/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import io.hops.TestUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDFSPermission {
    public static final Log LOG = LogFactory.getLog(TestDFSPermission.class);
    private static final Configuration conf = new HdfsConfiguration();
    private static final String GROUP1_NAME = "group1";
    private static final String GROUP2_NAME = "group2";
    private static final String GROUP3_NAME = "group3";
    private static final String GROUP4_NAME = "group4";
    private static final String USER1_NAME = "user1";
    private static final String USER2_NAME = "user2";
    private static final String USER3_NAME = "user3";
    private static UserGroupInformation SUPERUSER;
    private static UserGroupInformation USER1;
    private static UserGroupInformation USER2;
    private static UserGroupInformation USER3;
    private static final short MAX_PERMISSION = 511;
    private static final short DEFAULT_UMASK = 18;
    private static final FsPermission DEFAULT_PERMISSION;
    private static final int NUM_TEST_PERMISSIONS;
    private static final String PATH_NAME = "xx";
    private static final Path FILE_DIR_PATH;
    private static final Path NON_EXISTENT_PATH;
    private static final Path NON_EXISTENT_FILE;
    private FileSystem fs;
    private MiniDFSCluster cluster;
    private static Random r;
    private static final String ANCESTOR_NAME = "/ancestor";
    private static final String PARENT_NAME = "parent";
    private static final String FILE_NAME = "file";
    private static final String DIR_NAME = "dir";
    private static final String FILE_DIR_NAME = "filedir";
    private static final short SUPER_MASK = 0;
    private static final short READ_MASK = 292;
    private static final short WRITE_MASK = 146;
    private static final short SEARCH_MASK = 73;
    private static final short NULL_MASK = 0;
    private static final short OWNER_MASK = 448;
    private static final short GROUP_MASK = 56;
    private static final short OTHER_MASK = 7;
    private CreatePermissionVerifier createVerifier = new CreatePermissionVerifier();
    private OpenPermissionVerifier openVerifier = new OpenPermissionVerifier();
    private SetReplicationPermissionVerifier replicatorVerifier = new SetReplicationPermissionVerifier();
    private SetTimesPermissionVerifier timesVerifier = new SetTimesPermissionVerifier();
    private StatsPermissionVerifier statsVerifier = new StatsPermissionVerifier();
    ListPermissionVerifier listVerifier = new ListPermissionVerifier();
    RenamePermissionVerifier renameVerifier = new RenamePermissionVerifier();
    DeletePermissionVerifier fileDeletionVerifier = new DeletePermissionVerifier();
    DeleteDirPermissionVerifier dirDeletionVerifier = new DeleteDirPermissionVerifier();

    @Before
    public void setUp() throws IOException {
        this.cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
        this.cluster.waitActive();
        SUPERUSER = UserGroupInformation.getCurrentUser();
        USER1 = UserGroupInformation.createUserForTesting((String)USER1_NAME, (String[])new String[]{GROUP1_NAME, GROUP2_NAME});
        USER2 = UserGroupInformation.createUserForTesting((String)USER2_NAME, (String[])new String[]{GROUP2_NAME, GROUP3_NAME});
        USER3 = UserGroupInformation.createUserForTesting((String)USER3_NAME, (String[])new String[]{GROUP3_NAME, GROUP4_NAME});
    }

    @After
    public void tearDown() throws IOException {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test
    public void testAccessOwner() throws IOException, InterruptedException {
        FileSystem rootFs = FileSystem.get((Configuration)conf);
        Path p1 = new Path("/p1");
        rootFs.mkdirs(p1);
        rootFs.setOwner(p1, USER1_NAME, GROUP1_NAME);
        this.fs = (FileSystem)USER1.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

            @Override
            public FileSystem run() throws Exception {
                return FileSystem.get((Configuration)conf);
            }
        });
        this.fs.setPermission(p1, new FsPermission(292));
        this.fs.access(p1, FsAction.READ);
        long inodeId = TestUtil.getINodeId(this.cluster.getNameNode(), p1);
        try {
            this.fs.access(p1, FsAction.WRITE);
            Assert.fail((String)"The access call should have failed.");
        }
        catch (AccessControlException e) {
            Assert.assertTrue((String)"Permission denied messages must carry the username", (boolean)e.getMessage().contains(USER1_NAME));
            Assert.assertTrue((String)"Permission denied messages must carry the inode id", (boolean)e.getMessage().contains(String.valueOf(inodeId)));
        }
        Path badPath = new Path("/bad/bad");
        try {
            this.fs.access(badPath, FsAction.READ);
            Assert.fail((String)"The access call should have failed");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testAccessGroupMember() throws IOException, InterruptedException {
        FileSystem rootFs = FileSystem.get((Configuration)conf);
        Path p2 = new Path("/p2");
        rootFs.mkdirs(p2);
        rootFs.setOwner(p2, UserGroupInformation.getCurrentUser().getShortUserName(), GROUP1_NAME);
        rootFs.setPermission(p2, new FsPermission(480));
        this.fs = (FileSystem)USER1.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

            @Override
            public FileSystem run() throws Exception {
                return FileSystem.get((Configuration)conf);
            }
        });
        long inodeId = TestUtil.getINodeId(this.cluster.getNameNode(), p2);
        this.fs.access(p2, FsAction.READ);
        try {
            this.fs.access(p2, FsAction.EXECUTE);
            Assert.fail((String)"The access call should have failed.");
        }
        catch (AccessControlException e) {
            Assert.assertTrue((String)"Permission denied messages must carry the username", (boolean)e.getMessage().contains(USER1_NAME));
            Assert.assertTrue((String)"Permission denied messages must carry the inode path", (boolean)e.getMessage().contains(String.valueOf("p2")));
        }
    }

    @Test
    public void testAccessOthers() throws IOException, InterruptedException {
        FileSystem rootFs = FileSystem.get((Configuration)conf);
        Path p3 = new Path("/p3");
        rootFs.mkdirs(p3);
        rootFs.setPermission(p3, new FsPermission(508));
        this.fs = (FileSystem)USER1.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

            @Override
            public FileSystem run() throws Exception {
                return FileSystem.get((Configuration)conf);
            }
        });
        long inodeId = TestUtil.getINodeId(this.cluster.getNameNode(), p3);
        this.fs.access(p3, FsAction.READ);
        try {
            this.fs.access(p3, FsAction.READ_WRITE);
            Assert.fail((String)"The access call should have failed.");
        }
        catch (AccessControlException e) {
            Assert.assertTrue((String)"Permission denied messages must carry the username", (boolean)e.getMessage().contains(USER1_NAME));
            Assert.assertTrue((String)"Permission denied messages must carry the inode id", (boolean)e.getMessage().contains(String.valueOf(inodeId)));
        }
    }

    @Test
    public void testPermissionSetting() throws Exception {
        this.testPermissionSetting(OpType.CREATE);
        this.testPermissionSetting(OpType.MKDIRS);
    }

    private void initFileSystem(short umask) throws Exception {
        conf.set("fs.permissions.umask-mode", String.format("%1$03o", umask));
        this.fs = FileSystem.get((Configuration)conf);
    }

    private void closeFileSystem() throws Exception {
        this.fs.close();
    }

    private void testPermissionSetting(OpType op) throws Exception {
        short uMask = 18;
        PermissionGenerator generator = new PermissionGenerator(r);
        FsPermission permission = new FsPermission(DEFAULT_PERMISSION);
        for (int i = 0; i < NUM_TEST_PERMISSIONS; i = (int)((short)(i + 1))) {
            uMask = generator.next();
            this.initFileSystem(uMask);
            this.createAndCheckPermission(op, FILE_DIR_PATH, uMask, permission, true);
            this.closeFileSystem();
        }
        uMask = 18;
        this.initFileSystem(uMask);
        this.createAndCheckPermission(op, FILE_DIR_PATH, uMask, new FsPermission(419), true);
        this.closeFileSystem();
        uMask = 146;
        this.initFileSystem(uMask);
        this.createAndCheckPermission(op, FILE_DIR_PATH, uMask, new FsPermission(419), false);
        this.closeFileSystem();
        uMask = 73;
        this.initFileSystem(uMask);
        this.fs.setPermission(FILE_DIR_PATH, new FsPermission(uMask));
        short expectedPermission = 73;
        this.checkPermission(FILE_DIR_PATH, expectedPermission, true);
        this.closeFileSystem();
        uMask = 18;
        this.initFileSystem(uMask);
        Assert.assertFalse((String)"File shouldn't exists", (boolean)this.fs.exists(NON_EXISTENT_PATH));
        this.createAndCheckPermission(op, NON_EXISTENT_PATH, uMask, new FsPermission(DEFAULT_PERMISSION), false);
        Path parent = NON_EXISTENT_PATH.getParent();
        this.checkPermission(parent, this.getPermission(parent.getParent()), true);
        this.closeFileSystem();
    }

    private short getPermission(Path path) throws IOException {
        return this.fs.getFileStatus(path).getPermission().toShort();
    }

    private void create(OpType op, Path name) throws IOException {
        this.create(op, name, (short)18, new FsPermission(DEFAULT_PERMISSION));
    }

    private void create(OpType op, Path name, short umask, FsPermission permission) throws IOException {
        conf.set("fs.permissions.umask-mode", String.format("%1$03o", umask));
        switch (op) {
            case CREATE: {
                FSDataOutputStream out = this.fs.create(name, permission, true, conf.getInt("io.file.buffer.size", 4096), this.fs.getDefaultReplication(name), this.fs.getDefaultBlockSize(name), null);
                out.close();
                break;
            }
            case MKDIRS: {
                this.fs.mkdirs(name, permission);
                break;
            }
            default: {
                throw new IOException("Unsupported operation: " + (Object)((Object)op));
            }
        }
    }

    private void createAndCheckPermission(OpType op, Path name, short umask, FsPermission permission, boolean delete) throws Exception {
        this.create(op, name, umask, permission);
        int permissionNum = DEFAULT_PERMISSION.equals((Object)permission) ? 511 : (int)permission.toShort();
        short expectedPermission = op == OpType.CREATE ? (short)(~umask & permissionNum) : (short)(~umask & permissionNum);
        this.checkPermission(name, expectedPermission, delete);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPermission(Path name, short expectedPermission, boolean delete) throws IOException {
        try {
            Assert.assertEquals((long)this.getPermission(name), (long)expectedPermission);
        }
        finally {
            if (delete) {
                this.fs.delete(name, true);
            }
        }
    }

    @Test
    public void testImmutableFsPermission() throws IOException {
        this.fs = FileSystem.get((Configuration)conf);
        this.fs.setPermission(new Path("/"), FsPermission.createImmutable((short)511));
    }

    @Test
    public void testOwnership() throws Exception {
        this.testOwnership(OpType.CREATE);
        this.testOwnership(OpType.MKDIRS);
    }

    private void setOwner(Path path, String owner, String group, boolean expectDeny) throws IOException {
        try {
            String expectedOwner = owner == null ? this.getOwner(path) : owner;
            String expectedGroup = group == null ? this.getGroup(path) : group;
            this.fs.setOwner(path, owner, group);
            this.checkOwnership(path, expectedOwner, expectedGroup);
            Assert.assertFalse((boolean)expectDeny);
        }
        catch (AccessControlException e) {
            Assert.assertTrue((boolean)expectDeny);
        }
    }

    private void testOwnership(OpType op) throws Exception {
        this.fs = FileSystem.get((Configuration)conf);
        this.create(op, FILE_DIR_PATH, (short)18, new FsPermission(DEFAULT_PERMISSION));
        this.checkOwnership(FILE_DIR_PATH, SUPERUSER.getShortUserName(), this.getGroup(FILE_DIR_PATH.getParent()));
        this.setOwner(FILE_DIR_PATH, USER1.getShortUserName(), GROUP3_NAME, false);
        this.login(USER1);
        this.setOwner(FILE_DIR_PATH, USER2.getShortUserName(), null, true);
        this.setOwner(FILE_DIR_PATH, null, GROUP1_NAME, false);
        this.setOwner(FILE_DIR_PATH, null, GROUP3_NAME, true);
        this.login(USER2);
        this.setOwner(FILE_DIR_PATH, null, GROUP3_NAME, true);
        this.setOwner(FILE_DIR_PATH, USER2.getShortUserName(), null, true);
        this.login(SUPERUSER);
        this.fs.delete(FILE_DIR_PATH, true);
    }

    private String getGroup(Path path) throws IOException {
        return this.fs.getFileStatus(path).getGroup();
    }

    private String getOwner(Path path) throws IOException {
        return this.fs.getFileStatus(path).getOwner();
    }

    private void checkOwnership(Path name, String expectedOwner, String expectedGroup) throws IOException {
        FileStatus status = this.fs.getFileStatus(name);
        Assert.assertEquals((Object)status.getOwner(), (Object)expectedOwner);
        Assert.assertEquals((Object)status.getGroup(), (Object)expectedGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPermissionChecking() throws Exception {
        try {
            this.fs = FileSystem.get((Configuration)conf);
            this.fs.setPermission(new Path("/"), new FsPermission(511));
            PermissionGenerator ancestorPermissionGenerator = new PermissionGenerator(r);
            PermissionGenerator dirPermissionGenerator = new PermissionGenerator(r);
            PermissionGenerator filePermissionGenerator = new PermissionGenerator(r);
            short[] ancestorPermissions = new short[NUM_TEST_PERMISSIONS];
            short[] parentPermissions = new short[NUM_TEST_PERMISSIONS];
            short[] permissions = new short[NUM_TEST_PERMISSIONS];
            Path[] ancestorPaths = new Path[NUM_TEST_PERMISSIONS];
            Path[] parentPaths = new Path[NUM_TEST_PERMISSIONS];
            Path[] filePaths = new Path[NUM_TEST_PERMISSIONS];
            Path[] dirPaths = new Path[NUM_TEST_PERMISSIONS];
            for (int i = 0; i < NUM_TEST_PERMISSIONS; ++i) {
                ancestorPaths[i] = new Path(ANCESTOR_NAME + i);
                this.create(OpType.MKDIRS, ancestorPaths[i]);
                this.fs.setOwner(ancestorPaths[i], USER1_NAME, GROUP2_NAME);
                parentPaths[i] = new Path(ancestorPaths[i], PARENT_NAME + i);
                this.create(OpType.MKDIRS, parentPaths[i]);
                this.fs.setOwner(parentPaths[i], USER1_NAME, GROUP2_NAME);
                filePaths[i] = new Path(parentPaths[i], FILE_NAME + i);
                dirPaths[i] = new Path(parentPaths[i], DIR_NAME + i);
                ancestorPermissions[i] = ancestorPermissionGenerator.next();
                parentPermissions[i] = dirPermissionGenerator.next();
                permissions[i] = filePermissionGenerator.next();
                this.fs.setPermission(ancestorPaths[i], new FsPermission(ancestorPermissions[i]));
                this.fs.setPermission(parentPaths[i], new FsPermission(parentPermissions[i]));
            }
            this.testPermissionCheckingPerUser(USER1, ancestorPermissions, parentPermissions, permissions, parentPaths, filePaths, dirPaths);
            this.testPermissionCheckingPerUser(USER2, ancestorPermissions, parentPermissions, permissions, parentPaths, filePaths, dirPaths);
            this.testPermissionCheckingPerUser(USER3, ancestorPermissions, parentPermissions, permissions, parentPaths, filePaths, dirPaths);
            this.testPermissionCheckingPerUser(SUPERUSER, ancestorPermissions, parentPermissions, permissions, parentPaths, filePaths, dirPaths);
        }
        finally {
            this.fs.close();
        }
    }

    private void testPermissionCheckingPerUser(UserGroupInformation ugi, short[] ancestorPermission, short[] parentPermission, short[] filePermission, Path[] parentDirs, Path[] files, Path[] dirs) throws Exception {
        int i;
        this.login(SUPERUSER);
        for (i = 0; i < NUM_TEST_PERMISSIONS; ++i) {
            this.create(OpType.CREATE, files[i]);
            this.create(OpType.MKDIRS, dirs[i]);
            this.fs.setOwner(files[i], USER1_NAME, GROUP2_NAME);
            this.fs.setOwner(dirs[i], USER1_NAME, GROUP2_NAME);
            this.checkOwnership(dirs[i], USER1_NAME, GROUP2_NAME);
            this.checkOwnership(files[i], USER1_NAME, GROUP2_NAME);
            FsPermission fsPermission = new FsPermission(filePermission[i]);
            this.fs.setPermission(files[i], fsPermission);
            this.fs.setPermission(dirs[i], fsPermission);
        }
        this.login(ugi);
        for (i = 0; i < NUM_TEST_PERMISSIONS; ++i) {
            this.testCreateMkdirs(ugi, new Path(parentDirs[i], FILE_DIR_NAME), ancestorPermission[i], parentPermission[i]);
            this.testOpen(ugi, files[i], ancestorPermission[i], parentPermission[i], filePermission[i]);
            this.testSetReplication(ugi, files[i], ancestorPermission[i], parentPermission[i], filePermission[i]);
            this.testSetTimes(ugi, files[i], ancestorPermission[i], parentPermission[i], filePermission[i]);
            this.testStats(ugi, files[i], ancestorPermission[i], parentPermission[i]);
            this.testList(ugi, files[i], dirs[i], ancestorPermission[i], parentPermission[i], filePermission[i]);
            int next = i == NUM_TEST_PERMISSIONS - 1 ? 0 : i + 1;
            this.testRename(ugi, files[i], files[next], ancestorPermission[i], parentPermission[i], ancestorPermission[next], parentPermission[next]);
            this.testDeleteFile(ugi, files[i], ancestorPermission[i], parentPermission[i]);
            this.testDeleteDir(ugi, dirs[i], ancestorPermission[i], parentPermission[i], filePermission[i], null);
        }
        this.checkNonExistentFile();
    }

    private void testCreateMkdirs(UserGroupInformation ugi, Path path, short ancestorPermission, short parentPermission) throws Exception {
        this.createVerifier.set(path, OpType.MKDIRS, ancestorPermission, parentPermission);
        this.createVerifier.verifyPermission(ugi);
        this.createVerifier.setOpType(OpType.CREATE);
        this.createVerifier.setCleanup(false);
        this.createVerifier.verifyPermission(ugi);
        this.createVerifier.setCleanup(true);
        this.createVerifier.verifyPermission(ugi);
    }

    private void testOpen(UserGroupInformation ugi, Path path, short ancestorPermission, short parentPermission, short filePermission) throws Exception {
        this.openVerifier.set(path, ancestorPermission, parentPermission, filePermission);
        this.openVerifier.verifyPermission(ugi);
    }

    private void testSetReplication(UserGroupInformation ugi, Path path, short ancestorPermission, short parentPermission, short filePermission) throws Exception {
        this.replicatorVerifier.set(path, ancestorPermission, parentPermission, filePermission);
        this.replicatorVerifier.verifyPermission(ugi);
    }

    private void testSetTimes(UserGroupInformation ugi, Path path, short ancestorPermission, short parentPermission, short filePermission) throws Exception {
        this.timesVerifier.set(path, ancestorPermission, parentPermission, filePermission);
        this.timesVerifier.verifyPermission(ugi);
    }

    private void testStats(UserGroupInformation ugi, Path path, short ancestorPermission, short parentPermission) throws Exception {
        this.statsVerifier.set(path, OpType.GET_FILEINFO, ancestorPermission, parentPermission);
        this.statsVerifier.verifyPermission(ugi);
        this.statsVerifier.setOpType(OpType.IS_DIR);
        this.statsVerifier.verifyPermission(ugi);
        this.statsVerifier.setOpType(OpType.EXISTS);
        this.statsVerifier.verifyPermission(ugi);
        this.statsVerifier.setOpType(OpType.GET_CONTENT_LENGTH);
        this.statsVerifier.verifyPermission(ugi);
    }

    private void testList(UserGroupInformation ugi, Path file, Path dir, short ancestorPermission, short parentPermission, short filePermission) throws Exception {
        this.listVerifier.set(file, InodeType.FILE, ancestorPermission, parentPermission, filePermission);
        this.listVerifier.verifyPermission(ugi);
        this.listVerifier.setInodeType(dir, InodeType.DIR);
        this.listVerifier.verifyPermission(ugi);
    }

    private void testRename(UserGroupInformation ugi, Path src, Path dst, short srcAncestorPermission, short srcParentPermission, short dstAncestorPermission, short dstParentPermission) throws Exception {
        this.renameVerifier.set(src, srcAncestorPermission, srcParentPermission, dst, dstAncestorPermission, dstParentPermission);
        this.renameVerifier.verifyPermission(ugi);
    }

    private void testDeleteFile(UserGroupInformation ugi, Path file, short ancestorPermission, short parentPermission) throws Exception {
        this.fileDeletionVerifier.set(file, ancestorPermission, parentPermission);
        this.fileDeletionVerifier.verifyPermission(ugi);
    }

    private void testDeleteDir(UserGroupInformation ugi, Path path, short ancestorPermission, short parentPermission, short permission, short[] childPermissions) throws Exception {
        this.dirDeletionVerifier.set(path, ancestorPermission, parentPermission, permission, childPermissions);
        this.dirDeletionVerifier.verifyPermission(ugi);
    }

    private void login(UserGroupInformation ugi) throws IOException, InterruptedException {
        if (this.fs != null) {
            this.fs.close();
        }
        this.fs = DFSTestUtil.getFileSystemAs(ugi, conf);
    }

    private void checkNonExistentFile() {
        try {
            Assert.assertFalse((boolean)this.fs.exists(NON_EXISTENT_FILE));
        }
        catch (IOException e) {
            this.checkNoPermissionDeny(e);
        }
        try {
            this.fs.open(NON_EXISTENT_FILE);
        }
        catch (IOException e) {
            this.checkNoPermissionDeny(e);
        }
        try {
            this.fs.setReplication(NON_EXISTENT_FILE, (short)4);
        }
        catch (IOException e) {
            this.checkNoPermissionDeny(e);
        }
        try {
            this.fs.getFileStatus(NON_EXISTENT_FILE);
        }
        catch (IOException e) {
            this.checkNoPermissionDeny(e);
        }
        try {
            this.fs.getContentSummary(NON_EXISTENT_FILE).getLength();
        }
        catch (IOException e) {
            this.checkNoPermissionDeny(e);
        }
        try {
            this.fs.listStatus(NON_EXISTENT_FILE);
        }
        catch (IOException e) {
            this.checkNoPermissionDeny(e);
        }
        try {
            this.fs.delete(NON_EXISTENT_FILE, true);
        }
        catch (IOException e) {
            this.checkNoPermissionDeny(e);
        }
        try {
            this.fs.rename(NON_EXISTENT_FILE, new Path(NON_EXISTENT_FILE + ".txt"));
        }
        catch (IOException e) {
            this.checkNoPermissionDeny(e);
        }
    }

    private void checkNoPermissionDeny(IOException e) {
        Assert.assertFalse((boolean)(e instanceof AccessControlException));
    }

    static {
        DEFAULT_PERMISSION = FsPermission.createImmutable((short)511);
        NUM_TEST_PERMISSIONS = conf.getInt("test.dfs.permission.num", 10) * 512 / 100;
        FILE_DIR_PATH = new Path("/", PATH_NAME);
        NON_EXISTENT_PATH = new Path("/parent", PATH_NAME);
        NON_EXISTENT_FILE = new Path("/NonExistentFile");
        long seed = Time.now();
        r = new Random(seed);
        LOG.info((Object)("Random number generator uses seed " + seed));
        LOG.info((Object)("NUM_TEST_PERMISSIONS=" + NUM_TEST_PERMISSIONS));
        conf.setBoolean("dfs.permissions.enabled", true);
        HashMap<String, String[]> u2g_map = new HashMap<String, String[]>(3);
        u2g_map.put(USER1_NAME, new String[]{GROUP1_NAME, GROUP2_NAME});
        u2g_map.put(USER2_NAME, new String[]{GROUP2_NAME, GROUP3_NAME});
        u2g_map.put(USER3_NAME, new String[]{GROUP3_NAME, GROUP4_NAME});
        DFSTestUtil.updateConfWithFakeGroupMapping(conf, u2g_map);
    }

    private class DeleteDirPermissionVerifier
    extends DeletePermissionVerifier {
        private short[] childPermissions;

        private DeleteDirPermissionVerifier() {
        }

        void set(Path path, short ancestorPermission, short parentPermission, short permission, short[] childPermissions) {
            this.set(path, ancestorPermission, parentPermission, permission);
            this.childPermissions = childPermissions;
        }

        @Override
        void setOpPermission() {
            this.opParentPermission = (short)219;
            this.opPermission = (short)511;
        }

        @Override
        protected boolean expectPermissionDeny() {
            if (super.expectPermissionDeny()) {
                return true;
            }
            if (this.childPermissions != null) {
                for (short childPermission : this.childPermissions) {
                    if ((this.requiredPermission & childPermission) == this.requiredPermission) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private class DeletePermissionVerifier
    extends PermissionVerifier {
        private DeletePermissionVerifier() {
        }

        void set(Path path, short ancestorPermission, short parentPermission) {
            super.set(path, ancestorPermission, parentPermission, (short)0);
        }

        @Override
        void setOpPermission() {
            this.opParentPermission = (short)219;
        }

        @Override
        void call() throws IOException {
            TestDFSPermission.this.fs.delete(this.path, true);
        }
    }

    private class RenamePermissionVerifier
    extends PermissionVerifier {
        private Path dst;
        private short dstAncestorPermission;
        private short dstParentPermission;

        private RenamePermissionVerifier() {
        }

        void set(Path src, short srcAncestorPermission, short srcParentPermission, Path dst, short dstAncestorPermission, short dstParentPermission) {
            super.set(src, srcAncestorPermission, srcParentPermission, (short)0);
            this.dst = dst;
            this.dstAncestorPermission = dstAncestorPermission;
            this.dstParentPermission = dstParentPermission;
        }

        @Override
        void setOpPermission() {
            this.opParentPermission = (short)219;
        }

        @Override
        void call() throws IOException {
            TestDFSPermission.this.fs.rename(this.path, this.dst);
        }

        @Override
        protected boolean expectPermissionDeny() {
            return super.expectPermissionDeny() || (this.requiredParentPermission & this.dstParentPermission) != this.requiredParentPermission || (this.requiredAncestorPermission & this.dstAncestorPermission) != this.requiredAncestorPermission;
        }

        @Override
        protected void logPermissions() {
            super.logPermissions();
            LOG.info((Object)("dst ancestor permission: " + Integer.toOctalString(this.dstAncestorPermission)));
            LOG.info((Object)("dst parent permission: " + Integer.toOctalString(this.dstParentPermission)));
        }
    }

    private class ListPermissionVerifier
    extends PermissionVerifier {
        private InodeType inodeType;

        private ListPermissionVerifier() {
        }

        void set(Path path, InodeType inodeType, short ancestorPermission, short parentPermission, short permission) {
            this.inodeType = inodeType;
            super.set(path, ancestorPermission, parentPermission, permission);
        }

        void setInodeType(Path path, InodeType inodeType) {
            this.path = path;
            this.inodeType = inodeType;
            this.setOpPermission();
            this.ugi = null;
        }

        @Override
        void setOpPermission() {
            this.opParentPermission = (short)73;
            switch (this.inodeType) {
                case FILE: {
                    this.opPermission = 0;
                    break;
                }
                case DIR: {
                    this.opPermission = (short)365;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal inode type: " + (Object)((Object)this.inodeType));
                }
            }
        }

        @Override
        void call() throws IOException {
            TestDFSPermission.this.fs.listStatus(this.path);
        }
    }

    private static enum InodeType {
        FILE,
        DIR;

    }

    private class StatsPermissionVerifier
    extends PermissionVerifier {
        OpType opType;

        private StatsPermissionVerifier() {
        }

        void set(Path path, OpType opType, short ancestorPermission, short parentPermission) {
            super.set(path, ancestorPermission, parentPermission, (short)0);
            this.setOpType(opType);
        }

        void setOpType(OpType opType) {
            this.opType = opType;
        }

        @Override
        void setOpPermission() {
            this.opParentPermission = (short)73;
        }

        @Override
        void call() throws IOException {
            switch (this.opType) {
                case GET_FILEINFO: {
                    TestDFSPermission.this.fs.getFileStatus(this.path);
                    break;
                }
                case IS_DIR: {
                    TestDFSPermission.this.fs.isDirectory(this.path);
                    break;
                }
                case EXISTS: {
                    TestDFSPermission.this.fs.exists(this.path);
                    break;
                }
                case GET_CONTENT_LENGTH: {
                    TestDFSPermission.this.fs.getContentSummary(this.path).getLength();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected operation type: " + (Object)((Object)this.opType));
                }
            }
        }
    }

    private class SetTimesPermissionVerifier
    extends PermissionVerifier {
        private SetTimesPermissionVerifier() {
        }

        @Override
        void setOpPermission() {
            this.opParentPermission = (short)73;
            this.opPermission = (short)146;
        }

        @Override
        void call() throws IOException {
            TestDFSPermission.this.fs.setTimes(this.path, 100L, 100L);
            TestDFSPermission.this.fs.setTimes(this.path, -1L, 100L);
            TestDFSPermission.this.fs.setTimes(this.path, 100L, -1L);
        }
    }

    private class SetReplicationPermissionVerifier
    extends PermissionVerifier {
        private SetReplicationPermissionVerifier() {
        }

        @Override
        void setOpPermission() {
            this.opParentPermission = (short)73;
            this.opPermission = (short)146;
        }

        @Override
        void call() throws IOException {
            TestDFSPermission.this.fs.setReplication(this.path, (short)1);
        }
    }

    private class OpenPermissionVerifier
    extends PermissionVerifier {
        private OpenPermissionVerifier() {
        }

        @Override
        void setOpPermission() {
            this.opParentPermission = (short)73;
            this.opPermission = (short)292;
        }

        @Override
        void call() throws IOException {
            FSDataInputStream in = TestDFSPermission.this.fs.open(this.path);
            in.close();
        }
    }

    private class CreatePermissionVerifier
    extends PermissionVerifier {
        private OpType opType;
        private boolean cleanup;

        private CreatePermissionVerifier() {
            this.cleanup = true;
        }

        protected void set(Path path, OpType opType, short ancestorPermission, short parentPermission) {
            super.set(path, ancestorPermission, parentPermission, (short)0);
            this.setOpType(opType);
        }

        void setCleanup(boolean cleanup) {
            this.cleanup = cleanup;
        }

        void setOpType(OpType opType) {
            this.opType = opType;
        }

        @Override
        void setOpPermission() {
            this.opParentPermission = (short)219;
        }

        @Override
        void call() throws IOException {
            TestDFSPermission.this.create(this.opType, this.path);
            if (this.cleanup) {
                TestDFSPermission.this.fs.delete(this.path, true);
            }
        }
    }

    abstract class PermissionVerifier {
        protected Path path;
        protected short ancestorPermission;
        protected short parentPermission;
        private short permission;
        protected short requiredAncestorPermission;
        protected short requiredParentPermission;
        protected short requiredPermission;
        protected static final short opAncestorPermission = 73;
        protected short opParentPermission;
        protected short opPermission;
        protected UserGroupInformation ugi;

        PermissionVerifier() {
        }

        protected void set(Path path, short ancestorPermission, short parentPermission, short permission) {
            this.path = path;
            this.ancestorPermission = ancestorPermission;
            this.parentPermission = parentPermission;
            this.permission = permission;
            this.setOpPermission();
            this.ugi = null;
        }

        void verifyPermission(UserGroupInformation ugi) throws IOException {
            if (this.ugi != ugi) {
                this.setRequiredPermissions(ugi);
                this.ugi = ugi;
            }
            try {
                try {
                    this.call();
                    Assert.assertFalse((boolean)this.expectPermissionDeny());
                }
                catch (AccessControlException e) {
                    Assert.assertTrue((boolean)this.expectPermissionDeny());
                }
            }
            catch (AssertionError ae) {
                this.logPermissions();
                throw ae;
            }
        }

        protected void logPermissions() {
            LOG.info((Object)("required ancestor permission:" + Integer.toOctalString(this.requiredAncestorPermission)));
            LOG.info((Object)("ancestor permission: " + Integer.toOctalString(this.ancestorPermission)));
            LOG.info((Object)("required parent permission:" + Integer.toOctalString(this.requiredParentPermission)));
            LOG.info((Object)("parent permission: " + Integer.toOctalString(this.parentPermission)));
            LOG.info((Object)("required permission:" + Integer.toOctalString(this.requiredPermission)));
            LOG.info((Object)("permission: " + Integer.toOctalString(this.permission)));
        }

        protected boolean expectPermissionDeny() {
            return (this.requiredPermission & this.permission) != this.requiredPermission || (this.requiredParentPermission & this.parentPermission) != this.requiredParentPermission || (this.requiredAncestorPermission & this.ancestorPermission) != this.requiredAncestorPermission;
        }

        protected void setRequiredPermissions(UserGroupInformation ugi) {
            if (SUPERUSER.equals((Object)ugi)) {
                this.requiredAncestorPermission = 0;
                this.requiredParentPermission = 0;
                this.requiredPermission = 0;
            } else if (USER1.equals((Object)ugi)) {
                this.requiredAncestorPermission = (short)64;
                this.requiredParentPermission = (short)(this.opParentPermission & 0x1C0);
                this.requiredPermission = (short)(this.opPermission & 0x1C0);
            } else if (USER2.equals((Object)ugi)) {
                this.requiredAncestorPermission = (short)8;
                this.requiredParentPermission = (short)(this.opParentPermission & 0x38);
                this.requiredPermission = (short)(this.opPermission & 0x38);
            } else if (USER3.equals((Object)ugi)) {
                this.requiredAncestorPermission = 1;
                this.requiredParentPermission = (short)(this.opParentPermission & 7);
                this.requiredPermission = (short)(this.opPermission & 7);
            } else {
                throw new IllegalArgumentException("Non-supported user: " + ugi);
            }
        }

        abstract void setOpPermission();

        abstract void call() throws IOException;
    }

    private static class PermissionGenerator {
        private Random r;
        private short[] permissions = new short[512];
        private int numLeft = 512;

        PermissionGenerator(Random r) {
            this.r = r;
            for (int i = 0; i <= 511; ++i) {
                this.permissions[i] = (short)i;
            }
        }

        short next() throws IOException {
            if (this.numLeft == 0) {
                throw new IOException("No more permission is avaialbe");
            }
            int index = this.r.nextInt(this.numLeft);
            --this.numLeft;
            short temp = this.permissions[this.numLeft];
            this.permissions[this.numLeft] = this.permissions[index];
            this.permissions[index] = temp;
            return this.permissions[this.numLeft];
        }
    }

    private static enum OpType {
        CREATE,
        MKDIRS,
        OPEN,
        SET_REPLICATION,
        GET_FILEINFO,
        IS_DIR,
        EXISTS,
        GET_CONTENT_LENGTH,
        LIST,
        RENAME,
        DELETE;

    }
}

