/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDFSUtil {
    @Before
    public void resetUGI() {
        UserGroupInformation.setConfiguration((Configuration)new Configuration());
    }

    @Test
    public void testLocatedBlocks2Locations() {
        DatanodeInfo d = DFSTestUtil.getLocalDatanodeInfo();
        DatanodeInfo[] ds = new DatanodeInfo[]{d};
        ExtendedBlock b1 = new ExtendedBlock("bpid", 1L, 1L, 1L);
        LocatedBlock l1 = new LocatedBlock(b1, ds, 0L, false);
        ExtendedBlock b2 = new ExtendedBlock("bpid", 2L, 1L, 1L);
        LocatedBlock l2 = new LocatedBlock(b2, ds, 0L, true);
        List<LocatedBlock> ls = Arrays.asList(l1, l2);
        LocatedBlocks lbs = new LocatedBlocks(10L, false, ls, l2, true);
        BlockLocation[] bs = DFSUtil.locatedBlocks2Locations((LocatedBlocks)lbs);
        Assert.assertTrue((String)("expected 2 blocks but got " + bs.length), (bs.length == 2 ? 1 : 0) != 0);
        int corruptCount = 0;
        for (BlockLocation b : bs) {
            if (!b.isCorrupt()) continue;
            ++corruptCount;
        }
        Assert.assertTrue((String)("expected 1 corrupt files but got " + corruptCount), (corruptCount == 1 ? 1 : 0) != 0);
        bs = DFSUtil.locatedBlocks2Locations((LocatedBlocks)new LocatedBlocks());
        Assert.assertEquals((long)0L, (long)bs.length);
    }

    @Test
    public void testLocatedBlockConstructorWithNullCachedLocs() {
        DatanodeInfo d = DFSTestUtil.getLocalDatanodeInfo();
        DatanodeInfo[] ds = new DatanodeInfo[]{d};
        ExtendedBlock b1 = new ExtendedBlock("bpid", 1L, 1L, 1L);
        LocatedBlock l1 = new LocatedBlock(b1, ds, null, null, 0L, false, null);
        DatanodeInfo[] cachedLocs = l1.getCachedLocations();
        Assert.assertTrue((cachedLocs.length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetInfoServer() throws IOException, URISyntaxException {
        HdfsConfiguration conf = new HdfsConfiguration();
        URI httpsport = DFSUtil.getInfoServer(null, (Configuration)conf, (String)"https");
        Assert.assertEquals((Object)new URI("https", null, "0.0.0.0", 50470, null, null, null), (Object)httpsport);
        URI httpport = DFSUtil.getInfoServer(null, (Configuration)conf, (String)"http");
        Assert.assertEquals((Object)new URI("http", null, "0.0.0.0", 50070, null, null, null), (Object)httpport);
        URI httpAddress = DFSUtil.getInfoServer((InetSocketAddress)new InetSocketAddress("localhost", 8020), (Configuration)conf, (String)"http");
        Assert.assertEquals((Object)URI.create("http://localhost:50070"), (Object)httpAddress);
    }

    @Test
    public void testSubstituteForWildcardAddress() throws IOException {
        Assert.assertEquals((Object)"foo:12345", (Object)DFSUtil.substituteForWildcardAddress((String)"0.0.0.0:12345", (String)"foo"));
        Assert.assertEquals((Object)"127.0.0.1:12345", (Object)DFSUtil.substituteForWildcardAddress((String)"127.0.0.1:12345", (String)"foo"));
    }

    @Test(timeout=15000L)
    public void testIsValidName() {
        Assert.assertFalse((boolean)DFSUtil.isValidName((String)"/foo/../bar"));
        Assert.assertFalse((boolean)DFSUtil.isValidName((String)"/foo//bar"));
        Assert.assertTrue((boolean)DFSUtil.isValidName((String)"/"));
        Assert.assertTrue((boolean)DFSUtil.isValidName((String)"/bar/"));
    }

    @Test(timeout=5000L)
    public void testGetSpnegoKeytabKey() {
        HdfsConfiguration conf = new HdfsConfiguration();
        String defaultKey = "default.spengo.key";
        conf.unset("dfs.web.authentication.kerberos.keytab");
        Assert.assertEquals((String)"Test spnego key in config is null", (Object)defaultKey, (Object)DFSUtil.getSpnegoKeytabKey((Configuration)conf, (String)defaultKey));
        conf.set("dfs.web.authentication.kerberos.keytab", "");
        Assert.assertEquals((String)"Test spnego key is empty", (Object)defaultKey, (Object)DFSUtil.getSpnegoKeytabKey((Configuration)conf, (String)defaultKey));
        String spengoKey = "spengo.key";
        conf.set("dfs.web.authentication.kerberos.keytab", spengoKey);
        Assert.assertEquals((String)"Test spnego key is NOT null", (Object)"dfs.web.authentication.kerberos.keytab", (Object)DFSUtil.getSpnegoKeytabKey((Configuration)conf, (String)defaultKey));
    }

    @Test(timeout=1000L)
    public void testDurationToString() throws Exception {
        Assert.assertEquals((Object)"000:00:00:00.000", (Object)DFSUtil.durationToString((long)0L));
        Assert.assertEquals((Object)"001:01:01:01.000", (Object)DFSUtil.durationToString((long)90061000L));
        Assert.assertEquals((Object)"000:23:59:59.999", (Object)DFSUtil.durationToString((long)86399999L));
        Assert.assertEquals((Object)"-001:01:01:01.000", (Object)DFSUtil.durationToString((long)-90061000L));
        Assert.assertEquals((Object)"-000:23:59:59.574", (Object)DFSUtil.durationToString((long)-86399574L));
    }

    @Test(timeout=5000L)
    public void testRelativeTimeConversion() throws Exception {
        try {
            DFSUtil.parseRelativeTime((String)"1");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"too short", (Throwable)e);
        }
        try {
            DFSUtil.parseRelativeTime((String)"1z");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"unknown time unit", (Throwable)e);
        }
        try {
            DFSUtil.parseRelativeTime((String)"yyz");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"is not a number", (Throwable)e);
        }
        Assert.assertEquals((long)61000L, (long)DFSUtil.parseRelativeTime((String)"61s"));
        Assert.assertEquals((long)3660000L, (long)DFSUtil.parseRelativeTime((String)"61m"));
        Assert.assertEquals((long)0L, (long)DFSUtil.parseRelativeTime((String)"0s"));
        Assert.assertEquals((long)90000000L, (long)DFSUtil.parseRelativeTime((String)"25h"));
        Assert.assertEquals((long)345600000L, (long)DFSUtil.parseRelativeTime((String)"4d"));
        Assert.assertEquals((long)86313600000L, (long)DFSUtil.parseRelativeTime((String)"999d"));
    }
}

