/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.mover;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.StorageType;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.balancer.Dispatcher;
import org.apache.hadoop.hdfs.server.balancer.NameNodeConnector;
import org.apache.hadoop.hdfs.server.mover.Mover;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestMover {
    static Mover newMover(Configuration conf) throws IOException, URISyntaxException {
        List namenodes = DFSUtil.getNsServiceRpcUris((Configuration)conf);
        Assert.assertEquals((long)1L, (long)namenodes.size());
        List nncs = NameNodeConnector.newNameNodeConnectors((Collection)namenodes, (String)Mover.class.getSimpleName(), (Path)Mover.MOVER_ID_PATH, (Configuration)conf);
        return new Mover((NameNodeConnector)nncs.get(0), conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScheduleSameBlock() throws IOException, URISyntaxException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(4).build();
        try {
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            String file = "/testScheduleSameBlock/file";
            FSDataOutputStream out = dfs.create(new Path("/testScheduleSameBlock/file"));
            out.writeChars("testScheduleSameBlock");
            out.close();
            Mover mover = TestMover.newMover((Configuration)conf);
            mover.init();
            Mover.Processor processor = new Mover.Processor(mover);
            LocatedBlock lb = dfs.getClient().getLocatedBlocks("/testScheduleSameBlock/file", 0L).get(0);
            List locations = Mover.MLocation.toLocations((LocatedBlock)lb);
            Mover.MLocation ml = (Mover.MLocation)locations.get(0);
            Dispatcher.DBlock db = mover.newDBlock(lb.getBlock().getLocalBlock(), locations);
            ArrayList<StorageType> storageTypes = new ArrayList<StorageType>(Arrays.asList(StorageType.DEFAULT, StorageType.DEFAULT));
            Assert.assertTrue((boolean)processor.scheduleMoveReplica(db, ml, storageTypes));
            Assert.assertFalse((boolean)processor.scheduleMoveReplica(db, ml, storageTypes));
        }
        finally {
            cluster.shutdown();
        }
    }

    private void checkMovePaths(List<Path> actual, Path ... expected) {
        Assert.assertEquals((long)expected.length, (long)actual.size());
        for (Path p : expected) {
            Assert.assertTrue((boolean)actual.contains(p));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMoverCli() throws Exception {
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)new HdfsConfiguration()).numDataNodes(0).build();
        try {
            Configuration conf = cluster.getConfiguration(0);
            try {
                Mover.Cli.getNameNodePathsToMove((Configuration)conf, (String[])new String[]{"-p", "/foo", "bar"});
                Assert.fail((String)"Expected exception for illegal path bar");
            }
            catch (IllegalArgumentException e) {
                GenericTestUtils.assertExceptionContains((String)"bar is not absolute", (Throwable)e);
            }
            Map movePaths = Mover.Cli.getNameNodePathsToMove((Configuration)conf, (String[])new String[0]);
            List namenodes = DFSUtil.getNameNodesRPCAddressesAsURIs((Configuration)conf);
            Assert.assertEquals((long)1L, (long)namenodes.size());
            Assert.assertEquals((long)1L, (long)movePaths.size());
            URI nn = (URI)namenodes.iterator().next();
            Assert.assertTrue((boolean)movePaths.containsKey(nn));
            Assert.assertNull(movePaths.get(nn));
            movePaths = Mover.Cli.getNameNodePathsToMove((Configuration)conf, (String[])new String[]{"-p", "/foo", "/bar"});
            namenodes = DFSUtil.getNameNodesRPCAddressesAsURIs((Configuration)conf);
            Assert.assertEquals((long)1L, (long)movePaths.size());
            nn = (URI)namenodes.iterator().next();
            Assert.assertTrue((boolean)movePaths.containsKey(nn));
            this.checkMovePaths((List)movePaths.get(nn), new Path("/foo"), new Path("/bar"));
        }
        finally {
            cluster.shutdown();
        }
    }
}

