/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import io.hops.exception.StorageException;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.lock.INodeLock;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestFSDirectory {
    public static final Log LOG = LogFactory.getLog(TestFSDirectory.class);
    private static final long seed = 0L;
    private static final short REPLICATION = 3;
    private final Path dir = new Path("/" + this.getClass().getSimpleName());
    private final Path sub1 = new Path(this.dir, "sub1");
    private final Path file1 = new Path(this.sub1, "file1");
    private final Path file2 = new Path(this.sub1, "file2");
    private final Path sub11 = new Path(this.sub1, "sub11");
    private final Path file3 = new Path(this.sub11, "file3");
    private final Path file4 = new Path(this.sub1, "z_file4");
    private final Path file5 = new Path(this.sub1, "z_file5");
    private final Path sub2 = new Path(this.dir, "sub2");
    private Configuration conf;
    private MiniDFSCluster cluster;
    private FSNamesystem fsn;
    private FSDirectory fsdir;
    private DistributedFileSystem hdfs;

    @Before
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(3).build();
        this.cluster.waitActive();
        this.fsn = this.cluster.getNamesystem();
        this.fsdir = this.fsn.getFSDirectory();
        this.hdfs = this.cluster.getFileSystem();
        DFSTestUtil.createFile((FileSystem)this.hdfs, this.file1, 1024L, (short)3, 0L);
        DFSTestUtil.createFile((FileSystem)this.hdfs, this.file2, 1024L, (short)3, 0L);
        DFSTestUtil.createFile((FileSystem)this.hdfs, this.file3, 1024L, (short)3, 0L);
        DFSTestUtil.createFile((FileSystem)this.hdfs, this.file5, 1024L, (short)3, 0L);
        this.hdfs.mkdirs(this.sub2);
    }

    @After
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test
    public void testDumpTree() throws Exception {
        HopsTransactionalRequestHandler verifyFileBlocksHandler = new HopsTransactionalRequestHandler(HDFSOperationType.VERIFY_FILE_BLOCKS, this.dir.toString()){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE_ON_TARGET_AND_PARENT, TransactionLockTypes.INodeResolveType.PATH_AND_ALL_CHILDREN_RECURSIVELY, new String[]{TestFSDirectory.this.dir.toString()}).setNameNodeID(TestFSDirectory.this.cluster.getNameNode().getId()).setActiveNameNodes((Collection)TestFSDirectory.this.cluster.getNameNode().getActiveNameNodes().getActiveNodes());
                locks.add((Lock)il).add(lf.getLeaseLock(TransactionLockTypes.LockType.WRITE)).add(lf.getLeasePathLock(TransactionLockTypes.LockType.READ_COMMITTED)).add(lf.getBlockLock()).add(lf.getBlockRelated(new LockFactory.BLK[]{LockFactory.BLK.RE, LockFactory.BLK.CR, LockFactory.BLK.UC, LockFactory.BLK.UR, LockFactory.BLK.PE, LockFactory.BLK.IV}));
            }

            public Object performTask() throws StorageException, IOException {
                INode root = TestFSDirectory.this.fsdir.getINode(TestFSDirectory.this.dir.toString());
                LOG.info((Object)"Original tree");
                StringBuffer b1 = root.dumpTreeRecursively();
                System.out.println("b1=" + b1);
                BufferedReader in = new BufferedReader(new StringReader(b1.toString()));
                String line = in.readLine();
                TestFSDirectory.checkClassName(line);
                while ((line = in.readLine()) != null) {
                    Assert.assertTrue(((line = line.trim()).startsWith("\\-") || line.startsWith("+-") ? 1 : 0) != 0);
                    TestFSDirectory.checkClassName(line);
                }
                return b1;
            }
        };
        final StringBuffer b1 = (StringBuffer)verifyFileBlocksHandler.handle();
        LOG.info((Object)("Create a new file " + this.file4));
        DFSTestUtil.createFile((FileSystem)this.hdfs, this.file4, 1024L, (short)3, 0L);
        verifyFileBlocksHandler = new HopsTransactionalRequestHandler(HDFSOperationType.VERIFY_FILE_BLOCKS, this.dir.toString()){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE_ON_TARGET_AND_PARENT, TransactionLockTypes.INodeResolveType.PATH_AND_ALL_CHILDREN_RECURSIVELY, new String[]{TestFSDirectory.this.dir.toString()}).setNameNodeID(TestFSDirectory.this.cluster.getNameNode().getId()).setActiveNameNodes((Collection)TestFSDirectory.this.cluster.getNameNode().getActiveNameNodes().getActiveNodes());
                locks.add((Lock)il).add(lf.getLeaseLock(TransactionLockTypes.LockType.WRITE)).add(lf.getLeasePathLock(TransactionLockTypes.LockType.READ_COMMITTED)).add(lf.getBlockLock()).add(lf.getBlockRelated(new LockFactory.BLK[]{LockFactory.BLK.RE, LockFactory.BLK.CR, LockFactory.BLK.UC, LockFactory.BLK.UR, LockFactory.BLK.PE, LockFactory.BLK.IV}));
            }

            public Object performTask() throws StorageException, IOException {
                INode root = TestFSDirectory.this.fsdir.getINode(TestFSDirectory.this.dir.toString());
                StringBuffer b2 = root.dumpTreeRecursively();
                System.out.println("b2=" + b2);
                int i = 0;
                int j = b1.length() - 1;
                while (b1.charAt(i) == b2.charAt(i)) {
                    ++i;
                }
                int k = b2.length() - 1;
                while (b1.charAt(j) == b2.charAt(k)) {
                    --j;
                    --k;
                }
                String diff = b2.substring(i, k + 1);
                System.out.println("i=" + i + ", j=" + j + ", k=" + k);
                System.out.println("diff=" + diff);
                Assert.assertTrue((i > j ? 1 : 0) != 0);
                Assert.assertTrue((boolean)diff.contains(TestFSDirectory.this.file4.getName()));
                return null;
            }
        };
        verifyFileBlocksHandler.handle();
    }

    static void checkClassName(String line) {
        int j;
        int i = line.lastIndexOf(40);
        String classname = line.substring(i + 1, j = line.lastIndexOf(64));
        Assert.assertTrue((classname.equals(INodeFile.class.getSimpleName()) || classname.equals(INodeDirectory.class.getSimpleName()) ? 1 : 0) != 0);
    }
}

