/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import io.hops.exception.StorageException;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestFSNamesystem {
    @After
    public void cleanUp() {
        FileUtil.fullyDeleteContents((File)new File(MiniDFSCluster.getBaseDirectory()));
    }

    @Test
    public void testFSNamespaceClearLeases() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        NameNode.initMetrics((Configuration)conf, (HdfsServerConstants.NamenodeRole)HdfsServerConstants.NamenodeRole.NAMENODE);
        DFSTestUtil.formatNameNode((Configuration)conf);
        FSNamesystem fsn = FSNamesystem.loadFromDisk((Configuration)conf, null);
        LeaseManager leaseMan = fsn.getLeaseManager();
        this.addLease(leaseMan, "client1", "importantFile");
        Assert.assertEquals((long)1L, (long)leaseMan.countLease());
        fsn.clear();
        leaseMan = fsn.getLeaseManager();
        Assert.assertEquals((long)0L, (long)leaseMan.countLease());
    }

    private void addLease(final LeaseManager leaseMan, final String holder, final String src) throws IOException {
        new HopsTransactionalRequestHandler(HDFSOperationType.TEST){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getLeaseLock(TransactionLockTypes.LockType.WRITE, holder));
            }

            public Object performTask() throws StorageException, IOException {
                leaseMan.addLease(holder, src);
                return null;
            }
        }.handle();
    }

    @Test
    public void testStartupSafemode() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        NameNode.initMetrics((Configuration)conf, (HdfsServerConstants.NamenodeRole)HdfsServerConstants.NamenodeRole.NAMENODE);
        DFSTestUtil.formatNameNode((Configuration)conf);
        NameNode nameNode = (NameNode)Mockito.mock(NameNode.class);
        ((NameNode)Mockito.doReturn((Object)true).when((Object)nameNode)).isLeader();
        FSNamesystem fsn = FSNamesystem.loadFromDisk((Configuration)conf, (NameNode)nameNode);
        fsn.leaveSafeMode();
        Assert.assertTrue((String)"After leaving safemode FSNamesystem.isInStartupSafeMode still returned true", (!fsn.isInStartupSafeMode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"After leaving safemode FSNamesystem.isInSafeMode still returned true", (!fsn.isInSafeMode() ? 1 : 0) != 0);
        fsn.enterSafeMode(true);
        Assert.assertTrue((String)"After entering safemode due to low resources FSNamesystem.isInStartupSafeMode still returned true", (!fsn.isInStartupSafeMode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"After entering safemode due to low resources FSNamesystem.isInSafeMode still returned false", (boolean)fsn.isInSafeMode());
    }

    @Test
    public void testReplQueuesActiveAfterStartupSafemode() throws IOException, InterruptedException {
        HdfsConfiguration conf = new HdfsConfiguration();
        NameNode.initMetrics((Configuration)conf, (HdfsServerConstants.NamenodeRole)HdfsServerConstants.NamenodeRole.NAMENODE);
        DFSTestUtil.formatNameNode((Configuration)conf);
        NameNode nameNode = (NameNode)Mockito.mock(NameNode.class);
        ((NameNode)Mockito.doReturn((Object)true).when((Object)nameNode)).isLeader();
        FSNamesystem fsNamesystem = FSNamesystem.loadFromDisk((Configuration)conf, (NameNode)nameNode);
        FSNamesystem fsn = (FSNamesystem)Mockito.spy((Object)fsNamesystem);
        NameNode.initMetrics((Configuration)conf, (HdfsServerConstants.NamenodeRole)HdfsServerConstants.NamenodeRole.NAMENODE);
        fsn.enterSafeMode(false);
        Assert.assertTrue((String)"FSNamesystem didn't enter safemode", (boolean)fsn.isInSafeMode());
        Assert.assertTrue((String)"Replication queues were being populated during very first safemode", (!fsn.isPopulatingReplQueues() ? 1 : 0) != 0);
        fsn.leaveSafeMode();
        Assert.assertTrue((String)"FSNamesystem didn't leave safemode", (!fsn.isInSafeMode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Replication queues weren't being populated even after leaving safemode", (boolean)fsn.isPopulatingReplQueues());
        fsn.enterSafeMode(false);
        Assert.assertTrue((String)"FSNamesystem didn't enter safemode", (boolean)fsn.isInSafeMode());
        Assert.assertTrue((String)"Replication queues weren't being populated after entering safemode 2nd time", (boolean)fsn.isPopulatingReplQueues());
    }
}

