/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.net.NodeBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestNetworkTopology {
    private static final NetworkTopology cluster = new NetworkTopology();
    private DatanodeDescriptor[] dataNodes;

    @Before
    public void setupDatanodes() {
        for (DatanodeDescriptor dataNode : this.dataNodes = new DatanodeDescriptor[]{DFSTestUtil.getDatanodeDescriptor("1.1.1.1", "/d1/r1"), DFSTestUtil.getDatanodeDescriptor("2.2.2.2", "/d1/r1"), DFSTestUtil.getDatanodeDescriptor("3.3.3.3", "/d1/r2"), DFSTestUtil.getDatanodeDescriptor("4.4.4.4", "/d1/r2"), DFSTestUtil.getDatanodeDescriptor("5.5.5.5", "/d1/r2"), DFSTestUtil.getDatanodeDescriptor("6.6.6.6", "/d2/r3"), DFSTestUtil.getDatanodeDescriptor("7.7.7.7", "/d2/r3")}) {
            cluster.add((Node)dataNode);
        }
    }

    @Test
    public void testContains() throws Exception {
        DatanodeDescriptor nodeNotInMap = DFSTestUtil.getDatanodeDescriptor("8.8.8.8", "/d2/r4");
        for (DatanodeDescriptor dataNode : this.dataNodes) {
            Assert.assertTrue((boolean)cluster.contains((Node)dataNode));
        }
        Assert.assertFalse((boolean)cluster.contains((Node)nodeNotInMap));
    }

    @Test
    public void testNumOfChildren() throws Exception {
        Assert.assertEquals((long)cluster.getNumOfLeaves(), (long)this.dataNodes.length);
    }

    @Test
    public void testCreateInvalidTopology() throws Exception {
        NetworkTopology invalCluster = new NetworkTopology();
        DatanodeDescriptor[] invalDataNodes = new DatanodeDescriptor[]{DFSTestUtil.getDatanodeDescriptor("1.1.1.1", "/d1/r1"), DFSTestUtil.getDatanodeDescriptor("2.2.2.2", "/d1/r1"), DFSTestUtil.getDatanodeDescriptor("3.3.3.3", "/d1")};
        invalCluster.add((Node)invalDataNodes[0]);
        invalCluster.add((Node)invalDataNodes[1]);
        try {
            invalCluster.add((Node)invalDataNodes[2]);
            Assert.fail((String)"expected InvalidTopologyException");
        }
        catch (NetworkTopology.InvalidTopologyException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("You cannot have a rack and a non-rack node at the same level of the network topology."));
        }
    }

    @Test
    public void testRacks() throws Exception {
        Assert.assertEquals((long)cluster.getNumOfRacks(), (long)3L);
        Assert.assertTrue((boolean)cluster.isOnSameRack((Node)this.dataNodes[0], (Node)this.dataNodes[1]));
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)this.dataNodes[1], (Node)this.dataNodes[2]));
        Assert.assertTrue((boolean)cluster.isOnSameRack((Node)this.dataNodes[2], (Node)this.dataNodes[3]));
        Assert.assertTrue((boolean)cluster.isOnSameRack((Node)this.dataNodes[3], (Node)this.dataNodes[4]));
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)this.dataNodes[4], (Node)this.dataNodes[5]));
        Assert.assertTrue((boolean)cluster.isOnSameRack((Node)this.dataNodes[5], (Node)this.dataNodes[6]));
    }

    @Test
    public void testGetDistance() throws Exception {
        Assert.assertEquals((long)cluster.getDistance((Node)this.dataNodes[0], (Node)this.dataNodes[0]), (long)0L);
        Assert.assertEquals((long)cluster.getDistance((Node)this.dataNodes[0], (Node)this.dataNodes[1]), (long)2L);
        Assert.assertEquals((long)cluster.getDistance((Node)this.dataNodes[0], (Node)this.dataNodes[3]), (long)4L);
        Assert.assertEquals((long)cluster.getDistance((Node)this.dataNodes[0], (Node)this.dataNodes[6]), (long)6L);
    }

    @Test
    public void testPseudoSortByDistance() throws Exception {
        DatanodeDescriptor[] testNodes = new DatanodeDescriptor[]{this.dataNodes[1], this.dataNodes[2], this.dataNodes[0]};
        cluster.pseudoSortByDistance((Node)this.dataNodes[0], (Node[])testNodes);
        Assert.assertTrue((testNodes[0] == this.dataNodes[0] ? 1 : 0) != 0);
        Assert.assertTrue((testNodes[1] == this.dataNodes[1] ? 1 : 0) != 0);
        Assert.assertTrue((testNodes[2] == this.dataNodes[2] ? 1 : 0) != 0);
        testNodes[0] = this.dataNodes[1];
        testNodes[1] = this.dataNodes[3];
        testNodes[2] = this.dataNodes[0];
        cluster.pseudoSortByDistance((Node)this.dataNodes[0], (Node[])testNodes);
        Assert.assertTrue((testNodes[0] == this.dataNodes[0] ? 1 : 0) != 0);
        Assert.assertTrue((testNodes[1] == this.dataNodes[1] ? 1 : 0) != 0);
        Assert.assertTrue((testNodes[2] == this.dataNodes[3] ? 1 : 0) != 0);
        testNodes[0] = this.dataNodes[5];
        testNodes[1] = this.dataNodes[3];
        testNodes[2] = this.dataNodes[1];
        cluster.pseudoSortByDistance((Node)this.dataNodes[0], (Node[])testNodes);
        Assert.assertTrue((testNodes[0] == this.dataNodes[1] ? 1 : 0) != 0);
        Assert.assertTrue((testNodes[1] == this.dataNodes[3] ? 1 : 0) != 0);
        Assert.assertTrue((testNodes[2] == this.dataNodes[5] ? 1 : 0) != 0);
        testNodes[0] = this.dataNodes[1];
        testNodes[1] = this.dataNodes[5];
        testNodes[2] = this.dataNodes[3];
        cluster.pseudoSortByDistance((Node)this.dataNodes[0], (Node[])testNodes);
        Assert.assertTrue((testNodes[0] == this.dataNodes[1] ? 1 : 0) != 0);
        Assert.assertTrue((testNodes[1] == this.dataNodes[5] ? 1 : 0) != 0);
        Assert.assertTrue((testNodes[2] == this.dataNodes[3] ? 1 : 0) != 0);
    }

    @Test
    public void testRemove() throws Exception {
        for (DatanodeDescriptor dataNode2 : this.dataNodes) {
            cluster.remove((Node)dataNode2);
        }
        for (DatanodeDescriptor dataNode1 : this.dataNodes) {
            Assert.assertFalse((boolean)cluster.contains((Node)dataNode1));
        }
        Assert.assertEquals((long)0L, (long)cluster.getNumOfLeaves());
        for (DatanodeDescriptor dataNode : this.dataNodes) {
            cluster.add((Node)dataNode);
        }
    }

    private Map<Node, Integer> pickNodesAtRandom(int numNodes, String excludedScope) {
        HashMap<Node, Integer> frequency = new HashMap<Node, Integer>();
        for (DatanodeDescriptor dnd : this.dataNodes) {
            frequency.put((Node)dnd, 0);
        }
        for (int j = 0; j < numNodes; ++j) {
            Node random = cluster.chooseRandom(excludedScope);
            frequency.put(random, (Integer)frequency.get(random) + 1);
        }
        return frequency;
    }

    @Test
    public void testChooseRandomExcludedNode() {
        String scope = "~" + NodeBase.getPath((Node)this.dataNodes[0]);
        Map<Node, Integer> frequency = this.pickNodesAtRandom(100, scope);
        for (DatanodeDescriptor key : this.dataNodes) {
            Assert.assertTrue((frequency.get(key) > 0 || key == this.dataNodes[0] ? 1 : 0) != 0);
        }
    }

    @Test
    public void testChooseRandomExcludedRack() {
        Map<Node, Integer> frequency = this.pickNodesAtRandom(100, "~/d2");
        for (DatanodeDescriptor dataNode : this.dataNodes) {
            int freq = frequency.get(dataNode);
            if (dataNode.getNetworkLocation().startsWith("/d2")) {
                Assert.assertEquals((long)0L, (long)freq);
                continue;
            }
            Assert.assertTrue((freq > 0 ? 1 : 0) != 0);
        }
    }
}

