/*
 * Decompiled with CFR 0.152.
 */
package io.hops.resolvingcache;

import io.hops.resolvingcache.Memcache;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.internal.GetFuture;
import org.apache.hadoop.hdfs.server.namenode.INode;

public class INodeMemcache
extends Memcache {
    @Override
    protected void setInternal(MemcachedClient mc, String path, List<INode> inodes) {
        for (INode inode : inodes) {
            this.setInternal(mc, inode);
        }
    }

    @Override
    protected long[] getInternal(MemcachedClient mc, String path) throws IOException {
        String cmp;
        Long inodeId;
        int index;
        String[] pathComponents = INode.getPathNames(path);
        long[] inodeIds = new long[pathComponents.length];
        long parentId = 0L;
        for (index = 0; index < pathComponents.length && (inodeId = this.getInternal(mc, cmp = pathComponents[index], parentId)) != null; ++index) {
            parentId = inodeId;
            inodeIds[index] = inodeId;
        }
        if (index <= 1) {
            return null;
        }
        return Arrays.copyOf(inodeIds, index);
    }

    @Override
    protected void setInternal(MemcachedClient mc, INode inode) {
        INodeMemcache.setInternal(mc, this.keyPrefix, this.keyExpiry, inode);
    }

    @Override
    protected void deleteInternal(MemcachedClient mc, String path) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void deleteInternal(MemcachedClient mc, INode inode) {
        INodeMemcache.deleteInternal(mc, this.keyPrefix, inode);
    }

    private String getKey(INode inode) {
        return INodeMemcache.getKey(this.keyPrefix, inode);
    }

    private Long getInternal(MemcachedClient mc, String name, Long parentId) {
        return INodeMemcache.getInternal(mc, this.keyPrefix, name, parentId);
    }

    private static String getKey(String KEY_PREFIX, INode inode) {
        return KEY_PREFIX + inode.nameParentKey();
    }

    private static String getKey(String KEY_PREFIX, String name, Long parentId) {
        return KEY_PREFIX + INode.nameParentKey(parentId, name);
    }

    static Long getInternal(MemcachedClient mc, String KEY_PREFIX, String name, Long parentId) {
        Long inodeId = null;
        GetFuture f = mc.asyncGet(INodeMemcache.getKey(KEY_PREFIX, name, parentId));
        try {
            Object res = f.get(1L, TimeUnit.SECONDS);
            if (res instanceof Long) {
                inodeId = (Long)res;
            }
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            f.cancel(true);
        }
        return inodeId;
    }

    static void setInternal(MemcachedClient mc, String KEY_PREFIX, int KEY_EXPIRY, INode inode) {
        mc.set(INodeMemcache.getKey(KEY_PREFIX, inode), KEY_EXPIRY, (Object)inode.getId());
    }

    static void deleteInternal(MemcachedClient mc, String KEY_PREFIX, INode inode) {
        mc.delete(INodeMemcache.getKey(KEY_PREFIX, inode));
    }

    @Override
    protected int getRoundTrips(String path) {
        return INode.getPathNames(path).length;
    }

    @Override
    protected int getRoundTrips(List<INode> inodes) {
        return inodes.size();
    }
}

