/*
 * Decompiled with CFR 0.152.
 */
package io.hops.resolvingcache;

import io.hops.resolvingcache.Cache;
import io.hops.resolvingcache.MemcachedClientPool;
import java.io.IOException;
import java.util.List;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.internal.OperationCompletionListener;
import net.spy.memcached.internal.OperationFuture;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.namenode.INode;

public abstract class Memcache
extends Cache {
    private MemcachedClientPool mcpool;
    protected int keyExpiry;
    protected String keyPrefix;
    private int numberOfConnections;
    private String server;

    @Override
    protected void setConfiguration(Configuration conf) throws IOException {
        this.numberOfConnections = conf.getInt("dfs.resolvingcache.memcache.connectionpool.size", 10);
        this.server = conf.get("dfs.resolvingcache.memcache.server.address", "127.0.0.1:11212");
        this.keyExpiry = conf.getInt("dfs.resolvingcache.memcache.key.expiry", 0);
        this.keyPrefix = conf.get("dfs.resolvingcache.memcache.key.prefix", "p:");
        super.setConfiguration(conf);
    }

    @Override
    protected final void startInternal() throws IOException {
        this.mcpool = new MemcachedClientPool(this.numberOfConnections, this.server);
    }

    @Override
    protected final void stopInternal() {
        this.mcpool.shutdown();
    }

    @Override
    protected final void setInternal(String path, List<INode> inodes) {
        MemcachedClient mc = this.mcpool.poll();
        if (mc == null) {
            return;
        }
        this.setInternal(mc, path, inodes);
    }

    @Override
    protected void setInternal(INode inode) {
        MemcachedClient mc = this.mcpool.poll();
        if (mc == null) {
            return;
        }
        this.setInternal(mc, inode);
    }

    @Override
    protected final long[] getInternal(String path) throws IOException {
        MemcachedClient mc = this.mcpool.poll();
        if (mc == null) {
            return null;
        }
        return this.getInternal(mc, path);
    }

    @Override
    protected final void deleteInternal(String path) {
        MemcachedClient mc = this.mcpool.poll();
        if (mc == null) {
            return;
        }
        this.deleteInternal(mc, path);
    }

    @Override
    protected final void deleteInternal(INode inode) {
        MemcachedClient mc = this.mcpool.poll();
        if (mc == null) {
            return;
        }
        this.deleteInternal(mc, inode);
    }

    @Override
    protected final void flushInternal() {
        MemcachedClient mc = this.mcpool.poll();
        if (mc == null) {
            return;
        }
        mc.flush().addListener(new OperationCompletionListener(){

            public void onComplete(OperationFuture<?> f) throws Exception {
                Cache.LOG.debug((Object)"Memcache flushed");
            }
        });
    }

    protected abstract void setInternal(MemcachedClient var1, String var2, List<INode> var3);

    protected abstract void setInternal(MemcachedClient var1, INode var2);

    protected abstract long[] getInternal(MemcachedClient var1, String var2) throws IOException;

    protected abstract void deleteInternal(MemcachedClient var1, String var2);

    protected abstract void deleteInternal(MemcachedClient var1, INode var2);
}

