/*
 * Decompiled with CFR 0.152.
 */
package io.hops.resolvingcache;

import io.hops.resolvingcache.INodeMemcache;
import io.hops.resolvingcache.PathMemcache;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.spy.memcached.MemcachedClient;
import org.apache.hadoop.hdfs.server.namenode.INode;

public class OptimalMemcache
extends PathMemcache {
    @Override
    protected void setInternal(MemcachedClient mc, String path, List<INode> inodes) {
        if (INode.getPathNames(path).length != inodes.size()) {
            return;
        }
        int lastIndex = path.lastIndexOf("/");
        if (lastIndex <= 0) {
            return;
        }
        INode file = inodes.get(inodes.size() - 1);
        if (file.isDirectory()) {
            super.setInternal(mc, path, inodes);
            return;
        }
        String parentPath = path.substring(0, lastIndex);
        super.setInternal(mc, parentPath, inodes.subList(0, inodes.size() - 1));
        this.setInternal(mc, file);
    }

    @Override
    protected long[] getInternal(MemcachedClient mc, String path) throws IOException {
        long fileParentId;
        int lastIndex = path.lastIndexOf("/");
        if (lastIndex <= 0) {
            return null;
        }
        String parentPath = path.substring(0, lastIndex);
        long[] inodeIds = super.getInternal(mc, parentPath);
        if (inodeIds == null) {
            return null;
        }
        String file = path.substring(lastIndex + 1, path.length());
        Long fileInodeId = INodeMemcache.getInternal(mc, this.keyPrefix, file, fileParentId = inodeIds[inodeIds.length - 1]);
        if (fileInodeId != null) {
            inodeIds = Arrays.copyOf(inodeIds, inodeIds.length + 1);
            inodeIds[inodeIds.length - 1] = fileInodeId;
        }
        return inodeIds;
    }

    @Override
    protected void setInternal(MemcachedClient mc, INode inode) {
        INodeMemcache.setInternal(mc, this.keyPrefix, this.keyExpiry, inode);
    }

    @Override
    protected void deleteInternal(MemcachedClient mc, String path) {
        int lastIndex = path.lastIndexOf("/");
        if (lastIndex == -1) {
            return;
        }
        String parentPath = path.substring(0, lastIndex);
        super.deleteInternal(mc, parentPath);
    }

    @Override
    protected void deleteInternal(MemcachedClient mc, INode inode) {
        INodeMemcache.deleteInternal(mc, this.keyPrefix, inode);
    }

    @Override
    protected int getRoundTrips(String path) {
        return 2;
    }

    @Override
    protected int getRoundTrips(List<INode> inodes) {
        return 2;
    }
}

