/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.context;

import io.hops.exception.TransactionContextException;
import io.hops.metadata.hdfs.entity.INodeCandidatePrimaryKey;
import io.hops.transaction.context.BaseEntityContext;
import io.hops.transaction.context.BlockPK;
import io.hops.transaction.context.HdfsTransactionContextMaintenanceCmds;
import io.hops.transaction.context.TransactionContextMaintenanceCmds;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdfs.server.namenode.INode;

abstract class BaseReplicaContext<Key extends BlockPK, Entity>
extends BaseEntityContext<Key, Entity> {
    private Map<Long, Map<Key, Entity>> blocksToReplicas = new HashMap<Long, Map<Key, Entity>>();
    private Map<Long, Map<Key, Entity>> inodesToReplicas = new HashMap<Long, Map<Key, Entity>>();

    BaseReplicaContext() {
    }

    public void update(Entity entity) throws TransactionContextException {
        super.update(entity);
        this.addInternal(entity);
    }

    public void remove(Entity entity) throws TransactionContextException {
        super.remove(entity);
        BlockPK key = (BlockPK)this.getKey(entity);
        Map<Key, Entity> entityMap = this.blocksToReplicas.get(key.getBlockId());
        if (entityMap != null) {
            entityMap.remove(key);
        }
        if ((entityMap = this.inodesToReplicas.get(key.getInodeId())) != null) {
            entityMap.remove(key);
        }
    }

    public void clear() throws TransactionContextException {
        super.clear();
        this.blocksToReplicas.clear();
        this.inodesToReplicas.clear();
    }

    final void gotFromDB(Key entityKey, Entity entity) {
        super.gotFromDB(entityKey, entity);
        this.addInternal(entityKey, entity);
    }

    private void addInternal(Entity entity) {
        this.addInternal((BlockPK)this.getKey(entity), entity);
    }

    protected void addInternal(Key key, Entity entity) {
        Map<Key, Entity> entityMap;
        if (((BlockPK)key).hasBlockId()) {
            entityMap = this.blocksToReplicas.get(((BlockPK)key).getBlockId());
            if (entityMap == null) {
                entityMap = new HashMap<Key, Entity>();
                this.blocksToReplicas.put(((BlockPK)key).getBlockId(), entityMap);
            }
            entityMap.put(key, entity);
        }
        if (((BlockPK)key).hasINodeId()) {
            entityMap = this.inodesToReplicas.get(((BlockPK)key).getInodeId());
            if (entityMap == null) {
                entityMap = new HashMap<Key, Entity>();
                this.inodesToReplicas.put(((BlockPK)key).getInodeId(), entityMap);
            }
            entityMap.put(key, entity);
        }
    }

    final void gotFromDB(BlockPK key, List<Entity> entities) {
        Map<Key, Entity> entityMap;
        if (key.hasBlockId() && (entityMap = this.blocksToReplicas.get(key.getBlockId())) == null) {
            this.blocksToReplicas.put(key.getBlockId(), null);
        }
        if (key.hasINodeId() && (entityMap = this.inodesToReplicas.get(key.getInodeId())) == null) {
            this.inodesToReplicas.put(key.getInodeId(), null);
        }
        if (entities != null) {
            for (Entity entity : entities) {
                this.gotFromDB(entity);
            }
        }
    }

    final void gotFromDB(List<Key> keys, List<Entity> entities) {
        if (entities != null) {
            for (Object entity : entities) {
                BlockPK key = (BlockPK)this.getKey(entity);
                this.gotFromDB((Key)key, (Entity)entity);
                keys.remove(key);
            }
        }
        for (BlockPK key : keys) {
            this.gotFromDB((Key)key, (Entity)null);
        }
    }

    final boolean containsByBlock(long blockId) {
        return this.blocksToReplicas.containsKey(blockId);
    }

    final boolean containsByINode(long inodeId) {
        return this.inodesToReplicas.containsKey(inodeId);
    }

    final List<Entity> getByBlock(long blockId) {
        Map<Key, Entity> entityMap = this.blocksToReplicas.get(blockId);
        if (entityMap == null) {
            return null;
        }
        return new ArrayList<Entity>(entityMap.values());
    }

    final List<Entity> getByINode(long inodeId) {
        Map<Key, Entity> entityMap = this.inodesToReplicas.get(inodeId);
        if (entityMap == null) {
            return null;
        }
        return new ArrayList<Entity>(entityMap.values());
    }

    public final void snapshotMaintenance(TransactionContextMaintenanceCmds cmds, Object ... params) throws TransactionContextException {
        HdfsTransactionContextMaintenanceCmds hopCmds = (HdfsTransactionContextMaintenanceCmds)cmds;
        switch (hopCmds) {
            case INodePKChanged: {
                this.checkForSnapshotChange();
                INode inodeBeforeChange = (INode)params[0];
                INode inodeAfterChange = (INode)params[1];
                break;
            }
            case Concat: {
                this.checkForSnapshotChange();
                INodeCandidatePrimaryKey trg_param = (INodeCandidatePrimaryKey)params[0];
                List srcs_param = (List)params[1];
                List oldBlks = (List)params[2];
                this.updateReplicas(trg_param, srcs_param);
                break;
            }
            case BlockDoesNotExist: {
                this.blockDoesNotExist((Long)params[0], (Long)params[1]);
                break;
            }
            case EmptyFile: {
                this.emptyFile((Long)params[0]);
            }
        }
    }

    private void checkForSnapshotChange() {
        if (this.snapshotChanged()) {
            throw new IllegalStateException("No replica should have been changed during the Tx ( " + ((Object)((Object)this)).getClass() + ")");
        }
    }

    protected boolean snapshotChanged() {
        return !this.getAdded().isEmpty() || !this.getModified().isEmpty() || !this.getRemoved().isEmpty();
    }

    private void updateReplicas(INodeCandidatePrimaryKey trg_param, List<INodeCandidatePrimaryKey> toBeDeletedSrcs) throws TransactionContextException {
        toBeDeletedSrcs.remove(trg_param);
        for (INodeCandidatePrimaryKey src : toBeDeletedSrcs) {
            List<Entity> replicas = this.getByINode(src.getInodeId());
            if (replicas == null) continue;
            for (Entity replica : replicas) {
                Entity toBeDeleted = this.cloneEntity(replica);
                Entity toBeAdded = this.cloneEntity(replica, trg_param.getInodeId());
                BlockPK toBeDeletedKey = (BlockPK)this.getKey(toBeDeleted);
                BlockPK toBeAddedKey = (BlockPK)this.getKey(toBeAdded);
                this.remove(toBeDeleted);
                if (this.isLogDebugEnabled()) {
                    this.log("snapshot-maintenance-removed-replica", new Object[]{"bid", toBeDeletedKey.getBlockId(), "inodeId", toBeDeletedKey.getInodeId()});
                }
                this.add(toBeAdded);
                if (!this.isLogDebugEnabled()) continue;
                this.log("snapshot-maintenance-added-replica", new Object[]{"bid", toBeAddedKey.getBlockId(), "inodeId", toBeAddedKey.getInodeId()});
            }
        }
    }

    private void blockDoesNotExist(long blockId, long inodeId) {
        this.emptyFile(inodeId);
        if (!this.containsByBlock(blockId)) {
            this.blocksToReplicas.put(blockId, null);
        }
    }

    private void emptyFile(long inodeId) {
        if (!this.containsByINode(inodeId)) {
            this.inodesToReplicas.put(inodeId, null);
        }
    }

    abstract Entity cloneEntity(Entity var1);

    abstract Entity cloneEntity(Entity var1, long var2);
}

