/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.context;

import io.hops.exception.StorageCallPreventedException;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.dal.CacheDirectiveDataAccess;
import io.hops.transaction.context.BaseEntityContext;
import io.hops.transaction.lock.TransactionLocks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.hadoop.hdfs.protocol.CacheDirective;

public class CacheDirectiveContext
extends BaseEntityContext<Long, CacheDirective> {
    private CacheDirectiveDataAccess<CacheDirective> dataAccess;
    private Map<String, Collection<CacheDirective>> cacheDirectivesByPool = new HashMap<String, Collection<CacheDirective>>();
    private Map<Long, CacheDirective> cacheDirectivesById = new HashMap<Long, CacheDirective>();
    private boolean fetchedCacheDirectivesById = false;
    private Collection<CacheDirective> all = null;

    public CacheDirectiveContext(CacheDirectiveDataAccess dataAccess) {
        this.dataAccess = dataAccess;
    }

    public CacheDirective find(FinderType<CacheDirective> finder, Object ... params) throws TransactionContextException, StorageException {
        CacheDirective.Finder hbFinder = (CacheDirective.Finder)finder;
        switch (hbFinder) {
            case ById: {
                return this.findByPrimaryKey(hbFinder, params);
            }
        }
        throw new RuntimeException(UNSUPPORTED_FINDER);
    }

    public Collection<CacheDirective> findList(FinderType<CacheDirective> finder, Object ... params) throws TransactionContextException, StorageException {
        CacheDirective.Finder hbFinder = (CacheDirective.Finder)finder;
        switch (hbFinder) {
            case ByPoolName: {
                return this.findByPoolName(hbFinder, params);
            }
            case ByIdPoolAndPath: {
                return this.findByIdPoolAndPath(hbFinder, params);
            }
            case All: {
                return this.findAll(hbFinder, params);
            }
        }
        throw new RuntimeException(UNSUPPORTED_FINDER);
    }

    private CacheDirective findByPrimaryKey(CacheDirective.Finder hbFinder, Object[] params) throws StorageException, StorageCallPreventedException {
        CacheDirective result;
        long pk = (Long)params[0];
        if (this.contains(pk)) {
            result = (CacheDirective)this.get(pk);
            this.hit(hbFinder, result, new Object[]{"id", pk});
        } else {
            this.aboutToAccessStorage(hbFinder, params);
            result = (CacheDirective)this.dataAccess.find(pk);
            this.gotFromDB(pk, result);
            this.miss(hbFinder, result, new Object[]{"Id", pk});
        }
        return result;
    }

    private Collection<CacheDirective> findByPoolName(CacheDirective.Finder hbFinder, Object[] params) throws StorageCallPreventedException, StorageException {
        Collection results;
        String poolName = (String)params[0];
        if (this.cacheDirectivesByPool.containsKey(poolName)) {
            results = this.cacheDirectivesByPool.get(poolName);
            this.hit(hbFinder, results, new Object[]{"poolName", poolName});
        } else {
            this.aboutToAccessStorage(hbFinder, params);
            results = this.dataAccess.findByPool(poolName);
            this.cacheDirectivesByPool.put(poolName, results);
            this.gotFromDB(results);
            this.miss(hbFinder, results, new Object[]{"poolName", poolName});
        }
        return results;
    }

    private Collection<CacheDirective> findByIdPoolAndPath(CacheDirective.Finder hbFinder, Object[] params) throws StorageCallPreventedException, StorageException {
        Collection<CacheDirective> results;
        long id = (Long)params[0];
        String poolName = (String)params[1];
        String path = (String)params[2];
        int maxNumResults = (Integer)params[3];
        if (this.fetchedCacheDirectivesById) {
            results = new ArrayList();
            TreeSet<Long> ids = new TreeSet<Long>(this.cacheDirectivesById.keySet());
            Iterator iterator = ids.iterator();
            while (iterator.hasNext()) {
                long directiveId = (Long)iterator.next();
                CacheDirective directive = this.cacheDirectivesById.get(directiveId);
                if (poolName != null && !directive.getPoolName().equals(poolName) || path != null && !directive.getPath().equals(path)) continue;
                results.add(directive);
                if (results.size() < maxNumResults) continue;
                break;
            }
            this.hit(hbFinder, results, new Object[]{"id", id, "poolName", poolName, "path", path});
        } else {
            this.aboutToAccessStorage(hbFinder, params);
            results = this.dataAccess.findByIdAndPool(id, poolName);
            this.fetchedCacheDirectivesById = true;
            for (CacheDirective directive : results) {
                this.cacheDirectivesById.put(directive.getId(), directive);
            }
            this.miss(hbFinder, results, new Object[]{"id", id, "poolName", poolName, "path", path});
        }
        return results;
    }

    private Collection<CacheDirective> findAll(CacheDirective.Finder hbFinder, Object[] params) throws StorageCallPreventedException, StorageException {
        Collection results;
        if (this.all != null) {
            results = this.all;
            this.hit(hbFinder, results, new Object[]{"all"});
        } else {
            this.aboutToAccessStorage(hbFinder, params);
            results = this.dataAccess.findAll();
        }
        return results;
    }

    public void prepare(TransactionLocks tlm) throws TransactionContextException, StorageException {
        this.dataAccess.prepare(this.getRemoved(), this.getModified());
    }

    Long getKey(CacheDirective cacheDirective) {
        return cacheDirective.getId();
    }
}

