/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.context;

import io.hops.exception.StorageCallPreventedException;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.dal.ExcessReplicaDataAccess;
import io.hops.metadata.hdfs.entity.ExcessReplica;
import io.hops.transaction.context.BaseReplicaContext;
import io.hops.transaction.context.BlockPK;
import io.hops.transaction.lock.TransactionLocks;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ExcessReplicaContext
extends BaseReplicaContext<BlockPK.ReplicaPK, ExcessReplica> {
    ExcessReplicaDataAccess<ExcessReplica> dataAccess;

    public ExcessReplicaContext(ExcessReplicaDataAccess dataAccess) {
        this.dataAccess = dataAccess;
    }

    @Override
    public void update(ExcessReplica hopExcessReplica) throws TransactionContextException {
        super.update(hopExcessReplica);
        if (this.isLogDebugEnabled()) {
            this.log("added-excess", new Object[]{"bid", hopExcessReplica.getBlockId(), "sid", hopExcessReplica.getStorageId()});
        }
    }

    @Override
    public void remove(ExcessReplica hopExcessReplica) throws TransactionContextException {
        super.remove(hopExcessReplica);
        if (this.isLogDebugEnabled()) {
            this.log("removed-excess", new Object[]{"bid", hopExcessReplica.getBlockId(), "sid", hopExcessReplica.getStorageId()});
        }
    }

    public ExcessReplica find(FinderType<ExcessReplica> finder, Object ... params) throws TransactionContextException, StorageException {
        ExcessReplica.Finder eFinder = (ExcessReplica.Finder)finder;
        switch (eFinder) {
            case ByBlockIdSidAndINodeId: {
                return this.findByPrimaryKey(eFinder, params);
            }
        }
        throw new RuntimeException(UNSUPPORTED_FINDER);
    }

    public Collection<ExcessReplica> findList(FinderType<ExcessReplica> finder, Object ... params) throws TransactionContextException, StorageException {
        ExcessReplica.Finder eFinder = (ExcessReplica.Finder)finder;
        switch (eFinder) {
            case ByBlockIdAndINodeId: {
                return this.findByBlockId(eFinder, params);
            }
            case ByINodeId: {
                return this.findByINodeId(eFinder, params);
            }
            case ByINodeIds: {
                return this.findByINodeIds(eFinder, params);
            }
        }
        throw new RuntimeException(UNSUPPORTED_FINDER);
    }

    public void prepare(TransactionLocks tlm) throws TransactionContextException, StorageException {
        this.dataAccess.prepare(this.getRemoved(), this.getAdded(), this.getModified());
    }

    @Override
    ExcessReplica cloneEntity(ExcessReplica hopExcessReplica) {
        return this.cloneEntity(hopExcessReplica, hopExcessReplica.getInodeId());
    }

    @Override
    ExcessReplica cloneEntity(ExcessReplica hopExcessReplica, long inodeId) {
        return new ExcessReplica(hopExcessReplica.getStorageId(), hopExcessReplica.getBlockId(), inodeId);
    }

    BlockPK.ReplicaPK getKey(ExcessReplica hopExcessReplica) {
        return new BlockPK.ReplicaPK(hopExcessReplica.getBlockId(), hopExcessReplica.getInodeId(), hopExcessReplica.getStorageId());
    }

    private ExcessReplica findByPrimaryKey(ExcessReplica.Finder eFinder, Object[] params) throws StorageCallPreventedException, StorageException {
        long blockId = (Long)params[0];
        int storageId = (Integer)params[1];
        long inodeId = (Long)params[2];
        BlockPK.ReplicaPK key = new BlockPK.ReplicaPK(blockId, inodeId, storageId);
        ExcessReplica result = null;
        if (this.contains(key) || this.containsByINode(inodeId) || this.containsByBlock(blockId)) {
            result = (ExcessReplica)this.get(key);
            this.hit((FinderType)eFinder, result, new Object[]{"bid", blockId, "uuid", storageId});
        } else {
            this.aboutToAccessStorage((FinderType)eFinder, params);
            result = (ExcessReplica)this.dataAccess.findByPK(blockId, storageId, inodeId);
            this.gotFromDB(key, result);
            this.miss((FinderType)eFinder, result, new Object[]{"bid", blockId, "sid", storageId});
        }
        return result;
    }

    private List<ExcessReplica> findByBlockId(ExcessReplica.Finder eFinder, Object[] params) throws StorageCallPreventedException, StorageException {
        long blockId = (Long)params[0];
        long inodeId = (Long)params[1];
        List result = null;
        if (this.containsByBlock(blockId) || this.containsByINode(inodeId)) {
            result = this.getByBlock(blockId);
            this.hit((FinderType)eFinder, result, new Object[]{"bid", blockId, "inodeId", inodeId});
        } else {
            this.aboutToAccessStorage((FinderType)eFinder, params);
            result = this.dataAccess.findExcessReplicaByBlockId(blockId, inodeId);
            Collections.sort(result);
            this.gotFromDB(new BlockPK(blockId, null), result);
            this.miss((FinderType)eFinder, result, new Object[]{"bid", blockId, "inodeId", inodeId});
        }
        return result;
    }

    private List<ExcessReplica> findByINodeId(ExcessReplica.Finder eFinder, Object[] params) throws StorageCallPreventedException, StorageException {
        long inodeId = (Long)params[0];
        List result = null;
        if (this.containsByINode(inodeId)) {
            result = this.getByINode(inodeId);
            this.hit((FinderType)eFinder, result, new Object[]{"inodeId", inodeId});
        } else {
            this.aboutToAccessStorage((FinderType)eFinder, params);
            result = this.dataAccess.findExcessReplicaByINodeId(inodeId);
            this.gotFromDB(new BlockPK(null, inodeId), result);
            this.miss((FinderType)eFinder, result, new Object[]{"inodeId", inodeId});
        }
        return result;
    }

    private List<ExcessReplica> findByINodeIds(ExcessReplica.Finder eFinder, Object[] params) throws StorageCallPreventedException, StorageException {
        long[] inodeIds = (long[])params[0];
        this.aboutToAccessStorage((FinderType)eFinder, params);
        List result = this.dataAccess.findExcessReplicaByINodeIds(inodeIds);
        this.gotFromDB(BlockPK.ReplicaPK.getKeys(inodeIds), result);
        this.miss((FinderType)eFinder, result, new Object[]{"inodeIds", Arrays.toString(inodeIds)});
        return result;
    }
}

