/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.lock;

import com.google.common.collect.Iterables;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.dal.INodeDataAccess;
import io.hops.metadata.hdfs.entity.INodeCandidatePrimaryKey;
import io.hops.resolvingcache.Cache;
import io.hops.transaction.EntityManager;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.TransactionLockTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;

public abstract class BaseINodeLock
extends Lock {
    private final Map<INode, TransactionLockTypes.INodeLockType> allLockedInodesInTx = new HashMap<INode, TransactionLockTypes.INodeLockType>();
    private final ResolvedINodesMap resolvedINodesMap = new ResolvedINodesMap();
    private boolean isPartitionKeyAlreaySet = false;
    private boolean enableHierarchicalLocking = false;
    protected static boolean setPartitionKeyEnabled = false;
    protected static boolean setRandomParitionKeyEnabled = false;
    protected static Random rand = new Random(System.currentTimeMillis());

    static void enableSetPartitionKey(boolean enable) {
        setPartitionKeyEnabled = enable;
    }

    static void enableSetRandomPartitionKey(boolean enable) {
        setRandomParitionKeyEnabled = enable;
    }

    protected BaseINodeLock() {
    }

    Iterable<INode> getAllResolvedINodes() {
        return this.resolvedINodesMap.getAll();
    }

    void addPathINodesAndUpdateResolvingCache(String path, List<INode> iNodes) {
        this.addPathINodes(path, iNodes);
        this.updateResolvingCache(path, iNodes);
    }

    void updateResolvingCache(String path, List<INode> iNodes) {
        Cache.getInstance().set(path, iNodes);
    }

    void updateResolvingCache(INode inode) {
        Cache.getInstance().set(inode);
    }

    void addPathINodes(String path, List<INode> iNodes) {
        this.resolvedINodesMap.putPathINodes(path, iNodes);
    }

    void addChildINodes(String path, List<INode> iNodes) {
        this.resolvedINodesMap.putChildINodes(path, iNodes);
    }

    void addIndividualINode(INode iNode) {
        this.resolvedINodesMap.putIndividualINode(iNode);
    }

    void addIndividualINodes(List<INode> iNodes) {
        this.resolvedINodesMap.putIndividualINodes(iNodes);
    }

    List<INode> getPathINodes(String path) {
        return this.resolvedINodesMap.getPathINodes(path);
    }

    INode getTargetINode(String path) {
        List list = this.resolvedINodesMap.getPathINodes(path);
        return (INode)list.get(list.size() - 1);
    }

    List<INode> getChildINodes(String path) {
        return this.resolvedINodesMap.getChildINodes(path);
    }

    public TransactionLockTypes.INodeLockType getLockedINodeLockType(INode inode) {
        return this.allLockedInodesInTx.get(inode);
    }

    protected INode find(TransactionLockTypes.INodeLockType lock, String name, long parentId, long partitionId, long possibleINodeId) throws StorageException, TransactionContextException {
        this.setINodeLockType(lock);
        INode inode = (INode)EntityManager.find((FinderType)INode.Finder.ByNameParentIdAndPartitionId, (Object[])new Object[]{name, parentId, partitionId, possibleINodeId});
        this.addLockedINodes(inode, lock);
        return inode;
    }

    protected INode find(TransactionLockTypes.INodeLockType lock, String name, long parentId, long partitionId) throws StorageException, TransactionContextException {
        this.setINodeLockType(lock);
        INode inode = (INode)EntityManager.find((FinderType)INode.Finder.ByNameParentIdAndPartitionId, (Object[])new Object[]{name, parentId, partitionId});
        this.addLockedINodes(inode, lock);
        return inode;
    }

    protected INode find(TransactionLockTypes.INodeLockType lock, long id) throws StorageException, TransactionContextException {
        this.setINodeLockType(lock);
        INode inode = (INode)EntityManager.find((FinderType)INode.Finder.ByINodeIdFTIS, (Object[])new Object[]{id});
        this.addLockedINodes(inode, lock);
        return inode;
    }

    protected List<INode> find(TransactionLockTypes.INodeLockType lock, String[] names, long[] parentIds, long[] partitionIds, boolean checkLocalCache) throws StorageException, TransactionContextException {
        this.setINodeLockType(lock);
        List inodes = (List)EntityManager.findList((FinderType)(checkLocalCache ? INode.Finder.ByNamesParentIdsAndPartitionIdsCheckLocal : INode.Finder.ByNamesParentIdsAndPartitionIds), (Object[])new Object[]{names, parentIds, partitionIds});
        if (inodes != null) {
            for (INode inode : inodes) {
                this.addLockedINodes(inode, lock);
            }
        }
        return inodes;
    }

    protected void addLockedINodes(INode inode, TransactionLockTypes.INodeLockType lock) {
        if (inode == null) {
            return;
        }
        TransactionLockTypes.INodeLockType oldLock = this.allLockedInodesInTx.get(inode);
        if (oldLock == null || oldLock.compareTo((Enum)lock) < 0) {
            this.allLockedInodesInTx.put(inode, lock);
        }
    }

    protected void setINodeLockType(TransactionLockTypes.INodeLockType lock) throws StorageException {
        switch (lock) {
            case WRITE: 
            case WRITE_ON_TARGET_AND_PARENT: {
                EntityManager.writeLock();
                break;
            }
            case READ: {
                EntityManager.readLock();
                break;
            }
            case READ_COMMITTED: {
                EntityManager.readCommited();
            }
        }
    }

    protected void acquireINodeAttributes() throws StorageException, TransactionContextException {
        ArrayList<INodeCandidatePrimaryKey> pks = new ArrayList<INodeCandidatePrimaryKey>();
        for (INode inode : this.getAllResolvedINodes()) {
            if (!(inode instanceof INodeDirectory) || !((INodeDirectory)inode).isWithQuota()) continue;
            INodeCandidatePrimaryKey pk = new INodeCandidatePrimaryKey(inode.getId());
            pks.add(pk);
        }
        this.acquireLockList(DEFAULT_LOCK_TYPE, INodeAttributes.Finder.ByINodeIds, new Object[]{pks});
    }

    protected void setPartitioningKey(Long partitionId) throws StorageException, TransactionContextException {
        if (setPartitionKeyEnabled && partitionId != null && !this.isPartitionKeyAlreaySet) {
            Object[] key = new Object[]{partitionId, 0L, ""};
            EntityManager.setPartitionKey(INodeDataAccess.class, (Object)key);
            this.isPartitionKeyAlreaySet = true;
            LOG.debug((Object)("Setting PartitionKey to be " + partitionId));
        } else {
            LOG.debug((Object)"Transaction PartitionKey is not Set");
        }
    }

    protected final Lock.Type getType() {
        return Lock.Type.INode;
    }

    protected static boolean isStoredInDB(INode inode) {
        if (inode instanceof INodeFile) {
            INodeFile file = (INodeFile)inode;
            return file.isFileStoredInDB();
        }
        return false;
    }

    protected List<INode> readUpInodes(INode leaf) throws StorageException, TransactionContextException {
        LinkedList<INode> pathInodes = new LinkedList<INode>();
        pathInodes.add(leaf);
        INode curr = leaf;
        while (curr.getParentId() != 0L && (curr = this.find(TransactionLockTypes.INodeLockType.READ_COMMITTED, curr.getParentId())) != null) {
            pathInodes.addFirst(curr);
        }
        return pathInodes;
    }

    public BaseINodeLock enableHierarchicalLocking(boolean val) {
        this.enableHierarchicalLocking = val;
        return this;
    }

    public TransactionLockTypes.INodeLockType getDefaultInodeLockType() {
        if (this.enableHierarchicalLocking) {
            return TransactionLockTypes.INodeLockType.READ;
        }
        return TransactionLockTypes.INodeLockType.READ_COMMITTED;
    }

    private class ResolvedINodesMap {
        private final Map<String, PathRelatedINodes> pathToPathINodes = new HashMap<String, PathRelatedINodes>();
        private final Collection<INode> individualInodes = new ArrayList<INode>();

        private ResolvedINodesMap() {
        }

        private PathRelatedINodes getWithLazyInit(String path) {
            if (!this.pathToPathINodes.containsKey(path)) {
                PathRelatedINodes pathRelatedINodes = new PathRelatedINodes();
                this.pathToPathINodes.put(path, pathRelatedINodes);
                return pathRelatedINodes;
            }
            return this.pathToPathINodes.get(path);
        }

        private void putPathINodes(String path, List<INode> iNodes) {
            PathRelatedINodes pathRelatedINodes = this.getWithLazyInit(path);
            pathRelatedINodes.pathINodes = iNodes;
        }

        private void putChildINodes(String path, List<INode> iNodes) {
            PathRelatedINodes pathRelatedINodes = this.getWithLazyInit(path);
            pathRelatedINodes.childINodes = iNodes;
        }

        private void putIndividualINode(INode iNode) {
            this.individualInodes.add(iNode);
        }

        private void putIndividualINodes(List<INode> iNodes) {
            for (INode iNode : iNodes) {
                this.individualInodes.add(iNode);
            }
        }

        private List<INode> getPathINodes(String path) {
            PathRelatedINodes pri = this.pathToPathINodes.get(path);
            return pri.pathINodes;
        }

        private final int countResolvedFilesStoredInDB() {
            return this.fileCount(true);
        }

        private final int countResolvedFilesStoredOnDataNodes() {
            return this.fileCount(false);
        }

        private final int fileCount(boolean isStoredInDB) {
            int count = 0;
            for (INode inode : this.getAll()) {
                if (!(inode instanceof INodeFile)) continue;
                INodeFile file = (INodeFile)inode;
                if (isStoredInDB && file.isFileStoredInDB()) {
                    ++count;
                    continue;
                }
                if (isStoredInDB || file.isFileStoredInDB()) continue;
                ++count;
            }
            return count;
        }

        private List<INode> getChildINodes(String path) {
            return this.pathToPathINodes.get(path).childINodes;
        }

        public Iterable<INode> getAll() {
            Iterable iterable = null;
            for (PathRelatedINodes pathRelatedINodes : this.pathToPathINodes.values()) {
                List childINodes;
                List pathINodes = pathRelatedINodes.pathINodes == null ? Collections.EMPTY_LIST : pathRelatedINodes.pathINodes;
                List list = childINodes = pathRelatedINodes.childINodes == null ? Collections.EMPTY_LIST : pathRelatedINodes.childINodes;
                if (iterable == null) {
                    iterable = Iterables.concat((Iterable)pathINodes, (Iterable)childINodes);
                    continue;
                }
                iterable = Iterables.concat((Iterable)iterable, (Iterable)pathINodes, (Iterable)childINodes);
            }
            if (iterable == null) {
                iterable = Collections.EMPTY_LIST;
            }
            return Iterables.concat((Iterable)iterable, this.individualInodes);
        }

        private class PathRelatedINodes {
            private List<INode> pathINodes;
            private List<INode> childINodes;

            private PathRelatedINodes() {
            }
        }
    }
}

