/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.lock;

import io.hops.transaction.lock.INodeLock;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.hadoop.hdfs.server.namenode.INode;

final class RenameINodeLock
extends INodeLock {
    private static final Comparator PATH_COMPARTOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            String[] o2Path;
            String[] o1Path = INode.getPathNames(o1);
            if (o1Path.length > (o2Path = INode.getPathNames(o2)).length) {
                return 1;
            }
            if (o1Path.length == o2Path.length) {
                return o1.compareTo(o2);
            }
            return -1;
        }
    };
    private final boolean legacyRename;

    public RenameINodeLock(TransactionLockTypes.INodeLockType lockType, TransactionLockTypes.INodeResolveType resolveType, String src, String dst, boolean legacyRename) {
        super(lockType, resolveType, src, dst);
        this.legacyRename = legacyRename;
    }

    public RenameINodeLock(TransactionLockTypes.INodeLockType lockType, TransactionLockTypes.INodeResolveType resolveType, String src, String dst) {
        this(lockType, resolveType, src, dst, false);
    }

    @Override
    protected void acquire(TransactionLocks locks) throws IOException {
        String src = this.paths[0];
        String dst = this.paths[1];
        Arrays.sort(this.paths, PATH_COMPARTOR);
        this.acquireINodeLocks();
        if (this.legacyRename) {
            List<INode> dstINodes = this.getPathINodes(dst);
            String[] dstComponents = INode.getPathNames(dst);
            String[] srcComponents = INode.getPathNames(src);
            INode lastComp = dstINodes.get(dstINodes.size() - 1);
            if (dstINodes.size() == dstComponents.length && lastComp.isDirectory()) {
                long parttitionId = INode.calculatePartitionId(lastComp.getId(), srcComponents[srcComponents.length - 1], (short)(lastComp.myDepth() + 1));
                this.find(srcComponents[srcComponents.length - 1], lastComp.getId(), parttitionId);
            }
        }
        if (!this.skipReadingQuotaAttr) {
            this.acquireINodeAttributes();
        }
    }
}

