/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolPB;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Shorts;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import io.hops.leader_election.node.ActiveNode;
import io.hops.leader_election.node.ActiveNodePBImpl;
import io.hops.leader_election.node.SortedActiveNodeList;
import io.hops.leader_election.node.SortedActiveNodeListPBImpl;
import io.hops.leader_election.proto.ActiveNodeProtos;
import io.hops.metadata.hdfs.entity.EncodingPolicy;
import io.hops.metadata.hdfs.entity.EncodingStatus;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.fs.CacheFlag;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.StorageType;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveEntry;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveStats;
import org.apache.hadoop.hdfs.protocol.CachePoolEntry;
import org.apache.hadoop.hdfs.protocol.CachePoolInfo;
import org.apache.hadoop.hdfs.protocol.CachePoolStats;
import org.apache.hadoop.hdfs.protocol.CorruptFileBlocks;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeLocalInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.HdfsLocatedFileStatus;
import org.apache.hadoop.hdfs.protocol.LastUpdatedContentSummary;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeInfo;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeStatus;
import org.apache.hadoop.hdfs.protocol.proto.AclProtos;
import org.apache.hadoop.hdfs.protocol.proto.ClientNamenodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.DataTransferProtos;
import org.apache.hadoop.hdfs.protocol.proto.DatanodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.security.token.block.BlockKey;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.DataEncryptionKey;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.protocol.BalancerBandwidthCommand;
import org.apache.hadoop.hdfs.server.protocol.BlockCommand;
import org.apache.hadoop.hdfs.server.protocol.BlockIdCommand;
import org.apache.hadoop.hdfs.server.protocol.BlockRecoveryCommand;
import org.apache.hadoop.hdfs.server.protocol.BlockReport;
import org.apache.hadoop.hdfs.server.protocol.BlockReportBlockState;
import org.apache.hadoop.hdfs.server.protocol.BlocksWithLocations;
import org.apache.hadoop.hdfs.server.protocol.Bucket;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorageReport;
import org.apache.hadoop.hdfs.server.protocol.FinalizeCommand;
import org.apache.hadoop.hdfs.server.protocol.KeyUpdateCommand;
import org.apache.hadoop.hdfs.server.protocol.NamenodeCommand;
import org.apache.hadoop.hdfs.server.protocol.NamenodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.ReceivedDeletedBlockInfo;
import org.apache.hadoop.hdfs.server.protocol.RegisterCommand;
import org.apache.hadoop.hdfs.server.protocol.ReportedBlock;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.hdfs.shortcircuit.ShortCircuitShm;
import org.apache.hadoop.hdfs.util.ExactSizeInputStream;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.proto.SecurityProtos;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.DataChecksum;

public class PBHelper {
    private static final DatanodeProtocolProtos.RegisterCommandProto REG_CMD_PROTO = DatanodeProtocolProtos.RegisterCommandProto.newBuilder().build();
    private static final RegisterCommand REG_CMD = new RegisterCommand();
    private static final AclEntryScope[] ACL_ENTRY_SCOPE_VALUES = AclEntryScope.values();
    private static final AclEntryType[] ACL_ENTRY_TYPE_VALUES = AclEntryType.values();
    private static final FsAction[] FSACTION_VALUES = FsAction.values();

    private PBHelper() {
    }

    static <T extends Enum<T>, U extends Enum<U>> U castEnum(T from, U[] to) {
        return to[from.ordinal()];
    }

    public static ByteString getByteString(byte[] bytes) {
        return ByteString.copyFrom((byte[])bytes);
    }

    public static HdfsServerConstants.NamenodeRole convert(HdfsProtos.NamenodeRegistrationProto.NamenodeRoleProto role) {
        switch (role) {
            case NAMENODE: {
                return HdfsServerConstants.NamenodeRole.NAMENODE;
            }
            case BACKUP: {
                return HdfsServerConstants.NamenodeRole.BACKUP;
            }
            case CHECKPOINT: {
                return HdfsServerConstants.NamenodeRole.CHECKPOINT;
            }
        }
        return null;
    }

    public static HdfsProtos.NamenodeRegistrationProto.NamenodeRoleProto convert(HdfsServerConstants.NamenodeRole role) {
        switch (role) {
            case NAMENODE: {
                return HdfsProtos.NamenodeRegistrationProto.NamenodeRoleProto.NAMENODE;
            }
            case BACKUP: {
                return HdfsProtos.NamenodeRegistrationProto.NamenodeRoleProto.BACKUP;
            }
            case CHECKPOINT: {
                return HdfsProtos.NamenodeRegistrationProto.NamenodeRoleProto.CHECKPOINT;
            }
        }
        return null;
    }

    public static HdfsProtos.StorageInfoProto convert(StorageInfo info) {
        return HdfsProtos.StorageInfoProto.newBuilder().setClusterID(info.getClusterID()).setCTime(info.getCTime()).setLayoutVersion(info.getLayoutVersion()).setNamespaceID(info.getNamespaceID()).setBlockpoolID(info.getBlockPoolId()).setDEFAULTROWID(info.getDefaultRowId()).build();
    }

    public static StorageInfo convert(HdfsProtos.StorageInfoProto info, HdfsServerConstants.NodeType type) {
        return new StorageInfo(info.getLayoutVersion(), info.getNamespaceID(), info.getClusterID(), info.getCTime(), type, info.getBlockpoolID());
    }

    public static HdfsProtos.NamenodeRegistrationProto convert(NamenodeRegistration reg) {
        return HdfsProtos.NamenodeRegistrationProto.newBuilder().setHttpAddress(reg.getHttpAddress()).setRole(PBHelper.convert(reg.getRole())).setRpcAddress(reg.getAddress()).setStorageInfo(PBHelper.convert((StorageInfo)reg)).build();
    }

    public static NamenodeRegistration convert(HdfsProtos.NamenodeRegistrationProto reg) {
        StorageInfo si = PBHelper.convert(reg.getStorageInfo(), HdfsServerConstants.NodeType.NAME_NODE);
        return new NamenodeRegistration(reg.getRpcAddress(), reg.getHttpAddress(), si, PBHelper.convert(reg.getRole()));
    }

    public static DatanodeID convert(HdfsProtos.DatanodeIDProto dn) {
        return new DatanodeID(dn.getIpAddr(), dn.getHostName(), dn.getDatanodeUuid(), dn.getXferPort(), dn.getInfoPort(), dn.hasInfoSecurePort() ? dn.getInfoSecurePort() : 0, dn.getIpcPort());
    }

    public static HdfsProtos.DatanodeIDProto convert(DatanodeID dn) {
        return HdfsProtos.DatanodeIDProto.newBuilder().setIpAddr(dn.getIpAddr()).setHostName(dn.getHostName()).setDatanodeUuid(dn.getDatanodeUuid() != null ? dn.getDatanodeUuid() : "").setXferPort(dn.getXferPort()).setInfoPort(dn.getInfoPort()).setInfoSecurePort(dn.getInfoSecurePort()).setIpcPort(dn.getIpcPort()).build();
    }

    public static HdfsProtos.DatanodeIDProto[] convert(DatanodeID[] did) {
        if (did == null) {
            return null;
        }
        int len = did.length;
        HdfsProtos.DatanodeIDProto[] result = new HdfsProtos.DatanodeIDProto[len];
        for (int i = 0; i < len; ++i) {
            result[i] = PBHelper.convert(did[i]);
        }
        return result;
    }

    public static DatanodeID[] convert(HdfsProtos.DatanodeIDProto[] did) {
        if (did == null) {
            return null;
        }
        int len = did.length;
        DatanodeID[] result = new DatanodeID[len];
        for (int i = 0; i < len; ++i) {
            result[i] = PBHelper.convert(did[i]);
        }
        return result;
    }

    public static HdfsProtos.BlockProto convert(Block b) {
        return HdfsProtos.BlockProto.newBuilder().setBlockId(b.getBlockId()).setGenStamp(b.getGenerationStamp()).setNumBytes(b.getNumBytes()).build();
    }

    public static Block convert(HdfsProtos.BlockProto b) {
        return new Block(b.getBlockId(), b.getNumBytes(), b.getGenStamp());
    }

    public static HdfsProtos.BlockWithLocationsProto convert(BlocksWithLocations.BlockWithLocations blk) {
        return HdfsProtos.BlockWithLocationsProto.newBuilder().setBlock(PBHelper.convert(blk.getBlock())).addAllDatanodeUuids(Arrays.asList(blk.getDatanodeUuids())).addAllStorageUuids(Arrays.asList(blk.getStorageIDs())).addAllStorageTypes(PBHelper.convertStorageTypes(blk.getStorageTypes())).build();
    }

    public static BlocksWithLocations.BlockWithLocations convert(HdfsProtos.BlockWithLocationsProto b) {
        List<String> datanodeUuids = b.getDatanodeUuidsList();
        List<String> storageUuids = b.getStorageUuidsList();
        List<HdfsProtos.StorageTypeProto> storageTypes = b.getStorageTypesList();
        return new BlocksWithLocations.BlockWithLocations(PBHelper.convert(b.getBlock()), datanodeUuids.toArray(new String[datanodeUuids.size()]), storageUuids.toArray(new String[storageUuids.size()]), PBHelper.convertStorageTypes(storageTypes, storageUuids.size()));
    }

    public static HdfsProtos.BlocksWithLocationsProto convert(BlocksWithLocations blks) {
        HdfsProtos.BlocksWithLocationsProto.Builder builder = HdfsProtos.BlocksWithLocationsProto.newBuilder();
        for (BlocksWithLocations.BlockWithLocations b : blks.getBlocks()) {
            builder.addBlocks(PBHelper.convert(b));
        }
        return builder.build();
    }

    public static BlocksWithLocations convert(HdfsProtos.BlocksWithLocationsProto blocks) {
        List<HdfsProtos.BlockWithLocationsProto> b = blocks.getBlocksList();
        BlocksWithLocations.BlockWithLocations[] ret = new BlocksWithLocations.BlockWithLocations[b.size()];
        int i = 0;
        for (HdfsProtos.BlockWithLocationsProto entry : b) {
            ret[i++] = PBHelper.convert(entry);
        }
        return new BlocksWithLocations(ret);
    }

    public static HdfsProtos.BlockKeyProto convert(BlockKey key) {
        byte[] encodedKey = key.getEncodedKey();
        ByteString keyBytes = ByteString.copyFrom((byte[])(encodedKey == null ? new byte[]{} : encodedKey));
        return HdfsProtos.BlockKeyProto.newBuilder().setKeyId(key.getKeyId()).setKeyBytes(keyBytes).setExpiryDate(key.getExpiryDate()).build();
    }

    public static BlockKey convert(HdfsProtos.BlockKeyProto k) {
        return new BlockKey(k.getKeyId(), k.getExpiryDate(), k.getKeyBytes().toByteArray());
    }

    public static HdfsProtos.ExportedBlockKeysProto convert(ExportedBlockKeys keys) {
        HdfsProtos.ExportedBlockKeysProto.Builder builder = HdfsProtos.ExportedBlockKeysProto.newBuilder();
        builder.setIsBlockTokenEnabled(keys.isBlockTokenEnabled()).setKeyUpdateInterval(keys.getKeyUpdateInterval()).setTokenLifeTime(keys.getTokenLifetime()).setCurrentKey(PBHelper.convert(keys.getCurrentKey()));
        for (BlockKey k : keys.getAllKeys()) {
            builder.addAllKeys(PBHelper.convert(k));
        }
        return builder.build();
    }

    public static ExportedBlockKeys convert(HdfsProtos.ExportedBlockKeysProto keys) {
        return new ExportedBlockKeys(keys.getIsBlockTokenEnabled(), keys.getKeyUpdateInterval(), keys.getTokenLifeTime(), PBHelper.convert(keys.getCurrentKey()), PBHelper.convertBlockKeys(keys.getAllKeysList()));
    }

    public static HdfsProtos.NamenodeCommandProto convert(NamenodeCommand cmd) {
        return HdfsProtos.NamenodeCommandProto.newBuilder().setType(HdfsProtos.NamenodeCommandProto.Type.NamenodeCommand).setAction(cmd.getAction()).build();
    }

    public static BlockKey[] convertBlockKeys(List<HdfsProtos.BlockKeyProto> list) {
        BlockKey[] ret = new BlockKey[list.size()];
        int i = 0;
        for (HdfsProtos.BlockKeyProto k : list) {
            ret[i++] = PBHelper.convert(k);
        }
        return ret;
    }

    public static NamespaceInfo convert(HdfsProtos.NamespaceInfoProto info) {
        HdfsProtos.StorageInfoProto storage = info.getStorageInfo();
        return new NamespaceInfo(storage.getNamespaceID(), storage.getClusterID(), info.getBlockPoolID(), storage.getCTime(), info.getBuildVersion(), info.getSoftwareVersion());
    }

    public static NamenodeCommand convert(HdfsProtos.NamenodeCommandProto cmd) {
        if (cmd == null) {
            return null;
        }
        return new NamenodeCommand(cmd.getAction());
    }

    public static ExtendedBlock convert(HdfsProtos.ExtendedBlockProto eb) {
        if (eb == null) {
            return null;
        }
        return new ExtendedBlock(eb.getPoolId(), eb.getBlockId(), eb.getNumBytes(), eb.getGenerationStamp());
    }

    public static HdfsProtos.ExtendedBlockProto convert(ExtendedBlock b) {
        if (b == null) {
            return null;
        }
        return HdfsProtos.ExtendedBlockProto.newBuilder().setPoolId(b.getBlockPoolId()).setBlockId(b.getBlockId()).setNumBytes(b.getNumBytes()).setGenerationStamp(b.getGenerationStamp()).build();
    }

    public static HdfsProtos.RecoveringBlockProto convert(BlockRecoveryCommand.RecoveringBlock b) {
        if (b == null) {
            return null;
        }
        HdfsProtos.LocatedBlockProto lb = PBHelper.convert((LocatedBlock)b);
        return HdfsProtos.RecoveringBlockProto.newBuilder().setBlock(lb).setNewGenStamp(b.getNewGenerationStamp()).build();
    }

    public static BlockRecoveryCommand.RecoveringBlock convert(HdfsProtos.RecoveringBlockProto b) {
        ExtendedBlock block = PBHelper.convert(b.getBlock().getB());
        DatanodeInfo[] locs = PBHelper.convert(b.getBlock().getLocsList());
        return new BlockRecoveryCommand.RecoveringBlock(block, locs, b.getNewGenStamp());
    }

    public static HdfsProtos.DatanodeInfoProto.AdminState convert(DatanodeInfo.AdminStates inAs) {
        switch (inAs) {
            case NORMAL: {
                return HdfsProtos.DatanodeInfoProto.AdminState.NORMAL;
            }
            case DECOMMISSION_INPROGRESS: {
                return HdfsProtos.DatanodeInfoProto.AdminState.DECOMMISSION_INPROGRESS;
            }
            case DECOMMISSIONED: {
                return HdfsProtos.DatanodeInfoProto.AdminState.DECOMMISSIONED;
            }
        }
        return HdfsProtos.DatanodeInfoProto.AdminState.NORMAL;
    }

    public static DatanodeInfo convert(HdfsProtos.DatanodeInfoProto di) {
        if (di == null) {
            return null;
        }
        DatanodeInfo datanodeInfo = new DatanodeInfo(PBHelper.convert(di.getId()), di.hasLocation() ? di.getLocation() : null, di.getCapacity(), di.getDfsUsed(), di.getRemaining(), di.getBlockPoolUsed(), di.getCacheCapacity(), di.getCacheUsed(), di.getLastUpdate(), di.getXceiverCount(), PBHelper.convert(di.getAdminState()));
        return datanodeInfo;
    }

    public static HdfsProtos.DatanodeInfoProto convertDatanodeInfo(DatanodeInfo di) {
        if (di == null) {
            return null;
        }
        return PBHelper.convert(di);
    }

    public static DatanodeInfo[] convert(HdfsProtos.DatanodeInfoProto[] di) {
        if (di == null) {
            return null;
        }
        DatanodeInfo[] result = new DatanodeInfo[di.length];
        for (int i = 0; i < di.length; ++i) {
            result[i] = PBHelper.convert(di[i]);
        }
        return result;
    }

    public static List<? extends HdfsProtos.DatanodeInfoProto> convert(DatanodeInfo[] dnInfos) {
        return PBHelper.convert(dnInfos, 0);
    }

    public static List<? extends HdfsProtos.DatanodeInfoProto> convert(DatanodeInfo[] dnInfos, int startIdx) {
        if (dnInfos == null) {
            return null;
        }
        ArrayList protos = Lists.newArrayListWithCapacity((int)dnInfos.length);
        for (int i = startIdx; i < dnInfos.length; ++i) {
            protos.add(PBHelper.convert(dnInfos[i]));
        }
        return protos;
    }

    public static DatanodeInfo[] convert(List<HdfsProtos.DatanodeInfoProto> list) {
        DatanodeInfo[] info = new DatanodeInfo[list.size()];
        for (int i = 0; i < info.length; ++i) {
            info[i] = PBHelper.convert(list.get(i));
        }
        return info;
    }

    public static HdfsProtos.DatanodeInfoProto convert(DatanodeInfo info) {
        HdfsProtos.DatanodeInfoProto.Builder builder = HdfsProtos.DatanodeInfoProto.newBuilder();
        if (info.getNetworkLocation() != null) {
            builder.setLocation(info.getNetworkLocation());
        }
        builder.setId(PBHelper.convert((DatanodeID)info)).setCapacity(info.getCapacity()).setDfsUsed(info.getDfsUsed()).setRemaining(info.getRemaining()).setBlockPoolUsed(info.getBlockPoolUsed()).setCacheCapacity(info.getCacheCapacity()).setCacheUsed(info.getCacheUsed()).setLastUpdate(info.getLastUpdate()).setXceiverCount(info.getXceiverCount()).setAdminState(PBHelper.convert(info.getAdminState())).build();
        return builder.build();
    }

    public static ClientNamenodeProtocolProtos.DatanodeStorageReportProto convertDatanodeStorageReport(DatanodeStorageReport report) {
        return ClientNamenodeProtocolProtos.DatanodeStorageReportProto.newBuilder().setDatanodeInfo(PBHelper.convert(report.getDatanodeInfo())).addAllStorageReports(PBHelper.convertStorageReports(report.getStorageReports())).build();
    }

    public static List<ClientNamenodeProtocolProtos.DatanodeStorageReportProto> convertDatanodeStorageReports(DatanodeStorageReport[] reports) {
        ArrayList<ClientNamenodeProtocolProtos.DatanodeStorageReportProto> protos = new ArrayList<ClientNamenodeProtocolProtos.DatanodeStorageReportProto>(reports.length);
        for (int i = 0; i < reports.length; ++i) {
            protos.add(PBHelper.convertDatanodeStorageReport(reports[i]));
        }
        return protos;
    }

    public static DatanodeStorageReport convertDatanodeStorageReport(ClientNamenodeProtocolProtos.DatanodeStorageReportProto proto) {
        return new DatanodeStorageReport(PBHelper.convert(proto.getDatanodeInfo()), PBHelper.convertStorageReports(proto.getStorageReportsList()));
    }

    public static DatanodeStorageReport[] convertDatanodeStorageReports(List<ClientNamenodeProtocolProtos.DatanodeStorageReportProto> protos) {
        DatanodeStorageReport[] reports = new DatanodeStorageReport[protos.size()];
        for (int i = 0; i < reports.length; ++i) {
            reports[i] = PBHelper.convertDatanodeStorageReport(protos.get(i));
        }
        return reports;
    }

    public static DatanodeInfo.AdminStates convert(HdfsProtos.DatanodeInfoProto.AdminState adminState) {
        switch (adminState) {
            case DECOMMISSION_INPROGRESS: {
                return DatanodeInfo.AdminStates.DECOMMISSION_INPROGRESS;
            }
            case DECOMMISSIONED: {
                return DatanodeInfo.AdminStates.DECOMMISSIONED;
            }
        }
        return DatanodeInfo.AdminStates.NORMAL;
    }

    public static HdfsProtos.LocatedBlockProto convert(LocatedBlock b) {
        String[] storageIDs;
        if (b == null) {
            return null;
        }
        HdfsProtos.LocatedBlockProto.Builder builder = HdfsProtos.LocatedBlockProto.newBuilder();
        DatanodeInfo[] locs = b.getLocations();
        LinkedList cachedLocs = Lists.newLinkedList(Arrays.asList(b.getCachedLocations()));
        for (int i = 0; i < locs.length; ++i) {
            DatanodeInfo loc = locs[i];
            builder.addLocs(i, PBHelper.convert(loc));
            boolean locIsCached = cachedLocs.contains(loc);
            builder.addIsCached(locIsCached);
            if (!locIsCached) continue;
            cachedLocs.remove(loc);
        }
        Preconditions.checkArgument((cachedLocs.size() == 0 ? 1 : 0) != 0, (Object)"Found additional cached replica locations that are not in the set of storage-backed locations!");
        StorageType[] storageTypes = b.getStorageTypes();
        if (storageTypes != null) {
            for (int i = 0; i < storageTypes.length; ++i) {
                builder.addStorageTypes(PBHelper.convertStorageType(storageTypes[i]));
            }
        }
        if ((storageIDs = b.getStorageIDs()) != null) {
            builder = builder.addAllStorageIDs(Arrays.asList(storageIDs));
        }
        builder = builder.setB(PBHelper.convert(b.getBlock())).setBlockToken(PBHelper.convert(b.getBlockToken())).setCorrupt(b.isCorrupt()).setOffset(b.getStartOffset());
        if (b.isPhantomBlock() && b.isDataSet()) {
            builder.setData(ByteString.copyFrom((byte[])b.getData()));
        }
        return builder.build();
    }

    public static LocatedBlock convert(HdfsProtos.LocatedBlockProto proto) {
        String[] storageIDs;
        if (proto == null) {
            return null;
        }
        List<HdfsProtos.DatanodeInfoProto> locs = proto.getLocsList();
        DatanodeInfo[] targets = new DatanodeInfo[locs.size()];
        for (int i = 0; i < locs.size(); ++i) {
            targets[i] = PBHelper.convert(locs.get(i));
        }
        StorageType[] storageTypes = PBHelper.convertStorageTypes(proto.getStorageTypesList(), locs.size());
        int storageIDsCount = proto.getStorageIDsCount();
        if (storageIDsCount == 0) {
            storageIDs = null;
        } else {
            assert (storageIDsCount == locs.size());
            storageIDs = proto.getStorageIDsList().toArray(new String[storageIDsCount]);
        }
        ArrayList<DatanodeInfo> cachedLocs = new ArrayList<DatanodeInfo>(locs.size());
        List<Boolean> isCachedList = proto.getIsCachedList();
        for (int i = 0; i < isCachedList.size(); ++i) {
            if (!isCachedList.get(i).booleanValue()) continue;
            cachedLocs.add(targets[i]);
        }
        LocatedBlock lb = new LocatedBlock(PBHelper.convert(proto.getB()), targets, storageIDs, storageTypes, proto.getOffset(), proto.getCorrupt(), cachedLocs.toArray(new DatanodeInfo[0]));
        lb.setBlockToken(PBHelper.convert(proto.getBlockToken()));
        if (proto.getData().size() > 0) {
            lb.setData(proto.getData().toByteArray());
        }
        return lb;
    }

    public static SecurityProtos.TokenProto convert(Token<?> tok) {
        return SecurityProtos.TokenProto.newBuilder().setIdentifier(ByteString.copyFrom((byte[])tok.getIdentifier())).setPassword(ByteString.copyFrom((byte[])tok.getPassword())).setKind(tok.getKind().toString()).setService(tok.getService().toString()).build();
    }

    public static Token<BlockTokenIdentifier> convert(SecurityProtos.TokenProto blockToken) {
        return new Token(blockToken.getIdentifier().toByteArray(), blockToken.getPassword().toByteArray(), new Text(blockToken.getKind()), new Text(blockToken.getService()));
    }

    public static Token<DelegationTokenIdentifier> convertDelegationToken(SecurityProtos.TokenProto blockToken) {
        return new Token(blockToken.getIdentifier().toByteArray(), blockToken.getPassword().toByteArray(), new Text(blockToken.getKind()), new Text(blockToken.getService()));
    }

    public static HdfsServerConstants.ReplicaState convert(HdfsProtos.ReplicaStateProto state) {
        switch (state) {
            case RBW: {
                return HdfsServerConstants.ReplicaState.RBW;
            }
            case RUR: {
                return HdfsServerConstants.ReplicaState.RUR;
            }
            case RWR: {
                return HdfsServerConstants.ReplicaState.RWR;
            }
            case TEMPORARY: {
                return HdfsServerConstants.ReplicaState.TEMPORARY;
            }
        }
        return HdfsServerConstants.ReplicaState.FINALIZED;
    }

    public static HdfsProtos.ReplicaStateProto convert(HdfsServerConstants.ReplicaState state) {
        switch (state) {
            case RBW: {
                return HdfsProtos.ReplicaStateProto.RBW;
            }
            case RUR: {
                return HdfsProtos.ReplicaStateProto.RUR;
            }
            case RWR: {
                return HdfsProtos.ReplicaStateProto.RWR;
            }
            case TEMPORARY: {
                return HdfsProtos.ReplicaStateProto.TEMPORARY;
            }
        }
        return HdfsProtos.ReplicaStateProto.FINALIZED;
    }

    public static DatanodeProtocolProtos.DatanodeRegistrationProto convert(DatanodeRegistration registration) {
        DatanodeProtocolProtos.DatanodeRegistrationProto.Builder builder = DatanodeProtocolProtos.DatanodeRegistrationProto.newBuilder();
        return builder.setDatanodeID(PBHelper.convert((DatanodeID)registration)).setStorageInfo(PBHelper.convert(registration.getStorageInfo())).setKeys(PBHelper.convert(registration.getExportedKeys())).setSoftwareVersion(registration.getSoftwareVersion()).build();
    }

    public static DatanodeRegistration convert(DatanodeProtocolProtos.DatanodeRegistrationProto proto) {
        StorageInfo si = PBHelper.convert(proto.getStorageInfo(), HdfsServerConstants.NodeType.DATA_NODE);
        return new DatanodeRegistration(PBHelper.convert(proto.getDatanodeID()), si, PBHelper.convert(proto.getKeys()), proto.getSoftwareVersion());
    }

    public static DatanodeCommand convert(DatanodeProtocolProtos.DatanodeCommandProto proto) {
        switch (proto.getCmdType()) {
            case BalancerBandwidthCommand: {
                return PBHelper.convert(proto.getBalancerCmd());
            }
            case BlockCommand: {
                return PBHelper.convert(proto.getBlkCmd());
            }
            case BlockRecoveryCommand: {
                return PBHelper.convert(proto.getRecoveryCmd());
            }
            case FinalizeCommand: {
                return PBHelper.convert(proto.getFinalizeCmd());
            }
            case KeyUpdateCommand: {
                return PBHelper.convert(proto.getKeyUpdateCmd());
            }
            case RegisterCommand: {
                return REG_CMD;
            }
            case BlockIdCommand: {
                return PBHelper.convert(proto.getBlkIdCmd());
            }
        }
        return null;
    }

    public static DatanodeProtocolProtos.BalancerBandwidthCommandProto convert(BalancerBandwidthCommand bbCmd) {
        return DatanodeProtocolProtos.BalancerBandwidthCommandProto.newBuilder().setBandwidth(bbCmd.getBalancerBandwidthValue()).build();
    }

    public static DatanodeProtocolProtos.KeyUpdateCommandProto convert(KeyUpdateCommand cmd) {
        return DatanodeProtocolProtos.KeyUpdateCommandProto.newBuilder().setKeys(PBHelper.convert(cmd.getExportedKeys())).build();
    }

    public static DatanodeProtocolProtos.BlockRecoveryCommandProto convert(BlockRecoveryCommand cmd) {
        DatanodeProtocolProtos.BlockRecoveryCommandProto.Builder builder = DatanodeProtocolProtos.BlockRecoveryCommandProto.newBuilder();
        for (BlockRecoveryCommand.RecoveringBlock b : cmd.getRecoveringBlocks()) {
            builder.addBlocks(PBHelper.convert(b));
        }
        return builder.build();
    }

    public static DatanodeProtocolProtos.FinalizeCommandProto convert(FinalizeCommand cmd) {
        return DatanodeProtocolProtos.FinalizeCommandProto.newBuilder().setBlockPoolId(cmd.getBlockPoolId()).build();
    }

    public static DatanodeProtocolProtos.BlockCommandProto convert(BlockCommand cmd) {
        Block[] blocks;
        DatanodeProtocolProtos.BlockCommandProto.Builder builder = DatanodeProtocolProtos.BlockCommandProto.newBuilder().setBlockPoolId(cmd.getBlockPoolId());
        switch (cmd.getAction()) {
            case 1: {
                builder.setAction(DatanodeProtocolProtos.BlockCommandProto.Action.TRANSFER);
                break;
            }
            case 2: {
                builder.setAction(DatanodeProtocolProtos.BlockCommandProto.Action.INVALIDATE);
                break;
            }
            case 3: {
                builder.setAction(DatanodeProtocolProtos.BlockCommandProto.Action.SHUTDOWN);
                break;
            }
            default: {
                throw new AssertionError((Object)"Invalid action");
            }
        }
        for (Block block : blocks = cmd.getBlocks()) {
            builder.addBlocks(PBHelper.convert(block));
        }
        builder.addAllTargets(PBHelper.convert(cmd.getTargets())).addAllTargetStorageUuids(PBHelper.convert(cmd.getTargetStorageIDs()));
        StorageType[][] types = cmd.getTargetStorageTypes();
        if (types != null) {
            builder.addAllTargetStorageTypes(PBHelper.convert(types));
        }
        return builder.build();
    }

    private static List<HdfsProtos.StorageTypesProto> convert(StorageType[][] types) {
        ArrayList list = Lists.newArrayList();
        if (types != null) {
            for (StorageType[] ts : types) {
                HdfsProtos.StorageTypesProto.Builder builder = HdfsProtos.StorageTypesProto.newBuilder();
                builder.addAllStorageTypes(PBHelper.convertStorageTypes(ts));
                list.add(builder.build());
            }
        }
        return list;
    }

    public static DatanodeProtocolProtos.BlockIdCommandProto convert(BlockIdCommand cmd) {
        DatanodeProtocolProtos.BlockIdCommandProto.Builder builder = DatanodeProtocolProtos.BlockIdCommandProto.newBuilder().setBlockPoolId(cmd.getBlockPoolId());
        switch (cmd.getAction()) {
            case 9: {
                builder.setAction(DatanodeProtocolProtos.BlockIdCommandProto.Action.CACHE);
                break;
            }
            case 10: {
                builder.setAction(DatanodeProtocolProtos.BlockIdCommandProto.Action.UNCACHE);
                break;
            }
            default: {
                throw new AssertionError((Object)"Invalid action");
            }
        }
        long[] blockIds = cmd.getBlockIds();
        for (int i = 0; i < blockIds.length; ++i) {
            builder.addBlockIds(blockIds[i]);
        }
        return builder.build();
    }

    private static List<HdfsProtos.DatanodeInfosProto> convert(DatanodeInfo[][] targets) {
        HdfsProtos.DatanodeInfosProto[] ret = new HdfsProtos.DatanodeInfosProto[targets.length];
        for (int i = 0; i < targets.length; ++i) {
            ret[i] = HdfsProtos.DatanodeInfosProto.newBuilder().addAllDatanodes(PBHelper.convert(targets[i])).build();
        }
        return Arrays.asList(ret);
    }

    private static List<HdfsProtos.StorageUuidsProto> convert(String[][] targetStorageUuids) {
        HdfsProtos.StorageUuidsProto[] ret = new HdfsProtos.StorageUuidsProto[targetStorageUuids.length];
        for (int i = 0; i < targetStorageUuids.length; ++i) {
            ret[i] = HdfsProtos.StorageUuidsProto.newBuilder().addAllStorageUuids(Arrays.asList(targetStorageUuids[i])).build();
        }
        return Arrays.asList(ret);
    }

    public static DatanodeProtocolProtos.DatanodeCommandProto convert(DatanodeCommand datanodeCommand) {
        DatanodeProtocolProtos.DatanodeCommandProto.Builder builder = DatanodeProtocolProtos.DatanodeCommandProto.newBuilder();
        if (datanodeCommand == null) {
            return builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.NullDatanodeCommand).build();
        }
        switch (datanodeCommand.getAction()) {
            case 8: {
                builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.BalancerBandwidthCommand).setBalancerCmd(PBHelper.convert((BalancerBandwidthCommand)datanodeCommand));
                break;
            }
            case 7: {
                builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.KeyUpdateCommand).setKeyUpdateCmd(PBHelper.convert((KeyUpdateCommand)datanodeCommand));
                break;
            }
            case 6: {
                builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.BlockRecoveryCommand).setRecoveryCmd(PBHelper.convert((BlockRecoveryCommand)datanodeCommand));
                break;
            }
            case 5: {
                builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.FinalizeCommand).setFinalizeCmd(PBHelper.convert((FinalizeCommand)datanodeCommand));
                break;
            }
            case 4: {
                builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.RegisterCommand).setRegisterCmd(REG_CMD_PROTO);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.BlockCommand).setBlkCmd(PBHelper.convert((BlockCommand)datanodeCommand));
                break;
            }
            case 9: 
            case 10: {
                builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.BlockIdCommand).setBlkIdCmd(PBHelper.convert((BlockIdCommand)datanodeCommand));
                break;
            }
            default: {
                builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.NullDatanodeCommand);
            }
        }
        return builder.build();
    }

    public static KeyUpdateCommand convert(DatanodeProtocolProtos.KeyUpdateCommandProto keyUpdateCmd) {
        return new KeyUpdateCommand(PBHelper.convert(keyUpdateCmd.getKeys()));
    }

    public static FinalizeCommand convert(DatanodeProtocolProtos.FinalizeCommandProto finalizeCmd) {
        return new FinalizeCommand(finalizeCmd.getBlockPoolId());
    }

    public static BlockRecoveryCommand convert(DatanodeProtocolProtos.BlockRecoveryCommandProto recoveryCmd) {
        List<HdfsProtos.RecoveringBlockProto> list = recoveryCmd.getBlocksList();
        ArrayList<BlockRecoveryCommand.RecoveringBlock> recoveringBlocks = new ArrayList<BlockRecoveryCommand.RecoveringBlock>(list.size());
        for (HdfsProtos.RecoveringBlockProto rbp : list) {
            recoveringBlocks.add(PBHelper.convert(rbp));
        }
        return new BlockRecoveryCommand(recoveringBlocks);
    }

    public static BlockCommand convert(DatanodeProtocolProtos.BlockCommandProto blkCmd) {
        int i;
        List<HdfsProtos.BlockProto> blockProtoList = blkCmd.getBlocksList();
        Block[] blocks = new Block[blockProtoList.size()];
        for (int i2 = 0; i2 < blockProtoList.size(); ++i2) {
            blocks[i2] = PBHelper.convert(blockProtoList.get(i2));
        }
        List<HdfsProtos.DatanodeInfosProto> targetList = blkCmd.getTargetsList();
        DatanodeInfo[][] targets = new DatanodeInfo[targetList.size()][];
        for (int i3 = 0; i3 < targetList.size(); ++i3) {
            targets[i3] = PBHelper.convert(targetList.get(i3));
        }
        StorageType[][] targetStorageTypes = new StorageType[targetList.size()][];
        List<HdfsProtos.StorageTypesProto> targetStorageTypesList = blkCmd.getTargetStorageTypesList();
        if (targetStorageTypesList.isEmpty()) {
            for (i = 0; i < targetStorageTypes.length; ++i) {
                targetStorageTypes[i] = new StorageType[targets[i].length];
                Arrays.fill((Object[])targetStorageTypes[i], (Object)StorageType.DEFAULT);
            }
        } else {
            for (i = 0; i < targetStorageTypes.length; ++i) {
                List<HdfsProtos.StorageTypeProto> p = targetStorageTypesList.get(i).getStorageTypesList();
                targetStorageTypes[i] = PBHelper.convertStorageTypes(p, targets[i].length);
            }
        }
        List<HdfsProtos.StorageUuidsProto> targetStorageUuidsList = blkCmd.getTargetStorageUuidsList();
        String[][] targetStorageIDs = new String[targetStorageUuidsList.size()][];
        for (int i4 = 0; i4 < targetStorageIDs.length; ++i4) {
            List<String> storageIDs = targetStorageUuidsList.get(i4).getStorageUuidsList();
            targetStorageIDs[i4] = storageIDs.toArray(new String[storageIDs.size()]);
        }
        int action = 0;
        switch (blkCmd.getAction()) {
            case TRANSFER: {
                action = 1;
                break;
            }
            case INVALIDATE: {
                action = 2;
                break;
            }
            case SHUTDOWN: {
                action = 3;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown action type: " + (Object)((Object)blkCmd.getAction())));
            }
        }
        return new BlockCommand(action, blkCmd.getBlockPoolId(), blocks, targets, targetStorageTypes, targetStorageIDs);
    }

    public static BlockIdCommand convert(DatanodeProtocolProtos.BlockIdCommandProto blkIdCmd) {
        int numBlockIds = blkIdCmd.getBlockIdsCount();
        long[] blockIds = new long[numBlockIds];
        for (int i = 0; i < numBlockIds; ++i) {
            blockIds[i] = blkIdCmd.getBlockIds(i);
        }
        int action = 0;
        switch (blkIdCmd.getAction()) {
            case CACHE: {
                action = 9;
                break;
            }
            case UNCACHE: {
                action = 10;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown action type: " + (Object)((Object)blkIdCmd.getAction())));
            }
        }
        return new BlockIdCommand(action, blkIdCmd.getBlockPoolId(), blockIds);
    }

    public static DatanodeInfo[] convert(HdfsProtos.DatanodeInfosProto datanodeInfosProto) {
        List<HdfsProtos.DatanodeInfoProto> proto = datanodeInfosProto.getDatanodesList();
        DatanodeInfo[] infos = new DatanodeInfo[proto.size()];
        for (int i = 0; i < infos.length; ++i) {
            infos[i] = PBHelper.convert(proto.get(i));
        }
        return infos;
    }

    public static BalancerBandwidthCommand convert(DatanodeProtocolProtos.BalancerBandwidthCommandProto balancerCmd) {
        return new BalancerBandwidthCommand(balancerCmd.getBandwidth());
    }

    public static DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto convert(ReceivedDeletedBlockInfo receivedDeletedBlockInfo) {
        DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto.BlockStatus status;
        DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto.Builder builder = DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto.newBuilder();
        switch (receivedDeletedBlockInfo.getStatus()) {
            case CREATING: {
                status = DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto.BlockStatus.CREATING;
                break;
            }
            case APPENDING: {
                status = DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto.BlockStatus.APPENDING;
                break;
            }
            case RECOVERING_APPEND: {
                status = DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto.BlockStatus.RECOVERING_APPEND;
                break;
            }
            case RECEIVED: {
                status = DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto.BlockStatus.RECEIVED;
                break;
            }
            case UPDATE_RECOVERED: {
                status = DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto.BlockStatus.UPDATE_RECOVERED;
                break;
            }
            case DELETED: {
                status = DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto.BlockStatus.DELETED;
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad status: " + (Object)((Object)receivedDeletedBlockInfo.getStatus()));
            }
        }
        builder.setStatus(status);
        if (receivedDeletedBlockInfo.getDelHints() != null) {
            builder.setDeleteHint(receivedDeletedBlockInfo.getDelHints());
        }
        return builder.setBlock(PBHelper.convert(receivedDeletedBlockInfo.getBlock())).build();
    }

    public static ReceivedDeletedBlockInfo convert(DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto proto) {
        ReceivedDeletedBlockInfo.BlockStatus status = null;
        switch (proto.getStatus()) {
            case CREATING: {
                status = ReceivedDeletedBlockInfo.BlockStatus.CREATING;
                break;
            }
            case APPENDING: {
                status = ReceivedDeletedBlockInfo.BlockStatus.APPENDING;
                break;
            }
            case RECOVERING_APPEND: {
                status = ReceivedDeletedBlockInfo.BlockStatus.RECOVERING_APPEND;
                break;
            }
            case RECEIVED: {
                status = ReceivedDeletedBlockInfo.BlockStatus.RECEIVED;
                break;
            }
            case UPDATE_RECOVERED: {
                status = ReceivedDeletedBlockInfo.BlockStatus.UPDATE_RECOVERED;
                break;
            }
            case DELETED: {
                status = ReceivedDeletedBlockInfo.BlockStatus.DELETED;
            }
        }
        return new ReceivedDeletedBlockInfo(PBHelper.convert(proto.getBlock()), status, proto.hasDeleteHint() ? proto.getDeleteHint() : null);
    }

    public static HdfsProtos.NamespaceInfoProto convert(NamespaceInfo info) {
        return HdfsProtos.NamespaceInfoProto.newBuilder().setBlockPoolID(info.getBlockPoolID()).setBuildVersion(info.getBuildVersion()).setUnused(0).setStorageInfo(PBHelper.convert((StorageInfo)info)).setSoftwareVersion(info.getSoftwareVersion()).build();
    }

    public static HdfsProtos.LocatedBlockProto[] convertLocatedBlock(LocatedBlock[] lb) {
        if (lb == null) {
            return null;
        }
        return PBHelper.convertLocatedBlock2(Arrays.asList(lb)).toArray(new HdfsProtos.LocatedBlockProto[lb.length]);
    }

    public static LocatedBlock[] convertLocatedBlock(HdfsProtos.LocatedBlockProto[] lb) {
        if (lb == null) {
            return null;
        }
        return PBHelper.convertLocatedBlock(Arrays.asList(lb)).toArray(new LocatedBlock[lb.length]);
    }

    public static List<LocatedBlock> convertLocatedBlock(List<HdfsProtos.LocatedBlockProto> lb) {
        if (lb == null) {
            return null;
        }
        int len = lb.size();
        ArrayList<LocatedBlock> result = new ArrayList<LocatedBlock>(len);
        for (HdfsProtos.LocatedBlockProto aLb : lb) {
            result.add(PBHelper.convert(aLb));
        }
        return result;
    }

    public static List<HdfsProtos.LocatedBlockProto> convertLocatedBlock2(List<LocatedBlock> lb) {
        if (lb == null) {
            return null;
        }
        int len = lb.size();
        ArrayList<HdfsProtos.LocatedBlockProto> result = new ArrayList<HdfsProtos.LocatedBlockProto>(len);
        for (LocatedBlock aLb : lb) {
            result.add(PBHelper.convert(aLb));
        }
        return result;
    }

    public static LocatedBlocks convert(HdfsProtos.LocatedBlocksProto lb) {
        LocatedBlocks locatedBlocks = new LocatedBlocks(lb.getFileLength(), lb.getUnderConstruction(), PBHelper.convertLocatedBlock(lb.getBlocksList()), lb.hasLastBlock() ? PBHelper.convert(lb.getLastBlock()) : null, lb.getIsLastBlockComplete());
        return locatedBlocks;
    }

    public static HdfsProtos.LocatedBlocksProto convert(LocatedBlocks lb) {
        if (lb == null) {
            return null;
        }
        HdfsProtos.LocatedBlocksProto.Builder builder = HdfsProtos.LocatedBlocksProto.newBuilder();
        if (lb.getLastLocatedBlock() != null) {
            builder.setLastBlock(PBHelper.convert(lb.getLastLocatedBlock()));
        }
        return builder.setFileLength(lb.getFileLength()).setUnderConstruction(lb.isUnderConstruction()).addAllBlocks(PBHelper.convertLocatedBlock2(lb.getLocatedBlocks())).setIsLastBlockComplete(lb.isLastBlockComplete()).build();
    }

    public static DataEncryptionKey convert(HdfsProtos.DataEncryptionKeyProto bet) {
        String encryptionAlgorithm = bet.getEncryptionAlgorithm();
        return new DataEncryptionKey(bet.getKeyId(), bet.getBlockPoolId(), bet.getNonce().toByteArray(), bet.getEncryptionKey().toByteArray(), bet.getExpiryDate(), encryptionAlgorithm.isEmpty() ? null : encryptionAlgorithm);
    }

    public static HdfsProtos.DataEncryptionKeyProto convert(DataEncryptionKey bet) {
        HdfsProtos.DataEncryptionKeyProto.Builder b = HdfsProtos.DataEncryptionKeyProto.newBuilder().setKeyId(bet.keyId).setBlockPoolId(bet.blockPoolId).setNonce(ByteString.copyFrom((byte[])bet.nonce)).setEncryptionKey(ByteString.copyFrom((byte[])bet.encryptionKey)).setExpiryDate(bet.expiryDate);
        if (bet.encryptionAlgorithm != null) {
            b.setEncryptionAlgorithm(bet.encryptionAlgorithm);
        }
        return b.build();
    }

    public static FsServerDefaults convert(HdfsProtos.FsServerDefaultsProto fs) {
        if (fs == null) {
            return null;
        }
        return new FsServerDefaults(fs.getBlockSize(), fs.getBytesPerChecksum(), fs.getWritePacketSize(), (short)fs.getReplication(), fs.getFileBufferSize(), fs.getEncryptDataTransfer(), fs.getTrashInterval(), PBHelper.convert(fs.getChecksumType()), fs.getQuotaEnabled());
    }

    public static HdfsProtos.FsServerDefaultsProto convert(FsServerDefaults fs) {
        if (fs == null) {
            return null;
        }
        return HdfsProtos.FsServerDefaultsProto.newBuilder().setBlockSize(fs.getBlockSize()).setBytesPerChecksum(fs.getBytesPerChecksum()).setWritePacketSize(fs.getWritePacketSize()).setReplication(fs.getReplication()).setFileBufferSize(fs.getFileBufferSize()).setEncryptDataTransfer(fs.getEncryptDataTransfer()).setTrashInterval(fs.getTrashInterval()).setChecksumType(PBHelper.convert(fs.getChecksumType())).setQuotaEnabled(fs.getQuotaEnabled()).build();
    }

    public static HdfsProtos.FsPermissionProto convert(FsPermission p) {
        if (p == null) {
            return null;
        }
        return HdfsProtos.FsPermissionProto.newBuilder().setPerm(p.toShort()).build();
    }

    public static FsPermission convert(HdfsProtos.FsPermissionProto p) {
        if (p == null) {
            return null;
        }
        return new FsPermission((short)p.getPerm());
    }

    public static int convertCreateFlag(EnumSetWritable<CreateFlag> flag) {
        int value = 0;
        if (flag.contains((Object)CreateFlag.APPEND)) {
            value |= ClientNamenodeProtocolProtos.CreateFlagProto.APPEND.getNumber();
        }
        if (flag.contains((Object)CreateFlag.CREATE)) {
            value |= ClientNamenodeProtocolProtos.CreateFlagProto.CREATE.getNumber();
        }
        if (flag.contains((Object)CreateFlag.OVERWRITE)) {
            value |= ClientNamenodeProtocolProtos.CreateFlagProto.OVERWRITE.getNumber();
        }
        return value;
    }

    public static EnumSetWritable<CreateFlag> convertCreateFlag(int flag) {
        EnumSet<CreateFlag> result = EnumSet.noneOf(CreateFlag.class);
        if ((flag & 4) == 4) {
            result.add(CreateFlag.APPEND);
        }
        if ((flag & 1) == 1) {
            result.add(CreateFlag.CREATE);
        }
        if ((flag & 2) == 2) {
            result.add(CreateFlag.OVERWRITE);
        }
        return new EnumSetWritable(result);
    }

    public static int convertCacheFlags(EnumSet<CacheFlag> flags) {
        int value = 0;
        if (flags.contains((Object)CacheFlag.FORCE)) {
            value |= ClientNamenodeProtocolProtos.CacheFlagProto.FORCE.getNumber();
        }
        return value;
    }

    public static EnumSet<CacheFlag> convertCacheFlags(int flags) {
        EnumSet<CacheFlag> result = EnumSet.noneOf(CacheFlag.class);
        if ((flags & 1) == 1) {
            result.add(CacheFlag.FORCE);
        }
        return result;
    }

    public static HdfsFileStatus convert(HdfsProtos.HdfsFileStatusProto fs) throws IOException {
        if (fs == null) {
            return null;
        }
        return new HdfsLocatedFileStatus(fs.getLength(), fs.getFileType().equals((Object)HdfsProtos.HdfsFileStatusProto.FileType.IS_DIR), fs.getBlockReplication(), fs.getBlocksize(), fs.getModificationTime(), fs.getAccessTime(), PBHelper.convert(fs.getPermission()), fs.getOwner(), fs.getGroup(), fs.getFileType().equals((Object)HdfsProtos.HdfsFileStatusProto.FileType.IS_SYMLINK) ? fs.getSymlink().toByteArray() : null, fs.getPath().toByteArray(), fs.hasFileId() ? fs.getFileId() : 0L, fs.hasLocations() ? PBHelper.convert(fs.getLocations()) : null, fs.hasChildrenNum() ? fs.getChildrenNum() : -1, fs.hasIsFileStoredInDB() ? fs.getIsFileStoredInDB() : false, fs.hasStoragePolicy() ? (byte)fs.getStoragePolicy() : (byte)0);
    }

    public static HdfsProtos.HdfsFileStatusProto convert(HdfsFileStatus fs) {
        LocatedBlocks locations;
        if (fs == null) {
            return null;
        }
        HdfsProtos.HdfsFileStatusProto.FileType fType = HdfsProtos.HdfsFileStatusProto.FileType.IS_FILE;
        if (fs.isDir()) {
            fType = HdfsProtos.HdfsFileStatusProto.FileType.IS_DIR;
        } else if (fs.isSymlink()) {
            fType = HdfsProtos.HdfsFileStatusProto.FileType.IS_SYMLINK;
        }
        HdfsProtos.HdfsFileStatusProto.Builder builder = HdfsProtos.HdfsFileStatusProto.newBuilder().setFileId(fs.getFileId()).setLength(fs.getLen()).setFileType(fType).setBlockReplication(fs.getReplication()).setBlocksize(fs.getBlockSize()).setModificationTime(fs.getModificationTime()).setAccessTime(fs.getAccessTime()).setPermission(PBHelper.convert(fs.getPermission())).setOwner(fs.getOwner()).setGroup(fs.getGroup()).setFileId(fs.getFileId()).setChildrenNum(fs.getChildrenNum()).setPath(ByteString.copyFrom((byte[])fs.getLocalNameInBytes())).setIsFileStoredInDB(fs.isFileStoredInDB()).setStoragePolicy(fs.getStoragePolicy());
        if (fs.isSymlink()) {
            builder.setSymlink(ByteString.copyFrom((byte[])fs.getSymlinkInBytes()));
        }
        if (fs instanceof HdfsLocatedFileStatus && (locations = ((HdfsLocatedFileStatus)fs).getBlockLocations()) != null) {
            builder.setLocations(PBHelper.convert(locations));
        }
        return builder.build();
    }

    public static HdfsProtos.HdfsFileStatusProto[] convert(HdfsFileStatus[] fs) {
        if (fs == null) {
            return null;
        }
        int len = fs.length;
        HdfsProtos.HdfsFileStatusProto[] result = new HdfsProtos.HdfsFileStatusProto[len];
        for (int i = 0; i < len; ++i) {
            result[i] = PBHelper.convert(fs[i]);
        }
        return result;
    }

    public static HdfsFileStatus[] convert(HdfsProtos.HdfsFileStatusProto[] fs) throws IOException {
        if (fs == null) {
            return null;
        }
        int len = fs.length;
        HdfsFileStatus[] result = new HdfsFileStatus[len];
        for (int i = 0; i < len; ++i) {
            result[i] = PBHelper.convert(fs[i]);
        }
        return result;
    }

    public static DirectoryListing convert(HdfsProtos.DirectoryListingProto dl) throws IOException {
        if (dl == null) {
            return null;
        }
        List<HdfsProtos.HdfsFileStatusProto> partList = dl.getPartialListingList();
        return new DirectoryListing(partList.isEmpty() ? new HdfsLocatedFileStatus[]{} : PBHelper.convert(partList.toArray(new HdfsProtos.HdfsFileStatusProto[partList.size()])), dl.getRemainingEntries());
    }

    public static HdfsProtos.DirectoryListingProto convert(DirectoryListing d) {
        if (d == null) {
            return null;
        }
        return HdfsProtos.DirectoryListingProto.newBuilder().addAllPartialListing(Arrays.asList(PBHelper.convert(d.getPartialListing()))).setRemainingEntries(d.getRemainingEntries()).build();
    }

    public static long[] convert(ClientNamenodeProtocolProtos.GetFsStatsResponseProto res) {
        long[] result = new long[]{res.getCapacity(), res.getUsed(), res.getRemaining(), res.getUnderReplicated(), res.getCorruptBlocks(), res.getMissingBlocks()};
        return result;
    }

    public static ClientNamenodeProtocolProtos.GetFsStatsResponseProto convert(long[] fsStats) {
        ClientNamenodeProtocolProtos.GetFsStatsResponseProto.Builder result = ClientNamenodeProtocolProtos.GetFsStatsResponseProto.newBuilder();
        if (fsStats.length >= 1) {
            result.setCapacity(fsStats[0]);
        }
        if (fsStats.length >= 2) {
            result.setUsed(fsStats[1]);
        }
        if (fsStats.length >= 3) {
            result.setRemaining(fsStats[2]);
        }
        if (fsStats.length >= 4) {
            result.setUnderReplicated(fsStats[3]);
        }
        if (fsStats.length >= 5) {
            result.setCorruptBlocks(fsStats[4]);
        }
        if (fsStats.length >= 6) {
            result.setMissingBlocks(fsStats[5]);
        }
        return result.build();
    }

    public static ClientNamenodeProtocolProtos.DatanodeReportTypeProto convert(HdfsConstants.DatanodeReportType t) {
        switch (t) {
            case ALL: {
                return ClientNamenodeProtocolProtos.DatanodeReportTypeProto.ALL;
            }
            case LIVE: {
                return ClientNamenodeProtocolProtos.DatanodeReportTypeProto.LIVE;
            }
            case DEAD: {
                return ClientNamenodeProtocolProtos.DatanodeReportTypeProto.DEAD;
            }
            case DECOMMISSIONING: {
                return ClientNamenodeProtocolProtos.DatanodeReportTypeProto.DECOMMISSIONING;
            }
        }
        throw new IllegalArgumentException("Unexpected data type report:" + (Object)((Object)t));
    }

    public static HdfsConstants.DatanodeReportType convert(ClientNamenodeProtocolProtos.DatanodeReportTypeProto t) {
        switch (t) {
            case ALL: {
                return HdfsConstants.DatanodeReportType.ALL;
            }
            case LIVE: {
                return HdfsConstants.DatanodeReportType.LIVE;
            }
            case DEAD: {
                return HdfsConstants.DatanodeReportType.DEAD;
            }
            case DECOMMISSIONING: {
                return HdfsConstants.DatanodeReportType.DECOMMISSIONING;
            }
        }
        throw new IllegalArgumentException("Unexpected data type report:" + (Object)((Object)t));
    }

    public static ClientNamenodeProtocolProtos.SafeModeActionProto convert(HdfsConstants.SafeModeAction a) {
        switch (a) {
            case SAFEMODE_LEAVE: {
                return ClientNamenodeProtocolProtos.SafeModeActionProto.SAFEMODE_LEAVE;
            }
            case SAFEMODE_ENTER: {
                return ClientNamenodeProtocolProtos.SafeModeActionProto.SAFEMODE_ENTER;
            }
            case SAFEMODE_GET: {
                return ClientNamenodeProtocolProtos.SafeModeActionProto.SAFEMODE_GET;
            }
        }
        throw new IllegalArgumentException("Unexpected SafeModeAction :" + (Object)((Object)a));
    }

    public static HdfsConstants.SafeModeAction convert(ClientNamenodeProtocolProtos.SafeModeActionProto a) {
        switch (a) {
            case SAFEMODE_LEAVE: {
                return HdfsConstants.SafeModeAction.SAFEMODE_LEAVE;
            }
            case SAFEMODE_ENTER: {
                return HdfsConstants.SafeModeAction.SAFEMODE_ENTER;
            }
            case SAFEMODE_GET: {
                return HdfsConstants.SafeModeAction.SAFEMODE_GET;
            }
        }
        throw new IllegalArgumentException("Unexpected SafeModeAction :" + (Object)((Object)a));
    }

    public static ClientNamenodeProtocolProtos.RollingUpgradeActionProto convert(HdfsConstants.RollingUpgradeAction a) {
        switch (a) {
            case QUERY: {
                return ClientNamenodeProtocolProtos.RollingUpgradeActionProto.QUERY;
            }
            case PREPARE: {
                return ClientNamenodeProtocolProtos.RollingUpgradeActionProto.START;
            }
            case FINALIZE: {
                return ClientNamenodeProtocolProtos.RollingUpgradeActionProto.FINALIZE;
            }
        }
        throw new IllegalArgumentException("Unexpected value: " + (Object)((Object)a));
    }

    public static HdfsConstants.RollingUpgradeAction convert(ClientNamenodeProtocolProtos.RollingUpgradeActionProto a) {
        switch (a) {
            case QUERY: {
                return HdfsConstants.RollingUpgradeAction.QUERY;
            }
            case START: {
                return HdfsConstants.RollingUpgradeAction.PREPARE;
            }
            case FINALIZE: {
                return HdfsConstants.RollingUpgradeAction.FINALIZE;
            }
        }
        throw new IllegalArgumentException("Unexpected value: " + (Object)((Object)a));
    }

    public static HdfsProtos.RollingUpgradeStatusProto convertRollingUpgradeStatus(RollingUpgradeStatus status) {
        return HdfsProtos.RollingUpgradeStatusProto.newBuilder().setBlockPoolId(status.getBlockPoolId()).build();
    }

    public static RollingUpgradeStatus convert(HdfsProtos.RollingUpgradeStatusProto proto) {
        return new RollingUpgradeStatus(proto.getBlockPoolId());
    }

    public static ClientNamenodeProtocolProtos.RollingUpgradeInfoProto convert(RollingUpgradeInfo info) {
        return ClientNamenodeProtocolProtos.RollingUpgradeInfoProto.newBuilder().setStatus(PBHelper.convertRollingUpgradeStatus(info)).setStartTime(info.getStartTime()).setFinalizeTime(info.getFinalizeTime()).build();
    }

    public static RollingUpgradeInfo convert(ClientNamenodeProtocolProtos.RollingUpgradeInfoProto proto) {
        HdfsProtos.RollingUpgradeStatusProto status = proto.getStatus();
        return new RollingUpgradeInfo(status.getBlockPoolId(), proto.getStartTime(), proto.getFinalizeTime());
    }

    public static CorruptFileBlocks convert(HdfsProtos.CorruptFileBlocksProto c) {
        if (c == null) {
            return null;
        }
        List<String> fileList = c.getFilesList();
        return new CorruptFileBlocks(fileList.toArray(new String[fileList.size()]), c.getCookie());
    }

    public static HdfsProtos.CorruptFileBlocksProto convert(CorruptFileBlocks c) {
        if (c == null) {
            return null;
        }
        return HdfsProtos.CorruptFileBlocksProto.newBuilder().addAllFiles(Arrays.asList(c.getFiles())).setCookie(c.getCookie()).build();
    }

    public static ContentSummary convert(HdfsProtos.ContentSummaryProto cs) {
        if (cs == null) {
            return null;
        }
        return new ContentSummary(cs.getLength(), cs.getFileCount(), cs.getDirectoryCount(), cs.getQuota(), cs.getSpaceConsumed(), cs.getSpaceQuota());
    }

    public static HdfsProtos.ContentSummaryProto convert(ContentSummary cs) {
        if (cs == null) {
            return null;
        }
        return HdfsProtos.ContentSummaryProto.newBuilder().setLength(cs.getLength()).setFileCount(cs.getFileCount()).setDirectoryCount(cs.getDirectoryCount()).setQuota(cs.getQuota()).setSpaceConsumed(cs.getSpaceConsumed()).setSpaceQuota(cs.getSpaceQuota()).build();
    }

    public static HdfsProtos.DatanodeStorageProto convert(DatanodeStorage s) {
        return HdfsProtos.DatanodeStorageProto.newBuilder().setState(PBHelper.convertState(s.getState())).setStorageType(PBHelper.convertStorageType(s.getStorageType())).setStorageUuid(s.getStorageID()).build();
    }

    private static HdfsProtos.DatanodeStorageProto.StorageState convertState(DatanodeStorage.State state) {
        switch (state) {
            case READ_ONLY_SHARED: {
                return HdfsProtos.DatanodeStorageProto.StorageState.READ_ONLY_SHARED;
            }
        }
        return HdfsProtos.DatanodeStorageProto.StorageState.NORMAL;
    }

    public static List<HdfsProtos.StorageTypeProto> convertStorageTypes(StorageType[] types) {
        return PBHelper.convertStorageTypes(types, 0);
    }

    public static List<HdfsProtos.StorageTypeProto> convertStorageTypes(StorageType[] types, int startIdx) {
        if (types == null) {
            return null;
        }
        ArrayList<HdfsProtos.StorageTypeProto> protos = new ArrayList<HdfsProtos.StorageTypeProto>(types.length);
        for (int i = startIdx; i < types.length; ++i) {
            protos.add(PBHelper.convertStorageType(types[i]));
        }
        return protos;
    }

    public static HdfsProtos.StorageTypeProto convertStorageType(StorageType type) {
        switch (type) {
            case DISK: {
                return HdfsProtos.StorageTypeProto.DISK;
            }
            case SSD: {
                return HdfsProtos.StorageTypeProto.SSD;
            }
            case RAID5: {
                return HdfsProtos.StorageTypeProto.RAID5;
            }
            case ARCHIVE: {
                return HdfsProtos.StorageTypeProto.ARCHIVE;
            }
        }
        Preconditions.checkState((boolean)false, (Object)("Failed to update StorageTypeProto with new StorageType " + type.toString()));
        return HdfsProtos.StorageTypeProto.DISK;
    }

    public static StorageType convertStorageType(HdfsProtos.StorageTypeProto type) {
        switch (type) {
            case DISK: {
                return StorageType.DISK;
            }
            case SSD: {
                return StorageType.SSD;
            }
            case RAID5: {
                return StorageType.RAID5;
            }
            case ARCHIVE: {
                return StorageType.ARCHIVE;
            }
        }
        throw new IllegalStateException("BUG: StorageTypeProto not found, type=" + (Object)((Object)type));
    }

    public static StorageType[] convertStorageTypes(List<HdfsProtos.StorageTypeProto> storageTypesList, int expectedSize) {
        StorageType[] storageTypes = new StorageType[expectedSize];
        if (storageTypesList.size() != expectedSize) {
            Preconditions.checkState((boolean)storageTypesList.isEmpty());
            Arrays.fill((Object[])storageTypes, (Object)StorageType.DEFAULT);
        } else {
            for (int i = 0; i < storageTypes.length; ++i) {
                storageTypes[i] = PBHelper.convertStorageType(storageTypesList.get(i));
            }
        }
        return storageTypes;
    }

    public static DatanodeStorage convert(HdfsProtos.DatanodeStorageProto s) {
        return new DatanodeStorage(s.getStorageUuid(), PBHelper.convertState(s.getState()), PBHelper.convertStorageType(s.getStorageType()));
    }

    private static DatanodeStorage.State convertState(HdfsProtos.DatanodeStorageProto.StorageState state) {
        switch (state) {
            case READ_ONLY_SHARED: {
                return DatanodeStorage.State.READ_ONLY_SHARED;
            }
        }
        return DatanodeStorage.State.NORMAL;
    }

    public static HdfsProtos.StorageReportProto convert(StorageReport r) {
        HdfsProtos.StorageReportProto.Builder builder = HdfsProtos.StorageReportProto.newBuilder().setBlockPoolUsed(r.getBlockPoolUsed()).setCapacity(r.getCapacity()).setDfsUsed(r.getDfsUsed()).setRemaining(r.getRemaining()).setStorageUuid(r.getStorage().getStorageID()).setStorage(PBHelper.convert(r.getStorage()));
        return builder.build();
    }

    public static StorageReport convert(HdfsProtos.StorageReportProto p) {
        return new StorageReport(p.hasStorage() ? PBHelper.convert(p.getStorage()) : new DatanodeStorage(p.getStorageUuid()), p.getFailed(), p.getCapacity(), p.getDfsUsed(), p.getRemaining(), p.getBlockPoolUsed());
    }

    public static StorageReport[] convertStorageReports(List<HdfsProtos.StorageReportProto> list) {
        StorageReport[] report = new StorageReport[list.size()];
        for (int i = 0; i < report.length; ++i) {
            report[i] = PBHelper.convert(list.get(i));
        }
        return report;
    }

    public static List<HdfsProtos.StorageReportProto> convertStorageReports(StorageReport[] storages) {
        ArrayList<HdfsProtos.StorageReportProto> protos = new ArrayList<HdfsProtos.StorageReportProto>(storages.length);
        for (int i = 0; i < storages.length; ++i) {
            protos.add(PBHelper.convert(storages[i]));
        }
        return protos;
    }

    public static DataChecksum.Type convert(HdfsProtos.ChecksumTypeProto type) {
        return DataChecksum.Type.valueOf((int)type.getNumber());
    }

    public static ClientNamenodeProtocolProtos.CacheDirectiveInfoProto convert(CacheDirectiveInfo info) {
        ClientNamenodeProtocolProtos.CacheDirectiveInfoProto.Builder builder = ClientNamenodeProtocolProtos.CacheDirectiveInfoProto.newBuilder();
        if (info.getId() != null) {
            builder.setId(info.getId());
        }
        if (info.getPath() != null) {
            builder.setPath(info.getPath().toUri().getPath());
        }
        if (info.getReplication() != null) {
            builder.setReplication(info.getReplication().shortValue());
        }
        if (info.getPool() != null) {
            builder.setPool(info.getPool());
        }
        if (info.getExpiration() != null) {
            builder.setExpiration(PBHelper.convert(info.getExpiration()));
        }
        return builder.build();
    }

    public static CacheDirectiveInfo convert(ClientNamenodeProtocolProtos.CacheDirectiveInfoProto proto) {
        CacheDirectiveInfo.Builder builder = new CacheDirectiveInfo.Builder();
        if (proto.hasId()) {
            builder.setId(proto.getId());
        }
        if (proto.hasPath()) {
            builder.setPath(new Path(proto.getPath()));
        }
        if (proto.hasReplication()) {
            builder.setReplication(Shorts.checkedCast((long)proto.getReplication()));
        }
        if (proto.hasPool()) {
            builder.setPool(proto.getPool());
        }
        if (proto.hasExpiration()) {
            builder.setExpiration(PBHelper.convert(proto.getExpiration()));
        }
        return builder.build();
    }

    public static ClientNamenodeProtocolProtos.CacheDirectiveInfoExpirationProto convert(CacheDirectiveInfo.Expiration expiration) {
        return ClientNamenodeProtocolProtos.CacheDirectiveInfoExpirationProto.newBuilder().setIsRelative(expiration.isRelative()).setMillis(expiration.getMillis()).build();
    }

    public static CacheDirectiveInfo.Expiration convert(ClientNamenodeProtocolProtos.CacheDirectiveInfoExpirationProto proto) {
        if (proto.getIsRelative()) {
            return CacheDirectiveInfo.Expiration.newRelative(proto.getMillis());
        }
        return CacheDirectiveInfo.Expiration.newAbsolute(proto.getMillis());
    }

    public static ClientNamenodeProtocolProtos.CacheDirectiveStatsProto convert(CacheDirectiveStats stats) {
        ClientNamenodeProtocolProtos.CacheDirectiveStatsProto.Builder builder = ClientNamenodeProtocolProtos.CacheDirectiveStatsProto.newBuilder();
        builder.setBytesNeeded(stats.getBytesNeeded());
        builder.setBytesCached(stats.getBytesCached());
        builder.setFilesNeeded(stats.getFilesNeeded());
        builder.setFilesCached(stats.getFilesCached());
        builder.setHasExpired(stats.hasExpired());
        return builder.build();
    }

    public static CacheDirectiveStats convert(ClientNamenodeProtocolProtos.CacheDirectiveStatsProto proto) {
        CacheDirectiveStats.Builder builder = new CacheDirectiveStats.Builder();
        builder.setBytesNeeded(proto.getBytesNeeded());
        builder.setBytesCached(proto.getBytesCached());
        builder.setFilesNeeded(proto.getFilesNeeded());
        builder.setFilesCached(proto.getFilesCached());
        builder.setHasExpired(proto.getHasExpired());
        return builder.build();
    }

    public static ClientNamenodeProtocolProtos.CacheDirectiveEntryProto convert(CacheDirectiveEntry entry) {
        ClientNamenodeProtocolProtos.CacheDirectiveEntryProto.Builder builder = ClientNamenodeProtocolProtos.CacheDirectiveEntryProto.newBuilder();
        builder.setInfo(PBHelper.convert(entry.getInfo()));
        builder.setStats(PBHelper.convert(entry.getStats()));
        return builder.build();
    }

    public static CacheDirectiveEntry convert(ClientNamenodeProtocolProtos.CacheDirectiveEntryProto proto) {
        CacheDirectiveInfo info = PBHelper.convert(proto.getInfo());
        CacheDirectiveStats stats = PBHelper.convert(proto.getStats());
        return new CacheDirectiveEntry(info, stats);
    }

    public static ClientNamenodeProtocolProtos.CachePoolInfoProto convert(CachePoolInfo info) {
        ClientNamenodeProtocolProtos.CachePoolInfoProto.Builder builder = ClientNamenodeProtocolProtos.CachePoolInfoProto.newBuilder();
        builder.setPoolName(info.getPoolName());
        if (info.getOwnerName() != null) {
            builder.setOwnerName(info.getOwnerName());
        }
        if (info.getGroupName() != null) {
            builder.setGroupName(info.getGroupName());
        }
        if (info.getMode() != null) {
            builder.setMode(info.getMode().toShort());
        }
        if (info.getLimit() != null) {
            builder.setLimit(info.getLimit());
        }
        if (info.getMaxRelativeExpiryMs() != null) {
            builder.setMaxRelativeExpiry(info.getMaxRelativeExpiryMs());
        }
        return builder.build();
    }

    public static CachePoolInfo convert(ClientNamenodeProtocolProtos.CachePoolInfoProto proto) {
        String poolName = (String)Preconditions.checkNotNull((Object)proto.getPoolName());
        CachePoolInfo info = new CachePoolInfo(poolName);
        if (proto.hasOwnerName()) {
            info.setOwnerName(proto.getOwnerName());
        }
        if (proto.hasGroupName()) {
            info.setGroupName(proto.getGroupName());
        }
        if (proto.hasMode()) {
            info.setMode(new FsPermission((short)proto.getMode()));
        }
        if (proto.hasLimit()) {
            info.setLimit(proto.getLimit());
        }
        if (proto.hasMaxRelativeExpiry()) {
            info.setMaxRelativeExpiryMs(proto.getMaxRelativeExpiry());
        }
        return info;
    }

    public static ClientNamenodeProtocolProtos.CachePoolStatsProto convert(CachePoolStats stats) {
        ClientNamenodeProtocolProtos.CachePoolStatsProto.Builder builder = ClientNamenodeProtocolProtos.CachePoolStatsProto.newBuilder();
        builder.setBytesNeeded(stats.getBytesNeeded());
        builder.setBytesCached(stats.getBytesCached());
        builder.setBytesOverlimit(stats.getBytesOverlimit());
        builder.setFilesNeeded(stats.getFilesNeeded());
        builder.setFilesCached(stats.getFilesCached());
        return builder.build();
    }

    public static CachePoolStats convert(ClientNamenodeProtocolProtos.CachePoolStatsProto proto) {
        CachePoolStats.Builder builder = new CachePoolStats.Builder();
        builder.setBytesNeeded(proto.getBytesNeeded());
        builder.setBytesCached(proto.getBytesCached());
        builder.setBytesOverlimit(proto.getBytesOverlimit());
        builder.setFilesNeeded(proto.getFilesNeeded());
        builder.setFilesCached(proto.getFilesCached());
        return builder.build();
    }

    public static ClientNamenodeProtocolProtos.CachePoolEntryProto convert(CachePoolEntry entry) {
        ClientNamenodeProtocolProtos.CachePoolEntryProto.Builder builder = ClientNamenodeProtocolProtos.CachePoolEntryProto.newBuilder();
        builder.setInfo(PBHelper.convert(entry.getInfo()));
        builder.setStats(PBHelper.convert(entry.getStats()));
        return builder.build();
    }

    public static CachePoolEntry convert(ClientNamenodeProtocolProtos.CachePoolEntryProto proto) {
        CachePoolInfo info = PBHelper.convert(proto.getInfo());
        CachePoolStats stats = PBHelper.convert(proto.getStats());
        return new CachePoolEntry(info, stats);
    }

    public static HdfsProtos.ChecksumTypeProto convert(DataChecksum.Type type) {
        return HdfsProtos.ChecksumTypeProto.valueOf(type.id);
    }

    public static HdfsProtos.DatanodeLocalInfoProto convert(DatanodeLocalInfo info) {
        HdfsProtos.DatanodeLocalInfoProto.Builder builder = HdfsProtos.DatanodeLocalInfoProto.newBuilder();
        builder.setSoftwareVersion(info.getSoftwareVersion());
        builder.setConfigVersion(info.getConfigVersion());
        builder.setUptime(info.getUptime());
        return builder.build();
    }

    public static DatanodeLocalInfo convert(HdfsProtos.DatanodeLocalInfoProto proto) {
        return new DatanodeLocalInfo(proto.getSoftwareVersion(), proto.getConfigVersion(), proto.getUptime());
    }

    public static InputStream vintPrefixed(InputStream input) throws IOException {
        int firstByte = input.read();
        if (firstByte == -1) {
            throw new EOFException("Premature EOF: no length prefix available");
        }
        int size = CodedInputStream.readRawVarint32((int)firstByte, (InputStream)input);
        assert (size >= 0);
        return new ExactSizeInputStream(input, size);
    }

    private static AclProtos.AclEntryProto.AclEntryScopeProto convert(AclEntryScope v) {
        return AclProtos.AclEntryProto.AclEntryScopeProto.valueOf(v.ordinal());
    }

    private static AclEntryScope convert(AclProtos.AclEntryProto.AclEntryScopeProto v) {
        return (AclEntryScope)PBHelper.castEnum((Enum)v, (Enum[])ACL_ENTRY_SCOPE_VALUES);
    }

    private static AclProtos.AclEntryProto.AclEntryTypeProto convert(AclEntryType e) {
        return AclProtos.AclEntryProto.AclEntryTypeProto.valueOf(e.ordinal());
    }

    private static AclEntryType convert(AclProtos.AclEntryProto.AclEntryTypeProto v) {
        return (AclEntryType)PBHelper.castEnum((Enum)v, (Enum[])ACL_ENTRY_TYPE_VALUES);
    }

    public static List<AclProtos.AclEntryProto> convertAclEntryProto(List<AclEntry> aclSpec) {
        ArrayList r = Lists.newArrayListWithCapacity((int)aclSpec.size());
        for (AclEntry e : aclSpec) {
            AclProtos.AclEntryProto.Builder builder = AclProtos.AclEntryProto.newBuilder();
            builder.setType(PBHelper.convert(e.getType()));
            builder.setScope(PBHelper.convert(e.getScope()));
            builder.setPermissions(PBHelper.convert(e.getPermission()));
            if (e.getName() != null) {
                builder.setName(e.getName());
            }
            r.add(builder.build());
        }
        return r;
    }

    public static List<AclEntry> convertAclEntry(List<AclProtos.AclEntryProto> aclSpec) {
        ArrayList r = Lists.newArrayListWithCapacity((int)aclSpec.size());
        for (AclProtos.AclEntryProto e : aclSpec) {
            AclEntry.Builder builder = new AclEntry.Builder();
            builder.setType(PBHelper.convert(e.getType()));
            builder.setScope(PBHelper.convert(e.getScope()));
            builder.setPermission(PBHelper.convert(e.getPermissions()));
            if (e.hasName()) {
                builder.setName(e.getName());
            }
            r.add(builder.build());
        }
        return r;
    }

    public static AclStatus convert(AclProtos.GetAclStatusResponseProto e) {
        AclProtos.AclStatusProto r = e.getResult();
        return new AclStatus.Builder().owner(r.getOwner()).group(r.getGroup()).stickyBit(r.getSticky()).addEntries(PBHelper.convertAclEntry(r.getEntriesList())).build();
    }

    public static AclProtos.GetAclStatusResponseProto convert(AclStatus e) {
        AclProtos.AclStatusProto r = AclProtos.AclStatusProto.newBuilder().setOwner(e.getOwner()).setGroup(e.getGroup()).setSticky(e.isStickyBit()).addAllEntries(PBHelper.convertAclEntryProto(e.getEntries())).build();
        return AclProtos.GetAclStatusResponseProto.newBuilder().setResult(r).build();
    }

    public static DataTransferProtos.ShortCircuitShmSlotProto convert(ShortCircuitShm.SlotId slotId) {
        return DataTransferProtos.ShortCircuitShmSlotProto.newBuilder().setShmId(PBHelper.convert(slotId.getShmId())).setSlotIdx(slotId.getSlotIdx()).build();
    }

    public static DataTransferProtos.ShortCircuitShmIdProto convert(ShortCircuitShm.ShmId shmId) {
        return DataTransferProtos.ShortCircuitShmIdProto.newBuilder().setHi(shmId.getHi()).setLo(shmId.getLo()).build();
    }

    public static ShortCircuitShm.SlotId convert(DataTransferProtos.ShortCircuitShmSlotProto slotId) {
        return new ShortCircuitShm.SlotId(PBHelper.convert(slotId.getShmId()), slotId.getSlotIdx());
    }

    public static ShortCircuitShm.ShmId convert(DataTransferProtos.ShortCircuitShmIdProto shmId) {
        return new ShortCircuitShm.ShmId(shmId.getHi(), shmId.getLo());
    }

    public static SortedActiveNodeList convert(DatanodeProtocolProtos.ActiveNamenodeListResponseProto p) {
        ArrayList<ActiveNode> anl = new ArrayList<ActiveNode>();
        List<ActiveNodeProtos.ActiveNodeProto> anlp = p.getNamenodesList();
        for (ActiveNodeProtos.ActiveNodeProto anAnlp : anlp) {
            ActiveNode an = PBHelper.convert(anAnlp);
            anl.add(an);
        }
        return new SortedActiveNodeListPBImpl(anl);
    }

    public static ActiveNode convert(ActiveNodeProtos.ActiveNodeProto p) {
        ActiveNodePBImpl an = new ActiveNodePBImpl(p.getId(), p.getRpcHostname(), p.getRpcIpAddress(), p.getRpcPort(), p.getHttpAddress(), p.getServiceIpAddress(), p.getServicePort());
        return an;
    }

    public static ActiveNodeProtos.ActiveNodeProto convert(ActiveNode p) {
        ActiveNodeProtos.ActiveNodeProto.Builder anp = ActiveNodeProtos.ActiveNodeProto.newBuilder();
        anp.setId(p.getId());
        anp.setRpcHostname(p.getHostname());
        anp.setRpcIpAddress(p.getRpcServerIpAddress());
        anp.setRpcPort(p.getRpcServerPort());
        anp.setHttpAddress(p.getHttpAddress());
        anp.setServiceIpAddress(p.getServiceRpcIpAddress());
        anp.setServicePort(p.getServiceRpcPort());
        return anp.build();
    }

    public static DatanodeProtocolProtos.ActiveNamenodeListResponseProto convert(SortedActiveNodeList anlWrapper) {
        List anl = anlWrapper.getActiveNodes();
        DatanodeProtocolProtos.ActiveNamenodeListResponseProto.Builder anlrpb = DatanodeProtocolProtos.ActiveNamenodeListResponseProto.newBuilder();
        for (ActiveNode anAnl : anl) {
            ActiveNodeProtos.ActiveNodeProto anp = PBHelper.convert(anAnl);
            anlrpb.addNamenodes(anp);
        }
        return anlrpb.build();
    }

    public static EncodingStatus convert(ClientNamenodeProtocolProtos.EncodingStatusProto encodingStatusProto) {
        EncodingStatus status = new EncodingStatus();
        if (encodingStatusProto.hasInodeId()) {
            status.setInodeId(Long.valueOf(encodingStatusProto.getInodeId()));
        }
        if (encodingStatusProto.hasParityInodeId()) {
            status.setParityInodeId(Long.valueOf(encodingStatusProto.getParityInodeId()));
        }
        status.setStatus(EncodingStatus.Status.values()[encodingStatusProto.getStatus()]);
        if (encodingStatusProto.hasParityStatus()) {
            status.setParityStatus(EncodingStatus.ParityStatus.values()[encodingStatusProto.getParityStatus()]);
        }
        if (encodingStatusProto.hasPolicy()) {
            status.setEncodingPolicy(PBHelper.convert(encodingStatusProto.getPolicy()));
        }
        if (encodingStatusProto.hasStatusModificationTime()) {
            status.setStatusModificationTime(Long.valueOf(encodingStatusProto.getStatusModificationTime()));
        }
        if (encodingStatusProto.hasParityStatusModificationTime()) {
            status.setParityStatusModificationTime(Long.valueOf(encodingStatusProto.getParityStatusModificationTime()));
        }
        if (encodingStatusProto.hasParityFileName()) {
            status.setParityFileName(encodingStatusProto.getParityFileName());
        }
        if (encodingStatusProto.hasLostBlocks()) {
            status.setLostBlocks(Integer.valueOf(encodingStatusProto.getLostBlocks()));
        }
        if (encodingStatusProto.hasLostParityBlocks()) {
            status.setLostParityBlocks(Integer.valueOf(encodingStatusProto.getLostParityBlocks()));
        }
        if (encodingStatusProto.hasRevoked()) {
            status.setRevoked(Boolean.valueOf(encodingStatusProto.getRevoked()));
        }
        return status;
    }

    public static ClientNamenodeProtocolProtos.EncodingStatusProto convert(EncodingStatus encodingStatus) {
        ClientNamenodeProtocolProtos.EncodingStatusProto.Builder builder = ClientNamenodeProtocolProtos.EncodingStatusProto.newBuilder();
        if (encodingStatus.getInodeId() != null) {
            builder.setInodeId(encodingStatus.getInodeId());
        }
        if (encodingStatus.getParityInodeId() != null) {
            builder.setParityInodeId(encodingStatus.getParityInodeId());
        }
        builder.setStatus(encodingStatus.getStatus().ordinal());
        if (encodingStatus.getParityStatus() != null) {
            builder.setParityStatus(encodingStatus.getParityStatus().ordinal());
        }
        if (encodingStatus.getEncodingPolicy() != null) {
            builder.setPolicy(PBHelper.convert(encodingStatus.getEncodingPolicy()));
        }
        if (encodingStatus.getStatusModificationTime() != null) {
            builder.setStatusModificationTime(encodingStatus.getStatusModificationTime());
        }
        if (encodingStatus.getParityStatusModificationTime() != null) {
            builder.setParityStatusModificationTime(encodingStatus.getParityStatusModificationTime());
        }
        if (encodingStatus.getParityFileName() != null) {
            builder.setParityFileName(encodingStatus.getParityFileName());
        }
        if (encodingStatus.getLostBlocks() != null) {
            builder.setLostBlocks(encodingStatus.getLostBlocks());
        }
        if (encodingStatus.getLostParityBlocks() != null) {
            builder.setLostParityBlocks(encodingStatus.getLostParityBlocks());
        }
        if (encodingStatus.getRevoked() != null) {
            builder.setRevoked(encodingStatus.getRevoked());
        }
        return builder.build();
    }

    public static ClientNamenodeProtocolProtos.EncodingPolicyProto convert(EncodingPolicy encodingPolicy) {
        ClientNamenodeProtocolProtos.EncodingPolicyProto.Builder builder = ClientNamenodeProtocolProtos.EncodingPolicyProto.newBuilder();
        builder.setCodec(encodingPolicy.getCodec());
        builder.setTargetReplication(encodingPolicy.getTargetReplication());
        return builder.build();
    }

    public static EncodingPolicy convert(ClientNamenodeProtocolProtos.EncodingPolicyProto encodingPolicyProto) {
        return new EncodingPolicy(encodingPolicyProto.getCodec(), (short)encodingPolicyProto.getTargetReplication());
    }

    public static byte[] convert(DatanodeProtocolProtos.SmallFileDataResponseProto response) {
        return response.getData().toByteArray();
    }

    public static DatanodeProtocolProtos.SmallFileDataResponseProto convert(byte[] data) {
        DatanodeProtocolProtos.SmallFileDataResponseProto.Builder responseProto = DatanodeProtocolProtos.SmallFileDataResponseProto.newBuilder();
        responseProto.setData(ByteString.copyFrom((byte[])data));
        return responseProto.build();
    }

    public static DatanodeProtocolProtos.BlockReportProto convert(BlockReport report) {
        ArrayList<DatanodeProtocolProtos.BlockReportBucketProto> bucketProtos = new ArrayList<DatanodeProtocolProtos.BlockReportBucketProto>();
        for (Bucket bucket : report.getBuckets()) {
            DatanodeProtocolProtos.BlockReportBucketProto.Builder bucketBuilder = DatanodeProtocolProtos.BlockReportBucketProto.newBuilder();
            for (ReportedBlock block : bucket.getBlocks()) {
                bucketBuilder.addBlocks(DatanodeProtocolProtos.BlockReportBlockProto.newBuilder().setBlockId(block.getBlockId()).setGenerationStamp(block.getGenerationStamp()).setLength(block.getLength()).setState(PBHelper.convert(block.getState())));
            }
            bucketProtos.add(bucketBuilder.build());
        }
        ArrayList<Long> hashes = new ArrayList<Long>();
        for (long hash : report.getHashes()) {
            hashes.add(hash);
        }
        return DatanodeProtocolProtos.BlockReportProto.newBuilder().addAllBuckets(bucketProtos).addAllHashes(hashes).build();
    }

    private static DatanodeProtocolProtos.BlockReportBlockProto.BlockReportBlockStateProto convert(BlockReportBlockState state) {
        switch (state) {
            case FINALIZED: {
                return DatanodeProtocolProtos.BlockReportBlockProto.BlockReportBlockStateProto.FINALIZED;
            }
            case RBW: {
                return DatanodeProtocolProtos.BlockReportBlockProto.BlockReportBlockStateProto.RBW;
            }
            case RUR: {
                return DatanodeProtocolProtos.BlockReportBlockProto.BlockReportBlockStateProto.RUR;
            }
            case RWR: {
                return DatanodeProtocolProtos.BlockReportBlockProto.BlockReportBlockStateProto.RWR;
            }
            case TEMPORARY: {
                return DatanodeProtocolProtos.BlockReportBlockProto.BlockReportBlockStateProto.TEMPORARY;
            }
        }
        throw new RuntimeException();
    }

    public static BlockReport convert(DatanodeProtocolProtos.BlockReportProto blockReportProto) {
        int numBuckets = blockReportProto.getBucketsCount();
        Bucket[] buckets = new Bucket[numBuckets];
        long[] hashes = new long[numBuckets];
        int numBlocks = 0;
        for (int i = 0; i < numBuckets; ++i) {
            DatanodeProtocolProtos.BlockReportBucketProto bucketProto = blockReportProto.getBuckets(i);
            int numBlocksInBucket = bucketProto.getBlocksCount();
            numBlocks += numBlocksInBucket;
            ReportedBlock[] blocks = new ReportedBlock[numBlocksInBucket];
            for (int j = 0; j < numBlocksInBucket; ++j) {
                DatanodeProtocolProtos.BlockReportBlockProto blockProto = bucketProto.getBlocks(j);
                blocks[j] = new ReportedBlock(blockProto.getBlockId(), blockProto.getGenerationStamp(), blockProto.getLength(), PBHelper.convert(blockProto.getState()));
            }
            Bucket bucket = new Bucket();
            bucket.setBlocks(blocks);
            buckets[i] = bucket;
            hashes[i] = blockReportProto.getHashes(i);
        }
        return new BlockReport(buckets, hashes, numBlocks);
    }

    private static BlockReportBlockState convert(DatanodeProtocolProtos.BlockReportBlockProto.BlockReportBlockStateProto state) {
        switch (state) {
            case FINALIZED: {
                return BlockReportBlockState.FINALIZED;
            }
            case RBW: {
                return BlockReportBlockState.RBW;
            }
            case RUR: {
                return BlockReportBlockState.RUR;
            }
            case RWR: {
                return BlockReportBlockState.RWR;
            }
            case TEMPORARY: {
                return BlockReportBlockState.TEMPORARY;
            }
        }
        throw new RuntimeException();
    }

    public static AclProtos.AclEntryProto.FsActionProto convert(FsAction v) {
        return AclProtos.AclEntryProto.FsActionProto.valueOf(v != null ? v.ordinal() : 0);
    }

    public static FsAction convert(AclProtos.AclEntryProto.FsActionProto v) {
        return (FsAction)PBHelper.castEnum((Enum)v, (Enum[])FSACTION_VALUES);
    }

    public static LastUpdatedContentSummary convert(ClientNamenodeProtocolProtos.LastUpdatedContentSummaryProto cs) {
        if (cs == null) {
            return null;
        }
        return new LastUpdatedContentSummary(cs.getFileandDirCount(), cs.getSpaceConsumed(), cs.getNsQuota(), cs.getDsQuota());
    }

    public static ClientNamenodeProtocolProtos.LastUpdatedContentSummaryProto convert(LastUpdatedContentSummary cs) {
        if (cs == null) {
            return null;
        }
        return ClientNamenodeProtocolProtos.LastUpdatedContentSummaryProto.newBuilder().setFileandDirCount(cs.getFileAndDirCount()).setNsQuota(cs.getNsQuota()).setSpaceConsumed(cs.getSpaceConsumed()).setDsQuota(cs.getDsQuota()).build();
    }

    public static BlockStoragePolicy[] convertStoragePolicies(List<HdfsProtos.BlockStoragePolicyProto> policyProtos) {
        if (policyProtos == null || policyProtos.size() == 0) {
            return new BlockStoragePolicy[0];
        }
        BlockStoragePolicy[] policies = new BlockStoragePolicy[policyProtos.size()];
        int i = 0;
        for (HdfsProtos.BlockStoragePolicyProto proto : policyProtos) {
            policies[i++] = PBHelper.convert(proto);
        }
        return policies;
    }

    public static BlockStoragePolicy convert(HdfsProtos.BlockStoragePolicyProto proto) {
        List<HdfsProtos.StorageTypeProto> cList = proto.getCreationPolicy().getStorageTypesList();
        StorageType[] creationTypes = PBHelper.convertStorageTypes(cList, cList.size());
        List<HdfsProtos.StorageTypeProto> cfList = proto.hasCreationFallbackPolicy() ? proto.getCreationFallbackPolicy().getStorageTypesList() : null;
        StorageType[] creationFallbackTypes = cfList == null ? StorageType.EMPTY_ARRAY : PBHelper.convertStorageTypes(cfList, cfList.size());
        List<HdfsProtos.StorageTypeProto> rfList = proto.hasReplicationFallbackPolicy() ? proto.getReplicationFallbackPolicy().getStorageTypesList() : null;
        StorageType[] replicationFallbackTypes = rfList == null ? StorageType.EMPTY_ARRAY : PBHelper.convertStorageTypes(rfList, rfList.size());
        return new BlockStoragePolicy((byte)proto.getPolicyId(), proto.getName(), creationTypes, creationFallbackTypes, replicationFallbackTypes);
    }

    public static HdfsProtos.BlockStoragePolicyProto convert(BlockStoragePolicy policy) {
        HdfsProtos.StorageTypesProto replicationFallbackProto;
        HdfsProtos.BlockStoragePolicyProto.Builder builder = HdfsProtos.BlockStoragePolicyProto.newBuilder().setPolicyId(policy.getId()).setName(policy.getName());
        HdfsProtos.StorageTypesProto creationProto = PBHelper.convert(policy.getStorageTypes());
        Preconditions.checkArgument((creationProto != null ? 1 : 0) != 0);
        builder.setCreationPolicy(creationProto);
        HdfsProtos.StorageTypesProto creationFallbackProto = PBHelper.convert(policy.getCreationFallbacks());
        if (creationFallbackProto != null) {
            builder.setCreationFallbackPolicy(creationFallbackProto);
        }
        if ((replicationFallbackProto = PBHelper.convert(policy.getReplicationFallbacks())) != null) {
            builder.setReplicationFallbackPolicy(replicationFallbackProto);
        }
        return builder.build();
    }

    public static HdfsProtos.StorageTypesProto convert(StorageType[] types) {
        if (types == null || types.length == 0) {
            return null;
        }
        List<HdfsProtos.StorageTypeProto> list = PBHelper.convertStorageTypes(types);
        return HdfsProtos.StorageTypesProto.newBuilder().addAllStorageTypes(list).build();
    }

    public static byte[] longToBytes(Long x) {
        if (x == null) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(x);
        return buffer.array();
    }

    public static Long bytesToLong(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.put(bytes);
        buffer.flip();
        return buffer.getLong();
    }
}

