/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.StorageType;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.VolumeChoosingPolicy;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.ReplicaMap;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.Time;

class FsVolumeList {
    private final AtomicReference<FsVolumeImpl[]> volumes = new AtomicReference<FsVolumeImpl[]>(new FsVolumeImpl[0]);
    private final VolumeChoosingPolicy<FsVolumeImpl> blockChooser;
    private volatile int numFailedVolumes;

    FsVolumeList(int failedVols, VolumeChoosingPolicy<FsVolumeImpl> blockChooser) {
        this.blockChooser = blockChooser;
        this.numFailedVolumes = failedVols;
    }

    int numberOfFailedVolumes() {
        return this.numFailedVolumes;
    }

    List<FsVolumeImpl> getVolumes() {
        return Collections.unmodifiableList(Arrays.asList((Object[])this.volumes.get()));
    }

    synchronized FsVolumeImpl getNextVolume(StorageType storageType, long blockSize) throws IOException {
        FsVolumeImpl[] curVolumes = this.volumes.get();
        ArrayList<FsVolumeImpl> list = new ArrayList<FsVolumeImpl>(curVolumes.length);
        for (FsVolumeImpl v : curVolumes) {
            if (v.getStorageType() != storageType) continue;
            list.add(v);
        }
        return this.blockChooser.chooseVolume(list, blockSize);
    }

    long getDfsUsed() throws IOException {
        long dfsUsed = 0L;
        for (FsVolumeImpl v : this.volumes.get()) {
            dfsUsed += v.getDfsUsed();
        }
        return dfsUsed;
    }

    long getBlockPoolUsed(String bpid) throws IOException {
        long dfsUsed = 0L;
        for (FsVolumeImpl v : this.volumes.get()) {
            dfsUsed += v.getBlockPoolUsed(bpid);
        }
        return dfsUsed;
    }

    long getCapacity() {
        long capacity = 0L;
        for (FsVolumeImpl v : this.volumes.get()) {
            capacity += v.getCapacity();
        }
        return capacity;
    }

    long getRemaining() throws IOException {
        long remaining = 0L;
        for (FsVolumeImpl vol : this.volumes.get()) {
            remaining += vol.getAvailable();
        }
        return remaining;
    }

    void getAllVolumesMap(final String bpid, final ReplicaMap volumeMap) throws IOException {
        long totalStartTime = System.currentTimeMillis();
        final List exceptions = Collections.synchronizedList(new ArrayList());
        ArrayList<1> replicaAddingThreads = new ArrayList<1>();
        for (final FsVolumeImpl v : this.volumes.get()) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        FsDatasetImpl.LOG.info((Object)("Adding replicas to map for block pool " + bpid + " on volume " + v + "..."));
                        long startTime = Time.monotonicNow();
                        v.getVolumeMap(bpid, volumeMap);
                        long timeTaken = Time.monotonicNow() - startTime;
                        FsDatasetImpl.LOG.info((Object)("Time to add replicas to map for block pool " + bpid + " on volume " + v + ": " + timeTaken + "ms"));
                    }
                    catch (ClosedChannelException e) {
                        FsDatasetImpl.LOG.info((Object)("The volume " + v + " is closed while addng replicas, ignored."));
                    }
                    catch (IOException ioe) {
                        FsDatasetImpl.LOG.info((Object)("Caught exception while adding replicas from " + v + ". Will throw later."), (Throwable)ioe);
                        exceptions.add(ioe);
                    }
                }
            };
            replicaAddingThreads.add(t);
            t.start();
        }
        for (Thread thread : replicaAddingThreads) {
            try {
                thread.join();
            }
            catch (InterruptedException ie) {
                throw new IOException(ie);
            }
        }
        if (!exceptions.isEmpty()) {
            throw (IOException)exceptions.get(0);
        }
        long totalTimeTaken = Time.monotonicNow() - totalStartTime;
        FsDatasetImpl.LOG.info((Object)("Total time to add all replicas to map: " + totalTimeTaken + "ms"));
    }

    synchronized List<FsVolumeImpl> checkDirs() {
        ArrayList<FsVolumeImpl> removedVols = null;
        List<FsVolumeImpl> volumeList = this.getVolumes();
        for (FsVolumeImpl fsv : volumeList) {
            try {
                fsv.checkDirs();
            }
            catch (DiskChecker.DiskErrorException e) {
                FsDatasetImpl.LOG.warn((Object)("Removing failed volume " + fsv + ": "), (Throwable)e);
                if (removedVols == null) {
                    removedVols = new ArrayList<FsVolumeImpl>(1);
                }
                removedVols.add(fsv);
                this.removeVolume(fsv);
                ++this.numFailedVolumes;
            }
        }
        if (removedVols != null && removedVols.size() > 0) {
            FsDatasetImpl.LOG.warn((Object)("Completed checkDirs. Removed " + removedVols.size() + " volumes. Current volumes: " + this));
        }
        return removedVols;
    }

    public String toString() {
        return Arrays.toString(this.volumes.get());
    }

    void addVolume(FsVolumeImpl newVolume) {
        while (true) {
            Object[] curVolumes = this.volumes.get();
            ArrayList volumeList = Lists.newArrayList((Object[])curVolumes);
            volumeList.add(newVolume);
            if (this.volumes.compareAndSet((FsVolumeImpl[])curVolumes, volumeList.toArray(new FsVolumeImpl[volumeList.size()]))) break;
            if (!FsDatasetImpl.LOG.isDebugEnabled()) continue;
            FsDatasetImpl.LOG.debug((Object)("The volume list has been changed concurrently, retry to remove volume: " + newVolume));
        }
        FsDatasetImpl.LOG.info((Object)("Added new volume: " + newVolume.toString()));
    }

    private void removeVolume(FsVolumeImpl target) {
        block2: {
            Object[] curVolumes;
            ArrayList volumeList;
            while ((volumeList = Lists.newArrayList((Object[])(curVolumes = this.volumes.get()))).remove(target)) {
                if (this.volumes.compareAndSet((FsVolumeImpl[])curVolumes, volumeList.toArray(new FsVolumeImpl[volumeList.size()]))) {
                    target.shutdown();
                    FsDatasetImpl.LOG.info((Object)("Removed volume: " + target));
                    break block2;
                }
                if (!FsDatasetImpl.LOG.isDebugEnabled()) continue;
                FsDatasetImpl.LOG.debug((Object)("The volume list has been changed concurrently, retry to remove volume: " + target));
            }
            if (!FsDatasetImpl.LOG.isDebugEnabled()) break block2;
            FsDatasetImpl.LOG.debug((Object)("Volume " + target + " does not exist or is removed by others."));
        }
    }

    void addBlockPool(final String bpid, final Configuration conf) throws IOException {
        long totalStartTime = Time.monotonicNow();
        final List exceptions = Collections.synchronizedList(new ArrayList());
        ArrayList<2> blockPoolAddingThreads = new ArrayList<2>();
        for (final FsVolumeImpl v : this.volumes.get()) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        FsDatasetImpl.LOG.info((Object)("Scanning block pool " + bpid + " on volume " + v + "..."));
                        long startTime = Time.monotonicNow();
                        v.addBlockPool(bpid, conf);
                        long timeTaken = Time.monotonicNow() - startTime;
                        FsDatasetImpl.LOG.info((Object)("Time taken to scan block pool " + bpid + " on " + v + ": " + timeTaken + "ms"));
                    }
                    catch (IOException ioe) {
                        FsDatasetImpl.LOG.info((Object)("Caught exception while scanning " + v + ". Will throw later."), (Throwable)ioe);
                        exceptions.add(ioe);
                    }
                }
            };
            blockPoolAddingThreads.add(t);
            t.start();
        }
        for (Thread thread : blockPoolAddingThreads) {
            try {
                thread.join();
            }
            catch (InterruptedException ie) {
                throw new IOException(ie);
            }
        }
        if (!exceptions.isEmpty()) {
            throw (IOException)exceptions.get(0);
        }
        long totalTimeTaken = Time.monotonicNow() - totalStartTime;
        FsDatasetImpl.LOG.info((Object)("Total time to scan all replicas for block pool " + bpid + ": " + totalTimeTaken + "ms"));
    }

    void removeBlockPool(String bpid) {
        for (FsVolumeImpl v : this.volumes.get()) {
            v.shutdownBlockPool(bpid);
        }
    }

    void shutdown() {
        for (FsVolumeImpl volume : this.volumes.get()) {
            if (volume == null) continue;
            volume.shutdown();
        }
    }
}

