/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.protobuf.InvalidProtocolBufferException;
import io.hops.common.IDsGeneratorFactory;
import io.hops.common.IDsMonitor;
import io.hops.common.INodeUtil;
import io.hops.erasure_coding.Codec;
import io.hops.erasure_coding.ErasureCodingManager;
import io.hops.exception.HDFSClientAppendToDBFileException;
import io.hops.exception.LockUpgradeException;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.leader_election.node.ActiveNode;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.HdfsVariables;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.common.entity.Variable;
import io.hops.metadata.hdfs.dal.BlockChecksumDataAccess;
import io.hops.metadata.hdfs.dal.CacheDirectiveDataAccess;
import io.hops.metadata.hdfs.dal.EncodingStatusDataAccess;
import io.hops.metadata.hdfs.dal.INodeDataAccess;
import io.hops.metadata.hdfs.dal.RetryCacheEntryDataAccess;
import io.hops.metadata.hdfs.dal.SafeBlocksDataAccess;
import io.hops.metadata.hdfs.entity.BlockChecksum;
import io.hops.metadata.hdfs.entity.EncodingPolicy;
import io.hops.metadata.hdfs.entity.EncodingStatus;
import io.hops.metadata.hdfs.entity.INodeIdentifier;
import io.hops.metadata.hdfs.entity.LeasePath;
import io.hops.metadata.hdfs.entity.MetadataLogEntry;
import io.hops.metadata.hdfs.entity.ProjectedINode;
import io.hops.metadata.hdfs.entity.RetryCacheEntry;
import io.hops.metadata.hdfs.entity.SubTreeOperation;
import io.hops.resolvingcache.Cache;
import io.hops.security.Users;
import io.hops.transaction.EntityManager;
import io.hops.transaction.context.RootINodeCache;
import io.hops.transaction.handler.EncodingStatusOperationType;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.handler.LightWeightRequestHandler;
import io.hops.transaction.lock.INodeLock;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BatchedRemoteIterator;
import org.apache.hadoop.fs.CacheFlag;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.DirectoryListingStartAfterNotFoundException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.InvalidPathException;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.protocol.AlreadyBeingCreatedException;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.CacheDirective;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveEntry;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.CachePoolEntry;
import org.apache.hadoop.hdfs.protocol.CachePoolInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LastUpdatedContentSummary;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.RecoveryInProgressException;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeException;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeInfo;
import org.apache.hadoop.hdfs.protocol.datatransfer.ReplaceDatanodeOnFailure;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenSecretManager;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSecretManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoUnderConstruction;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStatistics;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.HashBuckets;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.namenode.AbstractFileTree;
import org.apache.hadoop.hdfs.server.namenode.AclConfigFlag;
import org.apache.hadoop.hdfs.server.namenode.AclFeature;
import org.apache.hadoop.hdfs.server.namenode.AuditLogger;
import org.apache.hadoop.hdfs.server.namenode.CacheManager;
import org.apache.hadoop.hdfs.server.namenode.DirectoryWithQuotaFeature;
import org.apache.hadoop.hdfs.server.namenode.FSClusterStats;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.FileUnderConstructionFeature;
import org.apache.hadoop.hdfs.server.namenode.HdfsAuditLogger;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeAclHelper;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeSymlink;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.Lease;
import org.apache.hadoop.hdfs.server.namenode.LeaseExpiredException;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeMXBean;
import org.apache.hadoop.hdfs.server.namenode.Namesystem;
import org.apache.hadoop.hdfs.server.namenode.NotReplicatedYetException;
import org.apache.hadoop.hdfs.server.namenode.Quota;
import org.apache.hadoop.hdfs.server.namenode.QuotaUpdateException;
import org.apache.hadoop.hdfs.server.namenode.QuotaUpdateManager;
import org.apache.hadoop.hdfs.server.namenode.SafeModeException;
import org.apache.hadoop.hdfs.server.namenode.metrics.FSNamesystemMBean;
import org.apache.hadoop.hdfs.server.namenode.metrics.NameNodeMetrics;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.Phase;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StartupProgress;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.Status;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.Step;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StepType;
import org.apache.hadoop.hdfs.server.namenode.web.resources.NamenodeWebHdfsMethods;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorageReport;
import org.apache.hadoop.hdfs.server.protocol.HeartbeatResponse;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.StorageReceivedDeletedBlocks;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.NotALeaderException;
import org.apache.hadoop.ipc.RetriableException;
import org.apache.hadoop.ipc.RetryCache;
import org.apache.hadoop.ipc.RetryCacheDistributed;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.Timer;
import org.apache.hadoop.util.VersionInfo;
import org.apache.log4j.Appender;
import org.apache.log4j.AsyncAppender;
import org.apache.log4j.Logger;
import org.mortbay.util.ajax.JSON;

@InterfaceAudience.Private
@Metrics(context="dfs")
public class FSNamesystem
implements Namesystem,
FSClusterStats,
FSNamesystemMBean,
NameNodeMXBean {
    public static final Log LOG = LogFactory.getLog(FSNamesystem.class);
    private static final ThreadLocal<StringBuilder> auditBuffer = new ThreadLocal<StringBuilder>(){

        @Override
        protected StringBuilder initialValue() {
            return new StringBuilder();
        }
    };
    public static final Log auditLog = LogFactory.getLog((String)(FSNamesystem.class.getName() + ".audit"));
    static final int DEFAULT_MAX_CORRUPT_FILEBLOCKS_RETURNED = 100;
    static int BLOCK_DELETION_INCREMENT = 1000;
    private final boolean isPermissionEnabled;
    private final UserGroupInformation fsOwner;
    private final String fsOwnerShortUserName;
    private final String superGroup;
    private static final long DELEGATION_TOKEN_REMOVER_SCAN_INTERVAL = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.HOURS);
    private final DelegationTokenSecretManager dtSecretManager;
    private final boolean alwaysUseDelegationTokensForTests;
    private static final Step STEP_AWAITING_REPORTED_BLOCKS = new Step(StepType.AWAITING_REPORTED_BLOCKS);
    private final boolean isDefaultAuditLogger;
    private final List<AuditLogger> auditLoggers;
    FSDirectory dir;
    private final BlockManager blockManager;
    private final CacheManager cacheManager;
    private final DatanodeStatistics datanodeStatistics;
    private final boolean isStoragePolicyEnabled;
    private final String blockPoolId;
    final LeaseManager leaseManager = new LeaseManager(this);
    private volatile Daemon smmthread = null;
    private Daemon nnrmthread = null;
    private Daemon retryCacheCleanerThread = null;
    private volatile boolean hasResourcesAvailable = true;
    private volatile boolean fsRunning = true;
    private final long startTime = Time.now();
    private final long resourceRecheckInterval;
    private final FsServerDefaults serverDefaults;
    private final boolean supportAppends;
    private final ReplaceDatanodeOnFailure dtpReplaceDatanodeOnFailure;
    private final long maxFsObjects;
    private final long minBlockSize;
    private final long maxBlocksPerFile;
    private final long accessTimePrecision;
    private NameNode nameNode;
    private final Configuration conf;
    private final QuotaUpdateManager quotaUpdateManager;
    private final ExecutorService subtreeOperationsExecutor;
    private final boolean erasureCodingEnabled;
    private final ErasureCodingManager erasureCodingManager;
    private final boolean storeSmallFilesInDB;
    private static int DB_ON_DISK_FILE_MAX_SIZE;
    private static int DB_ON_DISK_SMALL_FILE_MAX_SIZE;
    private static int DB_ON_DISK_MEDIUM_FILE_MAX_SIZE;
    private static int DB_ON_DISK_LARGE_FILE_MAX_SIZE;
    private static int DB_IN_MEMORY_FILE_MAX_SIZE;
    private final long BIGGEST_DELETABLE_DIR;
    boolean initializedReplQueues = false;
    boolean shouldPopulateReplicationQueue = false;
    private volatile boolean startingActiveService = false;
    private final AclConfigFlag aclConfigFlag;
    private final RetryCacheDistributed retryCache;
    private boolean isTestingSTO = false;
    private ThreadLocal<Times> delays = new ThreadLocal();
    long delayBeforeSTOFlag = 0L;
    long delayAfterBuildingTree = 0L;
    private ObjectName mbeanName;
    private ObjectName mxbeanName;

    @VisibleForTesting
    private boolean isAuditEnabled() {
        return !this.isDefaultAuditLogger || auditLog.isInfoEnabled();
    }

    private HdfsFileStatus getAuditFileInfo(String path, boolean resolveSymlink) throws IOException {
        return this.isAuditEnabled() && this.isExternalInvocation() ? this.dir.getFileInfo(path, resolveSymlink, false) : null;
    }

    private void logAuditEvent(boolean succeeded, String cmd, String src) throws IOException {
        this.logAuditEvent(succeeded, cmd, src, null, null);
    }

    private void logAuditEvent(boolean succeeded, String cmd, String src, String dst, HdfsFileStatus stat) throws IOException {
        if (this.isAuditEnabled() && this.isExternalInvocation()) {
            this.logAuditEvent(succeeded, FSNamesystem.getRemoteUser(), FSNamesystem.getRemoteIp(), cmd, src, dst, stat);
        }
    }

    private void logAuditEvent(boolean succeeded, UserGroupInformation ugi, InetAddress addr, String cmd, String src, String dst, HdfsFileStatus stat) throws IOException {
        FileStatus status = null;
        if (stat != null) {
            Path symlink = stat.isSymlink() ? new Path(stat.getSymlink()) : null;
            Path path = dst != null ? new Path(dst) : new Path(src);
            status = new FileStatus(stat.getLen(), stat.isDir(), (int)stat.getReplication(), stat.getBlockSize(), stat.getModificationTime(), stat.getAccessTime(), stat.getPermission(), stat.getOwner(), stat.getGroup(), symlink, path);
        }
        for (AuditLogger logger : this.auditLoggers) {
            if (logger instanceof HdfsAuditLogger) {
                HdfsAuditLogger hdfsLogger = (HdfsAuditLogger)logger;
                hdfsLogger.logAuditEvent(succeeded, ugi.toString(), addr, cmd, src, dst, status, ugi, this.dtSecretManager);
                continue;
            }
            logger.logAuditEvent(succeeded, ugi.toString(), addr, cmd, src, dst, status);
        }
    }

    void clear() throws IOException {
        this.dir.reset();
        this.dtSecretManager.reset();
        this.leaseManager.removeAllLeases();
    }

    @VisibleForTesting
    LeaseManager getLeaseManager() {
        return this.leaseManager;
    }

    static FSNamesystem loadFromDisk(Configuration conf, NameNode namenode) throws IOException {
        FSNamesystem namesystem = new FSNamesystem(conf, namenode, false);
        HdfsServerConstants.StartupOption startOpt = NameNode.getStartupOption(conf);
        if (startOpt == HdfsServerConstants.StartupOption.RECOVER) {
            namesystem.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
        }
        if (HdfsServerConstants.RollingUpgradeStartupOption.ROLLBACK.matches(startOpt)) {
            FSNamesystem.rollBackRollingUpgradeTX();
        }
        long loadStart = Time.now();
        switch (startOpt) {
            case UPGRADE: {
                StorageInfo sinfo = StorageInfo.getStorageInfoFromDB();
                StorageInfo.updateStorageInfoToDB(sinfo, Time.now());
            }
        }
        namesystem.dir.imageLoadComplete();
        long timeTakenToLoadFSImage = Time.now() - loadStart;
        LOG.info((Object)("Finished loading FSImage in " + timeTakenToLoadFSImage + " ms"));
        NameNodeMetrics nnMetrics = NameNode.getNameNodeMetrics();
        if (nnMetrics != null) {
            nnMetrics.setFsImageLoadTime((int)timeTakenToLoadFSImage);
        }
        return namesystem;
    }

    FSNamesystem(Configuration conf, NameNode namenode) throws IOException {
        this(conf, namenode, false);
    }

    private FSNamesystem(Configuration conf, NameNode namenode, boolean ignoreRetryCache) throws IOException {
        try {
            DataChecksum.Type checksumType;
            if (conf.getBoolean("dfs.namenode.audit.log.async", false)) {
                LOG.info((Object)"Enabling async auditlog");
                FSNamesystem.enableAsyncAuditLog();
            }
            this.conf = conf;
            this.nameNode = namenode;
            this.resourceRecheckInterval = conf.getLong("dfs.namenode.resource.check.interval", 5000L);
            this.blockManager = new BlockManager(this, this, conf);
            this.erasureCodingEnabled = ErasureCodingManager.isErasureCodingEnabled(conf);
            this.erasureCodingManager = new ErasureCodingManager(this, conf);
            this.storeSmallFilesInDB = conf.getBoolean("dfs.store.small.files.in.db", false);
            DB_ON_DISK_FILE_MAX_SIZE = conf.getInt("dfs.db.file.max.size", 65536);
            DB_ON_DISK_LARGE_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.large.file.max.size", 65536);
            DB_ON_DISK_MEDIUM_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.medium.file.max.size", 4000);
            DB_ON_DISK_SMALL_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.small.file.max.size", 2000);
            DB_IN_MEMORY_FILE_MAX_SIZE = conf.getInt("dfs.db.inmemory.file.max.size", 1024);
            if (DB_IN_MEMORY_FILE_MAX_SIZE >= DB_ON_DISK_SMALL_FILE_MAX_SIZE || DB_ON_DISK_SMALL_FILE_MAX_SIZE >= DB_ON_DISK_MEDIUM_FILE_MAX_SIZE || DB_ON_DISK_MEDIUM_FILE_MAX_SIZE >= DB_ON_DISK_LARGE_FILE_MAX_SIZE || DB_ON_DISK_LARGE_FILE_MAX_SIZE != DB_ON_DISK_FILE_MAX_SIZE) {
                throw new IllegalArgumentException("The size for the database files is not correctly set");
            }
            this.datanodeStatistics = this.blockManager.getDatanodeManager().getDatanodeStatistics();
            this.isStoragePolicyEnabled = conf.getBoolean("dfs.storage.policy.enabled", true);
            this.fsOwner = UserGroupInformation.getCurrentUser();
            this.fsOwnerShortUserName = this.fsOwner.getShortUserName();
            this.superGroup = conf.get("dfs.permissions.superusergroup", "supergroup");
            this.isPermissionEnabled = conf.getBoolean("dfs.permissions.enabled", true);
            this.blockPoolId = StorageInfo.getStorageInfoFromDB().getBlockPoolId();
            this.blockManager.setBlockPoolId(this.blockPoolId);
            this.hopSpecificInitialization(conf);
            this.quotaUpdateManager = new QuotaUpdateManager(this, conf);
            this.subtreeOperationsExecutor = Executors.newFixedThreadPool(conf.getInt("dfs.namenode.subtree-executor-limit", 80));
            this.BIGGEST_DELETABLE_DIR = conf.getLong("dfs.dir.delete.batch.size", 50L);
            LOG.info((Object)("fsOwner             = " + this.fsOwner));
            LOG.info((Object)("superGroup          = " + this.superGroup));
            LOG.info((Object)("isPermissionEnabled = " + this.isPermissionEnabled));
            String checksumTypeStr = conf.get("dfs.checksum.type", "CRC32C");
            try {
                checksumType = DataChecksum.Type.valueOf((String)checksumTypeStr);
            }
            catch (IllegalArgumentException iae) {
                throw new IOException("Invalid checksum type in dfs.checksum.type: " + checksumTypeStr);
            }
            this.serverDefaults = new FsServerDefaults(conf.getLongBytes("dfs.blocksize", 0x8000000L), conf.getInt("dfs.bytes-per-checksum", 512), conf.getInt("dfs.client-write-packet-size", 65536), (short)conf.getInt("dfs.replication", 3), conf.getInt("io.file.buffer.size", 4096), conf.getBoolean("dfs.encrypt.data.transfer", false), conf.getLong("fs.trash.interval", 0L), checksumType, conf.getBoolean("dfs.namenode.quota.enabled", true));
            this.maxFsObjects = conf.getLong("dfs.namenode.max.objects", 0L);
            this.minBlockSize = conf.getLong("dfs.namenode.fs-limits.min-block-size", 0x100000L);
            this.maxBlocksPerFile = conf.getLong("dfs.namenode.fs-limits.max-blocks-per-file", 0x100000L);
            this.accessTimePrecision = conf.getLong("dfs.namenode.accesstime.precision", 3600000L);
            this.supportAppends = conf.getBoolean("dfs.support.append", true);
            LOG.info((Object)("Append Enabled: " + this.supportAppends));
            this.dtpReplaceDatanodeOnFailure = ReplaceDatanodeOnFailure.get(conf);
            this.alwaysUseDelegationTokensForTests = conf.getBoolean("dfs.namenode.delegation.token.always-use", false);
            this.dtSecretManager = this.createDelegationTokenSecretManager(conf);
            this.dir = new FSDirectory(this, conf);
            this.cacheManager = new CacheManager(this, conf, this.blockManager);
            this.auditLoggers = this.initAuditLoggers(conf);
            this.isDefaultAuditLogger = this.auditLoggers.size() == 1 && this.auditLoggers.get(0) instanceof DefaultAuditLogger;
            this.aclConfigFlag = new AclConfigFlag(conf);
            this.retryCache = ignoreRetryCache ? null : FSNamesystem.initRetryCache(conf);
        }
        catch (IOException | RuntimeException e) {
            LOG.error((Object)(this.getClass().getSimpleName() + " initialization failed."), (Throwable)e);
            this.close();
            throw e;
        }
    }

    @VisibleForTesting
    public RetryCacheDistributed getRetryCache() {
        return this.retryCache;
    }

    boolean hasRetryCache() {
        return this.retryCache != null;
    }

    void addCacheEntryWithPayload(byte[] clientId, int callId, Object payload) {
        if (this.retryCache != null) {
            this.retryCache.addCacheEntryWithPayload(clientId, callId, payload);
        }
    }

    void addCacheEntry(byte[] clientId, int callId) {
        if (this.retryCache != null) {
            this.retryCache.addCacheEntry(clientId, callId);
        }
    }

    @VisibleForTesting
    static RetryCacheDistributed initRetryCache(Configuration conf) {
        boolean enable = conf.getBoolean("dfs.namenode.enable.retrycache", true);
        LOG.info((Object)("Retry cache on namenode is " + (enable ? "enabled" : "disabled")));
        if (enable) {
            float heapPercent = conf.getFloat("dfs.namenode.retrycache.heap.percent", 0.03f);
            long entryExpiryMillis = conf.getLong("dfs.namenode.retrycache.expirytime.millis", 600000L);
            LOG.info((Object)("Retry cache will use " + heapPercent + " of total heap and retry cache entry expiry time is " + entryExpiryMillis + " millis"));
            return new RetryCacheDistributed("NameNodeRetryCache", (double)heapPercent, entryExpiryMillis);
        }
        return null;
    }

    private List<AuditLogger> initAuditLoggers(Configuration conf) {
        Collection alClasses = conf.getStringCollection("dfs.namenode.audit.loggers");
        ArrayList auditLoggers = Lists.newArrayList();
        if (alClasses != null && !alClasses.isEmpty()) {
            for (String className : alClasses) {
                try {
                    AuditLogger logger = "default".equals(className) ? new DefaultAuditLogger() : (AuditLogger)Class.forName(className).newInstance();
                    logger.initialize(conf);
                    auditLoggers.add(logger);
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (auditLoggers.isEmpty()) {
            auditLoggers.add(new DefaultAuditLogger());
        }
        return Collections.unmodifiableList(auditLoggers);
    }

    private void startSecretManager() {
        if (this.dtSecretManager != null) {
            try {
                this.dtSecretManager.startThreads();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void startSecretManagerIfNecessary() throws IOException {
        boolean shouldRun = this.shouldUseDelegationTokens() && !this.isInSafeMode();
        boolean running = this.dtSecretManager.isRunning();
        if (shouldRun && !running) {
            this.startSecretManager();
        }
    }

    private void stopSecretManager() {
        if (this.dtSecretManager != null) {
            this.dtSecretManager.stopThreads();
        }
    }

    void startCommonServices(Configuration conf) throws IOException {
        this.registerMBean();
        IDsMonitor.getInstance().start();
        RootINodeCache.start();
        if (this.isLeader()) {
            HdfsVariables.setSafeModeInfo(new SafeModeInfo(conf), -1L);
            assert (this.safeMode() != null && !this.isPopulatingReplQueues());
            StartupProgress prog = NameNode.getStartupProgress();
            prog.beginPhase(Phase.SAFEMODE);
            prog.setTotal(Phase.SAFEMODE, STEP_AWAITING_REPORTED_BLOCKS, this.getCompleteBlocksTotal());
            this.setBlockTotal();
        }
        this.shouldPopulateReplicationQueue = true;
        this.blockManager.activate(conf);
        if (this.dir.isQuotaEnabled()) {
            this.quotaUpdateManager.activate();
        }
        this.registerMXBean();
        DefaultMetricsSystem.instance().register((Object)this);
    }

    private void stopCommonServices() {
        if (this.blockManager != null) {
            this.blockManager.close();
        }
        if (this.quotaUpdateManager != null) {
            this.quotaUpdateManager.close();
        }
        RootINodeCache.stop();
        RetryCacheDistributed.clear((RetryCacheDistributed)this.retryCache);
    }

    void startActiveServices() throws IOException {
        this.startingActiveService = true;
        LOG.info((Object)"Starting services required for active state");
        LOG.info((Object)"Catching up to latest edits from old active before taking over writer role in edits logs");
        try {
            this.blockManager.getDatanodeManager().markAllDatanodesStale();
            if (this.isLeader()) {
                if (!this.isInSafeMode()) {
                    LOG.info((Object)"Reprocessing replication and invalidation queues");
                    this.initializeReplQueues();
                } else {
                    HdfsVariables.resetMisReplicatedIndex();
                }
            }
            this.leaseManager.startMonitor();
            this.startSecretManagerIfNecessary();
            this.nnrmthread = new Daemon((Runnable)new NameNodeResourceMonitor());
            this.nnrmthread.start();
            this.retryCacheCleanerThread = new Daemon((Runnable)new RetryCacheCleaner());
            this.retryCacheCleanerThread.start();
            if (this.erasureCodingEnabled) {
                this.erasureCodingManager.activate();
            }
            this.cacheManager.startMonitorThread();
        }
        finally {
            this.startingActiveService = false;
        }
    }

    private void initializeReplQueues() throws IOException {
        LOG.info((Object)"initializing replication queues");
        this.blockManager.processMisReplicatedBlocks();
        this.initializedReplQueues = true;
    }

    public boolean inTransitionToActive() {
        return this.startingActiveService;
    }

    private boolean shouldUseDelegationTokens() {
        return UserGroupInformation.isSecurityEnabled() || this.alwaysUseDelegationTokensForTests;
    }

    void stopActiveServices() {
        LOG.info((Object)"Stopping services started for active state");
        this.stopSecretManager();
        this.leaseManager.stopMonitor();
        if (this.nnrmthread != null) {
            ((NameNodeResourceMonitor)this.nnrmthread.getRunnable()).stopMonitor();
            this.nnrmthread.interrupt();
        }
        if (this.retryCacheCleanerThread != null) {
            ((RetryCacheCleaner)this.retryCacheCleanerThread.getRunnable()).stopMonitor();
            this.retryCacheCleanerThread.interrupt();
        }
        if (this.erasureCodingManager != null) {
            this.erasureCodingManager.close();
        }
        if (this.cacheManager != null) {
            this.cacheManager.stopMonitorThread();
        }
    }

    private void checkNameNodeSafeMode(String errorMsg) throws RetriableException, SafeModeException, IOException {
        if (this.isInSafeMode()) {
            SafeModeInfo safeMode = this.safeMode();
            SafeModeException se = new SafeModeException(errorMsg, safeMode);
            if (this.shouldRetrySafeMode(safeMode)) {
                throw new RetriableException((Exception)se);
            }
            throw se;
        }
    }

    private boolean shouldRetrySafeMode(SafeModeInfo safeMode) {
        if (safeMode == null) {
            return false;
        }
        return !safeMode.isManual() && !safeMode.areResourcesLow();
    }

    NamespaceInfo getNamespaceInfo() throws IOException {
        return this.unprotectedGetNamespaceInfo();
    }

    private NamespaceInfo unprotectedGetNamespaceInfo() throws IOException {
        StorageInfo storageInfo = StorageInfo.getStorageInfoFromDB();
        return new NamespaceInfo(storageInfo.getNamespaceID(), this.getClusterId(), this.getBlockPoolId(), storageInfo.getCTime());
    }

    void close() {
        this.fsRunning = false;
        try {
            this.stopCommonServices();
            if (this.smmthread != null) {
                this.smmthread.interrupt();
            }
            this.subtreeOperationsExecutor.shutdownNow();
        }
        catch (Throwable throwable) {
            try {
                this.stopActiveServices();
                if (this.dir != null) {
                    this.dir.close();
                }
            }
            catch (IOException ie) {
                LOG.error((Object)"Error closing FSDirectory", (Throwable)ie);
                IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{this.dir});
            }
            throw throwable;
        }
        try {
            this.stopActiveServices();
            if (this.dir != null) {
                this.dir.close();
            }
        }
        catch (IOException ie) {
            LOG.error((Object)"Error closing FSDirectory", (Throwable)ie);
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{this.dir});
        }
    }

    @Override
    public boolean isRunning() {
        return this.fsRunning;
    }

    long getDefaultBlockSize() {
        return this.serverDefaults.getBlockSize();
    }

    FsServerDefaults getServerDefaults() {
        return this.serverDefaults;
    }

    long getAccessTimePrecision() {
        return this.accessTimePrecision;
    }

    private boolean isAccessTimeSupported() {
        return this.accessTimePrecision > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPermissionSTO(String src1, final FsPermission permission) throws IOException {
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(src1);
        final String src = FSDirectory.resolvePath(src1, pathComponents, this.dir);
        boolean txFailed = true;
        final INodeIdentifier inode = this.lockSubtreeAndCheckPathPermission(src, true, null, null, null, null, SubTreeOperation.Type.SET_PERMISSION_STO);
        final boolean isSTO = inode != null;
        try {
            new HopsTransactionalRequestHandler(HDFSOperationType.SUBTREE_SETPERMISSION, src){

                public void acquireLock(TransactionLocks locks) throws IOException {
                    LockFactory lf = LockFactory.getInstance();
                    INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(!FSNamesystem.this.dir.isQuotaEnabled());
                    if (isSTO) {
                        il.setIgnoredSTOInodes(inode.getInodeId());
                    }
                    locks.add((Lock)il).add(lf.getBlockLock());
                }

                public Object performTask() throws IOException {
                    try {
                        FSNamesystem.this.setPermissionSTOInt(src, permission, isSTO);
                    }
                    catch (AccessControlException e) {
                        FSNamesystem.this.logAuditEvent(false, "setPermission", src);
                        throw e;
                    }
                    return null;
                }
            }.handle(this);
            txFailed = false;
        }
        finally {
            if (txFailed && inode != null) {
                this.unlockSubtree(src, inode.getInodeId());
            }
        }
    }

    private void setPermissionSTOInt(String src, FsPermission permission, boolean isSTO) throws IOException {
        FSPermissionChecker pc = this.getPermissionChecker();
        this.checkNameNodeSafeMode("Cannot set permission for " + src);
        this.checkOwner(pc, src);
        this.dir.setPermission(src, permission);
        HdfsFileStatus resultingStat = this.getAuditFileInfo(src, false);
        this.logAuditEvent(true, "setPermission", src, null, resultingStat);
        if (isSTO) {
            INodesInPath inodesInPath = this.dir.getINodesInPath(src, false);
            INode[] nodes = inodesInPath.getINodes();
            INode inode = nodes[nodes.length - 1];
            if (inode != null && inode.isSTOLocked()) {
                inode.setSubtreeLocked(false);
                EntityManager.update((Object)inode);
            }
            EntityManager.remove((Object)new SubTreeOperation(this.getSubTreeLockPathPrefix(src)));
        }
    }

    void setPermission(String src1, final FsPermission permission) throws IOException {
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(src1);
        final String src = FSDirectory.resolvePath(src1, pathComponents, this.dir);
        new HopsTransactionalRequestHandler(HDFSOperationType.SET_PERMISSION, src){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes());
                locks.add((Lock)il).add(lf.getBlockLock());
            }

            public Object performTask() throws IOException {
                try {
                    FSNamesystem.this.setPermissionInt(src, permission);
                }
                catch (AccessControlException e) {
                    FSNamesystem.this.logAuditEvent(false, "setPermission", src);
                    throw e;
                }
                return null;
            }
        }.handle(this);
    }

    private void setPermissionInt(String src, FsPermission permission) throws IOException {
        FSPermissionChecker pc = this.getPermissionChecker();
        this.checkNameNodeSafeMode("Cannot set permission for " + src);
        this.checkOwner(pc, src);
        this.dir.setPermission(src, permission);
        HdfsFileStatus resultingStat = this.getAuditFileInfo(src, false);
        this.logAuditEvent(true, "setPermission", src, null, resultingStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setOwnerSTO(String src1, final String username, final String group) throws IOException {
        this.saveTimes();
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(src1);
        final String src = FSDirectory.resolvePath(src1, pathComponents, this.dir);
        boolean txFailed = true;
        final INodeIdentifier inode = this.lockSubtreeAndCheckPathPermission(src, true, null, null, null, null, SubTreeOperation.Type.SET_OWNER_STO);
        final boolean isSTO = inode != null;
        try {
            new HopsTransactionalRequestHandler(HDFSOperationType.SET_OWNER_SUBTREE, src){

                public void acquireLock(TransactionLocks locks) throws IOException {
                    LockFactory lf = LockFactory.getInstance();
                    INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(!FSNamesystem.this.dir.isQuotaEnabled());
                    if (isSTO) {
                        il.setIgnoredSTOInodes(inode.getInodeId());
                    }
                    locks.add((Lock)il).add(lf.getBlockLock());
                }

                public Object performTask() throws IOException {
                    try {
                        FSNamesystem.this.setOwnerSTOInt(src, username, group, isSTO);
                    }
                    catch (AccessControlException e) {
                        FSNamesystem.this.logAuditEvent(false, "setOwner", src);
                        throw e;
                    }
                    return null;
                }
            }.handle(this);
            txFailed = false;
        }
        finally {
            if (txFailed && inode != null) {
                this.unlockSubtree(src, inode.getInodeId());
            }
        }
    }

    private void setOwnerSTOInt(String src, String username, String group, boolean isSTO) throws IOException {
        FSPermissionChecker pc = this.getPermissionChecker();
        this.checkNameNodeSafeMode("Cannot set owner for " + src);
        this.checkOwner(pc, src);
        if (!pc.isSuperUser()) {
            if (username != null && !pc.getUser().equals(username)) {
                throw new AccessControlException("Non-super user cannot change owner");
            }
            if (group != null && !pc.containsGroup(group)) {
                throw new AccessControlException("User does not belong to " + group);
            }
        }
        this.dir.setOwner(src, username, group);
        HdfsFileStatus resultingStat = this.getAuditFileInfo(src, false);
        this.logAuditEvent(true, "setOwner", src, null, resultingStat);
        if (isSTO) {
            INodesInPath inodesInPath = this.dir.getINodesInPath(src, false);
            INode[] nodes = inodesInPath.getINodes();
            INode inode = nodes[nodes.length - 1];
            if (inode != null && inode.isSTOLocked()) {
                inode.setSubtreeLocked(false);
                EntityManager.update((Object)inode);
            }
            EntityManager.remove((Object)new SubTreeOperation(this.getSubTreeLockPathPrefix(src)));
        }
    }

    void setOwner(final String src, final String username, final String group) throws IOException {
        new HopsTransactionalRequestHandler(HDFSOperationType.SET_OWNER, src){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes());
                locks.add((Lock)il).add(lf.getBlockLock());
            }

            public Object performTask() throws IOException {
                try {
                    FSNamesystem.this.setOwnerInt(src, username, group);
                }
                catch (AccessControlException e) {
                    FSNamesystem.this.logAuditEvent(false, "setOwner", src);
                    throw e;
                }
                return null;
            }
        }.handle(this);
    }

    private void setOwnerInt(String src, String username, String group) throws IOException {
        FSPermissionChecker pc = this.getPermissionChecker();
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(src);
        this.checkNameNodeSafeMode("Cannot set owner for " + src);
        src = FSDirectory.resolvePath(src, pathComponents, this.dir);
        this.checkOwner(pc, src);
        if (!pc.isSuperUser()) {
            if (username != null && !pc.getUser().equals(username)) {
                throw new AccessControlException("Non-super user cannot change owner");
            }
            if (group != null && !pc.containsGroup(group)) {
                throw new AccessControlException("User does not belong to " + group);
            }
        }
        this.dir.setOwner(src, username, group);
        HdfsFileStatus resultingStat = this.getAuditFileInfo(src, false);
        this.logAuditEvent(true, "setOwner", src, null, resultingStat);
    }

    public LocatedBlocks getBlockLocations(String clientMachine, String src, long offset, long length) throws IOException {
        try {
            return this.getBlockLocationsWithLock(clientMachine, src, offset, length, TransactionLockTypes.INodeLockType.READ);
        }
        catch (LockUpgradeException e) {
            LOG.debug((Object)("Encountered LockUpgradeException while reading " + src + ". Retrying the operation using exclusive locks"));
            return this.getBlockLocationsWithLock(clientMachine, src, offset, length, TransactionLockTypes.INodeLockType.WRITE);
        }
    }

    LocatedBlocks getBlockLocationsWithLock(final String clientMachine, String src1, final long offset, final long length, final TransactionLockTypes.INodeLockType lockType) throws IOException {
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(src1);
        final String src = FSDirectory.resolvePath(src1, pathComponents, this.dir);
        HopsTransactionalRequestHandler getBlockLocationsHandler = new HopsTransactionalRequestHandler(HDFSOperationType.GET_BLOCK_LOCATIONS, src){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(lockType, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(!FSNamesystem.this.dir.isQuotaEnabled());
                locks.add((Lock)il).add(lf.getBlockLock()).add(lf.getBlockRelated(LockFactory.BLK.RE, LockFactory.BLK.ER, LockFactory.BLK.CR, LockFactory.BLK.UC, LockFactory.BLK.CA));
                locks.add(lf.getAcesLock());
            }

            public Object performTask() throws IOException {
                LocatedBlocks blocks = FSNamesystem.this.getBlockLocationsInternal(src, offset, length, true, true, true);
                if (blocks != null && !blocks.hasPhantomBlock()) {
                    FSNamesystem.this.blockManager.getDatanodeManager().sortLocatedBlocks(clientMachine, blocks.getLocatedBlocks());
                    LocatedBlock lastBlock = blocks.getLastLocatedBlock();
                    if (lastBlock != null) {
                        ArrayList<LocatedBlock> lastBlockList = new ArrayList<LocatedBlock>();
                        lastBlockList.add(lastBlock);
                        FSNamesystem.this.blockManager.getDatanodeManager().sortLocatedBlocks(clientMachine, lastBlockList);
                    }
                }
                return blocks;
            }
        };
        LocatedBlocks locatedBlocks = (LocatedBlocks)getBlockLocationsHandler.handle(this);
        this.logAuditEvent(true, "open", src);
        return locatedBlocks;
    }

    public LocatedBlocks getBlockLocations(String src1, final long offset, final long length, final boolean doAccessTime, final boolean needBlockToken, final boolean checkSafeMode) throws IOException {
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(src1);
        final String src = FSDirectory.resolvePath(src1, pathComponents, this.dir);
        HopsTransactionalRequestHandler getBlockLocationsHandler = new HopsTransactionalRequestHandler(HDFSOperationType.GET_BLOCK_LOCATIONS, src){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.READ, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes());
                locks.add((Lock)il).add(lf.getBlockLock()).add(lf.getBlockRelated(LockFactory.BLK.RE, LockFactory.BLK.ER, LockFactory.BLK.CR, LockFactory.BLK.UC, LockFactory.BLK.CA));
            }

            public Object performTask() throws IOException {
                return FSNamesystem.this.getBlockLocationsInternal(src, offset, length, doAccessTime, needBlockToken, checkSafeMode);
            }
        };
        return (LocatedBlocks)getBlockLocationsHandler.handle(this);
    }

    private LocatedBlocks getBlockLocationsInternal(String src, long offset, long length, boolean doAccessTime, boolean needBlockToken, boolean checkSafeMode) throws IOException {
        FSPermissionChecker pc = this.getPermissionChecker();
        try {
            return this.getBlockLocationsInt(pc, src, offset, length, doAccessTime, needBlockToken, checkSafeMode);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "open", src);
            throw e;
        }
    }

    private LocatedBlocks getBlockLocationsInt(FSPermissionChecker pc, String src, long offset, long length, boolean doAccessTime, boolean needBlockToken, boolean checkSafeMode) throws IOException {
        LocatedBlocks ret;
        if (this.isPermissionEnabled) {
            this.checkPathAccess(pc, src, FsAction.READ);
        }
        if (offset < 0L) {
            throw new HadoopIllegalArgumentException("Negative offset is not supported. File: " + src);
        }
        if (length < 0L) {
            throw new HadoopIllegalArgumentException("Negative length is not supported. File: " + src);
        }
        INodeFile inodeFile = INodeFile.valueOf(this.dir.getINode(src), src);
        if (inodeFile.isFileStoredInDB()) {
            LOG.debug((Object)"SMALL_FILE The file is stored in the database. Returning Phantom Blocks");
            ret = this.getPhantomBlockLocationsUpdateTimes(src, offset, length, doAccessTime, needBlockToken);
        } else {
            ret = this.getBlockLocationsUpdateTimes(src, offset, length, doAccessTime, needBlockToken);
        }
        if (checkSafeMode && this.isInSafeMode()) {
            for (LocatedBlock b : ret.getLocatedBlocks()) {
                if (b.getLocations() != null && b.getLocations().length != 0) continue;
                SafeModeException se = new SafeModeException("Zero blocklocations for " + src, this.safeMode());
                throw new RetriableException((Exception)se);
            }
        }
        return ret;
    }

    private LocatedBlocks getPhantomBlockLocationsUpdateTimes(String src, long offset, long length, boolean doAccessTime, boolean needBlockToken) throws IOException {
        for (int attempt = 0; attempt < 2; ++attempt) {
            if (this.isInSafeMode()) {
                doAccessTime = false;
            }
            long now = Time.now();
            INodeFile inode = INodeFile.valueOf(this.dir.getINode(src), src);
            if (doAccessTime && this.isAccessTimeSupported()) {
                if (now <= inode.getAccessTime() + this.getAccessTimePrecision() && attempt == 0) continue;
                this.dir.setTimes(src, inode, -1L, now, false);
            }
            return this.blockManager.createPhantomLocatedBlocks(inode, inode.getFileDataInDB(), inode.isUnderConstruction(), needBlockToken);
        }
        return null;
    }

    private LocatedBlocks getBlockLocationsUpdateTimes(String src, long offset, long length, boolean doAccessTime, boolean needBlockToken) throws IOException {
        if (this.isInSafeMode()) {
            doAccessTime = false;
        }
        long now = Time.now();
        INodeFile inode = INodeFile.valueOf(this.dir.getINode(src), src);
        if (doAccessTime && this.isAccessTimeSupported()) {
            this.dir.setTimes(src, inode, -1L, now, false);
        }
        long fileSize = inode.computeFileSizeNotIncludingLastUcBlock();
        boolean isUc = inode.isUnderConstruction();
        LocatedBlocks blocks = this.blockManager.createLocatedBlocks(inode.getBlocks(), fileSize, isUc, offset, length, needBlockToken);
        for (LocatedBlock lb : blocks.getLocatedBlocks()) {
            this.cacheManager.setCachedLocations(lb, inode.getId());
        }
        return blocks;
    }

    void concat(final String target, final String[] srcs) throws IOException {
        final String[] paths = new String[srcs.length + 1];
        System.arraycopy(srcs, 0, paths, 0, srcs.length);
        paths[srcs.length] = target;
        new HopsTransactionalRequestHandler(HDFSOperationType.CONCAT){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE_ON_TARGET_AND_PARENT, TransactionLockTypes.INodeResolveType.PATH, paths).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes());
                locks.add((Lock)il).add(lf.getBlockLock()).add(lf.getBlockRelated(LockFactory.BLK.RE, LockFactory.BLK.CR, LockFactory.BLK.ER, LockFactory.BLK.PE, LockFactory.BLK.UC, LockFactory.BLK.IV)).add(lf.getRetryCacheEntryLock(Server.getClientId(), Server.getCallId()));
                if (FSNamesystem.this.erasureCodingEnabled) {
                    locks.add(lf.getEncodingStatusLock(TransactionLockTypes.LockType.WRITE, srcs));
                }
                locks.add(lf.getAcesLock());
            }

            public Object performTask() throws IOException {
                RetryCache.CacheEntry cacheEntry = RetryCacheDistributed.waitForCompletion((RetryCacheDistributed)FSNamesystem.this.retryCache);
                if (cacheEntry != null && cacheEntry.isSuccess()) {
                    return null;
                }
                boolean success = false;
                try {
                    FSNamesystem.this.concatInt(target, srcs);
                    success = true;
                }
                catch (AccessControlException e) {
                    FSNamesystem.this.logAuditEvent(false, "concat", Arrays.toString(srcs), target, null);
                    throw e;
                }
                finally {
                    RetryCacheDistributed.setState((RetryCache.CacheEntry)cacheEntry, (boolean)success);
                }
                return null;
            }
        }.handle(this);
    }

    private void concatInt(String target, String[] srcs) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("concat " + Arrays.toString(srcs) + " to " + target));
        }
        if (target.isEmpty()) {
            throw new IllegalArgumentException("Target file name is empty");
        }
        if (srcs == null || srcs.length == 0) {
            throw new IllegalArgumentException("No sources given");
        }
        String trgParent = target.substring(0, target.lastIndexOf(47));
        for (String s : srcs) {
            String srcParent = s.substring(0, s.lastIndexOf(47));
            if (srcParent.equals(trgParent)) continue;
            throw new IllegalArgumentException("Sources and target are not in the same directory");
        }
        FSPermissionChecker pc = this.getPermissionChecker();
        this.checkNameNodeSafeMode("Cannot concat " + target);
        this.concatInternal(pc, target, srcs);
        HdfsFileStatus resultingStat = this.getAuditFileInfo(target, false);
        this.logAuditEvent(true, "concat", Arrays.toString(srcs), target, resultingStat);
    }

    private void concatInternal(FSPermissionChecker pc, String target, String[] srcs) throws IOException {
        BlockInfo last;
        if (this.isPermissionEnabled) {
            this.checkPathAccess(pc, target, FsAction.WRITE);
            for (String aSrc : srcs) {
                this.checkPathAccess(pc, aSrc, FsAction.READ);
                this.checkParentAccess(pc, aSrc, FsAction.WRITE);
            }
        }
        HashSet<INodeFile> si = new HashSet<INodeFile>();
        INodeFile trgInode = INodeFile.valueOf(this.dir.getINode(target), target);
        if (trgInode.isFileStoredInDB()) {
            throw new IOException("The target file is stored in the database. Can not concat to a a file stored in the database");
        }
        if (trgInode.isUnderConstruction()) {
            throw new HadoopIllegalArgumentException("concat: target file " + target + " is under construction");
        }
        if (trgInode.numBlocks() == 0) {
            throw new HadoopIllegalArgumentException("concat: target file " + target + " is empty");
        }
        long blockSize = trgInode.getPreferredBlockSize();
        if (blockSize != (last = trgInode.getLastBlock()).getNumBytes()) {
            throw new HadoopIllegalArgumentException("The last block in " + target + " is not full; last block size = " + last.getNumBytes() + " but file block size = " + blockSize);
        }
        si.add(trgInode);
        short replication = trgInode.getBlockReplication();
        boolean endSrc = false;
        for (int i = 0; i < srcs.length; ++i) {
            INodeFile srcInode;
            String src = srcs[i];
            if (i == srcs.length - 1) {
                endSrc = true;
            }
            if ((srcInode = INodeFile.valueOf(this.dir.getINode(src), src)).isFileStoredInDB()) {
                throw new IOException(src + " is stored in the database. Can not concat to a a file stored in the database");
            }
            if (src.isEmpty() || srcInode.isUnderConstruction() || srcInode.numBlocks() == 0) {
                throw new HadoopIllegalArgumentException("concat: source file " + src + " is invalid or empty or underConstruction");
            }
            if (replication != srcInode.getBlockReplication()) {
                throw new HadoopIllegalArgumentException("concat: the source file " + src + " and the target file " + target + " should have the same replication: source replication is " + srcInode.getBlockReplication() + " but target replication is " + replication);
            }
            BlockInfo[] srcBlocks = srcInode.getBlocks();
            int idx = srcBlocks.length - 1;
            if (endSrc) {
                idx = srcBlocks.length - 2;
            }
            if (idx >= 0 && srcBlocks[idx].getNumBytes() != blockSize) {
                throw new HadoopIllegalArgumentException("concat: the source file " + src + " and the target file " + target + " should have the same blocks sizes: target block size is " + blockSize + " but the size of source block " + idx + " is " + srcBlocks[idx].getNumBytes());
            }
            si.add(srcInode);
        }
        if (si.size() < srcs.length + 1) {
            throw new HadoopIllegalArgumentException("concat: at least two of the source files are the same");
        }
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.concat: " + Arrays.toString(srcs) + " to " + target));
        }
        this.dir.concat(target, srcs);
    }

    void setTimes(String src1, final long mtime, final long atime) throws IOException {
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(src1);
        final String src = FSDirectory.resolvePath(src1, pathComponents, this.dir);
        new HopsTransactionalRequestHandler(HDFSOperationType.SET_TIMES, src){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes());
                locks.add((Lock)il).add(lf.getBlockLock());
                locks.add(lf.getAcesLock());
            }

            public Object performTask() throws IOException {
                try {
                    FSNamesystem.this.setTimesInt(src, mtime, atime);
                }
                catch (AccessControlException e) {
                    FSNamesystem.this.logAuditEvent(false, "setTimes", src);
                    throw e;
                }
                return null;
            }
        }.handle(this);
    }

    private void setTimesInt(String src, long mtime, long atime) throws IOException {
        INode inode;
        if (!this.isAccessTimeSupported() && atime != -1L) {
            throw new IOException("Access time for hdfs is not configured.  Please set dfs.namenode.accesstime.precision configuration parameter.");
        }
        FSPermissionChecker pc = this.getPermissionChecker();
        if (this.isPermissionEnabled) {
            this.checkPathAccess(pc, src, FsAction.WRITE);
        }
        if ((inode = this.dir.getINode(src)) == null) {
            throw new FileNotFoundException("File/Directory " + src + " does not exist.");
        }
        this.dir.setTimes(src, inode, mtime, atime, true);
        HdfsFileStatus resultingStat = this.getAuditFileInfo(src, false);
        this.logAuditEvent(true, "setTimes", src, null, resultingStat);
    }

    void createSymlink(final String target, String link1, final PermissionStatus dirPerms, final boolean createParent) throws IOException {
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(link1);
        final String link = FSDirectory.resolvePath(link1, pathComponents, this.dir);
        new HopsTransactionalRequestHandler(HDFSOperationType.CREATE_SYM_LINK, link){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, link).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes());
                locks.add((Lock)il).add(lf.getAcesLock()).add(lf.getRetryCacheEntryLock(Server.getClientId(), Server.getCallId()));
            }

            public Object performTask() throws IOException {
                RetryCache.CacheEntry cacheEntry = RetryCacheDistributed.waitForCompletion((RetryCacheDistributed)FSNamesystem.this.retryCache);
                if (cacheEntry != null && cacheEntry.isSuccess()) {
                    return null;
                }
                boolean success = false;
                try {
                    FSNamesystem.this.createSymlinkInt(target, link, dirPerms, createParent);
                    success = true;
                }
                catch (AccessControlException e) {
                    FSNamesystem.this.logAuditEvent(false, "createSymlink", link, target, null);
                    throw e;
                }
                finally {
                    RetryCacheDistributed.setState((RetryCache.CacheEntry)cacheEntry, (boolean)success);
                }
                return null;
            }
        }.handle(this);
    }

    private void createSymlinkInt(String target, String link, PermissionStatus dirPerms, boolean createParent) throws IOException {
        FSPermissionChecker pc = this.getPermissionChecker();
        if (!createParent) {
            this.verifyParentDir(link);
        }
        this.createSymlinkInternal(pc, target, link, dirPerms, createParent);
        HdfsFileStatus resultingStat = this.getAuditFileInfo(link, false);
        this.logAuditEvent(true, "createSymlink", link, target, resultingStat);
    }

    private void createSymlinkInternal(FSPermissionChecker pc, String target, String link, PermissionStatus dirPerms, boolean createParent) throws IOException {
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.createSymlink: target=" + target + " link=" + link));
        }
        this.checkNameNodeSafeMode("Cannot create symlink " + link);
        if (FSDirectory.isReservedName(target)) {
            throw new InvalidPathException("Invalid target name: " + target);
        }
        if (!DFSUtil.isValidName(link)) {
            throw new InvalidPathException("Invalid file name: " + link);
        }
        if (!this.dir.isValidToCreate(link)) {
            throw new IOException("failed to create link " + link + " either because the filename is invalid or the file exists");
        }
        if (this.isPermissionEnabled) {
            this.checkAncestorAccess(pc, link, FsAction.WRITE);
        }
        this.checkFsObjectLimit();
        this.dir.addSymlink(link, target, dirPerms, createParent);
    }

    boolean setReplication(String src1, final short replication) throws IOException {
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(src1);
        final String src = FSDirectory.resolvePath(src1, pathComponents, this.dir);
        HopsTransactionalRequestHandler setReplicationHandler = new HopsTransactionalRequestHandler(HDFSOperationType.SET_REPLICATION, src){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE_ON_TARGET_AND_PARENT, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(!FSNamesystem.this.dir.isQuotaEnabled());
                locks.add((Lock)il).add(lf.getBlockLock()).add(lf.getBlockRelated(LockFactory.BLK.RE, LockFactory.BLK.ER, LockFactory.BLK.CR, LockFactory.BLK.UC, LockFactory.BLK.UR, LockFactory.BLK.IV)).add(lf.getAcesLock());
            }

            public Object performTask() throws IOException {
                try {
                    return FSNamesystem.this.setReplicationInt(src, replication);
                }
                catch (AccessControlException e) {
                    FSNamesystem.this.logAuditEvent(false, "setReplication", src);
                    throw e;
                }
            }
        };
        return (Boolean)setReplicationHandler.handle(this);
    }

    private boolean setReplicationInt(String src, short replication) throws IOException {
        boolean isFile;
        this.blockManager.verifyReplication(src, replication, null);
        FSPermissionChecker pc = this.getPermissionChecker();
        this.checkNameNodeSafeMode("Cannot set replication for " + src);
        if (this.isPermissionEnabled) {
            this.checkPathAccess(pc, src, FsAction.WRITE);
        }
        INode targetNode = this.getINode(src);
        short[] oldReplication = new short[1];
        Block[] blocks = this.dir.setReplication(src, replication, oldReplication);
        boolean bl = isFile = blocks != null;
        if (isFile && !((INodeFile)targetNode).isFileStoredInDB()) {
            this.blockManager.setReplication(oldReplication[0], replication, src, blocks);
        }
        if (isFile) {
            this.logAuditEvent(true, "setReplication", src);
        }
        return isFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMetaEnabled(final String src, final boolean metaEnabled) throws IOException {
        INodeIdentifier stoRootINode = null;
        try {
            stoRootINode = this.lockSubtree(src, SubTreeOperation.Type.META_ENABLE_STO);
            final AbstractFileTree.FileTree fileTree = this.buildTreeForLogging(stoRootINode, metaEnabled);
            new HopsTransactionalRequestHandler(HDFSOperationType.SET_META_ENABLED, src){

                public void acquireLock(TransactionLocks locks) throws IOException {
                    long stoRootINodeId = (Long)this.getParams()[0];
                    LockFactory lf = LockFactory.getInstance();
                    INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes());
                    il.setIgnoredSTOInodes(stoRootINodeId);
                    locks.add((Lock)il);
                    locks.add(lf.getAcesLock());
                }

                public Object performTask() throws IOException {
                    try {
                        if (metaEnabled) {
                            FSNamesystem.this.logMetadataEvents(fileTree, MetadataLogEntry.Operation.ADD);
                        }
                        FSNamesystem.this.setMetaEnabledInt(src, metaEnabled);
                    }
                    catch (AccessControlException e) {
                        FSNamesystem.this.logAuditEvent(false, "setMetaEnabled", src);
                        throw e;
                    }
                    return null;
                }
            }.setParams(new Object[]{stoRootINode.getInodeId()}).handle((Object)this);
        }
        finally {
            if (stoRootINode != null) {
                this.unlockSubtree(src, stoRootINode.getInodeId());
            }
        }
    }

    private AbstractFileTree.FileTree buildTreeForLogging(INodeIdentifier inode, boolean metaEnabled) throws IOException {
        if (!metaEnabled) {
            return null;
        }
        AbstractFileTree.FileTree fileTree = new AbstractFileTree.FileTree(this, inode);
        fileTree.buildUp();
        return fileTree;
    }

    private void setMetaEnabledInt(String src, boolean metaEnabled) throws IOException {
        INode targetNode;
        FSPermissionChecker pc = this.getPermissionChecker();
        this.checkNameNodeSafeMode("Cannot set metaEnabled for " + src);
        if (this.isPermissionEnabled) {
            this.checkPathAccess(pc, src, FsAction.WRITE);
        }
        if (!(targetNode = this.getINode(src)).isDirectory()) {
            throw new FileNotFoundException(src + ": Is not a directory");
        }
        INodeDirectory dirNode = (INodeDirectory)targetNode;
        dirNode.setMetaEnabled(metaEnabled);
        EntityManager.update((Object)dirNode);
    }

    private void logMetadataEvents(AbstractFileTree.FileTree fileTree, MetadataLogEntry.Operation operation) throws IOException {
        ProjectedINode dataSetDir = fileTree.getSubtreeRoot();
        ArrayList<MetadataLogEntry> logEntries = new ArrayList<MetadataLogEntry>(fileTree.getAllChildren().size());
        for (ProjectedINode node : fileTree.getAllChildren()) {
            node.incrementLogicalTime();
            MetadataLogEntry logEntry = new MetadataLogEntry(dataSetDir.getId(), node.getId(), node.getPartitionId(), node.getParentId(), node.getName(), node.getLogicalTime(), operation);
            logEntries.add(logEntry);
            EntityManager.add((Object)logEntry);
        }
        AbstractFileTree.LoggingQuotaCountingFileTree.updateLogicalTime(logEntries);
    }

    void setStoragePolicy(String src, String policyName) throws IOException {
        try {
            this.setStoragePolicyInt(src, policyName);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "setStoragePolicy", src);
            throw e;
        }
    }

    private void setStoragePolicyInt(final String filename, String policyName) throws IOException, UnresolvedLinkException, AccessControlException {
        if (!this.isStoragePolicyEnabled) {
            throw new IOException("Failed to set storage policy since dfs.storage.policy.enabled is set to false.");
        }
        final BlockStoragePolicy policy = this.blockManager.getStoragePolicy(policyName);
        if (policy == null) {
            throw new HadoopIllegalArgumentException("Cannot find a block policy with the name " + policyName);
        }
        HopsTransactionalRequestHandler setStoragePolicyHandler = new HopsTransactionalRequestHandler(HDFSOperationType.SET_STORAGE_POLICY, filename){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, filename).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes());
                locks.add((Lock)il);
            }

            public Object performTask() throws IOException {
                FSPermissionChecker pc = FSNamesystem.this.getPermissionChecker();
                FSNamesystem.this.checkNameNodeSafeMode("Cannot set metaEnabled for " + filename);
                if (FSNamesystem.this.isPermissionEnabled) {
                    FSNamesystem.this.checkPathAccess(pc, filename, FsAction.WRITE);
                }
                FSNamesystem.this.dir.setStoragePolicy(filename, policy);
                return null;
            }
        };
        setStoragePolicyHandler.handle();
    }

    BlockStoragePolicy getDefaultStoragePolicy() throws IOException {
        return this.blockManager.getDefaultStoragePolicy();
    }

    BlockStoragePolicy getStoragePolicy(byte storagePolicyID) throws IOException {
        return this.blockManager.getStoragePolicy(storagePolicyID);
    }

    BlockStoragePolicy[] getStoragePolicies() throws IOException {
        return this.blockManager.getStoragePolicies();
    }

    long getPreferredBlockSize(String filename1) throws IOException {
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(filename1);
        final String filename = FSDirectory.resolvePath(filename1, pathComponents, this.dir);
        HopsTransactionalRequestHandler getPreferredBlockSizeHandler = new HopsTransactionalRequestHandler(HDFSOperationType.GET_PREFERRED_BLOCK_SIZE, filename){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.READ_COMMITTED, TransactionLockTypes.INodeResolveType.PATH, filename).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes());
                locks.add((Lock)il);
            }

            public Object performTask() throws IOException {
                FSPermissionChecker pc = FSNamesystem.this.getPermissionChecker();
                if (FSNamesystem.this.isPermissionEnabled) {
                    FSNamesystem.this.checkTraverse(pc, filename);
                }
                return FSNamesystem.this.dir.getPreferredBlockSize(filename);
            }
        };
        return (Long)getPreferredBlockSizeHandler.handle(this);
    }

    private void verifyParentDir(String src) throws FileNotFoundException, ParentNotDirectoryException, UnresolvedLinkException, StorageException, TransactionContextException {
        Path parent = new Path(src).getParent();
        if (parent != null) {
            INode parentNode = this.getINode(parent.toString());
            if (parentNode == null) {
                throw new FileNotFoundException("Parent directory doesn't exist: " + parent.toString());
            }
            if (!parentNode.isDirectory() && !parentNode.isSymlink()) {
                throw new ParentNotDirectoryException("Parent path is not a directory: " + parent.toString());
            }
        }
    }

    HdfsFileStatus startFile(String src1, final PermissionStatus permissions, final String holder, final String clientMachine, final EnumSet<CreateFlag> flag, final boolean createParent, final short replication, final long blockSize) throws IOException {
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(src1);
        final String src = FSDirectory.resolvePath(src1, pathComponents, this.dir);
        return (HdfsFileStatus)new HopsTransactionalRequestHandler(HDFSOperationType.START_FILE, src){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE_ON_TARGET_AND_PARENT, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(!FSNamesystem.this.dir.isQuotaEnabled());
                locks.add((Lock)il).add(lf.getBlockLock()).add(lf.getLeaseLock(TransactionLockTypes.LockType.WRITE, holder)).add(lf.getLeasePathLock(TransactionLockTypes.LockType.READ_COMMITTED)).add(lf.getBlockRelated(LockFactory.BLK.RE, LockFactory.BLK.CR, LockFactory.BLK.ER, LockFactory.BLK.UC, LockFactory.BLK.UR, LockFactory.BLK.PE, LockFactory.BLK.IV)).add(lf.getRetryCacheEntryLock(Server.getClientId(), Server.getCallId()));
                if (flag.contains(CreateFlag.OVERWRITE) && FSNamesystem.this.dir.isQuotaEnabled()) {
                    locks.add(lf.getQuotaUpdateLock(src));
                }
                if (flag.contains(CreateFlag.OVERWRITE) && FSNamesystem.this.erasureCodingEnabled) {
                    locks.add(lf.getEncodingStatusLock(TransactionLockTypes.LockType.WRITE, src));
                }
                locks.add(lf.getAcesLock());
            }

            public Object performTask() throws IOException {
                byte[] statusArray;
                HdfsFileStatus hdfsFileStatus;
                RetryCacheDistributed.CacheEntryWithPayload cacheEntry = RetryCacheDistributed.waitForCompletion((RetryCacheDistributed)FSNamesystem.this.retryCache, null);
                if (cacheEntry != null && cacheEntry.isSuccess()) {
                    HdfsFileStatus test = PBHelper.convert(HdfsProtos.HdfsFileStatusProto.parseFrom(cacheEntry.getPayload()));
                    return test;
                }
                HdfsFileStatus status = null;
                try {
                    hdfsFileStatus = status = FSNamesystem.this.startFileInt(src, permissions, holder, clientMachine, flag, createParent, replication, blockSize);
                    statusArray = status == null ? null : PBHelper.convert(status).toByteArray();
                }
                catch (AccessControlException e) {
                    try {
                        FSNamesystem.this.logAuditEvent(false, "create", src);
                        throw e;
                    }
                    catch (Throwable throwable) {
                        byte[] statusArray2 = status == null ? null : PBHelper.convert(status).toByteArray();
                        RetryCacheDistributed.setState((RetryCacheDistributed.CacheEntryWithPayload)cacheEntry, (status != null ? 1 : 0) != 0, (byte[])statusArray2);
                        throw throwable;
                    }
                }
                RetryCacheDistributed.setState((RetryCacheDistributed.CacheEntryWithPayload)cacheEntry, (status != null ? 1 : 0) != 0, (byte[])statusArray);
                return hdfsFileStatus;
            }
        }.handle(this);
    }

    private HdfsFileStatus startFileInt(String src, PermissionStatus permissions, String holder, String clientMachine, EnumSet<CreateFlag> flag, boolean createParent, short replication, long blockSize) throws IOException {
        FSPermissionChecker pc = this.getPermissionChecker();
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.startFile: src=" + src + ", holder=" + holder + ", clientMachine=" + clientMachine + ", createParent=" + createParent + ", replication=" + replication + ", createFlag=" + flag.toString()));
        }
        if (!DFSUtil.isValidName(src)) {
            throw new InvalidPathException(src);
        }
        if (blockSize < this.minBlockSize) {
            throw new IOException("Specified block size is less than configured minimum value (dfs.namenode.fs-limits.min-block-size): " + blockSize + " < " + this.minBlockSize);
        }
        boolean create = flag.contains(CreateFlag.CREATE);
        boolean overwrite = flag.contains(CreateFlag.OVERWRITE);
        this.startFileInternal(pc, src, permissions, holder, clientMachine, create, overwrite, createParent, replication, blockSize);
        HdfsFileStatus stat = this.dir.getFileInfo(src, false, true);
        this.logAuditEvent(true, "create", src, null, this.isAuditEnabled() && this.isExternalInvocation() ? stat : null);
        return stat;
    }

    private void startFileInternal(FSPermissionChecker pc, String src, PermissionStatus permissions, String holder, String clientMachine, boolean create, boolean overwrite, boolean createParent, short replication, long blockSize) throws IOException {
        boolean pathExists = this.dir.exists(src);
        if (pathExists && this.dir.isDir(src)) {
            throw new FileAlreadyExistsException(src + " already exists as a directory");
        }
        if (this.isPermissionEnabled) {
            if (overwrite && pathExists) {
                this.checkPathAccess(pc, src, FsAction.WRITE);
            } else {
                this.checkAncestorAccess(pc, src, FsAction.WRITE);
            }
        }
        if (!createParent) {
            this.verifyParentDir(src);
        }
        try {
            INode inode = this.dir.getINode(src);
            if (inode == null) {
                if (!create) {
                    throw new FileNotFoundException("Can't overwrite non-existent " + src + " for client " + clientMachine);
                }
            } else if (overwrite) {
                try {
                    this.deleteInt(src, true);
                }
                catch (AccessControlException e) {
                    this.logAuditEvent(false, "delete", src);
                    throw e;
                }
            } else {
                INodeFile myFile = INodeFile.valueOf(this.dir.getINode(src), src);
                this.recoverLeaseInternal(myFile, src, holder, clientMachine, false);
                throw new FileAlreadyExistsException(src + " for client " + clientMachine + " already exists");
            }
            this.checkFsObjectLimit();
            DatanodeDescriptor clientNode = this.blockManager.getDatanodeManager().getDatanodeByHost(clientMachine);
            INodeFile newNode = this.dir.addFile(src, permissions, replication, blockSize, holder, clientMachine, clientNode);
            if (newNode == null) {
                throw new IOException("Unable to add " + src + " to namespace");
            }
            this.leaseManager.addLease(newNode.getFileUnderConstructionFeature().getClientName(), src);
            if (NameNode.stateChangeLog.isDebugEnabled()) {
                NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.startFile: added " + src + " inode " + newNode.getId() + " " + holder));
            }
        }
        catch (IOException ie) {
            NameNode.stateChangeLog.warn((Object)("DIR* NameSystem.startFile: " + src + " " + ie.getMessage()));
            throw ie;
        }
    }

    private LocatedBlock appendFileInternal(FSPermissionChecker pc, String src, String holder, String clientMachine) throws AccessControlException, UnresolvedLinkException, FileNotFoundException, IOException {
        boolean pathExists = this.dir.exists(src);
        if (pathExists && this.dir.isDir(src)) {
            throw new FileAlreadyExistsException("Cannot append to directory " + src + "; already exists as a directory.");
        }
        if (this.isPermissionEnabled) {
            this.checkPathAccess(pc, src, FsAction.WRITE);
        }
        try {
            INode inode = this.dir.getINode(src);
            if (inode == null) {
                throw new FileNotFoundException("failed to append to non-existent file " + src + " for client " + clientMachine);
            }
            INodeFile myFile = INodeFile.valueOf(inode, src);
            BlockInfo lastBlock = myFile.getLastBlock();
            if (lastBlock != null && lastBlock.isComplete() && !this.getBlockManager().isSufficientlyReplicated(lastBlock)) {
                throw new IOException("append: lastBlock=" + lastBlock + " of src=" + src + " is not sufficiently replicated yet.");
            }
            this.recoverLeaseInternal(myFile, src, holder, clientMachine, false);
            DatanodeDescriptor clientNode = this.blockManager.getDatanodeManager().getDatanodeByHost(clientMachine);
            return this.prepareFileForWrite(src, myFile, holder, clientMachine, clientNode);
        }
        catch (IOException ie) {
            NameNode.stateChangeLog.warn((Object)("DIR* NameSystem.append: " + ie.getMessage()));
            throw ie;
        }
    }

    private LocatedBlock prepareFileForWrite(String src, INodeFile file, String leaseHolder, String clientMachine, DatanodeDescriptor clientNode) throws IOException {
        INodeFile cons = file.toUnderConstruction(leaseHolder, clientMachine, clientNode);
        Lease lease = this.leaseManager.addLease(cons.getFileUnderConstructionFeature().getClientName(), src);
        if (cons.isFileStoredInDB()) {
            LOG.debug((Object)"Stuffed Inode:  prepareFileForWrite stored in database. Returning phantom block");
            return this.blockManager.createPhantomLocatedBlocks(cons, cons.getFileDataInDB(), true, false).getLocatedBlocks().get(0);
        }
        LocatedBlock ret = this.blockManager.convertLastBlockToUnderConstruction(cons);
        lease.updateLastTwoBlocksInLeasePath(src, file.getLastBlock(), file.getPenultimateBlock());
        return ret;
    }

    boolean recoverLease(String src1, final String holder, final String clientMachine) throws IOException {
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(src1);
        final String src = FSDirectory.resolvePath(src1, pathComponents, this.dir);
        HopsTransactionalRequestHandler recoverLeaseHandler = new HopsTransactionalRequestHandler(HDFSOperationType.RECOVER_LEASE, src){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes());
                locks.add((Lock)il).add(lf.getLeaseLock(TransactionLockTypes.LockType.WRITE, holder)).add(lf.getLeasePathLock(TransactionLockTypes.LockType.READ_COMMITTED)).add(lf.getBlockLock()).add(lf.getBlockRelated(LockFactory.BLK.RE, LockFactory.BLK.CR, LockFactory.BLK.ER, LockFactory.BLK.UC, LockFactory.BLK.UR)).add(lf.getAcesLock());
            }

            public Object performTask() throws IOException {
                FSPermissionChecker pc = FSNamesystem.this.getPermissionChecker();
                if (FSNamesystem.this.isInSafeMode()) {
                    FSNamesystem.this.checkNameNodeSafeMode("Cannot recover the lease of " + src);
                }
                if (!DFSUtil.isValidName(src)) {
                    throw new IOException("Invalid file name: " + src);
                }
                INodeFile inode = INodeFile.valueOf(FSNamesystem.this.dir.getINode(src), src);
                if (!inode.isUnderConstruction()) {
                    return true;
                }
                if (FSNamesystem.this.isPermissionEnabled) {
                    FSNamesystem.this.checkPathAccess(pc, src, FsAction.WRITE);
                }
                FSNamesystem.this.recoverLeaseInternal(inode, src, holder, clientMachine, true);
                return false;
            }
        };
        return (Boolean)recoverLeaseHandler.handle(this);
    }

    private void recoverLeaseInternal(INodeFile fileInode, String src, String holder, String clientMachine, boolean force) throws IOException {
        if (fileInode != null && fileInode.isUnderConstruction()) {
            Lease leaseFile;
            Lease lease = this.leaseManager.getLease(holder);
            if (!force && lease != null && ((leaseFile = this.leaseManager.getLeaseByPath(src)) != null && leaseFile.equals(lease) || lease.getHolder().equals(holder))) {
                throw new AlreadyBeingCreatedException("failed to create file " + src + " for " + holder + " for client " + clientMachine + " because current leaseholder is trying to recreate file.");
            }
            FileUnderConstructionFeature uc = fileInode.getFileUnderConstructionFeature();
            String clientName = uc.getClientName();
            lease = this.leaseManager.getLease(clientName);
            if (lease == null) {
                throw new AlreadyBeingCreatedException("failed to create file " + src + " for " + holder + " for client " + clientMachine + " because pendingCreates is non-null but no leases found.");
            }
            if (force) {
                LOG.info((Object)("recoverLease: " + lease + ", src=" + src + " from client " + clientName));
                this.internalReleaseLease(lease, src, holder);
            } else {
                assert (lease.getHolder().equals(clientName)) : "Current lease holder " + lease.getHolder() + " does not match file creator " + clientName;
                if (this.leaseManager.expiredSoftLimit(lease)) {
                    LOG.info((Object)("startFile: recover " + lease + ", src=" + src + " client " + clientName));
                    boolean isClosed = this.internalReleaseLease(lease, src, null);
                    if (!isClosed) {
                        throw new RecoveryInProgressException.NonAbortingRecoveryInProgressException("Failed to close file " + src + ". Lease recovery is in progress. Try again later.");
                    }
                } else {
                    BlockInfo lastBlock = fileInode.getLastBlock();
                    if (lastBlock != null && lastBlock.getBlockUCState() == HdfsServerConstants.BlockUCState.UNDER_RECOVERY) {
                        throw new RecoveryInProgressException("Recovery in progress, file [" + src + "], lease owner [" + lease.getHolder() + "]");
                    }
                    throw new AlreadyBeingCreatedException("Failed to create file [" + src + "] for [" + holder + "] on client [" + clientMachine + "], because this file is already being created by [" + clientName + "] on [" + uc.getClientMachine() + "]");
                }
            }
        }
    }

    LocatedBlock appendFile(String src, String holder, String clientMachine) throws IOException {
        LocatedBlock lb = null;
        try {
            lb = this.appendFileHopFS(src, holder, clientMachine);
            return lb;
        }
        catch (HDFSClientAppendToDBFileException e) {
            LOG.debug((Object)e);
            return this.moveToDNsAndAppend(src, holder, clientMachine);
        }
    }

    private LocatedBlock moveToDNsAndAppend(String src, String holder, String clientMachine) throws IOException {
        FileSystem hopsFSClient1 = FileSystem.newInstance((Configuration)this.conf);
        byte[] data = new byte[this.conf.getInt("dfs.db.file.max.size", 65536)];
        FSDataInputStream is = hopsFSClient1.open(new Path(src));
        int dataRead = is.read(data, 0, data.length);
        is.close();
        Configuration newConf = this.copyConfiguration(this.conf);
        newConf.setBoolean("dfs.store.small.files.in.db", false);
        FileSystem hopsFSClient2 = FileSystem.newInstance((Configuration)newConf);
        FSDataOutputStream os = hopsFSClient2.create(new Path(src), true);
        os.write(data, 0, dataRead);
        os.close();
        return this.appendFileHopFS(src, holder, clientMachine);
    }

    private Configuration copyConfiguration(Configuration conf) {
        HdfsConfiguration newConf = new HdfsConfiguration();
        for (Map.Entry entry : conf) {
            newConf.set((String)entry.getKey(), (String)entry.getValue());
        }
        return newConf;
    }

    private LocatedBlock appendFileHopFS(String src1, final String holder, final String clientMachine) throws IOException {
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(src1);
        final String src = FSDirectory.resolvePath(src1, pathComponents, this.dir);
        HopsTransactionalRequestHandler appendFileHandler = new HopsTransactionalRequestHandler(HDFSOperationType.APPEND_FILE, src){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE_ON_TARGET_AND_PARENT, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(!FSNamesystem.this.dir.isQuotaEnabled());
                locks.add((Lock)il).add(lf.getBlockLock()).add(lf.getLeaseLock(TransactionLockTypes.LockType.WRITE, holder)).add(lf.getLeasePathLock(TransactionLockTypes.LockType.READ_COMMITTED)).add(lf.getBlockRelated(LockFactory.BLK.RE, LockFactory.BLK.CR, LockFactory.BLK.ER, LockFactory.BLK.UC, LockFactory.BLK.UR, LockFactory.BLK.IV, LockFactory.BLK.PE)).add(lf.getLastBlockHashBucketsLock());
                locks.add(lf.getRetryCacheEntryLock(Server.getClientId(), Server.getCallId()));
                locks.add(lf.getEncodingStatusLock(TransactionLockTypes.LockType.READ_COMMITTED, src));
                locks.add(lf.getAcesLock());
            }

            public Object performTask() throws IOException {
                Object locatedBlock = null;
                RetryCacheDistributed.CacheEntryWithPayload cacheEntry = RetryCacheDistributed.waitForCompletion((RetryCacheDistributed)FSNamesystem.this.retryCache, null);
                if (cacheEntry != null && cacheEntry.isSuccess()) {
                    INode inode;
                    INodeFile file;
                    locatedBlock = PBHelper.convert(HdfsProtos.LocatedBlockProto.parseFrom(cacheEntry.getPayload()));
                    if (locatedBlock.isPhantomBlock() && (file = INodeFile.valueOf(inode = FSNamesystem.this.dir.getINode(src), src)).isFileStoredInDB()) {
                        LOG.debug((Object)"Stuffed Inode: appendFileHopFS  stored in database. Returning phantom block");
                        locatedBlock.setData(file.getFileDataInDB());
                    }
                    return locatedBlock;
                }
                boolean success = false;
                try {
                    EncodingStatus status;
                    INode target = FSNamesystem.this.getINode(src);
                    if (target != null && target instanceof INodeFile && !((INodeFile)target).isFileStoredInDB() && (status = (EncodingStatus)EntityManager.find((FinderType)EncodingStatus.Finder.ByInodeId, (Object[])new Object[]{target.getId()})) != null) {
                        throw new IOException("Cannot append to erasure-coded file");
                    }
                    if (target != null && target instanceof INodeFile && ((INodeFile)target).isFileStoredInDB() && !holder.contains("HopsFS")) {
                        throw new HDFSClientAppendToDBFileException("HDFS can not directly append to a file stored in the database");
                    }
                    locatedBlock = FSNamesystem.this.appendFileInt(src, holder, clientMachine);
                    if (locatedBlock != null && !locatedBlock.isPhantomBlock()) {
                        for (String storageID : locatedBlock.getStorageIDs()) {
                            int sId = FSNamesystem.this.blockManager.getDatanodeManager().getSid(storageID);
                            BlockInfo blockInfo = (BlockInfo)EntityManager.find((FinderType)BlockInfo.Finder.ByBlockIdAndINodeId, (Object[])new Object[]{locatedBlock.getBlock().getBlockId(), target.getId()});
                            Block undoBlock = new Block(blockInfo);
                            undoBlock.setGenerationStampNoPersistance(undoBlock.getGenerationStamp() - 1L);
                            HashBuckets.getInstance().undoHash(sId, HdfsServerConstants.ReplicaState.FINALIZED, undoBlock);
                        }
                    }
                    success = true;
                    String[] stringArray = locatedBlock;
                    return stringArray;
                }
                catch (AccessControlException e) {
                    FSNamesystem.this.logAuditEvent(false, "append", src);
                    throw e;
                }
                finally {
                    byte[] locatedBlockBytes = null;
                    if (locatedBlock != null) {
                        LocatedBlock lb = new LocatedBlock(locatedBlock.getBlock(), locatedBlock.getLocations(), locatedBlock.getStorageIDs(), locatedBlock.getStorageTypes(), locatedBlock.getStartOffset(), locatedBlock.isCorrupt(), locatedBlock.getBlockToken(), locatedBlock.getCachedLocations());
                        locatedBlockBytes = PBHelper.convert(lb).toByteArray();
                    }
                    RetryCacheDistributed.setState((RetryCacheDistributed.CacheEntryWithPayload)cacheEntry, (boolean)success, locatedBlockBytes);
                }
            }
        };
        return (LocatedBlock)appendFileHandler.handle(this);
    }

    private LocatedBlock appendFileInt(String src, String holder, String clientMachine) throws IOException {
        if (!this.supportAppends) {
            throw new UnsupportedOperationException("Append is not enabled on this NameNode. Use the dfs.support.append configuration option to enable it.");
        }
        FSPermissionChecker pc = this.getPermissionChecker();
        LocatedBlock lb = this.appendFileInternal(pc, src, holder, clientMachine);
        if (lb != null && NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.appendFile: file " + src + " for " + holder + " at " + clientMachine + " block " + lb.getBlock() + " block size " + lb.getBlock().getNumBytes()));
        }
        this.logAuditEvent(true, "append", src);
        return lb;
    }

    private ExtendedBlock getExtendedBlock(Block blk) {
        return new ExtendedBlock(this.blockPoolId, blk);
    }

    LocatedBlock getAdditionalBlock(String src1, final long fileId, final String clientName, final ExtendedBlock previous, final Set<Node> excludedNodes, final List<String> favoredNodes) throws IOException {
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(src1);
        final String src = FSDirectory.resolvePath(src1, pathComponents, this.dir);
        HopsTransactionalRequestHandler additionalBlockHandler = new HopsTransactionalRequestHandler(HDFSOperationType.GET_ADDITIONAL_BLOCK, src){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes());
                locks.add((Lock)il).add(lf.getLeaseLock(TransactionLockTypes.LockType.READ, clientName)).add(lf.getLeasePathLock(TransactionLockTypes.LockType.READ_COMMITTED)).add(lf.getLastTwoBlocksLock(src)).add(lf.getBlockRelated(LockFactory.BLK.RE, LockFactory.BLK.CR, LockFactory.BLK.ER, LockFactory.BLK.UC));
            }

            public Object performTask() throws IOException {
                if (NameNode.stateChangeLog.isDebugEnabled()) {
                    NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.getAdditionalBlock: " + src + " inodeId " + fileId + " for " + clientName));
                }
                LocatedBlock[] onRetryBlock = new LocatedBlock[1];
                INodesInPath inodesInPath = FSNamesystem.this.analyzeFileState(src, fileId, clientName, previous, onRetryBlock);
                INode[] inodes = inodesInPath.getINodes();
                INodeFile pendingFile = inodes[inodes.length - 1].asFile();
                if (onRetryBlock[0] != null && onRetryBlock[0].getLocations().length > 0) {
                    return onRetryBlock[0];
                }
                if ((long)pendingFile.getBlocks().length >= FSNamesystem.this.maxBlocksPerFile) {
                    throw new IOException("File has reached the limit on maximum number of blocks (dfs.namenode.fs-limits.max-blocks-per-file): " + pendingFile.getBlocks().length + " >= " + FSNamesystem.this.maxBlocksPerFile);
                }
                long blockSize = pendingFile.getPreferredBlockSize();
                DatanodeDescriptor clientNode = pendingFile.getFileUnderConstructionFeature().getClientNode() == null ? null : FSNamesystem.this.getBlockManager().getDatanodeManager().getDatanode(pendingFile.getFileUnderConstructionFeature().getClientNode());
                short replication = pendingFile.getBlockReplication();
                byte storagePolicyID = pendingFile.getStoragePolicyID();
                DatanodeStorageInfo[] targets = FSNamesystem.this.getBlockManager().chooseTarget4NewBlock(src, replication, clientNode, excludedNodes, blockSize, favoredNodes, storagePolicyID);
                onRetryBlock = new LocatedBlock[1];
                INodesInPath iNodesInPath2 = FSNamesystem.this.analyzeFileState(src, fileId, clientName, previous, onRetryBlock);
                INode[] inodes2 = iNodesInPath2.getINodes();
                INodeFile pendingFile2 = inodes2[inodes2.length - 1].asFile();
                if (onRetryBlock[0] != null) {
                    if (onRetryBlock[0].getLocations().length > 0) {
                        return onRetryBlock[0];
                    }
                    BlockInfo lastBlockInFile = pendingFile.getLastBlock();
                    ((BlockInfoUnderConstruction)lastBlockInFile).setExpectedLocations(targets);
                    long offset = pendingFile.computeFileSize();
                    return FSNamesystem.this.makeLocatedBlock(lastBlockInFile, targets, offset);
                }
                FSNamesystem.this.commitOrCompleteLastBlock(pendingFile2, ExtendedBlock.getLocalBlock(previous));
                Block newBlock = FSNamesystem.this.createNewBlock(pendingFile2);
                FSNamesystem.this.saveAllocatedBlock(src, iNodesInPath2, newBlock, targets);
                FSNamesystem.this.dir.persistNewBlock(src, pendingFile2);
                long offset = pendingFile2.computeFileSize(true);
                Lease lease = FSNamesystem.this.leaseManager.getLease(clientName);
                lease.updateLastTwoBlocksInLeasePath(src, newBlock, ExtendedBlock.getLocalBlock(previous));
                LocatedBlock lb = FSNamesystem.this.makeLocatedBlock(newBlock, targets, offset);
                if (pendingFile.isFileStoredInDB()) {
                    pendingFile.setFileStoredInDB(false);
                    pendingFile.deleteFileDataStoredInDB();
                    LOG.debug((Object)"Stuffed Inode:  appending to a file stored in the database. In the current implementation there is potential for data loss if the client fails");
                }
                return lb;
            }
        };
        return (LocatedBlock)additionalBlockHandler.handle(this);
    }

    private INodesInPath analyzeFileState(String src, long fileId, String clientName, ExtendedBlock previous, LocatedBlock[] onRetryBlock) throws IOException {
        this.checkBlock(previous);
        onRetryBlock[0] = null;
        this.checkNameNodeSafeMode("Cannot add block to " + src);
        this.checkFsObjectLimit();
        Block previousBlock = ExtendedBlock.getLocalBlock(previous);
        INodesInPath inodesInPath = this.dir.getINodesInPath4Write(src);
        INode[] inodes = inodesInPath.getINodes();
        INodeFile pendingFile = this.checkLease(src, fileId, clientName, inodes[inodes.length - 1]);
        BlockInfo lastBlockInFile = pendingFile.getLastBlock();
        if (!Block.matchingIdAndGenStamp(previousBlock, lastBlockInFile)) {
            BlockInfo penultimateBlock = pendingFile.getPenultimateBlock();
            if (previous == null && lastBlockInFile != null && lastBlockInFile.getNumBytes() == pendingFile.getPreferredBlockSize() && lastBlockInFile.isComplete()) {
                if (NameNode.stateChangeLog.isDebugEnabled()) {
                    NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.allocateBlock: handling block allocation writing to a file with a complete previous block: src=" + src + " lastBlock=" + lastBlockInFile));
                }
            } else {
                if (Block.matchingIdAndGenStamp(penultimateBlock, previousBlock)) {
                    if (lastBlockInFile.getNumBytes() != 0L) {
                        throw new IOException("Request looked like a retry to allocate block " + lastBlockInFile + " but it already contains " + lastBlockInFile.getNumBytes() + " bytes");
                    }
                    NameNode.stateChangeLog.info((Object)("BLOCK* allocateBlock: caught retry for allocation of a new block in " + src + ". Returning previously allocated block " + lastBlockInFile));
                    long offset = pendingFile.computeFileSize(true);
                    onRetryBlock[0] = this.makeLocatedBlock(lastBlockInFile, ((BlockInfoUnderConstruction)lastBlockInFile).getExpectedStorageLocations(this.getBlockManager().getDatanodeManager()), offset);
                    return inodesInPath;
                }
                throw new IOException("Cannot allocate block in " + src + ": passed 'previous' block " + previous + " does not match actual last block in file " + lastBlockInFile);
            }
        }
        if (!this.checkFileProgress(pendingFile, false)) {
            throw new NotReplicatedYetException("Not replicated yet: " + src + " block " + pendingFile.getPenultimateBlock());
        }
        return inodesInPath;
    }

    private LocatedBlock makeLocatedBlock(Block blk, DatanodeStorageInfo[] locs, long offset) throws IOException {
        LocatedBlock lBlk = LocatedBlock.createLocatedBlock(this.getExtendedBlock(blk), locs, offset, false);
        this.getBlockManager().setBlockToken(lBlk, BlockTokenSecretManager.AccessMode.WRITE);
        return lBlk;
    }

    LocatedBlock getAdditionalDatanode(String src1, final ExtendedBlock blk, final DatanodeInfo[] existings, final String[] storageIDs, final HashSet<Node> excludes, final int numAdditionalNodes, final String clientName) throws IOException {
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(src1);
        final String src = FSDirectory.resolvePath(src1, pathComponents, this.dir);
        HopsTransactionalRequestHandler getAdditionalDatanodeHandler = new HopsTransactionalRequestHandler(HDFSOperationType.GET_ADDITIONAL_DATANODE, src){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.READ, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes());
                locks.add((Lock)il).add(lf.getLeaseLock(TransactionLockTypes.LockType.READ, clientName));
            }

            public Object performTask() throws IOException {
                FSNamesystem.this.dtpReplaceDatanodeOnFailure.checkEnabled();
                FSNamesystem.this.checkNameNodeSafeMode("Cannot add datanode; src=" + src + ", blk=" + blk);
                INodeFile file = FSNamesystem.this.checkLease(src, clientName, false);
                DatanodeDescriptor clientNode = file.getFileUnderConstructionFeature().getClientNode() == null ? null : FSNamesystem.this.getBlockManager().getDatanodeManager().getDatanode(file.getFileUnderConstructionFeature().getClientNode());
                long preferredBlockSize = file.getPreferredBlockSize();
                byte storagePolicyID = file.getStoragePolicyID();
                DatanodeManager dm = FSNamesystem.this.blockManager.getDatanodeManager();
                List<DatanodeStorageInfo> chosen = Arrays.asList(dm.getDatanodeStorageInfos(existings, storageIDs));
                DatanodeStorageInfo[] targets = FSNamesystem.this.blockManager.chooseTarget4AdditionalDatanode(src, numAdditionalNodes, clientNode, chosen, excludes, preferredBlockSize, storagePolicyID);
                LocatedBlock lb = new LocatedBlock(blk, targets);
                FSNamesystem.this.blockManager.setBlockToken(lb, BlockTokenSecretManager.AccessMode.COPY);
                return lb;
            }
        };
        return (LocatedBlock)getAdditionalDatanodeHandler.handle(this);
    }

    boolean abandonBlock(final ExtendedBlock b, String src1, final String holder) throws IOException {
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(src1);
        final String src = FSDirectory.resolvePath(src1, pathComponents, this.dir);
        HopsTransactionalRequestHandler abandonBlockHandler = new HopsTransactionalRequestHandler(HDFSOperationType.ABANDON_BLOCK, src){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE_ON_TARGET_AND_PARENT, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes());
                locks.add((Lock)il).add(lf.getLeaseLock(TransactionLockTypes.LockType.READ)).add(lf.getLeasePathLock(TransactionLockTypes.LockType.READ_COMMITTED, src)).add(lf.getBlockLock()).add(lf.getBlockRelated(LockFactory.BLK.RE, LockFactory.BLK.CR, LockFactory.BLK.UC, LockFactory.BLK.UR));
            }

            public Object performTask() throws IOException {
                if (NameNode.stateChangeLog.isDebugEnabled()) {
                    NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.abandonBlock: " + b + "of file " + src));
                }
                FSNamesystem.this.checkNameNodeSafeMode("Cannot abandon block " + b + " for fle" + src);
                INodeFile file = FSNamesystem.this.checkLease(src, holder, false);
                boolean removed = FSNamesystem.this.dir.removeBlock(src, file, ExtendedBlock.getLocalBlock(b));
                if (!removed) {
                    return true;
                }
                FSNamesystem.this.leaseManager.getLease(holder).updateLastTwoBlocksInLeasePath(src, file.getLastBlock(), file.getPenultimateBlock());
                if (NameNode.stateChangeLog.isDebugEnabled()) {
                    NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.abandonBlock: " + b + " is removed from pendingCreates"));
                }
                FSNamesystem.this.dir.persistBlocks(src, file);
                file.recomputeFileSize();
                return true;
            }
        };
        return (Boolean)abandonBlockHandler.handle(this);
    }

    private INodeFile checkLease(String src, String holder) throws LeaseExpiredException, UnresolvedLinkException, StorageException, TransactionContextException, FileNotFoundException {
        return this.checkLease(src, 0L, holder, true);
    }

    private INodeFile checkLease(String src, String holder, boolean updateLastTwoBlocksInFile) throws LeaseExpiredException, UnresolvedLinkException, StorageException, TransactionContextException, FileNotFoundException {
        return this.checkLease(src, 0L, holder, updateLastTwoBlocksInFile);
    }

    private INodeFile checkLease(String src, long fileId, String holder, boolean updateLastTwoBlocksInFile) throws LeaseExpiredException, UnresolvedLinkException, StorageException, TransactionContextException, FileNotFoundException {
        return this.checkLease(src, fileId, holder, this.dir.getINode(src), updateLastTwoBlocksInFile);
    }

    private INodeFile checkLease(String src, long fileId, String holder, INode file) throws LeaseExpiredException, StorageException, TransactionContextException, FileNotFoundException {
        return this.checkLease(src, fileId, holder, file, true);
    }

    private INodeFile checkLease(String src, long fileId, String holder, INode inode, boolean updateLastTwoBlocksInFile) throws LeaseExpiredException, StorageException, TransactionContextException, FileNotFoundException {
        INodeFile file = inode.asFile();
        if (file == null || !(file instanceof INodeFile)) {
            Lease lease = this.leaseManager.getLease(holder);
            throw new LeaseExpiredException("No lease on " + src + ": File does not exist. " + (lease != null ? lease.toString() : "Holder " + holder + " does not have any open files."));
        }
        if (!file.isUnderConstruction()) {
            Lease lease = this.leaseManager.getLease(holder);
            throw new LeaseExpiredException("No lease on " + src + ": File is not open for writing. " + (lease != null ? lease.toString() : "Holder " + holder + " does not have any open files."));
        }
        String clientName = file.getFileUnderConstructionFeature().getClientName();
        if (holder != null && !clientName.equals(holder)) {
            throw new LeaseExpiredException("Lease mismatch on " + src + " owned by " + clientName + " but is accessed by " + holder);
        }
        if (updateLastTwoBlocksInFile) {
            file.getFileUnderConstructionFeature().updateLastTwoBlocks(this.leaseManager.getLease(holder), src);
        }
        INode.checkId(fileId, file);
        return file;
    }

    boolean completeFile(String src1, final String holder, final ExtendedBlock last, final long fileId, final byte[] data) throws IOException {
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(src1);
        final String src = FSDirectory.resolvePath(src1, pathComponents, this.dir);
        HopsTransactionalRequestHandler completeFileHandler = new HopsTransactionalRequestHandler(HDFSOperationType.COMPLETE_FILE, src){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(!FSNamesystem.this.dir.isQuotaEnabled());
                locks.add((Lock)il).add(lf.getLeaseLock(TransactionLockTypes.LockType.WRITE, holder)).add(lf.getLeasePathLock(TransactionLockTypes.LockType.WRITE)).add(lf.getBlockLock());
                if (data == null) {
                    locks.add(lf.getBlockRelated(LockFactory.BLK.RE, LockFactory.BLK.CR, LockFactory.BLK.ER, LockFactory.BLK.UC, LockFactory.BLK.UR, LockFactory.BLK.IV));
                }
            }

            public Object performTask() throws IOException {
                FSNamesystem.this.checkBlock(last);
                return FSNamesystem.this.completeFileInternal(src, holder, ExtendedBlock.getLocalBlock(last), fileId, data);
            }
        };
        return (Boolean)completeFileHandler.handle(this);
    }

    private boolean completeFileInternal(String src, String holder, Block last, long fileId, byte[] data) throws IOException {
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.completeFile: " + src + " for " + holder));
        }
        this.checkNameNodeSafeMode("Cannot complete file " + src);
        if (data != null) {
            if (last != null) {
                throw new IllegalStateException("Trying to store the file data in the database. Last block of the file should have been null");
            }
            return this.completeFileStoredInDataBase(src, holder, fileId, data);
        }
        return this.completeFileStoredOnDataNodes(src, holder, last, fileId);
    }

    private boolean completeFileStoredOnDataNodes(String src, String holder, Block last, long fileId) throws IOException {
        INodeFile pendingFile;
        INodesInPath iip = this.dir.getLastINodeInPath(src);
        try {
            pendingFile = this.checkLease(src, fileId, holder, iip.getINode(0));
        }
        catch (LeaseExpiredException lee) {
            BlockInfo realLastBlock;
            INode inode = this.dir.getINode(src);
            if (inode != null && inode instanceof INodeFile && !inode.isUnderConstruction() && Block.matchingIdAndGenStamp(last, realLastBlock = ((INodeFile)inode).getLastBlock())) {
                NameNode.stateChangeLog.info((Object)("DIR* completeFile: request from " + holder + " to complete " + src + " which is already closed. But, it appears to be an RPC retry. Returning success"));
                return true;
            }
            throw lee;
        }
        if (!this.checkFileProgress(pendingFile, false)) {
            return false;
        }
        this.commitOrCompleteLastBlock(pendingFile, last);
        if (!this.checkFileProgress(pendingFile, true)) {
            return false;
        }
        this.finalizeINodeFileUnderConstruction(src, pendingFile);
        NameNode.stateChangeLog.info((Object)("DIR* completeFile: " + src + " is closed by " + holder));
        return true;
    }

    private boolean completeFileStoredInDataBase(String src, String holder, long fileId, byte[] data) throws IOException {
        INodesInPath iip = this.dir.getLastINodeInPath(src);
        INodeFile pendingFile = this.checkLease(src, fileId, holder, iip.getINode(0));
        if (pendingFile.isFileStoredInDB()) {
            pendingFile.deleteFileDataStoredInDB();
        }
        pendingFile.setFileStoredInDB(true);
        long oldSize = pendingFile.getSize();
        pendingFile.setSize(data.length);
        pendingFile.storeFileDataInDB(data);
        if (this.dir.isQuotaEnabled()) {
            long spaceConsumed = ((long)data.length - oldSize) * (long)pendingFile.getBlockReplication();
            this.dir.updateSpaceConsumed(src, 0L, spaceConsumed);
        }
        this.finalizeINodeFileUnderConstructionStoredInDB(src, pendingFile);
        NameNode.stateChangeLog.info((Object)("DIR* completeFile: " + src + " is closed by " + holder));
        return true;
    }

    private BlockInfo saveAllocatedBlock(String src, INodesInPath inodesInPath, Block newBlock, DatanodeStorageInfo[] targets) throws IOException, StorageException {
        BlockInfo b = this.dir.addBlock(src, inodesInPath, newBlock, targets);
        NameNode.stateChangeLog.info((Object)("BLOCK* allocateBlock: " + src + ". " + this.getBlockPoolId() + " " + b));
        DatanodeStorageInfo.incrementBlocksScheduled(targets);
        return b;
    }

    private Block createNewBlock(INodeFile pendingFile) throws IOException {
        Block b = new Block(this.nextBlockId(), 0L, 0L);
        b.setGenerationStampNoPersistance(pendingFile.nextGenerationStamp());
        return b;
    }

    private boolean checkFileProgress(INodeFile v, boolean checkAll) throws IOException {
        if (checkAll) {
            for (BlockInfo block : v.getBlocks()) {
                if (block.isComplete()) continue;
                BlockInfo cBlock = this.blockManager.tryToCompleteBlock(v, block.getBlockIndex());
                if (cBlock != null) {
                    block = cBlock;
                }
                if (block.isComplete()) continue;
                LOG.info((Object)("BLOCK* checkFileProgress: " + block + " has not reached minimal replication " + this.blockManager.minReplication));
                return false;
            }
        } else {
            BlockInfo b = v.getPenultimateBlock();
            if (b != null && !b.isComplete()) {
                this.blockManager.tryToCompleteBlock(v, b.getBlockIndex());
                b = v.getPenultimateBlock();
                if (!b.isComplete()) {
                    LOG.warn((Object)("BLOCK* checkFileProgress: " + b + " has not reached minimal replication " + this.blockManager.minReplication));
                    return false;
                }
            }
        }
        return true;
    }

    public boolean deleteWithTransaction(String src1, final boolean recursive) throws IOException {
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(src1);
        final String src = FSDirectory.resolvePath(src1, pathComponents, this.dir);
        HopsTransactionalRequestHandler deleteHandler = new HopsTransactionalRequestHandler(HDFSOperationType.DELETE, src){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE_ON_TARGET_AND_PARENT, TransactionLockTypes.INodeResolveType.PATH_AND_IMMEDIATE_CHILDREN, src).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(!FSNamesystem.this.dir.isQuotaEnabled());
                locks.add((Lock)il).add(lf.getLeaseLock(TransactionLockTypes.LockType.WRITE)).add(lf.getLeasePathLock(TransactionLockTypes.LockType.READ_COMMITTED)).add(lf.getBlockLock()).add(lf.getBlockRelated(LockFactory.BLK.RE, LockFactory.BLK.CR, LockFactory.BLK.UC, LockFactory.BLK.UR, LockFactory.BLK.PE, LockFactory.BLK.IV)).add(lf.getRetryCacheEntryLock(Server.getClientId(), Server.getCallId()));
                if (FSNamesystem.this.dir.isQuotaEnabled()) {
                    locks.add(lf.getQuotaUpdateLock(true, src));
                }
                if (FSNamesystem.this.erasureCodingEnabled) {
                    locks.add(lf.getEncodingStatusLock(TransactionLockTypes.LockType.WRITE, src));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object performTask() throws IOException {
                RetryCache.CacheEntry cacheEntry = RetryCacheDistributed.waitForCompletion((RetryCacheDistributed)FSNamesystem.this.retryCache);
                if (cacheEntry != null && cacheEntry.isSuccess()) {
                    return true;
                }
                boolean ret = false;
                try {
                    ret = FSNamesystem.this.delete(src, recursive);
                    Boolean bl = ret;
                    return bl;
                }
                finally {
                    RetryCacheDistributed.setState((RetryCache.CacheEntry)cacheEntry, (boolean)ret);
                }
            }
        };
        return (Boolean)deleteHandler.handle(this);
    }

    private boolean delete(String src, boolean recursive) throws IOException {
        try {
            return this.deleteInt(src, recursive);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "delete", src);
            throw e;
        }
    }

    private boolean deleteInt(String src, boolean recursive) throws IOException {
        boolean status;
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.delete: " + src));
        }
        if (status = this.deleteInternal(src, recursive, true)) {
            this.logAuditEvent(true, "delete", src);
        }
        return status;
    }

    FSPermissionChecker getPermissionChecker() throws AccessControlException {
        try {
            return new FSPermissionChecker(this.fsOwnerShortUserName, this.superGroup, FSNamesystem.getRemoteUser());
        }
        catch (IOException ioe) {
            throw new AccessControlException((Throwable)ioe);
        }
    }

    private boolean deleteInternal(String src, boolean recursive, boolean enforcePermission) throws IOException {
        INode.BlocksMapUpdateInfo collectedBlocks = new INode.BlocksMapUpdateInfo();
        FSPermissionChecker pc = this.getPermissionChecker();
        this.checkNameNodeSafeMode("Cannot delete " + src);
        if (!recursive && this.dir.isNonEmptyDirectory(src)) {
            throw new IOException(src + " is non empty");
        }
        if (enforcePermission && this.isPermissionEnabled) {
            this.checkPermission(pc, src, false, null, FsAction.WRITE, null, FsAction.ALL, false);
        }
        if (!this.dir.delete(src, collectedBlocks)) {
            return false;
        }
        this.removeBlocks(collectedBlocks);
        collectedBlocks.clear();
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* Namesystem.delete: " + src + " is removed"));
        }
        return true;
    }

    private void removeBlocks(INode.BlocksMapUpdateInfo blocks) throws StorageException, TransactionContextException {
        List<Block> toDeleteList = blocks.getToDeleteList();
        Iterator<Block> iter = toDeleteList.iterator();
        while (iter.hasNext()) {
            for (int i = 0; i < BLOCK_DELETION_INCREMENT && iter.hasNext(); ++i) {
                this.blockManager.removeBlock(iter.next());
            }
        }
    }

    void removePathAndBlocks(String src, INode.BlocksMapUpdateInfo blocks) throws IOException {
        this.leaseManager.removeLeaseWithPrefixPath(src);
        if (blocks == null) {
            return;
        }
        this.removeBlocksAndUpdateSafemodeTotal(blocks);
    }

    void removeBlocksAndUpdateSafemodeTotal(INode.BlocksMapUpdateInfo blocks) throws IOException {
        int numRemovedComplete = 0;
        ArrayList<Block> removedSafe = new ArrayList<Block>();
        for (Block b : blocks.getToDeleteList()) {
            BlockInfo bi = this.getStoredBlock(b);
            if (bi.isComplete()) {
                ++numRemovedComplete;
                removedSafe.add(b);
            }
            this.blockManager.removeBlock(b);
        }
        this.adjustSafeModeBlockTotals(removedSafe, -numRemovedComplete);
    }

    public HdfsFileStatus getFileInfo(String src1, final boolean resolveLink) throws IOException {
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(src1);
        final String src = FSDirectory.resolvePath(src1, pathComponents, this.dir);
        HopsTransactionalRequestHandler getFileInfoHandler = new HopsTransactionalRequestHandler(HDFSOperationType.GET_FILE_INFO, src){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.READ, TransactionLockTypes.INodeResolveType.PATH, src).resolveSymLink(resolveLink).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(true);
                locks.add((Lock)il);
                locks.add(lf.getAcesLock());
            }

            public Object performTask() throws IOException {
                HdfsFileStatus stat;
                FSPermissionChecker pc = FSNamesystem.this.getPermissionChecker();
                try {
                    boolean isSuperUser = true;
                    if (FSNamesystem.this.isPermissionEnabled) {
                        FSNamesystem.this.checkPermission(pc, src, false, null, null, null, null, resolveLink);
                        isSuperUser = pc.isSuperUser();
                    }
                    stat = FSNamesystem.this.dir.getFileInfo(src, resolveLink, isSuperUser);
                }
                catch (AccessControlException e) {
                    FSNamesystem.this.logAuditEvent(false, "getfileinfo", src);
                    throw e;
                }
                FSNamesystem.this.logAuditEvent(true, "getfileinfo", src);
                return stat;
            }
        };
        if (!DFSUtil.isValidName(src)) {
            throw new InvalidPathException("Invalid file name: " + src);
        }
        return (HdfsFileStatus)getFileInfoHandler.handle(this);
    }

    boolean isFileClosed(final String src) throws AccessControlException, UnresolvedLinkException, StandbyException, IOException {
        HopsTransactionalRequestHandler isFileClosedHandler = new HopsTransactionalRequestHandler(HDFSOperationType.GET_FILE_INFO, src){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.READ, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes());
                locks.add((Lock)il);
            }

            public Object performTask() throws IOException {
                FSPermissionChecker pc = FSNamesystem.this.getPermissionChecker();
                try {
                    if (FSNamesystem.this.isPermissionEnabled) {
                        FSNamesystem.this.checkTraverse(pc, src);
                    }
                    return !INodeFile.valueOf(FSNamesystem.this.dir.getINode(src), src).isUnderConstruction();
                }
                catch (AccessControlException e) {
                    if (FSNamesystem.this.isAuditEnabled() && FSNamesystem.this.isExternalInvocation()) {
                        FSNamesystem.this.logAuditEvent(false, UserGroupInformation.getCurrentUser(), FSNamesystem.getRemoteIp(), "isFileClosed", src, null, null);
                    }
                    throw e;
                }
            }
        };
        return (Boolean)isFileClosedHandler.handle();
    }

    boolean mkdirs(String src1, final PermissionStatus permissions, final boolean createParent) throws IOException {
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(src1);
        final String src = FSDirectory.resolvePath(src1, pathComponents, this.dir);
        boolean resolvedLink = false;
        HopsTransactionalRequestHandler mkdirsHandler = new HopsTransactionalRequestHandler(HDFSOperationType.MKDIRS, src){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE_ON_TARGET_AND_PARENT, TransactionLockTypes.INodeResolveType.PATH, src).resolveSymLink(false).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(!FSNamesystem.this.dir.isQuotaEnabled());
                locks.add((Lock)il);
                locks.add(lf.getAcesLock());
            }

            public Object performTask() throws IOException {
                try {
                    return FSNamesystem.this.mkdirsInt(src, permissions, createParent);
                }
                catch (AccessControlException e) {
                    FSNamesystem.this.logAuditEvent(false, "mkdirs", src);
                    throw e;
                }
            }
        };
        return (Boolean)mkdirsHandler.handle(this);
    }

    private boolean mkdirsInt(String src, PermissionStatus permissions, boolean createParent) throws IOException {
        FSPermissionChecker pc;
        HdfsFileStatus resultingStat = null;
        boolean status = false;
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)(this.getNamenodeId() + ") DIR* NameSystem.mkdirs: " + src));
        }
        if (status = this.mkdirsInternal(pc = this.getPermissionChecker(), src, permissions, createParent)) {
            resultingStat = this.dir.getFileInfo(src, false, false);
        }
        if (status) {
            this.logAuditEvent(true, "mkdirs", src, null, resultingStat);
        }
        return status;
    }

    private boolean mkdirsInternal(FSPermissionChecker pc, String src, PermissionStatus permissions, boolean createParent) throws IOException {
        this.checkNameNodeSafeMode("Cannot create directory " + src);
        if (this.isPermissionEnabled) {
            this.checkTraverse(pc, src);
        }
        if (this.dir.isDir(src)) {
            return true;
        }
        if (!DFSUtil.isValidName(src)) {
            throw new InvalidPathException(src);
        }
        if (this.isPermissionEnabled) {
            this.checkAncestorAccess(pc, src, FsAction.WRITE);
        }
        if (!createParent) {
            this.verifyParentDir(src);
        }
        this.checkFsObjectLimit();
        if (!this.dir.mkdirs(src, permissions, false, Time.now())) {
            throw new IOException("Failed to create directory: " + src);
        }
        return true;
    }

    ContentSummary getContentSummary(String src) throws IOException {
        return this.multiTransactionalGetContentSummary(src);
    }

    void fsync(final String src, final String clientName, final long lastBlockLength) throws IOException {
        new HopsTransactionalRequestHandler(HDFSOperationType.FSYNC, src){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes());
                locks.add((Lock)il).add(lf.getLeaseLock(TransactionLockTypes.LockType.READ, clientName)).add(lf.getLeasePathLock(TransactionLockTypes.LockType.READ_COMMITTED)).add(lf.getBlockLock());
            }

            public Object performTask() throws IOException {
                NameNode.stateChangeLog.info((Object)("BLOCK* fsync: " + src + " for " + clientName));
                FSNamesystem.this.checkNameNodeSafeMode("Cannot fsync file " + src);
                INodeFile pendingFile = FSNamesystem.this.checkLease(src, clientName);
                if (lastBlockLength > 0L) {
                    pendingFile.getFileUnderConstructionFeature().updateLengthOfLastBlock(pendingFile, lastBlockLength);
                }
                FSNamesystem.this.dir.persistBlocks(src, pendingFile);
                pendingFile.recomputeFileSize();
                return null;
            }
        }.handle(this);
    }

    boolean internalReleaseLease(Lease lease, String src, String recoveryLeaseHolder) throws IOException {
        int nrCompleteBlocks;
        LOG.info((Object)("Recovering " + lease + ", src=" + src));
        assert (!this.isInSafeMode());
        INodeFile pendingFile = INodeFile.valueOf(this.dir.getINode(src), src);
        int nrBlocks = pendingFile.numBlocks();
        BlockInfo[] blocks = pendingFile.getBlocks();
        BlockInfo curBlock = null;
        for (nrCompleteBlocks = 0; nrCompleteBlocks < nrBlocks && (curBlock = blocks[nrCompleteBlocks]).isComplete(); ++nrCompleteBlocks) {
            assert (this.blockManager.checkMinReplication(curBlock)) : "A COMPLETE block is not minimally replicated in " + src;
        }
        if (nrCompleteBlocks == nrBlocks) {
            this.finalizeINodeFileUnderConstruction(src, pendingFile);
            NameNode.stateChangeLog.warn((Object)"BLOCK* internalReleaseLease: All existing blocks are COMPLETE, lease removed, file closed.");
            return true;
        }
        if (nrCompleteBlocks < nrBlocks - 2 || nrCompleteBlocks == nrBlocks - 2 && curBlock != null && curBlock.getBlockUCState() != HdfsServerConstants.BlockUCState.COMMITTED) {
            String message = "DIR* NameSystem.internalReleaseLease: attempt to release a create lock on " + src + " but file is already closed.";
            NameNode.stateChangeLog.warn((Object)message);
            throw new IOException(message);
        }
        BlockInfo lastBlock = pendingFile.getLastBlock();
        HdfsServerConstants.BlockUCState lastBlockState = lastBlock.getBlockUCState();
        BlockInfo penultimateBlock = pendingFile.getPenultimateBlock();
        boolean penultimateBlockMinReplication = penultimateBlock == null ? true : this.blockManager.checkMinReplication(penultimateBlock);
        switch (lastBlockState) {
            case COMPLETE: {
                assert (false) : "Already checked that the last block is incomplete";
                break;
            }
            case COMMITTED: {
                if (penultimateBlockMinReplication && this.blockManager.checkMinReplication(lastBlock)) {
                    this.finalizeINodeFileUnderConstruction(src, pendingFile);
                    NameNode.stateChangeLog.warn((Object)"BLOCK* internalReleaseLease: Committed blocks are minimally replicated, lease removed, file closed.");
                    return true;
                }
                String message = "DIR* NameSystem.internalReleaseLease: Failed to release lease for file " + src + ". Committed blocks are waiting to be minimally replicated. Try again later.";
                NameNode.stateChangeLog.warn((Object)message);
                throw new AlreadyBeingCreatedException(message);
            }
            case UNDER_CONSTRUCTION: 
            case UNDER_RECOVERY: {
                BlockInfoUnderConstruction uc = (BlockInfoUnderConstruction)lastBlock;
                if (uc.getNumExpectedLocations() == 0) {
                    uc.setExpectedLocations(this.blockManager.getStorages(lastBlock));
                }
                if (uc.getNumExpectedLocations() == 0 && uc.getNumBytes() == 0L) {
                    pendingFile.removeLastBlock(lastBlock);
                    this.finalizeINodeFileUnderConstruction(src, pendingFile);
                    NameNode.stateChangeLog.warn((Object)"BLOCK* internalReleaseLease: Removed empty last block and closed file.");
                    return true;
                }
                long blockRecoveryId = pendingFile.nextGenerationStamp();
                lease = this.reassignLease(lease, src, recoveryLeaseHolder, pendingFile);
                uc.initializeBlockRecovery(blockRecoveryId, this.getBlockManager().getDatanodeManager());
                this.leaseManager.renewLease(lease);
                NameNode.stateChangeLog.warn((Object)("DIR* NameSystem.internalReleaseLease: File " + src + " has not been closed. Lease recovery is in progress. RecoveryId = " + blockRecoveryId + " for block " + lastBlock));
            }
        }
        return false;
    }

    private Lease reassignLease(Lease lease, String src, String newHolder, INodeFile pendingFile) throws StorageException, TransactionContextException {
        if (newHolder == null) {
            return lease;
        }
        return this.reassignLeaseInternal(lease, src, newHolder, pendingFile);
    }

    private Lease reassignLeaseInternal(Lease lease, String src, String newHolder, INodeFile pendingFile) throws StorageException, TransactionContextException {
        pendingFile.getFileUnderConstructionFeature().setClientName(newHolder);
        return this.leaseManager.reassignLease(lease, src, newHolder);
    }

    private void commitOrCompleteLastBlock(INodeFile fileINode, Block commitBlock) throws IOException {
        long diff;
        Preconditions.checkArgument((boolean)fileINode.isUnderConstruction());
        if (!this.blockManager.commitOrCompleteLastBlock(fileINode, commitBlock)) {
            return;
        }
        fileINode.recomputeFileSize();
        if (this.dir.isQuotaEnabled() && (diff = fileINode.getPreferredBlockSize() - commitBlock.getNumBytes()) > 0L) {
            String path = fileINode.getFullPathName();
            this.dir.updateSpaceConsumed(path, 0L, -diff * (long)fileINode.getBlockReplication());
        }
    }

    private void finalizeINodeFileUnderConstruction(String src, INodeFile pendingFile) throws IOException {
        this.finalizeINodeFileUnderConstructionInternal(src, pendingFile, false);
    }

    private void finalizeINodeFileUnderConstructionStoredInDB(String src, INodeFile pendingFile) throws IOException {
        this.finalizeINodeFileUnderConstructionInternal(src, pendingFile, true);
    }

    private void finalizeINodeFileUnderConstructionInternal(String src, INodeFile pendingFile, boolean skipReplicationChecks) throws IOException {
        FileUnderConstructionFeature uc = pendingFile.getFileUnderConstructionFeature();
        Preconditions.checkArgument((uc != null ? 1 : 0) != 0);
        this.leaseManager.removeLease(uc.getClientName(), src);
        INodeFile newFile = pendingFile.toCompleteFile(Time.now());
        this.dir.closeFile(src, newFile);
        if (!skipReplicationChecks) {
            this.blockManager.checkReplication(newFile);
        }
    }

    void commitBlockSynchronization(final ExtendedBlock lastBlock, final long newGenerationStamp, final long newLength, final boolean closeFile, final boolean deleteBlock, final DatanodeID[] newTargets, final String[] newTargetStorages) throws IOException {
        new HopsTransactionalRequestHandler(HDFSOperationType.COMMIT_BLOCK_SYNCHRONIZATION){
            INodeIdentifier inodeIdentifier;

            @Override
            public void setUp() throws StorageException {
                this.inodeIdentifier = INodeUtil.resolveINodeFromBlock(lastBlock.getLocalBlock());
            }

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getIndividualINodeLock(TransactionLockTypes.INodeLockType.WRITE, this.inodeIdentifier, true)).add(lf.getLeaseLock(TransactionLockTypes.LockType.WRITE)).add(lf.getLeasePathLock(TransactionLockTypes.LockType.READ_COMMITTED)).add(lf.getBlockLock(lastBlock.getBlockId(), this.inodeIdentifier)).add(lf.getBlockRelated(LockFactory.BLK.RE, LockFactory.BLK.CR, LockFactory.BLK.ER, LockFactory.BLK.UC, LockFactory.BLK.UR));
            }

            public Object performTask() throws IOException {
                FSNamesystem.this.checkNameNodeSafeMode("Cannot commitBlockSynchronization while in safe mode");
                LOG.info((Object)("commitBlockSynchronization(lastBlock=" + lastBlock + ", newGenerationStamp=" + newGenerationStamp + ", newLength=" + newLength + ", newTargets=" + Arrays.asList(newTargets) + ", closeFile=" + closeFile + ", deleteBlock=" + deleteBlock + ")"));
                BlockInfo storedBlock = FSNamesystem.this.getStoredBlock(ExtendedBlock.getLocalBlock(lastBlock));
                if (storedBlock == null) {
                    if (deleteBlock) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Block (=" + lastBlock + ") not found"));
                        }
                        return null;
                    }
                    throw new IOException("Block (=" + lastBlock + ") not found");
                }
                INodeFile iFile = ((INode)((Object)storedBlock.getBlockCollection())).asFile();
                if (!iFile.isUnderConstruction() || storedBlock.isComplete()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Unexpected block (=" + lastBlock + ") since the file (=" + iFile.getLocalName() + ") is not under construction"));
                    }
                    return null;
                }
                long recoveryId = ((BlockInfoUnderConstruction)storedBlock).getBlockRecoveryId();
                if (recoveryId != newGenerationStamp) {
                    throw new IOException("The recovery id " + newGenerationStamp + " does not match current recovery id " + recoveryId + " for block " + lastBlock);
                }
                if (deleteBlock) {
                    Block blockToDel = ExtendedBlock.getLocalBlock(lastBlock);
                    boolean remove = iFile.removeLastBlock(blockToDel);
                    if (remove) {
                        FSNamesystem.this.blockManager.removeBlockFromMap(storedBlock);
                    }
                } else {
                    int i;
                    storedBlock.setGenerationStamp(newGenerationStamp);
                    storedBlock.setNumBytes(newLength);
                    iFile.recomputeFileSize();
                    ArrayList<DatanodeDescriptor> trimmedTargets = new ArrayList<DatanodeDescriptor>(newTargets.length);
                    ArrayList<String> trimmedStorages = new ArrayList<String>(newTargets.length);
                    for (i = 0; i < newTargets.length; ++i) {
                        DatanodeDescriptor targetNode = FSNamesystem.this.blockManager.getDatanodeManager().getDatanode(newTargets[i]);
                        if (targetNode != null) {
                            trimmedTargets.add(targetNode);
                            trimmedStorages.add(newTargetStorages[i]);
                            continue;
                        }
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("DatanodeDescriptor (=" + newTargets[i] + ") not found"));
                    }
                    if (closeFile && !trimmedTargets.isEmpty()) {
                        for (i = 0; i < trimmedTargets.size(); ++i) {
                            DatanodeStorageInfo storageInfo = ((DatanodeDescriptor)trimmedTargets.get(i)).getStorageInfo((String)trimmedStorages.get(i));
                            if (storageInfo == null) continue;
                            storageInfo.addBlock(storedBlock);
                        }
                    }
                    DatanodeStorageInfo[] trimmedStorageInfos = FSNamesystem.this.blockManager.getDatanodeManager().getDatanodeStorageInfos(trimmedTargets.toArray(new DatanodeID[trimmedTargets.size()]), trimmedStorages.toArray(new String[trimmedStorages.size()]));
                    iFile.setLastBlock(storedBlock, trimmedStorageInfos);
                }
                String src = closeFile ? FSNamesystem.this.closeFileCommitBlocks(iFile, storedBlock) : FSNamesystem.this.persistBlocks(iFile);
                if (closeFile) {
                    LOG.info((Object)("commitBlockSynchronization(newBlock=" + lastBlock + ", file=" + src + ", newGenerationStamp=" + newGenerationStamp + ", newLength=" + newLength + ", newTargets=" + Arrays.asList(newTargets) + ") successful"));
                } else {
                    LOG.info((Object)("commitBlockSynchronization(" + lastBlock + ") successful"));
                }
                return null;
            }
        }.handle(this);
    }

    @VisibleForTesting
    String closeFileCommitBlocks(INodeFile pendingFile, BlockInfo storedBlock) throws IOException {
        String src = pendingFile.getFullPathName();
        this.commitOrCompleteLastBlock(pendingFile, storedBlock);
        this.finalizeINodeFileUnderConstruction(src, pendingFile);
        return src;
    }

    @VisibleForTesting
    String persistBlocks(INodeFile pendingFile) throws IOException {
        String src = pendingFile.getFullPathName();
        this.dir.persistBlocks(src, pendingFile);
        return src;
    }

    @VisibleForTesting
    BlockInfo getStoredBlock(Block block) throws StorageException, TransactionContextException {
        return this.blockManager.getStoredBlock(block);
    }

    void renewLease(final String holder) throws IOException {
        new HopsTransactionalRequestHandler(HDFSOperationType.RENEW_LEASE){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getLeaseLock(TransactionLockTypes.LockType.WRITE, holder));
            }

            public Object performTask() throws IOException {
                FSNamesystem.this.checkNameNodeSafeMode("Cannot renew lease for " + holder);
                FSNamesystem.this.leaseManager.renewLease(holder);
                return null;
            }
        }.handle(this);
    }

    DirectoryListing getListing(String src1, byte[] startAfter1, final boolean needLocation) throws IOException {
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(src1);
        String startAfterString = new String(startAfter1);
        final String src = FSDirectory.resolvePath(src1, pathComponents, this.dir);
        if (FSDirectory.isReservedName(startAfterString)) {
            byte[][] startAfterComponents = FSDirectory.getPathComponentsForReservedPath(startAfterString);
            try {
                String tmp = FSDirectory.resolvePath(src, startAfterComponents, this.dir);
                byte[][] regularPath = INode.getPathComponents(tmp);
                startAfter1 = regularPath[regularPath.length - 1];
            }
            catch (IOException e) {
                throw new DirectoryListingStartAfterNotFoundException("Can't find startAfter " + startAfterString);
            }
        }
        final byte[] startAfter = startAfter1;
        HopsTransactionalRequestHandler getListingHandler = new HopsTransactionalRequestHandler(HDFSOperationType.GET_LISTING, src){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.READ, TransactionLockTypes.INodeResolveType.PATH_AND_IMMEDIATE_CHILDREN, src).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(true);
                locks.add((Lock)il);
                if (needLocation) {
                    locks.add(lf.getBlockLock()).add(lf.getBlockRelated(LockFactory.BLK.RE, LockFactory.BLK.ER, LockFactory.BLK.CR, LockFactory.BLK.UC, LockFactory.BLK.CA));
                }
                locks.add(lf.getAcesLock());
            }

            public Object performTask() throws IOException {
                try {
                    return FSNamesystem.this.getListingInt(src, startAfter, needLocation);
                }
                catch (AccessControlException e) {
                    FSNamesystem.this.logAuditEvent(false, "listStatus", src);
                    throw e;
                }
            }
        };
        return (DirectoryListing)getListingHandler.handle(this);
    }

    private DirectoryListing getListingInt(String src, byte[] startAfter, boolean needLocation) throws IOException {
        FSPermissionChecker pc = this.getPermissionChecker();
        boolean isSuperUser = true;
        if (this.isPermissionEnabled) {
            if (this.dir.isDir(src)) {
                this.checkPathAccess(pc, src, FsAction.READ_EXECUTE);
            } else {
                this.checkTraverse(pc, src);
            }
            isSuperUser = pc.isSuperUser();
        }
        this.logAuditEvent(true, "listStatus", src);
        DirectoryListing dl = this.dir.getListing(src, startAfter, needLocation, isSuperUser);
        return dl;
    }

    void registerDatanode(DatanodeRegistration nodeReg) throws IOException {
        this.getBlockManager().getDatanodeManager().registerDatanode(nodeReg);
        this.checkSafeMode();
    }

    String getRegistrationID() throws IOException {
        return Storage.getRegistrationID(StorageInfo.getStorageInfoFromDB());
    }

    HeartbeatResponse handleHeartbeat(DatanodeRegistration nodeReg, StorageReport[] reports, long cacheCapacity, long cacheUsed, int xceiverCount, int xmitsInProgress, int failedVolumes) throws IOException {
        int maxTransfer = this.blockManager.getMaxReplicationStreams() - xmitsInProgress;
        DatanodeCommand[] cmds = this.blockManager.getDatanodeManager().handleHeartbeat(nodeReg, reports, this.blockPoolId, cacheCapacity, cacheUsed, xceiverCount, maxTransfer, failedVolumes);
        return new HeartbeatResponse(cmds, this.getRollingUpgradeInfoTX());
    }

    private boolean nameNodeHasResourcesAvailable() {
        return this.hasResourcesAvailable;
    }

    private void checkBlock(ExtendedBlock block) throws IOException {
        if (block != null && !this.blockPoolId.equals(block.getBlockPoolId())) {
            throw new IOException("Unexpected BlockPoolId " + block.getBlockPoolId() + " - expected " + this.blockPoolId);
        }
    }

    @Metric(value={"MissingBlocks", "Number of missing blocks"})
    public long getMissingBlocksCount() throws IOException {
        return this.blockManager.getMissingBlocksCount();
    }

    @Metric(value={"ExpiredHeartbeats", "Number of expired heartbeats"})
    public int getExpiredHeartbeats() {
        return this.datanodeStatistics.getExpiredHeartbeats();
    }

    long[] getStats() throws IOException {
        long[] stats = this.datanodeStatistics.getStats();
        stats[3] = this.getUnderReplicatedBlocks();
        stats[4] = this.getCorruptReplicaBlocks();
        stats[5] = this.getMissingBlocksCount();
        return stats;
    }

    @Override
    @Metric(value={"CapacityTotal", "Total raw capacity of data nodes in bytes"})
    public long getCapacityTotal() {
        return this.datanodeStatistics.getCapacityTotal();
    }

    @Metric(value={"CapacityTotalGB", "Total raw capacity of data nodes in GB"})
    public float getCapacityTotalGB() {
        return DFSUtil.roundBytesToGB(this.getCapacityTotal());
    }

    @Override
    @Metric(value={"CapacityUsed", "Total used capacity across all data nodes in bytes"})
    public long getCapacityUsed() {
        return this.datanodeStatistics.getCapacityUsed();
    }

    @Metric(value={"CapacityUsedGB", "Total used capacity across all data nodes in GB"})
    public float getCapacityUsedGB() {
        return DFSUtil.roundBytesToGB(this.getCapacityUsed());
    }

    @Override
    @Metric(value={"CapacityRemaining", "Remaining capacity in bytes"})
    public long getCapacityRemaining() {
        return this.datanodeStatistics.getCapacityRemaining();
    }

    @Metric(value={"CapacityRemainingGB", "Remaining capacity in GB"})
    public float getCapacityRemainingGB() {
        return DFSUtil.roundBytesToGB(this.getCapacityRemaining());
    }

    @Metric(value={"CapacityUsedNonDFS", "Total space used by data nodes for non DFS purposes in bytes"})
    public long getCapacityUsedNonDFS() {
        return this.datanodeStatistics.getCapacityUsedNonDFS();
    }

    @Override
    @Metric
    public int getTotalLoad() {
        return this.datanodeStatistics.getXceiverCount();
    }

    int getNumberOfDatanodes(HdfsConstants.DatanodeReportType type) {
        return this.getBlockManager().getDatanodeManager().getDatanodeListForReport(type).size();
    }

    DatanodeInfo[] datanodeReport(HdfsConstants.DatanodeReportType type) throws AccessControlException {
        this.checkSuperuserPrivilege();
        DatanodeManager dm = this.getBlockManager().getDatanodeManager();
        List<DatanodeDescriptor> results = dm.getDatanodeListForReport(type);
        DatanodeInfo[] arr = new DatanodeInfo[results.size()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = new DatanodeInfo(results.get(i));
        }
        return arr;
    }

    DatanodeStorageReport[] getDatanodeStorageReport(HdfsConstants.DatanodeReportType type) throws AccessControlException, StandbyException {
        this.checkSuperuserPrivilege();
        DatanodeManager dm = this.getBlockManager().getDatanodeManager();
        List<DatanodeDescriptor> datanodes = dm.getDatanodeListForReport(type);
        DatanodeStorageReport[] reports = new DatanodeStorageReport[datanodes.size()];
        for (int i = 0; i < reports.length; ++i) {
            DatanodeDescriptor d = datanodes.get(i);
            reports[i] = new DatanodeStorageReport(new DatanodeInfo(d), d.getStorageReports());
        }
        return reports;
    }

    Date getStartTime() {
        return new Date(this.startTime);
    }

    void refreshNodes() throws IOException {
        this.checkSuperuserPrivilege();
        this.getBlockManager().getDatanodeManager().refreshNodes(new HdfsConfiguration());
    }

    void setBalancerBandwidth(long bandwidth) throws IOException {
        this.checkSuperuserPrivilege();
        this.getBlockManager().getDatanodeManager().setBalancerBandwidth(bandwidth);
    }

    boolean setSafeMode(HdfsConstants.SafeModeAction action) throws IOException {
        if (action != HdfsConstants.SafeModeAction.SAFEMODE_GET) {
            this.checkSuperuserPrivilege();
            switch (action) {
                case SAFEMODE_LEAVE: {
                    this.leaveSafeMode();
                    break;
                }
                case SAFEMODE_ENTER: {
                    this.enterSafeMode(false);
                    break;
                }
                default: {
                    LOG.error((Object)"Unexpected safe mode action");
                }
            }
        }
        return this.isInSafeMode();
    }

    @Override
    public void checkSafeMode() throws IOException {
        SafeModeInfo safeMode = this.safeMode();
        if (safeMode != null) {
            safeMode.checkMode();
        }
    }

    @Override
    public boolean isInSafeMode() throws IOException {
        SafeModeInfo safeMode = this.safeMode();
        if (safeMode == null) {
            return false;
        }
        if (safeMode.isOn() && !this.isLeader()) {
            safeMode.tryToHelpToGetOut();
        }
        return safeMode.isOn();
    }

    private SafeModeInfo safeMode() throws IOException {
        List<Object> vals = HdfsVariables.getSafeModeFromDB();
        if (vals == null || vals.isEmpty()) {
            return null;
        }
        return new SafeModeInfo((Double)vals.get(0), (Integer)vals.get(1), (Integer)vals.get(2), (Integer)vals.get(3), (Double)vals.get(4), (Integer)vals.get(5) == 0);
    }

    @Override
    public boolean isInStartupSafeMode() throws IOException {
        SafeModeInfo safeMode = this.safeMode();
        if (safeMode == null) {
            return false;
        }
        return !safeMode.isManual() && !safeMode.areResourcesLow() && safeMode.isOn();
    }

    @Override
    public boolean isPopulatingReplQueues() throws IOException {
        if (!this.shouldPopulateReplicationQueues()) {
            return false;
        }
        SafeModeInfo safeMode = this.safeMode();
        if (safeMode == null) {
            return true;
        }
        return this.initializedReplQueues;
    }

    private boolean shouldPopulateReplicationQueues() {
        return this.shouldPopulateReplicationQueue;
    }

    @Override
    public void incrementSafeBlockCount(int replication, BlockInfo blk) throws IOException {
        SafeModeInfo safeMode = this.safeMode();
        if (safeMode == null) {
            return;
        }
        safeMode.incrementSafeBlockCount((short)replication, blk);
    }

    @Override
    public void decrementSafeBlockCount(BlockInfo b) throws IOException {
        SafeModeInfo safeMode = this.safeMode();
        if (safeMode == null) {
            return;
        }
        if (b.isComplete()) {
            safeMode.decrementSafeBlockCount(b, (short)this.blockManager.countNodes(b).liveReplicas());
        }
    }

    @Override
    public void adjustSafeModeBlockTotals(List<Block> deltaSafe, int deltaTotal) throws IOException {
        SafeModeInfo safeMode = this.safeMode();
        if (safeMode == null) {
            return;
        }
        safeMode.adjustBlockTotals(deltaSafe, deltaTotal);
    }

    private void setBlockTotal() throws IOException {
        SafeModeInfo safeMode = this.safeMode();
        if (safeMode == null) {
            return;
        }
        safeMode.setBlockTotal(this.blockManager.getTotalCompleteBlocks());
    }

    @Override
    public long getCacheCapacity() {
        return this.datanodeStatistics.getCacheCapacity();
    }

    @Override
    public long getCacheUsed() {
        return this.datanodeStatistics.getCacheUsed();
    }

    @Override
    @Metric
    public long getBlocksTotal() throws IOException {
        return this.blockManager.getTotalBlocks();
    }

    private long getCompleteBlocksTotal() throws IOException {
        long numUCBlocks = 0L;
        for (final Lease lease : this.leaseManager.getSortedLeases()) {
            HopsTransactionalRequestHandler ucBlocksHandler = new HopsTransactionalRequestHandler(HDFSOperationType.GET_LISTING){
                private Set<String> leasePaths;
                {
                    super(opType);
                    this.leasePaths = null;
                }

                @Override
                public void setUp() throws StorageException {
                    String holder = lease.getHolder();
                    this.leasePaths = INodeUtil.findPathsByLeaseHolder(holder);
                    if (this.leasePaths != null) {
                        LOG.debug((Object)("Total Paths " + this.leasePaths.size() + " Paths: " + Arrays.toString(this.leasePaths.toArray())));
                    }
                }

                public void acquireLock(TransactionLocks locks) throws IOException {
                    String holder = lease.getHolder();
                    LockFactory lf = LockFactory.getInstance();
                    INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.READ, TransactionLockTypes.INodeResolveType.PATH_AND_IMMEDIATE_CHILDREN, this.leasePaths.toArray(new String[this.leasePaths.size()])).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes());
                    locks.add((Lock)il).add(lf.getLeaseLock(TransactionLockTypes.LockType.READ, holder)).add(lf.getLeasePathLock(TransactionLockTypes.LockType.READ)).add(lf.getBlockLock()).add(lf.getBlockRelated(LockFactory.BLK.RE, LockFactory.BLK.CR, LockFactory.BLK.ER, LockFactory.BLK.UC, LockFactory.BLK.UR));
                }

                public Object performTask() throws IOException {
                    int numUCBlocks = 0;
                    for (LeasePath leasePath : lease.getPaths()) {
                        INodeFile cons;
                        String path = leasePath.getPath();
                        try {
                            cons = FSNamesystem.this.dir.getINode(path).asFile();
                            Preconditions.checkState((boolean)cons.isUnderConstruction());
                        }
                        catch (UnresolvedLinkException e) {
                            throw new AssertionError((Object)"Lease files should reside on this FS");
                        }
                        BlockInfo[] blocks = cons.getBlocks();
                        if (blocks == null) continue;
                        for (BlockInfo b : blocks) {
                            if (b.isComplete()) continue;
                            ++numUCBlocks;
                        }
                    }
                    return numUCBlocks;
                }
            };
            numUCBlocks += (long)((Integer)ucBlocksHandler.handle()).intValue();
        }
        LOG.info((Object)("Number of blocks under construction: " + numUCBlocks));
        return this.getBlocksTotal() - numUCBlocks;
    }

    void enterSafeMode(boolean resourcesLow) throws IOException {
        if (!this.isLeader()) {
            return;
        }
        this.stopSecretManager();
        this.shouldPopulateReplicationQueue = true;
        SafeModeInfo safeMode = this.safeMode();
        if (safeMode != null) {
            if (resourcesLow) {
                safeMode.setResourcesLow();
            } else {
                safeMode.setManual();
            }
        }
        if (!this.isInSafeMode()) {
            safeMode = new SafeModeInfo(resourcesLow);
        }
        if (resourcesLow) {
            safeMode.setResourcesLow();
        } else {
            safeMode.setManual();
        }
        HdfsVariables.setSafeModeInfo(safeMode, 0L);
        NameNode.stateChangeLog.info((Object)("STATE* Safe mode is ON" + safeMode.getTurnOffTip()));
    }

    void leaveSafeMode() throws IOException {
        if (!this.isInSafeMode()) {
            NameNode.stateChangeLog.info((Object)"STATE* Safe mode is already OFF");
            return;
        }
        this.safeMode().leave();
    }

    String getSafeModeTip() throws IOException {
        boolean inSafeMode;
        if (!this.isInSafeMode()) {
            return "";
        }
        SafeModeInfo safeMode = this.safeMode();
        if (safeMode == null) {
            inSafeMode = false;
        } else {
            if (safeMode.isOn() && !this.isLeader()) {
                safeMode.tryToHelpToGetOut();
            }
            inSafeMode = safeMode.isOn();
        }
        if (!inSafeMode) {
            return "";
        }
        return safeMode.getTurnOffTip();
    }

    public void processIncrementalBlockReport(DatanodeRegistration nodeReg, StorageReceivedDeletedBlocks r) throws IOException {
        this.blockManager.processIncrementalBlockReport(nodeReg, r);
    }

    PermissionStatus createFsOwnerPermissions(FsPermission permission) {
        return new PermissionStatus(this.fsOwner.getShortUserName(), this.superGroup, permission);
    }

    private void checkOwner(FSPermissionChecker pc, String path) throws IOException {
        this.checkPermission(pc, path, true, null, null, null, null);
    }

    private void checkPathAccess(FSPermissionChecker pc, String path, FsAction access) throws IOException {
        this.checkPermission(pc, path, false, null, null, access, null);
    }

    private void checkParentAccess(FSPermissionChecker pc, String path, FsAction access) throws IOException {
        this.checkPermission(pc, path, false, null, access, null, null);
    }

    private void checkAncestorAccess(FSPermissionChecker pc, String path, FsAction access) throws IOException {
        this.checkPermission(pc, path, false, access, null, null, null);
    }

    private void checkTraverse(FSPermissionChecker pc, String path) throws IOException {
        this.checkPermission(pc, path, false, null, null, null, null);
    }

    @Override
    public void checkSuperuserPrivilege() throws AccessControlException {
        if (this.isPermissionEnabled) {
            FSPermissionChecker pc = this.getPermissionChecker();
            pc.checkSuperuserPrivilege();
        }
    }

    private void checkPermission(FSPermissionChecker pc, String path, boolean doCheckOwner, FsAction ancestorAccess, FsAction parentAccess, FsAction access, FsAction subAccess) throws AccessControlException, UnresolvedLinkException, IOException {
        this.checkPermission(pc, path, doCheckOwner, ancestorAccess, parentAccess, access, subAccess, true);
    }

    private void checkPermission(FSPermissionChecker pc, String path, boolean doCheckOwner, FsAction ancestorAccess, FsAction parentAccess, FsAction access, FsAction subAccess, boolean resolveLink) throws AccessControlException, UnresolvedLinkException, TransactionContextException, IOException {
        if (!pc.isSuperUser()) {
            pc.checkPermission(path, this.dir, doCheckOwner, ancestorAccess, parentAccess, access, subAccess, resolveLink);
        }
    }

    private void checkFsObjectLimit() throws IOException {
        if (this.maxFsObjects != 0L && this.maxFsObjects <= this.dir.totalInodes() + this.getBlocksTotal()) {
            throw new IOException("Exceeded the configured number of objects " + this.maxFsObjects + " in the filesystem.");
        }
    }

    @Override
    public long getMaxObjects() {
        return this.maxFsObjects;
    }

    @Override
    @Metric
    public long getFilesTotal() {
        try {
            return this.dir.totalInodes();
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            return -1L;
        }
    }

    @Override
    @Metric
    public long getPendingReplicationBlocks() {
        return this.blockManager.getPendingReplicationBlocksCount();
    }

    @Override
    @Metric
    public long getUnderReplicatedBlocks() {
        return this.blockManager.getUnderReplicatedBlocksCount();
    }

    @Metric(value={"CorruptBlocks", "Number of blocks with corrupt replicas"})
    public long getCorruptReplicaBlocks() {
        return this.blockManager.getCorruptReplicaBlocksCount();
    }

    @Override
    @Metric
    public long getScheduledReplicationBlocks() {
        return this.blockManager.getScheduledReplicationBlocksCount();
    }

    @Override
    @Metric
    public long getPendingDeletionBlocks() throws IOException {
        return this.blockManager.getPendingDeletionBlocksCount();
    }

    @Metric
    public long getExcessBlocks() throws IOException {
        return this.blockManager.getExcessBlocksCount();
    }

    @Metric
    public long getPostponedMisreplicatedBlocks() {
        return this.blockManager.getPostponedMisreplicatedBlocksCount();
    }

    @Metric
    public int getBlockCapacity() {
        return this.blockManager.getCapacity();
    }

    @Override
    public String getFSState() throws IOException {
        return this.isInSafeMode() ? "safeMode" : "Operational";
    }

    private void registerMBean() {
        try {
            StandardMBean bean = new StandardMBean(this, FSNamesystemMBean.class);
            this.mbeanName = MBeans.register((String)"NameNode", (String)"FSNamesystemState", (Object)bean);
        }
        catch (NotCompliantMBeanException e) {
            throw new RuntimeException("Bad MBean setup", e);
        }
        LOG.info((Object)"Registered FSNamesystemState MBean");
    }

    void shutdown() {
        if (this.mbeanName != null) {
            MBeans.unregister((ObjectName)this.mbeanName);
            this.mbeanName = null;
        }
        if (this.mxbeanName != null) {
            MBeans.unregister((ObjectName)this.mxbeanName);
            this.mxbeanName = null;
        }
        if (this.blockManager != null) {
            this.blockManager.shutdown();
        }
    }

    @Override
    @Metric(value={"LiveDataNodes", "Number of datanodes marked as live"})
    public int getNumLiveDataNodes() {
        return this.getBlockManager().getDatanodeManager().getNumLiveDataNodes();
    }

    @Override
    @Metric(value={"DeadDataNodes", "Number of datanodes marked dead due to delayed heartbeat"})
    public int getNumDeadDataNodes() {
        return this.getBlockManager().getDatanodeManager().getNumDeadDataNodes();
    }

    @Override
    public int getNumDecomLiveDataNodes() {
        ArrayList<DatanodeDescriptor> live = new ArrayList<DatanodeDescriptor>();
        this.getBlockManager().getDatanodeManager().fetchDatanodes(live, null, true);
        int liveDecommissioned = 0;
        for (DatanodeDescriptor node : live) {
            liveDecommissioned += node.isDecommissioned() ? 1 : 0;
        }
        return liveDecommissioned;
    }

    @Override
    public int getNumDecomDeadDataNodes() {
        ArrayList<DatanodeDescriptor> dead = new ArrayList<DatanodeDescriptor>();
        this.getBlockManager().getDatanodeManager().fetchDatanodes(null, dead, true);
        int deadDecommissioned = 0;
        for (DatanodeDescriptor node : dead) {
            deadDecommissioned += node.isDecommissioned() ? 1 : 0;
        }
        return deadDecommissioned;
    }

    @Override
    public int getNumDecommissioningDataNodes() {
        return this.getBlockManager().getDatanodeManager().getDecommissioningNodes().size();
    }

    @Override
    @Metric(value={"StaleDataNodes", "Number of datanodes marked stale due to delayed heartbeat"})
    public int getNumStaleDataNodes() {
        return this.getBlockManager().getDatanodeManager().getNumStaleNodes();
    }

    @Override
    public int getNumStaleStorages() {
        return this.getBlockManager().getDatanodeManager().getNumStaleStorages();
    }

    private long nextBlockId() throws IOException {
        this.checkNameNodeSafeMode("Cannot get next block ID");
        return IDsGeneratorFactory.getInstance().getUniqueBlockID();
    }

    private INodeFile checkUCBlock(ExtendedBlock block, String clientName) throws IOException {
        this.checkNameNodeSafeMode("Cannot get a new generation stamp and an access token for block " + block);
        BlockInfo storedBlock = this.getStoredBlock(ExtendedBlock.getLocalBlock(block));
        if (storedBlock == null || storedBlock.getBlockUCState() != HdfsServerConstants.BlockUCState.UNDER_CONSTRUCTION) {
            throw new IOException(block + " does not exist or is not under Construction" + storedBlock);
        }
        INodeFile file = (INodeFile)storedBlock.getBlockCollection();
        if (file == null || !file.isUnderConstruction()) {
            throw new IOException("The file " + storedBlock + " belonged to does not exist or it is not under construction.");
        }
        if (clientName == null || !clientName.equals(file.getFileUnderConstructionFeature().getClientName())) {
            throw new LeaseExpiredException("Lease mismatch: " + block + " is accessed by a non lease holder " + clientName);
        }
        return file;
    }

    void reportBadBlocks(LocatedBlock[] blocks) throws IOException {
        NameNode.stateChangeLog.info((Object)"*DIR* reportBadBlocks");
        for (LocatedBlock block : blocks) {
            ExtendedBlock blk = block.getBlock();
            DatanodeInfo[] nodes = block.getLocations();
            String[] storageIDs = block.getStorageIDs();
            for (int j = 0; j < nodes.length; ++j) {
                this.blockManager.findAndMarkBlockAsCorrupt(blk, nodes[j], storageIDs == null ? null : storageIDs[j], "client machine reported it");
            }
        }
    }

    LocatedBlock updateBlockForPipeline(final ExtendedBlock block, final String clientName) throws IOException {
        HopsTransactionalRequestHandler updateBlockForPipelineHandler = new HopsTransactionalRequestHandler(HDFSOperationType.UPDATE_BLOCK_FOR_PIPELINE){
            INodeIdentifier inodeIdentifier;

            @Override
            public void setUp() throws StorageException {
                Block b = block.getLocalBlock();
                this.inodeIdentifier = INodeUtil.resolveINodeFromBlock(b);
            }

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getIndividualINodeLock(TransactionLockTypes.INodeLockType.WRITE, this.inodeIdentifier, true)).add(lf.getBlockLock(block.getBlockId(), this.inodeIdentifier));
            }

            public Object performTask() throws IOException {
                FSNamesystem.this.checkUCBlock(block, clientName);
                INodeFile pendingFile = (INodeFile)EntityManager.find((FinderType)INode.Finder.ByINodeIdFTIS, (Object[])new Object[]{this.inodeIdentifier.getInodeId()});
                block.setGenerationStamp(pendingFile.nextGenerationStamp());
                LocatedBlock locatedBlock = new LocatedBlock(block, new DatanodeInfo[0]);
                FSNamesystem.this.blockManager.setBlockToken(locatedBlock, BlockTokenSecretManager.AccessMode.WRITE);
                if (FSNamesystem.this.dir.isQuotaEnabled()) {
                    long diff = pendingFile.getPreferredBlockSize() - block.getNumBytes();
                    FSNamesystem.this.dir.updateSpaceConsumed(pendingFile.getFullPathName(), 0L, diff * (long)pendingFile.getBlockReplication());
                }
                return locatedBlock;
            }
        };
        return (LocatedBlock)updateBlockForPipelineHandler.handle(this);
    }

    void updatePipeline(final String clientName, final ExtendedBlock oldBlock, final ExtendedBlock newBlock, final DatanodeID[] newNodes, final String[] newStorageIDs) throws IOException {
        new HopsTransactionalRequestHandler(HDFSOperationType.UPDATE_PIPELINE){
            INodeIdentifier inodeIdentifier;

            @Override
            public void setUp() throws StorageException {
                Block b = oldBlock.getLocalBlock();
                this.inodeIdentifier = INodeUtil.resolveINodeFromBlock(b);
            }

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getIndividualINodeLock(TransactionLockTypes.INodeLockType.WRITE, this.inodeIdentifier, true)).add(lf.getLeaseLock(TransactionLockTypes.LockType.READ)).add(lf.getLeasePathLock(TransactionLockTypes.LockType.READ_COMMITTED)).add(lf.getBlockLock(oldBlock.getBlockId(), this.inodeIdentifier)).add(lf.getBlockRelated(LockFactory.BLK.UC)).add(lf.getLastBlockHashBucketsLock()).add(lf.getRetryCacheEntryLock(Server.getClientId(), Server.getCallId()));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object performTask() throws IOException {
                RetryCache.CacheEntry cacheEntry = RetryCacheDistributed.waitForCompletion((RetryCacheDistributed)FSNamesystem.this.retryCache);
                if (cacheEntry != null && cacheEntry.isSuccess()) {
                    return null;
                }
                boolean success = false;
                try {
                    FSNamesystem.this.checkNameNodeSafeMode("Pipeline not updated");
                    assert (newBlock.getBlockId() == oldBlock.getBlockId()) : newBlock + " and " + oldBlock + " has different block identifier";
                    LOG.info((Object)("updatePipeline(block=" + oldBlock + ", newGenerationStamp=" + newBlock.getGenerationStamp() + ", newLength=" + newBlock.getNumBytes() + ", newNodes=" + Arrays.asList(newNodes) + ", clientName=" + clientName + ")"));
                    FSNamesystem.this.updatePipelineInternal(clientName, oldBlock, newBlock, newNodes, newStorageIDs);
                    LOG.info((Object)("updatePipeline(" + oldBlock + ") successfully to " + newBlock));
                    success = true;
                    Object var3_3 = null;
                    return var3_3;
                }
                finally {
                    RetryCacheDistributed.setState((RetryCache.CacheEntry)cacheEntry, (boolean)success);
                }
            }
        }.handle(this);
    }

    private void updatePipelineInternal(String clientName, ExtendedBlock oldBlock, ExtendedBlock newBlock, DatanodeID[] newNodes, String[] newStorageIDs) throws IOException, StorageException {
        INodeFile pendingFile = this.checkUCBlock(oldBlock, clientName);
        pendingFile.getFileUnderConstructionFeature().updateLastTwoBlocks(this.leaseManager.getLease(clientName));
        BlockInfoUnderConstruction blockInfo = (BlockInfoUnderConstruction)pendingFile.getLastBlock();
        if (newBlock.getGenerationStamp() <= blockInfo.getGenerationStamp() || newBlock.getNumBytes() < blockInfo.getNumBytes()) {
            String msg = "Update " + oldBlock + " (len = " + blockInfo.getNumBytes() + ") to an older state: " + newBlock + " (len = " + newBlock.getNumBytes() + ")";
            LOG.warn((Object)msg);
            throw new IOException(msg);
        }
        for (DatanodeStorageInfo oldLocation : blockInfo.getStorages(this.blockManager.getDatanodeManager())) {
            HashBuckets.getInstance().undoHash(oldLocation.getSid(), HdfsServerConstants.ReplicaState.FINALIZED, oldBlock.getLocalBlock());
        }
        blockInfo.setNumBytes(newBlock.getNumBytes());
        blockInfo.setGenerationStampAndVerifyReplicas(newBlock.getGenerationStamp(), this.blockManager.getDatanodeManager());
        pendingFile.recomputeFileSize();
        DatanodeStorageInfo[] storages = this.blockManager.getDatanodeManager().getDatanodeStorageInfos(newNodes, newStorageIDs);
        blockInfo.setExpectedLocations(storages);
    }

    void unprotectedChangeLease(String src, String dst) throws StorageException, TransactionContextException {
        this.leaseManager.changeLease(src, dst);
    }

    Collection<CorruptFileBlockInfo> listCorruptFileBlocks(final String path, String[] cookieTab) throws IOException {
        this.checkSuperuserPrivilege();
        final int[] count = new int[]{0};
        final ArrayList<CorruptFileBlockInfo> corruptFiles = new ArrayList<CorruptFileBlockInfo>();
        if (cookieTab == null) {
            cookieTab = new String[]{null};
        }
        if (this.blockManager.getMissingBlocksCount() == 0L) {
            if (cookieTab[0] == null) {
                cookieTab[0] = String.valueOf(FSNamesystem.getIntCookie(cookieTab[0]));
            }
            LOG.info((Object)"there are no corrupt file blocks.");
            return corruptFiles;
        }
        if (!this.isPopulatingReplQueues()) {
            throw new IOException("Cannot run listCorruptFileBlocks because replication queues have not been initialized.");
        }
        Iterator<Block> blkIterator = this.blockManager.getCorruptReplicaBlockIterator();
        final int[] skip = new int[]{FSNamesystem.getIntCookie(cookieTab[0])};
        for (int i = 0; i < skip[0] && blkIterator.hasNext(); ++i) {
            blkIterator.next();
        }
        HopsTransactionalRequestHandler listCorruptFileBlocksHandler = new HopsTransactionalRequestHandler(HDFSOperationType.LIST_CORRUPT_FILE_BLOCKS){
            INodeIdentifier iNodeIdentifier;

            @Override
            public void setUp() throws StorageException {
                Block block = (Block)this.getParams()[0];
                this.iNodeIdentifier = INodeUtil.resolveINodeFromBlock(block);
            }

            public void acquireLock(TransactionLocks locks) throws IOException {
                Block block = (Block)this.getParams()[0];
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getIndividualINodeLock(TransactionLockTypes.INodeLockType.READ_COMMITTED, this.iNodeIdentifier, true)).add(lf.getBlockLock(block.getBlockId(), this.iNodeIdentifier)).add(lf.getBlockRelated(LockFactory.BLK.RE, LockFactory.BLK.CR, LockFactory.BLK.ER));
            }

            public Object performTask() throws IOException {
                String src;
                Block blk = (Block)this.getParams()[0];
                INodeFile inode = (INodeFile)FSNamesystem.this.blockManager.getBlockCollection(blk);
                skip[0] = skip[0] + 1;
                if (inode != null && FSNamesystem.this.blockManager.countNodes(blk).liveReplicas() == 0 && (src = FSDirectory.getFullPathName(inode)).startsWith(path)) {
                    corruptFiles.add(new CorruptFileBlockInfo(src, blk));
                    count[0] = count[0] + 1;
                }
                return null;
            }
        };
        while (blkIterator.hasNext()) {
            Block blk = blkIterator.next();
            listCorruptFileBlocksHandler.setParams(new Object[]{blk});
            listCorruptFileBlocksHandler.handle(this);
            if (count[0] < 100) continue;
            break;
        }
        cookieTab[0] = String.valueOf(skip[0]);
        LOG.info((Object)("list corrupt file blocks returned: " + count[0]));
        return corruptFiles;
    }

    private static int getIntCookie(String cookie) {
        int c;
        if (cookie == null) {
            c = 0;
        } else {
            try {
                c = Integer.parseInt(cookie);
            }
            catch (NumberFormatException e) {
                c = 0;
            }
        }
        c = Math.max(0, c);
        return c;
    }

    private DelegationTokenSecretManager createDelegationTokenSecretManager(Configuration conf) {
        return new DelegationTokenSecretManager(conf.getLong("dfs.namenode.delegation.key.update-interval", 86400000L), conf.getLong("dfs.namenode.delegation.token.max-lifetime", 604800000L), conf.getLong("dfs.namenode.delegation.token.renew-interval", 86400000L), DELEGATION_TOKEN_REMOVER_SCAN_INTERVAL, conf.getBoolean("dfs.namenode.audit.log.token.tracking.id", false), this);
    }

    DelegationTokenSecretManager getDelegationTokenSecretManager() {
        return this.dtSecretManager;
    }

    Token<DelegationTokenIdentifier> getDelegationToken(final Text renewer) throws IOException {
        HopsTransactionalRequestHandler getDelegationTokenHandler = new HopsTransactionalRequestHandler(HDFSOperationType.GET_DELEGATION_TOKEN){

            public void acquireLock(TransactionLocks locks) throws IOException {
            }

            public Object performTask() throws IOException {
                FSNamesystem.this.checkNameNodeSafeMode("Cannot issue delegation token");
                if (!FSNamesystem.this.isAllowedDelegationTokenOp()) {
                    throw new IOException("Delegation Token can be issued only with kerberos or web authentication");
                }
                if (FSNamesystem.this.dtSecretManager == null || !FSNamesystem.this.dtSecretManager.isRunning()) {
                    LOG.warn((Object)"trying to get DT with no secret manager running");
                    return null;
                }
                UserGroupInformation ugi = FSNamesystem.getRemoteUser();
                String user = ugi.getUserName();
                Text owner = new Text(user);
                Text realUser = null;
                if (ugi.getRealUser() != null) {
                    realUser = new Text(ugi.getRealUser().getUserName());
                }
                DelegationTokenIdentifier dtId = new DelegationTokenIdentifier(owner, renewer, realUser);
                Token token = new Token((TokenIdentifier)dtId, (SecretManager)FSNamesystem.this.dtSecretManager);
                long expiryTime = FSNamesystem.this.dtSecretManager.getTokenExpiryTime(dtId);
                return token;
            }
        };
        return (Token)getDelegationTokenHandler.handle(this);
    }

    long renewDelegationToken(final Token<DelegationTokenIdentifier> token) throws IOException {
        HopsTransactionalRequestHandler renewDelegationTokenHandler = new HopsTransactionalRequestHandler(HDFSOperationType.RENEW_DELEGATION_TOKEN){

            public void acquireLock(TransactionLocks locks) throws IOException {
            }

            public Object performTask() throws IOException {
                FSNamesystem.this.checkNameNodeSafeMode("Cannot renew delegation token");
                if (!FSNamesystem.this.isAllowedDelegationTokenOp()) {
                    throw new IOException("Delegation Token can be renewed only with kerberos or web authentication");
                }
                String renewer = FSNamesystem.getRemoteUser().getShortUserName();
                long expiryTime = FSNamesystem.this.dtSecretManager.renewToken(token, renewer);
                DelegationTokenIdentifier id = new DelegationTokenIdentifier();
                ByteArrayInputStream buf = new ByteArrayInputStream(token.getIdentifier());
                DataInputStream in = new DataInputStream(buf);
                id.readFields(in);
                return expiryTime;
            }
        };
        return (Long)renewDelegationTokenHandler.handle(this);
    }

    void cancelDelegationToken(final Token<DelegationTokenIdentifier> token) throws IOException {
        HopsTransactionalRequestHandler cancelDelegationTokenHandler = new HopsTransactionalRequestHandler(HDFSOperationType.CANCEL_DELEGATION_TOKEN){

            public void acquireLock(TransactionLocks locks) throws IOException {
            }

            public Object performTask() throws IOException {
                FSNamesystem.this.checkNameNodeSafeMode("Cannot cancel delegation token");
                String canceller = FSNamesystem.getRemoteUser().getUserName();
                DelegationTokenIdentifier id = (DelegationTokenIdentifier)FSNamesystem.this.dtSecretManager.cancelToken(token, canceller);
                return null;
            }
        };
        cancelDelegationTokenHandler.handle(this);
    }

    public void logUpdateMasterKey(DelegationKey key) throws IOException {
        assert (!this.isInSafeMode()) : "this should never be called while in safe mode, since we stop the DT manager before entering safe mode!";
    }

    private boolean isAllowedDelegationTokenOp() throws IOException {
        UserGroupInformation.AuthenticationMethod authMethod = this.getConnectionAuthenticationMethod();
        return !UserGroupInformation.isSecurityEnabled() || authMethod == UserGroupInformation.AuthenticationMethod.KERBEROS || authMethod == UserGroupInformation.AuthenticationMethod.KERBEROS_SSL || authMethod == UserGroupInformation.AuthenticationMethod.CERTIFICATE;
    }

    private UserGroupInformation.AuthenticationMethod getConnectionAuthenticationMethod() throws IOException {
        UserGroupInformation ugi = FSNamesystem.getRemoteUser();
        UserGroupInformation.AuthenticationMethod authMethod = ugi.getAuthenticationMethod();
        if (authMethod == UserGroupInformation.AuthenticationMethod.PROXY) {
            authMethod = ugi.getRealUser().getAuthenticationMethod();
        }
        return authMethod;
    }

    private boolean isExternalInvocation() {
        return Server.isRpcInvocation() || NamenodeWebHdfsMethods.isWebHdfsInvocation();
    }

    private static InetAddress getRemoteIp() {
        InetAddress ip = Server.getRemoteIp();
        if (ip != null) {
            return ip;
        }
        return NamenodeWebHdfsMethods.getRemoteIp();
    }

    private static UserGroupInformation getRemoteUser() throws IOException {
        return NameNode.getRemoteUser();
    }

    void logFsckEvent(String src, InetAddress remoteAddress) throws IOException {
        if (this.isAuditEnabled()) {
            this.logAuditEvent(true, FSNamesystem.getRemoteUser(), remoteAddress, "fsck", src, null, null);
        }
    }

    private void registerMXBean() {
        this.mxbeanName = MBeans.register((String)"NameNode", (String)"NameNodeInfo", (Object)this);
    }

    @Override
    public String getVersion() {
        return VersionInfo.getVersion() + ", r" + VersionInfo.getRevision();
    }

    @Override
    public long getUsed() {
        return this.getCapacityUsed();
    }

    @Override
    public long getFree() {
        return this.getCapacityRemaining();
    }

    @Override
    public long getTotal() {
        return this.getCapacityTotal();
    }

    @Override
    public String getSafemode() throws IOException {
        if (!this.isInSafeMode()) {
            return "";
        }
        return "Safe mode is ON. " + this.getSafeModeTip();
    }

    public boolean isUpgradeFinalized() {
        throw new UnsupportedOperationException("HOP: Upgrade is not supported");
    }

    @Override
    public long getNonDfsUsedSpace() {
        return this.datanodeStatistics.getCapacityUsedNonDFS();
    }

    @Override
    public float getPercentUsed() {
        return this.datanodeStatistics.getCapacityUsedPercent();
    }

    @Override
    public long getBlockPoolUsedSpace() {
        return this.datanodeStatistics.getBlockPoolUsed();
    }

    @Override
    public float getPercentBlockPoolUsed() {
        return this.datanodeStatistics.getPercentBlockPoolUsed();
    }

    @Override
    public float getPercentRemaining() {
        return this.datanodeStatistics.getCapacityRemainingPercent();
    }

    @Override
    public long getTotalBlocks() throws IOException {
        return this.getBlocksTotal();
    }

    @Override
    @Metric
    public long getTotalFiles() {
        return this.getFilesTotal();
    }

    @Override
    public long getNumberOfMissingBlocks() throws IOException {
        return this.getMissingBlocksCount();
    }

    @Override
    public int getThreads() {
        return ManagementFactory.getThreadMXBean().getThreadCount();
    }

    @Override
    public String getLiveNodes() throws IOException {
        HashMap<String, ImmutableMap> info = new HashMap<String, ImmutableMap>();
        ArrayList<DatanodeDescriptor> live = new ArrayList<DatanodeDescriptor>();
        this.blockManager.getDatanodeManager().fetchDatanodes(live, null, true);
        for (DatanodeDescriptor node : live) {
            ImmutableMap innerInfo = ImmutableMap.builder().put((Object)"infoAddr", (Object)node.getInfoAddr()).put((Object)"infoSecureAddr", (Object)node.getInfoSecureAddr()).put((Object)"xferaddr", (Object)node.getXferAddr()).put((Object)"lastContact", (Object)this.getLastContact(node)).put((Object)"usedSpace", (Object)this.getDfsUsed(node)).put((Object)"adminState", (Object)node.getAdminState().toString()).put((Object)"nonDfsUsedSpace", (Object)node.getNonDfsUsed()).put((Object)"capacity", (Object)node.getCapacity()).put((Object)"numBlocks", (Object)node.numBlocks()).put((Object)"version", (Object)node.getSoftwareVersion()).put((Object)"used", (Object)node.getDfsUsed()).put((Object)"remaining", (Object)node.getRemaining()).put((Object)"blockScheduled", (Object)node.getBlocksScheduled()).put((Object)"blockPoolUsed", (Object)node.getBlockPoolUsed()).put((Object)"blockPoolUsedPercent", (Object)Float.valueOf(node.getBlockPoolUsedPercent())).put((Object)"volfails", (Object)node.getVolumeFailures()).build();
            info.put(node.getHostName(), innerInfo);
        }
        return JSON.toString(info);
    }

    @Override
    public String getDeadNodes() {
        HashMap<String, ImmutableMap> info = new HashMap<String, ImmutableMap>();
        ArrayList<DatanodeDescriptor> dead = new ArrayList<DatanodeDescriptor>();
        this.blockManager.getDatanodeManager().fetchDatanodes(null, dead, true);
        for (DatanodeDescriptor node : dead) {
            ImmutableMap innerInfo = ImmutableMap.builder().put((Object)"lastContact", (Object)this.getLastContact(node)).put((Object)"decommissioned", (Object)node.isDecommissioned()).put((Object)"xferaddr", (Object)node.getXferAddr()).build();
            info.put(node.getHostName(), innerInfo);
        }
        return JSON.toString(info);
    }

    @Override
    public String getDecomNodes() {
        HashMap<String, ImmutableMap> info = new HashMap<String, ImmutableMap>();
        List<DatanodeDescriptor> decomNodeList = this.blockManager.getDatanodeManager().getDecommissioningNodes();
        for (DatanodeDescriptor node : decomNodeList) {
            ImmutableMap innerInfo = ImmutableMap.builder().put((Object)"xferaddr", (Object)node.getXferAddr()).put((Object)"underReplicatedBlocks", (Object)node.decommissioningStatus.getUnderReplicatedBlocks()).put((Object)"decommissionOnlyReplicas", (Object)node.decommissioningStatus.getDecommissionOnlyReplicas()).put((Object)"underReplicateInOpenFiles", (Object)node.decommissioningStatus.getUnderReplicatedInOpenFiles()).build();
            info.put(node.getHostName(), innerInfo);
        }
        return JSON.toString(info);
    }

    private long getLastContact(DatanodeDescriptor aliveNode) {
        return (Time.now() - aliveNode.getLastUpdate()) / 1000L;
    }

    private long getDfsUsed(DatanodeDescriptor aliveNode) {
        return aliveNode.getDfsUsed();
    }

    @Override
    public String getClusterId() {
        String cid = "";
        try {
            cid = StorageInfo.getStorageInfoFromDB().getClusterID();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return cid;
    }

    @Override
    public String getBlockPoolId() {
        return this.blockPoolId;
    }

    public String getNameDirStatuses() {
        throw new UnsupportedOperationException("HOP: there are no name dirs any more");
    }

    @Override
    public String getNodeUsage() {
        float median = 0.0f;
        float max = 0.0f;
        float min = 0.0f;
        float dev = 0.0f;
        HashMap info = new HashMap();
        ArrayList<DatanodeDescriptor> live = new ArrayList<DatanodeDescriptor>();
        this.blockManager.getDatanodeManager().fetchDatanodes(live, null, true);
        if (live.size() > 0) {
            float totalDfsUsed = 0.0f;
            float[] usages = new float[live.size()];
            int i = 0;
            for (DatanodeDescriptor dn : live) {
                usages[i++] = dn.getDfsUsedPercent();
                totalDfsUsed += dn.getDfsUsedPercent();
            }
            totalDfsUsed /= (float)live.size();
            Arrays.sort(usages);
            median = usages[usages.length / 2];
            max = usages[usages.length - 1];
            min = usages[0];
            for (i = 0; i < usages.length; ++i) {
                dev += (usages[i] - totalDfsUsed) * (usages[i] - totalDfsUsed);
            }
            dev = (float)Math.sqrt(dev / (float)usages.length);
        }
        HashMap<String, String> innerInfo = new HashMap<String, String>();
        innerInfo.put("min", StringUtils.format((String)"%.2f%%", (Object[])new Object[]{Float.valueOf(min)}));
        innerInfo.put("median", StringUtils.format((String)"%.2f%%", (Object[])new Object[]{Float.valueOf(median)}));
        innerInfo.put("max", StringUtils.format((String)"%.2f%%", (Object[])new Object[]{Float.valueOf(max)}));
        innerInfo.put("stdDev", StringUtils.format((String)"%.2f%%", (Object[])new Object[]{Float.valueOf(dev)}));
        info.put("nodeUsage", innerInfo);
        return JSON.toString(info);
    }

    @Override
    public String getNNStarted() {
        return this.getStartTime().toString();
    }

    @Override
    public String getCompileInfo() {
        return VersionInfo.getDate() + " by " + VersionInfo.getUser() + " from " + VersionInfo.getBranch();
    }

    public BlockManager getBlockManager() {
        return this.blockManager;
    }

    public FSDirectory getFSDirectory() {
        return this.dir;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Override
    public String getCorruptFiles() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            Collection<CorruptFileBlockInfo> corruptFileBlocks = this.listCorruptFileBlocks("/", null);
            int corruptFileCount = corruptFileBlocks.size();
            if (corruptFileCount != 0) {
                for (CorruptFileBlockInfo c : corruptFileBlocks) {
                    list.add(c.toString());
                }
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("Get corrupt file blocks returned error: " + e.getMessage()));
        }
        return JSON.toString(list);
    }

    @Override
    public int getDistinctVersionCount() {
        return this.blockManager.getDatanodeManager().getDatanodesSoftwareVersions().size();
    }

    @Override
    public Map<String, Integer> getDistinctVersions() {
        return this.blockManager.getDatanodeManager().getDatanodesSoftwareVersions();
    }

    @Override
    public String getSoftwareVersion() {
        return VersionInfo.getVersion();
    }

    @Override
    public int getNumNameNodes() {
        return this.nameNode.getActiveNameNodes().size();
    }

    @Override
    public String getLeaderNameNode() {
        return ((ActiveNode)this.nameNode.getActiveNameNodes().getSortedActiveNodes().get(0)).getHostname();
    }

    public synchronized void verifyToken(DelegationTokenIdentifier identifier, byte[] password) throws SecretManager.InvalidToken, RetriableException {
        try {
            this.getDelegationTokenSecretManager().verifyToken(identifier, password);
        }
        catch (SecretManager.InvalidToken it) {
            if (this.inTransitionToActive()) {
                throw new RetriableException((Exception)((Object)it));
            }
            throw it;
        }
    }

    @Override
    public boolean isGenStampInFuture(Block block) throws StorageException {
        throw new UnsupportedOperationException("Not supported anymore.");
    }

    @VisibleForTesting
    public SafeModeInfo getSafeModeInfoForTests() throws IOException {
        return this.safeMode();
    }

    @Override
    public boolean isAvoidingStaleDataNodesForWrite() {
        return this.blockManager.getDatanodeManager().shouldAvoidStaleDataNodesForWrite();
    }

    @Override
    public int getNumDatanodesInService() {
        return this.datanodeStatistics.getNumDatanodesInService();
    }

    @Override
    public double getInServiceXceiverAverage() {
        double avgLoad = 0.0;
        int nodes = this.getNumDatanodesInService();
        if (nodes != 0) {
            int xceivers = this.datanodeStatistics.getInServiceXceiverCount();
            avgLoad = (double)xceivers / (double)nodes;
        }
        return avgLoad;
    }

    RollingUpgradeInfo queryRollingUpgrade() throws IOException {
        this.checkSuperuserPrivilege();
        return this.getRollingUpgradeInfoTX();
    }

    RollingUpgradeInfo startRollingUpgrade() throws IOException {
        this.checkSuperuserPrivilege();
        long startTime = Time.now();
        this.checkNameNodeSafeMode("Failed to start rolling upgrade");
        RollingUpgradeInfo rollingUpgradeInfo = this.startRollingUpgradeInternal(startTime);
        if (auditLog.isInfoEnabled() && this.isExternalInvocation()) {
            this.logAuditEvent(true, "startRollingUpgrade", null, null, null);
        }
        return rollingUpgradeInfo;
    }

    RollingUpgradeInfo startRollingUpgradeInternal(final long startTime) throws IOException {
        return (RollingUpgradeInfo)new HopsTransactionalRequestHandler(HDFSOperationType.ADD_ROLLING_UPGRADE_INFO){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getVariableLock(Variable.Finder.RollingUpgradeInfo, TransactionLockTypes.LockType.WRITE));
            }

            public Object performTask() throws StorageException, IOException {
                FSNamesystem.this.checkRollingUpgrade("start rolling upgrade");
                return FSNamesystem.this.setRollingUpgradeInfo(startTime);
            }
        }.handle();
    }

    RollingUpgradeInfo setRollingUpgradeInfo(long startTime) throws TransactionContextException, StorageException {
        RollingUpgradeInfo rollingUpgradeInfo = new RollingUpgradeInfo(this.blockPoolId, startTime, 0L);
        HdfsVariables.setRollingUpgradeInfo(rollingUpgradeInfo);
        return rollingUpgradeInfo;
    }

    public RollingUpgradeInfo getRollingUpgradeInfoTX() throws IOException {
        return (RollingUpgradeInfo)new HopsTransactionalRequestHandler(HDFSOperationType.GET_ROLLING_UPGRADE_INFO){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getVariableLock(Variable.Finder.RollingUpgradeInfo, TransactionLockTypes.LockType.READ));
            }

            public Object performTask() throws StorageException, IOException {
                return HdfsVariables.getRollingUpgradeInfo();
            }
        }.handle();
    }

    @Override
    public RollingUpgradeInfo.Bean getRollingUpgradeStatus() {
        RollingUpgradeInfo upgradeInfo = null;
        try {
            upgradeInfo = this.getRollingUpgradeInfoTX();
        }
        catch (IOException ex) {
            LOG.warn((Object)ex);
        }
        if (upgradeInfo != null) {
            return new RollingUpgradeInfo.Bean(upgradeInfo);
        }
        return null;
    }

    public boolean isRollingUpgrade() throws TransactionContextException, StorageException, InvalidProtocolBufferException {
        return HdfsVariables.getRollingUpgradeInfo() != null;
    }

    public boolean isRollingUpgradeTX() throws IOException {
        return (Boolean)new HopsTransactionalRequestHandler(HDFSOperationType.GET_ROLLING_UPGRADE_INFO){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getVariableLock(Variable.Finder.RollingUpgradeInfo, TransactionLockTypes.LockType.READ));
            }

            public Object performTask() throws StorageException, IOException {
                return FSNamesystem.this.isRollingUpgrade();
            }
        }.handle();
    }

    void checkRollingUpgrade(String action) throws RollingUpgradeException, TransactionContextException, StorageException, InvalidProtocolBufferException {
        if (this.isRollingUpgrade()) {
            throw new RollingUpgradeException("Failed to " + action + " since a rolling upgrade is already in progress. Existing rolling upgrade info:\n" + HdfsVariables.getRollingUpgradeInfo());
        }
    }

    RollingUpgradeInfo finalizeRollingUpgrade() throws IOException {
        this.checkSuperuserPrivilege();
        this.checkNameNodeSafeMode("Failed to finalize rolling upgrade");
        RollingUpgradeInfo returnInfo = this.finalizeRollingUpgradeInternal(Time.now());
        if (auditLog.isInfoEnabled() && this.isExternalInvocation()) {
            this.logAuditEvent(true, "finalizeRollingUpgrade", null, null, null);
        }
        return returnInfo;
    }

    RollingUpgradeInfo finalizeRollingUpgradeInternal(final long finalizeTime) throws RollingUpgradeException, IOException {
        return (RollingUpgradeInfo)new HopsTransactionalRequestHandler(HDFSOperationType.ADD_ROLLING_UPGRADE_INFO){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getVariableLock(Variable.Finder.RollingUpgradeInfo, TransactionLockTypes.LockType.WRITE));
            }

            public Object performTask() throws StorageException, IOException {
                if (!FSNamesystem.this.isRollingUpgrade()) {
                    throw new RollingUpgradeException("Failed to finalize rolling upgrade since there is no rolling upgrade in progress.");
                }
                long startTime = HdfsVariables.getRollingUpgradeInfo().getStartTime();
                HdfsVariables.setRollingUpgradeInfo(null);
                return new RollingUpgradeInfo(FSNamesystem.this.blockPoolId, startTime, finalizeTime);
            }
        }.handle();
    }

    static void rollBackRollingUpgradeTX() throws RollingUpgradeException, IOException {
        new HopsTransactionalRequestHandler(HDFSOperationType.ADD_ROLLING_UPGRADE_INFO){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getVariableLock(Variable.Finder.RollingUpgradeInfo, TransactionLockTypes.LockType.WRITE));
            }

            public Object performTask() throws StorageException, IOException {
                HdfsVariables.setRollingUpgradeInfo(null);
                return null;
            }
        }.handle();
    }

    long addCacheDirective(final CacheDirectiveInfo directive, final EnumSet<CacheFlag> flags) throws IOException {
        CacheManager.validatePoolName(directive);
        final String path = CacheManager.validatePath(directive);
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot add cache directive", this.safeMode());
        }
        if (directive.getId() != null) {
            throw new IOException("addDirective: you cannot specify an ID for this operation.");
        }
        if (!flags.contains((Object)CacheFlag.FORCE)) {
            this.cacheManager.waitForRescanIfNeeded();
        }
        final long id = this.cacheManager.getNextDirectiveId();
        HopsTransactionalRequestHandler addDirectiveHandler = new HopsTransactionalRequestHandler(HDFSOperationType.ADD_CACHE_DIRECTIVE){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getRetryCacheEntryLock(Server.getClientId(), Server.getCallId())).add(lf.getCachePoolLock(directive.getPool()));
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.READ, TransactionLockTypes.INodeResolveType.PATH_AND_IMMEDIATE_CHILDREN, path).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(!FSNamesystem.this.dir.isQuotaEnabled());
                locks.add((Lock)il).add(lf.getCacheDirectiveLock(id)).add(lf.getBlockLock());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object performTask() throws IOException {
                FSPermissionChecker pc = FSNamesystem.this.isPermissionEnabled ? FSNamesystem.this.getPermissionChecker() : null;
                RetryCacheDistributed.CacheEntryWithPayload cacheEntry = RetryCacheDistributed.waitForCompletion((RetryCacheDistributed)FSNamesystem.this.retryCache, null);
                if (cacheEntry != null && cacheEntry.isSuccess()) {
                    return PBHelper.bytesToLong(cacheEntry.getPayload());
                }
                boolean success = false;
                Long result = null;
                try {
                    CacheDirectiveInfo effectiveDirective = FSNamesystem.this.cacheManager.addDirective(directive, pc, flags, id);
                    result = effectiveDirective.getId();
                    success = true;
                }
                catch (Throwable throwable) {
                    if (FSNamesystem.this.isAuditEnabled() && FSNamesystem.this.isExternalInvocation()) {
                        FSNamesystem.this.logAuditEvent(success, "addCacheDirective", null, null, null);
                    }
                    RetryCacheDistributed.setState((RetryCacheDistributed.CacheEntryWithPayload)cacheEntry, (boolean)success, (byte[])PBHelper.longToBytes(result));
                    throw throwable;
                }
                if (FSNamesystem.this.isAuditEnabled() && FSNamesystem.this.isExternalInvocation()) {
                    FSNamesystem.this.logAuditEvent(success, "addCacheDirective", null, null, null);
                }
                RetryCacheDistributed.setState((RetryCacheDistributed.CacheEntryWithPayload)cacheEntry, (boolean)success, (byte[])PBHelper.longToBytes(result));
                return result;
            }
        };
        return (Long)addDirectiveHandler.handle();
    }

    void modifyCacheDirective(final CacheDirectiveInfo directive, final EnumSet<CacheFlag> flags) throws IOException {
        if (!flags.contains((Object)CacheFlag.FORCE)) {
            this.cacheManager.waitForRescanIfNeeded();
        }
        new HopsTransactionalRequestHandler(HDFSOperationType.MODIFY_CACHE_DIRECTIVE){
            String path;
            List<String> pools;
            {
                super(opType);
                this.pools = new ArrayList<String>(2);
            }

            @Override
            public void setUp() throws StorageException, IOException {
                CacheDirectiveDataAccess da = (CacheDirectiveDataAccess)HdfsStorageFactory.getDataAccess(CacheDirectiveDataAccess.class);
                CacheDirective originalDirective = (CacheDirective)da.find(directive.getId().longValue());
                if (directive.getPath() != null) {
                    this.path = directive.getPath().toString();
                } else if (originalDirective != null) {
                    this.path = originalDirective.getPath();
                }
                if (directive.getPool() != null) {
                    this.pools.add(directive.getPool());
                }
                if (originalDirective != null) {
                    this.pools.add(originalDirective.getPoolName());
                }
            }

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getRetryCacheEntryLock(Server.getClientId(), Server.getCallId())).add(lf.getCacheDirectiveLock(directive.getId())).add(lf.getCachePoolsLock(this.pools));
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.READ, TransactionLockTypes.INodeResolveType.PATH_AND_IMMEDIATE_CHILDREN, this.path).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(!FSNamesystem.this.dir.isQuotaEnabled());
                locks.add((Lock)il).add(lf.getBlockLock());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object performTask() throws IOException {
                FSPermissionChecker pc = FSNamesystem.this.isPermissionEnabled ? FSNamesystem.this.getPermissionChecker() : null;
                boolean success = false;
                RetryCache.CacheEntry cacheEntry = RetryCacheDistributed.waitForCompletion((RetryCacheDistributed)FSNamesystem.this.retryCache);
                if (cacheEntry != null && cacheEntry.isSuccess()) {
                    return null;
                }
                try {
                    if (FSNamesystem.this.isInSafeMode()) {
                        throw new SafeModeException("Cannot add cache directive", FSNamesystem.this.safeMode());
                    }
                    FSNamesystem.this.cacheManager.modifyDirective(directive, pc, flags);
                    success = true;
                }
                finally {
                    if (FSNamesystem.this.isAuditEnabled() && FSNamesystem.this.isExternalInvocation()) {
                        FSNamesystem.this.logAuditEvent(success, "modifyCacheDirective", null, null, null);
                    }
                    RetryCacheDistributed.setState((RetryCache.CacheEntry)cacheEntry, (boolean)success);
                }
                return null;
            }
        }.handle();
    }

    void removeCacheDirective(final Long id) throws IOException {
        new HopsTransactionalRequestHandler(HDFSOperationType.REMOVE_CACHE_DIRECTIVE){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getRetryCacheEntryLock(Server.getClientId(), Server.getCallId())).add(lf.getCacheDirectiveLock(id)).add(lf.getCachePoolLock(TransactionLockTypes.LockType.WRITE));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object performTask() throws IOException {
                FSPermissionChecker pc = FSNamesystem.this.isPermissionEnabled ? FSNamesystem.this.getPermissionChecker() : null;
                RetryCache.CacheEntry cacheEntry = RetryCacheDistributed.waitForCompletion((RetryCacheDistributed)FSNamesystem.this.retryCache);
                if (cacheEntry != null && cacheEntry.isSuccess()) {
                    return null;
                }
                boolean success = false;
                try {
                    if (FSNamesystem.this.isInSafeMode()) {
                        throw new SafeModeException("Cannot remove cache directives", FSNamesystem.this.safeMode());
                    }
                    FSNamesystem.this.cacheManager.removeDirective(id, pc);
                    success = true;
                }
                finally {
                    if (FSNamesystem.this.isAuditEnabled() && FSNamesystem.this.isExternalInvocation()) {
                        FSNamesystem.this.logAuditEvent(success, "removeCacheDirective", null, null, null);
                    }
                    RetryCacheDistributed.setState((RetryCache.CacheEntry)cacheEntry, (boolean)success);
                }
                return null;
            }
        }.handle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BatchedRemoteIterator.BatchedListEntries<CacheDirectiveEntry> listCacheDirectives(long startId, CacheDirectiveInfo filter) throws IOException {
        BatchedRemoteIterator.BatchedListEntries<CacheDirectiveEntry> results;
        FSPermissionChecker pc = this.isPermissionEnabled ? this.getPermissionChecker() : null;
        this.cacheManager.waitForRescanIfNeeded();
        boolean success = false;
        try {
            results = this.cacheManager.listCacheDirectives(startId, filter, pc);
            success = true;
        }
        finally {
            if (this.isAuditEnabled() && this.isExternalInvocation()) {
                this.logAuditEvent(success, "listCacheDirectives", null, null, null);
            }
        }
        return results;
    }

    public void addCachePool(final CachePoolInfo req) throws IOException {
        CachePoolInfo.validate(req);
        final String poolName = req.getPoolName();
        new HopsTransactionalRequestHandler(HDFSOperationType.ADD_CACHE_POOL){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getRetryCacheEntryLock(Server.getClientId(), Server.getCallId())).add(lf.getCachePoolLock(poolName));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object performTask() throws IOException {
                FSPermissionChecker pc = FSNamesystem.this.isPermissionEnabled ? FSNamesystem.this.getPermissionChecker() : null;
                RetryCache.CacheEntry cacheEntry = RetryCacheDistributed.waitForCompletion((RetryCacheDistributed)FSNamesystem.this.retryCache);
                if (cacheEntry != null && cacheEntry.isSuccess()) {
                    return null;
                }
                boolean success = false;
                try {
                    if (FSNamesystem.this.isInSafeMode()) {
                        throw new SafeModeException("Cannot add cache pool " + req.getPoolName(), FSNamesystem.this.safeMode());
                    }
                    if (pc != null) {
                        pc.checkSuperuserPrivilege();
                    }
                    CachePoolInfo info = FSNamesystem.this.cacheManager.addCachePool(req);
                    success = true;
                }
                finally {
                    if (FSNamesystem.this.isAuditEnabled() && FSNamesystem.this.isExternalInvocation()) {
                        FSNamesystem.this.logAuditEvent(success, "addCachePool", req.getPoolName(), null, null);
                    }
                    RetryCacheDistributed.setState((RetryCache.CacheEntry)cacheEntry, (boolean)success);
                }
                return null;
            }
        }.handle();
    }

    public void modifyCachePool(final CachePoolInfo req) throws IOException {
        CachePoolInfo.validate(req);
        final String poolName = req.getPoolName();
        new HopsTransactionalRequestHandler(HDFSOperationType.MODIFY_CACHE_POOL){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getRetryCacheEntryLock(Server.getClientId(), Server.getCallId())).add(lf.getCachePoolLock(poolName));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object performTask() throws IOException {
                FSPermissionChecker pc = FSNamesystem.this.isPermissionEnabled ? FSNamesystem.this.getPermissionChecker() : null;
                RetryCache.CacheEntry cacheEntry = RetryCacheDistributed.waitForCompletion((RetryCacheDistributed)FSNamesystem.this.retryCache);
                if (cacheEntry != null && cacheEntry.isSuccess()) {
                    return null;
                }
                boolean success = false;
                try {
                    if (FSNamesystem.this.isInSafeMode()) {
                        throw new SafeModeException("Cannot modify cache pool " + req.getPoolName(), FSNamesystem.this.safeMode());
                    }
                    if (pc != null) {
                        pc.checkSuperuserPrivilege();
                    }
                    FSNamesystem.this.cacheManager.modifyCachePool(req);
                    success = true;
                }
                finally {
                    if (FSNamesystem.this.isAuditEnabled() && FSNamesystem.this.isExternalInvocation()) {
                        FSNamesystem.this.logAuditEvent(success, "modifyCachePool", req.getPoolName(), null, null);
                    }
                    RetryCacheDistributed.setState((RetryCache.CacheEntry)cacheEntry, (boolean)success);
                }
                return null;
            }
        }.handle();
    }

    public void removeCachePool(final String cachePoolName) throws IOException {
        CachePoolInfo.validateName(cachePoolName);
        new HopsTransactionalRequestHandler(HDFSOperationType.REMOVE_CACHE_POOL){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getRetryCacheEntryLock(Server.getClientId(), Server.getCallId())).add(lf.getCachePoolLock(cachePoolName)).add(lf.getCacheDirectiveLock(cachePoolName));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object performTask() throws IOException {
                FSPermissionChecker pc = FSNamesystem.this.isPermissionEnabled ? FSNamesystem.this.getPermissionChecker() : null;
                RetryCache.CacheEntry cacheEntry = RetryCacheDistributed.waitForCompletion((RetryCacheDistributed)FSNamesystem.this.retryCache);
                if (cacheEntry != null && cacheEntry.isSuccess()) {
                    return null;
                }
                boolean success = false;
                try {
                    if (FSNamesystem.this.isInSafeMode()) {
                        throw new SafeModeException("Cannot remove cache pool " + cachePoolName, FSNamesystem.this.safeMode());
                    }
                    if (pc != null) {
                        pc.checkSuperuserPrivilege();
                    }
                    FSNamesystem.this.cacheManager.removeCachePool(cachePoolName);
                    success = true;
                }
                finally {
                    if (FSNamesystem.this.isAuditEnabled() && FSNamesystem.this.isExternalInvocation()) {
                        FSNamesystem.this.logAuditEvent(success, "removeCachePool", cachePoolName, null, null);
                    }
                }
                return null;
            }
        }.handle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BatchedRemoteIterator.BatchedListEntries<CachePoolEntry> listCachePools(String prevKey) throws IOException {
        BatchedRemoteIterator.BatchedListEntries<CachePoolEntry> results;
        FSPermissionChecker pc = this.isPermissionEnabled ? this.getPermissionChecker() : null;
        boolean success = false;
        this.cacheManager.waitForRescanIfNeeded();
        try {
            results = this.cacheManager.listCachePools(pc, prevKey);
            success = true;
        }
        finally {
            if (this.isAuditEnabled() && this.isExternalInvocation()) {
                this.logAuditEvent(success, "listCachePools", null, null, null);
            }
        }
        return results;
    }

    private static void enableAsyncAuditLog() {
        if (!(auditLog instanceof Log4JLogger)) {
            LOG.warn((Object)"Log4j is required to enable async auditlog");
            return;
        }
        Logger logger = ((Log4JLogger)auditLog).getLogger();
        ArrayList<Appender> appenders = Collections.list(logger.getAllAppenders());
        if (!appenders.isEmpty() && !(appenders.get(0) instanceof AsyncAppender)) {
            AsyncAppender asyncAppender = new AsyncAppender();
            for (Appender appender : appenders) {
                logger.removeAppender(appender);
                asyncAppender.addAppender(appender);
            }
            logger.addAppender((Appender)asyncAppender);
        }
    }

    private void hopSpecificInitialization(Configuration conf) throws IOException {
        HdfsStorageFactory.setConfiguration(conf);
    }

    @Override
    public boolean isLeader() {
        return this.nameNode.isLeader();
    }

    @Override
    public long getNamenodeId() {
        return this.nameNode.getLeCurrentId();
    }

    public String getSuperGroup() {
        return this.superGroup;
    }

    public void performPendingSafeModeOperation() throws IOException {
        SafeModeInfo safeMode = this.safeMode();
        if (safeMode != null) {
            safeMode.performSafeModePendingOperation();
        }
    }

    void changeConf(List<String> props, List<String> newVals) throws IOException {
        for (int i = 0; i < props.size(); ++i) {
            String prop = props.get(i);
            String value = newVals.get(i);
            if (prop.equals("dfs.resolvingcache.enabled") || prop.equals("dfs.ndb.setpartitionkey.enabled")) {
                LOG.info((Object)("change configuration for  " + prop + " to " + value));
                this.conf.set(prop, value);
                if (!prop.equals("dfs.resolvingcache.enabled")) continue;
                Cache.getInstance().enableOrDisable(Boolean.parseBoolean(value));
                continue;
            }
            LOG.info((Object)("change configuration for  " + prop + " to " + value + " is not supported yet"));
        }
    }

    public void flushCache(String userName, String groupName) {
        Users.flushCache(userName, groupName);
    }

    @Override
    public void adjustSafeModeBlocks(Set<Long> safeBlocks) throws IOException {
        SafeModeInfo safeMode = this.safeMode();
        if (safeMode == null) {
            return;
        }
        safeMode.adjustSafeBlocks(safeBlocks);
    }

    QuotaUpdateManager getQuotaUpdateManager() {
        return this.quotaUpdateManager;
    }

    private void addSafeBlock(Long safeBlock) throws IOException {
        HashSet<Long> safeBlocks = new HashSet<Long>();
        safeBlocks.add(safeBlock);
        this.addSafeBlocks(safeBlocks);
    }

    private void removeSafeBlock(final Long safeBlock) throws IOException {
        new LightWeightRequestHandler(HDFSOperationType.REMOVE_SAFE_BLOCKS){

            public Object performTask() throws IOException {
                SafeBlocksDataAccess da = (SafeBlocksDataAccess)HdfsStorageFactory.getDataAccess(SafeBlocksDataAccess.class);
                da.remove(safeBlock);
                return null;
            }
        }.handle();
    }

    private void addSafeBlocks(final Set<Long> safeBlocks) throws IOException {
        new LightWeightRequestHandler(HDFSOperationType.ADD_SAFE_BLOCKS){

            public Object performTask() throws IOException {
                SafeBlocksDataAccess da = (SafeBlocksDataAccess)HdfsStorageFactory.getDataAccess(SafeBlocksDataAccess.class);
                da.insert((Collection)safeBlocks);
                return null;
            }
        }.handle();
    }

    private int getBlockSafe() throws IOException {
        return (Integer)new LightWeightRequestHandler(HDFSOperationType.GET_SAFE_BLOCKS_COUNT){

            public Object performTask() throws IOException {
                SafeBlocksDataAccess da = (SafeBlocksDataAccess)HdfsStorageFactory.getDataAccess(SafeBlocksDataAccess.class);
                return da.countAll();
            }
        }.handle();
    }

    private void clearSafeBlocks() throws IOException {
        new LightWeightRequestHandler(HDFSOperationType.CLEAR_SAFE_BLOCKS){

            public Object performTask() throws IOException {
                SafeBlocksDataAccess da = (SafeBlocksDataAccess)HdfsStorageFactory.getDataAccess(SafeBlocksDataAccess.class);
                da.removeAll();
                return null;
            }
        }.handle();
    }

    boolean isPermissionEnabled() {
        return this.isPermissionEnabled;
    }

    public ExecutorService getSubtreeOperationsExecutor() {
        return this.subtreeOperationsExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void multiTransactionalSetQuota(String path1, final long nsQuota, final long dsQuota) throws IOException {
        this.checkSuperuserPrivilege();
        this.checkNameNodeSafeMode("Cannot set quota on " + path1);
        if (!this.nameNode.isLeader() && this.dir.isQuotaEnabled()) {
            throw new NotALeaderException("Quota enabled. Delete operation can only be performed on a leader namenode");
        }
        INodeIdentifier subtreeRoot = null;
        boolean removeSTOLock = false;
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(path1);
        final String path = FSDirectory.resolvePath(path1, pathComponents, this.dir);
        try {
            Iterator<Long> idIterator;
            PathInformation pathInfo = this.getPathExistingINodesFromDB(path, false, null, null, null, null);
            INode lastComp = pathInfo.getPathInodes()[pathInfo.getPathComponents().length - 1];
            if (lastComp == null) {
                throw new FileNotFoundException("Directory does not exist: " + path);
            }
            if (!lastComp.isDirectory()) {
                throw new FileNotFoundException(path + ": Is not a directory");
            }
            if (lastComp.isRoot() && nsQuota == -1L) {
                throw new IllegalArgumentException("Cannot clear namespace quota on root.");
            }
            if (INode.getPathNames(path).length == 0) {
                subtreeRoot = INodeDirectory.getRootIdentifier();
            } else {
                subtreeRoot = this.lockSubtree(path, SubTreeOperation.Type.QUOTA_STO);
                if (subtreeRoot == null) {
                    throw new FileNotFoundException("Directory does not exist: " + path);
                }
                removeSTOLock = true;
            }
            final AbstractFileTree.IdCollectingCountingFileTree fileTree = new AbstractFileTree.IdCollectingCountingFileTree(this, subtreeRoot);
            fileTree.buildUp();
            Iterator<Long> iterator = idIterator = fileTree.getOrderedIds().descendingIterator();
            synchronized (iterator) {
                this.quotaUpdateManager.addPrioritizedUpdates(idIterator);
                try {
                    idIterator.wait();
                }
                catch (InterruptedException e) {
                    throw new IOException("Operation failed due to an Interrupt");
                }
            }
            HopsTransactionalRequestHandler setQuotaHandler = new HopsTransactionalRequestHandler(HDFSOperationType.SET_QUOTA, path){

                public void acquireLock(TransactionLocks locks) throws IOException {
                    LockFactory lf = LockFactory.getInstance();
                    INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, path).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes()).setIgnoredSTOInodes(fileTree.getSubtreeRootId().getInodeId()).setIgnoredSTOInodes(fileTree.getSubtreeRootId().getInodeId());
                    locks.add((Lock)il).add(lf.getBlockLock());
                }

                public Object performTask() throws IOException {
                    FSNamesystem.this.dir.setQuota(path, nsQuota, dsQuota, fileTree.getNamespaceCount(), fileTree.getDiskspaceCount());
                    return null;
                }
            };
            setQuotaHandler.handle(this);
        }
        finally {
            if (removeSTOLock) {
                this.unlockSubtree(path, subtreeRoot.getInodeId());
            }
        }
    }

    private ContentSummary multiTransactionalGetContentSummary(String path1) throws IOException {
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(path1);
        String path = FSDirectory.resolvePath(path1, pathComponents, this.dir);
        PathInformation pathInfo = this.getPathExistingINodesFromDB(path, false, null, null, null, null);
        if (pathInfo.getPathInodes()[pathInfo.getPathComponents().length - 1] == null) {
            throw new FileNotFoundException("File does not exist: " + path);
        }
        INode subtreeRoot = pathInfo.getPathInodes()[pathInfo.getPathComponents().length - 1];
        INodeAttributes subtreeAttr = pathInfo.getSubtreeRootAttributes();
        INodeIdentifier subtreeRootIdentifier = new INodeIdentifier(Long.valueOf(subtreeRoot.getId()), Long.valueOf(subtreeRoot.getParentId()), subtreeRoot.getLocalName(), subtreeRoot.getPartitionId());
        subtreeRootIdentifier.setDepth(Short.valueOf((short)(0 + pathInfo.getPathComponents().length - 1)));
        List<AclEntry> nearestDefaultsForSubtree = this.calculateNearestDefaultAclForSubtree(pathInfo);
        AbstractFileTree.CountingFileTree fileTree = new AbstractFileTree.CountingFileTree(this, subtreeRootIdentifier, FsAction.READ_EXECUTE, nearestDefaultsForSubtree);
        fileTree.buildUp();
        return new ContentSummary(fileTree.getFileSizeSummary(), fileTree.getFileCount(), fileTree.getDirectoryCount(), subtreeAttr == null ? subtreeRoot.getQuotaCounts().get(Quota.NAMESPACE) : subtreeAttr.getQuotaCounts().get(Quota.NAMESPACE), fileTree.getDiskspaceCount(), subtreeAttr == null ? subtreeRoot.getQuotaCounts().get(Quota.DISKSPACE) : subtreeAttr.getQuotaCounts().get(Quota.DISKSPACE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void multiTransactionalRename(String src1, String dst1, Options.Rename ... options) throws IOException {
        this.saveTimes();
        RetryCache.CacheEntry cacheEntry = this.retryCacheWaitForCompletionTransactional();
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return;
        }
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.multiTransactionalRename: with options - " + src1 + " to " + dst1));
        }
        if (!DFSUtil.isValidName(dst1)) {
            throw new InvalidPathException("Invalid name: " + dst1);
        }
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(src1);
        String src = FSDirectory.resolvePath(src1, pathComponents, this.dir);
        pathComponents = FSDirectory.getPathComponentsForReservedPath(dst1);
        String dst = FSDirectory.resolvePath(dst1, pathComponents, this.dir);
        boolean success = false;
        try {
            String error;
            PathInformation srcInfo;
            INode[] srcInodes;
            INode srcInode;
            if (this.isInSafeMode()) {
                this.checkNameNodeSafeMode("Cannot rename " + src);
            }
            if (dst.equals(src)) {
                throw new FileAlreadyExistsException("The source " + src + " and destination " + dst + " are the same");
            }
            if (dst.startsWith(src) && dst.charAt(src.length()) == '/') {
                String error2 = "Rename destination " + dst + " is a directory or file under source " + src;
                NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: " + error2));
                throw new IOException(error2);
            }
            boolean overwrite = false;
            if (null != options) {
                for (Options.Rename option : options) {
                    if (option != Options.Rename.OVERWRITE) continue;
                    overwrite = true;
                }
            }
            if ((srcInode = (srcInodes = (srcInfo = this.getPathExistingINodesFromDB(src, false, null, FsAction.WRITE, null, null)).getPathInodes())[srcInodes.length - 1]) == null) {
                error = "rename source " + src + " is not found.";
                NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: " + error));
                throw new FileNotFoundException(error);
            }
            if (srcInodes.length == 1) {
                error = "rename source cannot be the root";
                NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: " + error));
                throw new IOException(error);
            }
            if (srcInode.isSymlink() && dst.equals(((INodeSymlink)srcInode).getSymlinkString())) {
                throw new FileAlreadyExistsException("Cannot rename symlink " + src + " to its target " + dst);
            }
            PathInformation dstInfo = this.getPathExistingINodesFromDB(dst, false, FsAction.WRITE, null, null, null);
            INode[] dstInodes = dstInfo.getPathInodes();
            INode dstInode = dstInodes[dstInodes.length - 1];
            if (dstInodes.length == 1) {
                error = "rename destination cannot be the root";
                NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: " + error));
                throw new IOException(error);
            }
            if (dstInode != null) {
                if (dstInode.isDirectory() != srcInode.isDirectory()) {
                    error = "Source " + src + " and destination " + dst + " must both be directories";
                    NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: " + error));
                    throw new IOException(error);
                }
                if (!overwrite) {
                    error = "rename destination " + dst + " already exists";
                    NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: " + error));
                    throw new FileAlreadyExistsException(error);
                }
                short depth = (short)(0 + dstInfo.getPathInodes().length - 1);
                boolean areChildrenRandomlyPartitioned = INode.isTreeLevelRandomPartitioned(depth);
                if (dstInode.isDirectory() && this.dir.hasChildren(dstInode.getId(), areChildrenRandomlyPartitioned)) {
                    error = "rename cannot overwrite non empty destination directory " + dst;
                    NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: " + error));
                    throw new IOException(error);
                }
            }
            if (dstInodes[dstInodes.length - 2] == null) {
                error = "rename destination parent " + dst + " not found.";
                NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: " + error));
                throw new FileNotFoundException(error);
            }
            if (!dstInodes[dstInodes.length - 2].isDirectory()) {
                error = "rename destination parent " + dst + " is a file.";
                NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: " + error));
                throw new ParentNotDirectoryException(error);
            }
            INode srcDataSet = this.getMetaEnabledParent(srcInodes);
            INode dstDataSet = this.getMetaEnabledParent(dstInodes);
            Collection<Object> logEntries = Collections.EMPTY_LIST;
            INode.DirCounts srcCounts = new INode.DirCounts();
            srcCounts.nsCount = srcInfo.getNsCount();
            srcCounts.dsCount = srcInfo.getDsCount();
            INode.DirCounts dstCounts = new INode.DirCounts();
            dstCounts.nsCount = dstInfo.getNsCount();
            dstCounts.dsCount = dstInfo.getDsCount();
            boolean isUsingSubTreeLocks = srcInfo.isDir();
            boolean renameTransactionCommitted = false;
            INodeIdentifier srcSubTreeRoot = null;
            String subTreeLockDst = INode.constructPath(dstInfo.getPathComponents(), 0, dstInfo.getNumExistingComp());
            if (subTreeLockDst.equals("")) {
                subTreeLockDst = "/";
            }
            try {
                if (isUsingSubTreeLocks) {
                    LOG.debug((Object)("Rename src: " + src + " dst: " + dst + " requires sub-tree locking mechanism"));
                    srcSubTreeRoot = this.lockSubtreeAndCheckPathPermission(src, false, null, FsAction.WRITE, null, null, SubTreeOperation.Type.RENAME_STO);
                    if (srcSubTreeRoot != null) {
                        AbstractFileTree.QuotaCountingFileTree srcFileTree;
                        if (this.shouldLogSubtreeInodes(srcInfo, dstInfo, srcDataSet, dstDataSet, srcSubTreeRoot)) {
                            srcFileTree = new AbstractFileTree.LoggingQuotaCountingFileTree(this, srcSubTreeRoot, srcDataSet, dstDataSet);
                            srcFileTree.buildUp();
                            logEntries = ((AbstractFileTree.LoggingQuotaCountingFileTree)srcFileTree).getMetadataLogEntries();
                        } else {
                            srcFileTree = new AbstractFileTree.QuotaCountingFileTree(this, srcSubTreeRoot);
                            srcFileTree.buildUp();
                        }
                        srcCounts.nsCount = srcFileTree.getNamespaceCount();
                        srcCounts.dsCount = srcFileTree.getDiskspaceCount();
                        this.delayAfterBbuildingTree("Built Tree for " + src1 + " for rename. ");
                    }
                } else {
                    LOG.debug((Object)("Rename src: " + src + " dst: " + dst + " does not require sub-tree locking mechanism"));
                }
                this.renameTo(src, srcSubTreeRoot != null ? srcSubTreeRoot.getInodeId() : 0L, dst, srcCounts, dstCounts, isUsingSubTreeLocks, subTreeLockDst, logEntries, options);
                renameTransactionCommitted = true;
            }
            finally {
                if (!renameTransactionCommitted && srcSubTreeRoot != null) {
                    this.unlockSubtree(src, srcSubTreeRoot.getInodeId());
                }
            }
            success = true;
        }
        finally {
            this.retryCacheSetStateTransactional(cacheEntry, success);
        }
    }

    private boolean pathIsMetaEnabled(INode[] pathComponents) {
        return this.getMetaEnabledParent(pathComponents) != null;
    }

    private INode getMetaEnabledParent(INode[] pathComponents) {
        for (INode node : pathComponents) {
            INodeDirectory dir;
            if (node == null || !node.isDirectory() || !(dir = (INodeDirectory)node).isMetaEnabled()) continue;
            return dir;
        }
        return null;
    }

    private void renameTo(String src1, final long srcINodeID, String dst1, final INode.DirCounts srcCounts, final INode.DirCounts dstCounts, final boolean isUsingSubTreeLocks, final String subTreeLockDst, final Collection<MetadataLogEntry> logEntries, final Options.Rename ... options) throws IOException {
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(src1);
        final String src = FSDirectory.resolvePath(src1, pathComponents, this.dir);
        pathComponents = FSDirectory.getPathComponentsForReservedPath(dst1);
        final String dst = FSDirectory.resolvePath(dst1, pathComponents, this.dir);
        new HopsTransactionalRequestHandler(isUsingSubTreeLocks ? HDFSOperationType.SUBTREE_RENAME : HDFSOperationType.RENAME, src){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getRenameINodeLock(TransactionLockTypes.INodeLockType.WRITE_ON_TARGET_AND_PARENT, TransactionLockTypes.INodeResolveType.PATH, src, dst).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes());
                if (isUsingSubTreeLocks) {
                    il.setIgnoredSTOInodes(srcINodeID);
                }
                locks.add((Lock)il).add(lf.getBlockLock()).add(lf.getBlockRelated(LockFactory.BLK.RE, LockFactory.BLK.CR, LockFactory.BLK.UC, LockFactory.BLK.UR, LockFactory.BLK.IV, LockFactory.BLK.PE, LockFactory.BLK.ER));
                if (FSNamesystem.this.dir.isQuotaEnabled()) {
                    locks.add(lf.getQuotaUpdateLock(true, src, dst));
                }
                if (!isUsingSubTreeLocks) {
                    locks.add(lf.getLeaseLock(TransactionLockTypes.LockType.WRITE)).add(lf.getLeasePathLock(TransactionLockTypes.LockType.READ_COMMITTED));
                } else {
                    locks.add(lf.getLeaseLock(TransactionLockTypes.LockType.WRITE)).add(lf.getLeasePathLock(TransactionLockTypes.LockType.WRITE, src));
                }
                if (FSNamesystem.this.erasureCodingEnabled) {
                    locks.add(lf.getEncodingStatusLock(TransactionLockTypes.LockType.WRITE, dst));
                }
                locks.add(lf.getAcesLock());
            }

            public Object performTask() throws IOException {
                if (NameNode.stateChangeLog.isDebugEnabled()) {
                    NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.renameTo: with options - " + src + " to " + dst));
                }
                FSNamesystem.this.checkNameNodeSafeMode("Cannot rename " + src);
                if (!DFSUtil.isValidName(dst)) {
                    throw new InvalidPathException("Invalid name: " + dst);
                }
                for (MetadataLogEntry logEntry : logEntries) {
                    EntityManager.add((Object)logEntry);
                }
                AbstractFileTree.LoggingQuotaCountingFileTree.updateLogicalTime(logEntries);
                for (Options.Rename op : options) {
                    if (op != Options.Rename.KEEP_ENCODING_STATUS) continue;
                    INodesInPath srcInodesInPath = FSNamesystem.this.dir.getINodesInPath(src, false);
                    INode[] srcNodes = srcInodesInPath.getINodes();
                    INodesInPath dstInodesInPath = FSNamesystem.this.dir.getINodesInPath(dst, false);
                    INode[] dstNodes = dstInodesInPath.getINodes();
                    INode srcNode = srcNodes[srcNodes.length - 1];
                    INode dstNode = dstNodes[dstNodes.length - 1];
                    EncodingStatus status = (EncodingStatus)EntityManager.find((FinderType)EncodingStatus.Finder.ByInodeId, (Object[])new Object[]{dstNode.getId()});
                    EncodingStatus newStatus = new EncodingStatus(status);
                    newStatus.setInodeId(Long.valueOf(srcNode.getId()), srcNode.isInTree());
                    EntityManager.add((Object)newStatus);
                    EntityManager.remove((Object)status);
                    break;
                }
                FSNamesystem.this.removeSubTreeLocksForRenameInternal(src, isUsingSubTreeLocks, subTreeLockDst);
                FSNamesystem.this.dir.renameTo(src, dst, srcCounts, dstCounts, options);
                return null;
            }
        }.handle(this);
    }

    private void removeSubTreeLocksForRenameInternal(String src, boolean isUsingSubTreeLocks, String subTreeLockDst) throws StorageException, TransactionContextException, UnresolvedLinkException {
        if (isUsingSubTreeLocks && !src.equals("/")) {
            EntityManager.remove((Object)new SubTreeOperation(this.getSubTreeLockPathPrefix(src)));
            INodesInPath inodesInPath = this.dir.getINodesInPath(src, false);
            INode[] nodes = inodesInPath.getINodes();
            INode inode = nodes[nodes.length - 1];
            if (inode != null && inode.isSTOLocked()) {
                inode.setSubtreeLocked(false);
                EntityManager.update((Object)inode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    boolean multiTransactionalRename(String src, String dst) throws IOException {
        this.saveTimes();
        RetryCache.CacheEntry cacheEntry = this.retryCacheWaitForCompletionTransactional();
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return true;
        }
        boolean ret = false;
        try {
            ret = this.renameToInt(src, dst);
        }
        finally {
            this.retryCacheSetStateTransactional(cacheEntry, ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean renameToInt(String src1, String dst1) throws IOException {
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(src1);
        String src = FSDirectory.resolvePath(src1, pathComponents, this.dir);
        pathComponents = FSDirectory.getPathComponentsForReservedPath(dst1);
        String dst = FSDirectory.resolvePath(dst1, pathComponents, this.dir);
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.multiTransactionalRename: with options - " + src + " to " + dst));
        }
        this.checkNameNodeSafeMode("Cannot rename " + src);
        if (!DFSUtil.isValidName(dst)) {
            throw new InvalidPathException("Invalid name: " + dst);
        }
        if (INode.getPathComponents(src).length == 1) {
            NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst + " because source is the root"));
            return false;
        }
        PathInformation srcInfo = this.getPathExistingINodesFromDB(src, false, null, FsAction.WRITE, null, null);
        INode[] srcInodes = srcInfo.getPathInodes();
        INode srcInode = srcInodes[srcInodes.length - 1];
        if (srcInode == null) {
            NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst + " because source does not exist"));
            return false;
        }
        PathInformation dstInfo = this.getPathExistingINodesFromDB(dst, false, FsAction.WRITE, null, null, null);
        String actualDst = dst;
        if (dstInfo.isDir()) {
            actualDst = actualDst + "/" + new Path(src).getName();
        }
        if (actualDst.equals(src)) {
            return true;
        }
        INode[] dstInodes = dstInfo.getPathInodes();
        if (dstInodes[dstInodes.length - 2] == null) {
            NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst + " because destination's parent does not exist"));
            return false;
        }
        if (actualDst.startsWith(src) && actualDst.charAt(src.length()) == '/') {
            NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + actualDst + " because destination starts with src"));
            return false;
        }
        INode srcDataSet = this.getMetaEnabledParent(srcInfo.getPathInodes());
        INode dstDataSet = this.getMetaEnabledParent(dstInfo.getPathInodes());
        Collection<Object> logEntries = Collections.EMPTY_LIST;
        INode.DirCounts srcCounts = new INode.DirCounts();
        srcCounts.nsCount = srcInfo.getNsCount();
        srcCounts.dsCount = srcInfo.getDsCount();
        INode.DirCounts dstCounts = new INode.DirCounts();
        dstCounts.nsCount = dstInfo.getNsCount();
        dstCounts.dsCount = dstInfo.getDsCount();
        boolean isUsingSubTreeLocks = srcInfo.isDir();
        boolean renameTransactionCommitted = false;
        INodeIdentifier srcSubTreeRoot = null;
        String subTreeLockDst = INode.constructPath(dstInfo.getPathComponents(), 0, dstInfo.getNumExistingComp());
        if (subTreeLockDst.equals("")) {
            subTreeLockDst = "/";
        }
        try {
            if (isUsingSubTreeLocks) {
                LOG.debug((Object)("Rename src: " + src + " dst: " + dst + " requires sub-tree locking mechanism"));
                srcSubTreeRoot = this.lockSubtreeAndCheckPathPermission(src, false, null, FsAction.WRITE, null, null, SubTreeOperation.Type.RENAME_STO);
                if (srcSubTreeRoot != null) {
                    AbstractFileTree.QuotaCountingFileTree srcFileTree;
                    if (this.shouldLogSubtreeInodes(srcInfo, dstInfo, srcDataSet, dstDataSet, srcSubTreeRoot)) {
                        srcFileTree = new AbstractFileTree.LoggingQuotaCountingFileTree(this, srcSubTreeRoot, srcDataSet, dstDataSet);
                        srcFileTree.buildUp();
                        logEntries = ((AbstractFileTree.LoggingQuotaCountingFileTree)srcFileTree).getMetadataLogEntries();
                    } else {
                        srcFileTree = new AbstractFileTree.QuotaCountingFileTree(this, srcSubTreeRoot);
                        srcFileTree.buildUp();
                    }
                    srcCounts.nsCount = srcFileTree.getNamespaceCount();
                    srcCounts.dsCount = srcFileTree.getDiskspaceCount();
                }
                this.delayAfterBbuildingTree("Built tree of " + src1 + " for rename. ");
            } else {
                LOG.debug((Object)("Rename src: " + src + " dst: " + dst + " does not require sub-tree locking mechanism"));
            }
            boolean retValue = this.renameTo(src, srcSubTreeRoot != null ? srcSubTreeRoot.getInodeId() : 0L, dst, srcCounts, dstCounts, isUsingSubTreeLocks, subTreeLockDst, logEntries);
            renameTransactionCommitted = true;
            boolean bl = retValue;
            return bl;
        }
        finally {
            if (!renameTransactionCommitted && srcSubTreeRoot != null) {
                this.unlockSubtree(src, srcSubTreeRoot.getInodeId());
            }
        }
    }

    private boolean shouldLogSubtreeInodes(PathInformation srcInfo, PathInformation dstInfo, INode srcDataSet, INode dstDataSet, INodeIdentifier srcSubTreeRoot) {
        if (this.pathIsMetaEnabled(srcInfo.pathInodes) || this.pathIsMetaEnabled(dstInfo.pathInodes)) {
            if (srcDataSet == null) {
                if (dstDataSet != null) {
                    return true;
                }
            } else {
                if (dstDataSet == null) {
                    return !srcDataSet.equalsIdentifier(srcSubTreeRoot);
                }
                return !srcDataSet.equals(dstDataSet);
            }
        }
        return false;
    }

    @Deprecated
    boolean renameTo(String src1, final long srcINodeID, String dst1, final INode.DirCounts srcCounts, final INode.DirCounts dstCounts, final boolean isUsingSubTreeLocks, final String subTreeLockDst, final Collection<MetadataLogEntry> logEntries) throws IOException {
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(src1);
        final String src = FSDirectory.resolvePath(src1, pathComponents, this.dir);
        pathComponents = FSDirectory.getPathComponentsForReservedPath(dst1);
        final String dst = FSDirectory.resolvePath(dst1, pathComponents, this.dir);
        HopsTransactionalRequestHandler renameToHandler = new HopsTransactionalRequestHandler(isUsingSubTreeLocks ? HDFSOperationType.SUBTREE_DEPRICATED_RENAME : HDFSOperationType.DEPRICATED_RENAME, src){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getLegacyRenameINodeLock(TransactionLockTypes.INodeLockType.WRITE_ON_TARGET_AND_PARENT, TransactionLockTypes.INodeResolveType.PATH, src, dst).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(!FSNamesystem.this.dir.isQuotaEnabled());
                if (isUsingSubTreeLocks) {
                    il.setIgnoredSTOInodes(srcINodeID);
                }
                locks.add((Lock)il).add(lf.getBlockLock()).add(lf.getBlockRelated(LockFactory.BLK.RE, LockFactory.BLK.UC, LockFactory.BLK.IV, LockFactory.BLK.CR, LockFactory.BLK.ER, LockFactory.BLK.PE, LockFactory.BLK.UR));
                if (!isUsingSubTreeLocks) {
                    locks.add(lf.getLeaseLock(TransactionLockTypes.LockType.WRITE)).add(lf.getLeasePathLock(TransactionLockTypes.LockType.READ_COMMITTED));
                } else {
                    locks.add(lf.getLeaseLock(TransactionLockTypes.LockType.READ_COMMITTED)).add(lf.getLeasePathLock(TransactionLockTypes.LockType.READ_COMMITTED, src));
                }
                if (FSNamesystem.this.dir.isQuotaEnabled()) {
                    locks.add(lf.getQuotaUpdateLock(true, src, dst));
                }
            }

            public Object performTask() throws IOException {
                if (NameNode.stateChangeLog.isDebugEnabled()) {
                    NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.renameTo: " + src + " to " + dst));
                }
                FSNamesystem.this.checkNameNodeSafeMode("Cannot rename " + src);
                if (!DFSUtil.isValidName(dst)) {
                    throw new IOException("Invalid name: " + dst);
                }
                FSNamesystem.this.removeSubTreeLocksForRenameInternal(src, isUsingSubTreeLocks, subTreeLockDst);
                for (MetadataLogEntry logEntry : logEntries) {
                    EntityManager.add((Object)logEntry);
                }
                AbstractFileTree.LoggingQuotaCountingFileTree.updateLogicalTime(logEntries);
                return FSNamesystem.this.dir.renameTo(src, dst, srcCounts, dstCounts);
            }
        };
        return (Boolean)renameToHandler.handle(this);
    }

    boolean multiTransactionalDelete(String path, boolean recursive) throws IOException {
        this.saveTimes();
        if (!this.nameNode.isLeader() && this.dir.isQuotaEnabled()) {
            throw new NotALeaderException("Quota enabled. Delete operation can only be performed on a leader namenode");
        }
        boolean ret = false;
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.multiTransactionalDelete: " + path));
        }
        try {
            ret = this.multiTransactionalDeleteInternal(path, recursive);
            this.logAuditEvent(ret, "delete", path);
        }
        catch (IOException e) {
            this.logAuditEvent(false, "delete", path);
            throw e;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean multiTransactionalDeleteInternal(String path1, boolean recursive) throws IOException {
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(path1);
        String path = FSDirectory.resolvePath(path1, pathComponents, this.dir);
        this.checkNameNodeSafeMode("Cannot delete " + path);
        if (!recursive) {
            return this.deleteWithTransaction(path, recursive);
        }
        PathInformation pathInfo = this.getPathExistingINodesFromDB(path, false, null, FsAction.WRITE, null, null);
        INode[] pathInodes = pathInfo.getPathInodes();
        INode pathInode = pathInodes[pathInodes.length - 1];
        if (pathInode == null) {
            NameNode.stateChangeLog.debug((Object)("Failed to remove " + path + " because it does not exist"));
            return false;
        }
        if (pathInode.isRoot()) {
            NameNode.stateChangeLog.warn((Object)("Failed to remove " + path + " because the root is not allowed to be deleted"));
            return false;
        }
        INodeIdentifier subtreeRoot = null;
        if (pathInode.isFile()) {
            return this.deleteWithTransaction(path, false);
        }
        RetryCache.CacheEntry cacheEntry = this.retryCacheWaitForCompletionTransactional();
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return true;
        }
        boolean ret = false;
        try {
            if (!this.isLeader()) {
                throw new QuotaUpdateException("Unable to delete the file " + path + " because Quota is enabled and I am not the leader");
            }
            try {
                subtreeRoot = this.lockSubtreeAndCheckPathPermission(path, false, null, FsAction.WRITE, null, null, SubTreeOperation.Type.DELETE_STO);
                List<AclEntry> nearestDefaultsForSubtree = this.calculateNearestDefaultAclForSubtree(pathInfo);
                AbstractFileTree.FileTree fileTree = new AbstractFileTree.FileTree(this, subtreeRoot, FsAction.ALL, nearestDefaultsForSubtree);
                fileTree.buildUp();
                this.delayAfterBbuildingTree("Built tree for " + path1 + " for delete op");
                if (this.dir.isQuotaEnabled()) {
                    Iterator<Long> idIterator;
                    Iterator<Long> iterator = idIterator = fileTree.getAllINodesIds().iterator();
                    synchronized (iterator) {
                        this.quotaUpdateManager.addPrioritizedUpdates(idIterator);
                        try {
                            idIterator.wait();
                        }
                        catch (InterruptedException e) {
                            throw new IOException("Operation failed due to an Interrupt");
                        }
                    }
                }
                for (int i = fileTree.getHeight(); i > 0; --i) {
                    if (this.deleteTreeLevel(path, fileTree.getSubtreeRoot().getId(), fileTree, i)) continue;
                    boolean bl = ret = false;
                    return bl;
                }
            }
            finally {
                if (subtreeRoot != null) {
                    this.unlockSubtree(path, subtreeRoot.getInodeId());
                }
            }
            boolean bl = ret = true;
            return bl;
        }
        finally {
            this.retryCacheSetStateTransactional(cacheEntry, ret);
        }
    }

    private boolean deleteTreeLevel(String subtreeRootPath, long subTreeRootID, AbstractFileTree.FileTree fileTree, int level) throws TransactionContextException, IOException {
        ArrayList<Future> barrier = new ArrayList<Future>();
        for (ProjectedINode dir : fileTree.getDirsByLevel(level)) {
            Future f;
            Object path;
            if ((long)fileTree.countChildren(dir.getId()) <= this.BIGGEST_DELETABLE_DIR) {
                path = fileTree.createAbsolutePath(subtreeRootPath, dir);
                f = this.multiTransactionDeleteInternal((String)path, subTreeRootID);
                barrier.add(f);
                continue;
            }
            for (ProjectedINode inode : fileTree.getChildren(dir.getId())) {
                if (inode.isDirectory()) continue;
                String path2 = fileTree.createAbsolutePath(subtreeRootPath, inode);
                Future f2 = this.multiTransactionDeleteInternal(path2, subTreeRootID);
                barrier.add(f2);
            }
            path = fileTree.createAbsolutePath(subtreeRootPath, dir);
            f = this.multiTransactionDeleteInternal((String)path, subTreeRootID);
            barrier.add(f);
        }
        boolean result = true;
        for (Future f : barrier) {
            try {
                if (((Boolean)f.get()).booleanValue()) continue;
                result = false;
            }
            catch (ExecutionException e) {
                result = false;
                LOG.error((Object)"Exception was thrown during partial delete", (Throwable)e);
                Throwable throwable = e.getCause();
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                throw new IOException(e);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private Future multiTransactionDeleteInternal(final String path1, final long subTreeRootId) throws StorageException, TransactionContextException, IOException {
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(path1);
        final String path = FSDirectory.resolvePath(path1, pathComponents, this.dir);
        return this.subtreeOperationsExecutor.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                HopsTransactionalRequestHandler deleteHandler = new HopsTransactionalRequestHandler(HDFSOperationType.SUBTREE_DELETE){

                    public void acquireLock(TransactionLocks locks) throws IOException {
                        LockFactory lf = LockFactory.getInstance();
                        INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE_ON_TARGET_AND_PARENT, TransactionLockTypes.INodeResolveType.PATH_AND_ALL_CHILDREN_RECURSIVELY, path).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(!FSNamesystem.this.dir.isQuotaEnabled()).setIgnoredSTOInodes(subTreeRootId);
                        locks.add((Lock)il).add(lf.getLeaseLock(TransactionLockTypes.LockType.WRITE)).add(lf.getLeasePathLock(TransactionLockTypes.LockType.READ_COMMITTED)).add(lf.getBlockLock()).add(lf.getBlockRelated(LockFactory.BLK.RE, LockFactory.BLK.CR, LockFactory.BLK.UC, LockFactory.BLK.UR, LockFactory.BLK.PE, LockFactory.BLK.IV));
                        if (FSNamesystem.this.dir.isQuotaEnabled()) {
                            locks.add(lf.getQuotaUpdateLock(true, path));
                        }
                        if (FSNamesystem.this.erasureCodingEnabled) {
                            locks.add(lf.getEncodingStatusLock(true, TransactionLockTypes.LockType.WRITE, path));
                        }
                    }

                    public Object performTask() throws IOException {
                        if (!FSNamesystem.this.deleteInternal(path, true, false)) {
                            throw new RetriableException("Unable to Delete path: " + path1 + ". Possible subtree quiesce failure");
                        }
                        return true;
                    }
                };
                return (Boolean)deleteHandler.handle(this);
            }
        });
    }

    @VisibleForTesting
    INodeIdentifier lockSubtree(String path, SubTreeOperation.Type stoType) throws IOException {
        return this.lockSubtreeAndCheckPathPermission(path, false, null, null, null, null, stoType);
    }

    @VisibleForTesting
    private INodeIdentifier lockSubtreeAndCheckPathPermission(final String path, final boolean doCheckOwner, final FsAction ancestorAccess, final FsAction parentAccess, final FsAction access, final FsAction subAccess, final SubTreeOperation.Type stoType) throws IOException {
        if (path.compareTo("/") == 0) {
            return null;
        }
        return (INodeIdentifier)new HopsTransactionalRequestHandler(HDFSOperationType.SET_SUBTREE_LOCK){

            @Override
            public void setUp() throws IOException {
                super.setUp();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("About to lock \"" + path + "\""));
                }
            }

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, path);
                il.setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(!FSNamesystem.this.dir.isQuotaEnabled()).enableHierarchicalLocking(FSNamesystem.this.conf.getBoolean("dfs.namenode.subtree.hierarchical.locking", true));
                locks.add((Lock)il).add(lf.getSubTreeOpsLock(TransactionLockTypes.LockType.READ_COMMITTED, FSNamesystem.this.getSubTreeLockPathPrefix(path)));
                locks.add(lf.getAcesLock());
            }

            public Object performTask() throws IOException {
                INodesInPath inodesInPath;
                INode[] nodes;
                INode inode;
                FSPermissionChecker pc = FSNamesystem.this.getPermissionChecker();
                if (FSNamesystem.this.isPermissionEnabled && !pc.isSuperUser()) {
                    pc.checkPermission(path, FSNamesystem.this.dir, doCheckOwner, ancestorAccess, parentAccess, access, subAccess, true);
                }
                if ((inode = (nodes = (inodesInPath = FSNamesystem.this.dir.getINodesInPath(path, false)).getINodes())[nodes.length - 1]) != null && inode.isDirectory() && !inode.isRoot()) {
                    FSNamesystem.this.checkSubTreeLocks(FSNamesystem.this.getSubTreeLockPathPrefix(path));
                    inode.setSubtreeLocked(true);
                    inode.setSubtreeLockOwner(FSNamesystem.this.getNamenodeId());
                    EntityManager.update((Object)inode);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Lock the INode with sub tree lock flag. Path: \"" + path + "\"  id: " + inode.getId() + " pid: " + inode.getParentId() + " name: " + inode.getLocalName()));
                    }
                    EntityManager.update((Object)new SubTreeOperation(FSNamesystem.this.getSubTreeLockPathPrefix(path), FSNamesystem.this.nameNode.getId(), stoType));
                    INodeIdentifier iNodeIdentifier = new INodeIdentifier(Long.valueOf(inode.getId()), Long.valueOf(inode.getParentId()), inode.getLocalName(), inode.getPartitionId());
                    iNodeIdentifier.setDepth(Short.valueOf(inode.myDepth()));
                    FSNamesystem.this.delayBeforeSTOFlag(stoType.toString());
                    return iNodeIdentifier;
                }
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("No component was locked in the path using sub tree flag. Path: \"" + path + "\""));
                }
                return null;
            }
        }.handle(this);
    }

    private String getSubTreeLockPathPrefix(String path) {
        String subTreeLockPrefix = path;
        if (!subTreeLockPrefix.endsWith("/")) {
            subTreeLockPrefix = subTreeLockPrefix + "/";
        }
        return subTreeLockPrefix;
    }

    private void checkSubTreeLocks(String path) throws TransactionContextException, StorageException, RetriableException {
        List ops = (List)EntityManager.findList((FinderType)SubTreeOperation.Finder.ByPathPrefix, (Object[])new Object[]{path});
        HashSet<Long> activeNameNodeIds = new HashSet<Long>();
        for (ActiveNode node : this.nameNode.getActiveNameNodes().getActiveNodes()) {
            activeNameNodeIds.add(node.getId());
        }
        for (SubTreeOperation op : ops) {
            if (activeNameNodeIds.contains(op.getNameNodeId())) {
                throw new RetriableException("At least one ongoing subtree operation on the descendants of this subtree, e.g., Path: " + op.getPath() + " Operation: " + op.getOpType() + " NameNodeId: " + op.getNameNodeId());
            }
            EntityManager.remove((Object)op);
        }
    }

    @VisibleForTesting
    void unlockSubtree(final String path, final long ignoreStoInodeId) throws IOException {
        new HopsTransactionalRequestHandler(HDFSOperationType.RESET_SUBTREE_LOCK){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = (INodeLock)lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, path).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(!FSNamesystem.this.dir.isQuotaEnabled()).setIgnoredSTOInodes(ignoreStoInodeId).enableHierarchicalLocking(FSNamesystem.this.conf.getBoolean("dfs.namenode.subtree.hierarchical.locking", true));
                locks.add((Lock)il);
            }

            public Object performTask() throws IOException {
                INodesInPath inodesInPath = FSNamesystem.this.dir.getINodesInPath(path, false);
                INode[] nodes = inodesInPath.getINodes();
                INode inode = nodes[nodes.length - 1];
                if (inode != null && inode.isSTOLocked()) {
                    inode.setSubtreeLocked(false);
                    EntityManager.update((Object)inode);
                }
                EntityManager.remove((Object)new SubTreeOperation(FSNamesystem.this.getSubTreeLockPathPrefix(path)));
                return null;
            }
        }.handle(this);
    }

    private int pid(String param) {
        StringTokenizer tok = new StringTokenizer(param);
        tok.nextElement();
        return Integer.parseInt((String)tok.nextElement());
    }

    private String pname(String param) {
        StringTokenizer tok = new StringTokenizer(param);
        return (String)tok.nextElement();
    }

    @Override
    public NameNode getNameNode() {
        return this.nameNode;
    }

    public EncodingStatus getEncodingStatus(final String filePath) throws IOException {
        HopsTransactionalRequestHandler findReq = new HopsTransactionalRequestHandler(HDFSOperationType.FIND_ENCODING_STATUS){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.READ_COMMITTED, TransactionLockTypes.INodeResolveType.PATH, filePath).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes());
                locks.add((Lock)il).add(lf.getEncodingStatusLock(TransactionLockTypes.LockType.READ_COMMITTED, filePath));
            }

            public Object performTask() throws IOException {
                FSPermissionChecker pc = FSNamesystem.this.getPermissionChecker();
                try {
                    if (FSNamesystem.this.isPermissionEnabled) {
                        FSNamesystem.this.checkPathAccess(pc, filePath, FsAction.READ);
                    }
                }
                catch (AccessControlException e) {
                    FSNamesystem.this.logAuditEvent(false, "getEncodingStatus", filePath);
                    throw e;
                }
                INode targetNode = FSNamesystem.this.getINode(filePath);
                if (targetNode == null) {
                    throw new FileNotFoundException();
                }
                return EntityManager.find((FinderType)EncodingStatus.Finder.ByInodeId, (Object[])new Object[]{targetNode.getId()});
            }
        };
        Object result = findReq.handle();
        if (result == null) {
            return new EncodingStatus(EncodingStatus.Status.NOT_ENCODED);
        }
        return (EncodingStatus)result;
    }

    public INode findInode(final long id) throws IOException {
        LightWeightRequestHandler findHandler = new LightWeightRequestHandler(HDFSOperationType.GET_INODE){

            public Object performTask() throws IOException {
                INodeDataAccess dataAccess = (INodeDataAccess)HdfsStorageFactory.getDataAccess(INodeDataAccess.class);
                return dataAccess.findInodeByIdFTIS(id);
            }
        };
        return (INode)findHandler.handle();
    }

    public String getPath(long id, boolean inTree) throws IOException {
        LinkedList<INode> resolvedInodes = new LinkedList<INode>();
        boolean[] resolved = new boolean[1];
        INodeUtil.findPathINodesById(id, inTree, resolvedInodes, resolved);
        if (!resolved[0]) {
            throw new IOException("Path could not be resolved for inode with id " + id);
        }
        return INodeUtil.constructPath(resolvedInodes);
    }

    public LocatedBlocks getMissingBlockLocations(String clientMachine, String filePath) throws IOException {
        LocatedBlocks blocks = this.getBlockLocations(clientMachine, filePath, 0L, Long.MAX_VALUE);
        Iterator<LocatedBlock> iterator = blocks.getLocatedBlocks().iterator();
        while (iterator.hasNext()) {
            LocatedBlock b = iterator.next();
            if (b.isCorrupt() || b.getLocations().length == 0 && b.getBlockSize() > 0L) continue;
            iterator.remove();
        }
        return blocks;
    }

    public void addEncodingStatus(final String sourcePath, final EncodingPolicy policy, final EncodingStatus.Status status, final boolean checkRetryCache) throws IOException {
        new HopsTransactionalRequestHandler(HDFSOperationType.ADD_ENCODING_STATUS){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, sourcePath).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes());
                locks.add((Lock)il);
                locks.add(lf.getEncodingStatusLock(TransactionLockTypes.LockType.WRITE, sourcePath)).add(lf.getRetryCacheEntryLock(Server.getClientId(), Server.getCallId()));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object performTask() throws IOException {
                RetryCache.CacheEntry cacheEntry = null;
                if (checkRetryCache && (cacheEntry = RetryCacheDistributed.waitForCompletion((RetryCacheDistributed)FSNamesystem.this.retryCache)) != null && cacheEntry.isSuccess()) {
                    return null;
                }
                boolean success = false;
                try {
                    FSPermissionChecker pc = FSNamesystem.this.getPermissionChecker();
                    try {
                        if (FSNamesystem.this.isPermissionEnabled) {
                            FSNamesystem.this.checkPathAccess(pc, sourcePath, FsAction.WRITE);
                        }
                    }
                    catch (AccessControlException e) {
                        FSNamesystem.this.logAuditEvent(false, "encodeFile", sourcePath);
                        throw e;
                    }
                    INode target = FSNamesystem.this.getINode(sourcePath);
                    EncodingStatus existing = (EncodingStatus)EntityManager.find((FinderType)EncodingStatus.Finder.ByInodeId, (Object[])new Object[]{target.getId()});
                    if (existing != null) {
                        throw new IOException("Attempting to request encoding for anencoded file");
                    }
                    INode inode = FSNamesystem.this.dir.getINode(sourcePath);
                    EncodingStatus encodingStatus = new EncodingStatus(Long.valueOf(inode.getId()), inode.isInTree(), status, policy, Long.valueOf(System.currentTimeMillis()));
                    EntityManager.add((Object)encodingStatus);
                    success = true;
                    Object var8_9 = null;
                    return var8_9;
                }
                finally {
                    if (checkRetryCache) {
                        RetryCacheDistributed.setState((RetryCache.CacheEntry)cacheEntry, (boolean)success);
                    }
                }
            }
        }.handle();
    }

    public void removeEncodingStatus(final EncodingStatus encodingStatus) throws IOException {
        LightWeightRequestHandler removeHandler = new LightWeightRequestHandler(EncodingStatusOperationType.DELETE){

            public Object performTask() throws IOException {
                BlockChecksumDataAccess blockChecksumDataAccess = (BlockChecksumDataAccess)HdfsStorageFactory.getDataAccess(BlockChecksumDataAccess.class);
                EncodingStatusDataAccess encodingStatusDataAccess = (EncodingStatusDataAccess)HdfsStorageFactory.getDataAccess(EncodingStatusDataAccess.class);
                blockChecksumDataAccess.deleteAll(encodingStatus.getInodeId().longValue());
                blockChecksumDataAccess.deleteAll(encodingStatus.getParityInodeId().longValue());
                encodingStatusDataAccess.delete((Object)encodingStatus);
                return null;
            }
        };
        removeHandler.handle();
    }

    public void removeEncodingStatus(final String path, final EncodingStatus encodingStatus) throws IOException {
        new HopsTransactionalRequestHandler(HDFSOperationType.DELETE_ENCODING_STATUS){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, path).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes());
                locks.add((Lock)il).add(lf.getEncodingStatusLock(TransactionLockTypes.LockType.WRITE, path));
            }

            public Object performTask() throws IOException {
                EntityManager.remove((Object)encodingStatus);
                return null;
            }
        }.handle();
    }

    public void revokeEncoding(final String filePath, short replication) throws IOException {
        this.setReplication(filePath, replication);
        new HopsTransactionalRequestHandler(HDFSOperationType.REVOKE_ENCODING_STATUS){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, filePath).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes());
                locks.add((Lock)il).add(lf.getEncodingStatusLock(TransactionLockTypes.LockType.WRITE, filePath));
            }

            public Object performTask() throws IOException {
                FSPermissionChecker pc = FSNamesystem.this.getPermissionChecker();
                try {
                    if (FSNamesystem.this.isPermissionEnabled) {
                        FSNamesystem.this.checkPathAccess(pc, filePath, FsAction.WRITE);
                    }
                }
                catch (AccessControlException e) {
                    FSNamesystem.this.logAuditEvent(false, "revokeEncoding", filePath);
                    throw e;
                }
                INode targetNode = FSNamesystem.this.getINode(filePath);
                EncodingStatus encodingStatus = (EncodingStatus)EntityManager.find((FinderType)EncodingStatus.Finder.ByInodeId, (Object[])new Object[]{targetNode.getId()});
                encodingStatus.setRevoked(Boolean.valueOf(true));
                EntityManager.update((Object)encodingStatus);
                return null;
            }
        }.handle();
    }

    public void updateEncodingStatus(String sourceFile, EncodingStatus.Status status) throws IOException {
        this.updateEncodingStatus(sourceFile, status, null, null);
    }

    public void updateEncodingStatus(String sourceFile, EncodingStatus.ParityStatus parityStatus) throws IOException {
        this.updateEncodingStatus(sourceFile, null, parityStatus, null);
    }

    public void updateEncodingStatus(String sourceFile, EncodingStatus.Status status, String parityFile) throws IOException {
        this.updateEncodingStatus(sourceFile, status, null, parityFile);
    }

    public void updateEncodingStatus(final String sourceFile, final EncodingStatus.Status status, final EncodingStatus.ParityStatus parityStatus, final String parityFile) throws IOException {
        new HopsTransactionalRequestHandler(HDFSOperationType.UPDATE_ENCODING_STATUS){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, sourceFile).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes());
                locks.add((Lock)il).add(lf.getEncodingStatusLock(TransactionLockTypes.LockType.WRITE, sourceFile));
            }

            public Object performTask() throws IOException {
                INode targetNode = FSNamesystem.this.getINode(sourceFile);
                EncodingStatus encodingStatus = (EncodingStatus)EntityManager.find((FinderType)EncodingStatus.Finder.ByInodeId, (Object[])new Object[]{targetNode.getId()});
                if (status != null) {
                    encodingStatus.setStatus(status);
                    encodingStatus.setStatusModificationTime(Long.valueOf(System.currentTimeMillis()));
                }
                if (parityFile != null) {
                    encodingStatus.setParityFileName(parityFile);
                }
                if (parityStatus != null) {
                    encodingStatus.setParityStatus(parityStatus);
                    encodingStatus.setStatusModificationTime(Long.valueOf(System.currentTimeMillis()));
                }
                EntityManager.update((Object)encodingStatus);
                return null;
            }
        }.handle();
    }

    public INode getINode(String path) throws UnresolvedLinkException, StorageException, TransactionContextException {
        INodesInPath inodesInPath = this.dir.getINodesInPath4Write(path);
        INode[] inodes = inodesInPath.getINodes();
        return inodes[inodes.length - 1];
    }

    public boolean isErasureCodingEnabled() {
        return this.erasureCodingEnabled;
    }

    public void addBlockChecksum(final String src, final int blockIndex, final long checksum) throws IOException {
        new HopsTransactionalRequestHandler(HDFSOperationType.ADD_BLOCK_CHECKSUM){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes());
                locks.add((Lock)il);
            }

            public Object performTask() throws IOException {
                FSPermissionChecker pc = FSNamesystem.this.getPermissionChecker();
                try {
                    if (FSNamesystem.this.isPermissionEnabled) {
                        FSNamesystem.this.checkPathAccess(pc, src, FsAction.WRITE);
                    }
                }
                catch (AccessControlException e) {
                    FSNamesystem.this.logAuditEvent(false, "addBlockChecksum", src);
                    throw e;
                }
                long inodeId = FSNamesystem.this.dir.getINode(src).getId();
                BlockChecksum blockChecksum = new BlockChecksum(inodeId, blockIndex, checksum);
                EntityManager.add((Object)blockChecksum);
                return null;
            }
        }.handle();
    }

    public long getBlockChecksum(final String src, final int blockIndex) throws IOException {
        return (Long)new HopsTransactionalRequestHandler(HDFSOperationType.GET_BLOCK_CHECKSUM){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.READ, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes());
                locks.add((Lock)il).add(lf.getBlockChecksumLock(src, blockIndex));
            }

            public Object performTask() throws IOException {
                FSPermissionChecker pc = FSNamesystem.this.getPermissionChecker();
                try {
                    if (FSNamesystem.this.isPermissionEnabled) {
                        FSNamesystem.this.checkPathAccess(pc, src, FsAction.READ);
                    }
                }
                catch (AccessControlException e) {
                    FSNamesystem.this.logAuditEvent(false, "getBlockChecksum", src);
                    throw e;
                }
                INode node = FSNamesystem.this.dir.getINode(src);
                BlockChecksumDataAccess.KeyTuple key = new BlockChecksumDataAccess.KeyTuple(node.getId(), blockIndex);
                BlockChecksum checksum = (BlockChecksum)EntityManager.find((FinderType)BlockChecksum.Finder.ByKeyTuple, (Object[])new Object[]{key});
                if (checksum == null) {
                    throw new IOException("No checksum was found for " + key);
                }
                return checksum.getChecksum();
            }
        }.handle();
    }

    void modifyAclEntries(final String src, final List<AclEntry> aclSpec) throws IOException {
        this.aclConfigFlag.checkForApiCall();
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot modify acl entries " + src, this.safeMode());
        }
        new HopsTransactionalRequestHandler(HDFSOperationType.MODIFY_ACL_ENTRIES){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(false);
                locks.add((Lock)il);
                locks.add(lf.getAcesLock());
            }

            public Object performTask() throws IOException {
                FSPermissionChecker pc = FSNamesystem.this.getPermissionChecker();
                if (FSNamesystem.this.isPermissionEnabled) {
                    FSNamesystem.this.checkPathAccess(pc, src, FsAction.WRITE);
                }
                FSNamesystem.this.dir.modifyAclEntries(src, aclSpec);
                return null;
            }
        }.handle();
    }

    void removeAclEntries(final String src, final List<AclEntry> aclSpec) throws IOException {
        this.aclConfigFlag.checkForApiCall();
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot remove acl entries " + src, this.safeMode());
        }
        new HopsTransactionalRequestHandler(HDFSOperationType.REMOVE_ACL_ENTRIES){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(true);
                locks.add((Lock)il);
                locks.add(lf.getAcesLock());
            }

            public Object performTask() throws IOException {
                FSPermissionChecker pc = FSNamesystem.this.getPermissionChecker();
                if (FSNamesystem.this.isPermissionEnabled) {
                    FSNamesystem.this.checkPathAccess(pc, src, FsAction.WRITE);
                }
                FSNamesystem.this.dir.removeAclEntries(src, aclSpec);
                return null;
            }
        }.handle();
    }

    void removeDefaultAcl(final String src) throws IOException {
        this.aclConfigFlag.checkForApiCall();
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot remove default acl " + src, this.safeMode());
        }
        new HopsTransactionalRequestHandler(HDFSOperationType.REMOVE_DEFAULT_ACL){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(true);
                locks.add((Lock)il);
                locks.add(lf.getAcesLock());
            }

            public Object performTask() throws IOException {
                FSPermissionChecker pc = FSNamesystem.this.getPermissionChecker();
                if (FSNamesystem.this.isPermissionEnabled) {
                    FSNamesystem.this.checkPathAccess(pc, src, FsAction.WRITE);
                }
                FSNamesystem.this.dir.removeDefaultAcl(src);
                return null;
            }
        }.handle();
    }

    void removeAcl(final String src) throws IOException {
        this.aclConfigFlag.checkForApiCall();
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot remove acl " + src, this.safeMode());
        }
        new HopsTransactionalRequestHandler(HDFSOperationType.REMOVE_ACL){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(true);
                locks.add((Lock)il);
                locks.add(lf.getAcesLock());
            }

            public Object performTask() throws IOException {
                FSPermissionChecker pc = FSNamesystem.this.getPermissionChecker();
                if (FSNamesystem.this.isPermissionEnabled) {
                    FSNamesystem.this.checkPathAccess(pc, src, FsAction.WRITE);
                }
                FSNamesystem.this.dir.removeAcl(src);
                return null;
            }
        }.handle();
    }

    void setAcl(final String src, final List<AclEntry> aclSpec) throws IOException {
        this.aclConfigFlag.checkForApiCall();
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot set acl " + src, this.safeMode());
        }
        new HopsTransactionalRequestHandler(HDFSOperationType.SET_ACL){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(true);
                locks.add((Lock)il);
                locks.add(lf.getAcesLock());
            }

            public Object performTask() throws IOException {
                FSPermissionChecker pc = FSNamesystem.this.getPermissionChecker();
                if (FSNamesystem.this.isPermissionEnabled) {
                    FSNamesystem.this.checkPathAccess(pc, src, FsAction.WRITE);
                }
                FSNamesystem.this.dir.setAcl(src, aclSpec);
                return null;
            }
        }.handle();
    }

    AclStatus getAclStatus(final String src) throws IOException {
        this.aclConfigFlag.checkForApiCall();
        return (AclStatus)new HopsTransactionalRequestHandler(HDFSOperationType.GET_ACL_STATUS){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.READ, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(true);
                locks.add((Lock)il);
                locks.add(lf.getAcesLock());
            }

            public Object performTask() throws IOException {
                FSPermissionChecker pc = FSNamesystem.this.getPermissionChecker();
                if (FSNamesystem.this.isPermissionEnabled) {
                    FSNamesystem.this.checkPathAccess(pc, src, FsAction.READ);
                }
                return FSNamesystem.this.dir.getAclStatus(src);
            }
        }.handle();
    }

    public LocatedBlock getRepairedBlockLocations(String clientMachine, final String sourcePath, String parityPath, LocatedBlock block, boolean isParity) throws IOException {
        DatanodeInfo[] nodes;
        int index;
        int i;
        EncodingStatus status = this.getEncodingStatus(sourcePath);
        Codec codec = Codec.getCodec(status.getEncodingPolicy().getCodec());
        ArrayList<LocatedBlock> sourceLocations = new ArrayList<LocatedBlock>(this.getBlockLocations(clientMachine, sourcePath, 0L, Long.MAX_VALUE).getLocatedBlocks());
        Collections.sort(sourceLocations, LocatedBlock.blockIdComparator);
        ArrayList<LocatedBlock> parityLocations = new ArrayList<LocatedBlock>(this.getBlockLocations(clientMachine, parityPath, 0L, Long.MAX_VALUE).getLocatedBlocks());
        Collections.sort(parityLocations, LocatedBlock.blockIdComparator);
        HashSet<Node> excluded = new HashSet<Node>();
        int stripe = isParity ? this.getStripe(block, parityLocations, codec.getParityLength()) : this.getStripe(block, sourceLocations, codec.getStripeLength());
        for (i = index = stripe * codec.getStripeLength(); i < sourceLocations.size() && i < index + codec.getStripeLength(); ++i) {
            for (DatanodeInfo node : nodes = sourceLocations.get(i).getLocations()) {
                excluded.add(node);
            }
        }
        for (i = index = stripe * codec.getParityLength(); i < parityLocations.size() && i < index + codec.getParityLength(); ++i) {
            for (DatanodeInfo node : nodes = parityLocations.get(i).getLocations()) {
                excluded.add(node);
            }
        }
        byte storagePolicyID = (Byte)new HopsTransactionalRequestHandler(HDFSOperationType.TEST){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.READ_COMMITTED, TransactionLockTypes.INodeResolveType.PATH, sourcePath).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes());
                locks.add((Lock)il);
            }

            public Object performTask() throws IOException {
                INode targetNode = FSNamesystem.this.nameNode.getNamesystem().getINode(sourcePath);
                return targetNode.getLocalStoragePolicyID();
            }
        }.handle();
        LinkedList<DatanodeStorageInfo> chosenStorages = new LinkedList<DatanodeStorageInfo>();
        DatanodeStorageInfo[] descriptors = this.blockManager.chooseTarget4ParityRepair(isParity ? parityPath : sourcePath, isParity ? (short)1 : status.getEncodingPolicy().getTargetReplication(), null, chosenStorages, excluded, block.getBlockSize(), storagePolicyID);
        return new LocatedBlock(block.getBlock(), descriptors);
    }

    private int getStripe(LocatedBlock block, ArrayList<LocatedBlock> locatedBlocks, int length) {
        int i = 0;
        for (LocatedBlock b : locatedBlocks) {
            if (block.getBlock().getBlockId() == b.getBlock().getBlockId()) break;
            ++i;
        }
        return i / length;
    }

    private PathInformation getPathExistingINodesFromDB(final String path, final boolean doCheckOwner, final FsAction ancestorAccess, final FsAction parentAccess, final FsAction access, final FsAction subAccess) throws IOException {
        HopsTransactionalRequestHandler handler = new HopsTransactionalRequestHandler(HDFSOperationType.SUBTREE_PATH_INFO){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.READ_COMMITTED, TransactionLockTypes.INodeResolveType.PATH, path).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(!FSNamesystem.this.dir.isQuotaEnabled());
                locks.add((Lock)il).add(lf.getBlockLock());
                locks.add(lf.getAcesLock());
            }

            public Object performTask() throws IOException {
                FSPermissionChecker pc = FSNamesystem.this.getPermissionChecker();
                if (FSNamesystem.this.isPermissionEnabled && !pc.isSuperUser()) {
                    pc.checkPermission(path, FSNamesystem.this.dir, doCheckOwner, ancestorAccess, parentAccess, access, subAccess, true);
                }
                byte[][] pathComponents = INode.getPathComponents(path);
                boolean isDir = false;
                INode.DirCounts srcCounts = new INode.DirCounts();
                INodesInPath dstInodesInPath = FSNamesystem.this.dir.getExistingPathINodes(pathComponents);
                INode[] pathInodes = dstInodesInPath.getINodes();
                INodeAttributes quotaDirAttributes = null;
                INode leafInode = pathInodes[pathInodes.length - 1];
                if (leafInode != null) {
                    if (leafInode instanceof INodeFile) {
                        isDir = false;
                        leafInode.spaceConsumedInTree(srcCounts);
                    } else {
                        DirectoryWithQuotaFeature q;
                        isDir = true;
                        if (leafInode instanceof INodeDirectory && FSNamesystem.this.dir.isQuotaEnabled() && (q = ((INodeDirectory)leafInode).getDirectoryWithQuotaFeature()) != null) {
                            quotaDirAttributes = q.getINodeAttributes((INodeDirectory)leafInode);
                        }
                    }
                }
                List[] acls = new List[pathInodes.length];
                for (int i = 0; i < pathInodes.length; ++i) {
                    if (pathInodes[i] == null) continue;
                    AclFeature aclFeature = INodeAclHelper.getAclFeature(pathInodes[i]);
                    acls[i] = aclFeature != null ? aclFeature.getEntries() : null;
                }
                return new PathInformation(path, pathComponents, pathInodes, dstInodesInPath.getNumNonNull(), isDir, srcCounts.getNsCount(), srcCounts.getDsCount(), quotaDirAttributes, acls);
            }
        };
        return (PathInformation)handler.handle(this);
    }

    public boolean storeSmallFilesInDB() {
        return this.storeSmallFilesInDB;
    }

    public static int dbOnDiskFileMaximumSize() {
        return DB_ON_DISK_FILE_MAX_SIZE;
    }

    public static int dbOnDiskSmallFileMaxSize() {
        return DB_ON_DISK_SMALL_FILE_MAX_SIZE;
    }

    public static int dbOnDiskMediumFileMaxSize() {
        return DB_ON_DISK_MEDIUM_FILE_MAX_SIZE;
    }

    public static int dbOnDiskLargeFileMaxSize() {
        return DB_ON_DISK_LARGE_FILE_MAX_SIZE;
    }

    public static int dbInMemorySmallFileMaxSize() {
        return DB_IN_MEMORY_FILE_MAX_SIZE;
    }

    public byte[] getSmallFileData(final long id) throws IOException {
        final long inodeId = -id;
        return (byte[])new HopsTransactionalRequestHandler(HDFSOperationType.GET_SMALL_FILE_DATA){
            INodeIdentifier inodeIdentifier;

            @Override
            public void setUp() throws StorageException {
                this.inodeIdentifier = new INodeIdentifier(Long.valueOf(inodeId));
            }

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getIndividualINodeLock(TransactionLockTypes.INodeLockType.READ, this.inodeIdentifier));
            }

            public Object performTask() throws IOException {
                INode iNode = (INode)EntityManager.find((FinderType)INode.Finder.ByINodeIdFTIS, (Object[])new Object[]{inodeId});
                if (iNode == null) {
                    throw new FileNotFoundException("The file id: " + id + " does not exist");
                }
                if (iNode instanceof INodeFile) {
                    INodeFile file = (INodeFile)iNode;
                    if (!file.isFileStoredInDB()) {
                        throw new IOException("The requested file is not stored in the database.");
                    }
                    return ((INodeFile)iNode).getFileDataInDB();
                }
                throw new FileNotFoundException("Inode id: " + id + " is not a file.");
            }
        }.handle();
    }

    void checkAccess(final String src, final FsAction mode) throws IOException {
        HopsTransactionalRequestHandler checkAccessHandler = new HopsTransactionalRequestHandler(HDFSOperationType.CHECK_ACCESS, src){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.READ, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(true);
                locks.add((Lock)il);
            }

            public Object performTask() throws IOException {
                FSPermissionChecker pc = FSNamesystem.this.getPermissionChecker();
                try {
                    INode inode = FSNamesystem.this.getINode(src);
                    if (inode == null) {
                        throw new FileNotFoundException("Path not found");
                    }
                    if (FSNamesystem.this.isPermissionEnabled) {
                        FSNamesystem.this.checkPermission(pc, src, false, null, null, mode, null);
                    }
                }
                catch (AccessControlException e) {
                    FSNamesystem.this.logAuditEvent(false, "checkAccess", src);
                    throw e;
                }
                return null;
            }
        };
        if (!DFSUtil.isValidName(src)) {
            throw new InvalidPathException("Invalid file name: " + src);
        }
        checkAccessHandler.handle(this);
    }

    public LastUpdatedContentSummary getLastUpdatedContentSummary(final String path) throws IOException {
        LastUpdatedContentSummary luSummary = (LastUpdatedContentSummary)new HopsTransactionalRequestHandler(HDFSOperationType.GET_LAST_UPDATED_CONTENT_SUMMARY){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.READ_COMMITTED, TransactionLockTypes.INodeResolveType.PATH, path).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(!FSNamesystem.this.dir.isQuotaEnabled());
                locks.add((Lock)il);
            }

            public Object performTask() throws IOException {
                INodeDirectory quotaDir;
                DirectoryWithQuotaFeature q;
                INode subtreeRoot = FSNamesystem.this.getINode(path);
                if (subtreeRoot instanceof INodeDirectory && (q = (quotaDir = (INodeDirectory)subtreeRoot).getDirectoryWithQuotaFeature()) != null) {
                    return new LastUpdatedContentSummary(q.numItemsInTree(quotaDir), q.diskspaceConsumed(quotaDir), quotaDir.getQuotaCounts().get(Quota.NAMESPACE), quotaDir.getQuotaCounts().get(Quota.DISKSPACE));
                }
                return null;
            }
        }.handle(this);
        if (luSummary == null) {
            ContentSummary summary = this.getContentSummary(path);
            luSummary = new LastUpdatedContentSummary(summary.getFileCount() + summary.getDirectoryCount(), summary.getSpaceConsumed(), summary.getQuota(), summary.getSpaceQuota());
        }
        return luSummary;
    }

    private RetryCache.CacheEntry retryCacheWaitForCompletionTransactional() throws IOException {
        HopsTransactionalRequestHandler rh = new HopsTransactionalRequestHandler(HDFSOperationType.RETRY_CACHE){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getRetryCacheEntryLock(Server.getClientId(), Server.getCallId()));
            }

            public Object performTask() throws IOException {
                return RetryCacheDistributed.waitForCompletion((RetryCacheDistributed)FSNamesystem.this.retryCache);
            }
        };
        return (RetryCache.CacheEntry)rh.handle(this);
    }

    private RetryCache.CacheEntry retryCacheSetStateTransactional(final RetryCache.CacheEntry cacheEntry, final boolean ret) throws IOException {
        HopsTransactionalRequestHandler rh = new HopsTransactionalRequestHandler(HDFSOperationType.RETRY_CACHE){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getRetryCacheEntryLock(Server.getClientId(), Server.getCallId()));
            }

            public Object performTask() throws IOException {
                RetryCacheDistributed.setState((RetryCache.CacheEntry)cacheEntry, (boolean)ret);
                return null;
            }
        };
        return (RetryCache.CacheEntry)rh.handle(this);
    }

    private List<AclEntry> calculateNearestDefaultAclForSubtree(PathInformation pathInfo) throws IOException {
        for (int i = pathInfo.pathInodeAcls.length - 1; i > -1; --i) {
            List aclEntries = pathInfo.pathInodeAcls[i];
            if (aclEntries == null) continue;
            ArrayList<AclEntry> onlyDefaults = new ArrayList<AclEntry>();
            for (AclEntry aclEntry : aclEntries) {
                if (!aclEntry.getScope().equals((Object)AclEntryScope.DEFAULT)) continue;
                onlyDefaults.add(aclEntry);
            }
            if (onlyDefaults.isEmpty()) continue;
            return onlyDefaults;
        }
        return new ArrayList<AclEntry>();
    }

    public void setDelayBeforeSTOFlag(long delay) {
        if (this.isTestingSTO) {
            this.delayBeforeSTOFlag = delay;
        }
    }

    public void setDelayAfterBuildingTree(long delay) {
        if (this.isTestingSTO) {
            this.delayAfterBuildingTree = delay;
        }
    }

    public void delayBeforeSTOFlag(String message) {
        if (this.isTestingSTO) {
            Times time = this.delays.get();
            if (time == null) {
                time = this.saveTimes();
            }
            try {
                LOG.debug((Object)("Testing STO. " + message + " Sleeping for " + time.delayBeforeSTOFlag));
                Thread.sleep(time.delayBeforeSTOFlag);
                LOG.debug((Object)("Testing STO. " + message + " Waking up from sleep of " + time.delayBeforeSTOFlag));
            }
            catch (InterruptedException e) {
                LOG.warn((Object)e);
            }
        }
    }

    public void delayAfterBbuildingTree(String message) {
        if (this.isTestingSTO) {
            Times time = this.delays.get();
            if (time == null) {
                time = this.saveTimes();
            }
            try {
                LOG.debug((Object)("Testing STO. " + message + " Sleeping for " + time.delayAfterBuildingTree));
                Thread.sleep(time.delayAfterBuildingTree);
                LOG.debug((Object)("Testing STO. " + message + " Waking up from sleep of " + time.delayAfterBuildingTree));
            }
            catch (InterruptedException e) {
                LOG.warn((Object)e);
            }
        }
    }

    public void setTestingSTO(boolean val) {
        this.isTestingSTO = val;
    }

    public boolean isTestingSTO() {
        return this.isTestingSTO;
    }

    private Times saveTimes() {
        if (this.isTestingSTO) {
            this.delays.remove();
            Times times = new Times(this.delayBeforeSTOFlag, this.delayAfterBuildingTree);
            this.delays.set(times);
            return times;
        }
        return null;
    }

    private class Times {
        long delayBeforeSTOFlag = 0L;
        long delayAfterBuildingTree = 0L;

        public Times(long delayBeforeSTOFlag, long delayAfterBuildingTree) {
            this.delayBeforeSTOFlag = delayBeforeSTOFlag;
            this.delayAfterBuildingTree = delayAfterBuildingTree;
        }
    }

    class RetryCacheCleaner
    implements Runnable {
        boolean shouldCacheCleanerRun = true;
        long entryExpiryMillis;
        Timer timer = new Timer();

        public RetryCacheCleaner() {
            this.entryExpiryMillis = FSNamesystem.this.conf.getLong("dfs.namenode.retrycache.expirytime.millis", 600000L);
        }

        @Override
        public void run() {
            try {
                int numRun = 0;
                while (FSNamesystem.this.fsRunning && this.shouldCacheCleanerRun) {
                    final ArrayList toRemove = new ArrayList();
                    int num = FSNamesystem.this.retryCache.getToRemove().drainTo(toRemove);
                    if (num > 0) {
                        HopsTransactionalRequestHandler rh = new HopsTransactionalRequestHandler(HDFSOperationType.CLEAN_RETRY_CACHE){

                            public void acquireLock(TransactionLocks locks) throws IOException {
                                LockFactory lf = LockFactory.getInstance();
                                locks.add(lf.getRetryCacheEntryLock(toRemove));
                            }

                            public Object performTask() throws IOException {
                                for (RetryCache.CacheEntry entry : toRemove) {
                                    EntityManager.remove((Object)new RetryCacheEntry(entry.getClientId(), entry.getCallId()));
                                }
                                return null;
                            }
                        };
                        rh.handle();
                    }
                    if (FSNamesystem.this.isLeader() && numRun % 60 == 0) {
                        new LightWeightRequestHandler(HDFSOperationType.CLEAN_RETRY_CACHE){

                            public Object performTask() throws IOException {
                                RetryCacheEntryDataAccess da = (RetryCacheEntryDataAccess)HdfsStorageFactory.getDataAccess(RetryCacheEntryDataAccess.class);
                                da.removeOlds(RetryCacheCleaner.this.timer.now() - RetryCacheCleaner.this.entryExpiryMillis);
                                return null;
                            }
                        }.handle();
                    }
                    Thread.sleep(1000L);
                    ++numRun;
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Exception in RetryCacheCleaner: ", (Throwable)e);
            }
        }

        public void stopMonitor() {
            this.shouldCacheCleanerRun = false;
        }
    }

    private class PathInformation {
        private String path;
        private byte[][] pathComponents;
        private INode[] pathInodes;
        private boolean dir;
        private long nsCount;
        private long dsCount;
        private int numExistingComp;
        private final INodeAttributes subtreeRootAttributes;
        private final List<AclEntry>[] pathInodeAcls;

        public PathInformation(String path, byte[][] pathComponents, INode[] pathInodes, int numExistingComp, boolean dir, long nsCount, long dsCount, INodeAttributes subtreeRootAttributes, List<AclEntry>[] pathInodeAcls) {
            this.path = path;
            this.pathComponents = pathComponents;
            this.pathInodes = pathInodes;
            this.dir = dir;
            this.nsCount = nsCount;
            this.dsCount = dsCount;
            this.numExistingComp = numExistingComp;
            this.subtreeRootAttributes = subtreeRootAttributes;
            this.pathInodeAcls = pathInodeAcls;
        }

        public String getPath() {
            return this.path;
        }

        public byte[][] getPathComponents() {
            return this.pathComponents;
        }

        public INode[] getPathInodes() {
            return this.pathInodes;
        }

        public boolean isDir() {
            return this.dir;
        }

        public long getNsCount() {
            return this.nsCount;
        }

        public long getDsCount() {
            return this.dsCount;
        }

        public int getNumExistingComp() {
            return this.numExistingComp;
        }

        public INodeAttributes getSubtreeRootAttributes() {
            return this.subtreeRootAttributes;
        }

        public List<AclEntry>[] getPathInodeAcls() {
            return this.pathInodeAcls;
        }
    }

    public class FNode
    implements Comparable<FNode> {
        private String parentPath;
        private INode inode;

        public FNode(String parentPath, INode inode) {
            this.parentPath = parentPath;
            this.inode = inode;
        }

        public String getPath() {
            if (this.parentPath.endsWith("/")) {
                return this.parentPath + this.inode.getLocalName();
            }
            return this.parentPath + "/" + this.inode.getLocalName();
        }

        public INode getINode() {
            return this.inode;
        }

        public String getParentPath() {
            return this.parentPath;
        }

        @Override
        public int compareTo(FNode o) {
            int obj1Length = INode.getPathComponents(this.getPath()).length;
            int obj2Length = INode.getPathComponents(o.getPath()).length;
            return Integer.compare(obj2Length, obj1Length);
        }
    }

    private static class DefaultAuditLogger
    extends HdfsAuditLogger {
        private boolean logTokenTrackingId;

        private DefaultAuditLogger() {
        }

        @Override
        public void initialize(Configuration conf) {
            this.logTokenTrackingId = conf.getBoolean("dfs.namenode.audit.log.token.tracking.id", false);
        }

        @Override
        public void logAuditEvent(boolean succeeded, String userName, InetAddress addr, String cmd, String src, String dst, FileStatus status, UserGroupInformation ugi, DelegationTokenSecretManager dtSecretManager) {
            if (auditLog.isInfoEnabled()) {
                StringBuilder sb = (StringBuilder)auditBuffer.get();
                sb.setLength(0);
                sb.append("allowed=").append(succeeded).append("\t");
                sb.append("ugi=").append(userName).append("\t");
                sb.append("ip=").append(addr).append("\t");
                sb.append("cmd=").append(cmd).append("\t");
                sb.append("src=").append(src).append("\t");
                sb.append("dst=").append(dst).append("\t");
                if (null == status) {
                    sb.append("perm=null");
                } else {
                    sb.append("perm=");
                    sb.append(status.getOwner()).append(":");
                    sb.append(status.getGroup()).append(":");
                    sb.append(status.getPermission());
                }
                if (this.logTokenTrackingId) {
                    sb.append("\t").append("trackingId=");
                    String trackingId = null;
                    if (ugi != null && dtSecretManager != null && ugi.getAuthenticationMethod() == UserGroupInformation.AuthenticationMethod.TOKEN) {
                        for (TokenIdentifier tid : ugi.getTokenIdentifiers()) {
                            if (!(tid instanceof DelegationTokenIdentifier)) continue;
                            DelegationTokenIdentifier dtid = (DelegationTokenIdentifier)tid;
                            trackingId = dtSecretManager.getTokenTrackingId(dtid);
                            break;
                        }
                    }
                    sb.append(trackingId);
                }
                sb.append("\t").append("proto=");
                sb.append(NamenodeWebHdfsMethods.isWebHdfsInvocation() ? "webhdfs" : "rpc");
                this.logAuditMessage(sb.toString());
            }
        }

        public void logAuditMessage(String message) {
            auditLog.info((Object)message);
        }
    }

    static class CorruptFileBlockInfo {
        String path;
        Block block;

        CorruptFileBlockInfo(String p, Block b) {
            this.path = p;
            this.block = b;
        }

        public String toString() {
            return this.block.getBlockName() + "\t" + this.path;
        }
    }

    class SafeModeMonitor
    implements Runnable {
        private static final long recheckInterval = 1000L;

        SafeModeMonitor() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                SafeModeInfo safeMode;
                while (FSNamesystem.this.fsRunning && (safeMode = FSNamesystem.this.safeMode()) != null) {
                    if (safeMode.canLeave()) {
                        safeMode.leave();
                        FSNamesystem.this.smmthread = null;
                        break;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                if (FSNamesystem.this.fsRunning) return;
                LOG.info((Object)"NameNode is being shutdown, exit SafeModeMonitor thread");
                return;
            }
            catch (IOException ex) {
                LOG.error((Object)ex);
            }
        }
    }

    public class SafeModeInfo {
        private double threshold;
        private int datanodeThreshold;
        private int extension;
        private int safeReplication;
        private double replicationQueueThreshold;
        private long lastStatusReport = 0L;
        private boolean resourcesLow = false;
        private StartupProgress.Counter awaitingReportedBlocksCounter;
        public ThreadLocal<Boolean> safeModePendingOperation = new ThreadLocal();

        private long reached() throws IOException {
            return HdfsVariables.getSafeModeReached();
        }

        private SafeModeInfo(Configuration conf) throws IOException {
            this.threshold = conf.getFloat("dfs.namenode.safemode.threshold-pct", 0.999f);
            if (this.threshold > 1.0) {
                LOG.warn((Object)("The threshold value should't be greater than 1, threshold: " + this.threshold));
            }
            this.datanodeThreshold = conf.getInt("dfs.namenode.safemode.min.datanodes", 0);
            this.extension = conf.getInt("dfs.namenode.safemode.extension", 0);
            this.safeReplication = conf.getInt("dfs.namenode.replication.min", 1);
            if (this.safeReplication > 1) {
                LOG.warn((Object)"Only safe replication 1 is supported");
                this.safeReplication = 1;
            }
            LOG.info((Object)("dfs.namenode.safemode.threshold-pct = " + this.threshold));
            LOG.info((Object)("dfs.namenode.safemode.min.datanodes = " + this.datanodeThreshold));
            LOG.info((Object)("dfs.namenode.safemode.extension     = " + this.extension));
            this.replicationQueueThreshold = conf.getFloat("dfs.namenode.replqueue.threshold-pct", (float)this.threshold);
            HdfsVariables.setBlockTotal(0);
        }

        private SafeModeInfo(boolean resourcesLow) throws IOException {
            this.threshold = 1.5;
            this.datanodeThreshold = Integer.MAX_VALUE;
            this.extension = Integer.MAX_VALUE;
            this.safeReplication = 32768;
            this.replicationQueueThreshold = 1.5;
            HdfsVariables.setBlockTotal(-1);
            this.resourcesLow = resourcesLow;
            this.enter();
            this.reportStatus("STATE* Safe mode is ON.", true);
        }

        private SafeModeInfo(double threshold, int datanodeThreshold, int extension, int safeReplication, double replicationQueueThreshold, boolean resourcesLow) throws IOException {
            this.threshold = threshold;
            this.datanodeThreshold = datanodeThreshold;
            this.extension = extension;
            this.safeReplication = safeReplication;
            this.replicationQueueThreshold = replicationQueueThreshold;
            this.resourcesLow = resourcesLow;
        }

        public double getThreshold() {
            return this.threshold;
        }

        public int getDatanodeThreshold() {
            return this.datanodeThreshold;
        }

        public int getExtension() {
            return this.extension;
        }

        public int getSafeReplication() {
            return this.safeReplication;
        }

        public double getReplicationQueueThreshold() {
            return this.replicationQueueThreshold;
        }

        public long getLastStatusReport() {
            return this.lastStatusReport;
        }

        public boolean isResourcesLow() {
            return this.resourcesLow;
        }

        public long getReached() throws IOException {
            return this.reached();
        }

        private boolean isOn() throws IOException {
            this.doConsistencyCheck();
            return this.reached() >= 0L;
        }

        private void enter() throws IOException {
            if (FSNamesystem.this.isLeader()) {
                LOG.info((Object)"enter safe mode");
                HdfsVariables.setSafeModeReached(0L);
            }
        }

        private void leave() throws IOException {
            if (!FSNamesystem.this.isPopulatingReplQueues() && FSNamesystem.this.shouldPopulateReplicationQueues()) {
                FSNamesystem.this.initializeReplQueues();
            }
            this.leaveInternal();
            FSNamesystem.this.clearSafeBlocks();
        }

        private void leaveInternal() throws IOException {
            long timeInSafeMode = Time.now() - FSNamesystem.this.startTime;
            NameNode.stateChangeLog.info((Object)("STATE* Leaving safe mode after " + timeInSafeMode / 1000L + " secs"));
            NameNode.getNameNodeMetrics().setSafeModeTime((int)timeInSafeMode);
            if (this.reached() >= 0L) {
                NameNode.stateChangeLog.info((Object)"STATE* Safe mode is OFF");
            }
            if (FSNamesystem.this.isLeader()) {
                HdfsVariables.exitSafeMode();
            }
            NetworkTopology nt = FSNamesystem.this.blockManager.getDatanodeManager().getNetworkTopology();
            NameNode.stateChangeLog.info((Object)("STATE* Network topology has " + nt.getNumOfRacks() + " racks and " + nt.getNumOfLeaves() + " datanodes"));
            NameNode.stateChangeLog.info((Object)("STATE* UnderReplicatedBlocks has " + FSNamesystem.this.blockManager.numOfUnderReplicatedBlocks() + " blocks"));
            FSNamesystem.this.startSecretManagerIfNecessary();
            StartupProgress prog = NameNode.getStartupProgress();
            if (prog.getStatus(Phase.SAFEMODE) != Status.COMPLETE) {
                prog.endStep(Phase.SAFEMODE, STEP_AWAITING_REPORTED_BLOCKS);
                prog.endPhase(Phase.SAFEMODE);
            }
        }

        private boolean canInitializeReplicationQueues() throws IOException {
            return FSNamesystem.this.shouldPopulateReplicationQueues() && this.blockSafe() >= this.blockReplicationQueueThreshold();
        }

        private boolean canLeave() throws IOException {
            if (!FSNamesystem.this.isLeader()) {
                return false;
            }
            if (this.reached() == 0L) {
                return false;
            }
            if (Time.now() - this.reached() < (long)this.extension) {
                this.reportStatus("STATE* Safe mode ON, in safe mode extension.", false);
                return false;
            }
            if (this.needEnter()) {
                this.reportStatus("STATE* Safe mode ON, thresholds not met.", false);
                return false;
            }
            return true;
        }

        private void tryToHelpToGetOut() throws IOException {
            if (this.isManual() || this.areResourcesLow() || FSNamesystem.this.isLeader()) {
                return;
            }
            this.checkMode();
        }

        private void clusterLeftSafeModeAlready() throws IOException {
            this.leaveInternal();
        }

        private boolean needEnter() throws IOException {
            return this.threshold != 0.0 && this.blockSafe() < this.blockThreshold() || this.datanodeThreshold != 0 && FSNamesystem.this.getNumLiveDataNodes() < this.datanodeThreshold || !FSNamesystem.this.nameNodeHasResourcesAvailable();
        }

        private void checkMode() throws IOException {
            if (!FSNamesystem.this.isLeader() && this.reached() < 0L) {
                return;
            }
            if (FSNamesystem.this.smmthread == null && this.needEnter()) {
                this.enter();
                if (this.canInitializeReplicationQueues() && !FSNamesystem.this.isPopulatingReplQueues()) {
                    FSNamesystem.this.initializeReplQueues();
                }
                this.reportStatus("STATE* Safe mode ON.", false);
                return;
            }
            if (!this.isOn() || this.extension <= 0 || this.threshold <= 0.0) {
                this.leave();
                return;
            }
            if (this.reached() > 0L) {
                this.reportStatus("STATE* Safe mode ON.", false);
                return;
            }
            if (FSNamesystem.this.isLeader()) {
                HdfsVariables.setSafeModeReached(Time.now());
            }
            this.startSafeModeMonitor();
            this.reportStatus("STATE* Safe mode extension entered.", true);
            if (this.canInitializeReplicationQueues() && !FSNamesystem.this.isPopulatingReplQueues()) {
                FSNamesystem.this.initializeReplQueues();
            }
        }

        private synchronized void startSafeModeMonitor() throws IOException {
            if (FSNamesystem.this.smmthread == null) {
                FSNamesystem.this.smmthread = new Daemon((Runnable)new SafeModeMonitor());
                FSNamesystem.this.smmthread.start();
                this.reportStatus("STATE* Safe mode extension entered.", true);
            }
        }

        private synchronized void setBlockTotal(int total) throws IOException {
            int blockTotal = total;
            int blockThreshold = (int)((double)blockTotal * this.threshold);
            int blockReplicationQueueThreshold = (int)((double)blockTotal * this.replicationQueueThreshold);
            HdfsVariables.setBlockTotal(blockTotal, blockThreshold, blockReplicationQueueThreshold);
            this.checkMode();
        }

        private synchronized void updateBlockTotal(int deltaTotal) throws IOException {
            HdfsVariables.updateBlockTotal(deltaTotal, this.threshold, this.replicationQueueThreshold);
            this.setSafeModePendingOperation(true);
        }

        private void incrementSafeBlockCount(short replication, Block blk) throws IOException {
            if (replication == this.safeReplication) {
                FSNamesystem.this.addSafeBlock(blk.getBlockId());
                StartupProgress prog = NameNode.getStartupProgress();
                if (prog.getStatus(Phase.SAFEMODE) != Status.COMPLETE) {
                    if (this.awaitingReportedBlocksCounter == null) {
                        this.awaitingReportedBlocksCounter = prog.getCounter(Phase.SAFEMODE, STEP_AWAITING_REPORTED_BLOCKS);
                    }
                    this.awaitingReportedBlocksCounter.increment();
                }
                this.setSafeModePendingOperation(true);
            }
        }

        private void decrementSafeBlockCount(Block blk, short replication) throws IOException {
            if (replication == this.safeReplication - 1) {
                FSNamesystem.this.removeSafeBlock(blk.getBlockId());
                this.setSafeModePendingOperation(true);
            }
        }

        private boolean isManual() {
            return this.extension == Integer.MAX_VALUE;
        }

        private synchronized void setManual() {
            this.extension = Integer.MAX_VALUE;
        }

        private boolean areResourcesLow() {
            return this.resourcesLow;
        }

        private void setResourcesLow() {
            this.resourcesLow = true;
        }

        String getTurnOffTip() throws IOException {
            int blockTotal;
            int blockThreshold;
            int blockSafe;
            if (!this.isOn()) {
                return "Safe mode is OFF.";
            }
            String adminMsg = "It was turned on manually. ";
            if (this.areResourcesLow()) {
                adminMsg = "Resources are low on NN. Please add or free up more resources then turn off safe mode manually. NOTE:  If you turn off safe mode before adding resources, the NN will immediately return to safe mode. ";
            }
            if (this.isManual() || this.areResourcesLow()) {
                return adminMsg + "Use \"hdfs dfsadmin -safemode leave\" to turn safe mode off.";
            }
            boolean thresholdsMet = true;
            int numLive = FSNamesystem.this.getNumLiveDataNodes();
            String msg = "";
            try {
                blockSafe = this.blockSafe();
                blockThreshold = this.blockThreshold();
                blockTotal = this.blockTotal();
            }
            catch (IOException ex) {
                LOG.error((Object)ex);
                return "got exception " + ex.getMessage();
            }
            if (blockSafe < blockThreshold) {
                msg = msg + String.format("The reported blocks %d needs additional %d blocks to reach the threshold %.4f of total blocks %d.%n", blockSafe, blockThreshold - blockSafe + 1, this.threshold, blockTotal);
                thresholdsMet = false;
            } else {
                msg = msg + String.format("The reported blocks %d has reached the threshold %.4f of total blocks %d. ", blockSafe, this.threshold, blockTotal);
            }
            if (numLive < this.datanodeThreshold) {
                msg = msg + String.format("The number of live datanodes %d needs an additional %d live datanodes to reach the minimum number %d.%n", numLive, this.datanodeThreshold - numLive, this.datanodeThreshold);
                thresholdsMet = false;
            } else {
                msg = msg + String.format("The number of live datanodes %d has reached the minimum number %d. ", numLive, this.datanodeThreshold);
            }
            long reached = this.reached();
            msg = msg + (reached > 0L ? "In safe mode extension. " : "");
            msg = msg + "Safe mode will be turned off automatically ";
            msg = !thresholdsMet ? msg + "once the thresholds have been reached." : (reached + (long)this.extension - Time.now() > 0L ? msg + "in " + (reached + (long)this.extension - Time.now()) / 1000L + " seconds." : msg + "soon.");
            return msg;
        }

        private void reportStatus(String msg, boolean rightNow) throws IOException {
            long curTime = Time.now();
            if (!rightNow && curTime - this.lastStatusReport < 20000L) {
                return;
            }
            NameNode.stateChangeLog.error((Object)(msg + " \n" + this.getTurnOffTip()));
            this.lastStatusReport = curTime;
        }

        public String toString() {
            String blockSafe;
            long blockThreshold = -1L;
            long reached = -1L;
            try {
                blockSafe = "" + this.blockSafe();
                blockThreshold = this.blockThreshold();
                reached = this.reached();
            }
            catch (IOException ex) {
                blockSafe = ex.getMessage();
            }
            String resText = "Current safe blocks = " + blockSafe + ". Target blocks = " + blockThreshold + " for threshold = %" + this.threshold + ". Minimal replication = " + this.safeReplication + ".";
            if (reached > 0L) {
                resText = resText + " Threshold was reached " + new Date(reached) + ".";
            }
            return resText;
        }

        private void doConsistencyCheck() throws IOException {
            boolean assertsOn = false;
            if (!$assertionsDisabled) {
                assertsOn = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            if (!assertsOn) {
                return;
            }
            long blockTotal = this.blockTotal();
            if (blockTotal == -1L) {
                return;
            }
            long blockSafe = this.blockSafe();
            int activeBlocks = FSNamesystem.this.blockManager.getActiveBlockCount();
            if (blockTotal != (long)activeBlocks && (blockSafe < 0L || blockSafe > blockTotal)) {
                throw new AssertionError((Object)(" SafeMode: Inconsistent filesystem state: SafeMode data: blockTotal=" + blockTotal + " blockSafe=" + blockSafe + "; BlockManager data: active=" + activeBlocks));
            }
        }

        private void adjustBlockTotals(List<Block> deltaSafe, int deltaTotal) throws IOException {
            int oldBlockSafe = 0;
            if (LOG.isDebugEnabled()) {
                oldBlockSafe = this.blockSafe();
            }
            if (deltaSafe != null) {
                for (Block b : deltaSafe) {
                    FSNamesystem.this.removeSafeBlock(b.getBlockId());
                }
            }
            if (LOG.isDebugEnabled()) {
                int newBlockSafe = this.blockSafe();
                long blockTotal = this.blockTotal();
                LOG.debug((Object)("Adjusting block totals from " + oldBlockSafe + "/" + blockTotal + " to " + newBlockSafe + "/" + (blockTotal + (long)deltaTotal)));
            }
            this.updateBlockTotal(deltaTotal);
        }

        private void setSafeModePendingOperation(Boolean val) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"SafeModeX Some operation are put on hold");
            }
            this.safeModePendingOperation.set(val);
        }

        private void adjustSafeBlocks(Set<Long> safeBlocks) throws IOException {
            StartupProgress prog;
            int lastSafeBlockSize = this.blockSafe();
            FSNamesystem.this.addSafeBlocks(safeBlocks);
            int newSafeBlockSize = this.blockSafe();
            if (LOG.isDebugEnabled()) {
                long blockTotal = this.blockTotal();
                LOG.debug((Object)("Adjusting safe blocks from " + lastSafeBlockSize + "/" + blockTotal + " to " + newSafeBlockSize + "/" + blockTotal));
            }
            if ((prog = NameNode.getStartupProgress()).getStatus(Phase.SAFEMODE) != Status.COMPLETE) {
                if (this.awaitingReportedBlocksCounter == null) {
                    this.awaitingReportedBlocksCounter = prog.getCounter(Phase.SAFEMODE, STEP_AWAITING_REPORTED_BLOCKS);
                }
                this.awaitingReportedBlocksCounter.add(newSafeBlockSize - lastSafeBlockSize);
            }
            this.setSafeModePendingOperation(true);
            this.checkMode();
        }

        private void performSafeModePendingOperation() throws IOException {
            if (this.safeModePendingOperation.get() != null && this.safeModePendingOperation.get().booleanValue()) {
                LOG.debug((Object)"SafeMode about to perform pending safe mode operation");
                this.safeModePendingOperation.set(false);
                this.checkMode();
            }
        }

        int blockSafe() throws IOException {
            return FSNamesystem.this.getBlockSafe();
        }

        int blockTotal() throws IOException {
            return HdfsVariables.getBlockTotal();
        }

        int blockReplicationQueueThreshold() throws IOException {
            return HdfsVariables.getBlockReplicationQueueThreshold();
        }

        int blockThreshold() throws IOException {
            return HdfsVariables.getBlockThreshold();
        }
    }

    class NameNodeResourceMonitor
    implements Runnable {
        boolean shouldNNRmRun = true;

        NameNodeResourceMonitor() {
        }

        @Override
        public void run() {
            try {
                while (FSNamesystem.this.fsRunning && this.shouldNNRmRun) {
                    if (FSNamesystem.this.isLeader() && !FSNamesystem.this.nameNodeHasResourcesAvailable()) {
                        String lowResourcesMsg = "NameNode low on available disk space. ";
                        if (!FSNamesystem.this.isInSafeMode()) {
                            LOG.warn((Object)(lowResourcesMsg + "Entering safe mode."));
                        } else {
                            LOG.warn((Object)(lowResourcesMsg + "Already in safe mode."));
                        }
                        FSNamesystem.this.enterSafeMode(true);
                    }
                    try {
                        Thread.sleep(FSNamesystem.this.resourceRecheckInterval);
                    }
                    catch (InterruptedException lowResourcesMsg) {}
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Exception in NameNodeResourceMonitor: ", (Throwable)e);
            }
        }

        public void stopMonitor() {
            this.shouldNNRmRun = false;
        }
    }
}

