/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.entity.INodeIdentifier;
import io.hops.metadata.hdfs.entity.MetadataLogEntry;
import io.hops.transaction.EntityManager;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.fs.PathIsNotDirectoryException;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.server.namenode.Content;
import org.apache.hadoop.hdfs.server.namenode.ContentSummaryComputationContext;
import org.apache.hadoop.hdfs.server.namenode.DirectoryWithQuotaFeature;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeWithAdditionalFields;
import org.apache.hadoop.hdfs.server.namenode.Quota;

public class INodeDirectory
extends INodeWithAdditionalFields {
    protected static final int DEFAULT_FILES_PER_DIRECTORY = 5;
    public static final String ROOT_NAME = "";
    public static final long ROOT_DIR_PARTITION_KEY = 0L;
    public static final short ROOT_DIR_DEPTH = 0;
    private boolean metaEnabled;
    private int childrenNum;
    static final String DUMPTREE_EXCEPT_LAST_ITEM = "+-";
    static final String DUMPTREE_LAST_ITEM = "\\-";

    public static INodeDirectory valueOf(INode inode, Object path) throws FileNotFoundException, PathIsNotDirectoryException {
        if (inode == null) {
            throw new FileNotFoundException("Directory does not exist: " + DFSUtil.path2String(path));
        }
        if (!inode.isDirectory()) {
            throw new PathIsNotDirectoryException(DFSUtil.path2String(path));
        }
        return (INodeDirectory)inode;
    }

    public INodeDirectory(long id, String name, PermissionStatus permissions) throws IOException {
        super(id, name, permissions);
    }

    public INodeDirectory(long id, String name, PermissionStatus permissions, boolean inTree) throws IOException {
        super(id, name, permissions, inTree);
    }

    public INodeDirectory(long id, PermissionStatus permissions, long mTime) throws IOException {
        super(id, permissions, mTime, 0L);
    }

    INodeDirectory(long id, byte[] name, PermissionStatus permissions, long mtime) throws IOException {
        super(id, name, permissions, mtime, 0L, false);
    }

    INodeDirectory(INodeDirectory other) throws IOException {
        this(other, true);
    }

    INodeDirectory(INodeDirectory other, boolean copyFeatures) throws IOException {
        super(other);
        if (copyFeatures) {
            this.features = other.features;
        }
    }

    @Override
    public final boolean isDirectory() {
        return true;
    }

    public static INodeDirectory createRootDir(PermissionStatus permissions) throws IOException {
        INodeDirectory newRootINode = new INodeDirectory(1L, ROOT_NAME, permissions);
        newRootINode.inTree();
        newRootINode.setParentIdNoPersistance(0L);
        newRootINode.setPartitionIdNoPersistance(INodeDirectory.getRootDirPartitionKey());
        return newRootINode;
    }

    public static INodeDirectory getRootDir() throws StorageException, TransactionContextException {
        INode inode = (INode)EntityManager.find((FinderType)INode.Finder.ByINodeIdFTIS, (Object[])new Object[]{1L});
        return (INodeDirectory)inode;
    }

    void setQuota(long nsQuota, long nsCount, long dsQuota, long dsCount) throws StorageException, TransactionContextException {
        DirectoryWithQuotaFeature quota = this.getDirectoryWithQuotaFeature();
        if (quota != null) {
            quota.setQuota(this, nsQuota, dsQuota);
        } else {
            this.addDirectoryWithQuotaFeature(nsQuota, nsCount, dsQuota, dsCount);
        }
    }

    @Override
    public Quota.Counts getQuotaCounts() throws StorageException, TransactionContextException {
        DirectoryWithQuotaFeature q = this.getDirectoryWithQuotaFeature();
        return q != null ? q.getQuota(this) : super.getQuotaCounts();
    }

    @Override
    public void addSpaceConsumed(long nsDelta, long dsDelta) throws StorageException, TransactionContextException {
        DirectoryWithQuotaFeature q = this.getDirectoryWithQuotaFeature();
        if (q != null) {
            q.addSpaceConsumed(this, nsDelta, dsDelta);
        } else {
            this.parent.addSpaceConsumed2Parent(nsDelta, dsDelta);
        }
    }

    public final DirectoryWithQuotaFeature getDirectoryWithQuotaFeature() {
        for (INode.Feature f : this.features) {
            if (!(f instanceof DirectoryWithQuotaFeature)) continue;
            return (DirectoryWithQuotaFeature)f;
        }
        return null;
    }

    public final boolean isWithQuota() {
        return this.getDirectoryWithQuotaFeature() != null;
    }

    DirectoryWithQuotaFeature addDirectoryWithQuotaFeature(long nsQuota, long nsCount, long dsQuota, long dsCount) throws StorageException, TransactionContextException {
        Preconditions.checkState((!this.isWithQuota() ? 1 : 0) != 0, (Object)"Directory is already with quota");
        DirectoryWithQuotaFeature quota = new DirectoryWithQuotaFeature(this, nsQuota, nsCount, dsQuota, dsCount);
        this.addFeature(quota);
        return quota;
    }

    @Override
    public final INodeDirectory asDirectory() {
        return this;
    }

    public boolean isMetaEnabled() {
        return this.metaEnabled;
    }

    public void setMetaEnabled(boolean metaEnabled) {
        this.metaEnabled = metaEnabled;
    }

    INode removeChild(INode node) throws StorageException, TransactionContextException {
        INode existingInode = this.getChildINode(node.getLocalNameBytes());
        if (existingInode != null) {
            this.remove(existingInode);
            return existingInode;
        }
        return null;
    }

    void replaceChild(INode newChild) throws StorageException, TransactionContextException {
        INode existingINode = this.getChildINode(newChild.getLocalNameBytes());
        if (existingINode == null) {
            throw new IllegalArgumentException("No child exists to be replaced");
        }
        if (existingINode.getParentId() != newChild.getParentId()) {
            throw new IllegalArgumentException("Invalid parentid");
        }
        short depth = this.myDepth();
        long childPartitionKey = INode.calculatePartitionId(this.getId(), newChild.getLocalName(), (short)(this.myDepth() + 1));
        newChild.setPartitionId(childPartitionKey);
        EntityManager.update((Object)newChild);
    }

    INode getChild(String name) throws StorageException, TransactionContextException {
        return this.getChildINode(DFSUtil.string2Bytes(name));
    }

    public INode getChildINode(byte[] name) throws StorageException, TransactionContextException {
        short myDepth = this.myDepth();
        long childPartitionId = INode.calculatePartitionId(this.getId(), DFSUtil.bytes2String(name), (short)(myDepth + 1));
        INode existingInode = (INode)EntityManager.find((FinderType)INode.Finder.ByNameParentIdAndPartitionId, (Object[])new Object[]{DFSUtil.bytes2String(name), this.getId(), childPartitionId});
        if (existingInode != null && existingInode.isInTree()) {
            return existingInode;
        }
        return null;
    }

    int nextChild(List<INode> children, byte[] name) throws StorageException, TransactionContextException {
        if (name.length == 0) {
            return 0;
        }
        int nextPos = Collections.binarySearch(children, name) + 1;
        if (nextPos >= 0) {
            return nextPos;
        }
        return -nextPos;
    }

    boolean addChild(INode node, boolean setModTime) throws IOException {
        return this.addChild(node, setModTime, true);
    }

    boolean addChild(INode node, boolean setModTime, boolean logMetadataEvent) throws IOException {
        INode existingInode = this.getChildINode(node.getLocalNameBytes());
        if (existingInode != null) {
            return false;
        }
        if (!node.isInTree()) {
            node.inTree();
            node.setParentNoPersistance(this);
            short childDepth = (short)(this.myDepth() + 1);
            node.setPartitionIdNoPersistance(INode.calculatePartitionId(node.getParentId(), node.getLocalName(), childDepth));
            EntityManager.add((Object)node);
        } else {
            node.setParent(this);
        }
        if (setModTime) {
            this.setModificationTime(node.getModificationTime());
        }
        this.increaseChildrenNum();
        if (node.getGroupName() == null) {
            node.setGroup(this.getGroupName());
        }
        if (logMetadataEvent) {
            node.logMetadataEvent(MetadataLogEntry.Operation.ADD);
        }
        return true;
    }

    @Override
    INode.DirCounts spaceConsumedInTree(INode.DirCounts counts) throws StorageException, TransactionContextException {
        if (this.isWithQuota()) {
            DirectoryWithQuotaFeature q = this.getDirectoryWithQuotaFeature();
            if (q != null) {
                q.spaceConsumedInTree(this, counts);
            }
        } else {
            List<INode> children;
            ++counts.nsCount;
            if (this.isInTree() && (children = this.getChildren()) != null) {
                for (INode child : children) {
                    child.spaceConsumedInTree(counts);
                }
            }
        }
        return counts;
    }

    @Override
    ContentSummaryComputationContext computeContentSummary(ContentSummaryComputationContext summary) throws StorageException, TransactionContextException {
        DirectoryWithQuotaFeature q = this.getDirectoryWithQuotaFeature();
        if (q != null) {
            return q.computeContentSummary(this, summary);
        }
        return this.computeDirectoryContentSummary(summary);
    }

    ContentSummaryComputationContext computeDirectoryContentSummary(ContentSummaryComputationContext summary) throws StorageException, TransactionContextException {
        List<INode> childrenList = this.getChildrenList();
        for (int i = 0; i < childrenList.size(); ++i) {
            INode child = childrenList.get(i);
            byte[] childName = child.getLocalNameBytes();
            long lastYieldCount = summary.getYieldCount();
            child.computeContentSummary(summary);
            if (lastYieldCount == summary.getYieldCount()) continue;
            if (this.getParent() == null) break;
            childrenList = this.getChildrenList();
            i = this.nextChild(childrenList, childName) - 1;
        }
        summary.getCounts().add(Content.DIRECTORY, 1L);
        summary.yield();
        return summary;
    }

    public List<INode> getChildrenList() throws StorageException, TransactionContextException {
        List<INode> children = this.getChildren();
        return children == null ? EMPTY_LIST : children;
    }

    private List<INode> getChildren() throws StorageException, TransactionContextException {
        if (!this.isInTree()) {
            return null;
        }
        short childrenDepth = (short)(this.myDepth() + 1);
        if (INode.isTreeLevelRandomPartitioned(childrenDepth)) {
            return (List)EntityManager.findList((FinderType)INode.Finder.ByParentIdFTIS, (Object[])new Object[]{this.getId()});
        }
        return (List)EntityManager.findList((FinderType)INode.Finder.ByParentIdAndPartitionId, (Object[])new Object[]{this.getId(), this.getId()});
    }

    @Override
    int collectSubtreeBlocksAndClear(INode.BlocksMapUpdateInfo info) throws StorageException, TransactionContextException {
        int total = 1;
        List<INode> children = this.getChildren();
        if (children == null) {
            return total;
        }
        for (INode child : children) {
            total += child.collectSubtreeBlocksAndClear(info);
        }
        this.parent = null;
        for (INode child : children) {
            this.remove(child);
        }
        this.remove(this);
        return total;
    }

    public static long getRootDirPartitionKey() {
        return INode.calculatePartitionId(0L, ROOT_NAME, (short)0);
    }

    public static INodeIdentifier getRootIdentifier() {
        INodeIdentifier rootINodeIdentifier = new INodeIdentifier(Long.valueOf(1L), Long.valueOf(0L), ROOT_NAME, Long.valueOf(INodeDirectory.getRootDirPartitionKey()));
        rootINodeIdentifier.setDepth(Short.valueOf((short)0));
        return rootINodeIdentifier;
    }

    @Override
    @VisibleForTesting
    public void dumpTreeRecursively(PrintWriter out, StringBuilder prefix) throws StorageException, TransactionContextException {
        super.dumpTreeRecursively(out, prefix);
        if (prefix.length() >= 2) {
            prefix.setLength(prefix.length() - 2);
            prefix.append("  ");
        }
        INodeDirectory.dumpTreeRecursively(out, prefix, this.getChildren());
    }

    @VisibleForTesting
    protected static void dumpTreeRecursively(PrintWriter out, StringBuilder prefix, List<? extends INode> subs) throws StorageException, TransactionContextException {
        prefix.append(DUMPTREE_EXCEPT_LAST_ITEM);
        if (subs != null && subs.size() != 0) {
            int i;
            for (i = 0; i < subs.size() - 1; ++i) {
                subs.get(i).dumpTreeRecursively(out, prefix);
                prefix.setLength(prefix.length() - 2);
                prefix.append(DUMPTREE_EXCEPT_LAST_ITEM);
            }
            prefix.setLength(prefix.length() - 2);
            prefix.append(DUMPTREE_LAST_ITEM);
            subs.get(i).dumpTreeRecursively(out, prefix);
        }
        prefix.setLength(prefix.length() - 2);
    }

    @Override
    public INode cloneInode() throws IOException {
        return new INodeDirectory(this, true);
    }

    public int getChildrenNum() {
        return this.childrenNum;
    }

    public void setChildrenNum(int childrenNum) {
        this.childrenNum = childrenNum;
    }

    public void decreaseChildrenNum() throws StorageException, TransactionContextException {
        --this.childrenNum;
        this.save();
    }

    public void increaseChildrenNum() throws StorageException, TransactionContextException {
        ++this.childrenNum;
        this.save();
    }
}

