/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSClientFaultInjector;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestCrcCorruption {
    private DFSClientFaultInjector faultInjector;

    @Before
    public void setUp() throws IOException {
        DFSClientFaultInjector.instance = this.faultInjector = (DFSClientFaultInjector)Mockito.mock(DFSClientFaultInjector.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=50000L)
    public void testCorruptionDuringWrt() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        try {
            int c;
            int i;
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(10).build();
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            Path file = new Path("/test_corruption_file");
            FSDataOutputStream out = fs.create(file, true, 8192, (short)3, 0x8000000L);
            byte[] data = new byte[65536];
            for (i = 0; i < 65536; ++i) {
                data[i] = (byte)(i % 256);
            }
            for (i = 0; i < 5; ++i) {
                out.write(data, 0, 65535);
            }
            out.hflush();
            Mockito.when((Object)this.faultInjector.corruptPacket()).thenReturn((Object)true, (Object[])new Boolean[]{false});
            Mockito.when((Object)this.faultInjector.uncorruptPacket()).thenReturn((Object)true, (Object[])new Boolean[]{false});
            for (i = 0; i < 5; ++i) {
                out.write(data, 0, 65535);
            }
            out.close();
            FSDataInputStream in = fs.open(file);
            while ((c = in.read()) != -1) {
            }
            in.close();
            out = fs.create(file, true, 8192, (short)3, 0x8000000L);
            Mockito.when((Object)this.faultInjector.corruptPacket()).thenReturn((Object)true, (Object[])new Boolean[]{false});
            Mockito.when((Object)this.faultInjector.uncorruptPacket()).thenReturn((Object)false);
            try {
                for (int i2 = 0; i2 < 5; ++i2) {
                    out.write(data, 0, 65535);
                }
                out.close();
                Assert.fail((String)"Write did not fail");
            }
            catch (IOException ioe) {
                DFSClient.LOG.info((Object)"Got expected exception", (Throwable)ioe);
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
            Mockito.when((Object)this.faultInjector.corruptPacket()).thenReturn((Object)false);
            Mockito.when((Object)this.faultInjector.uncorruptPacket()).thenReturn((Object)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void thistest(Configuration conf, DFSTestUtil util) throws Exception {
        MiniDFSCluster cluster = null;
        int numDataNodes = 2;
        short replFactor = 2;
        Random random = new Random();
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(numDataNodes).build();
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            util.createFiles((FileSystem)fs, "/srcdat", replFactor);
            util.waitReplication((FileSystem)fs, "/srcdat", (short)2);
            File storageDir = cluster.getInstanceStorageDir(0, 1);
            String bpid = cluster.getNamesystem().getBlockPoolId();
            File data_dir = MiniDFSCluster.getFinalizedDir(storageDir, bpid);
            Assert.assertTrue((String)"data directory does not exist", (boolean)data_dir.exists());
            File[] blocks = data_dir.listFiles();
            Assert.assertTrue((String)"Blocks do not exist in data-dir", (blocks != null && blocks.length > 0 ? 1 : 0) != 0);
            int num = 0;
            for (File block1 : blocks) {
                FileChannel channel;
                RandomAccessFile file;
                if (!block1.getName().startsWith("blk_") || !block1.getName().endsWith(".meta")) continue;
                if (++num % 3 == 0) {
                    System.out.println("Deliberately removing file " + block1.getName());
                    Assert.assertTrue((String)"Cannot remove file.", (boolean)block1.delete());
                    continue;
                }
                if (num % 3 == 1) {
                    file = new RandomAccessFile(block1, "rw");
                    channel = file.getChannel();
                    int newsize = random.nextInt((int)channel.size() / 2);
                    System.out.println("Deliberately truncating file " + block1.getName() + " to size " + newsize + " bytes.");
                    channel.truncate(newsize);
                    file.close();
                    continue;
                }
                file = new RandomAccessFile(block1, "rw");
                channel = file.getChannel();
                long position = 0L;
                if (num != 2) {
                    position = random.nextInt((int)channel.size());
                }
                int length = random.nextInt((int)(channel.size() - position + 1L));
                byte[] buffer = new byte[length];
                random.nextBytes(buffer);
                channel.write(ByteBuffer.wrap(buffer), position);
                System.out.println("Deliberately corrupting file " + block1.getName() + " at offset " + position + " length " + length);
                file.close();
            }
            storageDir = cluster.getInstanceStorageDir(0, 1);
            data_dir = MiniDFSCluster.getFinalizedDir(storageDir, bpid);
            Assert.assertTrue((String)"data directory does not exist", (boolean)data_dir.exists());
            blocks = data_dir.listFiles();
            Assert.assertTrue((String)"Blocks do not exist in data-dir", (blocks != null && blocks.length > 0 ? 1 : 0) != 0);
            int count = 0;
            File previous = null;
            for (File block : blocks) {
                if (!block.getName().startsWith("blk_") || !block.getName().endsWith(".meta")) continue;
                if (++count % 2 == 0) {
                    System.out.println("Deliberately insertimg bad crc into files " + block.getName() + " " + previous.getName());
                    Assert.assertTrue((String)"Cannot remove file.", (boolean)block.delete());
                    Assert.assertTrue((String)"Cannot corrupt meta file.", (boolean)previous.renameTo(block));
                    Assert.assertTrue((String)"Cannot recreate empty meta file.", (boolean)previous.createNewFile());
                    previous = null;
                    continue;
                }
                previous = block;
            }
            Assert.assertTrue((String)"Corrupted replicas not handled properly.", (boolean)util.checkFiles((FileSystem)fs, "/srcdat"));
            System.out.println("All File still have a valid replica");
            util.setReplication((FileSystem)fs, "/srcdat", (short)1);
            System.out.println("The excess-corrupted-replica test is disabled  pending HADOOP-1557");
            util.cleanup((FileSystem)fs, "/srcdat");
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testCrcCorruption() throws Exception {
        System.out.println("TestCrcCorruption with default parameters");
        HdfsConfiguration conf1 = new HdfsConfiguration();
        conf1.setInt("dfs.blockreport.intervalMsec", 3000);
        DFSTestUtil util1 = new DFSTestUtil.Builder().setName("TestCrcCorruption").setNumFiles(40).build();
        this.thistest((Configuration)conf1, util1);
        System.out.println("TestCrcCorruption with specific parameters");
        HdfsConfiguration conf2 = new HdfsConfiguration();
        conf2.setInt("dfs.bytes-per-checksum", 17);
        conf2.setInt("dfs.blocksize", 34);
        DFSTestUtil util2 = new DFSTestUtil.Builder().setName("TestCrcCorruption").setNumFiles(40).setMaxSize(400).build();
        this.thistest((Configuration)conf2, util2);
    }

    @Test(timeout=300000L)
    public void testEntirelyCorruptFileOneNode() throws Exception {
        this.doTestEntirelyCorruptFile(1);
    }

    @Test(timeout=300000L)
    public void testEntirelyCorruptFileThreeNodes() throws Exception {
        this.doTestEntirelyCorruptFile(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestEntirelyCorruptFile(int numDataNodes) throws Exception {
        long fileSize = 4096L;
        Path file = new Path("/testFile");
        short replFactor = (short)numDataNodes;
        Configuration conf = new Configuration();
        conf.setInt("dfs.replication", numDataNodes);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(numDataNodes).build();
        try {
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)fs, file, fileSize, replFactor, 12345L);
            DFSTestUtil.waitReplication((FileSystem)fs, file, replFactor);
            ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)fs, file);
            int blockFilesCorrupted = cluster.corruptBlockOnDataNodes(block);
            Assert.assertEquals((String)"All replicas not corrupted", (long)replFactor, (long)blockFilesCorrupted);
            try {
                IOUtils.copyBytes((InputStream)fs.open(file), (OutputStream)new IOUtils.NullOutputStream(), (Configuration)conf, (boolean)true);
                Assert.fail((String)"Didn't get exception");
            }
            catch (IOException ioe) {
                DFSClient.LOG.info((Object)"Got expected exception", (Throwable)ioe);
            }
        }
        finally {
            cluster.shutdown();
        }
    }
}

