/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSClientAdapter;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenSecretManager;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestEncryptedTransfer {
    private static final Log LOG = LogFactory.getLog(TestEncryptedTransfer.class);
    private static final String PLAIN_TEXT = "this is very secret plain text";
    private static final Path TEST_PATH = new Path("/non-encrypted-file");

    private static void setEncryptionConfigKeys(Configuration conf) {
        conf.setBoolean("dfs.encrypt.data.transfer", true);
        conf.setBoolean("dfs.block.access.token.enable", true);
    }

    private static FileSystem getFileSystem(Configuration conf) throws IOException {
        Configuration localConf = new Configuration(conf);
        localConf.setBoolean("dfs.encrypt.data.transfer", false);
        localConf.unset("dfs.encrypt.data.transfer.algorithm");
        return FileSystem.get((Configuration)localConf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEncryptedRead() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            Configuration conf = new Configuration();
            cluster = new MiniDFSCluster.Builder(conf).build();
            FileSystem fs = TestEncryptedTransfer.getFileSystem(conf);
            TestEncryptedTransfer.writeTestDataToFile(fs);
            Assert.assertEquals((Object)PLAIN_TEXT, (Object)DFSTestUtil.readFile(fs, TEST_PATH));
            FileChecksum checksum = fs.getFileChecksum(TEST_PATH);
            fs.close();
            cluster.shutdown();
            TestEncryptedTransfer.setEncryptionConfigKeys(conf);
            cluster = new MiniDFSCluster.Builder(conf).manageDataDfsDirs(false).manageNameDfsDirs(false).format(false).startupOption(HdfsServerConstants.StartupOption.REGULAR).build();
            fs = TestEncryptedTransfer.getFileSystem(conf);
            Assert.assertEquals((Object)PLAIN_TEXT, (Object)DFSTestUtil.readFile(fs, TEST_PATH));
            Assert.assertEquals((Object)checksum, (Object)fs.getFileChecksum(TEST_PATH));
            fs.close();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEncryptedReadWithRC4() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            Configuration conf = new Configuration();
            cluster = new MiniDFSCluster.Builder(conf).build();
            FileSystem fs = TestEncryptedTransfer.getFileSystem(conf);
            TestEncryptedTransfer.writeTestDataToFile(fs);
            Assert.assertEquals((Object)PLAIN_TEXT, (Object)DFSTestUtil.readFile(fs, TEST_PATH));
            FileChecksum checksum = fs.getFileChecksum(TEST_PATH);
            fs.close();
            cluster.shutdown();
            TestEncryptedTransfer.setEncryptionConfigKeys(conf);
            conf.set("dfs.encrypt.data.transfer.algorithm", "rc4");
            cluster = new MiniDFSCluster.Builder(conf).manageDataDfsDirs(false).manageNameDfsDirs(false).format(false).startupOption(HdfsServerConstants.StartupOption.REGULAR).build();
            fs = TestEncryptedTransfer.getFileSystem(conf);
            Assert.assertEquals((Object)PLAIN_TEXT, (Object)DFSTestUtil.readFile(fs, TEST_PATH));
            Assert.assertEquals((Object)checksum, (Object)fs.getFileChecksum(TEST_PATH));
            fs.close();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEncryptedReadAfterNameNodeRestart() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            Configuration conf = new Configuration();
            cluster = new MiniDFSCluster.Builder(conf).build();
            FileSystem fs = TestEncryptedTransfer.getFileSystem(conf);
            TestEncryptedTransfer.writeTestDataToFile(fs);
            Assert.assertEquals((Object)PLAIN_TEXT, (Object)DFSTestUtil.readFile(fs, TEST_PATH));
            FileChecksum checksum = fs.getFileChecksum(TEST_PATH);
            fs.close();
            cluster.shutdown();
            TestEncryptedTransfer.setEncryptionConfigKeys(conf);
            cluster = new MiniDFSCluster.Builder(conf).manageDataDfsDirs(false).manageNameDfsDirs(false).format(false).startupOption(HdfsServerConstants.StartupOption.REGULAR).build();
            fs = TestEncryptedTransfer.getFileSystem(conf);
            Assert.assertEquals((Object)PLAIN_TEXT, (Object)DFSTestUtil.readFile(fs, TEST_PATH));
            Assert.assertEquals((Object)checksum, (Object)fs.getFileChecksum(TEST_PATH));
            fs.close();
            cluster.restartNameNode(new String[0]);
            fs = TestEncryptedTransfer.getFileSystem(conf);
            Assert.assertEquals((Object)PLAIN_TEXT, (Object)DFSTestUtil.readFile(fs, TEST_PATH));
            Assert.assertEquals((Object)checksum, (Object)fs.getFileChecksum(TEST_PATH));
            fs.close();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientThatDoesNotSupportEncryption() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            Configuration conf = new Configuration();
            cluster = new MiniDFSCluster.Builder(conf).build();
            FileSystem fs = TestEncryptedTransfer.getFileSystem(conf);
            TestEncryptedTransfer.writeTestDataToFile(fs);
            Assert.assertEquals((Object)PLAIN_TEXT, (Object)DFSTestUtil.readFile(fs, TEST_PATH));
            fs.close();
            cluster.shutdown();
            TestEncryptedTransfer.setEncryptionConfigKeys(conf);
            cluster = new MiniDFSCluster.Builder(conf).manageDataDfsDirs(false).manageNameDfsDirs(false).format(false).startupOption(HdfsServerConstants.StartupOption.REGULAR).build();
            fs = TestEncryptedTransfer.getFileSystem(conf);
            DFSClient client = DFSClientAdapter.getDFSClient((DistributedFileSystem)fs);
            DFSClient spyClient = (DFSClient)Mockito.spy((Object)client);
            ((DFSClient)Mockito.doReturn((Object)false).when((Object)spyClient)).shouldEncryptData();
            DFSClientAdapter.setDFSClient((DistributedFileSystem)fs, spyClient);
            GenericTestUtils.LogCapturer logs = GenericTestUtils.LogCapturer.captureLogs((Log)LogFactory.getLog(DataNode.class));
            try {
                Assert.assertEquals((Object)PLAIN_TEXT, (Object)DFSTestUtil.readFile(fs, TEST_PATH));
                Assert.fail((String)"Should not have been able to read without encryption enabled.");
            }
            catch (IOException ioe) {
                GenericTestUtils.assertExceptionContains((String)"Could not obtain block:", (Throwable)ioe);
            }
            finally {
                logs.stopCapturing();
            }
            fs.close();
            GenericTestUtils.assertMatches((String)logs.getOutput(), (String)"Failed to read expected encryption handshake from client at");
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLongLivedReadClientAfterRestart() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            Configuration conf = new Configuration();
            cluster = new MiniDFSCluster.Builder(conf).build();
            FileSystem fs = TestEncryptedTransfer.getFileSystem(conf);
            TestEncryptedTransfer.writeTestDataToFile(fs);
            Assert.assertEquals((Object)PLAIN_TEXT, (Object)DFSTestUtil.readFile(fs, TEST_PATH));
            FileChecksum checksum = fs.getFileChecksum(TEST_PATH);
            fs.close();
            cluster.shutdown();
            TestEncryptedTransfer.setEncryptionConfigKeys(conf);
            cluster = new MiniDFSCluster.Builder(conf).manageDataDfsDirs(false).manageNameDfsDirs(false).format(false).startupOption(HdfsServerConstants.StartupOption.REGULAR).build();
            fs = TestEncryptedTransfer.getFileSystem(conf);
            Assert.assertEquals((Object)PLAIN_TEXT, (Object)DFSTestUtil.readFile(fs, TEST_PATH));
            Assert.assertEquals((Object)checksum, (Object)fs.getFileChecksum(TEST_PATH));
            cluster.restartNameNode(new String[0]);
            Assert.assertTrue((boolean)cluster.restartDataNode(0));
            Assert.assertEquals((Object)PLAIN_TEXT, (Object)DFSTestUtil.readFile(fs, TEST_PATH));
            Assert.assertEquals((Object)checksum, (Object)fs.getFileChecksum(TEST_PATH));
            fs.close();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLongLivedWriteClientAfterRestart() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            Configuration conf = new Configuration();
            TestEncryptedTransfer.setEncryptionConfigKeys(conf);
            cluster = new MiniDFSCluster.Builder(conf).build();
            FileSystem fs = TestEncryptedTransfer.getFileSystem(conf);
            TestEncryptedTransfer.writeTestDataToFile(fs);
            Assert.assertEquals((Object)PLAIN_TEXT, (Object)DFSTestUtil.readFile(fs, TEST_PATH));
            cluster.restartNameNode(new String[0]);
            Assert.assertTrue((boolean)cluster.restartDataNodes());
            cluster.waitActive();
            TestEncryptedTransfer.writeTestDataToFile(fs);
            Assert.assertEquals((Object)"this is very secret plain textthis is very secret plain text", (Object)DFSTestUtil.readFile(fs, TEST_PATH));
            fs.close();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLongLivedClient() throws IOException, InterruptedException {
        MiniDFSCluster cluster = null;
        try {
            Configuration conf = new Configuration();
            cluster = new MiniDFSCluster.Builder(conf).build();
            FileSystem fs = TestEncryptedTransfer.getFileSystem(conf);
            TestEncryptedTransfer.writeTestDataToFile(fs);
            Assert.assertEquals((Object)PLAIN_TEXT, (Object)DFSTestUtil.readFile(fs, TEST_PATH));
            FileChecksum checksum = fs.getFileChecksum(TEST_PATH);
            fs.close();
            cluster.shutdown();
            TestEncryptedTransfer.setEncryptionConfigKeys(conf);
            cluster = new MiniDFSCluster.Builder(conf).manageDataDfsDirs(false).manageNameDfsDirs(false).format(false).startupOption(HdfsServerConstants.StartupOption.REGULAR).build();
            BlockTokenSecretManager btsm = cluster.getNamesystem().getBlockManager().getBlockTokenSecretManager();
            btsm.setKeyUpdateIntervalForTesting(2000L);
            btsm.setTokenLifetime(2000L);
            btsm.clearAllKeysForTesting();
            fs = TestEncryptedTransfer.getFileSystem(conf);
            Assert.assertEquals((Object)PLAIN_TEXT, (Object)DFSTestUtil.readFile(fs, TEST_PATH));
            Assert.assertEquals((Object)checksum, (Object)fs.getFileChecksum(TEST_PATH));
            LOG.info((Object)"Sleeping so that encryption keys expire...");
            Thread.sleep(15000L);
            LOG.info((Object)"Done sleeping.");
            Assert.assertEquals((Object)PLAIN_TEXT, (Object)DFSTestUtil.readFile(fs, TEST_PATH));
            Assert.assertEquals((Object)checksum, (Object)fs.getFileChecksum(TEST_PATH));
            fs.close();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testEncryptedWriteWithOneDn() throws IOException {
        this.testEncryptedWrite(1);
    }

    @Test
    public void testEncryptedWriteWithTwoDns() throws IOException {
        this.testEncryptedWrite(2);
    }

    @Test
    public void testEncryptedWriteWithMultipleDns() throws IOException {
        this.testEncryptedWrite(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testEncryptedWrite(int numDns) throws IOException {
        MiniDFSCluster cluster = null;
        try {
            Configuration conf = new Configuration();
            TestEncryptedTransfer.setEncryptionConfigKeys(conf);
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(numDns).build();
            FileSystem fs = TestEncryptedTransfer.getFileSystem(conf);
            TestEncryptedTransfer.writeTestDataToFile(fs);
            Assert.assertEquals((Object)PLAIN_TEXT, (Object)DFSTestUtil.readFile(fs, TEST_PATH));
            fs.close();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEncryptedAppend() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            Configuration conf = new Configuration();
            TestEncryptedTransfer.setEncryptionConfigKeys(conf);
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
            FileSystem fs = TestEncryptedTransfer.getFileSystem(conf);
            TestEncryptedTransfer.writeTestDataToFile(fs);
            Assert.assertEquals((Object)PLAIN_TEXT, (Object)DFSTestUtil.readFile(fs, TEST_PATH));
            TestEncryptedTransfer.writeTestDataToFile(fs);
            Assert.assertEquals((Object)"this is very secret plain textthis is very secret plain text", (Object)DFSTestUtil.readFile(fs, TEST_PATH));
            fs.close();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEncryptedAppendRequiringBlockTransfer() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            Configuration conf = new Configuration();
            TestEncryptedTransfer.setEncryptionConfigKeys(conf);
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(4).build();
            FileSystem fs = TestEncryptedTransfer.getFileSystem(conf);
            TestEncryptedTransfer.writeTestDataToFile(fs);
            Assert.assertEquals((Object)PLAIN_TEXT, (Object)DFSTestUtil.readFile(fs, TEST_PATH));
            FSDataInputStream in = fs.open(TEST_PATH);
            List<LocatedBlock> locatedBlocks = DFSTestUtil.getAllBlocks(in);
            in.close();
            Assert.assertEquals((long)1L, (long)locatedBlocks.size());
            Assert.assertEquals((long)3L, (long)locatedBlocks.get(0).getLocations().length);
            DataNode dn = cluster.getDataNode(locatedBlocks.get(0).getLocations()[0].getIpcPort());
            dn.shutdown();
            TestEncryptedTransfer.writeTestDataToFile(fs);
            Assert.assertEquals((Object)"this is very secret plain textthis is very secret plain text", (Object)DFSTestUtil.readFile(fs, TEST_PATH));
            fs.close();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private static void writeTestDataToFile(FileSystem fs) throws IOException {
        FSDataOutputStream out = null;
        out = !fs.exists(TEST_PATH) ? fs.create(TEST_PATH) : fs.append(TEST_PATH);
        out.write(PLAIN_TEXT.getBytes());
        out.close();
    }
}

