/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockLocalPathInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.TestInterDatanodeProtocol;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;
import org.junit.Test;

public class TestLeaseRecovery {
    static final int BLOCK_SIZE = 1024;
    static final short REPLICATION_NUM = 3;
    private static final long LEASE_PERIOD = 300L;

    static void checkMetaInfo(ExtendedBlock b, DataNode dn) throws IOException {
        TestInterDatanodeProtocol.checkMetaInfo(b, dn);
    }

    static int min(Integer ... x) {
        int m = x[0];
        for (int i = 1; i < x.length; ++i) {
            if (x[i] >= m) continue;
            m = x[i];
        }
        return m;
    }

    void waitLeaseRecovery(MiniDFSCluster cluster) {
        cluster.setLeasePeriod(300L, 300L);
        try {
            Thread.sleep(6000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlockSynchronization() throws Exception {
        int ORG_FILE_SIZE = 3000;
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blocksize", 1024L);
        conf.setLong("dfs.heartbeat.interval", 1L);
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(5).build();
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            String filestr = "/foo";
            Path filepath = new Path(filestr);
            DFSTestUtil.createFile((FileSystem)dfs, filepath, 3000L, (short)3, 0L);
            Assert.assertTrue((boolean)dfs.exists(filepath));
            DFSTestUtil.waitReplication((FileSystem)dfs, filepath, (short)3);
            LocatedBlock locatedblock = TestInterDatanodeProtocol.getLastLocatedBlock(dfs.dfs.getNamenode(), filestr);
            DatanodeInfo[] datanodeinfos = locatedblock.getLocations();
            Assert.assertEquals((long)3L, (long)datanodeinfos.length);
            DataNode[] datanodes = new DataNode[3];
            for (int i = 0; i < 3; ++i) {
                datanodes[i] = cluster.getDataNode(datanodeinfos[i].getIpcPort());
                Assert.assertTrue((datanodes[i] != null ? 1 : 0) != 0);
            }
            ExtendedBlock lastblock = locatedblock.getBlock();
            DataNode.LOG.info((Object)("newblocks=" + lastblock));
            for (int i = 0; i < 3; ++i) {
                TestLeaseRecovery.checkMetaInfo(lastblock, datanodes[i]);
            }
            DataNode.LOG.info((Object)("dfs.dfs.clientName=" + dfs.dfs.clientName));
            cluster.getNameNodeRpc().append(filestr, dfs.dfs.clientName);
            this.waitLeaseRecovery(cluster);
            Block[] updatedmetainfo = new Block[3];
            long oldSize = lastblock.getNumBytes();
            lastblock = TestInterDatanodeProtocol.getLastLocatedBlock(dfs.dfs.getNamenode(), filestr).getBlock();
            long currentGS = lastblock.getGenerationStamp();
            for (int i = 0; i < 3; ++i) {
                updatedmetainfo[i] = DataNodeTestUtils.getFSDataset(datanodes[i]).getStoredBlock(lastblock.getBlockPoolId(), lastblock.getBlockId());
                Assert.assertEquals((long)lastblock.getBlockId(), (long)updatedmetainfo[i].getBlockId());
                Assert.assertEquals((long)oldSize, (long)updatedmetainfo[i].getNumBytes());
                Assert.assertEquals((long)currentGS, (long)updatedmetainfo[i].getGenerationStamp());
            }
            System.out.println("Testing that lease recovery cannot happen during safemode.");
            filestr = "/foo.safemode";
            filepath = new Path(filestr);
            dfs.create(filepath, (short)1);
            cluster.getNameNodeRpc().setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER, false);
            Assert.assertTrue((boolean)dfs.dfs.exists(filestr));
            DFSTestUtil.waitReplication((FileSystem)dfs, filepath, (short)1);
            this.waitLeaseRecovery(cluster);
            LeaseManager lm = NameNodeAdapter.getLeaseManager(cluster.getNamesystem());
            Assert.assertTrue((String)("Found " + lm.countLease() + " lease, expected 1"), (lm.countLease() == 1 ? 1 : 0) != 0);
            cluster.getNameNodeRpc().setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE, false);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testBlockRecoveryWithLessMetafile() throws Exception {
        int count;
        Configuration conf = new Configuration();
        conf.set("dfs.block.local-path-access.user", UserGroupInformation.getCurrentUser().getShortUserName());
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        Path file = new Path("/testRecoveryFile");
        DistributedFileSystem dfs = cluster.getFileSystem();
        FSDataOutputStream out = dfs.create(file);
        for (count = 0; count < 0x200000; count += 4) {
            out.writeBytes("Data");
        }
        out.hsync();
        ((DFSOutputStream)out.getWrappedStream()).abort();
        LocatedBlocks locations = cluster.getNameNodeRpc().getBlockLocations(file.toString(), 0L, (long)count);
        ExtendedBlock block = locations.get(0).getBlock();
        DataNode dn = cluster.getDataNodes().get(0);
        BlockLocalPathInfo localPathInfo = dn.getBlockLocalPathInfo(block, null);
        File metafile = new File(localPathInfo.getMetaPath());
        Assert.assertTrue((boolean)metafile.exists());
        RandomAccessFile raf = new RandomAccessFile(metafile, "rw");
        raf.setLength(metafile.length() - 20L);
        raf.close();
        MiniDFSCluster.DataNodeProperties dnProp = cluster.stopDataNode(0);
        cluster.restartDataNode(dnProp, true);
        DistributedFileSystem newdfs = (DistributedFileSystem)FileSystem.newInstance((Configuration)cluster.getConfiguration(0));
        count = 0;
        while (++count < 10 && !newdfs.recoverLease(file)) {
            Thread.sleep(5000L);
        }
        Assert.assertTrue((String)"File should be closed", (boolean)newdfs.recoverLease(file));
    }
}

