/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import io.hops.exception.StorageException;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.hdfs.dal.InMemoryInodeDataAccess;
import io.hops.metadata.hdfs.dal.LargeOnDiskInodeDataAccess;
import io.hops.metadata.hdfs.dal.MediumOnDiskInodeDataAccess;
import io.hops.metadata.hdfs.dal.SmallOnDiskInodeDataAccess;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.LightWeightRequestHandler;
import io.hops.transaction.handler.RequestHandler;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.ExitUtil;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestSmallFilesCreation {
    static final String hdfsClinetEmulationForSF = "hdfsClientEmulationForSF";
    private static final Log LOG = LogFactory.getLog(TestSmallFilesCreation.class);

    static void writeFile(DistributedFileSystem dfs, String name, int size, boolean overwrite) throws IOException {
        FSDataOutputStream os = dfs.create(new Path(name), overwrite);
        TestSmallFilesCreation.writeData(os, 0, size);
        os.close();
    }

    static void writeFile(FileSystem fs, String name, int size) throws IOException {
        FSDataOutputStream os = fs.create(new Path(name), (short)1);
        TestSmallFilesCreation.writeData(os, 0, size);
        os.close();
    }

    static void writeData(FSDataOutputStream os, int existingSize, int size) throws IOException {
        byte[] data = new byte[size];
        int i = 0;
        while (i < size) {
            byte number;
            data[i] = number = (byte)(existingSize % 128);
            ++i;
            ++existingSize;
        }
        os.write(data);
    }

    static void verifyFile(FileSystem dfs, String file, int size) throws IOException {
        FSDataInputStream is = dfs.open(new Path(file));
        byte[] buffer = new byte[size];
        IOUtils.readFully((InputStream)is, (byte[])buffer, (int)0, (int)size);
        is.close();
        for (int i = 0; i < size; ++i) {
            if (i % 128 == buffer[i]) continue;
            Assert.fail((String)("Data is corrupted. Expecting: " + i % 128 + " got: " + buffer[i] + " index: " + i));
        }
    }

    public static int countDBFiles() throws IOException {
        return TestSmallFilesCreation.countInMemoryDBFiles() + TestSmallFilesCreation.countAllOnDiskDBFiles();
    }

    public static int countInMemoryDBFiles() throws IOException {
        LightWeightRequestHandler countDBFiles = new LightWeightRequestHandler((RequestHandler.OperationType)HDFSOperationType.TEST_DB_FILES){

            public Object performTask() throws StorageException, IOException {
                InMemoryInodeDataAccess fida = (InMemoryInodeDataAccess)HdfsStorageFactory.getDataAccess(InMemoryInodeDataAccess.class);
                return fida.count();
            }
        };
        return (Integer)countDBFiles.handle();
    }

    public static int countAllOnDiskDBFiles() throws IOException {
        return TestSmallFilesCreation.countOnDiskLargeDBFiles() + TestSmallFilesCreation.countOnDiskMediumDBFiles() + TestSmallFilesCreation.countOnDiskSmallDBFiles();
    }

    public static int countOnDiskSmallDBFiles() throws IOException {
        LightWeightRequestHandler countDBFiles = new LightWeightRequestHandler((RequestHandler.OperationType)HDFSOperationType.TEST_DB_FILES){

            public Object performTask() throws StorageException, IOException {
                int count = 0;
                SmallOnDiskInodeDataAccess fida = (SmallOnDiskInodeDataAccess)HdfsStorageFactory.getDataAccess(SmallOnDiskInodeDataAccess.class);
                return count += fida.count();
            }
        };
        return (Integer)countDBFiles.handle();
    }

    public static int countOnDiskMediumDBFiles() throws IOException {
        LightWeightRequestHandler countDBFiles = new LightWeightRequestHandler((RequestHandler.OperationType)HDFSOperationType.TEST_DB_FILES){

            public Object performTask() throws StorageException, IOException {
                int count = 0;
                MediumOnDiskInodeDataAccess fida = (MediumOnDiskInodeDataAccess)HdfsStorageFactory.getDataAccess(MediumOnDiskInodeDataAccess.class);
                return count += fida.count();
            }
        };
        return (Integer)countDBFiles.handle();
    }

    public static int countOnDiskLargeDBFiles() throws IOException {
        LightWeightRequestHandler countDBFiles = new LightWeightRequestHandler((RequestHandler.OperationType)HDFSOperationType.TEST_DB_FILES){

            public Object performTask() throws StorageException, IOException {
                int count = 0;
                LargeOnDiskInodeDataAccess fida = (LargeOnDiskInodeDataAccess)HdfsStorageFactory.getDataAccess(LargeOnDiskInodeDataAccess.class);
                return count += fida.countUniqueFiles();
            }
        };
        return (Integer)countDBFiles.handle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TestSimpleReadAndWrite() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            int BLOCK_SIZE = 0x100000;
            boolean ENABLE_STORE_SMALL_FILES_IN_DB = true;
            int ONDISK_SMALL_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.small.file.max.size", 2000);
            int ONDISK_MEDIUM_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.medium.file.max.size", 4000);
            int ONDISK_LARGE_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.large.file.max.size", 65536);
            int INMEMORY_SMALL_FILE_MAX_SIZE = conf.getInt("dfs.db.inmemory.file.max.size", 1024);
            String FILE_NAME1 = "/TEST-FLIE1";
            String FILE_NAME2 = "/TEST-FLIE2";
            String FILE_NAME3 = "/TEST-FLIE3";
            String FILE_NAME4 = "/TEST-FLIE4";
            conf.setBoolean("dfs.store.small.files.in.db", true);
            conf.setInt("dfs.blocksize", 0x100000);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).format(true).build();
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            TestSmallFilesCreation.writeFile((FileSystem)dfs, "/TEST-FLIE1", INMEMORY_SMALL_FILE_MAX_SIZE);
            TestSmallFilesCreation.verifyFile((FileSystem)dfs, "/TEST-FLIE1", INMEMORY_SMALL_FILE_MAX_SIZE);
            TestSmallFilesCreation.writeFile((FileSystem)dfs, "/TEST-FLIE2", ONDISK_SMALL_FILE_MAX_SIZE);
            TestSmallFilesCreation.verifyFile((FileSystem)dfs, "/TEST-FLIE2", ONDISK_SMALL_FILE_MAX_SIZE);
            TestSmallFilesCreation.writeFile((FileSystem)dfs, "/TEST-FLIE3", ONDISK_MEDIUM_FILE_MAX_SIZE);
            TestSmallFilesCreation.verifyFile((FileSystem)dfs, "/TEST-FLIE3", ONDISK_MEDIUM_FILE_MAX_SIZE);
            TestSmallFilesCreation.writeFile((FileSystem)dfs, "/TEST-FLIE4", ONDISK_LARGE_FILE_MAX_SIZE);
            TestSmallFilesCreation.verifyFile((FileSystem)dfs, "/TEST-FLIE4", ONDISK_LARGE_FILE_MAX_SIZE);
            Assert.assertTrue((String)("Expecting 1 in-memory file. Got: " + TestSmallFilesCreation.countInMemoryDBFiles()), (TestSmallFilesCreation.countInMemoryDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 3 on-disk file(s). Got:" + TestSmallFilesCreation.countAllOnDiskDBFiles()), (TestSmallFilesCreation.countAllOnDiskDBFiles() == 3 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 1 on-disk file(s). Got:" + TestSmallFilesCreation.countOnDiskSmallDBFiles()), (TestSmallFilesCreation.countOnDiskSmallDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 1 on-disk file(s). Got:" + TestSmallFilesCreation.countOnDiskMediumDBFiles()), (TestSmallFilesCreation.countOnDiskMediumDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 1 on-disk file(s). Got:" + TestSmallFilesCreation.countOnDiskLargeDBFiles()), (TestSmallFilesCreation.countOnDiskLargeDBFiles() == 1 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TestWriteLargeFile() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            int BLOCK_SIZE = 0x100000;
            boolean ENABLE_STORE_SMALL_FILES_IN_DB = true;
            int ONDISK_SMALL_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.small.file.max.size", 2000);
            int ONDISK_MEDIUM_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.medium.file.max.size", 4000);
            int ONDISK_LARGE_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.large.file.max.size", 65536);
            int INMEMORY_SMALL_FILE_MAX_SIZE = conf.getInt("dfs.db.inmemory.file.max.size", 1024);
            int FILE_SIZE = ONDISK_LARGE_FILE_MAX_SIZE + 1;
            String FILE_NAME = "/TEST-FLIE";
            conf.setBoolean("dfs.store.small.files.in.db", true);
            conf.setInt("dfs.blocksize", 0x100000);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).format(true).build();
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            TestSmallFilesCreation.writeFile((FileSystem)dfs, "/TEST-FLIE", FILE_SIZE);
            FSDataInputStream dfsIs = dfs.open(new Path("/TEST-FLIE"));
            LocatedBlocks lblks = dfs.getClient().getLocatedBlocks("/TEST-FLIE", 0L, Long.MAX_VALUE);
            Assert.assertFalse((String)"The should not have been stored in the database", (boolean)lblks.hasPhantomBlock());
            Assert.assertTrue((String)("Expecting 0 DB files. Got:" + TestSmallFilesCreation.countDBFiles()), (TestSmallFilesCreation.countDBFiles() == 0 ? 1 : 0) != 0);
            dfsIs.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TestSmallFileHflush() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            int BLOCK_SIZE = 0x100000;
            boolean ENABLE_STORE_SMALL_FILES_IN_DB = true;
            int ONDISK_SMALL_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.small.file.max.size", 2000);
            int ONDISK_MEDIUM_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.medium.file.max.size", 4000);
            int ONDISK_LARGE_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.large.file.max.size", 65536);
            int INMEMORY_SMALL_FILE_MAX_SIZE = conf.getInt("dfs.db.inmemory.file.max.size", 1024);
            String FILE_NAME = "/TEST-FLIE";
            conf.setBoolean("dfs.store.small.files.in.db", true);
            conf.setInt("dfs.blocksize", 0x100000);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).format(true).build();
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            FSDataOutputStream out = dfs.create(new Path("/TEST-FLIE"), (short)3);
            TestSmallFilesCreation.writeData(out, 0, INMEMORY_SMALL_FILE_MAX_SIZE);
            out.flush();
            out.hflush();
            out.close();
            FSDataInputStream dfsIs = dfs.open(new Path("/TEST-FLIE"));
            LocatedBlocks lblks = dfs.getClient().getLocatedBlocks("/TEST-FLIE", 0L, Long.MAX_VALUE);
            Assert.assertFalse((String)"The should not have been stored in the database", (boolean)lblks.hasPhantomBlock());
            Assert.assertTrue((String)("Expecting 0 DB files. Got:" + TestSmallFilesCreation.countDBFiles()), (TestSmallFilesCreation.countDBFiles() == 0 ? 1 : 0) != 0);
            dfsIs.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TestSmallFileHsync() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            int BLOCK_SIZE = 0x100000;
            boolean ENABLE_STORE_SMALL_FILES_IN_DB = true;
            int ONDISK_SMALL_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.small.file.max.size", 2000);
            int ONDISK_MEDIUM_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.medium.file.max.size", 4000);
            int ONDISK_LARGE_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.large.file.max.size", 65536);
            int INMEMORY_SMALL_FILE_MAX_SIZE = conf.getInt("dfs.db.inmemory.file.max.size", 1024);
            String FILE_NAME = "/TEST-FLIE";
            conf.setBoolean("dfs.store.small.files.in.db", true);
            conf.setInt("dfs.blocksize", 0x100000);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).format(true).build();
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            FSDataOutputStream out = dfs.create(new Path("/TEST-FLIE"), (short)3);
            TestSmallFilesCreation.writeData(out, 0, INMEMORY_SMALL_FILE_MAX_SIZE);
            out.hsync();
            out.close();
            FSDataInputStream dfsIs = dfs.open(new Path("/TEST-FLIE"));
            LocatedBlocks lblks = dfs.getClient().getLocatedBlocks("/TEST-FLIE", 0L, Long.MAX_VALUE);
            Assert.assertFalse((String)"The should not have been stored in the database", (boolean)lblks.hasPhantomBlock());
            Assert.assertTrue((String)("Expecting 0 DB files. Got:" + TestSmallFilesCreation.countDBFiles()), (TestSmallFilesCreation.countDBFiles() == 0 ? 1 : 0) != 0);
            dfsIs.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TestDeleteSmallFile() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            int BLOCK_SIZE = 0x100000;
            boolean ENABLE_STORE_SMALL_FILES_IN_DB = true;
            int ONDISK_SMALL_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.small.file.max.size", 2000);
            int ONDISK_MEDIUM_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.medium.file.max.size", 4000);
            int ONDISK_LARGE_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.large.file.max.size", 65536);
            int INMEMORY_SMALL_FILE_MAX_SIZE = conf.getInt("dfs.db.inmemory.file.max.size", 1024);
            String FILE_NAME1 = "/TEST-FLIE1";
            String FILE_NAME2 = "/TEST-FLIE2";
            String FILE_NAME3 = "/TEST-FLIE3";
            String FILE_NAME4 = "/TEST-FLIE4";
            conf.setBoolean("dfs.store.small.files.in.db", true);
            conf.setInt("dfs.blocksize", 0x100000);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).format(true).build();
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            TestSmallFilesCreation.writeFile((FileSystem)dfs, "/TEST-FLIE1", INMEMORY_SMALL_FILE_MAX_SIZE);
            TestSmallFilesCreation.writeFile((FileSystem)dfs, "/TEST-FLIE2", ONDISK_SMALL_FILE_MAX_SIZE);
            TestSmallFilesCreation.writeFile((FileSystem)dfs, "/TEST-FLIE3", ONDISK_MEDIUM_FILE_MAX_SIZE);
            TestSmallFilesCreation.writeFile((FileSystem)dfs, "/TEST-FLIE4", ONDISK_LARGE_FILE_MAX_SIZE);
            Assert.assertTrue((String)("Expecting 1 in-memory file(s). Got: " + TestSmallFilesCreation.countInMemoryDBFiles()), (TestSmallFilesCreation.countInMemoryDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 3 on-disk file(s). Got:" + TestSmallFilesCreation.countAllOnDiskDBFiles()), (TestSmallFilesCreation.countAllOnDiskDBFiles() == 3 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 1 on-disk file(s). Got:" + TestSmallFilesCreation.countOnDiskSmallDBFiles()), (TestSmallFilesCreation.countOnDiskSmallDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 1 on-disk file(s). Got:" + TestSmallFilesCreation.countOnDiskMediumDBFiles()), (TestSmallFilesCreation.countOnDiskMediumDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 1 on-disk file(s). Got:" + TestSmallFilesCreation.countOnDiskLargeDBFiles()), (TestSmallFilesCreation.countOnDiskLargeDBFiles() == 1 ? 1 : 0) != 0);
            dfs.delete(new Path("/TEST-FLIE1"));
            dfs.delete(new Path("/TEST-FLIE2"));
            dfs.delete(new Path("/TEST-FLIE3"));
            dfs.delete(new Path("/TEST-FLIE4"));
            Assert.assertTrue((String)("Expecting 0 in-memory file(s). Got: " + TestSmallFilesCreation.countInMemoryDBFiles()), (TestSmallFilesCreation.countInMemoryDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 0 on-disk file(s). Got:" + TestSmallFilesCreation.countAllOnDiskDBFiles()), (TestSmallFilesCreation.countAllOnDiskDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 0 on-disk file(s). Got:" + TestSmallFilesCreation.countOnDiskSmallDBFiles()), (TestSmallFilesCreation.countOnDiskSmallDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 0 on-disk file(s). Got:" + TestSmallFilesCreation.countOnDiskMediumDBFiles()), (TestSmallFilesCreation.countOnDiskMediumDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 0 on-disk file(s). Got:" + TestSmallFilesCreation.countOnDiskLargeDBFiles()), (TestSmallFilesCreation.countOnDiskLargeDBFiles() == 0 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TestRenameSmallFile() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            int BLOCK_SIZE = 0x100000;
            boolean ENABLE_STORE_SMALL_FILES_IN_DB = true;
            int ONDISK_SMALL_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.small.file.max.size", 2000);
            int ONDISK_MEDIUM_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.medium.file.max.size", 4000);
            int ONDISK_LARGE_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.large.file.max.size", 65536);
            int INMEMORY_SMALL_FILE_MAX_SIZE = conf.getInt("dfs.db.inmemory.file.max.size", 1024);
            String FILE_NAME1 = "/TEST-FLIE1";
            String FILE_NAME2 = "/TEST-FLIE2";
            String FILE_NAME3 = "/TEST-FLIE3";
            String FILE_NAME4 = "/TEST-FLIE4";
            conf.setBoolean("dfs.store.small.files.in.db", true);
            conf.setInt("dfs.blocksize", 0x100000);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).format(true).build();
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            TestSmallFilesCreation.writeFile((FileSystem)dfs, "/TEST-FLIE1", INMEMORY_SMALL_FILE_MAX_SIZE);
            TestSmallFilesCreation.writeFile((FileSystem)dfs, "/TEST-FLIE2", ONDISK_SMALL_FILE_MAX_SIZE);
            TestSmallFilesCreation.writeFile((FileSystem)dfs, "/TEST-FLIE3", ONDISK_MEDIUM_FILE_MAX_SIZE);
            TestSmallFilesCreation.writeFile((FileSystem)dfs, "/TEST-FLIE4", ONDISK_LARGE_FILE_MAX_SIZE);
            Assert.assertTrue((String)("Expecting 1 in-memory file(s). Got: " + TestSmallFilesCreation.countInMemoryDBFiles()), (TestSmallFilesCreation.countInMemoryDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 3 on-disk file(s). Got:" + TestSmallFilesCreation.countAllOnDiskDBFiles()), (TestSmallFilesCreation.countAllOnDiskDBFiles() == 3 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 1 on-disk file(s). Got:" + TestSmallFilesCreation.countOnDiskSmallDBFiles()), (TestSmallFilesCreation.countOnDiskSmallDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 1 on-disk file(s). Got:" + TestSmallFilesCreation.countOnDiskMediumDBFiles()), (TestSmallFilesCreation.countOnDiskMediumDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 1 on-disk file(s). Got:" + TestSmallFilesCreation.countOnDiskLargeDBFiles()), (TestSmallFilesCreation.countOnDiskLargeDBFiles() == 1 ? 1 : 0) != 0);
            dfs.rename(new Path("/TEST-FLIE1"), new Path("/TEST-FLIE11"));
            dfs.rename(new Path("/TEST-FLIE2"), new Path("/TEST-FLIE21"));
            dfs.rename(new Path("/TEST-FLIE3"), new Path("/TEST-FLIE31"));
            dfs.rename(new Path("/TEST-FLIE4"), new Path("/TEST-FLIE41"));
            TestSmallFilesCreation.verifyFile((FileSystem)dfs, "/TEST-FLIE11", INMEMORY_SMALL_FILE_MAX_SIZE);
            TestSmallFilesCreation.verifyFile((FileSystem)dfs, "/TEST-FLIE21", ONDISK_SMALL_FILE_MAX_SIZE);
            TestSmallFilesCreation.verifyFile((FileSystem)dfs, "/TEST-FLIE31", ONDISK_MEDIUM_FILE_MAX_SIZE);
            TestSmallFilesCreation.verifyFile((FileSystem)dfs, "/TEST-FLIE41", ONDISK_LARGE_FILE_MAX_SIZE);
            Assert.assertTrue((String)("Expecting 1 in-memory file(s). Got: " + TestSmallFilesCreation.countInMemoryDBFiles()), (TestSmallFilesCreation.countInMemoryDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 3 on-disk file(s). Got:" + TestSmallFilesCreation.countAllOnDiskDBFiles()), (TestSmallFilesCreation.countAllOnDiskDBFiles() == 3 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 1 on-disk file(s). Got:" + TestSmallFilesCreation.countOnDiskSmallDBFiles()), (TestSmallFilesCreation.countOnDiskSmallDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 1 on-disk file(s). Got:" + TestSmallFilesCreation.countOnDiskMediumDBFiles()), (TestSmallFilesCreation.countOnDiskMediumDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 1 on-disk file(s). Got:" + TestSmallFilesCreation.countOnDiskLargeDBFiles()), (TestSmallFilesCreation.countOnDiskLargeDBFiles() == 1 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TestRenameSmallFiles2() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            int BLOCK_SIZE = 0x100000;
            boolean ENABLE_STORE_SMALL_FILES_IN_DB = true;
            int ONDISK_SMALL_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.small.file.max.size", 2000);
            int ONDISK_MEDIUM_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.medium.file.max.size", 4000);
            int ONDISK_LARGE_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.large.file.max.size", 65536);
            int INMEMORY_SMALL_FILE_MAX_SIZE = conf.getInt("dfs.db.inmemory.file.max.size", 1024);
            String FILE_NAME1 = "/TEST-FLIE1";
            String FILE_NAME2 = "/TEST-FLIE2";
            conf.setBoolean("dfs.store.small.files.in.db", true);
            conf.setInt("dfs.blocksize", 0x100000);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).format(true).build();
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            TestSmallFilesCreation.writeFile((FileSystem)dfs, "/TEST-FLIE1", INMEMORY_SMALL_FILE_MAX_SIZE);
            TestSmallFilesCreation.writeFile((FileSystem)dfs, "/TEST-FLIE2", INMEMORY_SMALL_FILE_MAX_SIZE);
            Assert.assertTrue((String)"Count of db file should be 2", (TestSmallFilesCreation.countInMemoryDBFiles() == 2 ? 1 : 0) != 0);
            dfs.rename(new Path("/TEST-FLIE1"), new Path("/TEST-FLIE2"), new Options.Rename[]{Options.Rename.OVERWRITE});
            Assert.assertTrue((String)"Count of db file should be 1", (TestSmallFilesCreation.countInMemoryDBFiles() == 1 ? 1 : 0) != 0);
            TestSmallFilesCreation.verifyFile((FileSystem)dfs, "/TEST-FLIE2", INMEMORY_SMALL_FILE_MAX_SIZE);
            TestSmallFilesCreation.writeFile((FileSystem)dfs, "/TEST-FLIE1", ONDISK_SMALL_FILE_MAX_SIZE);
            Assert.assertTrue((String)"Count of db file should be 1", (TestSmallFilesCreation.countInMemoryDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Count of db file should be 1", (TestSmallFilesCreation.countAllOnDiskDBFiles() == 1 ? 1 : 0) != 0);
            dfs.rename(new Path("/TEST-FLIE1"), new Path("/TEST-FLIE2"), new Options.Rename[]{Options.Rename.OVERWRITE});
            Assert.assertTrue((String)"Count of db file should be 0", (TestSmallFilesCreation.countInMemoryDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Count of db file should be 1", (TestSmallFilesCreation.countAllOnDiskDBFiles() == 1 ? 1 : 0) != 0);
            TestSmallFilesCreation.verifyFile((FileSystem)dfs, "/TEST-FLIE2", ONDISK_SMALL_FILE_MAX_SIZE);
            TestSmallFilesCreation.writeFile((FileSystem)dfs, "/TEST-FLIE1", ONDISK_LARGE_FILE_MAX_SIZE);
            Assert.assertTrue((String)"Count of db file should be 0", (TestSmallFilesCreation.countInMemoryDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Count of db file should be 2", (TestSmallFilesCreation.countAllOnDiskDBFiles() == 2 ? 1 : 0) != 0);
            dfs.rename(new Path("/TEST-FLIE1"), new Path("/TEST-FLIE2"), new Options.Rename[]{Options.Rename.OVERWRITE});
            Assert.assertTrue((String)"Count of db file should be 0", (TestSmallFilesCreation.countInMemoryDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Count of db file should be 1", (TestSmallFilesCreation.countAllOnDiskDBFiles() == 1 ? 1 : 0) != 0);
            TestSmallFilesCreation.verifyFile((FileSystem)dfs, "/TEST-FLIE2", ONDISK_LARGE_FILE_MAX_SIZE);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TestRenameSmallFiles3() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            int BLOCK_SIZE = 0x100000;
            boolean ENABLE_STORE_SMALL_FILES_IN_DB = true;
            int ONDISK_SMALL_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.small.file.max.size", 2000);
            int ONDISK_MEDIUM_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.medium.file.max.size", 4000);
            int ONDISK_LARGE_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.large.file.max.size", 65536);
            int INMEMORY_SMALL_FILE_MAX_SIZE = conf.getInt("dfs.db.inmemory.file.max.size", 1024);
            String FILE_NAME1 = "/TEST-FLIE1";
            String FILE_NAME2 = "/TEST-FLIE2";
            conf.setBoolean("dfs.store.small.files.in.db", true);
            conf.setInt("dfs.blocksize", 0x100000);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).format(true).build();
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            FSNamesystem namesystem = cluster.getNamesystem();
            TestSmallFilesCreation.writeFile((FileSystem)dfs, "/TEST-FLIE1", INMEMORY_SMALL_FILE_MAX_SIZE);
            TestSmallFilesCreation.writeFile((FileSystem)dfs, "/TEST-FLIE2", ONDISK_LARGE_FILE_MAX_SIZE + 1);
            Assert.assertTrue((String)"Count of db file should be 1", (TestSmallFilesCreation.countDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 1 block but found: " + namesystem.getTotalBlocks()), (namesystem.getTotalBlocks() == 1L ? 1 : 0) != 0);
            dfs.rename(new Path("/TEST-FLIE1"), new Path("/TEST-FLIE2"), new Options.Rename[]{Options.Rename.OVERWRITE});
            Assert.assertTrue((String)"Count of db file should be 1", (TestSmallFilesCreation.countDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 0 block but foudn " + namesystem.getTotalBlocks()), (namesystem.getTotalBlocks() == 0L ? 1 : 0) != 0);
            dfs.delete(new Path("/TEST-FLIE2"));
            Assert.assertTrue((String)"Count of db file should be 0", (TestSmallFilesCreation.countDBFiles() == 0 ? 1 : 0) != 0);
            TestSmallFilesCreation.writeFile((FileSystem)dfs, "/TEST-FLIE1", INMEMORY_SMALL_FILE_MAX_SIZE);
            TestSmallFilesCreation.writeFile((FileSystem)dfs, "/TEST-FLIE2", ONDISK_LARGE_FILE_MAX_SIZE + 1);
            Assert.assertTrue((String)"Count of db file should be 1", (TestSmallFilesCreation.countDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 1 block but found: " + namesystem.getTotalBlocks()), (namesystem.getTotalBlocks() == 1L ? 1 : 0) != 0);
            dfs.rename(new Path("/TEST-FLIE2"), new Path("/TEST-FLIE1"), new Options.Rename[]{Options.Rename.OVERWRITE});
            Assert.assertTrue((String)"Count of db file should be 0", (TestSmallFilesCreation.countDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 1 block but foudn " + namesystem.getTotalBlocks()), (namesystem.getTotalBlocks() == 1L ? 1 : 0) != 0);
            dfs.delete(new Path("/TEST-FLIE1"));
            Assert.assertTrue((String)"Count of db file should be 0", (TestSmallFilesCreation.countDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 0 block but foudn " + namesystem.getTotalBlocks()), (namesystem.getTotalBlocks() == 0L ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TestDelete1() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            int i;
            HdfsConfiguration conf = new HdfsConfiguration();
            int BLOCK_SIZE = 0x100000;
            boolean ENABLE_STORE_SMALL_FILES_IN_DB = true;
            int ONDISK_SMALL_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.small.file.max.size", 2000);
            int ONDISK_MEDIUM_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.medium.file.max.size", 4000);
            int ONDISK_LARGE_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.large.file.max.size", 65536);
            int INMEMORY_SMALL_FILE_MAX_SIZE = conf.getInt("dfs.db.inmemory.file.max.size", 1024);
            conf.setBoolean("dfs.store.small.files.in.db", true);
            conf.setInt("dfs.blocksize", 0x100000);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).format(true).build();
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            dfs.mkdirs(new Path("/dir"));
            for (i = 0; i < 5; ++i) {
                TestSmallFilesCreation.writeFile((FileSystem)dfs, "/dir/file-db-file" + i, INMEMORY_SMALL_FILE_MAX_SIZE);
            }
            for (i = 5; i < 10; ++i) {
                TestSmallFilesCreation.writeFile((FileSystem)dfs, "/dir/file-db-file" + i, ONDISK_SMALL_FILE_MAX_SIZE);
            }
            for (i = 10; i < 15; ++i) {
                TestSmallFilesCreation.writeFile((FileSystem)dfs, "/dir/file-db-file" + i, ONDISK_MEDIUM_FILE_MAX_SIZE);
            }
            for (i = 15; i < 20; ++i) {
                TestSmallFilesCreation.writeFile((FileSystem)dfs, "/dir/file-db-file" + i, ONDISK_LARGE_FILE_MAX_SIZE);
            }
            for (i = 20; i < 25; ++i) {
                TestSmallFilesCreation.writeFile((FileSystem)dfs, "/dir/file2" + i, ONDISK_LARGE_FILE_MAX_SIZE + 1);
            }
            Assert.assertTrue((String)"Count of db file should be 10", (TestSmallFilesCreation.countDBFiles() == 20 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 5 block but found " + cluster.getNamesystem().getTotalBlocks()), (cluster.getNamesystem().getTotalBlocks() == 5L ? 1 : 0) != 0);
            dfs.delete(new Path("/dir"), true);
            Assert.assertTrue((String)"Count of db file should be 0", (TestSmallFilesCreation.countDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 0 block but foudn " + cluster.getNamesystem().getTotalBlocks()), (cluster.getNamesystem().getTotalBlocks() == 0L ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TestAppendMigrateToDataNodes() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            int BLOCK_SIZE = 0x100000;
            boolean ENABLE_STORE_SMALL_FILES_IN_DB = true;
            int ONDISK_SMALL_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.small.file.max.size", 2000);
            int ONDISK_MEDIUM_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.medium.file.max.size", 4000);
            int ONDISK_LARGE_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.large.file.max.size", 65536);
            int INMEMORY_SMALL_FILE_MAX_SIZE = conf.getInt("dfs.db.inmemory.file.max.size", 1024);
            String FILE_NAME1 = "/TEST-FLIE1";
            String FILE_NAME2 = "/TEST-FLIE2";
            conf.setBoolean("dfs.store.small.files.in.db", true);
            conf.setInt("dfs.blocksize", 0x100000);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).format(true).build();
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            TestSmallFilesCreation.writeFile((FileSystem)dfs, "/TEST-FLIE1", INMEMORY_SMALL_FILE_MAX_SIZE);
            TestSmallFilesCreation.verifyFile((FileSystem)dfs, "/TEST-FLIE1", INMEMORY_SMALL_FILE_MAX_SIZE);
            Assert.assertTrue((String)"Count of db file should be 1", (TestSmallFilesCreation.countInMemoryDBFiles() == 1 ? 1 : 0) != 0);
            FSDataOutputStream out = dfs.append(new Path("/TEST-FLIE1"));
            TestSmallFilesCreation.writeData(out, INMEMORY_SMALL_FILE_MAX_SIZE, ONDISK_SMALL_FILE_MAX_SIZE - INMEMORY_SMALL_FILE_MAX_SIZE);
            out.close();
            TestSmallFilesCreation.verifyFile((FileSystem)dfs, "/TEST-FLIE1", ONDISK_SMALL_FILE_MAX_SIZE);
            Assert.assertTrue((String)"Count of db file should be 0", (TestSmallFilesCreation.countInMemoryDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Count of db file should be 1", (TestSmallFilesCreation.countOnDiskSmallDBFiles() == 1 ? 1 : 0) != 0);
            out = dfs.append(new Path("/TEST-FLIE1"));
            TestSmallFilesCreation.writeData(out, ONDISK_SMALL_FILE_MAX_SIZE, ONDISK_MEDIUM_FILE_MAX_SIZE - ONDISK_SMALL_FILE_MAX_SIZE);
            out.close();
            TestSmallFilesCreation.verifyFile((FileSystem)dfs, "/TEST-FLIE1", ONDISK_MEDIUM_FILE_MAX_SIZE);
            Assert.assertTrue((String)"Count of db file should be 0", (TestSmallFilesCreation.countInMemoryDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Count of db file should be 0", (TestSmallFilesCreation.countOnDiskSmallDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Count of db file should be 1", (TestSmallFilesCreation.countOnDiskMediumDBFiles() == 1 ? 1 : 0) != 0);
            out = dfs.append(new Path("/TEST-FLIE1"));
            TestSmallFilesCreation.writeData(out, ONDISK_MEDIUM_FILE_MAX_SIZE, ONDISK_LARGE_FILE_MAX_SIZE - ONDISK_MEDIUM_FILE_MAX_SIZE);
            out.close();
            TestSmallFilesCreation.verifyFile((FileSystem)dfs, "/TEST-FLIE1", ONDISK_LARGE_FILE_MAX_SIZE);
            Assert.assertTrue((String)"Count of db file should be 0", (TestSmallFilesCreation.countInMemoryDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Count of db file should be 0", (TestSmallFilesCreation.countOnDiskSmallDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Count of db file should be 0", (TestSmallFilesCreation.countOnDiskMediumDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Count of db file should be 1", (TestSmallFilesCreation.countOnDiskLargeDBFiles() == 1 ? 1 : 0) != 0);
            out = dfs.append(new Path("/TEST-FLIE1"));
            TestSmallFilesCreation.writeData(out, ONDISK_LARGE_FILE_MAX_SIZE, 1);
            out.close();
            Assert.assertTrue((String)"Count of db file should be 0", (TestSmallFilesCreation.countDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 1 block but foudn " + cluster.getNamesystem().getTotalBlocks()), (cluster.getNamesystem().getTotalBlocks() == 1L ? 1 : 0) != 0);
            TestSmallFilesCreation.verifyFile((FileSystem)dfs, "/TEST-FLIE1", ONDISK_LARGE_FILE_MAX_SIZE + 1);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TestAppendSync() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            int BLOCK_SIZE = 0x100000;
            boolean ENABLE_STORE_SMALL_FILES_IN_DB = true;
            int ONDISK_SMALL_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.small.file.max.size", 2000);
            int ONDISK_MEDIUM_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.medium.file.max.size", 4000);
            int ONDISK_LARGE_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.large.file.max.size", 65536);
            int INMEMORY_SMALL_FILE_MAX_SIZE = conf.getInt("dfs.db.inmemory.file.max.size", 1024);
            String FILE_NAME1 = "/TEST-FLIE1";
            String FILE_NAME2 = "/TEST-FLIE2";
            conf.setBoolean("dfs.store.small.files.in.db", true);
            conf.setInt("dfs.blocksize", 0x100000);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).format(true).build();
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            TestSmallFilesCreation.writeFile((FileSystem)dfs, "/TEST-FLIE1", INMEMORY_SMALL_FILE_MAX_SIZE);
            Assert.assertTrue((String)"Count of db file should be 1", (TestSmallFilesCreation.countInMemoryDBFiles() == 1 ? 1 : 0) != 0);
            FSDataOutputStream out = dfs.append(new Path("/TEST-FLIE1"));
            TestSmallFilesCreation.writeData(out, INMEMORY_SMALL_FILE_MAX_SIZE, 1);
            out.hflush();
            TestSmallFilesCreation.writeData(out, INMEMORY_SMALL_FILE_MAX_SIZE + 1, 1);
            out.close();
            Assert.assertTrue((String)"Count of db file should be 0", (TestSmallFilesCreation.countDBFiles() == 0 ? 1 : 0) != 0);
            TestSmallFilesCreation.verifyFile((FileSystem)dfs, "/TEST-FLIE1", INMEMORY_SMALL_FILE_MAX_SIZE + 2);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TestAppend() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            int BLOCK_SIZE = 0x100000;
            boolean ENABLE_STORE_SMALL_FILES_IN_DB = true;
            int ONDISK_SMALL_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.small.file.max.size", 2000);
            int ONDISK_MEDIUM_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.medium.file.max.size", 4000);
            int ONDISK_LARGE_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.large.file.max.size", 65536);
            int INMEMORY_SMALL_FILE_MAX_SIZE = conf.getInt("dfs.db.inmemory.file.max.size", 1024);
            String FILE_NAME1 = "/TEST-FLIE1";
            String FILE_NAME2 = "/TEST-FLIE2";
            conf.setBoolean("dfs.store.small.files.in.db", true);
            conf.setInt("dfs.blocksize", 0x100000);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).format(true).build();
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            TestSmallFilesCreation.writeFile((FileSystem)dfs, "/TEST-FLIE1", ONDISK_LARGE_FILE_MAX_SIZE);
            TestSmallFilesCreation.verifyFile((FileSystem)dfs, "/TEST-FLIE1", ONDISK_LARGE_FILE_MAX_SIZE);
            Assert.assertTrue((String)"Count of db file should be 1", (TestSmallFilesCreation.countDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Count of db file should be 0", (TestSmallFilesCreation.countInMemoryDBFiles() == 0 ? 1 : 0) != 0);
            FSDataOutputStream out = dfs.append(new Path("/TEST-FLIE1"));
            TestSmallFilesCreation.writeData(out, ONDISK_LARGE_FILE_MAX_SIZE, 1024);
            out.close();
            Assert.assertTrue((String)"Count of db file should be 0", (TestSmallFilesCreation.countDBFiles() == 0 ? 1 : 0) != 0);
            TestSmallFilesCreation.verifyFile((FileSystem)dfs, "/TEST-FLIE1", ONDISK_LARGE_FILE_MAX_SIZE + 1024);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TestOverwrite() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            int BLOCK_SIZE = 0x100000;
            boolean ENABLE_STORE_SMALL_FILES_IN_DB = true;
            int ONDISK_SMALL_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.small.file.max.size", 2000);
            int ONDISK_MEDIUM_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.medium.file.max.size", 4000);
            int ONDISK_LARGE_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.large.file.max.size", 65536);
            int INMEMORY_SMALL_FILE_MAX_SIZE = conf.getInt("dfs.db.inmemory.file.max.size", 1024);
            String FILE_NAME1 = "/TEST-FLIE1";
            String FILE_NAME2 = "/TEST-FLIE2";
            conf.setBoolean("dfs.store.small.files.in.db", true);
            conf.setInt("dfs.blocksize", 0x100000);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).format(true).build();
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            TestSmallFilesCreation.writeFile((FileSystem)dfs, "/TEST-FLIE1", INMEMORY_SMALL_FILE_MAX_SIZE);
            Assert.assertTrue((String)"Count of db file should be 1", (TestSmallFilesCreation.countInMemoryDBFiles() == 1 ? 1 : 0) != 0);
            TestSmallFilesCreation.writeFile((FileSystem)dfs, "/TEST-FLIE1", INMEMORY_SMALL_FILE_MAX_SIZE);
            TestSmallFilesCreation.verifyFile((FileSystem)dfs, "/TEST-FLIE1", INMEMORY_SMALL_FILE_MAX_SIZE);
            Assert.assertTrue((String)"Count of db file should be 1", (TestSmallFilesCreation.countInMemoryDBFiles() == 1 ? 1 : 0) != 0);
            dfs.delete(new Path("/TEST-FLIE1"));
            TestSmallFilesCreation.writeFile((FileSystem)dfs, "/TEST-FLIE2", ONDISK_LARGE_FILE_MAX_SIZE);
            Assert.assertTrue((String)"Count of db file should be 1", (TestSmallFilesCreation.countOnDiskLargeDBFiles() == 1 ? 1 : 0) != 0);
            TestSmallFilesCreation.writeFile((FileSystem)dfs, "/TEST-FLIE2", ONDISK_LARGE_FILE_MAX_SIZE);
            TestSmallFilesCreation.verifyFile((FileSystem)dfs, "/TEST-FLIE2", ONDISK_LARGE_FILE_MAX_SIZE);
            Assert.assertTrue((String)"Count of db file should be 1", (TestSmallFilesCreation.countOnDiskLargeDBFiles() == 1 ? 1 : 0) != 0);
            dfs.delete(new Path("/TEST-FLIE2"));
            TestSmallFilesCreation.writeFile((FileSystem)dfs, "/TEST-FLIE2", ONDISK_MEDIUM_FILE_MAX_SIZE);
            Assert.assertTrue((String)"Count of db file should be 1", (TestSmallFilesCreation.countOnDiskMediumDBFiles() == 1 ? 1 : 0) != 0);
            TestSmallFilesCreation.writeFile((FileSystem)dfs, "/TEST-FLIE2", ONDISK_MEDIUM_FILE_MAX_SIZE);
            TestSmallFilesCreation.verifyFile((FileSystem)dfs, "/TEST-FLIE2", ONDISK_MEDIUM_FILE_MAX_SIZE);
            Assert.assertTrue((String)"Count of db file should be 1", (TestSmallFilesCreation.countOnDiskMediumDBFiles() == 1 ? 1 : 0) != 0);
            dfs.delete(new Path("/TEST-FLIE2"));
            TestSmallFilesCreation.writeFile((FileSystem)dfs, "/TEST-FLIE2", ONDISK_LARGE_FILE_MAX_SIZE);
            Assert.assertTrue((String)"Count of db file should be 1", (TestSmallFilesCreation.countOnDiskLargeDBFiles() == 1 ? 1 : 0) != 0);
            TestSmallFilesCreation.writeFile((FileSystem)dfs, "/TEST-FLIE2", ONDISK_LARGE_FILE_MAX_SIZE);
            TestSmallFilesCreation.verifyFile((FileSystem)dfs, "/TEST-FLIE2", ONDISK_LARGE_FILE_MAX_SIZE);
            Assert.assertTrue((String)"Count of db file should be 1", (TestSmallFilesCreation.countOnDiskLargeDBFiles() == 1 ? 1 : 0) != 0);
            dfs.delete(new Path("/TEST-FLIE2"));
            TestSmallFilesCreation.writeFile((FileSystem)dfs, "/TEST-FLIE1", INMEMORY_SMALL_FILE_MAX_SIZE);
            Assert.assertTrue((String)"Count of db file should be 1", (TestSmallFilesCreation.countInMemoryDBFiles() == 1 ? 1 : 0) != 0);
            TestSmallFilesCreation.writeFile((FileSystem)dfs, "/TEST-FLIE1", ONDISK_SMALL_FILE_MAX_SIZE);
            TestSmallFilesCreation.verifyFile((FileSystem)dfs, "/TEST-FLIE1", ONDISK_SMALL_FILE_MAX_SIZE);
            Assert.assertTrue((String)"Count of db file should be 0", (TestSmallFilesCreation.countInMemoryDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Count of db file should be 1", (TestSmallFilesCreation.countOnDiskSmallDBFiles() == 1 ? 1 : 0) != 0);
            dfs.delete(new Path("/TEST-FLIE1"));
            TestSmallFilesCreation.writeFile((FileSystem)dfs, "/TEST-FLIE1", INMEMORY_SMALL_FILE_MAX_SIZE);
            Assert.assertTrue((String)"Count of db file should be 1", (TestSmallFilesCreation.countInMemoryDBFiles() == 1 ? 1 : 0) != 0);
            TestSmallFilesCreation.writeFile((FileSystem)dfs, "/TEST-FLIE1", ONDISK_MEDIUM_FILE_MAX_SIZE);
            TestSmallFilesCreation.verifyFile((FileSystem)dfs, "/TEST-FLIE1", ONDISK_MEDIUM_FILE_MAX_SIZE);
            Assert.assertTrue((String)"Count of db file should be 0", (TestSmallFilesCreation.countInMemoryDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Count of db file should be 1", (TestSmallFilesCreation.countOnDiskMediumDBFiles() == 1 ? 1 : 0) != 0);
            dfs.delete(new Path("/TEST-FLIE1"));
            TestSmallFilesCreation.writeFile((FileSystem)dfs, "/TEST-FLIE1", INMEMORY_SMALL_FILE_MAX_SIZE);
            Assert.assertTrue((String)"Count of db file should be 1", (TestSmallFilesCreation.countInMemoryDBFiles() == 1 ? 1 : 0) != 0);
            TestSmallFilesCreation.writeFile((FileSystem)dfs, "/TEST-FLIE1", ONDISK_LARGE_FILE_MAX_SIZE);
            TestSmallFilesCreation.verifyFile((FileSystem)dfs, "/TEST-FLIE1", ONDISK_LARGE_FILE_MAX_SIZE);
            Assert.assertTrue((String)"Count of db file should be 0", (TestSmallFilesCreation.countInMemoryDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Count of db file should be 1", (TestSmallFilesCreation.countOnDiskLargeDBFiles() == 1 ? 1 : 0) != 0);
            dfs.delete(new Path("/TEST-FLIE1"));
            TestSmallFilesCreation.writeFile((FileSystem)dfs, "/TEST-FLIE2", ONDISK_LARGE_FILE_MAX_SIZE);
            Assert.assertTrue((String)"Count of db file should be 2", (TestSmallFilesCreation.countAllOnDiskDBFiles() == 1 ? 1 : 0) != 0);
            TestSmallFilesCreation.writeFile((FileSystem)dfs, "/TEST-FLIE2", ONDISK_SMALL_FILE_MAX_SIZE);
            TestSmallFilesCreation.verifyFile((FileSystem)dfs, "/TEST-FLIE2", ONDISK_SMALL_FILE_MAX_SIZE);
            Assert.assertTrue((String)"Count of db file should be 1", (TestSmallFilesCreation.countInMemoryDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Count of db file should be 0", (TestSmallFilesCreation.countOnDiskSmallDBFiles() == 1 ? 1 : 0) != 0);
            dfs.delete(new Path("/TEST-FLIE2"));
            Assert.assertTrue((String)"Count of db file should be 0", (TestSmallFilesCreation.countDBFiles() == 0 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TestOverwrite2() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            int BLOCK_SIZE = 0x100000;
            boolean ENABLE_STORE_SMALL_FILES_IN_DB = true;
            int ONDISK_SMALL_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.small.file.max.size", 2000);
            int ONDISK_MEDIUM_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.medium.file.max.size", 4000);
            int ONDISK_LARGE_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.large.file.max.size", 65536);
            int INMEMORY_SMALL_FILE_MAX_SIZE = conf.getInt("dfs.db.inmemory.file.max.size", 1024);
            String FILE_NAME1 = "/TEST-FLIE1";
            String FILE_NAME2 = "/TEST-FLIE2";
            conf.setBoolean("dfs.store.small.files.in.db", true);
            conf.setInt("dfs.blocksize", 0x100000);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).format(true).numDataNodes(1).format(true).build();
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            TestSmallFilesCreation.writeFile((FileSystem)dfs, "/TEST-FLIE1", INMEMORY_SMALL_FILE_MAX_SIZE);
            Assert.assertTrue((String)"Count of db file should be 1", (TestSmallFilesCreation.countInMemoryDBFiles() == 1 ? 1 : 0) != 0);
            TestSmallFilesCreation.writeFile((FileSystem)dfs, "/TEST-FLIE1", ONDISK_LARGE_FILE_MAX_SIZE + 1);
            Assert.assertTrue((String)("Expecting 1 block but found " + cluster.getNamesystem().getTotalBlocks()), (cluster.getNamesystem().getTotalBlocks() == 1L ? 1 : 0) != 0);
            Assert.assertTrue((String)"Count of db file should be 0", (TestSmallFilesCreation.countDBFiles() == 0 ? 1 : 0) != 0);
            dfs.delete(new Path("/TEST-FLIE1"));
            TestSmallFilesCreation.writeFile((FileSystem)dfs, "/TEST-FLIE1", ONDISK_LARGE_FILE_MAX_SIZE + 1);
            Assert.assertTrue((String)("Expecting 1 block but found " + cluster.getNamesystem().getTotalBlocks()), (cluster.getNamesystem().getTotalBlocks() == 1L ? 1 : 0) != 0);
            TestSmallFilesCreation.writeFile((FileSystem)dfs, "/TEST-FLIE1", INMEMORY_SMALL_FILE_MAX_SIZE);
            Assert.assertTrue((String)"Count of db file should be 1", (TestSmallFilesCreation.countInMemoryDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 0 block but found " + cluster.getNamesystem().getTotalBlocks()), (cluster.getNamesystem().getTotalBlocks() == 0L ? 1 : 0) != 0);
            dfs.delete(new Path("/TEST-FLIE1"));
            TestSmallFilesCreation.writeFile((FileSystem)dfs, "/TEST-FLIE1", ONDISK_LARGE_FILE_MAX_SIZE + 1);
            Assert.assertTrue((String)("Expecting 1 block but found " + cluster.getNamesystem().getTotalBlocks()), (cluster.getNamesystem().getTotalBlocks() == 1L ? 1 : 0) != 0);
            TestSmallFilesCreation.writeFile((FileSystem)dfs, "/TEST-FLIE1", ONDISK_LARGE_FILE_MAX_SIZE);
            Assert.assertTrue((String)"Count of db file should be 1", (TestSmallFilesCreation.countOnDiskLargeDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 0 block but found " + cluster.getNamesystem().getTotalBlocks()), (cluster.getNamesystem().getTotalBlocks() == 0L ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TestHdfsCompatibility1() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            int BLOCK_SIZE = 0x100000;
            boolean ENABLE_STORE_SMALL_FILES_IN_DB = true;
            int ONDISK_SMALL_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.small.file.max.size", 2000);
            int ONDISK_MEDIUM_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.medium.file.max.size", 4000);
            int ONDISK_LARGE_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.large.file.max.size", 65536);
            int INMEMORY_SMALL_FILE_MAX_SIZE = conf.getInt("dfs.db.inmemory.file.max.size", 1024);
            String FILE_NAME1 = "/TEST-FLIE1";
            String FILE_NAME2 = "/TEST-FLIE2";
            conf.setBoolean("dfs.store.small.files.in.db", true);
            conf.setInt("dfs.blocksize", 0x100000);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).format(true).numDataNodes(1).format(true).build();
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            TestSmallFilesCreation.writeFile((FileSystem)dfs, "/TEST-FLIE1", INMEMORY_SMALL_FILE_MAX_SIZE);
            Assert.assertTrue((String)"Count of db file should be 1", (TestSmallFilesCreation.countInMemoryDBFiles() == 1 ? 1 : 0) != 0);
            conf.setBoolean("dfs.store.small.files.in.db", false);
            conf.setBoolean(hdfsClinetEmulationForSF, true);
            FileSystem hdfsClient = FileSystem.newInstance((Configuration)conf);
            TestSmallFilesCreation.writeFile(hdfsClient, "/TEST-FLIE2", INMEMORY_SMALL_FILE_MAX_SIZE);
            Assert.assertTrue((String)"Count of db file should be 1", (TestSmallFilesCreation.countInMemoryDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 1 block but found " + cluster.getNamesystem().getTotalBlocks()), (cluster.getNamesystem().getTotalBlocks() == 1L ? 1 : 0) != 0);
            TestSmallFilesCreation.verifyFile(hdfsClient, "/TEST-FLIE1", INMEMORY_SMALL_FILE_MAX_SIZE);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TestHdfsCompatibility2() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            int BLOCK_SIZE = 0x100000;
            boolean ENABLE_STORE_SMALL_FILES_IN_DB = true;
            int ONDISK_SMALL_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.small.file.max.size", 2000);
            int ONDISK_MEDIUM_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.medium.file.max.size", 4000);
            int ONDISK_LARGE_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.large.file.max.size", 65536);
            int INMEMORY_SMALL_FILE_MAX_SIZE = conf.getInt("dfs.db.inmemory.file.max.size", 1024);
            String FILE_NAME1 = "/TEST-FLIE1";
            String FILE_NAME2 = "/TEST-FLIE2";
            conf.setBoolean("dfs.store.small.files.in.db", true);
            conf.setInt("dfs.blocksize", 0x100000);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).format(true).numDataNodes(1).format(true).build();
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            TestSmallFilesCreation.writeFile((FileSystem)dfs, "/TEST-FLIE1", INMEMORY_SMALL_FILE_MAX_SIZE);
            Assert.assertTrue((String)"Count of db file should be 1", (TestSmallFilesCreation.countInMemoryDBFiles() == 1 ? 1 : 0) != 0);
            conf.setBoolean("dfs.store.small.files.in.db", false);
            conf.setBoolean(hdfsClinetEmulationForSF, true);
            FileSystem hdfsClient = FileSystem.newInstance((Configuration)conf);
            FSDataOutputStream out = hdfsClient.append(new Path("/TEST-FLIE1"));
            TestSmallFilesCreation.writeData(out, INMEMORY_SMALL_FILE_MAX_SIZE, ONDISK_SMALL_FILE_MAX_SIZE - INMEMORY_SMALL_FILE_MAX_SIZE);
            out.close();
            Assert.assertTrue((String)"Count of db file should be 0", (TestSmallFilesCreation.countInMemoryDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 1 block but found " + cluster.getNamesystem().getTotalBlocks()), (cluster.getNamesystem().getTotalBlocks() == 1L ? 1 : 0) != 0);
            TestSmallFilesCreation.verifyFile(hdfsClient, "/TEST-FLIE1", ONDISK_SMALL_FILE_MAX_SIZE);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TestSmallFilesWithNoDataNodes() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            int BLOCK_SIZE = 0x100000;
            boolean ENABLE_STORE_SMALL_FILES_IN_DB = true;
            int ONDISK_SMALL_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.small.file.max.size", 2000);
            int ONDISK_MEDIUM_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.medium.file.max.size", 4000);
            int ONDISK_LARGE_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.large.file.max.size", 65536);
            int INMEMORY_SMALL_FILE_MAX_SIZE = conf.getInt("dfs.db.inmemory.file.max.size", 1024);
            String FILE_NAME1 = "/TEST-FLIE1";
            String FILE_NAME2 = "/TEST-FLIE2";
            conf.setBoolean("dfs.store.small.files.in.db", true);
            conf.setInt("dfs.blocksize", 0x100000);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).format(true).numDataNodes(0).format(true).build();
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            TestSmallFilesCreation.writeFile((FileSystem)dfs, "/TEST-FLIE1", INMEMORY_SMALL_FILE_MAX_SIZE);
            Assert.assertTrue((String)"Count of db file should be 1", (TestSmallFilesCreation.countInMemoryDBFiles() == 1 ? 1 : 0) != 0);
            TestSmallFilesCreation.verifyFile((FileSystem)dfs, "/TEST-FLIE1", INMEMORY_SMALL_FILE_MAX_SIZE);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TestSmallFilesReplication() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            int BLOCK_SIZE = 0x100000;
            boolean ENABLE_STORE_SMALL_FILES_IN_DB = true;
            int ONDISK_SMALL_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.small.file.max.size", 2000);
            int ONDISK_MEDIUM_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.medium.file.max.size", 4000);
            int ONDISK_LARGE_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.large.file.max.size", 65536);
            int INMEMORY_SMALL_FILE_MAX_SIZE = conf.getInt("dfs.db.inmemory.file.max.size", 1024);
            String FILE_NAME1 = "/TEST-FLIE1";
            String FILE_NAME2 = "/TEST-FLIE2";
            conf.setBoolean("dfs.store.small.files.in.db", true);
            conf.setInt("dfs.blocksize", 0x100000);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).format(true).numDataNodes(0).format(true).build();
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            TestSmallFilesCreation.writeFile((FileSystem)dfs, "/TEST-FLIE1", INMEMORY_SMALL_FILE_MAX_SIZE);
            Assert.assertTrue((String)"Count of db file should be 1", (TestSmallFilesCreation.countInMemoryDBFiles() == 1 ? 1 : 0) != 0);
            TestSmallFilesCreation.verifyFile((FileSystem)dfs, "/TEST-FLIE1", INMEMORY_SMALL_FILE_MAX_SIZE);
            dfs.setReplication(new Path("/TEST-FLIE1"), (short)10);
            if (dfs.getFileStatus(new Path("/TEST-FLIE1")).getReplication() != 10) {
                Assert.fail((String)"Unable to set replication for a small file");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TestSmallFileByteBufferReader() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            int BLOCK_SIZE = 0x100000;
            boolean ENABLE_STORE_SMALL_FILES_IN_DB = true;
            int ONDISK_SMALL_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.small.file.max.size", 2000);
            int ONDISK_MEDIUM_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.medium.file.max.size", 4000);
            int ONDISK_LARGE_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.large.file.max.size", 65536);
            int INMEMORY_SMALL_FILE_MAX_SIZE = conf.getInt("dfs.db.inmemory.file.max.size", 1024);
            String FILE_NAME1 = "/TEST-FLIE1";
            String FILE_NAME2 = "/TEST-FLIE2";
            conf.setBoolean("dfs.store.small.files.in.db", true);
            conf.setInt("dfs.blocksize", 0x100000);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).format(true).numDataNodes(0).format(true).build();
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            TestSmallFilesCreation.writeFile((FileSystem)dfs, "/TEST-FLIE1", ONDISK_LARGE_FILE_MAX_SIZE);
            TestSmallFilesCreation.verifyFile((FileSystem)dfs, "/TEST-FLIE1", ONDISK_LARGE_FILE_MAX_SIZE);
            FSDataInputStream read = dfs.open(new Path("/TEST-FLIE1"));
            ByteBuffer buf = ByteBuffer.allocate(ONDISK_LARGE_FILE_MAX_SIZE);
            while (buf.hasRemaining()) {
                int readCount = read.read(buf);
                if (readCount != -1) continue;
                throw new EOFException("Reached the end of stream. Still have: " + buf.remaining() + " bytes left");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TestSmallFileListing() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            int BLOCK_SIZE = 0x100000;
            boolean ENABLE_STORE_SMALL_FILES_IN_DB = true;
            int ONDISK_SMALL_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.small.file.max.size", 2000);
            int ONDISK_MEDIUM_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.medium.file.max.size", 4000);
            int ONDISK_LARGE_FILE_MAX_SIZE = conf.getInt("dfs.db.ondisk.large.file.max.size", 65536);
            int INMEMORY_SMALL_FILE_MAX_SIZE = conf.getInt("dfs.db.inmemory.file.max.size", 1024);
            String BASE_DIR = "/dir";
            String FILE_NAME1 = "/dir/TEST-FLIE1";
            String FILE_NAME2 = "/dir/TEST-FLIE2";
            String FILE_NAME3 = "/dir/TEST-FLIE3";
            conf.setBoolean("dfs.store.small.files.in.db", true);
            conf.setInt("dfs.blocksize", 0x100000);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).format(true).numDataNodes(1).format(true).build();
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            TestSmallFilesCreation.writeFile((FileSystem)dfs, "/dir/TEST-FLIE1", ONDISK_SMALL_FILE_MAX_SIZE);
            TestSmallFilesCreation.writeFile((FileSystem)dfs, "/dir/TEST-FLIE2", ONDISK_MEDIUM_FILE_MAX_SIZE);
            TestSmallFilesCreation.writeFile((FileSystem)dfs, "/dir/TEST-FLIE3", ONDISK_LARGE_FILE_MAX_SIZE);
            TestSmallFilesCreation.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE3", ONDISK_LARGE_FILE_MAX_SIZE);
            TestSmallFilesCreation.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE2", ONDISK_MEDIUM_FILE_MAX_SIZE);
            TestSmallFilesCreation.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE1", ONDISK_SMALL_FILE_MAX_SIZE);
            BlockLocation[] loc = dfs.getFileBlockLocations(new Path("/dir/TEST-FLIE1"), 0L, Long.MAX_VALUE);
            loc = dfs.getFileBlockLocations(new Path("/dir/TEST-FLIE2"), 0L, Long.MAX_VALUE);
            loc = dfs.getFileBlockLocations(new Path("/dir/TEST-FLIE3"), 0L, Long.MAX_VALUE);
            LocatedFileStatus fs = null;
            RemoteIterator itr = null;
            Assert.assertTrue((String)"Expecting 3 files", (dfs.listStatus(new Path("/dir")).length == 3 ? 1 : 0) != 0);
            FileStatus[] fss = dfs.listStatus(new Path("/dir/TEST-FLIE1"));
            Assert.assertTrue((String)("Small file size did not match. Expecting " + ONDISK_SMALL_FILE_MAX_SIZE + " Got " + fss[0].getLen()), (fss[0].getLen() == (long)ONDISK_SMALL_FILE_MAX_SIZE ? 1 : 0) != 0);
            fss = dfs.listStatus(new Path("/dir/TEST-FLIE2"));
            Assert.assertTrue((String)("Small file size did not match. Expecting " + ONDISK_MEDIUM_FILE_MAX_SIZE + " Got " + fss[0].getLen()), (fss[0].getLen() == (long)ONDISK_MEDIUM_FILE_MAX_SIZE ? 1 : 0) != 0);
            fss = dfs.listStatus(new Path("/dir/TEST-FLIE3"));
            Assert.assertTrue((String)("Small file size did not match. Expecting " + ONDISK_LARGE_FILE_MAX_SIZE + " Got " + fss[0].getLen()), (fss[0].getLen() == (long)ONDISK_LARGE_FILE_MAX_SIZE ? 1 : 0) != 0);
            itr = dfs.listFiles(new Path("/dir"), true);
            while (itr.hasNext()) {
                fs = (LocatedFileStatus)itr.next();
                System.out.println("File: " + fs.getPath() + ", Size: " + fs.getLen() + ", Loc: " + Arrays.toString(fs.getBlockLocations()));
            }
            itr = dfs.listFiles(new Path("/dir/TEST-FLIE1"), true);
            fs = (LocatedFileStatus)itr.next();
            Assert.assertTrue((String)("Small file size did not match. Expecting " + ONDISK_SMALL_FILE_MAX_SIZE + " Got " + fs.getLen()), (fs.getLen() == (long)ONDISK_SMALL_FILE_MAX_SIZE ? 1 : 0) != 0);
            itr = dfs.listFiles(new Path("/dir/TEST-FLIE2"), true);
            fs = (LocatedFileStatus)itr.next();
            Assert.assertTrue((String)("Small file size did not match. Expecting " + ONDISK_MEDIUM_FILE_MAX_SIZE + " Got " + fs.getLen()), (fs.getLen() == (long)ONDISK_MEDIUM_FILE_MAX_SIZE ? 1 : 0) != 0);
            itr = dfs.listFiles(new Path("/dir/TEST-FLIE3"), true);
            fs = (LocatedFileStatus)itr.next();
            Assert.assertTrue((String)("Small file size did not match. Expecting " + ONDISK_LARGE_FILE_MAX_SIZE + " Got " + fs.getLen()), (fs.getLen() == (long)ONDISK_LARGE_FILE_MAX_SIZE ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=900000L)
    public void TestWriteMaxSpillToDN() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            boolean ENABLE_STORE_SMALL_FILES_IN_DB = true;
            int MAX_SMALL_FILE_SIZE = 0xA00000;
            conf.setBoolean("dfs.store.small.files.in.db", true);
            conf.setInt("dfs.db.ondisk.large.file.max.size", 0xA00000);
            conf.setInt("dfs.db.file.max.size", 0xA00000);
            conf.setInt("dfs.blocksize", 0x8000000);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).format(true).numDataNodes(1).format(true).build();
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            int count = 13;
            int i = 0;
            try {
                for (i = 0; i < count; ++i) {
                    LOG.info((Object)("GAUTIER write file " + i));
                    TestSmallFilesCreation.writeFile((FileSystem)dfs, "/file" + i, 0xA00000);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("Failed after creating " + i + " files"));
            }
            try {
                for (i = 0; i < count; ++i) {
                    LOG.info((Object)("GAUTIER verify file " + i));
                    TestSmallFilesCreation.verifyFile((FileSystem)dfs, "/file" + i, 0xA00000);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"Failed to verify files");
            }
            int dbFiles = TestSmallFilesCreation.countDBFiles();
            Assert.assertTrue((String)("Count of db file should be more than 0 and less than " + count), (dbFiles > 0 && dbFiles < count ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void TestZLastTestCleanUp() throws IOException {
        String[] argv = new String[]{"-format", "-force"};
        ExitUtil.disableSystemExit();
        HdfsConfiguration conf = new HdfsConfiguration();
        try {
            NameNode.createNameNode((String[])argv, (Configuration)conf);
            Assert.fail((String)"createNameNode() did not call System.exit()");
        }
        catch (ExitUtil.ExitException exitException) {
            // empty catch block
        }
    }
}

