/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import io.hops.common.INodeUtil;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.hdfs.entity.INodeIdentifier;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.UnregisteredNodeException;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.junit.Assert;
import org.junit.Test;

public class TestComputeInvalidateWork {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompInvalidate() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        int NUM_OF_DATANODES = 3;
        conf.setInt("dfs.namenode.replication.interval", Integer.MAX_VALUE);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
        try {
            cluster.waitActive();
            FSNamesystem namesystem = cluster.getNamesystem();
            BlockManager bm = namesystem.getBlockManager();
            int blockInvalidateLimit = bm.getDatanodeManager().blockInvalidateLimit;
            DatanodeDescriptor[] nodes = bm.getDatanodeManager().getHeartbeatManager().getDatanodes();
            Assert.assertEquals((long)nodes.length, (long)3L);
            for (int i = 0; i < nodes.length; ++i) {
                for (int j = 0; j < 3 * blockInvalidateLimit + 1; ++j) {
                    Block block = new Block((long)(i * (blockInvalidateLimit + 1) + j), 0L, 1000L);
                    this.addToInvalidates(bm, block, nodes[i], namesystem);
                }
            }
            Assert.assertEquals((long)(blockInvalidateLimit * 3), (long)bm.computeInvalidateWork(4));
            Assert.assertEquals((long)(blockInvalidateLimit * 3), (long)bm.computeInvalidateWork(3));
            Assert.assertEquals((long)(blockInvalidateLimit * 2), (long)bm.computeInvalidateWork(2));
            int workCount = bm.computeInvalidateWork(1);
            if (workCount == 1) {
                Assert.assertEquals((long)(blockInvalidateLimit + 1), (long)bm.computeInvalidateWork(2));
            } else {
                Assert.assertEquals((long)workCount, (long)blockInvalidateLimit);
                Assert.assertEquals((long)2L, (long)bm.computeInvalidateWork(2));
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    private void addToInvalidates(final BlockManager bm, final Block block, final DatanodeDescriptor node, FSNamesystem namesystem) throws IOException {
        new HopsTransactionalRequestHandler(HDFSOperationType.COMP_INVALIDATE){
            INodeIdentifier inodeIdentifier;

            public void setUp() throws StorageException, IOException {
                this.inodeIdentifier = INodeUtil.resolveINodeFromBlock((Block)block);
            }

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getIndividualBlockLock(block.getBlockId(), this.inodeIdentifier)).add(lf.getBlockRelated(new LockFactory.BLK[]{LockFactory.BLK.IV}));
            }

            public Object performTask() throws StorageException, IOException {
                TestComputeInvalidateWork.this.addToInvalidates(block, (DatanodeInfo)node, bm);
                return null;
            }
        }.handle((Object)namesystem);
    }

    void addToInvalidates(Block block, DatanodeInfo datanode, BlockManager bm) throws StorageException, TransactionContextException, UnregisteredNodeException {
        DatanodeDescriptor dn = bm.getDatanodeManager().getDatanode((DatanodeID)datanode);
        DatanodeStorageInfo storage = dn.getStorageInfos()[0];
        bm.addToInvalidates(block, storage);
    }
}

