/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import io.hops.common.INodeUtil;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.entity.INodeIdentifier;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.HeartbeatManager;
import org.apache.hadoop.hdfs.server.blockmanagement.NumberReplicas;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.util.Time;
import org.junit.Assert;
import org.junit.Test;

public class TestNodeCount {
    final short REPLICATION_FACTOR = (short)2;
    final long TIMEOUT = 20000L;
    long timeout = 0L;
    long failtime = 0L;
    Block lastBlock = null;
    NumberReplicas lastNum = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNodeCount() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        try {
            FSNamesystem namesystem = cluster.getNamesystem();
            final BlockManager bm = namesystem.getBlockManager();
            HeartbeatManager hm = bm.getDatanodeManager().getHeartbeatManager();
            DistributedFileSystem fs = cluster.getFileSystem();
            Path FILE_PATH = new Path("/testfile");
            DFSTestUtil.createFile((FileSystem)fs, FILE_PATH, 1L, (short)2, 1L);
            DFSTestUtil.waitReplication((FileSystem)fs, FILE_PATH, (short)2);
            final ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)fs, FILE_PATH);
            DatanodeDescriptor[] datanodes = hm.getDatanodes();
            cluster.startDataNodes((Configuration)conf, 2, true, null, null);
            cluster.waitActive();
            DatanodeDescriptor datanode = datanodes[0];
            MiniDFSCluster.DataNodeProperties dnprop = cluster.stopDataNode(datanode.getXferAddr());
            BlockManagerTestUtil.noticeDeadDatanode(cluster.getNameNode(), datanode.getXferAddr());
            DFSTestUtil.waitReplication((FileSystem)fs, FILE_PATH, (short)2);
            cluster.restartDataNode(dnprop);
            cluster.waitActive();
            this.initializeTimeout(20000L);
            while (this.countNodes(block.getLocalBlock(), namesystem).excessReplicas() == 0) {
                this.checkTimeout("excess replicas not detected");
            }
            HopsTransactionalRequestHandler getnonExcessDN = new HopsTransactionalRequestHandler(HDFSOperationType.TEST_NODE_COUNT){
                INodeIdentifier inodeIdentifier;

                public void setUp() throws StorageException, IOException {
                    this.inodeIdentifier = INodeUtil.resolveINodeFromBlock((Block)block.getLocalBlock());
                }

                public void acquireLock(TransactionLocks locks) throws IOException {
                    LockFactory lf = LockFactory.getInstance();
                    locks.add(lf.getIndividualBlockLock(block.getBlockId(), this.inodeIdentifier)).add(lf.getBlockRelated(new LockFactory.BLK[]{LockFactory.BLK.RE, LockFactory.BLK.ER}));
                }

                public Object performTask() throws StorageException, IOException {
                    BlockInfo blkInfo = new BlockInfo(block.getLocalBlock(), this.inodeIdentifier.getInodeId().longValue());
                    Collection excessDns = bm.excessReplicateMap.get(blkInfo);
                    DatanodeDescriptor nonExcessDN = null;
                    for (DatanodeStorageInfo storage : bm.blocksMap.storageList(block.getLocalBlock())) {
                        DatanodeDescriptor dn = storage.getDatanodeDescriptor();
                        if (excessDns.contains(dn.getDatanodeUuid())) continue;
                        nonExcessDN = dn;
                    }
                    return nonExcessDN;
                }
            };
            DatanodeDescriptor nonExcessDN = (DatanodeDescriptor)getnonExcessDN.handle((Object)namesystem);
            Assert.assertTrue((nonExcessDN != null ? 1 : 0) != 0);
            dnprop = cluster.stopDataNode(nonExcessDN.getXferAddr());
            BlockManagerTestUtil.noticeDeadDatanode(cluster.getNameNode(), nonExcessDN.getXferAddr());
            this.initializeTimeout(20000L);
            while (this.countNodes(block.getLocalBlock(), namesystem).liveReplicas() != 2) {
                this.checkTimeout("live replica count not correct", 1000L);
            }
            cluster.restartDataNode(dnprop);
            cluster.waitActive();
            this.initializeTimeout(20000L);
            while (this.countNodes(block.getLocalBlock(), namesystem).excessReplicas() != 2) {
                this.checkTimeout("excess replica count not equal to 2");
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    void initializeTimeout(long timeout) {
        this.timeout = timeout;
        this.failtime = Time.now() + (timeout <= 0L ? Long.MAX_VALUE : timeout);
    }

    void checkTimeout(String testLabel) throws TimeoutException {
        this.checkTimeout(testLabel, 0L);
    }

    void checkTimeout(String testLabel, long cycleTime) throws TimeoutException {
        if (Time.now() > this.failtime) {
            throw new TimeoutException("Timeout: " + testLabel + " for block " + this.lastBlock + " after " + this.timeout + " msec.  Last counts: live = " + this.lastNum.liveReplicas() + ", excess = " + this.lastNum.excessReplicas() + ", corrupt = " + this.lastNum.corruptReplicas());
        }
        if (cycleTime > 0L) {
            try {
                Thread.sleep(cycleTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    NumberReplicas countNodes(final Block block, final FSNamesystem namesystem) throws IOException {
        return (NumberReplicas)new HopsTransactionalRequestHandler(HDFSOperationType.COUNT_NODES){
            INodeIdentifier inodeIdentifier;

            public void setUp() throws StorageException, IOException {
                this.inodeIdentifier = INodeUtil.resolveINodeFromBlock((Block)block);
            }

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getIndividualBlockLock(block.getBlockId(), this.inodeIdentifier)).add(lf.getBlockRelated(new LockFactory.BLK[]{LockFactory.BLK.RE, LockFactory.BLK.ER, LockFactory.BLK.CR}));
            }

            public Object performTask() throws StorageException, IOException {
                TestNodeCount.this.lastBlock = block;
                TestNodeCount.this.lastNum = namesystem.getBlockManager().countNodes(block);
                return TestNodeCount.this.lastNum;
            }
        }.handle((Object)namesystem);
    }
}

