/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import io.hops.common.INodeUtil;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.entity.INodeIdentifier;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLocks;
import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.TestDatanodeBlockScanner;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.HeartbeatManager;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.util.LightWeightLinkedSet;
import org.apache.hadoop.util.Time;
import org.junit.Assert;
import org.junit.Test;

public class TestOverReplicatedBlocks {
    static final long SMALL_BLOCK_SIZE = 512L;
    static final long SMALL_FILE_LENGTH = 2048L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProcesOverReplicateBlock() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blockreport.intervalMsec", 1000L);
        conf.set("dfs.namenode.replication.pending.timeout-sec", Integer.toString(2));
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        try {
            HeartbeatManager hm;
            Path fileName = new Path("/foo1");
            DFSTestUtil.createFile((FileSystem)fs, fileName, 2L, (short)3, 0L);
            DFSTestUtil.waitReplication((FileSystem)fs, fileName, (short)3);
            final ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)fs, fileName);
            Assert.assertTrue((boolean)TestDatanodeBlockScanner.corruptReplica(block, 0));
            MiniDFSCluster.DataNodeProperties dnProps = cluster.stopDataNode(0);
            File scanLog = new File(MiniDFSCluster.getFinalizedDir(cluster.getInstanceStorageDir(0, 0), cluster.getNamesystem().getBlockPoolId()).getParent().toString() + "/../dncp_block_verification.log.prev");
            int i = 0;
            while (!scanLog.delete()) {
                Assert.assertTrue((String)"Could not delete log file in one minute", (i < 60 ? 1 : 0) != 0);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++i;
            }
            cluster.restartDataNode(dnProps);
            DFSTestUtil.waitReplication((FileSystem)fs, fileName, (short)2);
            String blockPoolId = cluster.getNamesystem().getBlockPoolId();
            DatanodeRegistration corruptDataNode = DataNodeTestUtils.getDNRegistrationForBP(cluster.getDataNodes().get(2), blockPoolId);
            FSNamesystem namesystem = cluster.getNamesystem();
            final BlockManager bm = namesystem.getBlockManager();
            HeartbeatManager heartbeatManager = hm = bm.getDatanodeManager().getHeartbeatManager();
            synchronized (heartbeatManager) {
                String corruptMachineName = corruptDataNode.getXferAddr();
                for (DatanodeDescriptor datanode : hm.getDatanodes()) {
                    if (corruptMachineName.equals(datanode.getXferAddr())) continue;
                    datanode.getStorageInfos()[0].setUtilizationForTesting(100L, 100L, 0L, 100L);
                    datanode.updateHeartbeat(BlockManagerTestUtil.getStorageReportsForDatanode(datanode), 0L, 0L, 0, 0);
                }
                NameNodeAdapter.setReplication(namesystem, fileName.toString(), (short)1);
                new HopsTransactionalRequestHandler(HDFSOperationType.TEST_PROCESS_OVER_REPLICATED_BLOCKS){
                    INodeIdentifier inodeIdentifier;

                    public void setUp() throws StorageException, IOException {
                        this.inodeIdentifier = INodeUtil.resolveINodeFromBlock((Block)block.getLocalBlock());
                    }

                    public void acquireLock(TransactionLocks locks) throws IOException {
                        LockFactory lf = LockFactory.getInstance();
                        locks.add(lf.getIndividualBlockLock(block.getBlockId(), this.inodeIdentifier)).add(lf.getBlockRelated(new LockFactory.BLK[]{LockFactory.BLK.RE, LockFactory.BLK.ER, LockFactory.BLK.CR}));
                    }

                    public Object performTask() throws StorageException, IOException {
                        Assert.assertEquals((long)1L, (long)bm.countNodes(block.getLocalBlock()).liveReplicas());
                        return null;
                    }
                }.handle((Object)namesystem);
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChooseReplicaToDelete() throws Exception {
        MiniDFSCluster cluster = null;
        DistributedFileSystem fs = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            conf.setLong("dfs.blocksize", 512L);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
            fs = cluster.getFileSystem();
            FSNamesystem namesystem = cluster.getNamesystem();
            conf.setLong("dfs.heartbeat.interval", 300L);
            cluster.startDataNodes((Configuration)conf, 1, true, null, null, null);
            DataNode lastDN = cluster.getDataNodes().get(3);
            DatanodeRegistration dnReg = DataNodeTestUtils.getDNRegistrationForBP(lastDN, namesystem.getBlockPoolId());
            String lastDNid = dnReg.getDatanodeUuid();
            Path fileName = new Path("/foo2");
            DFSTestUtil.createFile((FileSystem)fs, fileName, 2048L, (short)4, 0L);
            DFSTestUtil.waitReplication((FileSystem)fs, fileName, (short)4);
            DatanodeDescriptor nodeInfo = null;
            long lastHeartbeat = 0L;
            long waitTime = 15000L;
            do {
                nodeInfo = namesystem.getBlockManager().getDatanodeManager().getDatanode((DatanodeID)dnReg);
                lastHeartbeat = nodeInfo.getLastUpdate();
            } while (Time.now() - lastHeartbeat < waitTime);
            fs.setReplication(fileName, (short)3);
            BlockLocation[] locs = fs.getFileBlockLocations(fs.getFileStatus(fileName), 0L, Long.MAX_VALUE);
            LightWeightLinkedSet dnBlocks = namesystem.getBlockManager().excessReplicateMap.get(lastDNid, namesystem.getBlockManager().getDatanodeManager());
            Assert.assertEquals((String)("Replicas on node " + lastDNid + " should have been deleted"), (long)4L, (long)dnBlocks.size());
            for (BlockLocation location : locs) {
                Assert.assertEquals((String)"Block should still have 4 replicas", (long)4L, (long)location.getNames().length);
            }
        }
        finally {
            if (fs != null) {
                fs.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidateOverReplicatedBlock() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
        try {
            FSNamesystem namesystem = cluster.getNamesystem();
            final BlockManager bm = namesystem.getBlockManager();
            DistributedFileSystem fs = cluster.getFileSystem();
            Path p = new Path(MiniDFSCluster.getBaseDirectory(), "/foo1");
            FSDataOutputStream out = fs.create(p, (short)2);
            out.writeBytes("HDFS-3119: " + p);
            out.hsync();
            fs.setReplication(p, (short)1);
            out.close();
            final ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)fs, p);
            new HopsTransactionalRequestHandler(HDFSOperationType.TEST_PROCESS_OVER_REPLICATED_BLOCKS){
                INodeIdentifier inodeIdentifier;

                public void setUp() throws StorageException, IOException {
                    this.inodeIdentifier = INodeUtil.resolveINodeFromBlock((Block)block.getLocalBlock());
                }

                public void acquireLock(TransactionLocks locks) throws IOException {
                    LockFactory lf = LockFactory.getInstance();
                    locks.add(lf.getIndividualBlockLock(block.getBlockId(), this.inodeIdentifier)).add(lf.getBlockRelated(new LockFactory.BLK[]{LockFactory.BLK.RE, LockFactory.BLK.ER, LockFactory.BLK.CR}));
                }

                public Object performTask() throws StorageException, IOException {
                    Assert.assertEquals((String)"Expected only one live replica for the block", (long)1L, (long)bm.countNodes(block.getLocalBlock()).liveReplicas());
                    return null;
                }
            }.handle((Object)namesystem);
        }
        finally {
            cluster.shutdown();
        }
    }
}

