/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.test.MetricsAsserts;
import org.apache.log4j.Level;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class TestDataNodeVolumeFailureReporting {
    private static final Log LOG = LogFactory.getLog(TestDataNodeVolumeFailureReporting.class);
    private FileSystem fs;
    private MiniDFSCluster cluster;
    private Configuration conf;
    private String dataDir;
    final int WAIT_FOR_HEARTBEATS = 3000;
    final int WAIT_FOR_DEATH = 15000;

    public TestDataNodeVolumeFailureReporting() {
        ((Log4JLogger)LOG).getLogger().setLevel(Level.ALL);
        this.WAIT_FOR_HEARTBEATS = 3000;
        this.WAIT_FOR_DEATH = 15000;
    }

    @Before
    public void setUp() throws Exception {
        this.conf = new HdfsConfiguration();
        this.conf.setLong("dfs.blocksize", 512L);
        this.conf.setInt("dfs.heartbeat.interval", 1);
        this.conf.setInt("dfs.df.interval", 1000);
        this.conf.setInt("dfs.namenode.heartbeat.recheck-interval", 1000);
        this.conf.setInt("dfs.datanode.failed.volumes.tolerated", 1);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(1).build();
        this.cluster.waitActive();
        this.fs = this.cluster.getFileSystem();
        this.dataDir = this.cluster.getDataDirectory();
    }

    @After
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            for (File dir : this.cluster.getAllInstanceStorageDirs()) {
                dir.setExecutable(true);
            }
            this.cluster.shutdown();
        }
    }

    @Test
    public void testSuccessiveVolumeFailures() throws Exception {
        Assume.assumeTrue((!System.getProperty("os.name").startsWith("Windows") ? 1 : 0) != 0);
        this.cluster.startDataNodes(this.conf, 2, true, null, null);
        this.cluster.waitActive();
        Thread.sleep(3000L);
        DatanodeManager dm = this.cluster.getNamesystem().getBlockManager().getDatanodeManager();
        long origCapacity = DFSTestUtil.getLiveDatanodeCapacity(dm);
        long dnCapacity = DFSTestUtil.getDatanodeCapacity(dm, 0);
        File dn1Vol1 = this.cluster.getInstanceStorageDir(0, 0);
        File dn2Vol1 = this.cluster.getInstanceStorageDir(1, 0);
        File dn3Vol1 = this.cluster.getInstanceStorageDir(2, 0);
        File dn3Vol2 = this.cluster.getInstanceStorageDir(2, 1);
        Assert.assertTrue((String)"Couldn't chmod local vol", (boolean)dn1Vol1.setExecutable(false));
        Assert.assertTrue((String)"Couldn't chmod local vol", (boolean)dn2Vol1.setExecutable(false));
        Path file1 = new Path("/test1");
        DFSTestUtil.createFile(this.fs, file1, 1024L, (short)3, 1L);
        DFSTestUtil.waitReplication(this.fs, file1, (short)3);
        ArrayList<DataNode> dns = this.cluster.getDataNodes();
        Assert.assertTrue((String)"DN1 should be up", (boolean)dns.get(0).isDatanodeUp());
        Assert.assertTrue((String)"DN2 should be up", (boolean)dns.get(1).isDatanodeUp());
        Assert.assertTrue((String)"DN3 should be up", (boolean)dns.get(2).isDatanodeUp());
        MetricsAsserts.assertCounter((String)"VolumeFailures", (long)1L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)dns.get(0).getMetrics().name()));
        MetricsAsserts.assertCounter((String)"VolumeFailures", (long)1L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)dns.get(1).getMetrics().name()));
        MetricsAsserts.assertCounter((String)"VolumeFailures", (long)0L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)dns.get(2).getMetrics().name()));
        DFSTestUtil.waitForDatanodeStatus(dm, 3, 0, 2L, origCapacity - 1L * dnCapacity, 3000L);
        Assert.assertTrue((String)"Couldn't chmod local vol", (boolean)dn3Vol1.setExecutable(false));
        Path file2 = new Path("/test2");
        DFSTestUtil.createFile(this.fs, file2, 1024L, (short)3, 1L);
        DFSTestUtil.waitReplication(this.fs, file2, (short)3);
        Assert.assertTrue((String)"DN3 should still be up", (boolean)dns.get(2).isDatanodeUp());
        MetricsAsserts.assertCounter((String)"VolumeFailures", (long)1L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)dns.get(2).getMetrics().name()));
        ArrayList live = new ArrayList();
        ArrayList dead = new ArrayList();
        dm.fetchDatanodes(live, dead, false);
        live.clear();
        dead.clear();
        dm.fetchDatanodes(live, dead, false);
        Assert.assertEquals((String)"DN3 should have 1 failed volume", (long)1L, (long)((DatanodeDescriptor)live.get(2)).getVolumeFailures());
        dnCapacity = DFSTestUtil.getDatanodeCapacity(dm, 0);
        DFSTestUtil.waitForDatanodeStatus(dm, 3, 0, 3L, origCapacity - 3L * dnCapacity, 3000L);
        Assert.assertTrue((String)"Couldn't chmod local vol", (boolean)dn3Vol2.setExecutable(false));
        Path file3 = new Path("/test3");
        DFSTestUtil.createFile(this.fs, file3, 1024L, (short)3, 1L);
        DFSTestUtil.waitReplication(this.fs, file3, (short)2);
        DFSTestUtil.waitForDatanodeDeath(dns.get(2));
        MetricsAsserts.assertCounter((String)"VolumeFailures", (long)2L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)dns.get(2).getMetrics().name()));
        DFSTestUtil.waitForDatanodeStatus(dm, 2, 1, 2L, origCapacity - 4L * dnCapacity, 3000L);
        Assert.assertTrue((String)"Couldn't chmod local vol", (boolean)dn1Vol1.setExecutable(true));
        Assert.assertTrue((String)"Couldn't chmod local vol", (boolean)dn2Vol1.setExecutable(true));
        Assert.assertTrue((String)"Couldn't chmod local vol", (boolean)dn3Vol1.setExecutable(true));
        Assert.assertTrue((String)"Couldn't chmod local vol", (boolean)dn3Vol2.setExecutable(true));
        this.cluster.restartDataNodes();
        this.cluster.waitActive();
        Path file4 = new Path("/test4");
        DFSTestUtil.createFile(this.fs, file4, 1024L, (short)3, 1L);
        DFSTestUtil.waitReplication(this.fs, file4, (short)3);
        DFSTestUtil.waitForDatanodeStatus(dm, 3, 0, 0L, origCapacity, 3000L);
    }

    @Test
    public void testVolFailureStatsPreservedOnNNRestart() throws Exception {
        Assume.assumeTrue((!System.getProperty("os.name").startsWith("Windows") ? 1 : 0) != 0);
        this.cluster.startDataNodes(this.conf, 2, true, null, null);
        this.cluster.waitActive();
        DatanodeManager dm = this.cluster.getNamesystem().getBlockManager().getDatanodeManager();
        long origCapacity = DFSTestUtil.getLiveDatanodeCapacity(dm);
        long dnCapacity = DFSTestUtil.getDatanodeCapacity(dm, 0);
        File dn1Vol1 = this.cluster.getInstanceStorageDir(0, 0);
        File dn2Vol1 = this.cluster.getInstanceStorageDir(1, 0);
        Assert.assertTrue((String)"Couldn't chmod local vol", (boolean)dn1Vol1.setExecutable(false));
        Assert.assertTrue((String)"Couldn't chmod local vol", (boolean)dn2Vol1.setExecutable(false));
        Path file1 = new Path("/test1");
        DFSTestUtil.createFile(this.fs, file1, 1024L, (short)2, 1L);
        DFSTestUtil.waitReplication(this.fs, file1, (short)2);
        DFSTestUtil.waitForDatanodeStatus(dm, 3, 0, 2L, origCapacity - 1L * dnCapacity, 3000L);
        this.cluster.restartNameNode(0);
        this.cluster.waitActive();
        DFSTestUtil.waitForDatanodeStatus(dm, 3, 0, 2L, origCapacity - 1L * dnCapacity, 3000L);
    }
}

