/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.junit.Assert;

public final class AclTestHelpers {
    public static AclEntry aclEntry(AclEntryScope scope, AclEntryType type, FsAction permission) {
        return new AclEntry.Builder().setScope(scope).setType(type).setPermission(permission).build();
    }

    public static AclEntry aclEntry(AclEntryScope scope, AclEntryType type, String name, FsAction permission) {
        return new AclEntry.Builder().setScope(scope).setType(type).setName(name).setPermission(permission).build();
    }

    public static AclEntry aclEntry(AclEntryScope scope, AclEntryType type, String name) {
        return new AclEntry.Builder().setScope(scope).setType(type).setName(name).build();
    }

    public static AclEntry aclEntry(AclEntryScope scope, AclEntryType type) {
        return new AclEntry.Builder().setScope(scope).setType(type).build();
    }

    public static void assertPermission(FileSystem fs, Path pathToCheck, short perm) throws IOException {
        Assert.assertEquals((long)perm, (long)fs.getFileStatus(pathToCheck).getPermission().toShort());
    }
}

