/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.ClusterJspHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestClusterJspHelper {
    private MiniDFSCluster cluster;
    private Configuration conf;

    @Before
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.cluster = new MiniDFSCluster.Builder(this.conf).build();
        this.cluster.waitClusterUp();
    }

    @After
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test(timeout=15000L)
    public void testClusterJspHelperReports() {
        ClusterJspHelper clusterJspHelper = new ClusterJspHelper(this.cluster.getNameNode());
        ClusterJspHelper.ClusterStatus clusterStatus = clusterJspHelper.generateClusterHealthReport();
        Assert.assertNotNull((String)"testClusterJspHelperReports ClusterStatus is null", (Object)clusterStatus);
        ClusterJspHelper.DecommissionStatus decommissionStatus = clusterJspHelper.generateDecommissioningReport();
        Assert.assertNotNull((String)"testClusterJspHelperReports DecommissionStatus is null", (Object)decommissionStatus);
    }
}

