/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import io.hops.common.IDsMonitor;
import io.hops.exception.StorageException;
import io.hops.leader_election.node.SortedActiveNodeListPBImpl;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.security.Users;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.lock.INodeLock;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.protocol.FSLimitException;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Time;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestFsLimits {
    static Configuration conf;
    static INode[] inodes;
    static FSDirectory fs;
    static boolean fsIsReady;
    static PermissionStatus perms;
    private static long id;

    private static FSNamesystem getMockNamesystem() {
        FSNamesystem fsn = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        Mockito.when((Object)fsn.createFsOwnerPermissions((FsPermission)Matchers.anyObject())).thenReturn((Object)new PermissionStatus("root", "wheel", FsPermission.getDefault()));
        NameNode nn = (NameNode)Mockito.mock(NameNode.class);
        Mockito.when((Object)nn.getActiveNameNodes()).thenReturn((Object)new SortedActiveNodeListPBImpl(Collections.EMPTY_LIST));
        Mockito.when((Object)fsn.getNameNode()).thenReturn((Object)nn);
        return fsn;
    }

    private void initFS() throws StorageException, IOException {
        HdfsStorageFactory.setConfiguration((Configuration)conf);
        assert (HdfsStorageFactory.formatStorage());
        Users.addUserToGroup((String)perms.getUserName(), (String)perms.getGroupName());
        IDsMonitor.getInstance().start();
        NameNode.initMetrics((Configuration)conf, (HdfsServerConstants.NamenodeRole)HdfsServerConstants.NamenodeRole.NAMENODE);
        fs = null;
        fsIsReady = true;
    }

    @Before
    public void setUp() throws IOException {
        conf = new Configuration();
        conf.setBoolean("dfs.namenode.quota.enabled", false);
        this.initFS();
    }

    @Test
    public void testNoLimits() throws Exception {
        this.mkdirs("/1", null);
        this.mkdirs("/22", null);
        this.mkdirs("/333", null);
        this.mkdirs("/4444", null);
        this.mkdirs("/55555", null);
    }

    @Test
    public void testMaxComponentLength() throws Exception {
        conf.setInt("dfs.namenode.fs-limits.max-component-length", 2);
        this.mkdirs("/1", null);
        this.mkdirs("/22", null);
        this.mkdirs("/333", FSLimitException.PathComponentTooLongException.class);
        this.mkdirs("/4444", FSLimitException.PathComponentTooLongException.class);
    }

    @Test
    public void testMaxComponentLengthRename() throws Exception {
        conf.setInt("dfs.namenode.fs-limits.max-component-length", 2);
        this.mkdirs("/5", null);
        this.rename("/5", "/555", FSLimitException.PathComponentTooLongException.class);
        this.rename("/5", "/55", null);
        this.mkdirs("/6", null);
        this.deprecatedRename("/6", "/666", FSLimitException.PathComponentTooLongException.class);
        this.deprecatedRename("/6", "/66", null);
    }

    @Test
    public void testMaxDirItems() throws Exception {
        conf.setInt("dfs.namenode.fs-limits.max-directory-items", 2);
        this.mkdirs("/1", null);
        this.mkdirs("/22", null);
        this.mkdirs("/333", FSLimitException.MaxDirectoryItemsExceededException.class);
        this.mkdirs("/4444", FSLimitException.MaxDirectoryItemsExceededException.class);
    }

    @Test
    public void testMaxDirItemsRename() throws Exception {
        conf.setInt("dfs.namenode.fs-limits.max-directory-items", 2);
        this.mkdirs("/1", null);
        this.mkdirs("/2", null);
        this.mkdirs("/2/A", null);
        this.rename("/2/A", "/A", FSLimitException.MaxDirectoryItemsExceededException.class);
        this.rename("/2/A", "/1/A", null);
        this.mkdirs("/2/B", null);
        this.deprecatedRename("/2/B", "/B", FSLimitException.MaxDirectoryItemsExceededException.class);
        this.deprecatedRename("/2/B", "/1/B", null);
        this.rename("/1", "/3", null);
        this.deprecatedRename("/2", "/4", null);
    }

    @Test
    public void testMaxDirItemsLimits() throws Exception {
        conf.setInt("dfs.namenode.fs-limits.max-directory-items", 0);
        try {
            this.mkdirs("/1", null);
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"Cannot set dfs", (Throwable)e);
        }
        conf.setInt("dfs.namenode.fs-limits.max-directory-items", 0x640000);
        try {
            this.mkdirs("/1", null);
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"Cannot set dfs", (Throwable)e);
        }
    }

    @Test
    public void testMaxComponentsAndMaxDirItems() throws Exception {
        conf.setInt("dfs.namenode.fs-limits.max-component-length", 3);
        conf.setInt("dfs.namenode.fs-limits.max-directory-items", 2);
        this.mkdirs("/1", null);
        this.mkdirs("/22", null);
        this.mkdirs("/333", FSLimitException.MaxDirectoryItemsExceededException.class);
        this.mkdirs("/4444", FSLimitException.PathComponentTooLongException.class);
    }

    @Test
    public void testDuringEditLogs() throws Exception {
        conf.setInt("dfs.namenode.fs-limits.max-component-length", 3);
        conf.setInt("dfs.namenode.fs-limits.max-directory-items", 2);
        fsIsReady = false;
        this.mkdirs("/1", null);
        this.mkdirs("/22", null);
        this.mkdirs("/333", null);
        this.mkdirs("/4444", null);
    }

    private void mkdirs(final String name, final Class<?> expected) throws Exception {
        TestFsLimits.lazyInitFSDirectory();
        HopsTransactionalRequestHandler handler = new HopsTransactionalRequestHandler(HDFSOperationType.TEST){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE_ON_TARGET_AND_PARENT, TransactionLockTypes.INodeResolveType.PATH, new String[]{name}).setNameNodeID(TestFsLimits.getMockNamesystem().getNameNode().getId()).setActiveNameNodes((Collection)TestFsLimits.getMockNamesystem().getNameNode().getActiveNameNodes().getActiveNodes());
                locks.add((Lock)il);
                locks.add(lf.getAcesLock());
            }

            public Object performTask() throws StorageException, IOException {
                Class<?> generated = null;
                try {
                    fs.mkdirs(name, perms, false, Time.now());
                }
                catch (Throwable e) {
                    generated = e.getClass();
                }
                Assert.assertEquals((Object)expected, generated);
                return null;
            }
        };
        handler.handle();
    }

    private void rename(final String src, final String dst, final Class<?> expected) throws Exception {
        TestFsLimits.lazyInitFSDirectory();
        new HopsTransactionalRequestHandler(HDFSOperationType.RENAME, src){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getRenameINodeLock(TransactionLockTypes.INodeLockType.WRITE_ON_TARGET_AND_PARENT, TransactionLockTypes.INodeResolveType.PATH, src, dst).setNameNodeID(TestFsLimits.getMockNamesystem().getNameNode().getId()).setActiveNameNodes((Collection)TestFsLimits.getMockNamesystem().getNameNode().getActiveNameNodes().getActiveNodes());
                locks.add((Lock)il);
                locks.add(lf.getAcesLock());
            }

            public Object performTask() throws IOException {
                Class<?> generated = null;
                try {
                    fs.renameTo(src, dst, new INode.DirCounts(), new INode.DirCounts(), new Options.Rename[0]);
                }
                catch (Throwable e) {
                    LOG.error((Object)e, e);
                    generated = e.getClass();
                }
                Assert.assertEquals((Object)expected, generated);
                return null;
            }
        }.handle();
    }

    private void deprecatedRename(final String src, final String dst, final Class<?> expected) throws Exception {
        TestFsLimits.lazyInitFSDirectory();
        new HopsTransactionalRequestHandler(HDFSOperationType.RENAME, src){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getRenameINodeLock(TransactionLockTypes.INodeLockType.WRITE_ON_TARGET_AND_PARENT, TransactionLockTypes.INodeResolveType.PATH, src, dst).setNameNodeID(TestFsLimits.getMockNamesystem().getNameNode().getId()).setActiveNameNodes((Collection)TestFsLimits.getMockNamesystem().getNameNode().getActiveNameNodes().getActiveNodes());
                locks.add((Lock)il);
                locks.add(lf.getAcesLock());
            }

            public Object performTask() throws IOException {
                Class<?> generated = null;
                try {
                    fs.renameTo(src, dst, new INode.DirCounts(), new INode.DirCounts());
                }
                catch (Throwable e) {
                    generated = e.getClass();
                }
                Assert.assertEquals((Object)expected, generated);
                return null;
            }
        }.handle();
    }

    private static void lazyInitFSDirectory() throws IOException {
        if (fs == null) {
            fs = new MockFSDirectory();
        }
    }

    static {
        perms = new PermissionStatus("admin", "admin", FsPermission.getDefault());
        id = 2L;
    }

    private static class MockFSDirectory
    extends FSDirectory {
        public MockFSDirectory() throws IOException {
            super(TestFsLimits.getMockNamesystem(), conf);
            this.setReady(fsIsReady);
        }
    }
}

