/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import io.hops.metadata.HdfsVariables;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSClientAdapter;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.log4j.Level;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.internal.util.reflection.Whitebox;

public class TestHASafeMode {
    private static final Log LOG = LogFactory.getLog(TestHASafeMode.class);
    private static final int BLOCK_SIZE = 1024;
    private NameNode nn0;
    private NameNode nn1;
    private FileSystem fs;
    private MiniDFSCluster cluster;

    @Before
    public void setupCluster() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("dfs.blocksize", 1024);
        conf.setInt("dfs.heartbeat.interval", 1);
        this.cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleHOPSTopology(2)).numDataNodes(3).waitSafeMode(false).build();
        this.cluster.waitActive();
        this.nn0 = this.cluster.getNameNode(0);
        this.nn1 = this.cluster.getNameNode(1);
        this.fs = this.cluster.getFileSystem(0);
        this.cluster.waitActive();
    }

    @After
    public void shutdownCluster() {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testClientRetrySafeMode() throws Exception {
        final Map results = Collections.synchronizedMap(new HashMap());
        final Path test = new Path("/test");
        NameNodeAdapter.enterSafeMode(this.nn0, false);
        NameNodeAdapter.enterSafeMode(this.nn1, false);
        FSNamesystem.SafeModeInfo safeMode = this.nn0.getNamesystem().getSafeModeInfoForTests();
        Whitebox.setInternalState((Object)safeMode, (String)"extension", (Object)30000);
        HdfsVariables.setSafeModeInfo((FSNamesystem.SafeModeInfo)safeMode, (long)safeMode.getReached());
        LOG.info((Object)"enter safemode");
        Thread testThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    boolean mkdir = TestHASafeMode.this.fs.mkdirs(test);
                    LOG.info((Object)("mkdir finished, result is " + mkdir));
                    TestHASafeMode testHASafeMode = TestHASafeMode.this;
                    synchronized (testHASafeMode) {
                        results.put(test, mkdir);
                        TestHASafeMode.this.notifyAll();
                    }
                }
                catch (Exception e) {
                    LOG.info((Object)"Got Exception while calling mkdir", (Throwable)e);
                }
            }
        };
        testThread.setName("test");
        testThread.start();
        Assert.assertFalse((String)"The directory should not be created while NN in safemode", (boolean)this.fs.exists(test));
        Thread.sleep(1000L);
        NameNodeAdapter.leaveSafeMode(this.nn0);
        LOG.info((Object)"leave safemode");
        TestHASafeMode testHASafeMode = this;
        synchronized (testHASafeMode) {
            while (!results.containsKey(test)) {
                this.wait();
            }
            Assert.assertTrue((boolean)((Boolean)results.get(test)));
        }
    }

    static void banner(String string) {
        LOG.info((Object)("\n\n\n\n================================================\n" + string + "\n==================================================\n\n"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=100000L)
    public void testOpenFileWhenNNAndClientCrashAfterAddBlock() throws Exception {
        this.cluster.getConfiguration(0).set("dfs.namenode.safemode.threshold-pct", "1.0f");
        String testData = "testData";
        this.cluster.getConfiguration(0).setInt("io.bytes.per.checksum", testData.length());
        this.cluster.getConfiguration(1).setInt("dfs.bytes-per-checksum", testData.length());
        this.cluster.restartNameNode(0);
        this.cluster.restartNameNode(1);
        try {
            this.cluster.waitActive();
            DistributedFileSystem dfs = (DistributedFileSystem)this.cluster.getNewFileSystemInstance(0);
            String pathString = "/tmp1.txt";
            Path filePath = new Path(pathString);
            FSDataOutputStream create = dfs.create(filePath, FsPermission.getDefault(), true, 1024, (short)3, (long)testData.length(), null);
            create.write(testData.getBytes());
            create.hflush();
            DFSClient client = DFSClientAdapter.getClient(dfs);
            ExtendedBlock previousBlock = DFSClientAdapter.getPreviousBlock(client, pathString);
            DFSClientAdapter.getNamenode(client).addBlock(pathString, client.getClientName(), new ExtendedBlock(previousBlock), new DatanodeInfo[0], DFSClientAdapter.getFileId((DFSOutputStream)create.getWrappedStream()), null);
            this.cluster.restartNameNode(0, true);
            this.cluster.restartNameNode(1, true);
            this.cluster.restartDataNode(0);
            this.cluster.waitActive();
            Thread.sleep(2000L);
            FSDataInputStream is = dfs.open(filePath);
            is.close();
            dfs.recoverLease(filePath);
            for (int i = 0; i < 10 && !dfs.recoverLease(filePath); ++i) {
                Thread.sleep(1000L);
            }
            Assert.assertTrue((String)"Recovery also should be success", (boolean)dfs.recoverLease(filePath));
        }
        finally {
            this.cluster.shutdown();
        }
    }

    static {
        ((Log4JLogger)LogFactory.getLog(FSNamesystem.class)).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)NameNode.stateChangeLog).getLogger().setLevel(Level.ALL);
    }
}

