/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.FSAclBaseTest;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.hdfs.web.WebHdfsTestUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class TestWebHDFSAcl
extends FSAclBaseTest {
    @BeforeClass
    public static void init() throws Exception {
        conf = WebHdfsTestUtil.createConf();
        conf.setBoolean("dfs.namenode.acls.enabled", true);
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        cluster.waitActive();
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        Assert.assertTrue((boolean)(fs instanceof WebHdfsFileSystem));
    }

    @Override
    protected FileSystem createFileSystem() throws Exception {
        return WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs");
    }

    @Override
    protected FileSystem createFileSystem(UserGroupInformation user) throws Exception {
        return WebHdfsTestUtil.getWebHdfsFileSystemAs(user, conf, "webhdfs");
    }

    @Override
    @Test
    @Ignore
    public void testDefaultAclNewSymlinkIntermediate() {
    }
}

