/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestWrapper;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class TestPermissionSymlinks {
    private static final Log LOG = LogFactory.getLog(TestPermissionSymlinks.class);
    private static final Configuration conf = new HdfsConfiguration();
    private static final UserGroupInformation user = UserGroupInformation.createRemoteUser((String)"myuser");
    private static final Path linkParent = new Path("/symtest1");
    private static final Path targetParent = new Path("/symtest2");
    private static final Path link = new Path(linkParent, "link");
    private static final Path target = new Path(targetParent, "target");
    private static MiniDFSCluster cluster;
    private static FileSystem fs;
    private static FileSystemTestWrapper wrapper;

    @BeforeClass
    public static void beforeClassSetUp() throws Exception {
        conf.setBoolean("dfs.permissions.enabled", true);
        conf.set("fs.permissions.umask-mode", "000");
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
        cluster.waitActive();
        fs = cluster.getFileSystem();
        wrapper = new FileSystemTestWrapper(fs);
    }

    @AfterClass
    public static void afterClassTearDown() throws Exception {
        if (fs != null) {
            fs.close();
        }
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Before
    public void setUp() throws Exception {
        fs.mkdirs(linkParent);
        fs.mkdirs(targetParent);
        DFSTestUtil.createFile(fs, target, 1024L, (short)3, 48879L);
        wrapper.createSymlink(target, link, false);
    }

    @After
    public void tearDown() throws Exception {
        fs.delete(linkParent, true);
        fs.delete(targetParent, true);
    }

    @Ignore
    @Test(timeout=5000L)
    public void testDelete() throws Exception {
        fs.setPermission(linkParent, new FsPermission(365));
        try {
            user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws IOException {
                    FileContext myfc = FileContext.getFileContext((Configuration)conf);
                    myfc.delete(link, false);
                    return null;
                }
            });
            Assert.fail((String)"Deleted symlink without write permissions on parent!");
        }
        catch (AccessControlException e) {
            GenericTestUtils.assertExceptionContains((String)"Permission denied", (Throwable)e);
        }
        fs.setPermission(linkParent, new FsPermission(511));
        fs.setPermission(targetParent, new FsPermission(365));
        fs.setPermission(target, new FsPermission(365));
        user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws IOException {
                FileContext myfc = FileContext.getFileContext((Configuration)conf);
                myfc.delete(link, false);
                return null;
            }
        });
        Assert.assertTrue((String)"Target should not have been deleted!", (boolean)wrapper.exists(target));
        Assert.assertFalse((String)"Link should have been deleted!", (boolean)wrapper.exists(link));
    }

    @Ignore
    @Test(timeout=5000L)
    public void testReadWhenTargetNotReadable() throws Exception {
        fs.setPermission(target, new FsPermission(0));
        try {
            user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws IOException {
                    FileContext myfc = FileContext.getFileContext((Configuration)conf);
                    myfc.open(link).read();
                    return null;
                }
            });
            Assert.fail((String)"Read link target even though target does not have read permissions!");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"Permission denied", (Throwable)e);
        }
    }

    @Ignore
    @Test(timeout=5000L)
    public void testFileStatus() throws Exception {
        fs.setPermission(target, new FsPermission(0));
        user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws IOException {
                FileContext myfc = FileContext.getFileContext((Configuration)conf);
                FileStatus stat = myfc.getFileLinkStatus(link);
                Assert.assertEquals((String)"Expected link's FileStatus path to match link!", (Object)link.makeQualified(fs.getUri(), fs.getWorkingDirectory()), (Object)stat.getPath());
                Path linkTarget = myfc.getLinkTarget(link);
                Assert.assertEquals((String)"Expected link's target to match target!", (Object)target, (Object)linkTarget);
                return null;
            }
        });
    }

    @Ignore
    @Test(timeout=5000L)
    public void testRenameLinkTargetNotWritableFC() throws Exception {
        fs.setPermission(target, new FsPermission(365));
        fs.setPermission(targetParent, new FsPermission(365));
        user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws IOException {
                FileContext myfc = FileContext.getFileContext((Configuration)conf);
                Path newlink = new Path(linkParent, "newlink");
                myfc.rename(link, newlink, new Options.Rename[]{Options.Rename.NONE});
                Path linkTarget = myfc.getLinkTarget(newlink);
                Assert.assertEquals((String)"Expected link's target to match target!", (Object)target, (Object)linkTarget);
                return null;
            }
        });
        Assert.assertTrue((String)"Expected target to exist", (boolean)wrapper.exists(target));
    }

    @Ignore
    @Test(timeout=5000L)
    public void testRenameSrcNotWritableFC() throws Exception {
        fs.setPermission(linkParent, new FsPermission(365));
        try {
            user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws IOException {
                    FileContext myfc = FileContext.getFileContext((Configuration)conf);
                    Path newlink = new Path(targetParent, "newlink");
                    myfc.rename(link, newlink, new Options.Rename[]{Options.Rename.NONE});
                    return null;
                }
            });
            Assert.fail((String)"Renamed link even though link's parent is not writable!");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"Permission denied", (Throwable)e);
        }
    }

    @Ignore
    @Test(timeout=5000L)
    public void testRenameLinkTargetNotWritableFS() throws Exception {
        fs.setPermission(target, new FsPermission(365));
        fs.setPermission(targetParent, new FsPermission(365));
        user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws IOException {
                FileSystem myfs = FileSystem.get((Configuration)conf);
                Path newlink = new Path(linkParent, "newlink");
                myfs.rename(link, newlink);
                Path linkTarget = myfs.getLinkTarget(newlink);
                Assert.assertEquals((String)"Expected link's target to match target!", (Object)target, (Object)linkTarget);
                return null;
            }
        });
        Assert.assertTrue((String)"Expected target to exist", (boolean)wrapper.exists(target));
    }

    @Ignore
    @Test(timeout=5000L)
    public void testRenameSrcNotWritableFS() throws Exception {
        fs.setPermission(linkParent, new FsPermission(365));
        try {
            user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws IOException {
                    FileSystem myfs = FileSystem.get((Configuration)conf);
                    Path newlink = new Path(targetParent, "newlink");
                    myfs.rename(link, newlink);
                    return null;
                }
            });
            Assert.fail((String)"Renamed link even though link's parent is not writable!");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"Permission denied", (Throwable)e);
        }
    }
}

