/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.adaptor;

import io.hops.exception.StorageException;
import io.hops.metadata.DalAdaptor;
import io.hops.metadata.hdfs.dal.BlockInfoDataAccess;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoUnderConstruction;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;

public class BlockInfoDALAdaptor
extends DalAdaptor<BlockInfo, io.hops.metadata.hdfs.entity.BlockInfo>
implements BlockInfoDataAccess<BlockInfo> {
    private final BlockInfoDataAccess<io.hops.metadata.hdfs.entity.BlockInfo> dataAccess;

    public BlockInfoDALAdaptor(BlockInfoDataAccess<io.hops.metadata.hdfs.entity.BlockInfo> dataAccess) {
        this.dataAccess = dataAccess;
    }

    public int countAll() throws StorageException {
        return this.dataAccess.countAll();
    }

    public int countAllCompleteBlocks() throws StorageException {
        return this.dataAccess.countAllCompleteBlocks();
    }

    public BlockInfo findById(long blockId, long inodeId) throws StorageException {
        return this.convertDALtoHDFS((io.hops.metadata.hdfs.entity.BlockInfo)this.dataAccess.findById(blockId, inodeId));
    }

    public List<BlockInfo> findByInodeId(long id) throws StorageException {
        return (List)this.convertDALtoHDFS(this.dataAccess.findByInodeId(id));
    }

    public List<BlockInfo> findByInodeIds(long[] inodeIds) throws StorageException {
        return (List)this.convertDALtoHDFS(this.dataAccess.findByInodeIds(inodeIds));
    }

    public List<BlockInfo> findAllBlocks() throws StorageException {
        return (List)this.convertDALtoHDFS(this.dataAccess.findAllBlocks());
    }

    public List<BlockInfo> findBlockInfosByStorageId(int storageId) throws StorageException {
        return (List)this.convertDALtoHDFS(this.dataAccess.findBlockInfosByStorageId(storageId));
    }

    public List<BlockInfo> findBlockInfosByStorageId(int storageId, long from, int size) throws StorageException {
        return (List)this.convertDALtoHDFS(this.dataAccess.findBlockInfosByStorageId(storageId, from, size));
    }

    public List<BlockInfo> findBlockInfosBySids(List<Integer> sids) throws StorageException {
        return (List)this.convertDALtoHDFS(this.dataAccess.findBlockInfosBySids(sids));
    }

    public Set<Long> findINodeIdsByStorageId(int storageId) throws StorageException {
        return this.dataAccess.findINodeIdsByStorageId(storageId);
    }

    public List<BlockInfo> findByIds(long[] blockIds, long[] inodeIds) throws StorageException {
        return (List)this.convertDALtoHDFS(this.dataAccess.findByIds(blockIds, inodeIds));
    }

    public boolean existsOnAnyStorage(long inodeId, long blockId, List<Integer> sids) throws StorageException {
        return this.dataAccess.existsOnAnyStorage(inodeId, blockId, sids);
    }

    public void prepare(Collection<BlockInfo> removed, Collection<BlockInfo> newed, Collection<BlockInfo> modified) throws StorageException {
        this.dataAccess.prepare(this.convertHDFStoDAL(removed), this.convertHDFStoDAL(newed), this.convertHDFStoDAL(modified));
    }

    public io.hops.metadata.hdfs.entity.BlockInfo convertHDFStoDAL(BlockInfo hdfsClass) throws StorageException {
        if (hdfsClass != null) {
            io.hops.metadata.hdfs.entity.BlockInfo hopBlkInfo = new io.hops.metadata.hdfs.entity.BlockInfo(hdfsClass.getBlockId(), hdfsClass.getBlockIndex(), hdfsClass.getInodeId(), hdfsClass.getNumBytes(), hdfsClass.getGenerationStamp(), hdfsClass.getBlockUCState().ordinal(), hdfsClass.getTimestamp());
            if (hdfsClass instanceof BlockInfoUnderConstruction) {
                BlockInfoUnderConstruction ucBlock = (BlockInfoUnderConstruction)hdfsClass;
                hopBlkInfo.setPrimaryNodeIndex(ucBlock.getPrimaryNodeIndex());
                hopBlkInfo.setBlockRecoveryId(ucBlock.getBlockRecoveryId());
            }
            return hopBlkInfo;
        }
        return null;
    }

    public BlockInfo convertDALtoHDFS(io.hops.metadata.hdfs.entity.BlockInfo dalClass) throws StorageException {
        if (dalClass != null) {
            Block b = new Block(dalClass.getBlockId(), dalClass.getNumBytes(), dalClass.getGenerationStamp());
            BlockInfo blockInfo = null;
            if (dalClass.getBlockUCState() > 0) {
                blockInfo = new BlockInfoUnderConstruction(b, dalClass.getInodeId());
                ((BlockInfoUnderConstruction)blockInfo).setBlockUCStateNoPersistance(HdfsServerConstants.BlockUCState.values()[dalClass.getBlockUCState()]);
                ((BlockInfoUnderConstruction)blockInfo).setPrimaryNodeIndexNoPersistance(dalClass.getPrimaryNodeIndex());
                ((BlockInfoUnderConstruction)blockInfo).setBlockRecoveryIdNoPersistance(dalClass.getBlockRecoveryId());
            } else if (dalClass.getBlockUCState() == HdfsServerConstants.BlockUCState.COMPLETE.ordinal()) {
                blockInfo = new BlockInfo(b, dalClass.getInodeId());
            } else {
                return null;
            }
            blockInfo.setINodeIdNoPersistance(dalClass.getInodeId());
            blockInfo.setTimestampNoPersistance(dalClass.getTimeStamp());
            blockInfo.setBlockIndexNoPersistance(dalClass.getBlockIndex());
            return blockInfo;
        }
        return null;
    }
}

