/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.context;

import io.hops.exception.StorageCallPreventedException;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.dal.INodeAttributesDataAccess;
import io.hops.metadata.hdfs.entity.INodeCandidatePrimaryKey;
import io.hops.transaction.context.BaseEntityContext;
import io.hops.transaction.context.HdfsTransactionContextMaintenanceCmds;
import io.hops.transaction.context.TransactionContextMaintenanceCmds;
import io.hops.transaction.lock.TransactionLocks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributes;
import org.apache.hadoop.hdfs.server.namenode.Quota;

public class INodeAttributesContext
extends BaseEntityContext<Long, INodeAttributes> {
    private final INodeAttributesDataAccess<INodeAttributes> dataAccess;

    public INodeAttributesContext(INodeAttributesDataAccess<INodeAttributes> dataAccess) {
        this.dataAccess = dataAccess;
    }

    public void update(INodeAttributes iNodeAttributes) throws TransactionContextException {
        if (iNodeAttributes.isInTree()) {
            super.update((Object)iNodeAttributes);
            if (this.isLogDebugEnabled()) {
                this.log("updated-attributes", new Object[]{"id", iNodeAttributes.getInodeId(), "DSQ", iNodeAttributes.getQuotaCounts().get(Quota.DISKSPACE), "DS", iNodeAttributes.getDiskspace(), "NSQ", iNodeAttributes.getQuotaCounts().get(Quota.NAMESPACE), "NS", iNodeAttributes.getNsCount()});
            }
        } else if (this.isLogDebugEnabled()) {
            this.log("updated-attributes -- IGNORED as id is not set", new Object[0]);
        }
    }

    public void remove(INodeAttributes iNodeAttributes) throws TransactionContextException {
        super.remove((Object)iNodeAttributes);
        if (this.isLogDebugEnabled()) {
            this.log("removed-attributes", new Object[]{"id", iNodeAttributes.getInodeId()});
            for (int i = 0; i < Thread.currentThread().getStackTrace().length; ++i) {
                System.out.println(Thread.currentThread().getStackTrace()[i]);
            }
        }
    }

    public INodeAttributes find(FinderType<INodeAttributes> finder, Object ... params) throws TransactionContextException, StorageException {
        INodeAttributes.Finder qfinder = (INodeAttributes.Finder)finder;
        switch (qfinder) {
            case ByINodeId: {
                return this.findByPrimaryKey(qfinder, params);
            }
        }
        throw new UnsupportedOperationException(UNSUPPORTED_FINDER);
    }

    public Collection<INodeAttributes> findList(FinderType<INodeAttributes> finder, Object ... params) throws TransactionContextException, StorageException {
        INodeAttributes.Finder qfinder = (INodeAttributes.Finder)finder;
        switch (qfinder) {
            case ByINodeIds: {
                return this.findByPrimaryKeys(qfinder, params);
            }
        }
        throw new UnsupportedOperationException(UNSUPPORTED_FINDER);
    }

    public void prepare(TransactionLocks tlm) throws TransactionContextException, StorageException {
        ArrayList modified = new ArrayList(this.getModified());
        modified.addAll(this.getAdded());
        this.dataAccess.prepare(modified, this.getRemoved());
    }

    Long getKey(INodeAttributes iNodeAttributes) {
        return iNodeAttributes.getInodeId();
    }

    public void snapshotMaintenance(TransactionContextMaintenanceCmds cmds, Object ... params) throws TransactionContextException {
        HdfsTransactionContextMaintenanceCmds hopCmds = (HdfsTransactionContextMaintenanceCmds)cmds;
        switch (hopCmds) {
            case INodePKChanged: {
                INode inodeBeforeChange = (INode)params[0];
                INode inodeAfterChange = (INode)params[1];
                break;
            }
            case Concat: {
                INodeCandidatePrimaryKey trg_param = (INodeCandidatePrimaryKey)params[0];
                List srcs_param = (List)params[1];
                List oldBlks = (List)params[2];
                this.updateAttributes(trg_param, srcs_param);
            }
        }
    }

    private INodeAttributes findByPrimaryKey(INodeAttributes.Finder qfinder, Object[] params) throws StorageCallPreventedException, StorageException {
        long inodeId = (Long)params[0];
        INodeAttributes result = null;
        if (this.contains(inodeId)) {
            result = (INodeAttributes)this.get(inodeId);
            this.hit(qfinder, result, new Object[]{"inodeid", inodeId});
        } else {
            this.aboutToAccessStorage(qfinder, params);
            result = (INodeAttributes)this.dataAccess.findAttributesByPk(Long.valueOf(inodeId));
            this.gotFromDB(inodeId, result);
            this.miss(qfinder, result, new Object[]{"inodeid", inodeId, "size", this.size()});
        }
        return result;
    }

    private Collection<INodeAttributes> findByPrimaryKeys(INodeAttributes.Finder qfinder, Object[] params) throws StorageCallPreventedException, StorageException {
        List inodePks = (List)params[0];
        Collection result = null;
        if (this.contains(inodePks)) {
            result = this.get(inodePks);
            this.hit(qfinder, result, new Object[]{"inodeids", inodePks});
        } else {
            this.aboutToAccessStorage(qfinder, new Object[]{inodePks});
            result = this.dataAccess.findAttributesByPkList(inodePks);
            this.gotFromDB(result);
            this.miss(qfinder, result, new Object[]{"inodeids", inodePks});
            if (result != null) {
                for (INodeAttributes iNodeAttributes : result) {
                    this.log("read-attributes", new Object[]{"id", iNodeAttributes.getInodeId(), "DSQ", iNodeAttributes.getQuotaCounts().get(Quota.DISKSPACE), "DS", iNodeAttributes.getDiskspace(), "NSQ", iNodeAttributes.getQuotaCounts().get(Quota.NAMESPACE), "NS", iNodeAttributes.getNsCount()});
                }
            }
        }
        return result;
    }

    private boolean contains(List<INodeCandidatePrimaryKey> iNodeCandidatePKs) {
        for (INodeCandidatePrimaryKey pk : iNodeCandidatePKs) {
            if (this.contains(pk.getInodeId())) continue;
            return false;
        }
        return true;
    }

    private Collection<INodeAttributes> get(List<INodeCandidatePrimaryKey> iNodeCandidatePKs) {
        ArrayList<INodeAttributes> iNodeAttributeses = new ArrayList<INodeAttributes>(iNodeCandidatePKs.size());
        for (INodeCandidatePrimaryKey pk : iNodeCandidatePKs) {
            iNodeAttributeses.add((INodeAttributes)this.get(pk.getInodeId()));
        }
        return iNodeAttributeses;
    }

    private void updateAttributes(INodeCandidatePrimaryKey trg_param, List<INodeCandidatePrimaryKey> toBeDeletedSrcs) throws TransactionContextException {
        toBeDeletedSrcs.remove(trg_param);
        for (INodeCandidatePrimaryKey src : toBeDeletedSrcs) {
            if (!this.contains(src.getInodeId())) continue;
            INodeAttributes toBeDeleted = (INodeAttributes)this.get(src.getInodeId());
            INodeAttributes toBeAdded = this.clone(toBeDeleted, trg_param.getInodeId());
            this.remove(toBeDeleted);
            if (this.isLogDebugEnabled()) {
                this.log("snapshot-maintenance-removed-inode-attribute", new Object[]{"inodeId", toBeDeleted.getInodeId()});
            }
            this.add(toBeAdded);
            if (!this.isLogDebugEnabled()) continue;
            this.log("snapshot-maintenance-added-inode-attribute", new Object[]{"inodeId", toBeAdded.getInodeId()});
        }
    }

    private INodeAttributes clone(INodeAttributes src, long inodeId) {
        return new INodeAttributes(inodeId, src.getQuotaCounts().get(Quota.NAMESPACE), src.getNsCount(), src.getQuotaCounts().get(Quota.DISKSPACE), src.getDiskspace());
    }
}

