/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.lock;

import com.google.common.base.Joiner;
import io.hops.common.INodeResolver;
import io.hops.common.INodeUtil;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.exception.TransientStorageException;
import io.hops.leader_election.node.ActiveNode;
import io.hops.metadata.hdfs.entity.INodeIdentifier;
import io.hops.resolvingcache.Cache;
import io.hops.transaction.lock.BaseINodeLock;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.SubtreeLockHelper;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.stat.StatUtils;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.UnresolvedPathException;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.LeaseExpiredException;
import org.apache.hadoop.ipc.RetriableException;

public class INodeLock
extends BaseINodeLock {
    private final TransactionLockTypes.INodeLockType lockType;
    private final TransactionLockTypes.INodeResolveType resolveType;
    private boolean resolveLink;
    protected final String[] paths;
    protected final long inodeId;
    private Collection<Long> ignoredSTOInodes;
    protected boolean skipReadingQuotaAttr;
    protected long namenodeId;
    protected Collection<ActiveNode> activeNamenodes;
    private CacheResolver instance = null;

    INodeLock(TransactionLockTypes.INodeLockType lockType, TransactionLockTypes.INodeResolveType resolveType, String ... paths) {
        this.lockType = lockType;
        this.resolveType = resolveType;
        this.resolveLink = false;
        this.activeNamenodes = null;
        this.ignoredSTOInodes = new ArrayList<Long>();
        this.namenodeId = -1L;
        this.paths = paths;
        this.inodeId = -1L;
        this.skipReadingQuotaAttr = false;
    }

    INodeLock(TransactionLockTypes.INodeLockType lockType, TransactionLockTypes.INodeResolveType resolveType, long inodeId) {
        this.lockType = lockType;
        this.resolveType = resolveType;
        this.resolveLink = false;
        this.activeNamenodes = null;
        this.ignoredSTOInodes = new ArrayList<Long>();
        this.namenodeId = -1L;
        this.paths = null;
        this.inodeId = inodeId;
        this.skipReadingQuotaAttr = false;
    }

    public INodeLock setIgnoredSTOInodes(long inodeID) {
        this.ignoredSTOInodes.add(inodeID);
        return this;
    }

    public INodeLock setNameNodeID(long nnID) {
        this.namenodeId = nnID;
        return this;
    }

    public INodeLock setActiveNameNodes(Collection<ActiveNode> activeNamenodes) {
        this.activeNamenodes = activeNamenodes;
        return this;
    }

    public INodeLock skipReadingQuotaAttr(boolean val) {
        this.skipReadingQuotaAttr = val;
        return this;
    }

    public INodeLock resolveSymLink(boolean resolveLink) {
        this.resolveLink = resolveLink;
        return this;
    }

    private CacheResolver getCacheResolver() {
        if (this.instance == null) {
            this.instance = new PathResolver();
        }
        return this.instance;
    }

    protected void acquire(TransactionLocks locks) throws IOException {
        if (this.paths != null) {
            Arrays.sort(this.paths);
            this.acquirePathsINodeLocks();
        } else {
            this.acquireInodeIdInodeLock();
        }
        if (!this.skipReadingQuotaAttr) {
            this.acquireINodeAttributes();
        }
    }

    protected void acquireInodeIdInodeLock() throws IOException {
        if (!(this.resolveType.equals((Object)TransactionLockTypes.INodeResolveType.PATH) || this.resolveType.equals((Object)TransactionLockTypes.INodeResolveType.PATH_AND_IMMEDIATE_CHILDREN) || this.resolveType.equals((Object)TransactionLockTypes.INodeResolveType.PATH_AND_ALL_CHILDREN_RECURSIVELY))) {
            throw new IllegalArgumentException("Unknown type " + this.resolveType.name());
        }
        List<INode> resolvedINodes = this.resolveUsingCache(this.inodeId);
        String path = INodeUtil.constructPath(resolvedINodes);
        this.addPathINodesAndUpdateResolvingCache(path, resolvedINodes);
        if (resolvedINodes.size() > 0) {
            INode lastINode = resolvedINodes.get(resolvedINodes.size() - 1);
            if (this.resolveType == TransactionLockTypes.INodeResolveType.PATH_AND_IMMEDIATE_CHILDREN) {
                List<INode> children = this.findImmediateChildren(lastINode);
                this.addChildINodes(path, children);
            } else if (this.resolveType == TransactionLockTypes.INodeResolveType.PATH_AND_ALL_CHILDREN_RECURSIVELY) {
                List<INode> children = this.findChildrenRecursively(lastINode);
                this.addChildINodes(path, children);
            }
        }
    }

    protected void acquirePathsINodeLocks() throws IOException {
        if (!(this.resolveType.equals((Object)TransactionLockTypes.INodeResolveType.PATH) || this.resolveType.equals((Object)TransactionLockTypes.INodeResolveType.PATH_AND_IMMEDIATE_CHILDREN) || this.resolveType.equals((Object)TransactionLockTypes.INodeResolveType.PATH_AND_ALL_CHILDREN_RECURSIVELY))) {
            throw new IllegalArgumentException("Unknown type " + this.resolveType.name());
        }
        for (String path : this.paths) {
            List<INode> children;
            List<INode> resolvedINodes = null;
            if (this.getDefaultInodeLockType() == TransactionLockTypes.INodeLockType.READ_COMMITTED) {
                resolvedINodes = this.resolveUsingCache(path);
            }
            if (resolvedINodes == null) {
                if (setRandomParitionKeyEnabled) {
                    this.setPartitioningKey(rand.nextLong());
                }
                resolvedINodes = this.acquireINodeLockByPath(path);
                this.addPathINodesAndUpdateResolvingCache(path, resolvedINodes);
            }
            if (resolvedINodes.size() <= 0) continue;
            INode lastINode = resolvedINodes.get(resolvedINodes.size() - 1);
            if (this.resolveType == TransactionLockTypes.INodeResolveType.PATH_AND_IMMEDIATE_CHILDREN) {
                children = this.findImmediateChildren(lastINode);
                this.addChildINodes(path, children);
                continue;
            }
            if (this.resolveType != TransactionLockTypes.INodeResolveType.PATH_AND_ALL_CHILDREN_RECURSIVELY) continue;
            children = this.findChildrenRecursively(lastINode);
            this.addChildINodes(path, children);
        }
    }

    private List<INode> resolveUsingCache(long inodeId) throws IOException {
        CacheResolver cacheResolver = this.getCacheResolver();
        List<INode> resolvedINodes = cacheResolver.fetchINodes(inodeId);
        if (resolvedINodes != null) {
            for (INode iNode : resolvedINodes) {
                if (iNode == null) continue;
                this.checkSubtreeLock(iNode);
            }
        }
        return resolvedINodes;
    }

    private List<INode> resolveUsingCache(String path) throws IOException {
        CacheResolver cacheResolver = this.getCacheResolver();
        if (cacheResolver == null) {
            return null;
        }
        List<INode> resolvedINodes = cacheResolver.fetchINodes(path);
        if (resolvedINodes != null) {
            for (INode iNode : resolvedINodes) {
                if (iNode == null) continue;
                this.checkSubtreeLock(iNode);
            }
            this.handleLockUpgrade(resolvedINodes, INode.getPathComponents(path), path);
        }
        return resolvedINodes;
    }

    private List<INode> acquireINodeLockByPath(String path) throws UnresolvedPathException, StorageException, RetriableException, TransactionContextException {
        ArrayList<INode> resolvedINodes = new ArrayList<INode>();
        byte[][] components = INode.getPathComponents(path);
        if (this.isRootTarget(components)) {
            resolvedINodes.add(this.acquireLockOnRoot(this.lockType));
            return resolvedINodes;
        }
        INode currentINode = this.isRootParent(components) && TransactionLockTypes.impliesParentWriteLock((TransactionLockTypes.INodeLockType)this.lockType) ? this.acquireLockOnRoot(this.lockType) : this.acquireLockOnRoot(this.getDefaultInodeLockType());
        resolvedINodes.add(currentINode);
        INodeResolver resolver = new INodeResolver(components, currentINode, this.resolveLink, true);
        while (resolver.hasNext()) {
            TransactionLockTypes.INodeLockType currentINodeLock = this.identifyLockType(resolver.getCount() + 1, components);
            this.setINodeLockType(currentINodeLock);
            currentINode = resolver.next();
            if (currentINode == null) continue;
            this.addLockedINodes(currentINode, currentINodeLock);
            this.checkSubtreeLock(currentINode);
            resolvedINodes.add(currentINode);
        }
        this.handleLockUpgrade(resolvedINodes, components, path);
        return resolvedINodes;
    }

    private boolean isRootTarget(byte[][] components) {
        return this.isTarget(0, components);
    }

    private boolean isRootParent(byte[][] components) {
        return this.isParent(0, components);
    }

    private TransactionLockTypes.INodeLockType identifyLockType(int count, byte[][] components) {
        TransactionLockTypes.INodeLockType lkType = this.isTarget(count, components) ? this.lockType : (this.isParent(count, components) && TransactionLockTypes.impliesParentWriteLock((TransactionLockTypes.INodeLockType)this.lockType) ? TransactionLockTypes.INodeLockType.WRITE : this.getDefaultInodeLockType());
        return lkType;
    }

    private boolean isTarget(int count, byte[][] components) {
        return count == components.length - 1;
    }

    private boolean isParent(int count, byte[][] components) {
        return count == components.length - 2;
    }

    private void checkSubtreeLock(INode iNode) throws RetriableException {
        if (SubtreeLockHelper.isSTOLocked(iNode.isSTOLocked(), iNode.getSTOLockOwner(), this.activeNamenodes)) {
            if (!this.ignoredSTOInodes.contains(iNode.getId())) {
                throw new RetriableException("The subtree " + iNode.getLocalName() + " is locked by Namenode Id: " + iNode.getSTOLockOwner() + ". Active Namenodes are: " + this.activeNamenodes);
            }
            LOG.debug((Object)("Ignoring subtree lock for inode id: " + iNode.getId()));
        }
    }

    private void handleLockUpgrade(List<INode> resolvedINodes, byte[][] components, String path) throws StorageException, UnresolvedPathException, TransactionContextException {
        if (resolvedINodes.size() != components.length) {
            INode inodeToReread = null;
            if (this.lockType == TransactionLockTypes.INodeLockType.WRITE_ON_TARGET_AND_PARENT) {
                if (resolvedINodes.size() <= components.length - 2) {
                    inodeToReread = resolvedINodes.get(resolvedINodes.size() - 1);
                }
            } else if (this.lockType == TransactionLockTypes.INodeLockType.WRITE) {
                inodeToReread = resolvedINodes.get(resolvedINodes.size() - 1);
            }
            if (inodeToReread != null) {
                long partitionIdOfINodeToBeReRead = INode.calculatePartitionId(inodeToReread.getParentId(), inodeToReread.getLocalName(), inodeToReread.myDepth());
                INode inode = this.find(this.lockType, inodeToReread.getLocalName(), inodeToReread.getParentId(), partitionIdOfINodeToBeReRead);
                if (inode != null) {
                    this.addLockedINodes(inode, this.lockType);
                    String existingPath = this.buildPath(path, resolvedINodes.size());
                    List<INode> rest = this.acquireLockOnRestOfPath(this.lockType, inode, path, existingPath, false);
                    resolvedINodes.addAll(rest);
                }
            }
        }
    }

    private List<INode> acquireLockOnRestOfPath(TransactionLockTypes.INodeLockType lock, INode baseInode, String fullPath, String prefix, boolean resolveLink) throws StorageException, UnresolvedPathException, TransactionContextException {
        ArrayList<INode> resolved = new ArrayList<INode>();
        byte[][] fullComps = INode.getPathComponents(fullPath);
        byte[][] prefixComps = INode.getPathComponents(prefix);
        INodeResolver resolver = new INodeResolver(fullComps, baseInode, resolveLink, true, prefixComps.length - 1);
        while (resolver.hasNext()) {
            this.setINodeLockType(lock);
            INode current = resolver.next();
            if (current == null) continue;
            this.addLockedINodes(current, lock);
            resolved.add(current);
        }
        return resolved;
    }

    private List<INode> findImmediateChildren(INode lastINode) throws StorageException, TransactionContextException {
        ArrayList<INode> children = new ArrayList<INode>();
        if (lastINode != null && lastINode instanceof INodeDirectory) {
            this.setINodeLockType(TransactionLockTypes.INodeLockType.READ_COMMITTED);
            children.addAll(((INodeDirectory)lastINode).getChildrenList());
        }
        return children;
    }

    private List<INode> findChildrenRecursively(INode lastINode) throws StorageException, TransactionContextException {
        LinkedList<INode> children = new LinkedList<INode>();
        LinkedList<INode> unCheckedDirs = new LinkedList<INode>();
        if (lastINode != null && lastINode instanceof INodeDirectory) {
            unCheckedDirs.add(lastINode);
        }
        while (!unCheckedDirs.isEmpty()) {
            INode next = (INode)unCheckedDirs.poll();
            if (!(next instanceof INodeDirectory)) continue;
            this.setINodeLockType(TransactionLockTypes.INodeLockType.READ_COMMITTED);
            List<INode> clist = ((INodeDirectory)next).getChildrenList();
            unCheckedDirs.addAll(clist);
            children.addAll(clist);
        }
        LOG.debug((Object)("Added " + children.size() + " children."));
        return children;
    }

    private INode acquireLockOnRoot(TransactionLockTypes.INodeLockType lock) throws StorageException, TransactionContextException {
        LOG.debug((Object)("Acquiring " + lock + " on the root node"));
        return this.find(lock, "", 0L, INodeDirectory.getRootDirPartitionKey());
    }

    private String buildPath(String path, int size) {
        StringBuilder builder = new StringBuilder();
        byte[][] components = INode.getPathComponents(path);
        for (int i = 0; i < Math.min(components.length, size); ++i) {
            if (i == 0) {
                builder.append("/");
                continue;
            }
            if (i != 1) {
                builder.append("/");
            }
            builder.append(DFSUtil.bytes2String(components[i]));
        }
        return builder.toString();
    }

    protected INode find(String name, long parentId, long partitionId) throws StorageException, TransactionContextException {
        return this.find(this.lockType, name, parentId, partitionId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("INodeLock {");
        if (this.paths != null && this.paths.length > 0) {
            sb.append("paths=");
            sb.append(Arrays.toString(this.paths));
            sb.append(", ");
        }
        if (this.lockType != null) {
            sb.append("lockType=");
            sb.append(this.lockType);
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    private class PathResolver
    extends CacheResolver {
        private PathResolver() {
        }

        @Override
        List<INode> fetchINodes(String path) throws IOException {
            long[] inodeIds = Cache.getInstance().get(path);
            if (inodeIds != null) {
                String[] names = INode.getPathNames(path);
                boolean partial = names.length > inodeIds.length;
                long[] parentIds = this.getParentIds(inodeIds, partial);
                long[] partitionIds = new long[parentIds.length];
                short depth = 0;
                partitionIds[0] = INodeDirectory.getRootDirPartitionKey();
                for (int i = 1; i < partitionIds.length; ++i) {
                    depth = (short)(depth + 1);
                    partitionIds[i] = INode.calculatePartitionId(parentIds[i], names[i], depth);
                }
                this.setPartitionKey(inodeIds, parentIds, partitionIds, partial);
                List<INode> inodes = this.readINodesWhileRespectingLocks(path, names, parentIds, partitionIds);
                if (inodes != null && !inodes.isEmpty()) {
                    int verifiedInode = this.verifyINodesPartial(inodes, names, parentIds, inodeIds);
                    for (int diff = inodes.size() - verifiedInode; diff > 0; --diff) {
                        INode node = inodes.remove(inodes.size() - 1);
                        if (node == null) continue;
                        Cache.getInstance().delete(node);
                    }
                    if (verifiedInode <= 1) {
                        return null;
                    }
                    this.tryResolvingTheRest(path, inodes);
                    return inodes;
                }
            }
            return null;
        }

        INode lockInode() throws IOException {
            INodeLock.this.setINodeLockType(INodeLock.this.lockType);
            INode targetInode = INodeUtil.getNode(INodeLock.this.inodeId, true);
            INodeLock.this.setINodeLockType(INodeLock.this.getDefaultInodeLockType());
            if (targetInode == null) {
                throw new LeaseExpiredException("No lease on inode: " + INodeLock.this.inodeId + ": File does not exist. ");
            }
            Cache.getInstance().set(targetInode);
            return targetInode;
        }

        List<INode> lockInodeAndParent() throws IOException {
            LinkedList<INode> inodes = new LinkedList<INode>();
            INodeIdentifier targetIdentifier = Cache.getInstance().get(INodeLock.this.inodeId);
            if (targetIdentifier == null) {
                INode targetInode = INodeUtil.getNode(INodeLock.this.inodeId, false);
                if (targetInode == null) {
                    throw new LeaseExpiredException("No lease on " + INodeLock.this.inodeId + ": File does not exist. ");
                }
                targetIdentifier = new INodeIdentifier(Long.valueOf(targetInode.getId()), Long.valueOf(targetInode.getParentId()), targetInode.getLocalName(), targetInode.getPartitionId());
            }
            if (targetIdentifier.getInodeId() == 1L) {
                inodes.add(this.lockInode());
                return inodes;
            }
            INodeLock.this.setINodeLockType(TransactionLockTypes.INodeLockType.WRITE);
            INode parentInode = INodeUtil.getNode(targetIdentifier.getPid(), true);
            if (parentInode == null) {
                Cache.getInstance().delete(targetIdentifier);
                throw new TransientStorageException("wrong inode in the cache");
            }
            inodes.add(parentInode);
            Cache.getInstance().set(parentInode);
            INode targetINode = this.lockInode();
            if (targetINode.getParentId() != parentInode.getId()) {
                throw new TransientStorageException("wrong inode in the cache");
            }
            inodes.add(targetINode);
            return inodes;
        }

        void getPathInodes(long parentId, Map<Long, INode> alreadyFetchedInodes) throws IOException {
            if (parentId == 0L) {
                return;
            }
            INodeIdentifier cur = Cache.getInstance().get(parentId);
            if (cur == null) {
                INode inode = INodeUtil.getNode(parentId, true);
                if (inode == null) {
                    return;
                }
                Cache.getInstance().set(inode);
                alreadyFetchedInodes.put(inode.getId(), inode);
                cur = new INodeIdentifier(Long.valueOf(inode.getId()), Long.valueOf(inode.getParentId()), inode.getLocalName(), inode.getPartitionId());
            }
            HashMap<Long, INodeIdentifier> inodeIdentifiers = new HashMap<Long, INodeIdentifier>();
            while (cur != null) {
                inodeIdentifiers.put(cur.getInodeId(), cur);
                parentId = cur.getPid();
                cur = Cache.getInstance().get(parentId);
            }
            for (INodeIdentifier identifier : inodeIdentifiers.values()) {
                if (!alreadyFetchedInodes.containsKey(identifier.getInodeId())) continue;
                inodeIdentifiers.remove(identifier);
            }
            if (!inodeIdentifiers.isEmpty()) {
                long[] inodeIds = new long[inodeIdentifiers.size()];
                String[] names = new String[inodeIdentifiers.size()];
                long[] parentIds = new long[inodeIdentifiers.size()];
                long[] partitionIds = new long[inodeIdentifiers.size()];
                int i = 0;
                for (INodeIdentifier inode : inodeIdentifiers.values()) {
                    inodeIds[i] = inode.getInodeId();
                    names[i] = inode.getName();
                    parentIds[i] = inode.getPid();
                    partitionIds[i] = inode.getPartitionId();
                    ++i;
                }
                List<INode> inodesFound = INodeLock.this.find(INodeLock.this.getDefaultInodeLockType(), names, parentIds, partitionIds, true);
                for (INode inode : inodesFound) {
                    INodeIdentifier identifier = (INodeIdentifier)inodeIdentifiers.get(inode.getId());
                    if (identifier == null || !inode.getLocalName().equals(identifier.getName()) || inode.getParentId() != identifier.getPid().longValue()) continue;
                    inodeIdentifiers.remove(inode.getId());
                    alreadyFetchedInodes.put(inode.getId(), inode);
                    Cache.getInstance().set(inode);
                }
                for (INodeIdentifier identifier : inodeIdentifiers.values()) {
                    Cache.getInstance().delete(identifier);
                    this.getPathInodes(identifier.getInodeId(), alreadyFetchedInodes);
                }
            }
            if (parentId != 0L) {
                this.getPathInodes(parentId, alreadyFetchedInodes);
            }
        }

        @Override
        List<INode> fetchINodes(long inodeId) throws IOException {
            LinkedList<INode> inodes = new LinkedList<INode>();
            if (TransactionLockTypes.impliesParentWriteLock((TransactionLockTypes.INodeLockType)INodeLock.this.lockType)) {
                inodes.addAll(this.lockInodeAndParent());
            } else {
                inodes.add(this.lockInode());
            }
            HashMap<Long, INode> parentsMap = new HashMap<Long, INode>();
            this.getPathInodes(((INode)inodes.get(0)).getParentId(), parentsMap);
            INode cur = (INode)parentsMap.get(((INode)inodes.get(0)).getParentId());
            while (cur != null) {
                inodes.add(0, cur);
                cur = (INode)parentsMap.get(cur.getParentId());
            }
            return inodes;
        }

        protected void tryResolvingTheRest(String path, List<INode> inodes) throws TransactionContextException, UnresolvedPathException, StorageException {
            int offset = inodes.size();
            this.resolveRestOfThePath(path, inodes);
            this.addPathINodesWithOffset(path, inodes, offset);
        }

        private void addPathINodesWithOffset(String path, List<INode> inodes, int offset) {
            INodeLock.this.addPathINodes(path, inodes);
            if (offset == 0) {
                INodeLock.this.updateResolvingCache(path, inodes);
            } else {
                if (offset == inodes.size()) {
                    return;
                }
                List<INode> newInodes = inodes.subList(offset, inodes.size());
                Object[] newPath = Arrays.copyOfRange(INode.getPathNames(path), offset, inodes.size());
                INodeLock.this.updateResolvingCache(Joiner.on((char)'/').join(newPath), newInodes);
            }
        }

        protected List<INode> readINodesWhileRespectingLocks(String path, String[] names, long[] parentIds, long[] partitionIds) throws TransactionContextException, StorageException, UnresolvedPathException {
            boolean partialPath;
            int rowsToReadWithDefaultLock = names.length;
            if (!INodeLock.this.lockType.equals((Object)INodeLock.this.getDefaultInodeLockType())) {
                rowsToReadWithDefaultLock = INodeLock.this.lockType.equals((Object)TransactionLockTypes.INodeLockType.WRITE_ON_TARGET_AND_PARENT) ? (rowsToReadWithDefaultLock -= 2) : --rowsToReadWithDefaultLock;
            }
            rowsToReadWithDefaultLock = Math.min(rowsToReadWithDefaultLock, parentIds.length);
            List<INode> inodes = null;
            if (rowsToReadWithDefaultLock > 0) {
                inodes = INodeLock.this.find(INodeLock.this.getDefaultInodeLockType(), Arrays.copyOf(names, rowsToReadWithDefaultLock), Arrays.copyOf(parentIds, rowsToReadWithDefaultLock), Arrays.copyOf(partitionIds, rowsToReadWithDefaultLock), true);
            }
            if (inodes != null) {
                for (INode inode : inodes) {
                    INodeLock.this.addLockedINodes(inode, INodeLock.this.getDefaultInodeLockType());
                }
            }
            if (rowsToReadWithDefaultLock == names.length) {
                return inodes;
            }
            boolean bl = partialPath = parentIds.length < names.length;
            if (inodes != null && !partialPath) {
                this.resolveRestOfThePath(path, inodes);
            }
            return inodes;
        }

        protected void resolveRestOfThePath(String path, List<INode> inodes) throws StorageException, TransactionContextException, UnresolvedPathException {
            byte[][] components = INode.getPathComponents(path);
            INode currentINode = inodes.get(inodes.size() - 1);
            INodeResolver resolver = new INodeResolver(components, currentINode, INodeLock.this.resolveLink, true, inodes.size() - 1);
            while (resolver.hasNext()) {
                TransactionLockTypes.INodeLockType currentINodeLock = INodeLock.this.identifyLockType(resolver.getCount() + 1, components);
                INodeLock.this.setINodeLockType(currentINodeLock);
                currentINode = resolver.next();
                if (currentINode == null) continue;
                INodeLock.this.addLockedINodes(currentINode, currentINodeLock);
                inodes.add(currentINode);
            }
        }
    }

    private abstract class CacheResolver {
        private CacheResolver() {
        }

        abstract List<INode> fetchINodes(String var1) throws IOException;

        abstract List<INode> fetchINodes(long var1) throws IOException;

        protected int verifyINodesFull(List<INode> inodes, String[] names, long[] parentIds, long[] inodeIds) throws IOException {
            int index = -1;
            if (names.length == parentIds.length && inodes.size() == names.length) {
                index = this.verifyINodesPartial(inodes, names, parentIds, inodeIds);
            }
            return index;
        }

        protected int verifyINodesPartial(List<INode> inodes, String[] names, long[] parentIds, long[] inodeIds) throws IOException {
            int index = (int)StatUtils.min((double[])new double[]{inodes.size(), inodeIds.length, parentIds.length, names.length});
            for (int i = 0; i < index; ++i) {
                boolean noChangeInInodes;
                INode inode = inodes.get(i);
                boolean bl = noChangeInInodes = inode != null && inode.getLocalName().equals(names[i]) && inode.getParentId() == parentIds[i] && inode.getId() == inodeIds[i];
                if (noChangeInInodes) continue;
                index = i;
                break;
            }
            return index;
        }

        protected int reverseVerifyINodesPartial(List<INode> inodes, String[] names, long[] parentIds, long[] inodeIds) throws IOException {
            int maxIndex = (int)StatUtils.min((double[])new double[]{inodes.size(), inodeIds.length, parentIds.length, names.length});
            for (int i = 1; i <= maxIndex; ++i) {
                boolean noChangeInInodes;
                INode inode = inodes.get(inodes.size() - i);
                boolean bl = noChangeInInodes = inode != null && inode.getLocalName().equals(names[names.length - i]) && inode.getParentId() == parentIds[parentIds.length - i] && inode.getId() == inodeIds[inodeIds.length - i];
                if (noChangeInInodes) continue;
                return i;
            }
            return maxIndex + 1;
        }

        protected long[] getParentIds(long[] inodeIds) {
            return this.getParentIds(inodeIds, false);
        }

        protected long[] getParentIds(long[] inodeIds, boolean partial) {
            long[] parentIds = new long[partial ? inodeIds.length + 1 : inodeIds.length];
            parentIds[0] = 0L;
            System.arraycopy(inodeIds, 0, parentIds, 1, partial ? inodeIds.length : inodeIds.length - 1);
            return parentIds;
        }

        protected void setPartitionKey(long[] inodeIds, long[] parentIds, long[] partitionIds, boolean partial) throws TransactionContextException, StorageException {
            Long partId = null;
            if (partial) {
                if (BaseINodeLock.setRandomParitionKeyEnabled && partId == null) {
                    Lock.LOG.debug((Object)"Setting Random PartitionKey");
                    partId = Math.abs(BaseINodeLock.rand.nextLong());
                }
            } else {
                partId = inodeIds[inodeIds.length - 1];
            }
            INodeLock.this.setPartitioningKey(partId);
        }
    }
}

