/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.security.token.delegation;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.RetriableException;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.apache.hadoop.security.token.delegation.DelegationKey;

@InterfaceAudience.Private
public class DelegationTokenSecretManager
extends AbstractDelegationTokenSecretManager<DelegationTokenIdentifier> {
    private static final Log LOG = LogFactory.getLog(DelegationTokenSecretManager.class);
    private final FSNamesystem namesystem;

    public DelegationTokenSecretManager(long delegationKeyUpdateInterval, long delegationTokenMaxLifetime, long delegationTokenRenewInterval, long delegationTokenRemoverScanInterval, FSNamesystem namesystem) {
        this(delegationKeyUpdateInterval, delegationTokenMaxLifetime, delegationTokenRenewInterval, delegationTokenRemoverScanInterval, false, namesystem);
    }

    public DelegationTokenSecretManager(long delegationKeyUpdateInterval, long delegationTokenMaxLifetime, long delegationTokenRenewInterval, long delegationTokenRemoverScanInterval, boolean storeTokenTrackingId, FSNamesystem namesystem) {
        super(delegationKeyUpdateInterval, delegationTokenMaxLifetime, delegationTokenRenewInterval, delegationTokenRemoverScanInterval);
        this.namesystem = namesystem;
        this.storeTokenTrackingId = storeTokenTrackingId;
    }

    public DelegationTokenIdentifier createIdentifier() {
        return new DelegationTokenIdentifier();
    }

    public byte[] retriableRetrievePassword(DelegationTokenIdentifier identifier) throws SecretManager.InvalidToken, StandbyException, RetriableException, IOException {
        try {
            return super.retrievePassword((AbstractDelegationTokenIdentifier)identifier);
        }
        catch (SecretManager.InvalidToken it) {
            if (this.namesystem.inTransitionToActive()) {
                throw new RetriableException((Exception)((Object)it));
            }
            throw it;
        }
    }

    public synchronized long getTokenExpiryTime(DelegationTokenIdentifier dtId) throws IOException {
        AbstractDelegationTokenSecretManager.DelegationTokenInformation info = (AbstractDelegationTokenSecretManager.DelegationTokenInformation)this.currentTokens.get((Object)dtId);
        if (info != null) {
            return info.getRenewDate();
        }
        throw new IOException("No delegation token found for this identifier");
    }

    public synchronized void addPersistedDelegationToken(DelegationTokenIdentifier identifier, long expiryTime) throws IOException {
        if (this.running) {
            throw new IOException("Can't add persisted delegation token to a running SecretManager.");
        }
        int keyId = identifier.getMasterKeyId();
        DelegationKey dKey = (DelegationKey)this.allKeys.get(keyId);
        if (dKey == null) {
            LOG.warn((Object)("No KEY found for persisted identifier " + identifier.toString()));
            return;
        }
        byte[] password = DelegationTokenSecretManager.createPassword((byte[])identifier.getBytes(), (SecretKey)dKey.getKey());
        if (identifier.getSequenceNumber() > this.delegationTokenSequenceNumber) {
            this.delegationTokenSequenceNumber = identifier.getSequenceNumber();
        }
        if (this.currentTokens.get((Object)identifier) != null) {
            throw new IOException("Same delegation token being added twice; invalid entry in fsimage or editlogs");
        }
        this.currentTokens.put(identifier, new AbstractDelegationTokenSecretManager.DelegationTokenInformation(expiryTime, password, this.getTrackingIdIfEnabled(identifier)));
    }

    public synchronized void updatePersistedMasterKey(DelegationKey key) throws IOException {
        this.addKey(key);
    }

    public synchronized void updatePersistedTokenRenewal(DelegationTokenIdentifier identifier, long expiryTime) throws IOException {
        if (this.running) {
            throw new IOException("Can't update persisted delegation token renewal to a running SecretManager.");
        }
        AbstractDelegationTokenSecretManager.DelegationTokenInformation info = null;
        info = (AbstractDelegationTokenSecretManager.DelegationTokenInformation)this.currentTokens.get((Object)identifier);
        if (info != null) {
            int keyId = identifier.getMasterKeyId();
            byte[] password = DelegationTokenSecretManager.createPassword((byte[])identifier.getBytes(), (SecretKey)((DelegationKey)this.allKeys.get(keyId)).getKey());
            this.currentTokens.put(identifier, new AbstractDelegationTokenSecretManager.DelegationTokenInformation(expiryTime, password, this.getTrackingIdIfEnabled(identifier)));
        }
    }

    public synchronized void updatePersistedTokenCancellation(DelegationTokenIdentifier identifier) throws IOException {
        if (this.running) {
            throw new IOException("Can't update persisted delegation token renewal to a running SecretManager.");
        }
        this.currentTokens.remove((Object)identifier);
    }

    public synchronized int getNumberOfKeys() {
        return this.allKeys.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logUpdateMasterKey(DelegationKey key) throws IOException {
        Object object = this.noInterruptsLock;
        synchronized (object) {
            if (Thread.interrupted()) {
                throw new InterruptedIOException("Interrupted before updating master key");
            }
            this.namesystem.logUpdateMasterKey(key);
        }
    }

    public static Credentials createCredentials(NameNode namenode, UserGroupInformation ugi, String renewer) throws IOException {
        Token<DelegationTokenIdentifier> token = namenode.getRpcServer().getDelegationToken(new Text(renewer));
        if (token == null) {
            throw new IOException("Failed to get the token for " + renewer + ", user=" + ugi.getShortUserName());
        }
        InetSocketAddress addr = namenode.getNameNodeAddress();
        SecurityUtil.setTokenService(token, (InetSocketAddress)addr);
        Credentials c = new Credentials();
        c.addToken(new Text(ugi.getShortUserName()), token);
        return c;
    }
}

