/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.dal.BlockInfoDataAccess;
import io.hops.metadata.hdfs.dal.INodeDataAccess;
import io.hops.metadata.hdfs.entity.INodeIdentifier;
import io.hops.transaction.EntityManager;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.LightWeightRequestHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockCollection;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;

class BlocksMap {
    private final DatanodeManager datanodeManager;
    private static final List<DatanodeDescriptor> empty_datanode_list = Collections.unmodifiableList(new ArrayList());
    private static final List<DatanodeStorageInfo> empty_storage_list = Collections.unmodifiableList(new ArrayList());

    BlocksMap(DatanodeManager datanodeManager) {
        this.datanodeManager = datanodeManager;
    }

    void close() {
    }

    BlockCollection getBlockCollection(Block b) throws StorageException, TransactionContextException {
        BlockInfo info = this.getStoredBlock(b);
        return info != null ? info.getBlockCollection() : null;
    }

    BlockInfo addBlockCollection(BlockInfo b, BlockCollection bc) throws StorageException, TransactionContextException {
        b.setBlockCollection(bc);
        return b;
    }

    void removeBlock(Block block) throws StorageException, TransactionContextException {
        BlockInfo blockInfo = this.getStoredBlock(block);
        if (blockInfo == null) {
            return;
        }
        blockInfo.remove();
        blockInfo.removeAllReplicas();
    }

    BlockInfo getStoredBlock(Block b) throws StorageException, TransactionContextException {
        if (b == null) {
            return null;
        }
        if (!(b instanceof BlockInfo)) {
            return (BlockInfo)EntityManager.find((FinderType)BlockInfo.Finder.ByBlockIdAndINodeId, (Object[])new Object[]{b.getBlockId()});
        }
        return (BlockInfo)b;
    }

    List<DatanodeStorageInfo> storageList(Block b) throws TransactionContextException, StorageException {
        BlockInfo blockInfo = this.getStoredBlock(b);
        return this.storageList(blockInfo);
    }

    List<DatanodeStorageInfo> storageList(BlockInfo storedBlock) throws StorageException, TransactionContextException {
        if (storedBlock == null) {
            return null;
        }
        DatanodeStorageInfo[] desc = storedBlock.getStorages(this.datanodeManager);
        if (desc == null) {
            return empty_storage_list;
        }
        return Arrays.asList(desc);
    }

    List<DatanodeStorageInfo> storageList(Block b, DatanodeStorage.State state) throws StorageException, TransactionContextException {
        BlockInfo blockInfo = this.getStoredBlock(b);
        return this.storageList(blockInfo, state);
    }

    List<DatanodeStorageInfo> storageList(BlockInfo storedBlock, DatanodeStorage.State state) throws StorageException, TransactionContextException {
        if (storedBlock == null) {
            return null;
        }
        DatanodeStorageInfo[] desc = storedBlock.getStorages(this.datanodeManager, state);
        if (desc == null) {
            return empty_storage_list;
        }
        return Arrays.asList(desc);
    }

    int numNodes(Block b) throws StorageException, TransactionContextException {
        BlockInfo info = this.getStoredBlock(b);
        return info == null ? 0 : info.numNodes(this.datanodeManager);
    }

    boolean removeNode(Block b, DatanodeDescriptor node) throws StorageException, TransactionContextException {
        BlockInfo info = this.getStoredBlock(b);
        if (info == null) {
            return false;
        }
        return node.removeReplica(info);
    }

    boolean removeNode(Block b, int sid) throws StorageException, TransactionContextException {
        BlockInfo info = this.getStoredBlock(b);
        if (info == null) {
            return false;
        }
        return info.removeReplica(sid) != null;
    }

    int size() throws IOException {
        LightWeightRequestHandler getAllBlocksSizeHander = new LightWeightRequestHandler(HDFSOperationType.GET_ALL_BLOCKS_SIZE){

            public Object performTask() throws IOException {
                BlockInfoDataAccess bida = (BlockInfoDataAccess)HdfsStorageFactory.getDataAccess(BlockInfoDataAccess.class);
                return bida.countAll();
            }
        };
        return (Integer)getAllBlocksSizeHander.handle();
    }

    int sizeCompleteOnly() throws IOException {
        LightWeightRequestHandler getAllBlocksSizeHander = new LightWeightRequestHandler(HDFSOperationType.GET_COMPLETE_BLOCKS_TOTAL){

            public Object performTask() throws IOException {
                BlockInfoDataAccess bida = (BlockInfoDataAccess)HdfsStorageFactory.getDataAccess(BlockInfoDataAccess.class);
                return bida.countAllCompleteBlocks();
            }
        };
        return (Integer)getAllBlocksSizeHander.handle();
    }

    Iterable<BlockInfo> getBlocks() throws IOException {
        LightWeightRequestHandler getAllBlocksHander = new LightWeightRequestHandler(HDFSOperationType.GET_ALL_BLOCKS){

            public Object performTask() throws IOException {
                BlockInfoDataAccess bida = (BlockInfoDataAccess)HdfsStorageFactory.getDataAccess(BlockInfoDataAccess.class);
                return bida.findAllBlocks();
            }
        };
        return (List)getAllBlocksHander.handle();
    }

    int getCapacity() {
        return Integer.MAX_VALUE;
    }

    List<INodeIdentifier> getAllINodeFiles(final long offset, final long count) throws IOException {
        return (List)new LightWeightRequestHandler(HDFSOperationType.GET_ALL_INODES){

            public Object performTask() throws IOException {
                INodeDataAccess ida = (INodeDataAccess)HdfsStorageFactory.getDataAccess(INodeDataAccess.class);
                return ida.getAllINodeFiles(offset, count);
            }
        }.handle();
    }

    boolean haveFilesWithIdGreaterThan(final long id) throws IOException {
        return (Boolean)new LightWeightRequestHandler(HDFSOperationType.HAVE_FILES_WITH_IDS_GREATER_THAN){

            public Object performTask() throws IOException {
                INodeDataAccess ida = (INodeDataAccess)HdfsStorageFactory.getDataAccess(INodeDataAccess.class);
                return ida.haveFilesWithIdsGreaterThan(id);
            }
        }.handle();
    }

    boolean haveFilesWithIdBetween(final long startId, final long endId) throws IOException {
        return (Boolean)new LightWeightRequestHandler(HDFSOperationType.HAVE_FILES_WITH_IDS_BETWEEN){

            public Object performTask() throws IOException {
                INodeDataAccess ida = (INodeDataAccess)HdfsStorageFactory.getDataAccess(INodeDataAccess.class);
                return ida.haveFilesWithIdsBetween(startId, endId);
            }
        }.handle();
    }

    long getMinFileId() throws IOException {
        return (Long)new LightWeightRequestHandler(HDFSOperationType.GET_MIN_FILE_ID){

            public Object performTask() throws IOException {
                INodeDataAccess ida = (INodeDataAccess)HdfsStorageFactory.getDataAccess(INodeDataAccess.class);
                return ida.getMinFileId();
            }
        }.handle();
    }

    int countAllFiles() throws IOException {
        return (Integer)new LightWeightRequestHandler(HDFSOperationType.COUNTALL_FILES){

            public Object performTask() throws IOException {
                INodeDataAccess ida = (INodeDataAccess)HdfsStorageFactory.getDataAccess(INodeDataAccess.class);
                return ida.countAllFiles();
            }
        }.handle();
    }
}

