/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import com.google.common.annotations.VisibleForTesting;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.dal.InvalidateBlockDataAccess;
import io.hops.metadata.hdfs.entity.InvalidatedBlock;
import io.hops.transaction.EntityManager;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.LightWeightRequestHandler;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Private
class InvalidateBlocks {
    private static final Log LOG = LogFactory.getLog(InvalidateBlocks.class);
    private final int blockInvalidateLimit;
    private final long pendingPeriodInMs;
    private final long startupTime = Time.monotonicNow();

    InvalidateBlocks(int blockInvalidateLimit, long pendingPeriodInMs) {
        this.blockInvalidateLimit = blockInvalidateLimit;
        this.pendingPeriodInMs = pendingPeriodInMs;
        this.printBlockDeletionTime(BlockManager.LOG);
    }

    private void printBlockDeletionTime(Log log) {
        log.info((Object)("dfs.namenode.startup.delay.block.deletion.ms is set to " + this.pendingPeriodInMs + " ms."));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy MMM dd HH:mm:ss");
        GregorianCalendar calendar = new GregorianCalendar();
        ((Calendar)calendar).add(13, (int)(this.pendingPeriodInMs / 1000L));
        log.info((Object)("The block deletion will start around " + sdf.format(calendar.getTime())));
    }

    long numBlocks() throws IOException {
        return ((Integer)new LightWeightRequestHandler(HDFSOperationType.GET_NUM_INVALIDATED_BLKS){

            public Object performTask() throws StorageException, IOException {
                InvalidateBlockDataAccess da = (InvalidateBlockDataAccess)HdfsStorageFactory.getDataAccess(InvalidateBlockDataAccess.class);
                return da.countAll();
            }
        }.handle()).intValue();
    }

    boolean contains(DatanodeStorageInfo dn, BlockInfo block) throws StorageException, TransactionContextException {
        InvalidatedBlock blkFound = this.findBlock(block.getBlockId(), dn.getSid(), block.getInodeId());
        if (blkFound == null) {
            return false;
        }
        return blkFound.getGenerationStamp() == block.getGenerationStamp();
    }

    void add(BlockInfo block, DatanodeStorageInfo storage, boolean log) throws StorageException, TransactionContextException {
        InvalidatedBlock invBlk = new InvalidatedBlock(storage.getSid(), block.getBlockId(), block.getGenerationStamp(), block.getNumBytes(), block.getInodeId());
        if (this.add(invBlk)) {
            LOG.info((Object)("BLOCK* " + this.getClass().getSimpleName() + ": add " + block + " to " + storage));
        } else {
            LOG.info((Object)("failed to add BLOCK* " + this.getClass().getSimpleName() + ": add " + block + " to " + storage));
        }
    }

    void remove(List<Integer> sids) throws IOException {
        if (sids != null) {
            for (int sid : sids) {
                this.removeInvBlocks(sid);
            }
        }
    }

    void remove(int sid) throws IOException {
        this.removeInvBlocks(sid);
    }

    void remove(DatanodeStorageInfo storageInfo, BlockInfo block) throws IOException {
        InvalidatedBlock invBlok = this.findBlock(block.getBlockId(), storageInfo.getSid(), block.getInodeId());
        if (invBlok != null) {
            this.removeInvalidatedBlockFromDB(block.getBlockId(), storageInfo.getSid());
        }
    }

    List<Integer> getSids() throws IOException {
        LightWeightRequestHandler getAllInvBlocksHandler = new LightWeightRequestHandler(HDFSOperationType.GET_ALL_INV_BLKS){

            public Object performTask() throws StorageException, IOException {
                InvalidateBlockDataAccess da = (InvalidateBlockDataAccess)HdfsStorageFactory.getDataAccess(InvalidateBlockDataAccess.class);
                return da.findAllInvalidatedBlocks();
            }
        };
        List invBlocks = (List)getAllInvBlocksHandler.handle();
        ArrayList<Integer> sids = new ArrayList<Integer>();
        if (invBlocks != null) {
            for (InvalidatedBlock ib : invBlocks) {
                sids.add(ib.getStorageId());
            }
        }
        return sids;
    }

    @VisibleForTesting
    long getInvalidationDelay() {
        return this.pendingPeriodInMs - (Time.monotonicNow() - this.startupTime);
    }

    List<Block> invalidateWork(DatanodeDescriptor dn) throws IOException {
        long delay = this.getInvalidationDelay();
        if (delay > 0L) {
            if (BlockManager.LOG.isDebugEnabled()) {
                BlockManager.LOG.debug((Object)("Block deletion is delayed during NameNode startup. The deletion will start after " + delay + " ms."));
            }
            return null;
        }
        ArrayList<InvalidatedBlock> invBlocks = new ArrayList<InvalidatedBlock>();
        for (DatanodeStorageInfo storage : dn.getStorageInfos()) {
            invBlocks.addAll(this.findInvBlocksbySid(storage.getSid()));
        }
        if (invBlocks == null || invBlocks.isEmpty()) {
            return null;
        }
        int limit = this.blockInvalidateLimit;
        ArrayList<Block> toInvalidate = new ArrayList<Block>(limit);
        ArrayList<InvalidatedBlock> toInvblks = new ArrayList<InvalidatedBlock>();
        Iterator it = invBlocks.iterator();
        for (int count = 0; count < limit && it.hasNext(); ++count) {
            InvalidatedBlock invBlock = (InvalidatedBlock)it.next();
            toInvalidate.add(new Block(invBlock.getBlockId(), invBlock.getNumBytes(), invBlock.getGenerationStamp()));
            toInvblks.add(invBlock);
        }
        this.removeInvBlocks(toInvblks);
        dn.addBlocksToBeInvalidated(toInvalidate);
        return toInvalidate;
    }

    void clear() throws IOException {
        new LightWeightRequestHandler(HDFSOperationType.DEL_ALL_INV_BLKS){

            public Object performTask() throws StorageException, IOException {
                InvalidateBlockDataAccess da = (InvalidateBlockDataAccess)HdfsStorageFactory.getDataAccess(InvalidateBlockDataAccess.class);
                da.removeAll();
                return null;
            }
        }.handle();
    }

    void add(final Collection<Block> blocks, final DatanodeStorageInfo storage) throws IOException {
        new LightWeightRequestHandler(HDFSOperationType.ADD_INV_BLOCKS){

            public Object performTask() throws StorageException, IOException {
                InvalidateBlockDataAccess da = (InvalidateBlockDataAccess)HdfsStorageFactory.getDataAccess(InvalidateBlockDataAccess.class);
                ArrayList<InvalidatedBlock> invblks = new ArrayList<InvalidatedBlock>();
                for (Block blk : blocks) {
                    invblks.add(new InvalidatedBlock(storage.getSid(), blk.getBlockId(), blk.getGenerationStamp(), blk.getNumBytes(), (long)BlockInfo.NON_EXISTING_ID));
                }
                da.prepare((Collection)Collections.EMPTY_LIST, invblks, (Collection)Collections.EMPTY_LIST);
                return null;
            }
        }.handle();
    }

    private boolean add(InvalidatedBlock invBlk) throws StorageException, TransactionContextException {
        InvalidatedBlock found = this.findBlock(invBlk.getBlockId(), invBlk.getStorageId(), invBlk.getInodeId());
        if (found == null) {
            this.addInvalidatedBlockToDB(invBlk);
            return true;
        }
        return false;
    }

    private List<InvalidatedBlock> findInvBlocksbySid(final int sid) throws IOException {
        return (List)new LightWeightRequestHandler(HDFSOperationType.GET_INV_BLKS_BY_STORAGEID){

            public Object performTask() throws StorageException, IOException {
                InvalidateBlockDataAccess da = (InvalidateBlockDataAccess)HdfsStorageFactory.getDataAccess(InvalidateBlockDataAccess.class);
                return da.findInvalidatedBlockByStorageId(sid);
            }
        }.handle();
    }

    private void removeInvBlocks(final List<InvalidatedBlock> blks) throws IOException {
        new LightWeightRequestHandler(HDFSOperationType.RM_INV_BLKS){

            public Object performTask() throws StorageException, IOException {
                InvalidateBlockDataAccess da = (InvalidateBlockDataAccess)HdfsStorageFactory.getDataAccess(InvalidateBlockDataAccess.class);
                da.prepare((Collection)blks, (Collection)Collections.EMPTY_LIST, (Collection)Collections.EMPTY_LIST);
                return null;
            }
        }.handle();
    }

    private void removeInvBlocks(final int sid) throws IOException {
        new LightWeightRequestHandler(HDFSOperationType.RM_INV_BLKS){

            public Object performTask() throws StorageException, IOException {
                InvalidateBlockDataAccess da = (InvalidateBlockDataAccess)HdfsStorageFactory.getDataAccess(InvalidateBlockDataAccess.class);
                da.removeAllByStorageId(sid);
                return null;
            }
        }.handle();
    }

    private InvalidatedBlock findBlock(long blkId, int sid, long inodeId) throws StorageException, TransactionContextException {
        return (InvalidatedBlock)EntityManager.find((FinderType)InvalidatedBlock.Finder.ByBlockIdSidAndINodeId, (Object[])new Object[]{blkId, sid, inodeId});
    }

    private void addInvalidatedBlockToDB(InvalidatedBlock invBlk) throws StorageException, TransactionContextException {
        EntityManager.add((Object)invBlk);
    }

    private void removeInvalidatedBlockFromDB(final long blockId, final int sid) throws IOException {
        new LightWeightRequestHandler(HDFSOperationType.RM_INV_BLKS){

            public Object performTask() throws StorageException, IOException {
                InvalidateBlockDataAccess da = (InvalidateBlockDataAccess)HdfsStorageFactory.getDataAccess(InvalidateBlockDataAccess.class);
                da.removeByBlockIdAndStorageId(blockId, sid);
                return null;
            }
        }.handle();
    }

    private List<InvalidatedBlock> findAllInvalidatedBlocks() throws StorageException, TransactionContextException {
        return (List)EntityManager.findList((FinderType)InvalidatedBlock.Finder.All, (Object[])new Object[0]);
    }

    public Map<DatanodeInfo, List<Integer>> getDatanodes(DatanodeManager manager) throws IOException {
        HashMap<DatanodeInfo, List<Integer>> nodes = new HashMap<DatanodeInfo, List<Integer>>();
        for (int sid : this.getSids()) {
            DatanodeDescriptor node = manager.getDatanodeBySid(sid);
            ArrayList<Integer> sids = (ArrayList<Integer>)nodes.get(node);
            if (sids == null) {
                sids = new ArrayList<Integer>();
                nodes.put(node, sids);
            }
            sids.add(sid);
        }
        return nodes;
    }
}

