/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetUtil;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.ReplicaMap;
import org.apache.hadoop.util.DiskChecker;

class LDir {
    final File dir;
    final int maxBlocksPerDir;
    private int numBlocks = 0;
    private LDir[] children = null;
    private int lastChildIdx = 0;

    LDir(File dir, int maxBlocksPerDir) throws IOException {
        this.dir = dir;
        this.maxBlocksPerDir = maxBlocksPerDir;
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                throw new IOException("Failed to mkdirs " + dir);
            }
        } else {
            File[] files = FileUtil.listFiles((File)dir);
            ArrayList<LDir> dirList = new ArrayList<LDir>();
            for (File file : files) {
                if (file.isDirectory()) {
                    dirList.add(new LDir(file, maxBlocksPerDir));
                    continue;
                }
                if (!Block.isBlockFilename(file)) continue;
                ++this.numBlocks;
            }
            if (dirList.size() > 0) {
                this.children = dirList.toArray(new LDir[dirList.size()]);
            }
        }
    }

    File addBlock(Block b, File src) throws IOException {
        File file = this.addBlock(b, src, false, false);
        return file != null ? file : this.addBlock(b, src, true, true);
    }

    private File addBlock(Block b, File src, boolean createOk, boolean resetIdx) throws IOException {
        if (this.numBlocks < this.maxBlocksPerDir) {
            File dest = FsDatasetImpl.moveBlockFiles(b, src, this.dir);
            ++this.numBlocks;
            return dest;
        }
        if (this.lastChildIdx < 0 && resetIdx) {
            this.lastChildIdx = DFSUtil.getRandom().nextInt(this.children.length);
        }
        if (this.lastChildIdx >= 0 && this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                int idx = (this.lastChildIdx + i) % this.children.length;
                File file = this.children[idx].addBlock(b, src, false, resetIdx);
                if (file == null) continue;
                this.lastChildIdx = idx;
                return file;
            }
            this.lastChildIdx = -1;
        }
        if (!createOk) {
            return null;
        }
        if (this.children == null || this.children.length == 0) {
            this.children = new LDir[this.maxBlocksPerDir];
            for (int idx = 0; idx < this.maxBlocksPerDir; ++idx) {
                File sub = new File(this.dir, "subdir" + idx);
                this.children[idx] = new LDir(sub, this.maxBlocksPerDir);
            }
        }
        this.lastChildIdx = DFSUtil.getRandom().nextInt(this.children.length);
        return this.children[this.lastChildIdx].addBlock(b, src, true, false);
    }

    void getVolumeMap(String bpid, ReplicaMap volumeMap, FsVolumeImpl volume) throws IOException {
        if (this.children != null) {
            for (LDir aChildren : this.children) {
                aChildren.getVolumeMap(bpid, volumeMap, volume);
            }
        }
        this.recoverTempUnlinkedBlock();
        volume.addToReplicasMap(bpid, volumeMap, this.dir, true);
    }

    private void recoverTempUnlinkedBlock() throws IOException {
        File[] files;
        for (File file : files = FileUtil.listFiles((File)this.dir)) {
            if (!FsDatasetUtil.isUnlinkTmpFile(file)) continue;
            File blockFile = FsDatasetUtil.getOrigFile(file);
            if (blockFile.exists()) {
                if (file.delete()) continue;
                throw new IOException("Unable to cleanup unlinked tmp file " + file);
            }
            if (file.renameTo(blockFile)) continue;
            throw new IOException("Unable to cleanup detached file " + file);
        }
    }

    void checkDirTree() throws DiskChecker.DiskErrorException {
        DiskChecker.checkDir((File)this.dir);
        if (this.children != null) {
            for (LDir aChildren : this.children) {
                aChildren.checkDirTree();
            }
        }
    }

    void clearPath(File f) {
        String[] dirNames;
        String root = this.dir.getAbsolutePath();
        String dir = f.getAbsolutePath();
        if (dir.startsWith(root) && this.clearPath(f, dirNames = dir.substring(root.length()).split(File.separator + "subdir"), 1)) {
            return;
        }
        this.clearPath(f, null, -1);
    }

    private boolean clearPath(File f, String[] dirNames, int idx) {
        if ((dirNames == null || idx == dirNames.length) && this.dir.compareTo(f) == 0) {
            --this.numBlocks;
            return true;
        }
        if (dirNames != null) {
            int childIdx;
            if (idx > dirNames.length - 1 || this.children == null) {
                return false;
            }
            try {
                childIdx = Integer.parseInt(dirNames[idx]);
            }
            catch (NumberFormatException ignored) {
                return false;
            }
            return childIdx >= 0 && childIdx < this.children.length ? this.children[childIdx].clearPath(f, dirNames, idx + 1) : false;
        }
        if (this.children != null) {
            for (LDir aChildren : this.children) {
                if (!aChildren.clearPath(f, null, -1)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "FSDir{dir=" + this.dir + ", children=" + (this.children == null ? null : Arrays.asList(this.children)) + "}";
    }
}

