/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Preconditions;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.dal.InMemoryInodeDataAccess;
import io.hops.metadata.hdfs.dal.LargeOnDiskInodeDataAccess;
import io.hops.metadata.hdfs.dal.MediumOnDiskInodeDataAccess;
import io.hops.metadata.hdfs.dal.SmallOnDiskInodeDataAccess;
import io.hops.metadata.hdfs.entity.FileInodeData;
import io.hops.transaction.EntityManager;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockCollection;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoUnderConstruction;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.Content;
import org.apache.hadoop.hdfs.server.namenode.ContentSummaryComputationContext;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.FileUnderConstructionFeature;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeWithAdditionalFields;

@InterfaceAudience.Private
public class INodeFile
extends INodeWithAdditionalFields
implements BlockCollection {
    private int generationStamp = 1000;
    private long size = 0L;
    private boolean isFileStoredInDB = false;

    public static INodeFile valueOf(INode inode, String path) throws FileNotFoundException, StorageException, TransactionContextException {
        return INodeFile.valueOf(inode, path, false);
    }

    public static INodeFile valueOf(INode inode, String path, boolean acceptNull) throws FileNotFoundException, StorageException, TransactionContextException {
        if (inode == null) {
            if (acceptNull) {
                return null;
            }
            throw new FileNotFoundException("File does not exist: " + path);
        }
        if (!inode.isFile()) {
            throw new FileNotFoundException("Path is not a file: " + path);
        }
        return inode.asFile();
    }

    @Override
    public final boolean isFile() {
        return true;
    }

    @Override
    public final INodeFile asFile() {
        return this;
    }

    public INodeFile(long id, PermissionStatus permissions, BlockInfo[] blklist, short replication, long modificationTime, long atime, long preferredBlockSize, byte storagePolicyID) throws IOException {
        this(id, permissions, blklist, replication, modificationTime, atime, preferredBlockSize, storagePolicyID, false);
    }

    public INodeFile(long id, PermissionStatus permissions, BlockInfo[] blklist, short replication, long modificationTime, long atime, long preferredBlockSize, byte storagePolicyID, boolean inTree) throws IOException {
        super(id, permissions, modificationTime, atime, inTree);
        this.header = INode.HeaderFormat.combineReplication(this.header, replication);
        this.header = INode.HeaderFormat.combinePreferredBlockSize(this.header, preferredBlockSize);
        this.setFileStoredInDBNoPersistence(false);
        this.setBlockStoragePolicyIDNoPersistance(storagePolicyID);
    }

    public INodeFile(long id, PermissionStatus permissions, long header, long modificationTime, long atime, boolean isFileStoredInDB, byte storagepolicy, boolean inTree) throws IOException {
        super(id, permissions, modificationTime, atime, inTree);
        this.header = header;
        this.isFileStoredInDB = isFileStoredInDB;
        this.blockStoragePolicyID = storagepolicy;
    }

    public INodeFile(INodeFile other) throws IOException {
        super(other);
        this.setGenerationStampNoPersistence(other.getGenerationStamp());
        this.setSizeNoPersistence(other.getSize());
        this.setFileStoredInDBNoPersistence(other.isFileStoredInDB());
        this.setPartitionIdNoPersistance(other.getPartitionId());
        this.header = other.getHeader();
        this.features = other.features;
    }

    public final FileUnderConstructionFeature getFileUnderConstructionFeature() {
        for (INode.Feature f : this.features) {
            if (!(f instanceof FileUnderConstructionFeature)) continue;
            return (FileUnderConstructionFeature)f;
        }
        return null;
    }

    @Override
    public boolean isUnderConstruction() {
        return this.getFileUnderConstructionFeature() != null;
    }

    @Override
    public short getBlockReplication() {
        return INode.HeaderFormat.getReplication(this.header);
    }

    @Override
    public byte getStoragePolicyID() throws TransactionContextException, StorageException {
        byte id = this.getLocalStoragePolicyID();
        if (id == 0) {
            return this.getParent() != null ? this.getParent().getStoragePolicyID() : id;
        }
        return id;
    }

    @Override
    public long getPreferredBlockSize() {
        return INode.HeaderFormat.getPreferredBlockSize(this.header);
    }

    @Override
    public BlockInfo getBlock(int index) throws TransactionContextException, StorageException {
        return (BlockInfo)EntityManager.find((FinderType)BlockInfo.Finder.ByINodeIdAndIndex, (Object[])new Object[]{this.id, index});
    }

    @Override
    public BlockInfo[] getBlocks() throws StorageException, TransactionContextException {
        if (this.isFileStoredInDB()) {
            FSNamesystem.LOG.debug((Object)"Stuffed Inode:  getBlocks(). the file is stored in the database. Returning empty list of blocks");
            return BlockInfo.EMPTY_ARRAY;
        }
        List<BlockInfo> blocks = this.getBlocksOrderedByIndex();
        if (blocks == null) {
            return BlockInfo.EMPTY_ARRAY;
        }
        BlockInfo[] blks = new BlockInfo[blocks.size()];
        return blocks.toArray(blks);
    }

    public void storeFileDataInDB(byte[] data) throws StorageException {
        FileInodeData fid;
        int len = data.length;
        InMemoryInodeDataAccess fida = null;
        if (len <= FSNamesystem.dbInMemorySmallFileMaxSize()) {
            fida = (InMemoryInodeDataAccess)HdfsStorageFactory.getDataAccess(InMemoryInodeDataAccess.class);
            fid = new FileInodeData(this.getId(), data, data.length, FileInodeData.Type.InmemoryFile);
        } else {
            if (len <= FSNamesystem.dbOnDiskSmallFileMaxSize()) {
                fida = (SmallOnDiskInodeDataAccess)HdfsStorageFactory.getDataAccess(SmallOnDiskInodeDataAccess.class);
            } else if (len <= FSNamesystem.dbOnDiskMediumFileMaxSize()) {
                fida = (MediumOnDiskInodeDataAccess)HdfsStorageFactory.getDataAccess(MediumOnDiskInodeDataAccess.class);
            } else if (len <= FSNamesystem.dbOnDiskLargeFileMaxSize()) {
                fida = (LargeOnDiskInodeDataAccess)HdfsStorageFactory.getDataAccess(LargeOnDiskInodeDataAccess.class);
            } else {
                StorageException up = new StorageException("The data is too large to be stored in the database. Requested data size is : " + len);
                throw up;
            }
            fid = new FileInodeData(this.getId(), data, data.length, FileInodeData.Type.OnDiskFile);
        }
        fida.add((Object)fid);
        FSNamesystem.LOG.debug((Object)"Stuffed Inode:  the file has been stored in the database ");
    }

    public byte[] getFileDataInDB() throws StorageException {
        HdfsStorageFactory.getConnector().readCommitted();
        FileInodeData fid = null;
        InMemoryInodeDataAccess fida = null;
        if (this.getSize() <= (long)FSNamesystem.dbInMemorySmallFileMaxSize()) {
            fida = (InMemoryInodeDataAccess)HdfsStorageFactory.getDataAccess(InMemoryInodeDataAccess.class);
        } else if (this.getSize() <= (long)FSNamesystem.dbOnDiskSmallFileMaxSize()) {
            fida = (SmallOnDiskInodeDataAccess)HdfsStorageFactory.getDataAccess(SmallOnDiskInodeDataAccess.class);
        } else if (this.getSize() <= (long)FSNamesystem.dbOnDiskMediumFileMaxSize()) {
            fida = (MediumOnDiskInodeDataAccess)HdfsStorageFactory.getDataAccess(MediumOnDiskInodeDataAccess.class);
        } else if (this.getSize() <= (long)FSNamesystem.dbOnDiskLargeFileMaxSize()) {
            fida = (LargeOnDiskInodeDataAccess)HdfsStorageFactory.getDataAccess(LargeOnDiskInodeDataAccess.class);
        } else {
            StorageException up = new StorageException("The data is too large to be stored in the database. Requested data size is : " + this.getSize());
            throw up;
        }
        fid = fida instanceof LargeOnDiskInodeDataAccess ? (FileInodeData)((LargeOnDiskInodeDataAccess)fida).get(this.getId(), (int)this.getSize()) : (FileInodeData)fida.get(this.getId());
        FSNamesystem.LOG.debug((Object)("Stuffed Inode:  Read file data from the database. Data length is :" + fid.getInodeData().length));
        return fid.getInodeData();
    }

    public void deleteFileDataStoredInDB() throws StorageException {
        Object fid = null;
        InMemoryInodeDataAccess fida = null;
        FileInodeData.Type fileType = null;
        if (this.getSize() <= (long)FSNamesystem.dbInMemorySmallFileMaxSize()) {
            fida = (InMemoryInodeDataAccess)HdfsStorageFactory.getDataAccess(InMemoryInodeDataAccess.class);
            fileType = FileInodeData.Type.InmemoryFile;
        } else if (this.getSize() <= (long)FSNamesystem.dbOnDiskSmallFileMaxSize()) {
            fida = (SmallOnDiskInodeDataAccess)HdfsStorageFactory.getDataAccess(SmallOnDiskInodeDataAccess.class);
            fileType = FileInodeData.Type.OnDiskFile;
        } else if (this.getSize() <= (long)FSNamesystem.dbOnDiskMediumFileMaxSize()) {
            fida = (MediumOnDiskInodeDataAccess)HdfsStorageFactory.getDataAccess(MediumOnDiskInodeDataAccess.class);
            fileType = FileInodeData.Type.OnDiskFile;
        } else if (this.getSize() <= (long)FSNamesystem.dbOnDiskLargeFileMaxSize()) {
            fida = (LargeOnDiskInodeDataAccess)HdfsStorageFactory.getDataAccess(LargeOnDiskInodeDataAccess.class);
            fileType = FileInodeData.Type.OnDiskFile;
        } else {
            IllegalStateException up = new IllegalStateException("Can not delete file. It is not stored in the database");
            throw up;
        }
        fida.delete((Object)new FileInodeData(this.getId(), null, (int)this.getSize(), fileType));
        FSNamesystem.LOG.debug((Object)("Stuffed Inode:  File data for Inode Id: " + this.getId() + " is deleted"));
    }

    List<BlockInfo> appendBlocks(INodeFile[] inodes, int totalAddedBlocks) throws StorageException, TransactionContextException {
        ArrayList<BlockInfo> oldBlks = new ArrayList<BlockInfo>();
        for (INodeFile srcInode : inodes) {
            for (BlockInfo block : srcInode.getBlocks()) {
                BlockInfo copy = BlockInfo.cloneBlock(block);
                oldBlks.add(copy);
                this.addBlock(block);
                block.setBlockCollection(this);
            }
        }
        return oldBlks;
    }

    void addBlock(BlockInfo newblock) throws StorageException, TransactionContextException {
        BlockInfo maxBlk = this.findMaxBlk();
        newblock.setBlockIndex(maxBlk.getBlockIndex() + 1);
    }

    @Override
    public void setBlock(int idx, BlockInfo blk) throws StorageException, TransactionContextException {
        blk.setBlockIndex(idx);
    }

    @Override
    int collectSubtreeBlocksAndClear(INode.BlocksMapUpdateInfo info) throws StorageException, TransactionContextException {
        this.parent = null;
        BlockInfo[] blocks = this.getBlocks();
        if (blocks != null && info != null) {
            for (BlockInfo blk : blocks) {
                blk.setBlockCollection(null);
                info.addDeleteBlock(blk);
            }
        }
        if (this.isFileStoredInDB()) {
            this.deleteFileDataStoredInDB();
        }
        return 1;
    }

    @Override
    public String getName() throws StorageException, TransactionContextException {
        return this.getFullPathName();
    }

    @Override
    public final ContentSummaryComputationContext computeContentSummary(ContentSummaryComputationContext summary) throws StorageException, TransactionContextException {
        this.computeContentSummary4Current(summary.getCounts());
        return summary;
    }

    private void computeContentSummary4Current(Content.Counts counts) throws StorageException, TransactionContextException {
        counts.add(Content.LENGTH, this.computeFileSize());
        counts.add(Content.FILE, 1L);
        counts.add(Content.DISKSPACE, this.diskspaceConsumed());
    }

    public final long computeFileSizeNotIncludingLastUcBlock() throws StorageException, TransactionContextException {
        return this.computeFileSize(false);
    }

    public long computeFileSize() throws StorageException, TransactionContextException {
        return INodeFile.computeFileSize(true, this.getBlocks());
    }

    public long computeFileSize(boolean includesBlockInfoUnderConstruction) throws StorageException, TransactionContextException {
        return INodeFile.computeFileSize(includesBlockInfoUnderConstruction, this.getBlocks());
    }

    static long computeFileSize(boolean includesBlockInfoUnderConstruction, BlockInfo[] blocks) throws StorageException {
        if (blocks == null || blocks.length == 0) {
            return 0L;
        }
        int last = blocks.length - 1;
        long bytes = 0L;
        if (blocks[last] instanceof BlockInfoUnderConstruction) {
            if (includesBlockInfoUnderConstruction) {
                bytes = blocks[last].getNumBytes();
            }
        } else {
            bytes = blocks[last].getNumBytes();
        }
        for (int i = 0; i < last; ++i) {
            bytes += blocks[i].getNumBytes();
        }
        return bytes;
    }

    @Override
    INode.DirCounts spaceConsumedInTree(INode.DirCounts counts) throws StorageException, TransactionContextException {
        ++counts.nsCount;
        counts.dsCount += this.diskspaceConsumed();
        return counts;
    }

    long diskspaceConsumed() throws StorageException, TransactionContextException {
        if (this.isFileStoredInDB()) {
            return this.getSize() * (long)this.getBlockReplication();
        }
        return this.diskspaceConsumed(this.getBlocks());
    }

    long diskspaceConsumed(Block[] blkArr) {
        return INodeFile.diskspaceConsumed(blkArr, this.isUnderConstruction(), this.getPreferredBlockSize(), this.getBlockReplication());
    }

    static long diskspaceConsumed(Block[] blkArr, boolean underConstruction, long preferredBlockSize, short blockReplication) {
        long size = 0L;
        if (blkArr == null) {
            return 0L;
        }
        for (Block blk : blkArr) {
            if (blk == null) continue;
            size += blk.getNumBytes();
        }
        if (blkArr.length > 0 && blkArr[blkArr.length - 1] != null && underConstruction) {
            size += preferredBlockSize - blkArr[blkArr.length - 1].getNumBytes();
        }
        return size * (long)blockReplication;
    }

    BlockInfo getPenultimateBlock() throws StorageException, TransactionContextException {
        FileUnderConstructionFeature uc;
        if (this.isUnderConstruction() && (uc = this.getFileUnderConstructionFeature()) != null && uc.getPenultimateBlockId() > -1L) {
            return (BlockInfo)EntityManager.find((FinderType)BlockInfo.Finder.ByBlockIdAndINodeId, (Object[])new Object[]{uc.getPenultimateBlockId(), this.getId()});
        }
        BlockInfo[] blocks = this.getBlocks();
        if (blocks == null || blocks.length <= 1) {
            return null;
        }
        return blocks[blocks.length - 2];
    }

    @Override
    public BlockInfo getLastBlock() throws IOException, StorageException {
        FileUnderConstructionFeature uc;
        if (this.isUnderConstruction() && (uc = this.getFileUnderConstructionFeature()) != null && uc.getLastBlockId() > -1L) {
            return (BlockInfo)EntityManager.find((FinderType)BlockInfo.Finder.ByBlockIdAndINodeId, (Object[])new Object[]{uc.getLastBlockId(), this.getId()});
        }
        BlockInfo[] blocks = this.getBlocks();
        return blocks == null || blocks.length == 0 ? null : blocks[blocks.length - 1];
    }

    @Override
    public int numBlocks() throws StorageException, TransactionContextException {
        BlockInfo[] blocks = this.getBlocks();
        return blocks == null ? 0 : blocks.length;
    }

    final long getBlockDiskspace() {
        return this.getPreferredBlockSize() * (long)this.getBlockReplication();
    }

    void setReplication(short replication) throws StorageException, TransactionContextException {
        this.header = INode.HeaderFormat.combineReplication(this.header, replication);
        this.save();
    }

    public INodeFile toUnderConstruction(String clientName, String clientMachine, DatanodeID clientNode) throws IOException {
        FileUnderConstructionFeature uc = new FileUnderConstructionFeature(clientName, clientMachine, clientNode, this);
        this.addFeature(uc);
        this.save();
        return this;
    }

    public INodeFile toCompleteFile(long mtime) throws IOException, StorageException {
        FileUnderConstructionFeature uc = this.getFileUnderConstructionFeature();
        if (uc != null) {
            if (!this.isFileStoredInDB()) assert (this.assertAllBlocksComplete()) : "Can't finalize inode " + this + " since it contains non-complete blocks! Blocks are " + this.getBlocks();
            this.removeFeature(uc);
            this.setModificationTime(mtime);
        }
        return this;
    }

    private boolean assertAllBlocksComplete() throws StorageException, TransactionContextException {
        for (BlockInfo b : this.getBlocks()) {
            if (b.isComplete()) continue;
            return false;
        }
        return true;
    }

    @Override
    public BlockInfoUnderConstruction setLastBlock(BlockInfo lastBlock, DatanodeStorageInfo[] locations) throws IOException {
        Preconditions.checkState((boolean)this.isUnderConstruction());
        if (this.numBlocks() == 0) {
            throw new IOException("Failed to set last block: File is empty.");
        }
        BlockInfoUnderConstruction ucBlock = lastBlock.convertToBlockUnderConstruction(HdfsServerConstants.BlockUCState.UNDER_CONSTRUCTION, locations);
        ucBlock.setBlockCollection(this);
        this.setBlock(this.numBlocks() - 1, ucBlock);
        return ucBlock;
    }

    boolean removeLastBlock(Block oldBlock) throws IOException, StorageException {
        BlockInfo[] blocks = this.getBlocks();
        if (blocks == null || blocks.length == 0) {
            return false;
        }
        int size_1 = blocks.length - 1;
        if (!blocks[size_1].equals(oldBlock)) {
            return false;
        }
        this.removeBlock(blocks[blocks.length - 1]);
        return true;
    }

    public void removeBlock(BlockInfo block) throws StorageException, TransactionContextException {
        BlockInfo[] blks = this.getBlocks();
        int index = block.getBlockIndex();
        block.setBlockCollection(null);
        if (index != blks.length) {
            for (int i = index + 1; i < blks.length; ++i) {
                blks[i].setBlockIndex(i - 1);
            }
        }
    }

    public BlockInfo findMaxBlk() throws StorageException, TransactionContextException {
        BlockInfo maxBlk = (BlockInfo)EntityManager.find((FinderType)BlockInfo.Finder.ByMaxBlockIndexForINode, (Object[])new Object[]{this.getId()});
        return maxBlk;
    }

    public int getGenerationStamp() {
        return this.generationStamp;
    }

    public void setGenerationStampNoPersistence(int generationStamp) {
        this.generationStamp = generationStamp;
    }

    public int nextGenerationStamp() throws StorageException, TransactionContextException {
        ++this.generationStamp;
        this.save();
        return this.generationStamp;
    }

    public long getSize() {
        return this.size;
    }

    public boolean isFileStoredInDB() {
        return this.isFileStoredInDB;
    }

    public void setFileStoredInDB(boolean isFileStoredInDB) throws StorageException, TransactionContextException {
        this.setFileStoredInDBNoPersistence(isFileStoredInDB);
        this.save();
    }

    public void setFileStoredInDBNoPersistence(boolean isFileStoredInDB) {
        this.isFileStoredInDB = isFileStoredInDB;
    }

    public void setSizeNoPersistence(long size) {
        this.size = size;
    }

    public void setSize(long size) throws TransactionContextException, StorageException {
        this.setSizeNoPersistence(size);
        this.save();
    }

    public void recomputeFileSize() throws StorageException, TransactionContextException {
        this.setSizeNoPersistence(this.computeFileSize(true));
        this.save();
    }

    protected List<BlockInfo> getBlocksOrderedByIndex() throws TransactionContextException, StorageException {
        if (!this.isInTree()) {
            return null;
        }
        List blocks = (List)EntityManager.findList((FinderType)BlockInfo.Finder.ByINodeId, (Object[])new Object[]{this.id});
        if (blocks != null) {
            Collections.sort(blocks, BlockInfo.Order.ByBlockIndex);
            return blocks;
        }
        return null;
    }

    @Override
    public INode cloneInode() throws IOException {
        return new INodeFile(this);
    }
}

