/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.transaction.EntityManager;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.server.namenode.AclFeature;
import org.apache.hadoop.hdfs.server.namenode.Content;
import org.apache.hadoop.hdfs.server.namenode.ContentSummaryComputationContext;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeWithAdditionalFields;

@InterfaceAudience.Private
public class INodeSymlink
extends INodeWithAdditionalFields {
    private final byte[] symlink;

    public INodeSymlink(long id, String value, long mtime, long atime, PermissionStatus permissions) throws IOException {
        this(id, value, mtime, atime, permissions, false);
    }

    public INodeSymlink(long id, String value, long mtime, long atime, PermissionStatus permissions, boolean inTree) throws IOException {
        super(id, permissions, mtime, atime, inTree);
        this.symlink = DFSUtil.string2Bytes(value);
    }

    public INodeSymlink(INodeSymlink other) throws IOException {
        super(other);
        this.symlink = Arrays.copyOf(other.symlink, other.symlink.length);
    }

    @Override
    public boolean isSymlink() {
        return true;
    }

    @Override
    public INodeSymlink asSymlink() {
        return this;
    }

    public String getSymlinkString() {
        return DFSUtil.bytes2String(this.symlink);
    }

    public byte[] getSymlink() {
        return this.symlink;
    }

    @Override
    INode.DirCounts spaceConsumedInTree(INode.DirCounts counts) {
        ++counts.nsCount;
        return counts;
    }

    @Override
    int collectSubtreeBlocksAndClear(INode.BlocksMapUpdateInfo info) throws StorageException, TransactionContextException {
        EntityManager.remove((Object)this);
        return 1;
    }

    @Override
    ContentSummaryComputationContext computeContentSummary(ContentSummaryComputationContext summary) {
        summary.getCounts().add(Content.SYMLINK, 1L);
        return summary;
    }

    @Override
    public byte getStoragePolicyID() {
        throw new UnsupportedOperationException("Storage policy are not supported on symlinks");
    }

    @Override
    public byte getLocalStoragePolicyID() {
        throw new UnsupportedOperationException("Storage policy are not supported on symlinks");
    }

    @Override
    public INode cloneInode() throws IOException {
        return new INodeSymlink(this);
    }

    @Override
    public void removeAclFeature() {
        throw new UnsupportedOperationException("ACLs are not supported on symlinks");
    }

    @Override
    public void addAclFeature(AclFeature f) {
        throw new UnsupportedOperationException("ACLs are not supported on symlinks");
    }
}

