/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.hash.Hashing;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.Replica;
import org.apache.hadoop.hdfs.server.protocol.BlockReportBlockState;
import org.apache.hadoop.hdfs.server.protocol.Bucket;
import org.apache.hadoop.hdfs.server.protocol.ReportedBlock;

public class BlockReport
implements Iterable<ReportedBlock> {
    private Bucket[] buckets;
    private long[] hashes;
    private int numBlocks;

    public Bucket[] getBuckets() {
        return this.buckets;
    }

    public long[] getHashes() {
        return this.hashes;
    }

    public int getNumberOfBlocks() {
        return this.numBlocks;
    }

    public BlockReport(Bucket[] buckets, long[] hashes, int numBlocks) {
        this.buckets = buckets;
        this.hashes = hashes;
        this.numBlocks = numBlocks;
    }

    @VisibleForTesting
    public Iterable<Block> blockIterable() {
        return new Iterable<Block>(){

            @Override
            public Iterator<Block> iterator() {
                return new Iterator<Block>(){
                    Iterator<ReportedBlock> it;
                    {
                        this.it = BlockReport.this.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public Block next() {
                        ReportedBlock next = this.it.next();
                        return new Block(next.getBlockId(), next.getLength(), next.getGenerationStamp());
                    }
                };
            }
        };
    }

    @Override
    public Iterator<ReportedBlock> iterator() {
        return new BlockReportIterator();
    }

    public static Builder builder(int numBuckets) {
        return new Builder(numBuckets);
    }

    public static int bucket(Replica replica, int numBuckets) {
        return BlockReport.bucket(replica.getBlockId(), numBuckets);
    }

    private static int bucket(Block block, int numBuckets) {
        return BlockReport.bucket(block.getBlockId(), numBuckets);
    }

    private static int bucket(long blockId, int numBuckets) {
        int reminder = (int)(blockId % (long)numBuckets);
        return reminder >= 0 ? reminder : numBuckets + reminder;
    }

    @VisibleForTesting
    public BlockReport corruptBlockGSForTesting(int blockIndex, Random rand) {
        Builder corruptReportBuilder = BlockReport.builder(this.buckets.length);
        int i = 0;
        for (ReportedBlock reportedBlock : this) {
            ReportedBlock toAdd = i == blockIndex ? new ReportedBlock(reportedBlock.getBlockId(), rand.nextInt(), reportedBlock.getLength(), reportedBlock.getState()) : reportedBlock;
            corruptReportBuilder.add(toAdd);
            ++i;
        }
        return corruptReportBuilder.build();
    }

    @VisibleForTesting
    public BlockReport corruptBlockLengthForTesting(int blockIndex, Random rand) {
        Builder corruptReportBuilder = BlockReport.builder(this.buckets.length);
        int i = 0;
        for (ReportedBlock reportedBlock : this) {
            ReportedBlock toAdd = i == blockIndex ? new ReportedBlock(reportedBlock.getBlockId(), reportedBlock.getGenerationStamp(), rand.nextInt(), reportedBlock.getState()) : reportedBlock;
            corruptReportBuilder.add(toAdd);
            ++i;
        }
        return corruptReportBuilder.build();
    }

    private static long hashAsFinalized(Block theBlock) {
        return BlockReport.hash(theBlock.getBlockId(), theBlock.getGenerationStamp(), theBlock.getNumBytes(), HdfsServerConstants.ReplicaState.FINALIZED.getValue());
    }

    public static long hashAsFinalized(ReportedBlock block) {
        Block toHash = new Block(block.getBlockId(), block.getLength(), block.getGenerationStamp());
        return BlockReport.hashAsFinalized(toHash);
    }

    private static long hash(Replica replica) {
        return BlockReport.hash(replica.getBlockId(), replica.getGenerationStamp(), replica.getNumBytes(), replica.getState().getValue());
    }

    public static long hash(Block block, HdfsServerConstants.ReplicaState state) {
        return BlockReport.hash(block.getBlockId(), block.getGenerationStamp(), block.getNumBytes(), state.getValue());
    }

    private static long hash(long blockId, long generationStamp, long numBytes, int replicaState) {
        return Hashing.md5().newHasher().putLong(blockId).putLong(generationStamp).putLong(numBytes).putInt(replicaState).hash().asLong();
    }

    private class BlockReportIterator
    implements Iterator<ReportedBlock> {
        int currentBucket = 0;
        int currentBucketOffset = 0;

        BlockReportIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.currentBucket < BlockReport.this.buckets.length) {
                if (this.currentBucketOffset < BlockReport.this.buckets[this.currentBucket].getBlocks().length) {
                    return true;
                }
                ++this.currentBucket;
                this.currentBucketOffset = 0;
                return this.hasNext();
            }
            return false;
        }

        @Override
        public ReportedBlock next() {
            if (this.hasNext()) {
                return BlockReport.this.buckets[this.currentBucket].getBlocks()[this.currentBucketOffset++];
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not allowed to remove blocks from blockReport.");
        }
    }

    public static class Builder {
        private final int NUM_BUCKETS;
        private ArrayList<ReportedBlock>[] buckets;
        private long[] hashes;
        private int blockCounter = 0;

        private Builder(int numBuckets) {
            this.NUM_BUCKETS = numBuckets;
            this.buckets = new ArrayList[this.NUM_BUCKETS];
            this.hashes = new long[this.NUM_BUCKETS];
            for (int i = 0; i < this.NUM_BUCKETS; ++i) {
                this.buckets[i] = new ArrayList();
            }
        }

        @VisibleForTesting
        public Builder add(ReportedBlock reportBlock) {
            int bucket = BlockReport.bucket(reportBlock.getBlockId(), this.NUM_BUCKETS);
            this.buckets[bucket].add(reportBlock);
            HdfsServerConstants.ReplicaState replicaState = null;
            switch (reportBlock.getState()) {
                case FINALIZED: {
                    replicaState = HdfsServerConstants.ReplicaState.FINALIZED;
                    break;
                }
                case RBW: {
                    replicaState = HdfsServerConstants.ReplicaState.RBW;
                    break;
                }
                case RUR: {
                    replicaState = HdfsServerConstants.ReplicaState.RUR;
                    break;
                }
                case RWR: {
                    replicaState = HdfsServerConstants.ReplicaState.RWR;
                    break;
                }
                case TEMPORARY: {
                    replicaState = HdfsServerConstants.ReplicaState.TEMPORARY;
                }
            }
            int n = bucket;
            this.hashes[n] = this.hashes[n] + BlockReport.hash(reportBlock.getBlockId(), reportBlock.getGenerationStamp(), reportBlock.getLength(), replicaState.getValue());
            ++this.blockCounter;
            return this;
        }

        public Builder add(Replica replica) {
            int bucket = BlockReport.bucket(replica, this.NUM_BUCKETS);
            this.buckets[bucket].add(new ReportedBlock(replica.getBlockId(), replica.getGenerationStamp(), replica.getNumBytes(), this.fromReplicaState(replica.getState())));
            int n = bucket;
            this.hashes[n] = this.hashes[n] + BlockReport.hash(replica);
            ++this.blockCounter;
            return this;
        }

        public Builder addAllAsFinalized(List<Block> blocks) {
            for (Block block : blocks) {
                this.addAsFinalized(block);
            }
            return this;
        }

        public Builder addAsFinalized(Block theBlock) {
            int bucket = BlockReport.bucket(theBlock, this.NUM_BUCKETS);
            this.buckets[bucket].add(new ReportedBlock(theBlock.getBlockId(), theBlock.getGenerationStamp(), theBlock.getNumBytes(), BlockReportBlockState.FINALIZED));
            int n = bucket;
            this.hashes[n] = this.hashes[n] + BlockReport.hashAsFinalized(theBlock);
            ++this.blockCounter;
            return this;
        }

        public BlockReport build() {
            Bucket[] bucketArray = new Bucket[this.NUM_BUCKETS];
            for (int i = 0; i < this.NUM_BUCKETS; ++i) {
                bucketArray[i] = new Bucket(this.buckets[i].toArray(new ReportedBlock[this.buckets[i].size()]));
            }
            return new BlockReport(bucketArray, this.hashes, this.blockCounter);
        }

        private BlockReportBlockState fromReplicaState(HdfsServerConstants.ReplicaState state) {
            switch (state) {
                case FINALIZED: {
                    return BlockReportBlockState.FINALIZED;
                }
                case RBW: {
                    return BlockReportBlockState.RBW;
                }
                case RUR: {
                    return BlockReportBlockState.RUR;
                }
                case RWR: {
                    return BlockReportBlockState.RWR;
                }
                case TEMPORARY: {
                    return BlockReportBlockState.TEMPORARY;
                }
            }
            throw new RuntimeException("Unimplemented state");
        }
    }
}

