/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import java.io.PrintStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LightWeightHashSet<T>
implements Collection<T> {
    protected static final float DEFAULT_MAX_LOAD_FACTOR = 0.75f;
    protected static final float DEFAUT_MIN_LOAD_FACTOR = 0.2f;
    protected static final int MINIMUM_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final Log LOG = LogFactory.getLog(LightWeightHashSet.class);
    protected LinkedElement<T>[] entries;
    private int capacity;
    protected int size = 0;
    private int hash_mask;
    private final int initialCapacity;
    protected int modification = 0;
    private float maxLoadFactor;
    private float minLoadFactor;
    private int expandMultiplier = 2;
    private int expandThreshold;
    private int shrinkThreshold;

    public LightWeightHashSet(int initCapacity, float maxLoadFactor, float minLoadFactor) {
        if (maxLoadFactor <= 0.0f || maxLoadFactor > 1.0f) {
            throw new IllegalArgumentException("Illegal maxload factor: " + maxLoadFactor);
        }
        if (minLoadFactor <= 0.0f || minLoadFactor > maxLoadFactor) {
            throw new IllegalArgumentException("Illegal minload factor: " + minLoadFactor);
        }
        this.capacity = this.initialCapacity = this.computeCapacity(initCapacity);
        this.hash_mask = this.capacity - 1;
        this.maxLoadFactor = maxLoadFactor;
        this.expandThreshold = (int)((float)this.capacity * maxLoadFactor);
        this.minLoadFactor = minLoadFactor;
        this.shrinkThreshold = (int)((float)this.capacity * minLoadFactor);
        this.entries = new LinkedElement[this.capacity];
        LOG.debug((Object)("initial capacity=" + this.initialCapacity + ", max load factor= " + maxLoadFactor + ", min load factor= " + minLoadFactor));
    }

    public LightWeightHashSet() {
        this(16, 0.75f, 0.2f);
    }

    public LightWeightHashSet(int minCapacity) {
        this(minCapacity, 0.75f, 0.2f);
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public int size() {
        return this.size;
    }

    protected int getIndex(int hashCode) {
        return hashCode & this.hash_mask;
    }

    @Override
    public boolean contains(Object key) {
        return this.getElement(key) != null;
    }

    public T getElement(T key) {
        if (key == null) {
            throw new IllegalArgumentException("Null element is not supported.");
        }
        int hashCode = key.hashCode();
        int index = this.getIndex(hashCode);
        return this.getContainedElem(index, key, hashCode);
    }

    protected T getContainedElem(int index, T key, int hashCode) {
        LinkedElement<T> e = this.entries[index];
        while (e != null) {
            if (hashCode == e.hashCode && e.element.equals(key)) {
                return e.element;
            }
            e = e.next;
        }
        return null;
    }

    @Override
    public boolean addAll(Collection<? extends T> toAdd) {
        boolean changed = false;
        for (T elem : toAdd) {
            changed |= this.addElem(elem);
        }
        this.expandIfNecessary();
        return changed;
    }

    @Override
    public boolean add(T element) {
        boolean added = this.addElem(element);
        this.expandIfNecessary();
        return added;
    }

    protected boolean addElem(T element) {
        if (element == null) {
            throw new IllegalArgumentException("Null element is not supported.");
        }
        int hashCode = element.hashCode();
        int index = this.getIndex(hashCode);
        if (this.getContainedElem(index, element, hashCode) != null) {
            return false;
        }
        ++this.modification;
        ++this.size;
        LinkedElement<T> le = new LinkedElement<T>(element, hashCode);
        le.next = this.entries[index];
        this.entries[index] = le;
        return true;
    }

    @Override
    public boolean remove(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("Null element is not supported.");
        }
        LinkedElement<Object> removed = this.removeElem(key);
        this.shrinkIfNecessary();
        return removed != null;
    }

    protected LinkedElement<T> removeElem(T key) {
        LinkedElement found = null;
        int hashCode = key.hashCode();
        int index = this.getIndex(hashCode);
        if (this.entries[index] == null) {
            return null;
        }
        if (hashCode == this.entries[index].hashCode && this.entries[index].element.equals(key)) {
            ++this.modification;
            --this.size;
            found = this.entries[index];
            this.entries[index] = found.next;
        } else {
            LinkedElement<T> prev = this.entries[index];
            found = prev.next;
            while (found != null) {
                if (hashCode == found.hashCode && found.element.equals(key)) {
                    ++this.modification;
                    --this.size;
                    prev.next = found.next;
                    found.next = null;
                    break;
                }
                prev = found;
                found = found.next;
            }
        }
        return found;
    }

    public List<T> pollN(int n) {
        if (n >= this.size) {
            return this.pollAll();
        }
        ArrayList retList = new ArrayList(n);
        if (n == 0) {
            return retList;
        }
        boolean done = false;
        int currentBucketIndex = 0;
        while (!done) {
            LinkedElement<T> current = this.entries[currentBucketIndex];
            while (current != null) {
                retList.add(current.element);
                this.entries[currentBucketIndex] = current = current.next;
                --this.size;
                ++this.modification;
                if (--n != 0) continue;
                done = true;
                break;
            }
            ++currentBucketIndex;
        }
        this.shrinkIfNecessary();
        return retList;
    }

    public List<T> pollAll() {
        ArrayList retList = new ArrayList(this.size);
        LinkedElement<T>[] linkedElementArray = this.entries;
        int n = linkedElementArray.length;
        for (int i = 0; i < n; ++i) {
            LinkedElement<T> entry;
            LinkedElement<T> current = entry = linkedElementArray[i];
            while (current != null) {
                retList.add(current.element);
                current = current.next;
            }
        }
        this.clear();
        return retList;
    }

    public T[] pollToArray(T[] array) {
        int currentIndex = 0;
        LinkedElement<T> current = null;
        if (array.length == 0) {
            return array;
        }
        if (array.length > this.size) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), this.size);
        }
        if (array.length == this.size) {
            LinkedElement<T>[] linkedElementArray = this.entries;
            int n = linkedElementArray.length;
            for (int i = 0; i < n; ++i) {
                LinkedElement<T> entry;
                current = entry = linkedElementArray[i];
                while (current != null) {
                    array[currentIndex++] = current.element;
                    current = current.next;
                }
            }
            this.clear();
            return array;
        }
        boolean done = false;
        int currentBucketIndex = 0;
        while (!done) {
            current = this.entries[currentBucketIndex];
            while (current != null) {
                array[currentIndex++] = current.element;
                this.entries[currentBucketIndex] = current = current.next;
                --this.size;
                ++this.modification;
                if (currentIndex != array.length) continue;
                done = true;
                break;
            }
            ++currentBucketIndex;
        }
        this.shrinkIfNecessary();
        return array;
    }

    private int computeCapacity(int initial) {
        int capacity;
        if (initial < 16) {
            return 16;
        }
        if (initial > 0x40000000) {
            return 0x40000000;
        }
        for (capacity = 1; capacity < initial; capacity <<= 1) {
        }
        return capacity;
    }

    private void resize(int cap) {
        int newCapacity = this.computeCapacity(cap);
        if (newCapacity == this.capacity) {
            return;
        }
        this.capacity = newCapacity;
        this.expandThreshold = (int)((float)this.capacity * this.maxLoadFactor);
        this.shrinkThreshold = (int)((float)this.capacity * this.minLoadFactor);
        this.hash_mask = this.capacity - 1;
        LinkedElement<T>[] temp = this.entries;
        this.entries = new LinkedElement[this.capacity];
        LinkedElement<T>[] linkedElementArray = temp;
        int n = linkedElementArray.length;
        for (int i = 0; i < n; ++i) {
            LinkedElement<T> aTemp;
            LinkedElement<T> curr = aTemp = linkedElementArray[i];
            while (curr != null) {
                LinkedElement next = curr.next;
                int index = this.getIndex(curr.hashCode);
                curr.next = this.entries[index];
                this.entries[index] = curr;
                curr = next;
            }
        }
    }

    protected void shrinkIfNecessary() {
        if (this.size < this.shrinkThreshold && this.capacity > this.initialCapacity) {
            this.resize(this.capacity / this.expandMultiplier);
        }
    }

    protected void expandIfNecessary() {
        if (this.size > this.expandThreshold && this.capacity < 0x40000000) {
            this.resize(this.capacity * this.expandMultiplier);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new LinkedSetIterator();
    }

    public String toString() {
        StringBuilder b = new StringBuilder(this.getClass().getSimpleName());
        b.append("(size=").append(this.size).append(", modification=").append(this.modification).append(", entries.length=").append(this.entries.length).append(")");
        return b.toString();
    }

    public void printDetails(PrintStream out) {
        out.print(this + ", entries = [");
        for (int i = 0; i < this.entries.length; ++i) {
            if (this.entries[i] == null) continue;
            LinkedElement<T> e = this.entries[i];
            out.print("\n  " + i + ": " + e);
            e = e.next;
            while (e != null) {
                out.print(" -> " + e);
                e = e.next;
            }
        }
        out.println("\n]");
    }

    @Override
    public void clear() {
        this.capacity = this.initialCapacity;
        this.hash_mask = this.capacity - 1;
        this.expandThreshold = (int)((float)this.capacity * this.maxLoadFactor);
        this.shrinkThreshold = (int)((float)this.capacity * this.minLoadFactor);
        this.entries = new LinkedElement[this.capacity];
        this.size = 0;
        ++this.modification;
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size];
        return this.toArray((U[])result);
    }

    @Override
    public <U> U[] toArray(U[] a) {
        if (a == null) {
            throw new NullPointerException("Input array can not be null");
        }
        if (a.length < this.size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        }
        int currentIndex = 0;
        LinkedElement<T>[] linkedElementArray = this.entries;
        int n = linkedElementArray.length;
        for (int i = 0; i < n; ++i) {
            LinkedElement<T> entry;
            LinkedElement<T> current = entry = linkedElementArray[i];
            while (current != null) {
                a[currentIndex++] = current.element;
                current = current.next;
            }
        }
        return a;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object aC : c) {
            if (this.contains(aC)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object aC : c) {
            changed |= this.remove(aC);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("retainAll is not supported.");
    }

    private class LinkedSetIterator
    implements Iterator<T> {
        private final int startModification;
        private int index;
        private LinkedElement<T> next;

        private LinkedSetIterator() {
            this.startModification = LightWeightHashSet.this.modification;
            this.index = -1;
            this.next = this.nextNonemptyEntry();
        }

        private LinkedElement<T> nextNonemptyEntry() {
            ++this.index;
            while (this.index < LightWeightHashSet.this.entries.length && LightWeightHashSet.this.entries[this.index] == null) {
                ++this.index;
            }
            return this.index < LightWeightHashSet.this.entries.length ? LightWeightHashSet.this.entries[this.index] : null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            if (LightWeightHashSet.this.modification != this.startModification) {
                throw new ConcurrentModificationException("modification=" + LightWeightHashSet.this.modification + " != startModification = " + this.startModification);
            }
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Object e = this.next.element;
            LinkedElement n = this.next.next;
            this.next = n != null ? n : this.nextNonemptyEntry();
            return e;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported.");
        }
    }

    static class LinkedElement<T> {
        protected final T element;
        protected LinkedElement<T> next;
        protected final int hashCode;

        public LinkedElement(T elem, int hash) {
            this.element = elem;
            this.next = null;
            this.hashCode = hash;
        }

        public String toString() {
            return this.element.toString();
        }
    }
}

