/*
 * Decompiled with CFR 0.152.
 */
package io.hops.security;

import io.hops.exception.UniqueKeyConstraintViolationException;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.hdfs.dal.GroupDataAccess;
import io.hops.metadata.hdfs.dal.UserDataAccess;
import io.hops.metadata.hdfs.dal.UserGroupDataAccess;
import io.hops.security.UsersGroups;
import io.hops.security.UsersGroupsCache;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.LightWeightRequestHandler;
import io.hops.transaction.handler.RequestHandler;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.JniBasedUnixGroupsMappingWithFallback;
import org.apache.hadoop.security.UserGroupInformation;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestUsersGroups {
    static UsersGroupsCache newUsersGroupsMapping(Configuration conf) {
        return new UsersGroupsCache((UserDataAccess)HdfsStorageFactory.getDataAccess(UserDataAccess.class), (UserGroupDataAccess)HdfsStorageFactory.getDataAccess(UserGroupDataAccess.class), (GroupDataAccess)HdfsStorageFactory.getDataAccess(GroupDataAccess.class), conf.getInt("hops.ug.cache.secs", 120), conf.getInt("hops.ug.cache.size", 10000));
    }

    @After
    public void afterTest() {
        UsersGroups.stop();
    }

    @Test
    public void testGroupsCacheIsEnabled() {
        HdfsConfiguration conf = new HdfsConfiguration();
        Assert.assertFalse((boolean)Groups.getUserToGroupsMappingServiceWithLoadedConfiguration((Configuration)conf).isCacheEnabled());
        conf.set("hadoop.security.group.mapping", "org.apache.hadoop.security.JniBasedUnixGroupsMappingWithFallback");
        Assert.assertTrue((boolean)Groups.getUserToGroupsMappingServiceWithLoadedConfiguration((Configuration)conf).isCacheEnabled());
        conf.set("hadoop.security.group.mapping", "io.hops.security.HopsGroupsWithFallBack");
        Assert.assertFalse((boolean)Groups.getUserToGroupsMappingServiceWithLoadedConfiguration((Configuration)conf).isCacheEnabled());
    }

    @Test
    public void testUsersGroupsCache() throws Exception {
        int groupId;
        Configuration conf = new Configuration();
        HdfsStorageFactory.resetDALInitialized();
        HdfsStorageFactory.setConfiguration((Configuration)conf);
        HdfsStorageFactory.formatStorage();
        UsersGroupsCache cache = TestUsersGroups.newUsersGroupsMapping(conf);
        String currentUser = "user0";
        String[] groups = new String[3];
        for (int i = 0; i < 3; ++i) {
            groups[i] = "group" + i;
        }
        Assert.assertEquals((long)cache.getUserId(currentUser), (long)0L);
        cache.addUserToGroups(currentUser, Arrays.copyOfRange(groups, 0, 2));
        int userId = cache.getUserId(currentUser);
        Assert.assertNotEquals((long)userId, (long)0L);
        Assert.assertEquals((Object)currentUser, (Object)cache.getUserName(Integer.valueOf(userId)));
        for (int i = 0; i < 2; ++i) {
            groupId = cache.getGroupId(groups[i]);
            Assert.assertNotEquals((long)groupId, (long)0L);
            Assert.assertEquals((Object)groups[i], (Object)cache.getGroupName(Integer.valueOf(groupId)));
        }
        Assert.assertEquals((long)cache.getGroupId(groups[2]), (long)0L);
        List cachedGroups = cache.getGroups(currentUser);
        Assert.assertNotNull((Object)cachedGroups);
        Assert.assertTrue((boolean)cachedGroups.equals(Arrays.asList(groups[0], groups[1])));
        cache.removeGroup(groups[0]);
        groupId = cache.getGroupId(groups[0]);
        Assert.assertEquals((long)groupId, (long)0L);
        cachedGroups = cache.getGroups(currentUser);
        Assert.assertNotNull((Object)cachedGroups);
        Assert.assertTrue((boolean)cachedGroups.equals(Arrays.asList(groups[1])));
        groupId = cache.getGroupId(groups[1]);
        cache.removeGroup(groups[1]);
        String groupName = cache.getGroupName(Integer.valueOf(groupId));
        Assert.assertNull((Object)groupName);
        cachedGroups = cache.getGroups(currentUser);
        Assert.assertNull((Object)cachedGroups);
        cache.addGroup(groups[2]);
        groupId = cache.getGroupId(groups[2]);
        Assert.assertNotEquals((long)groupId, (long)0L);
        cachedGroups = cache.getGroups(currentUser);
        Assert.assertNull((Object)cachedGroups);
        cache.addUserToGroup(currentUser, groups[2]);
        cachedGroups = cache.getGroups(currentUser);
        Assert.assertNotNull((Object)cachedGroups);
        Assert.assertTrue((boolean)cachedGroups.equals(Arrays.asList(groups[2])));
    }

    @Test
    public void testCacheEviction() throws Exception {
        int i;
        Configuration conf = new Configuration();
        HdfsStorageFactory.resetDALInitialized();
        HdfsStorageFactory.setConfiguration((Configuration)conf);
        HdfsStorageFactory.formatStorage();
        int CACHE_SIZE = 5;
        int CACHE_SECS = 5;
        conf.setInt("hops.ug.cache.size", 5);
        conf.setInt("hops.ug.cache.secs", 5);
        UsersGroupsCache cache = TestUsersGroups.newUsersGroupsMapping(conf);
        String[] users = new String[5];
        int[] usersIds = new int[5];
        String[] groups = new String[5];
        for (i = 0; i < 5; ++i) {
            users[i] = "user" + i;
            groups[i] = "group" + i;
        }
        for (i = 0; i < 5; ++i) {
            cache.addUserToGroups(users[i], Arrays.copyOfRange(groups, i, i == 4 ? i + 1 : i + 2));
            usersIds[i] = cache.getUserId(users[i]);
        }
        for (i = 0; i < 5; ++i) {
            List cachedGroups = cache.getGroups(users[i]);
            Assert.assertNotNull((Object)cachedGroups);
            Collections.sort(cachedGroups);
            Assert.assertEquals(Arrays.asList(Arrays.copyOfRange(groups, i, i == 4 ? i + 1 : i + 2)), (Object)cachedGroups);
        }
        String newUser = "newUser";
        cache.addUser(newUser);
        int newUserId = cache.getUserId(newUser);
        Assert.assertNotEquals((long)newUserId, (long)0L);
        Assert.assertEquals((Object)cache.getUserName(Integer.valueOf(newUserId)), (Object)newUser);
        Assert.assertNull((Object)cache.getUserIdFromCache(users[0]));
        Assert.assertNotNull((Object)cache.getGroupsFromCache(users[0]));
        cache.addUserToGroups(newUser, Arrays.copyOfRange(groups, 0, 3));
        Assert.assertNull((Object)cache.getGroupsFromCache(users[1]));
        Assert.assertNotNull((Object)cache.getGroupsFromCache(newUser));
        List cachedGroups = cache.getGroups(newUser);
        Collections.sort(cachedGroups);
        Assert.assertEquals(Arrays.asList(Arrays.copyOfRange(groups, 0, 3)), (Object)cachedGroups);
        Assert.assertEquals((long)cache.getUserId(users[0]), (long)usersIds[0]);
        String newGroup = "newgroup";
        cache.addGroup(newGroup);
        int newGroupId = cache.getGroupId(newGroup);
        Assert.assertNotEquals((long)newGroupId, (long)0L);
        Assert.assertEquals((Object)cache.getGroupName(Integer.valueOf(newGroupId)), (Object)newGroup);
        Assert.assertNull((Object)cache.getGroupIdFromCache(groups[0]));
        cache.addUserToGroup(newUser, newGroup);
        cachedGroups = cache.getGroups(newUser);
        Collections.sort(cachedGroups);
        Assert.assertEquals(Arrays.asList(groups[0], groups[1], groups[2], newGroup), (Object)cachedGroups);
        cache.removeGroupFromCache(newGroup);
        Assert.assertNull((Object)cache.getGroupIdFromCache(newGroup));
        cachedGroups = cache.getGroups(newUser);
        Collections.sort(cachedGroups);
        Assert.assertEquals(Arrays.asList(groups[0], groups[1], groups[2]), (Object)cachedGroups);
        Thread.sleep(5000L);
        cachedGroups = cache.getGroups(newUser);
        Collections.sort(cachedGroups);
        Assert.assertEquals(Arrays.asList(groups[0], groups[1], groups[2], newGroup), (Object)cachedGroups);
        cache.addUserToGroup(newUser, newGroup);
        cachedGroups = cache.getGroups(newUser);
        Collections.sort(cachedGroups);
        Assert.assertEquals(Arrays.asList(groups[0], groups[1], groups[2], newGroup), (Object)cachedGroups);
        Assert.assertNotNull((Object)cache.getGroupIdFromCache(newGroup));
        Assert.assertEquals((long)newGroupId, (long)cache.getGroupIdFromCache(newGroup).intValue());
        cache.removeGroup(groups[0]);
        Assert.assertNull((Object)cache.getGroupIdFromCache(groups[0]));
        Assert.assertEquals((long)0L, (long)cache.getGroupId(groups[0]));
        Assert.assertNull((Object)cache.getGroupsFromCache(users[0]));
        Assert.assertEquals(Arrays.asList(groups[1]), (Object)cache.getGroups(users[0]));
        Assert.assertEquals(Arrays.asList(groups[1]), (Object)cache.getGroupsFromCache(users[0]));
        cachedGroups = cache.getGroupsFromCache(newUser);
        Assert.assertNotNull((Object)cachedGroups);
        Collections.sort(cachedGroups);
        Assert.assertEquals(Arrays.asList(groups[1], groups[2], newGroup), (Object)cachedGroups);
        cachedGroups = cache.getGroups(newUser);
        Collections.sort(cachedGroups);
        Assert.assertEquals(Arrays.asList(groups[1], groups[2], newGroup), (Object)cachedGroups);
        cache.removeGroup(groups[1]);
        Assert.assertNull((Object)cache.getGroupIdFromCache(groups[1]));
        Assert.assertEquals((long)0L, (long)cache.getGroupId(groups[1]));
        Assert.assertNull((Object)cache.getGroupsFromCache(users[0]));
        Assert.assertNull((Object)cache.getGroups(users[0]));
        cachedGroups = cache.getGroupsFromCache(newUser);
        Assert.assertNotNull((Object)cachedGroups);
        Collections.sort(cachedGroups);
        Assert.assertEquals(Arrays.asList(groups[2], newGroup), (Object)cachedGroups);
        cache.removeUser(newUser);
        Assert.assertNull((Object)cache.getUserIdFromCache(newUser));
        Assert.assertEquals((long)0L, (long)cache.getUserId(newUser));
        Assert.assertNull((Object)cache.getGroupsFromCache(newUser));
        Assert.assertNull((Object)cache.getGroups(newUser));
    }

    @Test
    public void testAddRemoveUsersGroups() throws IOException {
        Configuration conf = new Configuration();
        HdfsStorageFactory.resetDALInitialized();
        HdfsStorageFactory.setConfiguration((Configuration)conf);
        HdfsStorageFactory.formatStorage();
        UsersGroupsCache cache = TestUsersGroups.newUsersGroupsMapping(conf);
        String user = "user";
        cache.addUserToGroupTx(user, null, false);
        int userId = cache.getUserId(user);
        Assert.assertNotSame((Object)0, (Object)userId);
        Assert.assertEquals((Object)user, (Object)cache.getUserName(Integer.valueOf(userId)));
        String group = "group";
        cache.addUserToGroupTx(null, group, false);
        int groupId = cache.getGroupId(group);
        Assert.assertNotSame((Object)0, (Object)groupId);
        Assert.assertEquals((Object)group, (Object)cache.getGroupName(Integer.valueOf(groupId)));
        List groups = cache.getGroups(user);
        Assert.assertNotNull((Object)groups);
        Assert.assertTrue((boolean)groups.isEmpty());
        cache.addUserToGroupTx(user, group, false);
        groups = cache.getGroups(user);
        Assert.assertNotNull((Object)groups);
        Assert.assertEquals(Arrays.asList(group), (Object)groups);
        cache.addUserToGroupTx(user, group, true);
        groups = cache.getGroupsFromCache(user);
        Assert.assertNotNull((Object)groups);
        Assert.assertEquals(Arrays.asList(group), (Object)groups);
        cache.removeUserFromGroupTx(user, group, true);
        Assert.assertNull((Object)cache.getGroupsFromCache(user));
        Assert.assertNotNull((Object)cache.getGroups(user));
        Assert.assertEquals(Arrays.asList(group), (Object)cache.getGroups(user));
        cache.removeUserFromGroupTx(null, group, true);
        Assert.assertNull((Object)cache.getGroupIdFromCache(group));
        groupId = cache.getGroupId(group);
        Assert.assertNotSame((Object)0, (Object)groupId);
        cache.removeUserFromGroupTx(user, null, true);
        Assert.assertNull((Object)cache.getUserIdFromCache(user));
        userId = cache.getUserId(user);
        Assert.assertNotSame((Object)0, (Object)userId);
        cache.removeUserFromGroupTx(user, group, false);
        Assert.assertNull((Object)cache.getGroupsFromCache(user));
        Assert.assertNull((Object)cache.getGroups(user));
        cache.removeUserFromGroupTx(null, group, false);
        groupId = cache.getGroupId(group);
        Assert.assertNull((Object)cache.getGroupIdFromCache(group));
        Assert.assertEquals((long)0L, (long)groupId);
        cache.removeUserFromGroupTx(user, null, false);
        userId = cache.getUserId(user);
        Assert.assertNull((Object)cache.getUserIdFromCache(user));
        Assert.assertEquals((long)0L, (long)userId);
    }

    @Test
    public void testUsersGroupsNotConfigurad() throws IOException {
        UsersGroups.addUserToGroups((String)"user", (String[])new String[]{"group1", "group2"});
        Assert.assertEquals((long)UsersGroups.getGroupID((String)"group1"), (long)0L);
        Assert.assertEquals((long)UsersGroups.getUserID((String)"user"), (long)0L);
        Assert.assertNull((Object)UsersGroups.getGroups((String)"user"));
    }

    @Test
    public void testGetUnixUserGroups() throws Exception {
        Configuration conf = new Configuration();
        HdfsStorageFactory.resetDALInitialized();
        HdfsStorageFactory.setConfiguration((Configuration)conf);
        HdfsStorageFactory.formatStorage();
        UserGroupInformation ugi = UserGroupInformation.getLoginUser();
        JniBasedUnixGroupsMappingWithFallback jniGroupsMapping = new JniBasedUnixGroupsMappingWithFallback();
        List loginUserGroups = jniGroupsMapping.getGroups(ugi.getUserName());
        Assert.assertFalse((boolean)loginUserGroups.isEmpty());
        UsersGroups.addUserToGroupsTx((String)ugi.getUserName(), (String[])new String[0]);
        List ugiGroups = ugi.getGroups();
        Assert.assertFalse((boolean)ugiGroups.isEmpty());
        Assert.assertThat((Object)ugiGroups, (Matcher)Matchers.equalTo((Object)loginUserGroups));
    }

    @Test
    public void testAddUsers() throws IOException {
        Configuration conf = new Configuration();
        conf.setInt("hops.ug.cache.secs", 10);
        HdfsStorageFactory.resetDALInitialized();
        HdfsStorageFactory.setConfiguration((Configuration)conf);
        HdfsStorageFactory.formatStorage();
        UsersGroups.addUserToGroupsTx((String)"user", (String[])new String[]{"group1", "group2"});
        int userId = UsersGroups.getUserID((String)"user");
        Assert.assertNotSame((Object)0, (Object)userId);
        Assert.assertEquals((Object)UsersGroups.getUser((int)userId), (Object)"user");
        int groupId = UsersGroups.getGroupID((String)"group1");
        Assert.assertNotSame((Object)0, (Object)groupId);
        Assert.assertEquals((Object)UsersGroups.getGroup((int)groupId), (Object)"group1");
        Assert.assertThat((Object)UsersGroups.getGroups((String)"user"), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"group1", "group2"}));
        this.removeUser(userId);
        userId = UsersGroups.getUserID((String)"user");
        Assert.assertNotSame((Object)0, (Object)userId);
        try {
            Thread.sleep(10500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        userId = UsersGroups.getUserID((String)"user");
        Assert.assertEquals((long)0L, (long)userId);
        Assert.assertNull((Object)UsersGroups.getGroups((String)"user"));
        UsersGroups.addUserToGroupsTx((String)"user", (String[])new String[]{"group1", "group2"});
        userId = UsersGroups.getUserID((String)"user");
        Assert.assertNotSame((Object)0, (Object)userId);
        Assert.assertThat((Object)UsersGroups.getGroups((String)"user"), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"group1", "group2"}));
        this.removeUser(userId);
        UsersGroups.addUserToGroupsTx((String)"user", (String[])new String[]{"group3"});
        int newUserId = UsersGroups.getUserID((String)"user");
        Assert.assertNotSame((Object)0, (Object)userId);
        Assert.assertNotSame((Object)userId, (Object)newUserId);
        UsersGroups.addUserToGroupsTx((String)"user", (String[])new String[]{"group1", "group2"});
        Assert.assertThat((Object)UsersGroups.getGroups((String)"user"), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"group1", "group2", "group3"}));
    }

    @Test
    public void testGroupMappingsRefresh() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        cluster.waitActive();
        cluster.getNameNode().getRpcServer().refreshUserToGroupsMappings();
        UsersGroups.addUserToGroupsTx((String)"user", (String[])new String[]{"group1", "group2"});
        int userId = UsersGroups.getUserID((String)"user");
        Assert.assertNotSame((Object)0, (Object)userId);
        Assert.assertEquals((Object)UsersGroups.getUser((int)userId), (Object)"user");
        int groupId = UsersGroups.getGroupID((String)"group1");
        Assert.assertNotSame((Object)0, (Object)groupId);
        Assert.assertEquals((Object)UsersGroups.getGroup((int)groupId), (Object)"group1");
        Assert.assertThat((Object)UsersGroups.getGroups((String)"user"), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"group1", "group2"}));
        this.removeUser(userId);
        userId = UsersGroups.getUserID((String)"user");
        Assert.assertNotSame((Object)0, (Object)userId);
        cluster.getNameNode().getRpcServer().refreshUserToGroupsMappings();
        userId = UsersGroups.getUserID((String)"user");
        Assert.assertEquals((long)0L, (long)userId);
        Assert.assertNull((Object)UsersGroups.getGroups((String)"user"));
        UsersGroups.addUserToGroupsTx((String)"user", (String[])new String[]{"group1", "group2"});
        userId = UsersGroups.getUserID((String)"user");
        Assert.assertNotSame((Object)0, (Object)userId);
        Assert.assertThat((Object)UsersGroups.getGroups((String)"user"), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"group1", "group2"}));
        this.removeUser(userId);
        UsersGroups.addUserToGroupsTx((String)"user", (String[])new String[]{"group3"});
        int newUserId = UsersGroups.getUserID((String)"user");
        Assert.assertNotSame((Object)0, (Object)userId);
        Assert.assertTrue((newUserId > userId ? 1 : 0) != 0);
        UsersGroups.addUserToGroupsTx((String)"user", (String[])new String[]{"group1", "group2"});
        Assert.assertThat((Object)UsersGroups.getGroups((String)"user"), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"group1", "group2", "group3"}));
        cluster.shutdown();
    }

    @Test
    public void setOwnerMultipleTimes() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        String userName = UserGroupInformation.getCurrentUser().getShortUserName();
        conf.set(String.format("hadoop.proxyuser.%s.hosts", userName), "*");
        conf.set(String.format("hadoop.proxyuser.%s.users", userName), "*");
        conf.set(String.format("hadoop.proxyuser.%s.groups", userName), "*");
        final MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        cluster.waitActive();
        DistributedFileSystem dfs = cluster.getFileSystem();
        Path base = new Path("/projects/project1");
        dfs.mkdirs(base);
        Path child = new Path(base, "dataset");
        dfs.mkdirs(child);
        dfs.setOwner(base, "testUser", "testGroup");
        this.removeGroup(UsersGroups.getGroupID((String)"testGroup"));
        UserGroupInformation ugi = UserGroupInformation.createProxyUserForTesting((String)"testUser", (UserGroupInformation)UserGroupInformation.getLoginUser(), (String[])new String[]{"testGroup"});
        FileSystem fs = (FileSystem)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

            @Override
            public FileSystem run() throws Exception {
                return cluster.getFileSystem();
            }
        });
        fs.mkdirs(new Path(base, "testdir"));
        dfs.setOwner(base, "testUser", "testGroup");
        cluster.shutdown();
    }

    private void removeUser(final int userId) throws IOException {
        new LightWeightRequestHandler((RequestHandler.OperationType)HDFSOperationType.TEST){

            public Object performTask() throws IOException {
                UserDataAccess da = (UserDataAccess)HdfsStorageFactory.getDataAccess(UserDataAccess.class);
                da.removeUser(userId);
                return null;
            }
        }.handle();
    }

    private void removeGroup(final int groupId) throws IOException {
        new LightWeightRequestHandler((RequestHandler.OperationType)HDFSOperationType.TEST){

            public Object performTask() throws IOException {
                GroupDataAccess da = (GroupDataAccess)HdfsStorageFactory.getDataAccess(GroupDataAccess.class);
                da.removeGroup(groupId);
                return null;
            }
        }.handle();
    }

    @Test
    public void testUserNameAndGroupNameCaseSensitivity() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        cluster.waitActive();
        DistributedFileSystem dfs = cluster.getFileSystem();
        Path base = new Path("/projects/project1");
        dfs.mkdirs(base);
        Path child = new Path(base, "dataset");
        dfs.mkdirs(child);
        dfs.setOwner(base, "testUser", "testGroup");
        FileStatus fileStatus = dfs.getFileStatus(base);
        Assert.assertTrue((boolean)fileStatus.getOwner().equals("testUser"));
        Assert.assertTrue((boolean)fileStatus.getGroup().equals("testGroup"));
        dfs.setOwner(base, "testuser", "testgroup");
        fileStatus = dfs.getFileStatus(base);
        Assert.assertTrue((boolean)fileStatus.getOwner().equals("testuser"));
        Assert.assertTrue((boolean)fileStatus.getGroup().equals("testgroup"));
        cluster.getNameNode().getRpcServer().refreshUserToGroupsMappings();
        Assert.assertTrue((UsersGroups.getUserID((String)"testUser") != 0 ? 1 : 0) != 0);
        Assert.assertTrue((UsersGroups.getUserID((String)"testuser") != 0 ? 1 : 0) != 0);
        Assert.assertNotEquals((long)UsersGroups.getUserID((String)"testUser"), (long)UsersGroups.getUserID((String)"testuser"));
        Assert.assertTrue((UsersGroups.getGroupID((String)"testGroup") != 0 ? 1 : 0) != 0);
        Assert.assertTrue((UsersGroups.getGroupID((String)"testgroup") != 0 ? 1 : 0) != 0);
        Assert.assertNotEquals((long)UsersGroups.getGroupID((String)"testGroup"), (long)UsersGroups.getGroupID((String)"testgroup"));
        cluster.shutdown();
    }

    @Test
    public void testConcurrentAddUser() throws Exception {
        Configuration conf = new Configuration();
        HdfsStorageFactory.resetDALInitialized();
        HdfsStorageFactory.setConfiguration((Configuration)conf);
        HdfsStorageFactory.formatStorage();
        String userName = "user1";
        int CONCURRENT_USERS = 100;
        ExecutorService executorService = Executors.newFixedThreadPool(100);
        ArrayList<AddUser> callables = new ArrayList<AddUser>();
        for (int i = 0; i < 100; ++i) {
            callables.add(new AddUser(false, "user1"));
        }
        List futures = executorService.invokeAll(callables);
        executorService.shutdown();
        executorService.awaitTermination(1L, TimeUnit.SECONDS);
        UsersGroups.clearCache();
        Integer userId = UsersGroups.getUserID((String)"user1");
        int success = 0;
        int failure = 0;
        for (Future f : futures) {
            try {
                Integer otherUserId = (Integer)f.get();
                Assert.assertNotEquals((Object)otherUserId, (Object)0);
                Assert.assertEquals((Object)otherUserId, (Object)userId);
                ++success;
            }
            catch (ExecutionException ex) {
                if (ex.getCause() instanceof UniqueKeyConstraintViolationException) {
                    ++failure;
                    continue;
                }
                Assert.fail();
            }
        }
        Assert.assertTrue((success >= 1 ? 1 : 0) != 0);
        Assert.assertTrue((failure == 100 - success ? 1 : 0) != 0);
    }

    @Test
    public void testConcurrentAddUserTx() throws Exception {
        Configuration conf = new Configuration();
        HdfsStorageFactory.resetDALInitialized();
        HdfsStorageFactory.setConfiguration((Configuration)conf);
        HdfsStorageFactory.formatStorage();
        String userName = "user1";
        int CONCURRENT_USERS = 100;
        ExecutorService executorService = Executors.newFixedThreadPool(100);
        ArrayList<AddUser> callables = new ArrayList<AddUser>();
        for (int i = 0; i < 100; ++i) {
            callables.add(new AddUser(true, "user1"));
        }
        List futures = executorService.invokeAll(callables);
        executorService.shutdown();
        executorService.awaitTermination(1L, TimeUnit.SECONDS);
        UsersGroups.clearCache();
        Integer userId = UsersGroups.getUserID((String)"user1");
        for (Future f : futures) {
            Integer otherUserId = (Integer)f.get();
            Assert.assertNotEquals((Object)otherUserId, (Object)0);
            Assert.assertEquals((Object)otherUserId, (Object)userId);
        }
    }

    @Test
    public void testConcurrentSetSameOwner() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        cluster.waitActive();
        DistributedFileSystem dfs = cluster.getFileSystem();
        Path base = new Path("/base");
        dfs.mkdirs(base);
        String userName = "user";
        String groupName = "group";
        int CONCURRENT_USERS = 100;
        ExecutorService executorService = Executors.newFixedThreadPool(100);
        ArrayList<SetOwner> callables = new ArrayList<SetOwner>();
        for (int i = 0; i < 100; ++i) {
            Path file = new Path(base, "file" + i);
            dfs.create(file).close();
            callables.add(new SetOwner(dfs, file, "user", "group"));
        }
        List futures = executorService.invokeAll(callables);
        executorService.shutdown();
        executorService.awaitTermination(1L, TimeUnit.SECONDS);
        for (Future f : futures) {
            Assert.assertTrue((boolean)((Boolean)f.get()));
        }
        cluster.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetOwnerOnOutdatedCache() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        try {
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path base = new Path("/base");
            dfs.mkdirs(base);
            String username = "user";
            String groupname = "group";
            String newgroupname = "newgroup";
            dfs.setOwner(base, "user", "group");
            FileStatus fileStatus = dfs.getFileStatus(base);
            Assert.assertEquals((Object)"user", (Object)fileStatus.getOwner());
            Assert.assertEquals((Object)"group", (Object)fileStatus.getGroup());
            int userId = UsersGroups.getUserID((String)"user");
            this.removeUser(userId);
            dfs.setOwner(base, "user", "newgroup");
            fileStatus = dfs.getFileStatus(base);
            Assert.assertEquals((Object)"user", (Object)fileStatus.getOwner());
            Assert.assertEquals((Object)"newgroup", (Object)fileStatus.getGroup());
            int newUserId = UsersGroups.getUserID((String)"user");
            Assert.assertTrue((newUserId > userId ? 1 : 0) != 0);
            Assert.assertNotEquals((long)userId, (long)newUserId);
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test
    public void testSuperUserCheck() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        String userName = UserGroupInformation.getCurrentUser().getShortUserName();
        conf.set(String.format("hadoop.proxyuser.%s.hosts", userName), "*");
        conf.set(String.format("hadoop.proxyuser.%s.users", userName), "*");
        conf.set(String.format("hadoop.proxyuser.%s.groups", userName), "*");
        final MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        cluster.waitActive();
        String user = "testUser";
        DistributedFileSystem dfs = cluster.getFileSystem();
        dfs.addUser(user);
        UserGroupInformation ugi = UserGroupInformation.createProxyUserForTesting((String)user, (UserGroupInformation)UserGroupInformation.getLoginUser(), (String[])new String[0]);
        DistributedFileSystem dfsTestUser = (DistributedFileSystem)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

            @Override
            public FileSystem run() throws Exception {
                return cluster.getFileSystem();
            }
        });
        try {
            dfsTestUser.addUser("user");
            Assert.fail();
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        try {
            dfsTestUser.addGroup("group");
            Assert.fail();
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        try {
            dfsTestUser.addUserToGroup("user", "group");
            Assert.fail();
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        try {
            dfsTestUser.removeUser("user");
            Assert.fail();
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        try {
            dfsTestUser.removeGroup("group");
            Assert.fail();
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        try {
            dfsTestUser.removeUserFromGroup("user", "group");
            Assert.fail();
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    private class SetOwner
    implements Callable<Boolean> {
        private final DistributedFileSystem dfs;
        private final Path path;
        private final String userName;
        private final String groupName;

        SetOwner(DistributedFileSystem dfs, Path path, String userName, String groupName) {
            this.dfs = dfs;
            this.path = path;
            this.userName = userName;
            this.groupName = groupName;
        }

        @Override
        public Boolean call() throws Exception {
            this.dfs.setOwner(this.path, this.userName, this.groupName);
            FileStatus fileStatus = this.dfs.getFileStatus(this.path);
            if (this.userName != null) {
                Assert.assertEquals((Object)this.userName, (Object)fileStatus.getOwner());
            }
            if (this.groupName != null) {
                Assert.assertEquals((Object)this.groupName, (Object)fileStatus.getGroup());
            }
            return true;
        }
    }

    private class AddUser
    implements Callable<Integer> {
        private final boolean useTransaction;
        private final String userName;

        AddUser(boolean useTransaction, String userName) {
            this.useTransaction = useTransaction;
            this.userName = userName;
        }

        @Override
        public Integer call() throws Exception {
            if (this.useTransaction) {
                UsersGroups.addUserToGroupsTx((String)this.userName, null);
            } else {
                UsersGroups.addUserToGroups((String)this.userName, null);
            }
            return UsersGroups.getUserID((String)this.userName);
        }
    }
}

