/*
 * Decompiled with CFR 0.152.
 */
package io.hops.security;

import io.hops.leader_election.node.SortedActiveNodeList;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.hdfs.entity.EncodingPolicy;
import io.hops.metadata.hdfs.entity.EncodingStatus;
import io.hops.security.TestUsersGroups;
import io.hops.security.UsersGroupsCache;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BatchedRemoteIterator;
import org.apache.hadoop.fs.CacheFlag;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSClientAdapter;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.protocol.AlreadyBeingCreatedException;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveEntry;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.CachePoolEntry;
import org.apache.hadoop.hdfs.protocol.CachePoolInfo;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.CorruptFileBlocks;
import org.apache.hadoop.hdfs.protocol.DSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LastUpdatedContentSummary;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.NSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeInfo;
import org.apache.hadoop.hdfs.security.token.block.DataEncryptionKey;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.namenode.NotReplicatedYetException;
import org.apache.hadoop.hdfs.server.namenode.SafeModeException;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorageReport;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.token.Token;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class TestUsersGroupsMultiNamenode {
    @Test
    public void testMultiNamenode() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        HdfsStorageFactory.setConfiguration((Configuration)conf);
        HdfsStorageFactory.formatStorage();
        ArrayList<ClientProtocol> namenodes = new ArrayList<ClientProtocol>();
        ClientProtocolMock nn1 = new ClientProtocolMock(1, TestUsersGroups.newUsersGroupsMapping((Configuration)conf));
        namenodes.add(nn1);
        ClientProtocolMock nn2 = new ClientProtocolMock(2, TestUsersGroups.newUsersGroupsMapping((Configuration)conf));
        namenodes.add(nn2);
        ClientProtocolMock nn3 = new ClientProtocolMock(3, TestUsersGroups.newUsersGroupsMapping((Configuration)conf));
        namenodes.add(nn3);
        DistributedFileSystem dfs1 = DFSClientAdapter.newDistributedFileSystem((Configuration)conf, nn1, namenodes);
        DistributedFileSystem dfs2 = DFSClientAdapter.newDistributedFileSystem((Configuration)conf, nn2, namenodes);
        DistributedFileSystem dfs3 = DFSClientAdapter.newDistributedFileSystem((Configuration)conf, nn3, namenodes);
        String user1 = "user1";
        dfs1.addUser(user1);
        Assert.assertFalse((boolean)nn1.cacheOnly);
        Assert.assertNull((Object)nn2.cacheOnly);
        Assert.assertNull((Object)nn3.cacheOnly);
        Integer user1Id = nn1.usersGroupsMapping.getUserIdFromCache(user1);
        Assert.assertNotNull((Object)user1Id);
        Assert.assertNotSame((Object)0, (Object)user1Id);
        Assert.assertNull((Object)nn2.usersGroupsMapping.getUserIdFromCache(user1));
        Assert.assertNull((Object)nn3.usersGroupsMapping.getUserIdFromCache(user1));
        Assert.assertEquals((long)user1Id.intValue(), (long)nn2.usersGroupsMapping.getUserId(user1));
        Assert.assertEquals((long)user1Id.intValue(), (long)nn3.usersGroupsMapping.getUserId(user1));
        nn1.reset();
        nn2.reset();
        nn3.reset();
        String group1 = "group1";
        dfs1.addGroup(group1);
        Assert.assertFalse((boolean)nn1.cacheOnly);
        Assert.assertNull((Object)nn2.cacheOnly);
        Assert.assertNull((Object)nn3.cacheOnly);
        Integer group1Id = nn1.usersGroupsMapping.getGroupIdFromCache(group1);
        Assert.assertNotNull((Object)group1Id);
        Assert.assertNotSame((Object)0, (Object)group1Id);
        Assert.assertNull((Object)nn2.usersGroupsMapping.getGroupIdFromCache(group1));
        Assert.assertNull((Object)nn3.usersGroupsMapping.getGroupIdFromCache(group1));
        Assert.assertEquals((long)group1Id.intValue(), (long)nn2.usersGroupsMapping.getGroupId(group1));
        Assert.assertEquals((long)group1Id.intValue(), (long)nn3.usersGroupsMapping.getGroupId(group1));
        nn1.reset();
        nn2.reset();
        nn3.reset();
        dfs2.addUserToGroup(user1, group1);
        Assert.assertTrue((boolean)nn1.cacheOnly);
        Assert.assertFalse((boolean)nn2.cacheOnly);
        Assert.assertTrue((boolean)nn3.cacheOnly);
        List groups = nn2.usersGroupsMapping.getGroupsFromCache(user1);
        Assert.assertNotNull((Object)groups);
        Assert.assertEquals(Arrays.asList(group1), (Object)groups);
        Assert.assertNotNull((Object)nn1.usersGroupsMapping.getGroupsFromCache(user1));
        Assert.assertNotNull((Object)nn3.usersGroupsMapping.getGroupsFromCache(user1));
        Assert.assertEquals(Arrays.asList(group1), (Object)nn1.usersGroupsMapping.getGroupsFromCache(user1));
        Assert.assertEquals(Arrays.asList(group1), (Object)nn3.usersGroupsMapping.getGroupsFromCache(user1));
        nn1.reset();
        nn2.reset();
        nn3.reset();
        String group2 = "group2";
        dfs3.addUserToGroup(user1, group2);
        Assert.assertTrue((boolean)nn1.cacheOnly);
        Assert.assertTrue((boolean)nn2.cacheOnly);
        Assert.assertFalse((boolean)nn3.cacheOnly);
        groups = nn3.usersGroupsMapping.getGroupsFromCache(user1);
        Assert.assertNotNull((Object)groups);
        Assert.assertThat((Object)groups, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{group1, group2}));
        Assert.assertThat((Object)nn1.usersGroupsMapping.getGroupsFromCache(user1), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{group1, group2}));
        Assert.assertThat((Object)nn2.usersGroupsMapping.getGroupsFromCache(user1), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{group1, group2}));
        Integer group2Id = nn3.usersGroupsMapping.getGroupIdFromCache(group2);
        Assert.assertNotNull((Object)group2Id);
        Assert.assertNotSame((Object)0, (Object)group2Id);
        Assert.assertNull((Object)nn1.usersGroupsMapping.getGroupIdFromCache(group2));
        Assert.assertNull((Object)nn2.usersGroupsMapping.getGroupIdFromCache(group2));
        Assert.assertEquals((long)nn1.usersGroupsMapping.getGroupId(group2), (long)group2Id.intValue());
        Assert.assertEquals((long)nn2.usersGroupsMapping.getGroupId(group2), (long)group2Id.intValue());
        nn1.reset();
        nn2.reset();
        nn3.reset();
        dfs1.removeUserFromGroup(user1, group2);
        Assert.assertFalse((boolean)nn1.cacheOnly);
        Assert.assertTrue((boolean)nn2.cacheOnly);
        Assert.assertTrue((boolean)nn3.cacheOnly);
        groups = nn1.usersGroupsMapping.getGroupsFromCache(user1);
        Assert.assertNotNull((Object)groups);
        Assert.assertEquals(Arrays.asList(group1), (Object)groups);
        Assert.assertEquals(Arrays.asList(group1), (Object)nn2.usersGroupsMapping.getGroupsFromCache(user1));
        Assert.assertEquals(Arrays.asList(group1), (Object)nn3.usersGroupsMapping.getGroupsFromCache(user1));
        Assert.assertEquals((Object)group2Id, (Object)nn1.usersGroupsMapping.getGroupIdFromCache(group2));
        Assert.assertEquals((Object)group2Id, (Object)nn2.usersGroupsMapping.getGroupIdFromCache(group2));
        Assert.assertEquals((Object)group2Id, (Object)nn3.usersGroupsMapping.getGroupIdFromCache(group2));
        nn1.reset();
        nn2.reset();
        nn3.reset();
        dfs2.removeGroup(group1);
        Assert.assertTrue((boolean)nn1.cacheOnly);
        Assert.assertFalse((boolean)nn2.cacheOnly);
        Assert.assertTrue((boolean)nn3.cacheOnly);
        Assert.assertNull((Object)nn1.usersGroupsMapping.getGroupIdFromCache(group1));
        Assert.assertNull((Object)nn2.usersGroupsMapping.getGroupIdFromCache(group1));
        Assert.assertNull((Object)nn3.usersGroupsMapping.getGroupIdFromCache(group1));
        Assert.assertEquals((long)0L, (long)nn1.usersGroupsMapping.getGroupId(group1));
        Assert.assertEquals((long)0L, (long)nn2.usersGroupsMapping.getGroupId(group1));
        Assert.assertEquals((long)0L, (long)nn3.usersGroupsMapping.getGroupId(group1));
        Assert.assertNull((Object)nn1.usersGroupsMapping.getGroupsFromCache(user1));
        Assert.assertNull((Object)nn2.usersGroupsMapping.getGroupsFromCache(user1));
        Assert.assertNull((Object)nn3.usersGroupsMapping.getGroupsFromCache(user1));
        Assert.assertNull((Object)nn1.usersGroupsMapping.getGroups(user1));
        Assert.assertNull((Object)nn2.usersGroupsMapping.getGroups(user1));
        Assert.assertNull((Object)nn3.usersGroupsMapping.getGroups(user1));
        nn1.reset();
        nn2.reset();
        nn3.reset();
        dfs3.addUserToGroup(user1, group2);
        Assert.assertTrue((boolean)nn1.cacheOnly);
        Assert.assertTrue((boolean)nn2.cacheOnly);
        Assert.assertFalse((boolean)nn3.cacheOnly);
        Assert.assertEquals(Arrays.asList(group2), (Object)nn1.usersGroupsMapping.getGroupsFromCache(user1));
        Assert.assertEquals(Arrays.asList(group2), (Object)nn2.usersGroupsMapping.getGroupsFromCache(user1));
        Assert.assertEquals(Arrays.asList(group2), (Object)nn3.usersGroupsMapping.getGroupsFromCache(user1));
        nn1.reset();
        nn2.reset();
        nn3.reset();
        dfs1.removeUser(user1);
        Assert.assertFalse((boolean)nn1.cacheOnly);
        Assert.assertTrue((boolean)nn2.cacheOnly);
        Assert.assertTrue((boolean)nn3.cacheOnly);
        Assert.assertNull((Object)nn1.usersGroupsMapping.getUserIdFromCache(user1));
        Assert.assertNull((Object)nn2.usersGroupsMapping.getUserIdFromCache(user1));
        Assert.assertNull((Object)nn3.usersGroupsMapping.getUserIdFromCache(user1));
        Assert.assertEquals((long)0L, (long)nn1.usersGroupsMapping.getUserId(user1));
        Assert.assertEquals((long)0L, (long)nn2.usersGroupsMapping.getUserId(user1));
        Assert.assertEquals((long)0L, (long)nn3.usersGroupsMapping.getUserId(user1));
        Assert.assertNull((Object)nn1.usersGroupsMapping.getGroupsFromCache(user1));
        Assert.assertNull((Object)nn2.usersGroupsMapping.getGroupsFromCache(user1));
        Assert.assertNull((Object)nn3.usersGroupsMapping.getGroupsFromCache(user1));
        Assert.assertNull((Object)nn1.usersGroupsMapping.getGroups(user1));
        Assert.assertNull((Object)nn2.usersGroupsMapping.getGroups(user1));
        Assert.assertNull((Object)nn3.usersGroupsMapping.getGroups(user1));
        nn1.reset();
        nn2.reset();
        nn3.reset();
    }

    private class ClientProtocolMock
    implements ClientProtocol {
        private final int id;
        private final UsersGroupsCache usersGroupsMapping;
        private Boolean cacheOnly = null;

        public ClientProtocolMock(int id, UsersGroupsCache usersGroupsMapping) {
            this.id = id;
            this.usersGroupsMapping = usersGroupsMapping;
        }

        public LocatedBlocks getBlockLocations(String src, long offset, long length) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
            return null;
        }

        public LocatedBlocks getMissingBlockLocations(String filePath) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
            return null;
        }

        public void addBlockChecksum(String src, int blockIndex, long checksum) throws IOException {
        }

        public long getBlockChecksum(String src, int blockIndex) throws IOException {
            return 0L;
        }

        public FsServerDefaults getServerDefaults() throws IOException {
            return null;
        }

        public HdfsFileStatus create(String src, FsPermission masked, String clientName, EnumSetWritable<CreateFlag> flag, boolean createParent, short replication, long blockSize, EncodingPolicy policy) throws AccessControlException, AlreadyBeingCreatedException, DSQuotaExceededException, FileAlreadyExistsException, FileNotFoundException, NSQuotaExceededException, ParentNotDirectoryException, SafeModeException, UnresolvedLinkException, IOException {
            return null;
        }

        public HdfsFileStatus create(String src, FsPermission masked, String clientName, EnumSetWritable<CreateFlag> flag, boolean createParent, short replication, long blockSize) throws AccessControlException, AlreadyBeingCreatedException, DSQuotaExceededException, FileAlreadyExistsException, FileNotFoundException, NSQuotaExceededException, ParentNotDirectoryException, SafeModeException, UnresolvedLinkException, IOException {
            return null;
        }

        public LocatedBlock append(String src, String clientName) throws AccessControlException, DSQuotaExceededException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException {
            return null;
        }

        public boolean setReplication(String src, short replication) throws AccessControlException, DSQuotaExceededException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException {
            return false;
        }

        public BlockStoragePolicy getStoragePolicy(byte storagePolicyID) throws IOException {
            return null;
        }

        public BlockStoragePolicy[] getStoragePolicies() throws IOException {
            return new BlockStoragePolicy[0];
        }

        public void setStoragePolicy(String src, String policyName) throws UnresolvedLinkException, FileNotFoundException, QuotaExceededException, IOException {
        }

        public void setMetaEnabled(String src, boolean metaEnabled) throws AccessControlException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException {
        }

        public void setPermission(String src, FsPermission permission) throws AccessControlException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException {
        }

        public void setOwner(String src, String username, String groupname) throws AccessControlException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException {
        }

        public void abandonBlock(ExtendedBlock b, long fileId, String src, String holder) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        }

        public LocatedBlock addBlock(String src, String clientName, ExtendedBlock previous, DatanodeInfo[] excludeNodes, long fileId, String[] favoredNodes) throws AccessControlException, FileNotFoundException, NotReplicatedYetException, SafeModeException, UnresolvedLinkException, IOException {
            return null;
        }

        public LocatedBlock getAdditionalDatanode(String src, long fileId, ExtendedBlock blk, DatanodeInfo[] existings, String[] existingStorageIDs, DatanodeInfo[] excludes, int numAdditionalNodes, String clientName) throws AccessControlException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException {
            return null;
        }

        public boolean complete(String src, String clientName, ExtendedBlock last, long fileId, byte[] data) throws AccessControlException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException {
            return false;
        }

        public void reportBadBlocks(LocatedBlock[] blocks) throws IOException {
        }

        public boolean rename(String src, String dst) throws UnresolvedLinkException, IOException {
            return false;
        }

        public void concat(String trg, String[] srcs) throws IOException, UnresolvedLinkException {
        }

        public void rename2(String src, String dst, Options.Rename ... options) throws AccessControlException, DSQuotaExceededException, FileAlreadyExistsException, FileNotFoundException, NSQuotaExceededException, ParentNotDirectoryException, SafeModeException, UnresolvedLinkException, IOException {
        }

        public boolean delete(String src, boolean recursive) throws AccessControlException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException {
            return false;
        }

        public boolean mkdirs(String src, FsPermission masked, boolean createParent) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, NSQuotaExceededException, ParentNotDirectoryException, SafeModeException, UnresolvedLinkException, IOException {
            return false;
        }

        public DirectoryListing getListing(String src, byte[] startAfter, boolean needLocation) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
            return null;
        }

        public void renewLease(String clientName) throws AccessControlException, IOException {
        }

        public boolean recoverLease(String src, String clientName) throws IOException {
            return false;
        }

        public long[] getStats() throws IOException {
            return new long[0];
        }

        public DatanodeInfo[] getDatanodeReport(HdfsConstants.DatanodeReportType type) throws IOException {
            return new DatanodeInfo[0];
        }

        public DatanodeStorageReport[] getDatanodeStorageReport(HdfsConstants.DatanodeReportType type) throws IOException {
            return new DatanodeStorageReport[0];
        }

        public long getPreferredBlockSize(String filename) throws IOException, UnresolvedLinkException {
            return 0L;
        }

        public boolean setSafeMode(HdfsConstants.SafeModeAction action, boolean isChecked) throws IOException {
            return false;
        }

        public void refreshNodes() throws IOException {
        }

        public RollingUpgradeInfo rollingUpgrade(HdfsConstants.RollingUpgradeAction action) throws IOException {
            return null;
        }

        public CorruptFileBlocks listCorruptFileBlocks(String path, String cookie) throws IOException {
            return null;
        }

        public void setBalancerBandwidth(long bandwidth) throws IOException {
        }

        public HdfsFileStatus getFileInfo(String src) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
            return null;
        }

        public boolean isFileClosed(String src) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
            return false;
        }

        public HdfsFileStatus getFileLinkInfo(String src) throws AccessControlException, UnresolvedLinkException, IOException {
            return null;
        }

        public ContentSummary getContentSummary(String path) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
            return null;
        }

        public void setQuota(String path, long namespaceQuota, long diskspaceQuota) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        }

        public void fsync(String src, long inodeId, String client, long lastBlockLength) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        }

        public void setTimes(String src, long mtime, long atime) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        }

        public void createSymlink(String target, String link, FsPermission dirPerm, boolean createParent) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, SafeModeException, UnresolvedLinkException, IOException {
        }

        public String getLinkTarget(String path) throws AccessControlException, FileNotFoundException, IOException {
            return null;
        }

        public LocatedBlock updateBlockForPipeline(ExtendedBlock block, String clientName) throws IOException {
            return null;
        }

        public void updatePipeline(String clientName, ExtendedBlock oldBlock, ExtendedBlock newBlock, DatanodeID[] newNodes, String[] newStorages) throws IOException {
        }

        public Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException {
            return null;
        }

        public long renewDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException {
            return 0L;
        }

        public void cancelDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException {
        }

        public DataEncryptionKey getDataEncryptionKey() throws IOException {
            return null;
        }

        public void ping() throws IOException {
        }

        public SortedActiveNodeList getActiveNamenodesForClient() throws IOException {
            return null;
        }

        public void changeConf(List<String> props, List<String> newVals) throws IOException {
        }

        public EncodingStatus getEncodingStatus(String filePath) throws IOException {
            return null;
        }

        public void encodeFile(String filePath, EncodingPolicy policy) throws IOException {
        }

        public void revokeEncoding(String filePath, short replication) throws IOException {
        }

        public LocatedBlock getRepairedBlockLocations(String sourcePath, String parityPath, LocatedBlock block, boolean isParity) throws IOException {
            return null;
        }

        public void checkAccess(String path, FsAction mode) throws IOException {
        }

        public LastUpdatedContentSummary getLastUpdatedContentSummary(String path) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
            return null;
        }

        public void modifyAclEntries(String src, List<AclEntry> aclSpec) throws IOException {
        }

        public void removeAclEntries(String src, List<AclEntry> aclSpec) throws IOException {
        }

        public void removeDefaultAcl(String src) throws IOException {
        }

        public void removeAcl(String src) throws IOException {
        }

        public void setAcl(String src, List<AclEntry> aclSpec) throws IOException {
        }

        public AclStatus getAclStatus(String src) throws IOException {
            return null;
        }

        public long addCacheDirective(CacheDirectiveInfo directive, EnumSet<CacheFlag> flags) throws IOException {
            return 0L;
        }

        public void modifyCacheDirective(CacheDirectiveInfo directive, EnumSet<CacheFlag> flags) throws IOException {
        }

        public void removeCacheDirective(long id) throws IOException {
        }

        public BatchedRemoteIterator.BatchedEntries<CacheDirectiveEntry> listCacheDirectives(long prevId, CacheDirectiveInfo filter) throws IOException {
            return null;
        }

        public void addCachePool(CachePoolInfo info) throws IOException {
        }

        public void modifyCachePool(CachePoolInfo req) throws IOException {
        }

        public void removeCachePool(String pool) throws IOException {
        }

        public BatchedRemoteIterator.BatchedEntries<CachePoolEntry> listCachePools(String prevPool) throws IOException {
            return null;
        }

        public void addUserGroup(String userName, String groupName, boolean cacheOnly) throws IOException {
            this.usersGroupsMapping.addUserToGroupTx(userName, groupName, cacheOnly);
            this.cacheOnly = cacheOnly;
        }

        public void removeUserGroup(String userName, String groupName, boolean cacheOnly) throws IOException {
            this.usersGroupsMapping.removeUserFromGroupTx(userName, groupName, cacheOnly);
            this.cacheOnly = cacheOnly;
        }

        void reset() {
            this.cacheOnly = null;
        }
    }
}

