/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction;

import io.hops.exception.StorageException;
import io.hops.exception.TransientStorageException;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.common.entity.Variable;
import io.hops.metadata.yarn.dal.util.YARNOperationType;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.handler.LightWeightRequestHandler;
import io.hops.transaction.handler.RequestHandler;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.After;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestTransaction {
    static MiniDFSCluster cluster;

    @BeforeClass
    public static void setupCluster() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.namenode.http-address", "0.0.0.0:0");
        conf.setBoolean("dfs.namenode.avoid.read.stale.datanode", true);
        conf.setBoolean("dfs.namenode.avoid.write.stale.datanode", true);
        conf.setInt("dfs.namenode.replication.interval", 10);
        cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).storagesPerDatanode(1).build();
        cluster.waitActive();
    }

    @After
    public void tearDown() {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Test
    public void testDB() throws IOException {
        HdfsStorageFactory.formatStorage();
        new HopsTransactionalRequestHandler(HDFSOperationType.CHOOSE_UNDER_REPLICATED_BLKS){
            final AtomicBoolean firstTime;
            {
                this.firstTime = new AtomicBoolean(true);
            }

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getVariableLock(Variable.Finder.ReplicationIndex, TransactionLockTypes.LockType.WRITE));
            }

            public Object performTask() throws StorageException, IOException {
                LightWeightRequestHandler setRMDTMasterKeyHandler = new LightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.TEST){

                    public Object performTask() throws IOException {
                        if (firstTime.getAndSet(false)) {
                            throw new TransientStorageException();
                        }
                        return null;
                    }
                };
                setRMDTMasterKeyHandler.handle();
                return null;
            }
        }.handle();
    }
}

