/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import java.io.IOException;
import java.net.BindException;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.net.DNS;
import org.junit.Assert;
import org.junit.Test;

public class TestHDFSServerPorts {
    public static final Log LOG = LogFactory.getLog(TestHDFSServerPorts.class);
    static final String THIS_HOST = TestHDFSServerPorts.getFullHostName() + ":0";
    Configuration config;
    File hdfsDir;

    public static String getFullHostName() {
        try {
            return DNS.getDefaultHost((String)"default");
        }
        catch (UnknownHostException e) {
            LOG.warn((Object)"Unable to determine hostname.  May interfere with obtaining valid test results.");
            return "127.0.0.1";
        }
    }

    private String getTestingDir() {
        return System.getProperty("test.build.data", "build/test/data");
    }

    public NameNode startNameNode() throws IOException {
        return this.startNameNode(false);
    }

    public NameNode startNameNode(boolean withService) throws IOException {
        String dataDir = this.getTestingDir();
        this.hdfsDir = new File(dataDir, "dfs");
        if (this.hdfsDir.exists() && !FileUtil.fullyDelete((File)this.hdfsDir)) {
            throw new IOException("Could not delete hdfs directory '" + this.hdfsDir + "'");
        }
        this.config = new HdfsConfiguration();
        FileSystem.setDefaultUri((Configuration)this.config, (String)("hdfs://" + THIS_HOST));
        if (withService) {
            NameNode.setServiceAddress((Configuration)this.config, (String)THIS_HOST);
        }
        this.config.set("dfs.namenode.http-address", THIS_HOST);
        DFSTestUtil.formatNameNode(this.config);
        String[] args = new String[]{};
        return NameNode.createNameNode((String[])args, (Configuration)this.config);
    }

    public DataNode startDataNode(int index, Configuration config) throws IOException {
        String dataDir = this.getTestingDir();
        File dataNodeDir = new File(dataDir, "data-" + index);
        config.set("dfs.datanode.data.dir", dataNodeDir.getPath());
        String[] args = new String[]{};
        return DataNode.createDataNode((String[])args, (Configuration)config);
    }

    public void stopDataNode(DataNode dn) {
        if (dn != null) {
            dn.shutdown();
        }
    }

    public void stopNameNode(NameNode nn) {
        if (nn != null) {
            nn.stop();
        }
    }

    public Configuration getConfig() {
        return this.config;
    }

    private boolean canStartNameNode(Configuration conf) throws IOException {
        NameNode nn2 = null;
        try {
            nn2 = NameNode.createNameNode((String[])new String[0], (Configuration)conf);
        }
        catch (IOException e) {
            if (e instanceof BindException) {
                boolean bl = false;
                return bl;
            }
            throw e;
        }
        finally {
            this.stopNameNode(nn2);
        }
        return true;
    }

    private boolean canStartDataNode(Configuration conf) throws IOException {
        DataNode dn = null;
        try {
            dn = DataNode.createDataNode((String[])new String[0], (Configuration)conf);
        }
        catch (IOException e) {
            if (e instanceof BindException) {
                boolean bl = false;
                return bl;
            }
            throw e;
        }
        finally {
            if (dn != null) {
                dn.shutdown();
            }
        }
        return true;
    }

    @Test
    public void testNameNodePorts() throws Exception {
        this.runTestNameNodePorts(false);
        this.runTestNameNodePorts(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTestNameNodePorts(boolean withService) throws Exception {
        NameNode nn = null;
        try {
            nn = this.startNameNode(withService);
            HdfsConfiguration conf2 = new HdfsConfiguration(this.config);
            DFSTestUtil.formatNameNode((Configuration)conf2);
            boolean started = this.canStartNameNode((Configuration)conf2);
            Assert.assertFalse((boolean)started);
            FileSystem.setDefaultUri((Configuration)conf2, (String)("hdfs://" + THIS_HOST));
            started = this.canStartNameNode((Configuration)conf2);
            Assert.assertFalse((boolean)started);
            FileSystem.setDefaultUri((Configuration)conf2, (String)("hdfs://" + THIS_HOST));
            conf2.set("dfs.namenode.http-address", THIS_HOST);
            started = this.canStartNameNode((Configuration)conf2);
            if (withService) {
                Assert.assertFalse((String)"Should've failed on service port", (boolean)started);
                FileSystem.setDefaultUri((Configuration)conf2, (String)("hdfs://" + THIS_HOST));
                conf2.set("dfs.namenode.http-address", THIS_HOST);
                conf2.set("dfs.namenode.servicerpc-address", THIS_HOST);
                started = this.canStartNameNode((Configuration)conf2);
            }
            Assert.assertTrue((boolean)started);
        }
        finally {
            this.stopNameNode(nn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDataNodePorts() throws Exception {
        NameNode nn = null;
        try {
            nn = this.startNameNode();
            HdfsConfiguration conf2 = new HdfsConfiguration(this.config);
            conf2.set("dfs.datanode.data.dir", new File(this.hdfsDir, "data").getPath());
            conf2.set("dfs.datanode.address", FileSystem.getDefaultUri((Configuration)this.config).getAuthority());
            conf2.set("dfs.datanode.http.address", THIS_HOST);
            boolean started = this.canStartDataNode((Configuration)conf2);
            Assert.assertFalse((boolean)started);
            conf2.set("dfs.datanode.address", THIS_HOST);
            conf2.set("dfs.datanode.http.address", this.config.get("dfs.namenode.http-address"));
            started = this.canStartDataNode((Configuration)conf2);
            Assert.assertFalse((boolean)started);
            conf2.set("dfs.datanode.address", THIS_HOST);
            conf2.set("dfs.datanode.http.address", THIS_HOST);
            conf2.set("dfs.datanode.ipc.address", THIS_HOST);
            started = this.canStartDataNode((Configuration)conf2);
            Assert.assertTrue((boolean)started);
        }
        finally {
            this.stopNameNode(nn);
        }
    }

    static {
        DefaultMetricsSystem.setMiniClusterMode((boolean)true);
    }
}

