/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspWriter;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.server.common.JspHelper;
import org.apache.hadoop.hdfs.server.datanode.DatanodeJspHelper;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.util.ServletUtil;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestDatanodeJsp {
    private static final String FILE_DATA = "foo bar baz biz buz";
    private static final HdfsConfiguration CONF = new HdfsConfiguration();
    private static String viewFilePage;

    private static void testViewingFile(MiniDFSCluster cluster, String filePath) throws IOException {
        Path testPath;
        DistributedFileSystem fs = cluster.getFileSystem();
        if (!fs.exists(testPath = new Path(filePath))) {
            DFSTestUtil.writeFile((FileSystem)fs, testPath, FILE_DATA);
        }
        InetSocketAddress nnIpcAddress = cluster.getNameNode().getNameNodeAddress();
        InetSocketAddress nnHttpAddress = cluster.getNameNode().getHttpAddress();
        String base = JspHelper.Url.url((String)"http", (DatanodeID)cluster.getDataNodes().get(0).getDatanodeId());
        URL url = new URL(base + "/browseDirectory.jsp" + JspHelper.getUrlParam((String)"dir", (String)URLEncoder.encode(testPath.toString(), "UTF-8"), (boolean)true) + JspHelper.getUrlParam((String)"namenodeInfoPort", (String)Integer.toString(nnHttpAddress.getPort())) + JspHelper.getUrlParam((String)"nnaddr", (String)("localhost:" + nnIpcAddress.getPort())));
        viewFilePage = StringEscapeUtils.unescapeHtml((String)DFSTestUtil.urlGet(url));
        Assert.assertTrue((String)("page should show preview of file contents, got: " + viewFilePage), (boolean)viewFilePage.contains(FILE_DATA));
        Assert.assertTrue((String)"page should show link to download file", (boolean)viewFilePage.contains("/streamFile" + ServletUtil.encodePath((String)filePath) + "?nnaddr=localhost:" + nnIpcAddress.getPort()));
        String regex = "<a.+href=\"(.+?)\">Tail\\s*this\\s*file\\<\\/a\\>";
        TestDatanodeJsp.assertFileContents(regex, "Tail this File");
        regex = "<a.+href=\"(.+?)\">Go\\s*Back\\s*to\\s*File\\s*View\\<\\/a\\>";
        TestDatanodeJsp.assertFileContents(regex, "Go Back to File View");
        regex = "<a href=\"///" + nnHttpAddress.getHostName() + ":" + nnHttpAddress.getPort() + "/dfshealth.jsp\">Go back to DFS home</a>";
        Assert.assertTrue((String)"page should generate DFS home scheme without explicit scheme", (boolean)viewFilePage.contains(regex));
    }

    private static void assertFileContents(String regex, String text) throws IOException {
        Pattern compile = Pattern.compile(regex);
        Matcher matcher = compile.matcher(viewFilePage);
        if (matcher.find()) {
            String u = matcher.group(1);
            String urlString = u.startsWith("///") ? "http://" + u.substring(3) : u;
            viewFilePage = StringEscapeUtils.unescapeHtml((String)DFSTestUtil.urlGet(new URL(urlString)));
            Assert.assertTrue((String)"page should show preview of file contents", (boolean)viewFilePage.contains(FILE_DATA));
        } else {
            Assert.fail((String)(text + " hyperlink should be there in the page content : " + viewFilePage));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testViewFileJsp() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            String[] paths;
            cluster = new MiniDFSCluster.Builder((Configuration)CONF).build();
            cluster.waitActive();
            for (String p : paths = new String[]{"/test-file", "/tmp/test-file", "/tmp/test-file%with goofy&characters", "/foo bar/foo bar", "/foo+bar/foo+bar", "/foo;bar/foo;bar", "/foo=bar/foo=bar", "/foo,bar/foo,bar", "/foo?bar/foo?bar", "/foo\">bar/foo\">bar"}) {
                TestDatanodeJsp.testViewingFile(cluster, p);
                TestDatanodeJsp.testViewingFile(cluster, p);
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGenStamp() throws Exception {
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)CONF).numDataNodes(1).build();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            Path testFile = new Path("/test/mkdirs/TestchunkSizeToView");
            TestDatanodeJsp.writeFile((FileSystem)fs, testFile);
            JspWriter writerMock = (JspWriter)Mockito.mock(JspWriter.class);
            HttpServletRequest reqMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            this.setTheMockExpectationsFromReq(testFile, reqMock);
            DatanodeJspHelper.generateFileDetails((JspWriter)writerMock, (HttpServletRequest)reqMock, (Configuration)CONF);
            ((JspWriter)Mockito.verify((Object)writerMock, (VerificationMode)Mockito.atLeastOnce())).print("<input type=\"hidden\" name=\"genstamp\" value=\"987654321\">");
        }
        finally {
            cluster.shutdown();
        }
    }

    private void setTheMockExpectationsFromReq(Path testFile, HttpServletRequest reqMock) {
        ((HttpServletRequest)Mockito.doReturn((Object)"987654321").when((Object)reqMock)).getParameter("genstamp");
        ((HttpServletRequest)Mockito.doReturn((Object)"1234").when((Object)reqMock)).getParameter("blockId");
        ((HttpServletRequest)Mockito.doReturn((Object)"8081").when((Object)reqMock)).getParameter("datanodePort");
        ((HttpServletRequest)Mockito.doReturn((Object)"8080").when((Object)reqMock)).getParameter("namenodeInfoPort");
        ((HttpServletRequest)Mockito.doReturn((Object)"100").when((Object)reqMock)).getParameter("chunkSizeToView");
        ((HttpServletRequest)Mockito.doReturn((Object)"1").when((Object)reqMock)).getParameter("startOffset");
        ((HttpServletRequest)Mockito.doReturn((Object)"1024").when((Object)reqMock)).getParameter("blockSize");
        ((HttpServletRequest)Mockito.doReturn((Object)NetUtils.getHostPortString((InetSocketAddress)NameNode.getAddress((Configuration)CONF))).when((Object)reqMock)).getParameter("nnaddr");
        ((HttpServletRequest)Mockito.doReturn((Object)testFile.toString()).when((Object)reqMock)).getPathInfo();
        ((HttpServletRequest)Mockito.doReturn((Object)"http").when((Object)reqMock)).getScheme();
    }

    static Path writeFile(FileSystem fs, Path f) throws IOException {
        try (FSDataOutputStream out = fs.create(f);){
            out.writeBytes("umamahesh: " + f);
        }
        Assert.assertTrue((boolean)fs.exists(f));
        return f;
    }
}

