/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.collect.Lists;
import io.hops.exception.StorageException;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.lock.INodeLock;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.AclException;
import org.apache.hadoop.hdfs.protocol.FsAclPermission;
import org.apache.hadoop.hdfs.server.namenode.AclStorage;
import org.apache.hadoop.hdfs.server.namenode.AclTestHelpers;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class FSAclBaseTest {
    protected static MiniDFSCluster cluster;
    protected static FileSystem fs;
    protected static Configuration conf;
    private static int pathCount;
    private static Path path;

    @AfterClass
    public static void shutdown() throws Exception {
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{fs});
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Before
    public void setUp() throws Exception {
        fs = this.createFileSystem();
        path = new Path("/p" + ++pathCount);
    }

    protected FileSystem createFileSystem() throws Exception {
        return cluster.getFileSystem();
    }

    protected FileSystem createFileSystem(UserGroupInformation user) throws Exception {
        return DFSTestUtil.getFileSystemAs(user, cluster.getConfiguration(0));
    }

    @Test
    public void testModifyAclEntries() throws IOException {
        FileSystem.mkdirs((FileSystem)fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        fs.setAcl(path, (List)aclSpec);
        aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.READ_EXECUTE)});
        fs.modifyAclEntries(path, (List)aclSpec);
        AclStatus s = fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        FSAclBaseTest.assertPermission((short)4584);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testModifyAclEntriesOnlyAccess() throws IOException {
        fs.create(path).close();
        fs.setPermission(path, FsPermission.createImmutable((short)416));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)});
        fs.setAcl(path, (List)aclSpec);
        aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ_EXECUTE)});
        fs.modifyAclEntries(path, (List)aclSpec);
        AclStatus s = fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        FSAclBaseTest.assertPermission((short)4584);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testModifyAclEntriesOnlyDefault() throws IOException {
        FileSystem.mkdirs((FileSystem)fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        fs.setAcl(path, (List)aclSpec);
        aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.READ_EXECUTE)});
        fs.modifyAclEntries(path, (List)aclSpec);
        AclStatus s = fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        FSAclBaseTest.assertPermission((short)4584);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testModifyAclEntriesMinimal() throws IOException {
        fs.create(path).close();
        fs.setPermission(path, FsPermission.createImmutable((short)416));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ_WRITE)});
        fs.modifyAclEntries(path, (List)aclSpec);
        AclStatus s = fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)}, (Object[])returned);
        FSAclBaseTest.assertPermission((short)4528);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testModifyAclEntriesMinimalDefault() throws IOException {
        FileSystem.mkdirs((FileSystem)fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE)});
        fs.modifyAclEntries(path, (List)aclSpec);
        AclStatus s = fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        FSAclBaseTest.assertPermission((short)4584);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testModifyAclEntriesCustomMask() throws IOException {
        fs.create(path).close();
        fs.setPermission(path, FsPermission.createImmutable((short)416));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.NONE)});
        fs.modifyAclEntries(path, (List)aclSpec);
        AclStatus s = fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)}, (Object[])returned);
        FSAclBaseTest.assertPermission((short)4480);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testModifyAclEntriesStickyBit() throws IOException {
        FileSystem.mkdirs((FileSystem)fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)1000));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        fs.setAcl(path, (List)aclSpec);
        aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.READ_EXECUTE)});
        fs.modifyAclEntries(path, (List)aclSpec);
        AclStatus s = fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        FSAclBaseTest.assertPermission((short)5096);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test(expected=FileNotFoundException.class)
    public void testModifyAclEntriesPathNotFound() throws IOException {
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)});
        fs.modifyAclEntries(path, (List)aclSpec);
    }

    @Test(expected=AclException.class)
    public void testModifyAclEntriesDefaultOnFile() throws IOException {
        fs.create(path).close();
        fs.setPermission(path, FsPermission.createImmutable((short)416));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        fs.modifyAclEntries(path, (List)aclSpec);
    }

    @Test
    public void testRemoveAclEntries() throws IOException {
        FileSystem.mkdirs((FileSystem)fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        fs.setAcl(path, (List)aclSpec);
        aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo"), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo")});
        fs.removeAclEntries(path, (List)aclSpec);
        AclStatus s = fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        FSAclBaseTest.assertPermission((short)4584);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testRemoveAclEntriesOnlyAccess() throws IOException {
        fs.create(path).close();
        fs.setPermission(path, FsPermission.createImmutable((short)416));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bar", FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)});
        fs.setAcl(path, (List)aclSpec);
        aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo")});
        fs.removeAclEntries(path, (List)aclSpec);
        AclStatus s = fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bar", FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_WRITE)}, (Object[])returned);
        FSAclBaseTest.assertPermission((short)4592);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testRemoveAclEntriesOnlyDefault() throws IOException {
        FileSystem.mkdirs((FileSystem)fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "bar", FsAction.READ_EXECUTE)});
        fs.setAcl(path, (List)aclSpec);
        aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo")});
        fs.removeAclEntries(path, (List)aclSpec);
        AclStatus s = fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "bar", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        FSAclBaseTest.assertPermission((short)4584);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testRemoveAclEntriesMinimal() throws IOException {
        fs.create(path).close();
        fs.setPermission(path, FsPermission.createImmutable((short)496));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)});
        fs.setAcl(path, (List)aclSpec);
        aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo"), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK)});
        fs.removeAclEntries(path, (List)aclSpec);
        AclStatus s = fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        FSAclBaseTest.assertPermission((short)496);
        FSAclBaseTest.assertAclFeature(false);
    }

    @Test
    public void testRemoveAclEntriesMinimalDefault() throws IOException {
        FileSystem.mkdirs((FileSystem)fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        fs.setAcl(path, (List)aclSpec);
        aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo"), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo")});
        fs.removeAclEntries(path, (List)aclSpec);
        AclStatus s = fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        FSAclBaseTest.assertPermission((short)4584);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testRemoveAclEntriesStickyBit() throws IOException {
        FileSystem.mkdirs((FileSystem)fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)1000));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        fs.setAcl(path, (List)aclSpec);
        aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo"), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo")});
        fs.removeAclEntries(path, (List)aclSpec);
        AclStatus s = fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        FSAclBaseTest.assertPermission((short)5096);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test(expected=FileNotFoundException.class)
    public void testRemoveAclEntriesPathNotFound() throws IOException {
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo")});
        fs.removeAclEntries(path, (List)aclSpec);
    }

    @Test
    public void testRemoveDefaultAcl() throws IOException {
        FileSystem.mkdirs((FileSystem)fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        fs.setAcl(path, (List)aclSpec);
        fs.removeDefaultAcl(path);
        AclStatus s = fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        FSAclBaseTest.assertPermission((short)4600);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testRemoveDefaultAclOnlyAccess() throws IOException {
        fs.create(path).close();
        fs.setPermission(path, FsPermission.createImmutable((short)416));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)});
        fs.setAcl(path, (List)aclSpec);
        fs.removeDefaultAcl(path);
        AclStatus s = fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        FSAclBaseTest.assertPermission((short)4600);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testRemoveDefaultAclOnlyDefault() throws IOException {
        FileSystem.mkdirs((FileSystem)fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        fs.setAcl(path, (List)aclSpec);
        fs.removeDefaultAcl(path);
        AclStatus s = fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        FSAclBaseTest.assertPermission((short)488);
        FSAclBaseTest.assertAclFeature(false);
    }

    @Test
    public void testRemoveDefaultAclMinimal() throws IOException {
        FileSystem.mkdirs((FileSystem)fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        fs.removeDefaultAcl(path);
        AclStatus s = fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        FSAclBaseTest.assertPermission((short)488);
        FSAclBaseTest.assertAclFeature(false);
    }

    @Test
    public void testRemoveDefaultAclStickyBit() throws IOException {
        FileSystem.mkdirs((FileSystem)fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)1000));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        fs.setAcl(path, (List)aclSpec);
        fs.removeDefaultAcl(path);
        AclStatus s = fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        FSAclBaseTest.assertPermission((short)5112);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test(expected=FileNotFoundException.class)
    public void testRemoveDefaultAclPathNotFound() throws IOException {
        fs.removeDefaultAcl(path);
    }

    @Test
    public void testRemoveAcl() throws IOException {
        FileSystem.mkdirs((FileSystem)fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        fs.setAcl(path, (List)aclSpec);
        fs.removeAcl(path);
        AclStatus s = fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        FSAclBaseTest.assertPermission((short)488);
        FSAclBaseTest.assertAclFeature(false);
    }

    @Test
    public void testRemoveAclMinimalAcl() throws IOException {
        fs.create(path).close();
        fs.setPermission(path, FsPermission.createImmutable((short)416));
        fs.removeAcl(path);
        AclStatus s = fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        FSAclBaseTest.assertPermission((short)416);
        FSAclBaseTest.assertAclFeature(false);
    }

    @Test
    public void testRemoveAclStickyBit() throws IOException {
        FileSystem.mkdirs((FileSystem)fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)1000));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        fs.setAcl(path, (List)aclSpec);
        fs.removeAcl(path);
        AclStatus s = fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        FSAclBaseTest.assertPermission((short)1000);
        FSAclBaseTest.assertAclFeature(false);
    }

    @Test
    public void testRemoveAclOnlyDefault() throws IOException {
        FileSystem.mkdirs((FileSystem)fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        fs.setAcl(path, (List)aclSpec);
        fs.removeAcl(path);
        AclStatus s = fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        FSAclBaseTest.assertPermission((short)488);
        FSAclBaseTest.assertAclFeature(false);
    }

    @Test(expected=FileNotFoundException.class)
    public void testRemoveAclPathNotFound() throws IOException {
        fs.removeAcl(path);
    }

    @Test
    public void testSetAcl() throws IOException {
        FileSystem.mkdirs((FileSystem)fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        fs.setAcl(path, (List)aclSpec);
        AclStatus s = fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        FSAclBaseTest.assertPermission((short)4600);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testSetAclOnlyAccess() throws IOException {
        fs.create(path).close();
        fs.setPermission(path, FsPermission.createImmutable((short)416));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)});
        fs.setAcl(path, (List)aclSpec);
        AclStatus s = fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)}, (Object[])returned);
        FSAclBaseTest.assertPermission((short)4512);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testSetAclOnlyDefault() throws IOException {
        FileSystem.mkdirs((FileSystem)fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        fs.setAcl(path, (List)aclSpec);
        AclStatus s = fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        FSAclBaseTest.assertPermission((short)4584);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testSetAclMinimal() throws IOException {
        fs.create(path).close();
        fs.setPermission(path, FsPermission.createImmutable((short)420));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)});
        fs.setAcl(path, (List)aclSpec);
        aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)});
        fs.setAcl(path, (List)aclSpec);
        AclStatus s = fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        FSAclBaseTest.assertPermission((short)416);
        FSAclBaseTest.assertAclFeature(false);
    }

    @Test
    public void testSetAclMinimalDefault() throws IOException {
        FileSystem.mkdirs((FileSystem)fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE)});
        fs.setAcl(path, (List)aclSpec);
        AclStatus s = fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        FSAclBaseTest.assertPermission((short)4584);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testSetAclCustomMask() throws IOException {
        fs.create(path).close();
        fs.setPermission(path, FsPermission.createImmutable((short)416));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)});
        fs.setAcl(path, (List)aclSpec);
        AclStatus s = fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)}, (Object[])returned);
        FSAclBaseTest.assertPermission((short)4536);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testSetAclStickyBit() throws IOException {
        FileSystem.mkdirs((FileSystem)fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)1000));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        fs.setAcl(path, (List)aclSpec);
        AclStatus s = fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        FSAclBaseTest.assertPermission((short)5112);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test(expected=FileNotFoundException.class)
    public void testSetAclPathNotFound() throws IOException {
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)});
        fs.setAcl(path, (List)aclSpec);
    }

    @Test(expected=AclException.class)
    public void testSetAclDefaultOnFile() throws IOException {
        fs.create(path).close();
        fs.setPermission(path, FsPermission.createImmutable((short)416));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        fs.setAcl(path, (List)aclSpec);
    }

    @Test
    public void testSetPermission() throws IOException {
        FileSystem.mkdirs((FileSystem)fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        fs.setAcl(path, (List)aclSpec);
        fs.setPermission(path, FsPermission.createImmutable((short)448));
        AclStatus s = fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        FSAclBaseTest.assertPermission((short)4544);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testSetPermissionOnlyAccess() throws IOException {
        fs.create(path).close();
        fs.setPermission(path, FsPermission.createImmutable((short)416));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)});
        fs.setAcl(path, (List)aclSpec);
        fs.setPermission(path, FsPermission.createImmutable((short)384));
        AclStatus s = fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)}, (Object[])returned);
        FSAclBaseTest.assertPermission((short)4480);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testSetPermissionOnlyDefault() throws IOException {
        FileSystem.mkdirs((FileSystem)fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        fs.setAcl(path, (List)aclSpec);
        fs.setPermission(path, FsPermission.createImmutable((short)448));
        AclStatus s = fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        FSAclBaseTest.assertPermission((short)4544);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testSetPermissionCannotSetAclBit() throws IOException {
        FileSystem.mkdirs((FileSystem)fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        fs.setPermission(path, FsPermission.createImmutable((short)448));
        FSAclBaseTest.assertPermission((short)448);
        fs.setPermission(path, (FsPermission)new FsAclPermission(FsPermission.createImmutable((short)493)));
        INode inode = this.getInode();
        Assert.assertNotNull((Object)inode);
        FsPermission perm = inode.getFsPermission();
        Assert.assertNotNull((Object)perm);
        Assert.assertEquals((long)493L, (long)perm.toShort());
        Assert.assertEquals((long)493L, (long)perm.toExtendedShort());
        FSAclBaseTest.assertAclFeature(false);
    }

    private INode getInode() throws IOException {
        return (INode)new HopsTransactionalRequestHandler(HDFSOperationType.TEST){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, new String[]{path.toUri().getPath()}).setNameNodeID(cluster.getNameNode().getId()).setActiveNameNodes((Collection)cluster.getNameNode().getActiveNameNodes().getActiveNodes());
                locks.add((Lock)il).add(lf.getBlockLock());
            }

            public Object performTask() throws StorageException, IOException {
                return cluster.getNamesystem().getFSDirectory().getNode(path.toUri().getPath(), false);
            }
        }.handle();
    }

    @Test
    public void testDefaultAclNewFile() throws Exception {
        FileSystem.mkdirs((FileSystem)fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        fs.setAcl(path, (List)aclSpec);
        Path filePath = new Path(path, "file1");
        fs.create(filePath).close();
        AclStatus s = fs.getAclStatus(filePath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        FSAclBaseTest.assertPermission(filePath, (short)4516);
        FSAclBaseTest.assertAclFeature(filePath, true);
    }

    @Test
    public void testOnlyAccessAclNewFile() throws Exception {
        FileSystem.mkdirs((FileSystem)fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL)});
        fs.modifyAclEntries(path, (List)aclSpec);
        Path filePath = new Path(path, "file1");
        fs.create(filePath).close();
        AclStatus s = fs.getAclStatus(filePath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        FSAclBaseTest.assertPermission(filePath, (short)420);
        FSAclBaseTest.assertAclFeature(filePath, false);
    }

    @Test
    public void testDefaultMinimalAclNewFile() throws Exception {
        FileSystem.mkdirs((FileSystem)fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE)});
        fs.setAcl(path, (List)aclSpec);
        Path filePath = new Path(path, "file1");
        fs.create(filePath).close();
        AclStatus s = fs.getAclStatus(filePath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        FSAclBaseTest.assertPermission(filePath, (short)4516);
        FSAclBaseTest.assertAclFeature(filePath, true);
    }

    @Test
    public void testDefaultAclNewDir() throws Exception {
        FileSystem.mkdirs((FileSystem)fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        fs.setAcl(path, (List)aclSpec);
        Path dirPath = new Path(path, "dir1");
        fs.mkdirs(dirPath);
        AclStatus s = fs.getAclStatus(dirPath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        FSAclBaseTest.assertPermission(dirPath, (short)4589);
        FSAclBaseTest.assertAclFeature(dirPath, true);
    }

    @Test
    public void testOnlyAccessAclNewDir() throws Exception {
        FileSystem.mkdirs((FileSystem)fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL)});
        fs.modifyAclEntries(path, (List)aclSpec);
        Path dirPath = new Path(path, "dir1");
        fs.mkdirs(dirPath);
        AclStatus s = fs.getAclStatus(dirPath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        FSAclBaseTest.assertPermission(dirPath, (short)493);
        FSAclBaseTest.assertAclFeature(dirPath, false);
    }

    @Test
    public void testDefaultMinimalAclNewDir() throws Exception {
        FileSystem.mkdirs((FileSystem)fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE)});
        fs.setAcl(path, (List)aclSpec);
        Path dirPath = new Path(path, "dir1");
        fs.mkdirs(dirPath);
        System.out.println("AUSUGST: " + fs.getFileStatus(dirPath).getPermission());
        AclStatus s = fs.getAclStatus(dirPath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        FSAclBaseTest.assertPermission(dirPath, (short)4589);
        FSAclBaseTest.assertAclFeature(dirPath, true);
    }

    @Test
    public void testDefaultAclNewFileIntermediate() throws Exception {
        FileSystem.mkdirs((FileSystem)fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        fs.setAcl(path, (List)aclSpec);
        Path dirPath = new Path(path, "dir1");
        Path filePath = new Path(dirPath, "file1");
        fs.create(filePath).close();
        Object[] expected = new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)};
        AclStatus s = fs.getAclStatus(dirPath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])returned);
        FSAclBaseTest.assertPermission(dirPath, (short)4584);
        FSAclBaseTest.assertAclFeature(dirPath, true);
        expected = new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)};
        s = fs.getAclStatus(filePath);
        returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])returned);
        FSAclBaseTest.assertPermission(filePath, (short)4516);
        FSAclBaseTest.assertAclFeature(filePath, true);
    }

    @Test
    public void testDefaultAclNewDirIntermediate() throws Exception {
        FileSystem.mkdirs((FileSystem)fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        fs.setAcl(path, (List)aclSpec);
        Path dirPath = new Path(path, "dir1");
        Path subdirPath = new Path(dirPath, "subdir1");
        fs.mkdirs(subdirPath);
        Object[] expected = new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)};
        AclStatus s = fs.getAclStatus(dirPath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])returned);
        FSAclBaseTest.assertPermission(dirPath, (short)4589);
        FSAclBaseTest.assertAclFeature(dirPath, true);
        s = fs.getAclStatus(subdirPath);
        returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])returned);
        FSAclBaseTest.assertPermission(subdirPath, (short)4589);
        FSAclBaseTest.assertAclFeature(subdirPath, true);
    }

    public void testDefaultAclNewSymlinkIntermediate() throws Exception {
        FileSystem.mkdirs((FileSystem)fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        Path filePath = new Path(path, "file1");
        fs.create(filePath).close();
        fs.setPermission(filePath, FsPermission.createImmutable((short)416));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        fs.setAcl(path, (List)aclSpec);
        Path dirPath = new Path(path, "dir1");
        Path linkPath = new Path(dirPath, "link1");
        fs.createSymlink(filePath, linkPath, true);
        Object[] expected = new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)};
        AclStatus s = fs.getAclStatus(dirPath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])returned);
        FSAclBaseTest.assertPermission(dirPath, (short)488);
        FSAclBaseTest.assertAclFeature(dirPath, true);
        expected = new AclEntry[]{};
        s = fs.getAclStatus(linkPath);
        returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])returned);
        FSAclBaseTest.assertPermission(linkPath, (short)416);
        FSAclBaseTest.assertAclFeature(linkPath, false);
        s = fs.getAclStatus(filePath);
        returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])returned);
        FSAclBaseTest.assertPermission(filePath, (short)4512);
        FSAclBaseTest.assertAclFeature(filePath, false);
    }

    @Test
    public void testDefaultAclNewFileWithMode() throws Exception {
        FileSystem.mkdirs((FileSystem)fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)493));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        fs.setAcl(path, (List)aclSpec);
        Path filePath = new Path(path, "file1");
        int bufferSize = cluster.getConfiguration(0).getInt("io.file.buffer.size", 4096);
        fs.create(filePath, new FsPermission(480), false, bufferSize, fs.getDefaultReplication(filePath), fs.getDefaultBlockSize(path), null).close();
        AclStatus s = fs.getAclStatus(filePath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        FSAclBaseTest.assertPermission(filePath, (short)4576);
        FSAclBaseTest.assertAclFeature(filePath, true);
    }

    @Test
    public void testDefaultAclNewDirWithMode() throws Exception {
        FileSystem.mkdirs((FileSystem)fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)493));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        fs.setAcl(path, (List)aclSpec);
        Path dirPath = new Path(path, "dir1");
        fs.mkdirs(dirPath, new FsPermission(480));
        AclStatus s = fs.getAclStatus(dirPath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        FSAclBaseTest.assertPermission(dirPath, (short)4576);
        FSAclBaseTest.assertAclFeature(dirPath, true);
    }

    private static void assertAclFeature(boolean expectAclFeature) throws IOException {
        FSAclBaseTest.assertAclFeature(path, expectAclFeature);
    }

    private static void assertAclFeature(final Path pathToCheck, final boolean expectAclFeature) throws IOException {
        new HopsTransactionalRequestHandler(HDFSOperationType.TEST){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.READ, TransactionLockTypes.INodeResolveType.PATH, new String[]{pathToCheck.toString()}).setNameNodeID(cluster.getNameNode().getId()).setActiveNameNodes((Collection)cluster.getNameNode().getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(true);
                locks.add((Lock)il);
                locks.add(lf.getAcesLock());
            }

            public Object performTask() throws IOException {
                INode inode = cluster.getNamesystem().getINode(pathToCheck.toString());
                Assert.assertNotNull((Object)inode);
                List aclEntries = AclStorage.readINodeAcl((INode)inode);
                if (expectAclFeature) {
                    Assert.assertFalse((boolean)aclEntries.isEmpty());
                } else {
                    Assert.assertTrue((boolean)aclEntries.isEmpty());
                }
                return null;
            }
        }.handle();
    }

    private static void assertPermission(short perm) throws IOException {
        FSAclBaseTest.assertPermission(path, perm);
    }

    private static void assertPermission(Path pathToCheck, short perm) throws IOException {
        AclTestHelpers.assertPermission(fs, pathToCheck, perm);
    }

    static {
        pathCount = 0;
    }
}

