/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.lock;

import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.entity.CachedBlock;
import io.hops.metadata.hdfs.entity.CorruptReplica;
import io.hops.metadata.hdfs.entity.ExcessReplica;
import io.hops.metadata.hdfs.entity.InvalidatedBlock;
import io.hops.metadata.hdfs.entity.Replica;
import io.hops.metadata.hdfs.entity.UnderReplicatedBlock;
import io.hops.transaction.lock.BatchedINodeLock;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.LockWithType;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import org.apache.hadoop.hdfs.server.blockmanagement.PendingBlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.ReplicaUnderConstruction;

final class SqlBatchedBlocksRelatedLock
extends LockWithType {
    SqlBatchedBlocksRelatedLock(Lock.Type type) {
        super(type);
    }

    protected void acquire(TransactionLocks locks) throws IOException {
        Lock inodeLock = locks.getLock(Lock.Type.INode);
        if (!(inodeLock instanceof BatchedINodeLock)) {
            throw new TransactionLocks.LockNotAddedException("Batched Inode Lock wasn't added");
        }
        long[] inodeIds = ((BatchedINodeLock)inodeLock).getINodeIds();
        this.acquireLockList(DEFAULT_LOCK_TYPE, this.getFinderType(), new Object[]{inodeIds});
    }

    private FinderType getFinderType() {
        switch (this.getType()) {
            case Replica: {
                return Replica.Finder.ByINodeIds;
            }
            case CorruptReplica: {
                return CorruptReplica.Finder.ByINodeIds;
            }
            case ExcessReplica: {
                return ExcessReplica.Finder.ByINodeIds;
            }
            case ReplicaUnderConstruction: {
                return ReplicaUnderConstruction.Finder.ByINodeIds;
            }
            case InvalidatedBlock: {
                return InvalidatedBlock.Finder.ByINodeIds;
            }
            case UnderReplicatedBlock: {
                return UnderReplicatedBlock.Finder.ByINodeIds;
            }
            case PendingBlock: {
                return PendingBlockInfo.Finder.ByINodeIds;
            }
            case CachedBlock: {
                return CachedBlock.Finder.ByInodeIds;
            }
        }
        return null;
    }
}

